<?php
// Create a function for converting the amount in words
function numberTowords(float $amount)
{
   $amount_after_decimal = round($amount - ($num = floor($amount)), 2) * 100;
   // Check if there is any number after decimal
   $amt_hundred = null;
   $count_length = strlen($num);
   $x = 0;
   $string = array();
   $change_words = array(0 => '', 1 => 'One', 2 => 'Two',
     3 => 'Three', 4 => 'Four', 5 => 'Five', 6 => 'Six',
     7 => 'Seven', 8 => 'Eight', 9 => 'Nine',
     10 => 'Ten', 11 => 'Eleven', 12 => 'Twelve',
     13 => 'Thirteen', 14 => 'Fourteen', 15 => 'Fifteen',
     16 => 'Sixteen', 17 => 'Seventeen', 18 => 'Eighteen',
     19 => 'Nineteen', 20 => 'Twenty', 30 => 'Thirty',
     40 => 'Forty', 50 => 'Fifty', 60 => 'Sixty',
     70 => 'Seventy', 80 => 'Eighty', 90 => 'Ninety');
    $here_digits = array('', 'Hundred','Thousand','Lakh', 'Crore');
    while( $x < $count_length ) {
 $get_divider = ($x == 2) ? 10 : 100;
 $amount = floor($num % $get_divider);
 $num = floor($num / $get_divider);
 $x += $get_divider == 10 ? 1 : 2;
 if ($amount) {
 $add_plural = (($counter = count($string)) && $amount > 9) ? 's' : null;
 $amt_hundred = ($counter == 1 && $string[0]) ? ' and ' : null;
 $string [] = ($amount < 21) ? $change_words[$amount].' '. $here_digits[$counter]. $add_plural.' 
 '.$amt_hundred:$change_words[floor($amount / 10) * 10].' '.$change_words[$amount % 10]. ' 
 '.$here_digits[$counter].$add_plural.' '.$amt_hundred;
 }else $string[] = null;
 
   }
   $implode_to_Rupees = implode('', array_reverse($string));
   $get_paise = ($amount_after_decimal > 0) ? "And " . ($change_words[$amount_after_decimal / 10] . " 
   " . $change_words[$amount_after_decimal % 10]) . ' Paise' : '';
   return ($implode_to_Rupees ? $implode_to_Rupees . 'Rupees ' : '') . $get_paise;
}
 
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <title>How to convert number to words using php - XpertPhp</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
</head>
<body>
 
<div class="container">
  <h2>How to convert number to words using php</h2>
  <form method="post">
    <div class="form-group">
      <label for="txtNumber">Enter Your Numbers:</label>
      <input type="number" class="form-control" id="txtNumber" placeholder="Enter Your Numbers" name="txtNumber">
    </div>
    <button type="submit" class="btn btn-default">Convert</button><br/><br/>
 <?php
 if(isset($_POST['txtNumber'])){
 $num = $_POST['txtNumber'];
 $get_amount= numberTowords($num);
 echo "<p align='center'>".$get_amount."</p>";
 }
 ?>
  </form>
</div>
</body>
</html>