$(document).ready(function(){ 
	load_data();
	function load_data(query){
		$.ajax({
			url:"search.php",
			method:"post",
			data:{query:query},
			success:function(data)
			{
				$('#result').html(data);
				$('#customer_code').val('');  
				$('#customer_name').val('');
				$('#cust_address_one').val('');
				$('#cust_address_two').val('');
				$('#cust_address_three').val('');
				$('#action').text("Add");
			}
		});
	}	
	$('#search_text').keyup(function(){
		var search = $(this).val();
		if(search !== '')
		{
			load_data(search);
		}
		else
		{
			load_data();
		}
	});	
	$('#action').click(function(){
		var customer_code = $('#customer_code').val();  
		var customer_name = $('#customer_name').val();
		var cust_address_one = $('#cust_address_one').val();
		var cust_address_two = $('#cust_address_two').val();
		var cust_address_three = $('#cust_address_three').val();		   
		var id = $('#user_id').val();  
		var action = $('#action').text();
		$actiontext = $('#action').text();
		if(customer_code != '' && customer_name != '' && cust_address_one != '' && cust_address_two != '' && cust_address_three != '')  
		{  
			$.ajax({  
				url : "action.php",  
				method:"POST",  
				data:{customer_code:customer_code,customer_name:customer_name,cust_address_one:cust_address_one,cust_address_two:cust_address_two,cust_address_three:cust_address_three, id:id, action:action},  
				success:function(data){  
					load_data();
					$('.success').show(1000).html("Record Saved Successfully.").delay(1000).fadeOut(1000);						
				}  
			});  
		}  
		else  
		{  
			$('.success').show(1000).html("All Fields are Required").delay(1000).fadeOut(1000);
		}  
    });  
	
	$(document).on('click', '.update', function(){  
		var id = $(this).attr("id");  
		$.ajax({  
			url:"fetch.php",  
			method:"POST",  
			data:{id:id},  
			dataType:"json",  
			success:function(data){  
				$('#action').text("Edit");  
				$('#user_id').val(id);  
				$('#customer_code').val(data.customer_code);  
				$('#customer_name').val(data.customer_name);  
				$('#cust_address_one').val(data.cust_address_one);  
				$('#cust_address_two').val(data.cust_address_two);  
				$('#cust_address_three').val(data.cust_address_three);  
			}  
		})  
	});  
	$(document).on('click', '.delete', function(){
		var id = $(this).attr("id");  
		if(confirm("Are you sure you want to remove this data?"))  
		{  
			var action = "Delete";  
			$.ajax({  
				url:"action.php",  
				method:"POST",  
				data:{id:id, action:action},  
				success:function(data){  
					$('.success').show(1000).html("Record Deleted Successfully.").delay(1000).fadeOut(1000);
					load_data();
				}  
			})  
		}  
		else
		{
			return false;
		}
	});	
	//To check the input is not empty and send the cursor to next input.
    $(document).ready(function(){
		  $('input').on('keypress', function(e) {
			if (e.which == 13) {
				switch ($(this).attr('id')) {
					case 'customer_code':
					if (!document.getElementById("customer_code").value.length == 0) {
						$('#customer_name').focus();
						e.preventDefault();
						break;
					}
					case 'customer_name':
					if (!document.getElementById("customer_name").value.length == 0) {
						$('#cust_address_one').focus();
						e.preventDefault();
						break;
					}
					case 'cust_address_one':
					if (!document.getElementById("cust_address_one").value.length == 0) {
						$('#cust_address_two').focus();
						e.preventDefault();
						break;
					}	
					case 'cust_address_two':
					if (!document.getElementById("cust_address_two").value.length == 0) {
						$('#cust_address_three').focus();
						e.preventDefault();
						break;
					}	
					case 'cust_address_three':
					if (!document.getElementById("cust_address_three").value.length == 0) {
						$('#action').focus();
						e.preventDefault();
						break;
					}
				}
			}
		});
	});
});