SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET AUTOCOMMIT = 0;
START TRANSACTION;
SET time_zone = "+00:00";

CREATE TABLE `acc_type` (
  `account_type` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `acc_type` (`account_type`, `description`) VALUES
('BAN', 'BANK'),
('CAS', 'CASH ACCOUNT');

CREATE TABLE `bank_mst` (
  `bank_name` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bank_mst` (`bank_name`) VALUES
('ABHYUDAYA COOPERATIVE BANK LIMITED'),
('ABU DHABI COMMERCIAL BANK'),
('ADITYA BIRLA IDEA PAYMENTS BANK'),
('AHMEDABAD MERCANTILE COOPERATIVE BANK'),
('AHMEDNAGAR MERCHANTS CO-OP BANK LTD'),
('AIRTEL PAYMENTS BANK LIMITED'),
('AKOLA JANATA COMMERCIAL COOPERATIVE BANK'),
('ALLAHABAD BANK'),
('ALMORA URBAN COOPERATIVE BANK LIMITED'),
('ALTURA FINANCIAL SERVICES LTD.'),
('AMBARNATH JAIHIND COOP BANK LTD AMBARNATH'),
('ANANYA FINANCE FOR INCLUSIVE GROWTH PVT. LTD.'),
('ANDHRA BANK'),
('ANDHRA PRADESH GRAMEENA VIKAS BANK'),
('ANDHRA PRAGATHI GRAMEENA BANK'),
('ANNAPURNA MAHILA MULTISTATE CO-OP CREDIT SOCIETY(CO-OP SOCIETY AND MFI)'),
('AP STATE APEX CO-OP BANK LTD.'),
('APNA SAHAKARI BANK LIMITED'),
('AROHAN FINANCIAL SERVICES P. LTD'),
('ARTH MICRO FINANCE PVT. LTD.'),
('ASA INTERNATIONAL INDIA MICROFINANCE LTD'),
('ASIRVAD MICROFINANCE PRIVATE LIMITED'),
('AU SMALL FINANCE BANK LIMITED'),
('AU SMALL FINANCE BANK LTD.'),
('AUSTRALIA AND NEW ZEALAND BANKING GROUP LIMITED'),
('AXIS BANK'),
('B N P PARIBAS'),
('BANDHAN BANK LIMITED'),
('BANK OF AMERICA'),
('BANK OF BAHARAIN AND KUWAIT BSC'),
('BANK OF BARODA'),
('BANK OF CEYLON'),
('BANK OF INDIA'),
('BANK OF MAHARASHTRA'),
('BANSAL CREDITS LTD.'),
('BARCLAYS BANK'),
('BARODA GUJARAT GRAMIN BANK'),
('BARODA RAJASTHAN KSHETRIYA GRAMIN BANK'),
('BARODA UTTAR PRADESH GRAMIN BANK'),
('BASSEIN CATHOLIC COOPERATIVE BANK LIMITED'),
('BELGHORIA JANAKALYAN SAMITY (SOCIETY)'),
('BELSTAR INVESTMENT & FINANCE P. LTD'),
('BHAGINI NIVEDITA SAHAKARI BANK LTD PUNE'),
('BHARAT COOPERATIVE BANK MUMBAI LIMITED'),
('BHARTIYA MICRO CREDIT (SEC  COMPANY)'),
('BIHAR GRAMIN BANK'),
('CANARA BANK'),
('CAPITAL FIRST LIMITED(CFL)'),
('CAPITAL SMALL FINANCE BANK LIMITED'),
('CASHPOR MICRO CREDIT (SEC  COMPANY)'),
('CATHOLIC SYRIAN BANK LTD.'),
('CDOT ( MFI REGISTERED AS A SOCIETY UNDER INDIAN SOCIETIES ACT)'),
('CENTRAL BANK OF INDIA'),
('CHAITANYA GODAVARI GRAMEENA BANK'),
('CHAITANYA INDIA FIN CREDIT PVT. LTD.'),
('CHANURA MICROFIN MANIPUR'),
('CITI BANK'),
('CITIZEN CREDIT COOPERATIVE BANK LIMITED'),
('CITY UNION BANK LIMITED'),
('COMMUNITY COLLECTIVE SOCIETY FOR INTEGRATED DEVELPOMENT (MFI REGISTERED AS A SOCIETY)'),
('CORPORATION BANK'),
('COUNT OF NAME OF PARTNER INSTITUTIONS'),
('CREDIT AGRICOLE CORPORATE AND INVESTMENT BANK CALYON BANK'),
('CREDIT SUISEE AG'),
('CSB BANK LIMITED'),
('CTBC BANK CO LTD'),
('DBS BANK INDIA LIMITED'),
('DCB BANK LIMITED'),
('DECCAN GRAMEENA BANK'),
('DENA BANK'),
('DENA GUJARAT GRAMIN BANK'),
('DEOGIRI NAGARI SAHAKARI BANK LTD. AURANGABAD'),
('DEPOSIT INSURANCE AND CREDIT GUARANTEE CORPORATION'),
('DEUSTCHE BANK'),
('DEVELOPMENT BANK OF SINGAPORE'),
('DHANALAKSHMI BANK'),
('DHOSA CHANDANESHWAR BRATYAJANA SAMITY (DCBS) (SOCIETY)'),
('DIGAMBER CAPFIN LTD'),
('DISHA INDIA MICRO CREDIT (SEC  COMPANY)'),
('DMK JAOLI BANK'),
('DOHA BANK'),
('DOHA BANK QSC'),
('DOMBIVALI NAGARI SAHAKARI BANK LTD'),
('DOMBIVLI NAGARI SAHAKARI BANK LIMITED'),
('DURGAPUR STEEL PEOPLES CO-OPERATIVE BANK LTD'),
('ECL FINANCE LTD.'),
('ELECTRONICA FINANCE LTD.'),
('EMIRATES NBD BANK P J S C'),
('EQUITAS FINANCE P. LTD.'),
('EQUITAS SMALL FINANCE BANK LIMITED'),
('ESAF SMALL FINANCE BANK LIMITED'),
('ESSKAY AUTO FINANCE LTD.'),
('EXPORT IMPORT BANK OF INDIA'),
('FEDERAL BANK'),
('FINCARE SMALL FINANCE BANK LTD'),
('FINO FINANCE P. LTD. (ERSTWHILE INTREPID FINANCE AND LEASING PVT. LTD.)'),
('FINO PAYMENTS BANK'),
('FIRST ABU DHABI BANK PJSC'),
('FIRSTRAND BANK LIMITED'),
('FIVE STAR BUSINESS CREDITS LTD.'),
('FULLERTON INDIA CREDIT CO. LTD.'),
('FUSION MICRO FINANCE P. LTD.'),
('FUTURE FINANCIAL SERVICES LTD.'),
('G P PARSIK BANK'),
('GRAMEEN DEVELOPMENT & FINANCE P. LTD.'),
('GRAMIN BANK OF ARYAVART'),
('GS MAHANAGAR CO-OPERATIVE BANK LIMITED MUMBAI'),
('GUJARAT STATE CO-OP BANK LTD'),
('HARYANA STATE COOPERATIVE BANK'),
('HDFC BANK'),
('HIMACHAL PRADESH GRAMIN BANK'),
('HIMACHAL PRADESH STATE COOPERATIVE BANK LTD'),
('HINDUSTAN MICROFINANCE PRIVATE LIMITED'),
('HSBC BANK'),
('HUMANA PEOPLE TO PEOPLE INDIA'),
('ICICI BANK LIMITED'),
('IDBI BANK LTD.'),
('IDF FINANCIAL SERVICES PVT LTD'),
('IDFC BANK LTD.'),
('IDFC FIRST BANK LTD'),
('IDRBT'),
('IDUKKI DISTRICT CO OPERATIVE BANK LTD'),
('IKF FINANCE LTD.'),
('INDIA INFOLINE FINANCE LTD (IIFL)'),
('INDIA POST PAYMENT BANK'),
('INDIABULLS FINANCIAL SERVICES LTD.'),
('INDIAN BANK'),
('INDIAN OVERSEAS BANK'),
('INDUSIND BANK LTD.'),
('INDUSTRIAL AND COMMERCIAL BANK OF CHINA LIMITED'),
('INDUSTRIAL BANK OF KOREA'),
('INTEC CAPITAL LTD.'),
('IRCED (MFI REGISTERED AS A SOCIETY AND TRUST)'),
('IRINJALAKUDA TOWN CO-OPERATIVE BANK LTD'),
('JAGARAN MICROFIN P. LTD'),
('JALGAON JANATA SAHAKARI BANK LIMITED'),
('JAMMU AND KASHMIR BANK LIMITED'),
('JANA SMALL FINANCE BANK LTD'),
('JANAKALYAN SAHAKARI BANK LIMITED'),
('JANALAKSHMI FINANCIAL SERVICES PVT LTD'),
('JANASEVA SAHAKARI BANK BORIVLI LIMITED'),
('JANASEVA SAHAKARI BANK LIMITED'),
('JANATA SAHAKARI BANK LIMITED'),
('JIO PAYMENTS BANK LIMITED'),
('JP MORGAN BANK'),
('JUMBO FINVEST (INDIA) LIMITED (JFIL)'),
('KALLAPPANNA AWADE ICHALKARANJI JANATA SAHAKARI BANK LIMITED'),
('KALUPUR COMMERCIAL COOPERATIVE BANK'),
('KALYAN JANATA SAHAKARI BANK'),
('KARNATAKA BANK LIMITED'),
('KARNATAKA VIKAS GRAMEENA BANK'),
('KARUR VYSYA BANK'),
('KASHI GOMTI SAMYUT GRAMIN BANK'),
('KAVERI GRAMEENA BANK'),
('KEB HANA BANK'),
('KERALA GRAMIN BANK'),
('KOTAK MAHINDRA BANK LIMITED'),
('KOTAK MAHINDRA PRIME LIMITED'),
('KOZHIKODE DISTRICT COOPERATIAVE BANK LTD'),
('KRUNG THAI BANK PCL'),
('L&T FINANCE LTD.'),
('LAXMI VILAS BANK'),
('LIFE FOUNDATION (MFI AND TRUST)'),
('LIGHT MICRO FINANCE LTD'),
('M POWER MICRO FINANCE PRIVATE LTD'),
('MAANAVEEYA DEVELOPMENT & FINANCE PRIVATE LTD'),
('MADHYA BIHAR GRAMIN BANK'),
('MADURA MICRO FINANCE LTD.'),
('MAGMA FINCORP LTD.'),
('MAHANA FOUNDATION (MFI REGISTERED AS A TRUST UNDER TRUST ACT )'),
('MAHARASHTRA GRAMIN BANK'),
('MAHARASHTRA STATE COOPERATIVE BANK'),
('MAHASEMAM TRUST (SOCIETY)'),
('MAHASHAKTI FOUNDATION (MFI REGISTERED AS A TRUST UNDER TRUST ACT )'),
('MAHESH SAHAKARI BANK LTD PUNE'),
('MAHINDRA & MAHINDRA FINANCIAL SERVICES LTD'),
('MALWA GRAMIN BANK'),
('MARGDARSHAK FINANCIAL SERVICES LTD.'),
('MARUDHARA GRAMIN BANK'),
('MAS FINANCIAL SERVICES LTD.'),
('MASHREQBANK PSC'),
('MEGHALAYA RURAL BANK'),
('MEHSANA URBAN CO-OP BANK'),
('MIDLAND MICROFIN LTD.'),
('MIZUHO BANK LTD'),
('MONEYWISE FINANCIAL SERVICES PVT LTD'),
('MSM MICROFINANCE LIMITED'),
('MUFG BANK LTD'),
('MUTHOOT FINCORP LIMITED'),
('MUTHOOT MICROFIN LTD'),
('NABARD FINANCIAL SERVICES LTD (NABFINS)'),
('NAGAR URBAN CO OPERATIVE BANK'),
('NAGPUR NAGARIK SAHAKARI BANK LIMITED'),
('NAINITAL BANK LTD.'),
('NAMRA FINANCE LTD'),
('NARMADA JHABUA GRAMIN BANK'),
('NATIONAL BANK FOR AGRICULTURE AND RURAL DEVELOPMENT'),
('NAV JEEVAN CO OP BANK LTD'),
('NAVACHETANA MICROFIN SERVICES PVT. LTD'),
('NEED LIVELIHOOD MICRO FINANCE P. LTD.'),
('NETWORK OF ENTREPRENEURSHIP & ECONOMIC DEVELOPMENT (NEED )'),
('NEW INDIA COOPERATIVE BANK LIMITED'),
('NIGHTINGALE FINVEST PVT LTD'),
('NKGSB COOPERATIVE BANK LIMITED'),
('NORTH EAST SMALL FINANCE BANK LIMITED'),
('NSDL PAYMENTS BANK LIMITED'),
('NUTAN NAGARIK SAHAKARI BANK LIMITED'),
('ORIENTAL BANK OF COMMERCE'),
('PAHAL FINANCIAL SERVICES P. LTD.'),
('PALLAVAN GRAMA BANK.'),
('PANDYAN GRAMA BANK'),
('PAYTM PAYMENTS BANK LTD'),
('PRAGATHI KRISHNA GRAMIN BANK'),
('PRATHAMA GRAMIN BANK'),
('PRAYAS (ORGANISATION FOR SUSTAINABLE DEVELOPMENT) (MFI REGISTERED AS A SOCIETY AND TRUST)'),
('PRIME COOPERATIVE BANK LIMITED'),
('PT BANK MAYBANK INDONESIA TBK'),
('PUDHUAARU FINANCIAL SERVICES PVT LIMITED (PFSPL)'),
('PUDUVAI BHARATHIAR GRAMA BANK'),
('PUNJAB AND SIND BANK'),
('PUNJAB GRAMIN BANK'),
('PUNJAB NATIONAL BANK'),
('QATAR NATIONAL BANK SAQ'),
('RABOBANK INTERNATIONAL'),
('RAJARAMBAPU SAHAKARI BANK LIMITED'),
('RAJASTHAN MARUDHARA GRAMIN BANK'),
('RAJGURUNAGAR SAHAKARI BANK LIMITED'),
('RAJKOT NAGRIK SAHAKARI BANK LIMITED'),
('RBL BANK LIMITED'),
('RELIANCE CAPITAL LTD.'),
('RELIGARE FINVEST LTD.'),
('S V CREDITLINE PVT. LTD.'),
('S.E. INVESTMENTS LTD.'),
('SAHEBRAO DESHMUKH COOPERATIVE BANK LIMITED'),
('SAHYOG MICROFINANCE LTD.'),
('SAIJA FINANCE PRIVATE LTD.'),
('SAKHI SAMUDAYA KOSH (SEC  COMPANY)'),
('SAKTHI FINANCE LTD.'),
('SAMARTH SAHAKARI BANK LTD'),
('SAMASTA MICROFINANCE LTD.'),
('SAMBANDH FINSERVE PVT LTD'),
('SAMPURNA TRAINING AND ENTREPRENEURSHIP PROGRAMME (STEP) (SECTION  COMPANY)'),
('SANGHMITRA RURAL FINANCIAL SERVICES (SEC )'),
('SANT SOPANKAKA SAHAKARI BANK LTD'),
('SAPTAGIRI GRAMEENA BANK'),
('SARASPUR NAGRIK CO OPERATIVE BANK LTD SARASPUR'),
('SARASWAT COOPERATIVE BANK LIMITED'),
('SARVA HARYANA GRAMIN BANK'),
('SARVA UP GRAMIN BANK'),
('SATIN CREDIT CARE NETWORK LTD-'),
('SAURASHTRA GRAMIN BANK'),
('SBER BANK'),
('SBM BANK INDIA LIMITED'),
('SEBA RAHARA (SOCIETY)'),
('SHAKTI MAHILA SANGH BAHU UDDESHYA SAHKARI MARYADIT (SOCIETY)'),
('SHIKHAR MICROFINANCE PVT. LTD.'),
('SHIKSHAK SAHAKARI BANK LIMITED'),
('SHINHAN BANK'),
('SHIVALIK MERCANTILE CO OPERATIVE BANK LTD'),
('SHRI CHHATRAPATI RAJASHRI SHAHU URBAN COOPERATIVE BANK LIMITED'),
('SHRI VEERSHAIV CO OP BANK LTD'),
('SHRIRAM CITY UNION FINANCE LTD.'),
('SHRIRAM FINANCE CORPORATION PVT LTD (SRFCL)'),
('SHRIRAM TRANSPORT FINANCE CO. LTD.'),
('SIR M VISVESVARAYA CO OPERATIVE BANK LTD'),
('SKS MICROFINANCE LTD. (NAME CHANGED TO BHARAT FINANCIAL INCLUSION LTD.)'),
('SMALL FINANCE BANK'),
('SMILE MICROFINANCE LIMITED'),
('SOCIETE GENERALE'),
('SOCIETY FOR MODEL GRAM BIKASH KENDRA (SMGBK)'),
('SOLAPUR JANATA SAHAKARI BANK LIMITED'),
('SONATA FINANCE PVT. LTD'),
('SOUTH INDIAN BANK'),
('SREI EQUIPMENT FINANCE LTD.'),
('STANDARD CHARTERED BANK'),
('STATE BANK OF INDIA'),
('SUMITOMO MITSUI BANKING CORPORATION'),
('SURAT NATIONAL COOPERATIVE BANK LIMITED'),
('SURAT PEOPLE CO-OP BANK LTD'),
('SURYODAY MICROFINANCE LTD (SINCE TRANSFORMED INTO SFB)'),
('SURYODAY SMALL FINANCE BANK LIMITED'),
('SUTEX COOPERATIVE BANK LIMITED'),
('SUTLEJ GRAMIN BANK'),
('SWAYAM MICRO SERVICES(SEC  COMPANY)'),
('SYNDICATE BANK'),
('TAMIL NADU APEX STATE CO-OP BANK LTD'),
('TAMILNAD MERCANTILE BANK LIMITED'),
('TATA MOTORS'),
('TELANGANA GRAMEENA BANK'),
('TELANGANA STATE COOP APEX BANK'),
('TEXTILE TRADERS CO-OPERATIVE BANK LIMITED'),
('THE A.P. MAHESH COOPERATIVE URBAN BANK LIMITED'),
('THE AKOLA DISTRICT CENTRAL COOPERATIVE BANK'),
('THE ANDHRA PRADESH STATE COOPERATIVE BANK LIMITED'),
('THE BANK OF NOVA SCOTIA'),
('THE BARAMATI SAHAKARI BANK LTD'),
('THE COSMOS CO OPERATIVE BANK LIMITED'),
('THE DELHI STATE COOPERATIVE BANK LIMITED'),
('THE GADCHIROLI DISTRICT CENTRAL COOPERATIVE BANK LIMITED'),
('THE GREATER BOMBAY COOPERATIVE BANK LIMITED'),
('THE GUJARAT STATE COOPERATIVE BANK LIMITED'),
('THE HASTI COOP BANK LTD'),
('THE JALGAON PEOPELS COOPERATIVE BANK LIMITED'),
('THE KANGRA CENTRAL COOPERATIVE BANK LIMITED'),
('THE KANGRA COOPERATIVE BANK LIMITED'),
('THE KARAD URBAN COOPERATIVE BANK LIMITED'),
('THE KARANATAKA STATE COOPERATIVE APEX BANK LIMITED'),
('THE KERALA STATE CO OPERATIVE BANK LTD'),
('THE KURMANCHAL NAGAR SAHAKARI BANK LIMITED'),
('THE MALKAPUR URBAN CO OPERATIVE BANK LTD MALKAPUR'),
('THE MEHSANA URBAN COOPERATIVE BANK'),
('THE MUMBAI DISTRICT CENTRAL COOPERATIVE BANK LIMITED'),
('THE MUNICIPAL COOPERATIVE BANK LIMITED'),
('THE MUSLIM CO-OPERATIVE BANK LTD'),
('THE NAINITAL BANK LIMITED'),
('THE NASIK MERCHANTS COOPERATIVE BANK LIMITED'),
('THE NAVNIRMAN CO-OPERATIVE BANK LIMITED'),
('THE NILAMBUR CO OPERATIVE URBAN BANK LTD NILAMBUR'),
('THE ODISHA STATE COOPERATIVE BANK LTD'),
('THE PANDHARPUR URBAN CO OP. BANK LTD. PANDHARPUR'),
('THE RAJASTHAN STATE COOPERATIVE BANK LIMITED'),
('THE RATNAKAR BANK LTD.'),
('THE SEVA VIKAS COOPERATIVE BANK LIMITED'),
('THE SHAMRAO VITHAL COOPERATIVE BANK'),
('THE SINDHUDURG DISTRICT CENTERIAL CO-OP BANK LTD'),
('THE SURAT DISTRICT COOPERATIVE BANK LIMITED'),
('THE SURATH PEOPLES COOPERATIVE BANK LIMITED'),
('THE TAMIL NADU STATE APEX COOPERATIVE BANK'),
('THE THANE BHARAT SAHAKARI BANK LIMITED'),
('THE THANE DISTRICT CENTRAL COOPERATIVE BANK LIMITED'),
('THE URBAN CO OPERATIVE BANK LTD NO ONE SEVEN FIVE EIGHT PERINTHALMANNA'),
('THE VARACHHA COOPERATIVE BANK LIMITED'),
('THE VIJAY CO OPERATIVE BANK LIMITED'),
('THE VISHWESHWAR SAHAKARI BANK LIMITED'),
('THE WEST BENGAL STATE COOPERATIVE BANK'),
('THE ZOROASTRIAN COOPERATIVE BANK LIMITED'),
('THRISSUR DISTRICT CO-OPERATIVE BANK LTD'),
('TJSB SAHAKARI BANK LIMITED'),
('TRIPURA GRAMIN BANK'),
('TUMKUR GRAIN MERCHANTS COOPERATIVE BANK LIMITED'),
('TVS CREDIT SERVICES LTD'),
('UCO BANK'),
('UJJIVAN FINANCIAL SERVICES P. LTD (SINCE TRANSFORMED INTO SFB)'),
('UJJIVAN SMALL FINANCE BANK LIMITED'),
('UNACCO FINANCIAL SERVICES PRIVATE LIMITED'),
('UNION BANK OF INDIA'),
('UNITED BANK OF INDIA'),
('UNITED OVERSEAS BANK LIMITED'),
('UTKARSH SMALL FINANCE BANK'),
('UTTAR BIHAR GRAMIN BANK'),
('UTTAR PRADESH COOPERATIVE BANK LTD'),
('UTTARAYAN FINANCIAL SERVICES PVT LTD'),
('VARAM CAPITAL PRIVATE LIMITED'),
('VASAI JANATA SAHAKARI BANK LTD'),
('VASAI VIKAS SAHAKARI BANK LIMITED'),
('VEDIKA CREDIT CAPITAL LTD'),
('VIDHARBHA KONKAN GRAMIN BANK'),
('VIJAYA BANK'),
('VILLAGE FINANCIAL SERVICES PVT LIMITED'),
('VISTAAR FINANCIAL SERVICES P. LTD.'),
('WESTPAC BANKING CORPORATION'),
('WOMEN?S VOLUNTARY ORGANISATION'),
('WOORI BANK'),
('YES BANK'),
('YES BANK LTD.'),
('YVU FINANCIAL SERVICES PRIVATE LTD'),
('ZILA SAHAKRI BANK LIMITED GHAZIABAD');

CREATE TABLE `company_mst` (
  `company_code` varchar(255) NOT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `company_address_one` varchar(255) DEFAULT NULL,
  `company_address_two` varchar(255) DEFAULT NULL,
  `company_address_three` varchar(255) DEFAULT NULL,
  `company_address_four` varchar(255) DEFAULT NULL,
  `company_place` varchar(255) DEFAULT NULL,
  `company_pin` varchar(255) DEFAULT NULL,
  `company_st_code` varchar(255) DEFAULT NULL,
  `company_st_name` varchar(255) DEFAULT NULL,
  `company_phone` varchar(255) DEFAULT NULL,
  `company_mobile` varchar(255) DEFAULT NULL,
  `company_email` varchar(255) DEFAULT NULL,
  `company_gstno` varchar(255) DEFAULT NULL,
  `company_pan_no` varchar(255) DEFAULT NULL,
  `company_aadhar_no` varchar(255) DEFAULT NULL,
  `company_bank_name` varchar(255) DEFAULT NULL,
  `company_bank_accno` varchar(255) DEFAULT NULL,
  `company_ifsc_code` varchar(255) DEFAULT NULL,
  `company_bank_address` varchar(255) DEFAULT NULL,
  `company_bank_branch` varchar(255) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `company_mst` (`company_code`, `company_name`, `company_address_one`, `company_address_two`, `company_address_three`, `company_address_four`, `company_place`, `company_pin`, `company_st_code`, `company_st_name`, `company_phone`, `company_mobile`, `company_email`, `company_gstno`, `company_pan_no`, `company_aadhar_no`, `company_bank_name`, `company_bank_accno`, `company_ifsc_code`, `company_bank_address`, `company_bank_branch`) VALUES
('SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', 'SURAT', '394305', '24', 'GUJARAT', '-', '9377811610', 'venkat1610@gmail.com', '24', '-', '-', 'HDFC', '-', '-', '-', '-');

CREATE TABLE `control_mst` (
  `description` varchar(100) NOT NULL,
  `srno` varchar(45) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `control_mst` (`description`, `srno`) VALUES
('ACCOUNT', '1001'),
('CUSTCN', '1'),
('CUSTDN', '1'),
('CUSTOMER', '1007'),
('DISC', '11'),
('GRN', '3'),
('GST-B2B', '10'),
('GST-B2B-P', '1'),
('GST-B2C', '2'),
('GST-B2C-P', '1'),
('I-GST', '5'),
('I-GST-P', '1'),
('ORDER', '2'),
('PART', '3766'),
('PAYMENTS', '2'),
('PDISC', '1'),
('RECEIPTS', '1'),
('SEGMENT', '1'),
('SUPCN', '1'),
('SUPDN', '1'),
('SUPPLIER', '1003');

CREATE TABLE `customer_mst` (
  `acc_type` varchar(150) NOT NULL,
  `id` int(12) NOT NULL,
  `customer_name` varchar(250) NOT NULL,
  `customer_code` varchar(50) NOT NULL,
  `cust_address_one` varchar(250) NOT NULL,
  `cust_address_two` varchar(250) NOT NULL,
  `cust_address_three` varchar(250) NOT NULL,
  `cust_place` varchar(150) NOT NULL,
  `cust_pin_code` varchar(10) NOT NULL,
  `cust_st_code` varchar(10) NOT NULL,
  `cust_st_name` varchar(250) NOT NULL,
  `cont_person` varchar(150) NOT NULL,
  `cust_phone` varchar(250) NOT NULL,
  `cust_mobile` varchar(250) NOT NULL,
  `cust_email` varchar(250) NOT NULL,
  `cust_gstno` varchar(50) NOT NULL,
  `cust_pan_no` varchar(15) NOT NULL,
  `cust_aadhar_no` varchar(20) NOT NULL,
  `tax_code` varchar(50) NOT NULL,
  `opening` double(18,2) NOT NULL,
  `debit` double(18,2) NOT NULL,
  `credit` double(18,2) NOT NULL,
  `clbalance` double(18,2) NOT NULL,
  `transporter_name` varchar(250) NOT NULL,
  `bankname` varchar(250) NOT NULL,
  `bankaccno` varchar(100) NOT NULL,
  `bankaccname` varchar(250) NOT NULL,
  `ifsccode` varchar(50) NOT NULL,
  `due_days` int(12) NOT NULL,
  `remarks` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `customer_mst` (`acc_type`, `id`, `customer_name`, `customer_code`, `cust_address_one`, `cust_address_two`, `cust_address_three`, `cust_place`, `cust_pin_code`, `cust_st_code`, `cust_st_name`, `cont_person`, `cust_phone`, `cust_mobile`, `cust_email`, `cust_gstno`, `cust_pan_no`, `cust_aadhar_no`, `tax_code`, `opening`, `debit`, `credit`, `clbalance`, `transporter_name`, `bankname`, `bankaccno`, `bankaccname`, `ifsccode`, `due_days`, `remarks`) VALUES
('SDE', 1003, 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', '1003', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '396193', '26', 'Dadra and Nagar Haveli', 'MANISHBHAI', '2668605 / 2669804', '-', '-', '26AAACD8469M1Z3', 'AAACD8469M', '-', 'I-GST', 0.00, 23276.00, 0.00, 23276.00, 'PATHAK', '-', '-', '-', '-', 60, '-'),
('SDE', 1001, 'AMIT TRADING CO', '1001', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '24', 'Gujarat', 'YOGESHBHAI', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', 'GST-B2B', 0.00, 230748.00, 0.00, 230748.00, 'POOJA', '-', '-', '-', '-', 30, '-'),
('CAS', 1005, 'CASH ACCOUNT', '1005', 'CASH ACCOUNT', 'CASH ACCOUNT', 'CASH ACCOUNT', 'SURAT', '394210', '24', 'Gujarat', '-', '-', '-', '-', '24', '-', '-', 'GST-B2C', 10000.00, 0.00, 0.00, 10000.00, '-', 'CASH ACCOUNT', '-', '-', '-', 0, '-'),
('SDE', 1006, 'CASH BILL', '1006', '-', '-', '-', 'SURAT', '-', '24', 'Gujarat', '-', '-', '-', '-', '24', '-', '-', 'GST-B2C', 0.00, 17228.00, 0.00, 17228.00, '0', '-', '-', '-', '-', 0, '-'),
('BAN', 1004, 'HDFC BANK LTD', '1004', 'HDFC BANK LTD', 'HDFC BANK LTD', 'NANPURA', 'SURAT', '395001', '24', 'Gujarat', '-', '-', '-', '-', '24', '-', '-', 'GST-B2C', 1000000.00, 2000.00, 0.00, 998000.00, '-', 'HDFC BANK LTD', '50200016394470', 'HDFC BANK LTD', 'HDFC0001026', 0, '-'),
('SDE', 1002, 'RADIANT TRADERS', '1002', '14, SPAN INDUSTRIAL COMPLEX,', 'NR. CANARA BANK,', 'GIDC - VATVA,', 'AHMEDABAD', '382445', '24', 'Gujarat', 'RAJUBHAI', '079-25835153', '9426354834', '-', '24ACLPP0047M1ZF', 'ACLPP0047M', '-', 'GST-B2B', 0.00, 3013.00, 0.00, 3013.00, 'POOJA', '-', '-', '-', '-', 60, '-');

CREATE TABLE `custsegment_mst` (
  `customer_code` varchar(250) NOT NULL,
  `segment` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `custsegment_mst` (`customer_code`, `segment`) VALUES
('1001', 'TVS-SOCKET');

CREATE TABLE `disc_mst` (
  `id` int(11) NOT NULL,
  `customer_code` varchar(50) NOT NULL,
  `customer_name` varchar(50) NOT NULL,
  `cust_place` varchar(50) NOT NULL,
  `segment` varchar(50) NOT NULL,
  `disc_per` double(18,2) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `disc_mst` (`id`, `customer_code`, `customer_name`, `cust_place`, `segment`, `disc_per`) VALUES
(1042, '1002', 'RADIANT TRADERS', 'AHMEDABAD', 'TVS-SOCKET', 63.00),
(1041, '1001', 'AMIT TRADING CO', 'AHMEDABAD', 'TVS-SOCKET', 62.00),
(1043, '1006', 'CASH BILL', 'SURAT', 'TVS-HEX', 0.00),
(1040, '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'DADRA', 'TVS-SOCKET', 55.00),
(1039, '1002', 'RADIANT TRADERS', 'AHMEDABAD', 'TVS-HEX', 49.50),
(1038, '1001', 'AMIT TRADING CO', 'AHMEDABAD', 'TVS-HEX', 49.50),
(1037, '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'DADRA', 'TVS-HEX', 45.00),
(1044, '1006', 'CASH BILL', 'SURAT', 'TVS-SOCKET', 0.00);

CREATE TABLE `getvalue_mst` (
  `part_number` varchar(250) NOT NULL,
  `description` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `getvalue_mst` (`part_number`, `description`) VALUES
('070000200-0500', 'CHANGEDVALUE');

CREATE TABLE `invprt_mst` (
  `inv_number` varchar(255) NOT NULL,
  `inv_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `partno` varchar(255) NOT NULL,
  `description_one` varchar(255) NOT NULL,
  `description_two` varchar(255) NOT NULL,
  `list` double(18,2) NOT NULL,
  `qty` double(18,2) NOT NULL,
  `disc_per` double(18,2) NOT NULL,
  `list_value` double(18,2) NOT NULL,
  `disc_amt` double(18,2) NOT NULL,
  `sales_val` double(18,2) NOT NULL,
  `sgst_per` double(18,2) NOT NULL,
  `sgst_amt` double(18,2) NOT NULL,
  `cgst_per` double(18,2) NOT NULL,
  `cgst_amt` double(18,2) NOT NULL,
  `igst_per` double(18,2) NOT NULL,
  `igst_amt` double(18,2) NOT NULL,
  `inv_val` double(18,2) NOT NULL,
  `cost` double(18,3) NOT NULL,
  `cost_val` double(18,3) NOT NULL,
  `rate_one` double(18,2) NOT NULL,
  `hsn_code` varchar(255) NOT NULL,
  `segment` varchar(255) NOT NULL,
  `tax_code` varchar(255) NOT NULL,
  `customer_code` varchar(255) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `cust_address_one` varchar(255) NOT NULL,
  `cust_address_two` varchar(255) NOT NULL,
  `cust_address_three` varchar(255) NOT NULL,
  `cust_place` varchar(255) NOT NULL,
  `cust_pin_code` varchar(255) NOT NULL,
  `cust_phone` varchar(255) NOT NULL,
  `cust_mobile` varchar(255) NOT NULL,
  `cust_email` varchar(255) NOT NULL,
  `cust_gstno` varchar(255) NOT NULL,
  `cust_pan_no` varchar(255) NOT NULL,
  `cust_aadhar_no` varchar(255) NOT NULL,
  `cust_st_code` varchar(255) NOT NULL,
  `cust_st_name` varchar(255) NOT NULL,
  `company_code` varchar(25) NOT NULL,
  `company_name` varchar(255) NOT NULL,
  `company_address_one` varchar(255) NOT NULL,
  `company_address_two` varchar(255) NOT NULL,
  `company_address_three` varchar(255) NOT NULL,
  `company_address_four` varchar(255) NOT NULL,
  `company_pin` varchar(255) NOT NULL,
  `company_place` varchar(255) NOT NULL,
  `company_mobile` varchar(255) NOT NULL,
  `company_phone` varchar(255) NOT NULL,
  `company_email` varchar(255) NOT NULL,
  `company_gstno` varchar(255) NOT NULL,
  `company_pan_no` varchar(255) NOT NULL,
  `company_aadhar_no` varchar(255) NOT NULL,
  `company_st_code` varchar(255) NOT NULL,
  `company_st_name` varchar(255) NOT NULL,
  `company_bank_name` varchar(255) NOT NULL,
  `company_bank_accno` varchar(255) NOT NULL,
  `company_ifsc_code` varchar(255) NOT NULL,
  `company_bank_address` varchar(255) NOT NULL,
  `po_no` varchar(255) NOT NULL,
  `po_date` varchar(255) NOT NULL,
  `challan_no` varchar(255) NOT NULL,
  `challan_date` varchar(255) NOT NULL,
  `lr_no` varchar(255) NOT NULL,
  `lr_dt` varchar(255) NOT NULL,
  `transporter_name` varchar(255) NOT NULL,
  `no_of_parcel` varchar(255) NOT NULL,
  `due_days` varchar(255) NOT NULL,
  `due_date` varchar(255) NOT NULL,
  `rsinwords` varchar(255) NOT NULL,
  `dpart` varchar(25) NOT NULL,
  `mpart` varchar(25) NOT NULL,
  `ypart` varchar(25) NOT NULL,
  `fyear` varchar(25) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `invprt_mst` (`inv_number`, `inv_date`, `partno`, `description_one`, `description_two`, `list`, `qty`, `disc_per`, `list_value`, `disc_amt`, `sales_val`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `inv_val`, `cost`, `cost_val`, `rate_one`, `hsn_code`, `segment`, `tax_code`, `customer_code`, `customer_name`, `cust_address_one`, `cust_address_two`, `cust_address_three`, `cust_place`, `cust_pin_code`, `cust_phone`, `cust_mobile`, `cust_email`, `cust_gstno`, `cust_pan_no`, `cust_aadhar_no`, `cust_st_code`, `cust_st_name`, `company_code`, `company_name`, `company_address_one`, `company_address_two`, `company_address_three`, `company_address_four`, `company_pin`, `company_place`, `company_mobile`, `company_phone`, `company_email`, `company_gstno`, `company_pan_no`, `company_aadhar_no`, `company_st_code`, `company_st_name`, `company_bank_name`, `company_bank_accno`, `company_ifsc_code`, `company_bank_address`, `po_no`, `po_date`, `challan_no`, `challan_date`, `lr_no`, `lr_dt`, `transporter_name`, `no_of_parcel`, `due_days`, `due_date`, `rsinwords`, `dpart`, `mpart`, `ypart`, `fyear`) VALUES
('B2B- 1  (22-23)', '2022-04-27 13:28:50', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 62.00, 6900.00, 4278.00, 2622.00, 9.00, 235.98, 9.00, 235.98, 0.00, 0.00, 3093.96, 2.520, 2520.000, 4.28, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '27/5/2022', 'Three Thousand Ninety Four ', '', '', '', '');

CREATE TABLE `invtemp_mst` (
  `partno` varchar(255) NOT NULL,
  `description_one` varchar(255) NOT NULL,
  `description_two` varchar(255) NOT NULL,
  `hsn_code` varchar(55) NOT NULL,
  `qty` double(18,2) NOT NULL,
  `list` double(18,2) NOT NULL,
  `segment` varchar(255) NOT NULL,
  `disc_per` double(18,2) NOT NULL,
  `disc_amt` double(18,2) NOT NULL,
  `list_value` double(18,2) NOT NULL,
  `rate_one` double(18,2) NOT NULL,
  `sales_val` double(18,2) NOT NULL,
  `sgst_per` double(18,2) NOT NULL,
  `sgst_amt` double(18,2) NOT NULL,
  `cgst_per` double(18,2) NOT NULL,
  `cgst_amt` double(18,2) NOT NULL,
  `igst_per` double(18,2) NOT NULL,
  `igst_amt` double(18,2) NOT NULL,
  `inv_val` double(18,2) NOT NULL,
  `cost` double(18,2) NOT NULL,
  `cost_val` double(18,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `invtotalprt_mst` (
  `inv_number` varchar(55) NOT NULL,
  `inv_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total_qty` double(18,2) NOT NULL,
  `total_disc_amt` double(18,2) NOT NULL,
  `total_list_value` double(18,2) NOT NULL,
  `total_sales_val` double(18,2) NOT NULL,
  `total_sgstamt` double(18,2) NOT NULL,
  `total_cgstamt` double(18,2) NOT NULL,
  `total_igstamt` double(18,2) NOT NULL,
  `total_val` double(18,2) NOT NULL,
  `roundoff` double(18,2) NOT NULL,
  `total_inv_val` double(18,2) NOT NULL,
  `total_cost` double(18,2) NOT NULL,
  `tax_code` varchar(255) NOT NULL,
  `customer_code` varchar(255) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `cust_address_one` varchar(255) NOT NULL,
  `cust_address_two` varchar(255) NOT NULL,
  `cust_address_three` varchar(255) NOT NULL,
  `cust_place` varchar(255) NOT NULL,
  `cust_phone` varchar(255) NOT NULL,
  `cust_pin_code` varchar(55) NOT NULL,
  `cust_email` varchar(255) NOT NULL,
  `cust_mobile` varchar(255) NOT NULL,
  `cust_gstno` varchar(55) NOT NULL,
  `cust_st_code` varchar(55) NOT NULL,
  `cust_st_name` varchar(255) NOT NULL,
  `cust_aadhar_no` varchar(55) NOT NULL,
  `cust_pan_no` varchar(55) NOT NULL,
  `po_no` varchar(255) NOT NULL,
  `po_date` varchar(55) NOT NULL,
  `challan_no` varchar(55) NOT NULL,
  `challan_date` varchar(55) NOT NULL,
  `lr_no` varchar(55) NOT NULL,
  `lr_dt` varchar(255) NOT NULL,
  `transporter_name` varchar(255) NOT NULL,
  `no_of_parcel` varchar(55) NOT NULL,
  `rsinwords` varchar(255) NOT NULL,
  `due_days` varchar(55) NOT NULL,
  `due_date` varchar(55) NOT NULL,
  `dpart` varchar(55) NOT NULL,
  `mpart` varchar(55) NOT NULL,
  `ypart` varchar(55) NOT NULL,
  `fyear` varchar(55) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `invtotalprt_mst` (`inv_number`, `inv_date`, `total_qty`, `total_disc_amt`, `total_list_value`, `total_sales_val`, `total_sgstamt`, `total_cgstamt`, `total_igstamt`, `total_val`, `roundoff`, `total_inv_val`, `total_cost`, `tax_code`, `customer_code`, `customer_name`, `cust_address_one`, `cust_address_two`, `cust_address_three`, `cust_place`, `cust_phone`, `cust_pin_code`, `cust_email`, `cust_mobile`, `cust_gstno`, `cust_st_code`, `cust_st_name`, `cust_aadhar_no`, `cust_pan_no`, `po_no`, `po_date`, `challan_no`, `challan_date`, `lr_no`, `lr_dt`, `transporter_name`, `no_of_parcel`, `rsinwords`, `due_days`, `due_date`, `dpart`, `mpart`, `ypart`, `fyear`) VALUES
('B2B- 1  (22-23)', '2022-04-27 13:28:50', 1000.00, 4278.00, 6900.00, 2622.00, 235.98, 235.98, 0.00, 3093.96, 0.04, 3094.00, 2520.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Three Thousand Ninety Four ', '30', '27/5/2022', '', '', '', '');

CREATE TABLE `invtotal_mst` (
  `inv_number` varchar(55) NOT NULL,
  `inv_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `total_qty` double(18,2) NOT NULL,
  `total_disc_amt` double(18,2) NOT NULL,
  `total_list_value` double(18,2) NOT NULL,
  `total_sales_val` double(18,2) NOT NULL,
  `total_sgstamt` double(18,2) NOT NULL,
  `total_cgstamt` double(18,2) NOT NULL,
  `total_igstamt` double(18,2) NOT NULL,
  `total_val` double(18,2) NOT NULL,
  `roundoff` double(18,2) NOT NULL,
  `total_inv_val` double(18,2) NOT NULL,
  `total_cost` double(18,2) NOT NULL,
  `tax_code` varchar(255) NOT NULL,
  `customer_code` varchar(255) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `cust_address_one` varchar(255) NOT NULL,
  `cust_address_two` varchar(255) NOT NULL,
  `cust_address_three` varchar(255) NOT NULL,
  `cust_place` varchar(255) NOT NULL,
  `cust_phone` varchar(255) NOT NULL,
  `cust_pin_code` varchar(55) NOT NULL,
  `cust_email` varchar(255) NOT NULL,
  `cust_mobile` varchar(255) NOT NULL,
  `cust_gstno` varchar(55) NOT NULL,
  `cust_st_code` varchar(55) NOT NULL,
  `cust_st_name` varchar(255) NOT NULL,
  `cust_aadhar_no` varchar(55) NOT NULL,
  `cust_pan_no` varchar(55) NOT NULL,
  `po_no` varchar(255) NOT NULL,
  `po_date` varchar(55) NOT NULL,
  `challan_no` varchar(55) NOT NULL,
  `challan_date` varchar(55) NOT NULL,
  `lr_no` varchar(55) NOT NULL,
  `lr_dt` varchar(255) NOT NULL,
  `transporter_name` varchar(255) NOT NULL,
  `no_of_parcel` varchar(55) NOT NULL,
  `rsinwords` varchar(255) NOT NULL,
  `due_days` varchar(55) NOT NULL,
  `due_date` varchar(55) NOT NULL,
  `dpart` varchar(55) NOT NULL,
  `mpart` varchar(55) NOT NULL,
  `ypart` varchar(55) NOT NULL,
  `fyear` varchar(25) NOT NULL,
  `rec_amount` double(18,2) NOT NULL,
  `balance_amount` double(18,2) NOT NULL,
  `status` varchar(50) NOT NULL,
  `ch_amount` double(18,2) NOT NULL,
  `inv_type` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `invtotal_mst` (`inv_number`, `inv_date`, `total_qty`, `total_disc_amt`, `total_list_value`, `total_sales_val`, `total_sgstamt`, `total_cgstamt`, `total_igstamt`, `total_val`, `roundoff`, `total_inv_val`, `total_cost`, `tax_code`, `customer_code`, `customer_name`, `cust_address_one`, `cust_address_two`, `cust_address_three`, `cust_place`, `cust_phone`, `cust_pin_code`, `cust_email`, `cust_mobile`, `cust_gstno`, `cust_st_code`, `cust_st_name`, `cust_aadhar_no`, `cust_pan_no`, `po_no`, `po_date`, `challan_no`, `challan_date`, `lr_no`, `lr_dt`, `transporter_name`, `no_of_parcel`, `rsinwords`, `due_days`, `due_date`, `dpart`, `mpart`, `ypart`, `fyear`, `rec_amount`, `balance_amount`, `status`, `ch_amount`, `inv_type`) VALUES
('B2B- 1  (22-23)', '2022-04-27 13:28:50', 1000.00, 4278.00, 6900.00, 2622.00, 235.98, 235.98, 0.00, 3093.96, 0.04, 3094.00, 2520.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Three Thousand Ninety Four ', '30', '27/5/2022', '27', '04', '2022', '22-23', 0.00, 3094.00, 'PENDING', 0.00, 'INVOICE'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', 16000.00, 81995.00, 132250.00, 50255.00, 4522.95, 4522.95, 0.00, 59300.90, 0.10, 59301.00, 48260.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Fifty Nine Thousand Three Hundred One ', '30', '29/5/2022', '29', '04', '2022', '22-23', 0.00, 59301.00, 'PENDING', 0.00, 'INVOICE'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', 39000.00, 201345.00, 324750.00, 123405.00, 11106.45, 11106.45, 0.00, 145617.90, 0.10, 145618.00, 118530.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '30', '29/5/2022', '29', '04', '2022', '22-23', 0.00, 145618.00, 'PENDING', 0.00, 'INVOICE'),
('B2B- 4  (22-23)', '2022-04-30 13:04:52', 1000.00, 4278.00, 6900.00, 2622.00, 235.98, 235.98, 0.00, 3093.96, 0.04, 3094.00, 2520.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Three Thousand Ninety Four ', '30', '30/5/2022', '30', '04', '2022', '22-23', 0.00, 3094.00, 'PENDING', 0.00, 'INVOICE'),
('B2B- 5  (22-23)', '2022-05-08 16:22:46', 2000.00, 9052.00, 14600.00, 5548.00, 499.32, 499.32, 0.00, 6546.64, 0.36, 6547.00, 5330.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Six Thousand Five Hundred and Forty Seven ', '30', '7/6/2022', '08', '05', '2022', '22-23', 0.00, 6547.00, 'PENDING', 0.00, 'INVOICE'),
('B2B- 6  (22-23)', '2022-05-22 07:13:02', 2000.00, 9052.00, 14600.00, 5548.00, 499.32, 499.32, 0.00, 6546.64, 0.36, 6547.00, 5330.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Six Thousand Five Hundred and Forty Seven ', '30', '21/6/2022', '22', '05', '2022', '22-23', 0.00, 6547.00, 'PENDING', 0.00, 'INVOICE'),
('B2B- 7  (22-23)', '2022-05-24 13:48:22', 1000.00, 4347.00, 6900.00, 2553.00, 229.77, 229.77, 0.00, 3012.54, 0.46, 3013.00, 2520.00, 'GST-B2B', '1002', 'RADIANT TRADERS', '14, SPAN INDUSTRIAL COMPLEX,', 'NR. CANARA BANK,', 'GIDC - VATVA,', 'AHMEDABAD', '079-25835153', '382445', '-', '9426354834', '24ACLPP0047M1ZF', '24', 'Gujarat', '-', 'ACLPP0047M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Three Thousand Thirteen ', '60', '23/7/2022', '24', '05', '2022', '22-23', 0.00, 3013.00, 'PENDING', 0.00, 'INVOICE'),
('B2B- 8  (22-23)', '2022-05-24 13:59:34', 1000.00, 4278.00, 6900.00, 2622.00, 235.98, 235.98, 0.00, 3093.96, 0.04, 3094.00, 2520.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Three Thousand Ninety Four ', '30', '23/6/2022', '24', '05', '2022', '22-23', 0.00, 3094.00, 'PENDING', 0.00, 'INVOICE'),
('B2B- 9  (22-23)', '2022-06-22 13:45:49', 1000.00, 4774.00, 7700.00, 2926.00, 263.34, 263.34, 0.00, 3452.68, 0.32, 3453.00, 2810.00, 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '9408870888', '380021', '-', '9408870888', '24AFGPS4210M1ZE', '24', 'Gujarat', '-', 'AFGPS4210M', '-', '-', '-', '-', '-', '-', 'POOJA', '-', 'Three Thousand Four Hundred and Fifty Three ', '30', '22/7/2022', '22', '06', '2022', '22-23', 0.00, 3453.00, 'PENDING', 0.00, 'INVOICE'),
('B2C- 1  (22-23)', '2022-05-24 13:32:17', 2000.00, 0.00, 14600.00, 14600.00, 1314.00, 1314.00, 0.00, 17228.00, 0.00, 17228.00, 5330.00, 'GST-B2C', '1006', 'CASH BILL', '-', '-', '-', 'SURAT', '-', '-', '-', '-', '24', '24', 'Gujarat', '-', '-', '-', '-', '-', '-', '-', '-', '0', '-', 'Seventeen Thousand Two Hundred and Twenty Eight ', '0', '24/5/2022', '24', '05', '2022', '22-23', 0.00, 17228.00, 'PENDING', 0.00, 'INVOICE'),
('IGST- 1  (22-23)', '2022-04-27 13:28:03', 1000.00, 3795.00, 6900.00, 3105.00, 0.00, 0.00, 558.90, 3663.90, 0.10, 3664.00, 2520.00, 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '2668605 / 2669804', '396193', '-', '-', '26AAACD8469M1Z3', '26', 'Dadra and Nagar Haveli', '-', 'AAACD8469M', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', 'Three Thousand Six Hundred and Sixty Four ', '60', '26/6/2022', '27', '04', '2022', '22-23', 0.00, 3664.00, 'PENDING', 0.00, 'INVOICE'),
('IGST- 2  (22-23)', '2022-05-07 13:20:45', 1000.00, 3795.00, 6900.00, 3105.00, 0.00, 0.00, 558.90, 3663.90, 0.10, 3664.00, 2520.00, 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '2668605 / 2669804', '396193', '-', '-', '26AAACD8469M1Z3', '26', 'Dadra and Nagar Haveli', '-', 'AAACD8469M', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', 'Three Thousand Six Hundred and Sixty Four ', '60', '6/7/2022', '07', '05', '2022', '22-23', 0.00, 3664.00, 'PENDING', 0.00, 'INVOICE'),
('IGST- 3  (22-23)', '2022-05-22 07:14:03', 4000.00, 16280.00, 29600.00, 13320.00, 0.00, 0.00, 2397.60, 15717.60, 0.40, 15718.00, 10810.00, 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '2668605 / 2669804', '396193', '-', '-', '26AAACD8469M1Z3', '26', 'Dadra and Nagar Haveli', '-', 'AAACD8469M', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', 'Fifteen Thousand Seven Hundred Eighteen ', '60', '21/7/2022', '22', '05', '2022', '22-23', 0.00, 15718.00, 'PENDING', 0.00, 'INVOICE'),
('IGST- 4  (22-23)', '2022-06-22 14:30:02', 100.00, 159.75, 355.00, 195.25, 0.00, 0.00, 35.15, 230.40, -0.40, 230.00, 183.00, 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '2668605 / 2669804', '396193', '-', '-', '26AAACD8469M1Z3', '26', 'Dadra and Nagar Haveli', '-', 'AAACD8469M', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', 'Two Hundred Thirty ', '60', '21/8/2022', '22', '06', '2022', '22-23', 0.00, 230.00, 'PENDING', 0.00, 'INVOICE');

CREATE TABLE `inv_mst` (
  `inv_number` varchar(150) NOT NULL,
  `inv_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `partno` varchar(255) NOT NULL,
  `description_one` varchar(255) NOT NULL,
  `description_two` varchar(255) NOT NULL,
  `list` double(18,2) NOT NULL,
  `qty` double(18,2) NOT NULL,
  `disc_per` double(18,2) NOT NULL,
  `list_value` double(18,2) NOT NULL,
  `disc_amt` double(18,2) NOT NULL,
  `sales_val` double(18,2) NOT NULL,
  `sgst_per` double(18,2) NOT NULL,
  `sgst_amt` double(18,2) NOT NULL,
  `cgst_per` double(18,2) NOT NULL,
  `cgst_amt` double(18,2) NOT NULL,
  `igst_per` double(18,2) NOT NULL,
  `igst_amt` double(18,2) NOT NULL,
  `inv_val` double(18,2) NOT NULL,
  `cost` double(18,2) NOT NULL,
  `cost_val` double(18,2) NOT NULL,
  `rate_one` double(18,2) NOT NULL,
  `hsn_code` varchar(255) NOT NULL,
  `segment` varchar(255) NOT NULL,
  `tax_code` varchar(255) NOT NULL,
  `customer_code` varchar(255) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `cust_address_one` varchar(255) NOT NULL,
  `cust_address_two` varchar(255) NOT NULL,
  `cust_address_three` varchar(255) NOT NULL,
  `cust_place` varchar(255) NOT NULL,
  `cust_pin_code` varchar(255) NOT NULL,
  `cust_phone` varchar(255) NOT NULL,
  `cust_mobile` varchar(255) NOT NULL,
  `cust_email` varchar(255) NOT NULL,
  `cust_gstno` varchar(255) NOT NULL,
  `cust_pan_no` varchar(255) NOT NULL,
  `cust_aadhar_no` varchar(255) NOT NULL,
  `cust_st_code` varchar(255) NOT NULL,
  `cust_st_name` varchar(255) NOT NULL,
  `company_code` varchar(25) NOT NULL,
  `company_name` varchar(255) NOT NULL,
  `company_address_one` varchar(255) NOT NULL,
  `company_address_two` varchar(255) NOT NULL,
  `company_address_three` varchar(255) NOT NULL,
  `company_address_four` varchar(255) NOT NULL,
  `company_pin` varchar(255) NOT NULL,
  `company_place` varchar(255) NOT NULL,
  `company_mobile` varchar(255) NOT NULL,
  `company_phone` varchar(255) NOT NULL,
  `company_email` varchar(255) NOT NULL,
  `company_gstno` varchar(255) NOT NULL,
  `company_pan_no` varchar(255) NOT NULL,
  `company_aadhar_no` varchar(255) NOT NULL,
  `company_st_code` varchar(255) NOT NULL,
  `company_st_name` varchar(255) NOT NULL,
  `company_bank_name` varchar(255) NOT NULL,
  `company_bank_accno` varchar(255) NOT NULL,
  `company_ifsc_code` varchar(255) NOT NULL,
  `company_bank_address` varchar(255) NOT NULL,
  `po_no` varchar(255) NOT NULL,
  `po_date` varchar(255) NOT NULL,
  `challan_no` varchar(255) NOT NULL,
  `challan_date` varchar(255) NOT NULL,
  `lr_no` varchar(255) NOT NULL,
  `lr_dt` varchar(255) NOT NULL,
  `transporter_name` varchar(255) NOT NULL,
  `no_of_parcel` varchar(255) NOT NULL,
  `due_days` varchar(255) NOT NULL,
  `due_date` varchar(255) NOT NULL,
  `rsinwords` varchar(255) NOT NULL,
  `dpart` varchar(25) NOT NULL,
  `mpart` varchar(25) NOT NULL,
  `ypart` varchar(25) NOT NULL,
  `fyear` varchar(25) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `inv_mst` (`inv_number`, `inv_date`, `partno`, `description_one`, `description_two`, `list`, `qty`, `disc_per`, `list_value`, `disc_amt`, `sales_val`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `inv_val`, `cost`, `cost_val`, `rate_one`, `hsn_code`, `segment`, `tax_code`, `customer_code`, `customer_name`, `cust_address_one`, `cust_address_two`, `cust_address_three`, `cust_place`, `cust_pin_code`, `cust_phone`, `cust_mobile`, `cust_email`, `cust_gstno`, `cust_pan_no`, `cust_aadhar_no`, `cust_st_code`, `cust_st_name`, `company_code`, `company_name`, `company_address_one`, `company_address_two`, `company_address_three`, `company_address_four`, `company_pin`, `company_place`, `company_mobile`, `company_phone`, `company_email`, `company_gstno`, `company_pan_no`, `company_aadhar_no`, `company_st_code`, `company_st_name`, `company_bank_name`, `company_bank_accno`, `company_ifsc_code`, `company_bank_address`, `po_no`, `po_date`, `challan_no`, `challan_date`, `lr_no`, `lr_dt`, `transporter_name`, `no_of_parcel`, `due_days`, `due_date`, `rsinwords`, `dpart`, `mpart`, `ypart`, `fyear`) VALUES
('IGST- 1  (22-23)', '2022-04-27 13:28:03', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 55.00, 6900.00, 3795.00, 3105.00, 0.00, 0.00, 0.00, 0.00, 18.00, 558.90, 3663.90, 2.52, 2520.00, 3.79, '73181500', 'TVS-SOCKET', 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '396193', '2668605 / 2669804', '-', '-', '26AAACD8469M1Z3', 'AAACD8469M', '-', '26', 'Dadra and Nagar Haveli', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', '60', '26/6/2022', 'Three Thousand Six Hundred and Sixty Four ', '27', '04', '2022', '22-23'),
('B2B- 1  (22-23)', '2022-04-27 13:28:50', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 62.00, 6900.00, 4278.00, 2622.00, 9.00, 235.98, 9.00, 235.98, 0.00, 0.00, 3093.96, 2.52, 2520.00, 4.28, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '27/5/2022', 'Three Thousand Ninety Four ', '27', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316061010-0500', 'SHCSM6X1X10 GR 12.9', 'X', 5.05, 1000.00, 62.00, 5050.00, 3131.00, 1919.00, 9.00, 172.71, 9.00, 172.71, 0.00, 0.00, 2264.42, 1.84, 1840.00, 3.13, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316061012-0500', 'SHCSM6X1X12 GR 12.9', 'X', 5.95, 1000.00, 62.00, 5950.00, 3689.00, 2261.00, 9.00, 203.49, 9.00, 203.49, 0.00, 0.00, 2667.98, 2.17, 2170.00, 3.69, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316061016-0500', 'SHCSM6X1X16 GR 12.9', 'X', 5.70, 1000.00, 62.00, 5700.00, 3534.00, 2166.00, 9.00, 194.94, 9.00, 194.94, 0.00, 0.00, 2555.88, 2.08, 2080.00, 3.53, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316061020-0500', 'SHCSM6X1X20 GR 12.9', 'X', 5.95, 1000.00, 62.00, 5950.00, 3689.00, 2261.00, 9.00, 203.49, 9.00, 203.49, 0.00, 0.00, 2667.98, 2.17, 2170.00, 3.69, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316061025-0500', 'SHCSM6X1X25 GR 12.9', 'X', 6.60, 1000.00, 62.00, 6600.00, 4092.00, 2508.00, 9.00, 225.72, 9.00, 225.72, 0.00, 0.00, 2959.44, 2.41, 2410.00, 4.09, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316061030-0500', 'SHCSM6X1X30 GR 12.9', 'X', 7.50, 1000.00, 62.00, 7500.00, 4650.00, 2850.00, 9.00, 256.50, 9.00, 256.50, 0.00, 0.00, 3363.00, 2.74, 2740.00, 4.65, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082016-0500', 'SHCSM8X1.25X16 GR 12.9', 'X', 6.60, 1000.00, 62.00, 6600.00, 4092.00, 2508.00, 9.00, 225.72, 9.00, 225.72, 0.00, 0.00, 2959.44, 2.41, 2410.00, 4.09, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 62.00, 6900.00, 4278.00, 2622.00, 9.00, 235.98, 9.00, 235.98, 0.00, 0.00, 3093.96, 2.52, 2520.00, 4.28, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082025-0500', 'SHCSM8X1.25X25 GR 12.9', 'X', 7.70, 1000.00, 62.00, 7700.00, 4774.00, 2926.00, 9.00, 263.34, 9.00, 263.34, 0.00, 0.00, 3452.68, 2.81, 2810.00, 4.77, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082030-0500', 'SHCSM8X1.25X30 GR 12.9', 'X', 8.40, 1000.00, 62.00, 8400.00, 5208.00, 3192.00, 9.00, 287.28, 9.00, 287.28, 0.00, 0.00, 3766.56, 3.07, 3070.00, 5.21, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082035-0500', 'SHCSM8X1.25X35 GR 12.9', 'X', 9.15, 1000.00, 62.00, 9150.00, 5673.00, 3477.00, 9.00, 312.93, 9.00, 312.93, 0.00, 0.00, 4102.86, 3.34, 3340.00, 5.67, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082040-0500', 'SHCSM8X1.25X40 GR 12.9', 'X', 9.90, 1000.00, 62.00, 9900.00, 6138.00, 3762.00, 9.00, 338.58, 9.00, 338.58, 0.00, 0.00, 4439.16, 3.61, 3610.00, 6.14, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082045-0500', 'SHCSM8X1.25X45 GR 12.9', 'X', 10.60, 1000.00, 62.00, 10600.00, 6572.00, 4028.00, 9.00, 362.52, 9.00, 362.52, 0.00, 0.00, 4753.04, 3.87, 3870.00, 6.57, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082050-0500', 'SHCSM8X1.25X50 GR 12.9', 'X', 11.05, 1000.00, 62.00, 11050.00, 6851.00, 4199.00, 9.00, 377.91, 9.00, 377.91, 0.00, 0.00, 4954.82, 4.03, 4030.00, 6.85, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082055-0500', 'SHCSM8X1.25X55 GR 12.9', 'X', 12.15, 1000.00, 62.00, 12150.00, 7533.00, 4617.00, 9.00, 415.53, 9.00, 415.53, 0.00, 0.00, 5448.06, 4.43, 4430.00, 7.53, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 2  (22-23)', '2022-04-29 04:56:41', '316082060-0500', 'SHCSM8X1.25X60 GR 12.9', 'X', 13.05, 1000.00, 62.00, 13050.00, 8091.00, 4959.00, 9.00, 446.31, 9.00, 446.31, 0.00, 0.00, 5851.62, 4.76, 4760.00, 8.09, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'Fifty Nine Thousand Three Hundred One ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316041010-0500', 'SHCSM4X0.7X10 GR 12.9', 'X', 6.65, 1000.00, 62.00, 6650.00, 4123.00, 2527.00, 9.00, 227.43, 9.00, 227.43, 0.00, 0.00, 2981.86, 2.43, 2430.00, 4.12, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316041012-0500', 'SHCSM4X0.7X12 GR 12.9', 'X', 6.05, 1000.00, 62.00, 6050.00, 3751.00, 2299.00, 9.00, 206.91, 9.00, 206.91, 0.00, 0.00, 2712.82, 2.21, 2210.00, 3.75, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316041016-0500', 'SHCSM4X0.7X16 GR 12.9', 'X', 5.10, 1000.00, 62.00, 5100.00, 3162.00, 1938.00, 9.00, 174.42, 9.00, 174.42, 0.00, 0.00, 2286.84, 1.86, 1860.00, 3.16, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316041020-0500', 'SHCSM4X0.7X20 GR 12.9', 'X', 5.45, 1000.00, 62.00, 5450.00, 3379.00, 2071.00, 9.00, 186.39, 9.00, 186.39, 0.00, 0.00, 2443.78, 1.99, 1990.00, 3.38, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316041025-0500', 'SHCSM4X0.7X25 GR 12.9', 'X', 5.65, 1000.00, 62.00, 5650.00, 3503.00, 2147.00, 9.00, 193.23, 9.00, 193.23, 0.00, 0.00, 2533.46, 2.06, 2060.00, 3.50, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316041030-0500', 'SHCSM4X0.7X30 GR 12.9', 'X', 8.25, 1000.00, 62.00, 8250.00, 5115.00, 3135.00, 9.00, 282.15, 9.00, 282.15, 0.00, 0.00, 3699.30, 3.01, 3010.00, 5.12, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316051010-0500', 'SHCSM5X0.8X10 GR 12.9', 'X', 4.85, 1000.00, 62.00, 4850.00, 3007.00, 1843.00, 9.00, 165.87, 9.00, 165.87, 0.00, 0.00, 2174.74, 1.77, 1770.00, 3.01, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316051012-0500', 'SHCSM5X0.8X12 GR 12.9', 'X', 4.90, 1000.00, 62.00, 4900.00, 3038.00, 1862.00, 9.00, 167.58, 9.00, 167.58, 0.00, 0.00, 2197.16, 1.79, 1790.00, 3.04, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316051016-0500', 'SHCSM5X0.8X16 GR 12.9', 'X', 5.55, 1000.00, 62.00, 5550.00, 3441.00, 2109.00, 9.00, 189.81, 9.00, 189.81, 0.00, 0.00, 2488.62, 2.03, 2030.00, 3.44, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316051020-0500', 'SHCSM5X0.8X20 GR 12.9', 'X', 5.10, 1000.00, 62.00, 5100.00, 3162.00, 1938.00, 9.00, 174.42, 9.00, 174.42, 0.00, 0.00, 2286.84, 1.86, 1860.00, 3.16, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316051025-0500', 'SHCS5X0.8X25 GR 12.9', 'X', 6.30, 1000.00, 62.00, 6300.00, 3906.00, 2394.00, 9.00, 215.46, 9.00, 215.46, 0.00, 0.00, 2824.92, 2.30, 2300.00, 3.91, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061010-0500', 'SHCSM6X1X10 GR 12.9', 'X', 5.05, 1000.00, 62.00, 5050.00, 3131.00, 1919.00, 9.00, 172.71, 9.00, 172.71, 0.00, 0.00, 2264.42, 1.84, 1840.00, 3.13, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061012-0500', 'SHCSM6X1X12 GR 12.9', 'X', 5.95, 1000.00, 62.00, 5950.00, 3689.00, 2261.00, 9.00, 203.49, 9.00, 203.49, 0.00, 0.00, 2667.98, 2.17, 2170.00, 3.69, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061016-0500', 'SHCSM6X1X16 GR 12.9', 'X', 5.70, 1000.00, 62.00, 5700.00, 3534.00, 2166.00, 9.00, 194.94, 9.00, 194.94, 0.00, 0.00, 2555.88, 2.08, 2080.00, 3.53, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061020-0500', 'SHCSM6X1X20 GR 12.9', 'X', 5.95, 1000.00, 62.00, 5950.00, 3689.00, 2261.00, 9.00, 203.49, 9.00, 203.49, 0.00, 0.00, 2667.98, 2.17, 2170.00, 3.69, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061025-0500', 'SHCSM6X1X25 GR 12.9', 'X', 6.60, 1000.00, 62.00, 6600.00, 4092.00, 2508.00, 9.00, 225.72, 9.00, 225.72, 0.00, 0.00, 2959.44, 2.41, 2410.00, 4.09, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061030-0500', 'SHCSM6X1X30 GR 12.9', 'X', 7.50, 1000.00, 62.00, 7500.00, 4650.00, 2850.00, 9.00, 256.50, 9.00, 256.50, 0.00, 0.00, 3363.00, 2.74, 2740.00, 4.65, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061030-0500', 'SHCSM6X1X30 GR 12.9', 'X', 7.50, 1000.00, 62.00, 7500.00, 4650.00, 2850.00, 9.00, 256.50, 9.00, 256.50, 0.00, 0.00, 3363.00, 2.74, 2740.00, 4.65, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061035-0500', 'SHCSM6X1X35 GR 12.9', 'X', 8.15, 1000.00, 62.00, 8150.00, 5053.00, 3097.00, 9.00, 278.73, 9.00, 278.73, 0.00, 0.00, 3654.46, 2.97, 2970.00, 5.05, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316061040-0500', 'SHCSM6X1X40 GR 12.9', 'X', 8.80, 1000.00, 62.00, 8800.00, 5456.00, 3344.00, 9.00, 300.96, 9.00, 300.96, 0.00, 0.00, 3945.92, 3.21, 3210.00, 5.46, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082010-0500', 'SHCSM8X1.25X10 GR 12.9', 'X', 9.90, 1000.00, 62.00, 9900.00, 6138.00, 3762.00, 9.00, 338.58, 9.00, 338.58, 0.00, 0.00, 4439.16, 3.61, 3610.00, 6.14, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082012-0500', 'SHCSM8X1.25X12 GR 12.9', 'X', 7.55, 1000.00, 62.00, 7550.00, 4681.00, 2869.00, 9.00, 258.21, 9.00, 258.21, 0.00, 0.00, 3385.42, 2.76, 2760.00, 4.68, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082016-0500', 'SHCSM8X1.25X16 GR 12.9', 'X', 6.60, 1000.00, 62.00, 6600.00, 4092.00, 2508.00, 9.00, 225.72, 9.00, 225.72, 0.00, 0.00, 2959.44, 2.41, 2410.00, 4.09, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 62.00, 6900.00, 4278.00, 2622.00, 9.00, 235.98, 9.00, 235.98, 0.00, 0.00, 3093.96, 2.52, 2520.00, 4.28, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082025-0500', 'SHCSM8X1.25X25 GR 12.9', 'X', 7.70, 1000.00, 62.00, 7700.00, 4774.00, 2926.00, 9.00, 263.34, 9.00, 263.34, 0.00, 0.00, 3452.68, 2.81, 2810.00, 4.77, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082030-0500', 'SHCSM8X1.25X30 GR 12.9', 'X', 8.40, 1000.00, 62.00, 8400.00, 5208.00, 3192.00, 9.00, 287.28, 9.00, 287.28, 0.00, 0.00, 3766.56, 3.07, 3070.00, 5.21, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082035-0500', 'SHCSM8X1.25X35 GR 12.9', 'X', 9.15, 1000.00, 62.00, 9150.00, 5673.00, 3477.00, 9.00, 312.93, 9.00, 312.93, 0.00, 0.00, 4102.86, 3.34, 3340.00, 5.67, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082040-0500', 'SHCSM8X1.25X40 GR 12.9', 'X', 9.90, 1000.00, 62.00, 9900.00, 6138.00, 3762.00, 9.00, 338.58, 9.00, 338.58, 0.00, 0.00, 4439.16, 3.61, 3610.00, 6.14, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082045-0500', 'SHCSM8X1.25X45 GR 12.9', 'X', 10.60, 1000.00, 62.00, 10600.00, 6572.00, 4028.00, 9.00, 362.52, 9.00, 362.52, 0.00, 0.00, 4753.04, 3.87, 3870.00, 6.57, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082050-0500', 'SHCSM8X1.25X50 GR 12.9', 'X', 11.05, 1000.00, 62.00, 11050.00, 6851.00, 4199.00, 9.00, 377.91, 9.00, 377.91, 0.00, 0.00, 4954.82, 4.03, 4030.00, 6.85, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082055-0500', 'SHCSM8X1.25X55 GR 12.9', 'X', 12.15, 1000.00, 62.00, 12150.00, 7533.00, 4617.00, 9.00, 415.53, 9.00, 415.53, 0.00, 0.00, 5448.06, 4.43, 4430.00, 7.53, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316082060-0500', 'SHCSM8X1.25X60 GR 12.9', 'X', 13.05, 1000.00, 62.00, 13050.00, 8091.00, 4959.00, 9.00, 446.31, 9.00, 446.31, 0.00, 0.00, 5851.62, 4.76, 4760.00, 8.09, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316103020-0500', 'SHCSM10X1.5X20 GR 12.9', 'X', 9.55, 1000.00, 62.00, 9550.00, 5921.00, 3629.00, 9.00, 326.61, 9.00, 326.61, 0.00, 0.00, 4282.22, 3.49, 3490.00, 5.92, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316103025-0500', 'SHCSM10X1.5X25 GR 12.9', 'X', 10.45, 1000.00, 62.00, 10450.00, 6479.00, 3971.00, 9.00, 357.39, 9.00, 357.39, 0.00, 0.00, 4685.78, 3.81, 3810.00, 6.48, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316103030-0500', 'SHCSM10X1.5X30 GR 12.9', 'X', 11.50, 1000.00, 62.00, 11500.00, 7130.00, 4370.00, 9.00, 393.30, 9.00, 393.30, 0.00, 0.00, 5156.60, 4.20, 4200.00, 7.13, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316103035-0500', 'SHCSM10X1.5X35 GR 12.9', 'X', 12.45, 1000.00, 62.00, 12450.00, 7719.00, 4731.00, 9.00, 425.79, 9.00, 425.79, 0.00, 0.00, 5582.58, 4.54, 4540.00, 7.72, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316103040-0500', 'SHCSM10X1.5X40 GR 12.9', 'X', 13.25, 1000.00, 62.00, 13250.00, 8215.00, 5035.00, 9.00, 453.15, 9.00, 453.15, 0.00, 0.00, 5941.30, 4.84, 4840.00, 8.21, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316103045-0500', 'SHCSM10X1.5X45 GR 12.9', 'X', 14.30, 1000.00, 62.00, 14300.00, 8866.00, 5434.00, 9.00, 489.06, 9.00, 489.06, 0.00, 0.00, 6412.12, 5.22, 5220.00, 8.87, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23'),
('B2B- 3  (22-23)', '2022-04-29 10:12:21', '316103050-0500', 'SHCSM10X1.5X50 GR 12.9', 'X', 15.25, 1000.00, 62.00, 15250.00, 9455.00, 5795.00, 9.00, 521.55, 9.00, 521.55, 0.00, 0.00, 6838.10, 5.57, 5570.00, 9.46, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '29/5/2022', 'One Lakhs Forty Five Thousand Six Hundred Eighteen ', '29', '04', '2022', '22-23');
INSERT INTO `inv_mst` (`inv_number`, `inv_date`, `partno`, `description_one`, `description_two`, `list`, `qty`, `disc_per`, `list_value`, `disc_amt`, `sales_val`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `inv_val`, `cost`, `cost_val`, `rate_one`, `hsn_code`, `segment`, `tax_code`, `customer_code`, `customer_name`, `cust_address_one`, `cust_address_two`, `cust_address_three`, `cust_place`, `cust_pin_code`, `cust_phone`, `cust_mobile`, `cust_email`, `cust_gstno`, `cust_pan_no`, `cust_aadhar_no`, `cust_st_code`, `cust_st_name`, `company_code`, `company_name`, `company_address_one`, `company_address_two`, `company_address_three`, `company_address_four`, `company_pin`, `company_place`, `company_mobile`, `company_phone`, `company_email`, `company_gstno`, `company_pan_no`, `company_aadhar_no`, `company_st_code`, `company_st_name`, `company_bank_name`, `company_bank_accno`, `company_ifsc_code`, `company_bank_address`, `po_no`, `po_date`, `challan_no`, `challan_date`, `lr_no`, `lr_dt`, `transporter_name`, `no_of_parcel`, `due_days`, `due_date`, `rsinwords`, `dpart`, `mpart`, `ypart`, `fyear`) VALUES
('B2B- 4  (22-23)', '2022-04-30 13:04:52', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 62.00, 6900.00, 4278.00, 2622.00, 9.00, 235.98, 9.00, 235.98, 0.00, 0.00, 3093.96, 2.52, 2520.00, 4.28, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '30/5/2022', 'Three Thousand Ninety Four ', '30', '04', '2022', '22-23'),
('IGST- 2  (22-23)', '2022-05-07 13:20:45', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 55.00, 6900.00, 3795.00, 3105.00, 0.00, 0.00, 0.00, 0.00, 18.00, 558.90, 3663.90, 2.52, 2520.00, 3.79, '73181500', 'TVS-SOCKET', 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '396193', '2668605 / 2669804', '-', '-', '26AAACD8469M1Z3', 'AAACD8469M', '-', '26', 'Dadra and Nagar Haveli', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', '60', '6/7/2022', 'Three Thousand Six Hundred and Sixty Four ', '07', '05', '2022', '22-23'),
('B2B- 5  (22-23)', '2022-05-08 16:22:46', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 62.00, 6900.00, 4278.00, 2622.00, 9.00, 235.98, 9.00, 235.98, 0.00, 0.00, 3093.96, 2.52, 2520.00, 4.28, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '7/6/2022', 'Six Thousand Five Hundred and Forty Seven ', '08', '05', '2022', '22-23'),
('B2B- 5  (22-23)', '2022-05-08 16:22:46', '316082025-0500', 'SHCSM8X1.25X25 GR 12.9', 'X', 7.70, 1000.00, 62.00, 7700.00, 4774.00, 2926.00, 9.00, 263.34, 9.00, 263.34, 0.00, 0.00, 3452.68, 2.81, 2810.00, 4.77, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '7/6/2022', 'Six Thousand Five Hundred and Forty Seven ', '08', '05', '2022', '22-23'),
('B2B- 6  (22-23)', '2022-05-22 07:13:02', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 62.00, 6900.00, 4278.00, 2622.00, 9.00, 235.98, 9.00, 235.98, 0.00, 0.00, 3093.96, 2.52, 2520.00, 4.28, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '21/6/2022', 'Six Thousand Five Hundred and Forty Seven ', '22', '05', '2022', '22-23'),
('B2B- 6  (22-23)', '2022-05-22 07:13:02', '316082025-0500', 'SHCSM8X1.25X25 GR 12.9', 'X', 7.70, 1000.00, 62.00, 7700.00, 4774.00, 2926.00, 9.00, 263.34, 9.00, 263.34, 0.00, 0.00, 3452.68, 2.81, 2810.00, 4.77, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '21/6/2022', 'Six Thousand Five Hundred and Forty Seven ', '22', '05', '2022', '22-23'),
('IGST- 3  (22-23)', '2022-05-22 07:14:03', '316082016-0500', 'SHCSM8X1.25X16 GR 12.9', 'X', 6.60, 1000.00, 55.00, 6600.00, 3630.00, 2970.00, 0.00, 0.00, 0.00, 0.00, 18.00, 534.60, 3504.60, 2.41, 2410.00, 3.63, '73181500', 'TVS-SOCKET', 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '396193', '2668605 / 2669804', '-', '-', '26AAACD8469M1Z3', 'AAACD8469M', '-', '26', 'Dadra and Nagar Haveli', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', '60', '21/7/2022', 'Fifteen Thousand Seven Hundred Eighteen ', '22', '05', '2022', '22-23'),
('IGST- 3  (22-23)', '2022-05-22 07:14:03', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 55.00, 6900.00, 3795.00, 3105.00, 0.00, 0.00, 0.00, 0.00, 18.00, 558.90, 3663.90, 2.52, 2520.00, 3.79, '73181500', 'TVS-SOCKET', 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '396193', '2668605 / 2669804', '-', '-', '26AAACD8469M1Z3', 'AAACD8469M', '-', '26', 'Dadra and Nagar Haveli', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', '60', '21/7/2022', 'Fifteen Thousand Seven Hundred Eighteen ', '22', '05', '2022', '22-23'),
('IGST- 3  (22-23)', '2022-05-22 07:14:03', '316082025-0500', 'SHCSM8X1.25X25 GR 12.9', 'X', 7.70, 1000.00, 55.00, 7700.00, 4235.00, 3465.00, 0.00, 0.00, 0.00, 0.00, 18.00, 623.70, 4088.70, 2.81, 2810.00, 4.24, '73181500', 'TVS-SOCKET', 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '396193', '2668605 / 2669804', '-', '-', '26AAACD8469M1Z3', 'AAACD8469M', '-', '26', 'Dadra and Nagar Haveli', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', '60', '21/7/2022', 'Fifteen Thousand Seven Hundred Eighteen ', '22', '05', '2022', '22-23'),
('IGST- 3  (22-23)', '2022-05-22 07:14:03', '316082030-0500', 'SHCSM8X1.25X30 GR 12.9', 'X', 8.40, 1000.00, 55.00, 8400.00, 4620.00, 3780.00, 0.00, 0.00, 0.00, 0.00, 18.00, 680.40, 4460.40, 3.07, 3070.00, 4.62, '73181500', 'TVS-SOCKET', 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '396193', '2668605 / 2669804', '-', '-', '26AAACD8469M1Z3', 'AAACD8469M', '-', '26', 'Dadra and Nagar Haveli', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', '60', '21/7/2022', 'Fifteen Thousand Seven Hundred Eighteen ', '22', '05', '2022', '22-23'),
('B2C- 1  (22-23)', '2022-05-24 13:32:17', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 0.00, 6900.00, 0.00, 6900.00, 9.00, 621.00, 9.00, 621.00, 0.00, 0.00, 8142.00, 2.52, 2520.00, 0.00, '73181500', 'TVS-SOCKET', 'GST-B2C', '1006', 'CASH BILL', '-', '-', '-', 'SURAT', '-', '-', '-', '-', '24', '-', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', '0', '-', '0', '24/5/2022', 'Seventeen Thousand Two Hundred and Twenty Eight ', '24', '05', '2022', '22-23'),
('B2C- 1  (22-23)', '2022-05-24 13:32:17', '316082025-0500', 'SHCSM8X1.25X25 GR 12.9', 'X', 7.70, 1000.00, 0.00, 7700.00, 0.00, 7700.00, 9.00, 693.00, 9.00, 693.00, 0.00, 0.00, 9086.00, 2.81, 2810.00, 0.00, '73181500', 'TVS-SOCKET', 'GST-B2C', '1006', 'CASH BILL', '-', '-', '-', 'SURAT', '-', '-', '-', '-', '24', '-', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', '0', '-', '0', '24/5/2022', 'Seventeen Thousand Two Hundred and Twenty Eight ', '24', '05', '2022', '22-23'),
('B2B- 7  (22-23)', '2022-05-24 13:48:22', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 63.00, 6900.00, 4347.00, 2553.00, 9.00, 229.77, 9.00, 229.77, 0.00, 0.00, 3012.54, 2.52, 2520.00, 4.35, '73181500', 'TVS-SOCKET', 'GST-B2B', '1002', 'RADIANT TRADERS', '14, SPAN INDUSTRIAL COMPLEX,', 'NR. CANARA BANK,', 'GIDC - VATVA,', 'AHMEDABAD', '382445', '079-25835153', '9426354834', '-', '24ACLPP0047M1ZF', 'ACLPP0047M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '60', '23/7/2022', 'Three Thousand Thirteen ', '24', '05', '2022', '22-23'),
('B2B- 8  (22-23)', '2022-05-24 13:59:34', '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', 6.90, 1000.00, 62.00, 6900.00, 4278.00, 2622.00, 9.00, 235.98, 9.00, 235.98, 0.00, 0.00, 3093.96, 2.52, 2520.00, 4.28, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '23/6/2022', 'Three Thousand Ninety Four ', '24', '05', '2022', '22-23'),
('B2B- 9  (22-23)', '2022-06-22 13:45:49', '316082025-0500', 'SHCSM8X1.25X25 GR 12.9', 'X', 7.70, 1000.00, 62.00, 7700.00, 4774.00, 2926.00, 9.00, 263.34, 9.00, 263.34, 0.00, 0.00, 3452.68, 2.81, 2810.00, 4.77, '73181500', 'TVS-SOCKET', 'GST-B2B', '1001', 'AMIT TRADING CO', 'NO.10, PARSHVANATH ESTATE,', 'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,', 'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,', 'AHMEDABAD', '380021', '9408870888', '9408870888', '-', '24AFGPS4210M1ZE', 'AFGPS4210M', '-', '24', 'Gujarat', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'POOJA', '-', '30', '22/7/2022', 'Three Thousand Four Hundred and Fifty Three ', '22', '06', '2022', '22-23'),
('IGST- 4  (22-23)', '2022-06-22 14:30:02', '115082020-0200', 'HHSM8X1.25X20 GR 10.9', 'X', 3.55, 100.00, 45.00, 355.00, 159.75, 195.25, 0.00, 0.00, 0.00, 0.00, 18.00, 35.15, 230.40, 1.83, 183.00, 1.60, '73181500', 'TVS-HEX', 'I-GST', '1003', 'ALIDHRA TEXTOOLS ENGINEERS PVT.LTD-DADRA', 'PLOT NO.122/5 & 119/2, VAGHDHARA ROAD', 'UT OF DADRA & NAGAR HAVELI', 'DADRA', 'DADRA', '396193', '2668605 / 2669804', '-', '-', '26AAACD8469M1Z3', 'AAACD8469M', '-', '26', 'Dadra and Nagar Haveli', 'SSC19', 'VENSOFT', 'EF-203, 2ND FLOOR, SARATI AVENUE', 'CHALTHAN', 'SURAT', 'SURAT', '394305', 'SURAT', '9377811610', '-', 'venkat1610@gmail.com', '24', '-', '-', '24', 'GUJARAT', 'HDFC', '-', '-', '-', '-', '-', '-', '-', '-', '-', 'PATHAK', '-', '60', '21/8/2022', 'Two Hundred Thirty ', '22', '06', '2022', '22-23');

-- --------------------------------------------------------

--
-- Table structure for table `item_mst`
--

CREATE TABLE `item_mst` (
  `id` int(10) UNSIGNED NOT NULL,
  `partno` varchar(250) NOT NULL,
  `description_one` varchar(250) DEFAULT NULL,
  `description_two` varchar(250) DEFAULT NULL,
  `hsn_code` varchar(45) DEFAULT NULL,
  `list` double(18,2) DEFAULT NULL,
  `moq` double(18,2) NOT NULL,
  `boxqty` double(18,2) DEFAULT NULL,
  `cost` double(18,3) DEFAULT NULL,
  `disc_per` double(18,2) DEFAULT NULL,
  `disc_amt` double(18,2) DEFAULT NULL,
  `mrp` double(18,2) DEFAULT NULL,
  `sgst_per` double(18,2) DEFAULT NULL,
  `sgst_amt` double(18,2) DEFAULT NULL,
  `cgst_per` double(18,2) DEFAULT NULL,
  `cgst_amt` double(18,2) DEFAULT NULL,
  `igst_per` double(18,2) DEFAULT NULL,
  `igst_amt` double(18,2) DEFAULT NULL,
  `op_stk` double(18,2) DEFAULT NULL,
  `stk_qty` double(18,2) DEFAULT NULL,
  `stk_val` double(18,2) DEFAULT NULL,
  `unit` varchar(150) DEFAULT NULL,
  `ly_sales` double(18,2) DEFAULT NULL,
  `cy_sales` double(18,2) DEFAULT NULL,
  `pending` double(18,2) DEFAULT NULL,
  `dispatch1` double(18,2) DEFAULT NULL,
  `min_qty` double(18,2) DEFAULT NULL,
  `max_qty` double(18,2) DEFAULT NULL,
  `reord_qty` double(18,2) DEFAULT NULL,
  `segment` varchar(250) DEFAULT NULL,
  `remarks` varchar(250) DEFAULT NULL,
  `rec_qty` double(18,2) NOT NULL,
  `bal_qty` decimal(18,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Dumping data for table `item_mst`
--

INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(1, '070000150-0500', 'KEY1.5MM STD', 'X', '82042000', 8.75, 300.00, 100.00, 3.190, 63.50, 5.56, 10.50, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 4500.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '4500.00'),
(2, '070000200-0500', 'KEY2MM STD', 'X', '82042000', 8.75, 300.00, 100.00, 3.190, 63.50, 5.56, 10.50, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 1800.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '1800.00'),
(3, '070000250-0500', 'KEY2.5MM STD', 'X', '82042000', 7.00, 200.00, 100.00, 2.560, 63.50, 4.45, 8.40, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 1000.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '1000.00'),
(4, '070000300-0500', 'KEY3MM STD', 'X', '82042000', 7.00, 800.00, 100.00, 2.560, 63.50, 4.45, 8.40, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 3200.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '3200.00'),
(5, '070000400-0500', 'KEY4MM STD', 'X', '82042000', 13.90, 800.00, 100.00, 5.070, 63.50, 8.83, 16.68, 9.00, 0.46, 9.00, 0.46, 18.00, 0.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 2400.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '2400.00'),
(6, '070000500-0500', 'KEY5MM STD', 'X', '82042000', 18.00, 300.00, 100.00, 6.570, 63.50, 11.43, 21.60, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 900.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '900.00'),
(7, '070000600-0500', 'KEY6MM STD', 'X', '82042000', 23.90, 400.00, 50.00, 8.720, 63.50, 15.18, 28.68, 9.00, 0.79, 9.00, 0.79, 18.00, 1.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(8, '070000700-0500', 'KEY7MM STD', 'X', '82042000', 71.55, 200.00, 25.00, 26.120, 63.50, 45.43, 85.86, 9.00, 2.35, 9.00, 2.35, 18.00, 4.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(9, '070000800-0500', 'KEY8MM STD', 'X', '82042000', 43.75, 200.00, 25.00, 15.970, 63.50, 27.78, 52.50, 9.00, 1.44, 9.00, 1.44, 18.00, 2.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(10, '070000900-0500', 'KEY9MM STD', 'X', '82042000', 111.90, 100.00, 25.00, 40.840, 63.50, 71.06, 134.28, 9.00, 3.68, 9.00, 3.68, 18.00, 7.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(11, '070001000-0500', 'KEY10MM STD', 'X', '82042000', 71.55, 75.00, 25.00, 26.120, 63.50, 45.43, 85.86, 9.00, 2.35, 9.00, 2.35, 18.00, 4.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 75.00, 75.00, 75.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(12, '070001200-0500', 'KEY12MM STD', 'X', '82042000', 111.90, 30.00, 10.00, 40.840, 63.50, 71.06, 134.28, 9.00, 3.68, 9.00, 3.68, 18.00, 7.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(13, '070001400-0500', 'KEY14MM STD', 'X', '82042000', 159.50, 30.00, 10.00, 58.220, 63.50, 101.28, 191.40, 9.00, 5.24, 9.00, 5.24, 18.00, 10.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(14, '070001700-0500', 'KEY17MM STD', 'X', '82042000', 271.50, 20.00, 10.00, 99.100, 63.50, 172.40, 325.80, 9.00, 8.92, 9.00, 8.92, 18.00, 17.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(15, '070001900-0500', 'KEY19MM STD', 'X', '82042000', 374.65, 10.00, 5.00, 136.750, 63.50, 237.90, 449.58, 9.00, 12.31, 9.00, 12.31, 18.00, 24.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(16, '070002200-0500', 'KEY22MM STD', 'X', '82042000', 654.85, 5.00, 5.00, 239.020, 63.50, 415.83, 785.82, 9.00, 21.51, 9.00, 21.51, 18.00, 43.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(17, '070002400-0500', 'KEY24MM STD', 'X', '82042000', 846.40, 5.00, 5.00, 308.940, 63.50, 537.46, 1015.68, 9.00, 27.80, 9.00, 27.80, 18.00, 55.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(18, '070002700-0500', 'KEY27MM STD', 'X', '82042000', 1480.45, 5.00, 5.00, 540.360, 63.50, 940.09, 1776.54, 9.00, 48.63, 9.00, 48.63, 18.00, 97.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(19, '070003200-0500', 'KEY32MM STD', 'X', '82042000', 2603.65, 2.00, 2.00, 950.330, 63.50, 1653.32, 3124.38, 9.00, 85.53, 9.00, 85.53, 18.00, 171.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(20, '070003600-0500', 'KEY36MM STD', 'X', '82042000', 3957.20, 2.00, 2.00, 1444.380, 63.50, 2512.82, 4748.64, 9.00, 129.99, 9.00, 129.99, 18.00, 259.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(21, '071000150-0500', 'KEY1.5MM LONG', 'X', '82042000', 14.55, 50.00, 25.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(22, '071000200-0500', 'KEY2MM LONG', 'X', '82042000', 16.40, 50.00, 25.00, 5.990, 63.50, 10.41, 19.68, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(23, '071000250-0500', 'KEY2.5MM LONG', 'X', '82042000', 16.40, 50.00, 25.00, 5.990, 63.50, 10.41, 19.68, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(24, '071000300-0500', 'KEY3MM LONG', 'X', '82042000', 16.40, 100.00, 25.00, 5.990, 63.50, 10.41, 19.68, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(25, '071000400-0500', 'KEY4MM LONG', 'X', '82042000', 25.35, 30.00, 10.00, 9.250, 63.50, 16.10, 30.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(26, '071000500-0500', 'KEY5MM LONG', 'X', '82042000', 31.50, 30.00, 10.00, 11.500, 63.50, 20.00, 37.80, 9.00, 1.03, 9.00, 1.03, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(27, '071000600-0500', 'KEY6MM LONG', 'X', '82042000', 39.50, 15.00, 5.00, 14.420, 63.50, 25.08, 47.40, 9.00, 1.30, 9.00, 1.30, 18.00, 2.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(28, '071000800-0500', 'KEY8MM LONG', 'X', '82042000', 54.85, 10.00, 5.00, 20.020, 63.50, 34.83, 65.82, 9.00, 1.80, 9.00, 1.80, 18.00, 3.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(29, '071001000-0500', 'KEY10MM LONG', 'X', '82042000', 104.45, 10.00, 5.00, 38.120, 63.50, 66.33, 125.34, 9.00, 3.43, 9.00, 3.43, 18.00, 6.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(30, '071010500-0500', 'KEY5MM LONG', 'X', '82042000', 30.80, 15.00, 5.00, 11.240, 63.50, 19.56, 36.96, 9.00, 1.01, 9.00, 1.01, 18.00, 2.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(31, '072000150-0500', 'KEY1.5MM T HANDLE LONG', 'X', '82042000', 29.05, 50.00, 25.00, 10.600, 63.50, 18.45, 34.86, 9.00, 0.95, 9.00, 0.95, 18.00, 1.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(32, '072000200-0500', 'KEY2MM T HANDLE LONG', 'X', '82042000', 32.65, 50.00, 25.00, 11.920, 63.50, 20.73, 39.18, 9.00, 1.07, 9.00, 1.07, 18.00, 2.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(33, '072000250-0500', 'KEY2.5MM T HANDLE LONG', 'X', '82042000', 32.65, 50.00, 25.00, 11.920, 63.50, 20.73, 39.18, 9.00, 1.07, 9.00, 1.07, 18.00, 2.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(34, '072000300-0500', 'KEY3MM T HANDLE LONG', 'X', '82042000', 32.65, 50.00, 25.00, 11.920, 63.50, 20.73, 39.18, 9.00, 1.07, 9.00, 1.07, 18.00, 2.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(35, '072000400-0500', 'KEY4MM T HANDLE LONG', 'X', '82042000', 38.05, 30.00, 10.00, 13.890, 63.50, 24.16, 45.66, 9.00, 1.25, 9.00, 1.25, 18.00, 2.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(36, '072000500-0500', 'KEY5MM T HANDLE LONG', 'X', '82042000', 44.15, 20.00, 10.00, 16.110, 63.50, 28.04, 52.98, 9.00, 1.45, 9.00, 1.45, 18.00, 2.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(37, '072000600-0500', 'KEY6MM T HANDLE LONG', 'X', '82042000', 59.40, 20.00, 10.00, 21.680, 63.50, 37.72, 71.28, 9.00, 1.95, 9.00, 1.95, 18.00, 3.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(38, '072000800-0500', 'KEY8MM T HANDLE LONG', 'X', '82042000', 80.15, 10.00, 5.00, 29.250, 63.50, 50.90, 96.18, 9.00, 2.63, 9.00, 2.63, 18.00, 5.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(39, '074000150-0500', 'KEY1.5MM T HANDLE SHORT', 'X', '82042000', 21.80, 50.00, 25.00, 7.960, 63.50, 13.84, 26.16, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(40, '074000200-0500', 'KEY2MM T HANDLE SHORT', 'X', '82042000', 21.80, 100.00, 25.00, 7.960, 63.50, 13.84, 26.16, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(41, '074000250-0500', 'KEY2.5MM T HANDLE SHORT', 'X', '82042000', 21.80, 100.00, 25.00, 7.960, 63.50, 13.84, 26.16, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(42, '074000300-0500', 'KEY3MM T HANDLE SHORT', 'X', '82042000', 21.80, 50.00, 25.00, 7.960, 63.50, 13.84, 26.16, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(43, '074000400-0500', 'KEY4MM T HANDLE SHORT', 'X', '82042000', 25.35, 50.00, 25.00, 9.250, 63.50, 16.10, 30.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(44, '074000500-0500', 'KEY5MM T HANDLE SHORT', 'X', '82042000', 29.65, 50.00, 25.00, 10.820, 63.50, 18.83, 35.58, 9.00, 0.97, 9.00, 0.97, 18.00, 1.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(45, '074000600-0500', 'KEY6MM T HANDLE SHORT', 'X', '82042000', 41.30, 40.00, 10.00, 15.070, 63.50, 26.23, 49.56, 9.00, 1.36, 9.00, 1.36, 18.00, 2.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(46, '074000800-0500', 'KEY8MM T HANDLE SHORT', 'X', '82042000', 62.10, 20.00, 10.00, 22.670, 63.50, 39.43, 74.52, 9.00, 2.04, 9.00, 2.04, 18.00, 4.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(47, '078000000-0500', 'KEYMMSET', 'X', '82042000', 223.55, 20.00, 10.00, 81.600, 63.50, 141.95, 268.26, 9.00, 7.34, 9.00, 7.34, 18.00, 14.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(48, '080000400-0500', 'KEY1/16STD INCH', 'X', '82042000', 8.75, 300.00, 100.00, 3.190, 63.50, 5.56, 10.50, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(49, '080000500-0500', 'KEY5/64STD INCH', 'X', '82042000', 8.75, 300.00, 100.00, 3.190, 63.50, 5.56, 10.50, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(50, '080000600-0500', 'KEY3/32STD INCH', 'X', '82042000', 8.75, 200.00, 100.00, 3.190, 63.50, 5.56, 10.50, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(51, '080000800-0500', 'KEY1/8 STD INCH', 'X', '82042000', 8.75, 600.00, 100.00, 3.190, 63.50, 5.56, 10.50, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(52, '080000900-0500', 'KEY9/64STD INCH', 'X', '82042000', 15.65, 800.00, 100.00, 5.710, 63.50, 9.94, 18.78, 9.00, 0.51, 9.00, 0.51, 18.00, 1.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(53, '080001000-0500', 'KEY5/32STD INCH', 'X', '82042000', 10.45, 800.00, 100.00, 3.810, 63.50, 6.64, 12.54, 9.00, 0.34, 9.00, 0.34, 18.00, 0.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(54, '080001200-0500', 'KEY3/16STD INCH', 'X', '82042000', 13.40, 300.00, 100.00, 4.890, 63.50, 8.51, 16.08, 9.00, 0.44, 9.00, 0.44, 18.00, 0.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(55, '080001400-0500', 'KEY7/32STD INCH', 'X', '82042000', 19.05, 400.00, 50.00, 6.950, 63.50, 12.10, 22.86, 9.00, 0.63, 9.00, 0.63, 18.00, 1.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(56, '080001600-0500', 'KEY1/4STD INCH', 'X', '82042000', 26.65, 200.00, 50.00, 9.730, 63.50, 16.92, 31.98, 9.00, 0.88, 9.00, 0.88, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(57, '080002000-0500', 'KEY5/16STD INCH', 'X', '82042000', 43.75, 200.00, 25.00, 15.970, 63.50, 27.78, 52.50, 9.00, 1.44, 9.00, 1.44, 18.00, 2.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(58, '080002400-0500', 'KEY3/8STD INCH', 'X', '82042000', 68.40, 75.00, 25.00, 24.970, 63.50, 43.43, 82.08, 9.00, 2.25, 9.00, 2.25, 18.00, 4.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 75.00, 75.00, 75.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(59, '080003200-0500', 'KEY1/2STD INCH', 'X', '82042000', 130.55, 30.00, 10.00, 47.650, 63.50, 82.90, 156.66, 9.00, 4.29, 9.00, 4.29, 18.00, 8.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(60, '080003600-0500', 'KEY9/16STD INCH', 'X', '82042000', 167.75, 20.00, 10.00, 61.230, 63.50, 106.52, 201.30, 9.00, 5.51, 9.00, 5.51, 18.00, 11.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(61, '080004000-0500', 'KEY5/8STD INCH', 'X', '82042000', 233.35, 20.00, 10.00, 85.170, 63.50, 148.18, 280.02, 9.00, 7.67, 9.00, 7.67, 18.00, 15.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(62, '081000400-0500', 'KEY1/16 LONG INCH', 'X', '82042000', 14.55, 50.00, 25.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(63, '081000500-0500', 'KEY5/64 LONG INCH', 'X', '82042000', 14.55, 50.00, 25.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(64, '081000600-0500', 'KEY3/32 LONG INCH', 'X', '82042000', 14.55, 50.00, 25.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(65, '081000800-0500', 'KEY1/8 LONG INCH', 'X', '82042000', 14.55, 50.00, 25.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(66, '081001000-0500', 'KEY5/32 LONG INCH', 'X', '82042000', 16.40, 75.00, 25.00, 5.990, 63.50, 10.41, 19.68, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 75.00, 75.00, 75.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(67, '081001200-0500', 'KEY3/16 LONG INCH', 'X', '82042000', 21.25, 30.00, 10.00, 7.760, 63.50, 13.49, 25.50, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(68, '081001400-0500', 'KEY7/32 LONG INCH', 'X', '82042000', 27.20, 30.00, 10.00, 9.930, 63.50, 17.27, 32.64, 9.00, 0.89, 9.00, 0.89, 18.00, 1.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(69, '081001600-0500', 'KEY1/4 LONG INCH', 'X', '82042000', 38.80, 15.00, 5.00, 14.160, 63.50, 24.64, 46.56, 9.00, 1.27, 9.00, 1.27, 18.00, 2.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(70, '082000400-0500', 'KEY1/16 T HANDLE LONG INCH', 'X', '82042000', 29.05, 50.00, 25.00, 10.600, 63.50, 18.45, 34.86, 9.00, 0.95, 9.00, 0.95, 18.00, 1.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(71, '082000500-0500', 'KEY5/64 T HANDLE LONG INCH', 'X', '82042000', 32.65, 50.00, 25.00, 11.920, 63.50, 20.73, 39.18, 9.00, 1.07, 9.00, 1.07, 18.00, 2.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(72, '082000600-0500', 'KEY3/32 T HANDLE LONG INCH', 'X', '82042000', 32.65, 50.00, 25.00, 11.920, 63.50, 20.73, 39.18, 9.00, 1.07, 9.00, 1.07, 18.00, 2.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(73, '082000800-0500', 'KEY1/8  T HANDLE LONG INCH', 'X', '82042000', 32.65, 50.00, 25.00, 11.920, 63.50, 20.73, 39.18, 9.00, 1.07, 9.00, 1.07, 18.00, 2.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(74, '082001000-0500', 'KEY5/32 T HANDLE LONG INCH', 'X', '82042000', 36.25, 30.00, 10.00, 13.230, 63.50, 23.02, 43.50, 9.00, 1.19, 9.00, 1.19, 18.00, 2.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(75, '082001200-0500', 'KEY3/16 T HANDLE LONG INCH', 'X', '82042000', 39.30, 30.00, 10.00, 14.340, 63.50, 24.96, 47.16, 9.00, 1.29, 9.00, 1.29, 18.00, 2.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(76, '082001400-0500', 'KEY7/32 T HANDLE LONG INCH', 'X', '82042000', 45.25, 20.00, 10.00, 16.520, 63.50, 28.73, 54.30, 9.00, 1.49, 9.00, 1.49, 18.00, 2.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(77, '082001600-0500', 'KEY1/4  T HANDLE LONG INCH', 'X', '82042000', 60.45, 20.00, 10.00, 22.060, 63.50, 38.39, 72.54, 9.00, 1.99, 9.00, 1.99, 18.00, 3.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(78, '084000400-0500', 'KEY1/16 T HANDLE SHORT INCH', 'X', '82042000', 21.80, 100.00, 25.00, 7.960, 63.50, 13.84, 26.16, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(79, '084000500-0500', 'KEY5/64 T HANDLE SHORT INCH', 'X', '82042000', 21.80, 50.00, 25.00, 7.960, 63.50, 13.84, 26.16, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(80, '084000600-0500', 'KEY3/32 T HANDLE SHORT INCH', 'X', '82042000', 21.80, 100.00, 25.00, 7.960, 63.50, 13.84, 26.16, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(81, '084000800-0500', 'KEY1/8  T HANDLE SHORT INCH', 'X', '82042000', 21.80, 75.00, 25.00, 7.960, 63.50, 13.84, 26.16, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 75.00, 75.00, 75.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(82, '084001000-0500', 'KEY5/32 T HANDLE SHORT INCH', 'X', '82042000', 23.60, 50.00, 25.00, 8.610, 63.50, 14.99, 28.32, 9.00, 0.78, 9.00, 0.78, 18.00, 1.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(83, '084001200-0500', 'KEY3/16 T HANDLE SHORT INCH', 'X', '82042000', 26.65, 50.00, 25.00, 9.730, 63.50, 16.92, 31.98, 9.00, 0.88, 9.00, 0.88, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(84, '084001400-0500', 'KEY7/32 T HANDLE SHORT INCH', 'X', '82042000', 30.85, 30.00, 10.00, 11.260, 63.50, 19.59, 37.02, 9.00, 1.01, 9.00, 1.01, 18.00, 2.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(85, '084001600-0500', 'KEY1/4  T HANDLE SHORT INCH', 'X', '82042000', 40.55, 30.00, 10.00, 14.800, 63.50, 25.75, 48.66, 9.00, 1.33, 9.00, 1.33, 18.00, 2.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(86, '084002000-0500', 'KEY5/16 T HANDLE SHORT INCH', 'X', '82042000', 56.70, 20.00, 10.00, 20.700, 63.50, 36.00, 68.04, 9.00, 1.86, 9.00, 1.86, 18.00, 3.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(87, '088000000-0500', 'KEYINCHSET', 'X', '82042000', 233.40, 20.00, 10.00, 85.190, 63.50, 148.21, 280.08, 9.00, 7.67, 9.00, 7.67, 18.00, 15.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(88, '102103012-0200', 'HHSM10X1.5X12 GR 8.8', 'X', '73181500', 8.25, 1200.00, 200.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(89, '102103015-0200', 'HHSM10X1.5X15 GR 8.8', 'X', '73181500', 8.25, 1200.00, 200.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(90, '102103016-0200', 'HHSM10X1.5X16 GR 8.8', 'X', '73181500', 7.95, 1200.00, 200.00, 4.090, 48.50, 3.86, 9.54, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(91, '102103018-0200', 'HHSM10X1.5X18 GR 8.8', 'X', '73181500', 7.95, 400.00, 100.00, 4.090, 48.50, 3.86, 9.54, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(92, '102103020-0200', 'HHSM10X1.5X20 GR 8.8', 'X', '73181500', 7.50, 800.00, 100.00, 3.860, 48.50, 3.64, 9.00, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(93, '102103022-0200', 'HHSM10X1.5X22 GR 8.8', 'X', '73181500', 7.85, 400.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(94, '102103025-0200', 'HHSM10X1.5X25 GR 8.8', 'X', '73181500', 7.70, 800.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(95, '102103030-0200', 'HHSM10X1.5X30 GR 8.8', 'X', '73181500', 7.85, 800.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(96, '102103035-0200', 'HHSM10X1.5X35 GR 8.8', 'X', '73181500', 7.85, 300.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(97, '102103040-0200', 'HHSM10X1.5X40 GR 8.8', 'X', '73181500', 9.95, 300.00, 100.00, 5.120, 48.50, 4.83, 11.94, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(98, '102103045-0200', 'HHSM10X1.5X45 GR 8.8', 'X', '73181500', 8.65, 300.00, 100.00, 4.450, 48.50, 4.20, 10.38, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(99, '102103050-0200', 'HHSM10X1.5X50 GR 8.8', 'X', '73181500', 9.35, 400.00, 100.00, 4.820, 48.50, 4.53, 11.22, 9.00, 0.43, 9.00, 0.43, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(100, '102103055-0200', 'HHSM10X1.5X55 GR 8.8', 'X', '73181500', 11.40, 400.00, 100.00, 5.870, 48.50, 5.53, 13.68, 9.00, 0.53, 9.00, 0.53, 18.00, 1.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(101, '102103060-0200', 'HHSM10X1.5X60 GR 8.8', 'X', '73181500', 12.50, 400.00, 100.00, 6.440, 48.50, 6.06, 15.00, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(102, '102103065-0200', 'HHSM10X1.5X65 GR 8.8', 'X', '73181500', 13.10, 400.00, 100.00, 6.750, 48.50, 6.35, 15.72, 9.00, 0.61, 9.00, 0.61, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(103, '102103070-0200', 'HHSM10X1.5X70 GR 8.8', 'X', '73181500', 13.80, 150.00, 50.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(104, '102103075-0200', 'HHSM10X1.5X75 GR 8.8', 'X', '73181500', 15.10, 150.00, 50.00, 7.780, 48.50, 7.32, 18.12, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(105, '102103080-0200', 'HHSM10X1.5X80 GR 8.8', 'X', '73181500', 17.85, 150.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(106, '102103090-0200', 'HHSM10X1.5X90 GR 8.8', 'X', '73181500', 19.85, 150.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(107, '102103100-0200', 'HHSM10X1.5X100 GR 8.8', 'X', '73181500', 21.55, 150.00, 50.00, 11.100, 48.50, 10.45, 25.86, 9.00, 1.00, 9.00, 1.00, 18.00, 2.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(108, '102103120-0200', 'HHSM10X1.5X120 GR 8.8', 'X', '73181500', 27.60, 200.00, 50.00, 14.210, 48.50, 13.39, 33.12, 9.00, 1.28, 9.00, 1.28, 18.00, 2.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(109, '102124020-0200', 'HHSM12X1.75X20 GR 8.8', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(110, '102124025-0200', 'HHSM12X1.75X25 GR 8.8', 'X', '73181500', 12.30, 300.00, 100.00, 6.330, 48.50, 5.97, 14.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(111, '102124028-0200', 'HHSM12X1.75X28 GR 8.8', 'X', '73181500', 12.75, 200.00, 50.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(112, '102124030-0200', 'HHSM12X1.75X30 GR 8.8', 'X', '73181500', 12.90, 400.00, 50.00, 6.640, 48.50, 6.26, 15.48, 9.00, 0.60, 9.00, 0.60, 18.00, 1.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(113, '102124035-0200', 'HHSM12X1.75X35 GR 8.8', 'X', '73181500', 13.00, 400.00, 50.00, 6.700, 48.50, 6.31, 15.60, 9.00, 0.60, 9.00, 0.60, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(114, '102124040-0200', 'HHSM12X1.75X40 GR 8.8', 'X', '73181500', 12.50, 400.00, 50.00, 6.440, 48.50, 6.06, 15.00, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(115, '102124045-0200', 'HHSM12X1.75X45 GR 8.8', 'X', '73181500', 15.60, 200.00, 50.00, 8.030, 48.50, 7.57, 18.72, 9.00, 0.72, 9.00, 0.72, 18.00, 1.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(116, '102124050-0200', 'HHSM12X1.75X50 GR 8.8', 'X', '73181500', 16.70, 400.00, 50.00, 8.600, 48.50, 8.10, 20.04, 9.00, 0.77, 9.00, 0.77, 18.00, 1.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(117, '102124055-0200', 'HHSM12X1.75X55 GR 8.8', 'X', '73181500', 17.35, 150.00, 50.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(118, '102124060-0200', 'HHSM12X1.75X60 GR 8.8', 'X', '73181500', 18.25, 150.00, 50.00, 9.400, 48.50, 8.85, 21.90, 9.00, 0.85, 9.00, 0.85, 18.00, 1.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(119, '102124065-0200', 'HHSM12X1.75X65 GR 8.8', 'X', '73181500', 18.55, 200.00, 50.00, 9.550, 48.50, 9.00, 22.26, 9.00, 0.86, 9.00, 0.86, 18.00, 1.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(120, '102124070-0200', 'HHSM12X1.75X70 GR 8.8', 'X', '73181500', 21.35, 80.00, 20.00, 11.000, 48.50, 10.35, 25.62, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(121, '102124075-0200', 'HHSM12X1.75X75 GR 8.8', 'X', '73181500', 22.25, 160.00, 20.00, 11.460, 48.50, 10.79, 26.70, 9.00, 1.03, 9.00, 1.03, 18.00, 2.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(122, '102124080-0200', 'HHSM12X1.75X80 GR 8.8', 'X', '73181500', 23.60, 160.00, 20.00, 12.150, 48.50, 11.45, 28.32, 9.00, 1.09, 9.00, 1.09, 18.00, 2.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(123, '102124085-0200', 'HHSM12X1.75X85 GR 8.8', 'X', '73181500', 24.60, 80.00, 20.00, 12.670, 48.50, 11.93, 29.52, 9.00, 1.14, 9.00, 1.14, 18.00, 2.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(124, '102124090-0200', 'HHSM12X1.75X90 GR 8.8', 'X', '73181500', 25.85, 80.00, 20.00, 13.310, 48.50, 12.54, 31.02, 9.00, 1.20, 9.00, 1.20, 18.00, 2.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(125, '102124100-0200', 'HHSM12X1.75X100 GR 8.8', 'X', '73181500', 30.15, 160.00, 20.00, 15.530, 48.50, 14.62, 36.18, 9.00, 1.40, 9.00, 1.40, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(126, '102124110-0200', 'HHSM12X1.75X110 GR 8.8', 'X', '73181500', 33.55, 120.00, 20.00, 17.280, 48.50, 16.27, 40.26, 9.00, 1.56, 9.00, 1.56, 18.00, 3.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(127, '102124120-0200', 'HHSM12X1.75X120 GR 8.8', 'X', '73181500', 35.70, 120.00, 20.00, 18.390, 48.50, 17.31, 42.84, 9.00, 1.65, 9.00, 1.65, 18.00, 3.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(128, '102124150-0200', 'HHSM12X1.75X150 GR 8.8', 'X', '73181500', 65.65, 60.00, 20.00, 33.810, 48.50, 31.84, 78.78, 9.00, 3.04, 9.00, 3.04, 18.00, 6.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(129, '102143035-0200', 'HHSM14X1.5X35 GR 8.8', 'X', '73181500', 20.30, 150.00, 50.00, 10.450, 48.50, 9.85, 24.36, 9.00, 0.94, 9.00, 0.94, 18.00, 1.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(130, '102143040-0200', 'HHSM14X1.5X40 GR 8.8', 'X', '73181500', 21.45, 150.00, 50.00, 11.050, 48.50, 10.40, 25.74, 9.00, 0.99, 9.00, 0.99, 18.00, 1.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(131, '102145022-0200', 'HHSM14X2X22 GR 8.8', 'X', '73181500', 16.80, 200.00, 50.00, 8.650, 48.50, 8.15, 20.16, 9.00, 0.78, 9.00, 0.78, 18.00, 1.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(132, '102145025-0200', 'HHSM14X2X25 GR 8.8', 'X', '73181500', 19.00, 200.00, 50.00, 9.790, 48.50, 9.22, 22.80, 9.00, 0.88, 9.00, 0.88, 18.00, 1.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(133, '102145030-0200', 'HHSM14X2X30 GR 8.8', 'X', '73181500', 19.50, 200.00, 50.00, 10.040, 48.50, 9.46, 23.40, 9.00, 0.90, 9.00, 0.90, 18.00, 1.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(134, '102145035-0200', 'HHSM14X2X35 GR 8.8', 'X', '73181500', 20.30, 300.00, 75.00, 10.450, 48.50, 9.85, 24.36, 9.00, 0.94, 9.00, 0.94, 18.00, 1.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(135, '102145040-0200', 'HHSM14X2X40 GR 8.8', 'X', '73181500', 21.45, 150.00, 50.00, 11.050, 48.50, 10.40, 25.74, 9.00, 0.99, 9.00, 0.99, 18.00, 1.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(136, '102145045-0200', 'HHSM14X2X45 GR 8.8', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(137, '102145050-0200', 'HHSM14X2X50 GR 8.8', 'X', '73181500', 20.95, 200.00, 50.00, 10.790, 48.50, 10.16, 25.14, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(138, '102145055-0200', 'HHSM14X2X55 GR 8.8', 'X', '73181500', 26.85, 200.00, 50.00, 13.830, 48.50, 13.02, 32.22, 9.00, 1.24, 9.00, 1.24, 18.00, 2.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(139, '102145060-0200', 'HHSM14X2X60 GR 8.8', 'X', '73181500', 24.80, 120.00, 20.00, 12.770, 48.50, 12.03, 29.76, 9.00, 1.15, 9.00, 1.15, 18.00, 2.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(140, '102145065-0200', 'HHSM14X2X65 GR 8.8', 'X', '73181500', 28.70, 80.00, 20.00, 14.780, 48.50, 13.92, 34.44, 9.00, 1.33, 9.00, 1.33, 18.00, 2.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(141, '102145070-0200', 'HHSM14X2X70 GR 8.8', 'X', '73181500', 31.95, 80.00, 20.00, 16.450, 48.50, 15.50, 38.34, 9.00, 1.48, 9.00, 1.48, 18.00, 2.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(142, '102145075-0200', 'HHSM14X2X75 GR 8.8', 'X', '73181500', 33.55, 80.00, 20.00, 17.280, 48.50, 16.27, 40.26, 9.00, 1.56, 9.00, 1.56, 18.00, 3.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(143, '102145080-0200', 'HHSM14X2X80 GR 8.8', 'X', '73181500', 35.40, 80.00, 20.00, 18.230, 48.50, 17.17, 42.48, 9.00, 1.64, 9.00, 1.64, 18.00, 3.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(144, '102145090-0200', 'HHSM14X2X90 GR 8.8', 'X', '73181500', 38.75, 80.00, 20.00, 19.960, 48.50, 18.79, 46.50, 9.00, 1.80, 9.00, 1.80, 18.00, 3.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(145, '105103012-0200', 'HHSM10X1.5X12 GR 10.9', 'X', '73181500', 8.25, 800.00, 100.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(146, '105103016-0200', 'HHSM10X1.5X16 GR 10.9', 'X', '73181500', 7.95, 1200.00, 200.00, 4.090, 48.50, 3.86, 9.54, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(147, '105103018-0200', 'HHSM10X1.5X18 GR 10.9', 'X', '73181500', 7.95, 1200.00, 200.00, 4.090, 48.50, 3.86, 9.54, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(148, '105103020-0200', 'HHSM10X1.5X20 GR 10.9', 'X', '73181500', 7.50, 800.00, 100.00, 3.860, 48.50, 3.64, 9.00, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(149, '105103022-0200', 'HHSM10X1.5X22 GR 10.9', 'X', '73181500', 7.85, 800.00, 200.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(150, '105103025-0200', 'HHSM10X1.5X25 GR 10.9', 'X', '73181500', 7.70, 800.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(151, '105103030-0200', 'HHSM10X1.5X30 GR 10.9', 'X', '73181500', 7.85, 800.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(152, '105103035-0200', 'HHSM10X1.5X35 GR 10.9', 'X', '73181500', 7.85, 300.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(153, '105103040-0200', 'HHSM10X1.5X40 GR 10.9', 'X', '73181500', 9.95, 300.00, 100.00, 5.120, 48.50, 4.83, 11.94, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(154, '105103045-0200', 'HHSM10X1.5X45 GR 10.9', 'X', '73181500', 8.65, 300.00, 100.00, 4.450, 48.50, 4.20, 10.38, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(155, '105103050-0200', 'HHSM10X1.5X50 GR 10.9', 'X', '73181500', 9.35, 400.00, 100.00, 4.820, 48.50, 4.53, 11.22, 9.00, 0.43, 9.00, 0.43, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(156, '105103055-0200', 'HHSM10X1.5X55 GR 10.9', 'X', '73181500', 11.40, 400.00, 100.00, 5.870, 48.50, 5.53, 13.68, 9.00, 0.53, 9.00, 0.53, 18.00, 1.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(157, '105103060-0200', 'HHSM10X1.5X60 GR 10.9', 'X', '73181500', 12.50, 400.00, 100.00, 6.440, 48.50, 6.06, 15.00, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(158, '105103065-0200', 'HHSM10X1.5X65 GR 10.9', 'X', '73181500', 13.10, 400.00, 100.00, 6.750, 48.50, 6.35, 15.72, 9.00, 0.61, 9.00, 0.61, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(159, '105103070-0200', 'HHSM10X1.5X70 GR 10.9', 'X', '73181500', 13.80, 150.00, 50.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(160, '105103075-0200', 'HHSM10X1.5X75 GR 10.9', 'X', '73181500', 15.10, 150.00, 50.00, 7.780, 48.50, 7.32, 18.12, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(161, '105103080-0200', 'HHSM10X1.5X80 GR 10.9', 'X', '73181500', 17.85, 150.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(162, '105103090-0200', 'HHSM10X1.5X90 GR 10.9', 'X', '73181500', 19.85, 150.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(163, '105103100-0200', 'HHSM10X1.5X100 GR 10.9', 'X', '73181500', 21.55, 150.00, 50.00, 11.100, 48.50, 10.45, 25.86, 9.00, 1.00, 9.00, 1.00, 18.00, 2.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(164, '105103115-0200', 'HHSM10X1.5X115 GR 10.9', 'X', '73181500', 29.70, 200.00, 50.00, 15.300, 48.50, 14.40, 35.64, 9.00, 1.38, 9.00, 1.38, 18.00, 2.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(165, '105124020-0200', 'HHSM12X1.75X20 GR 10.9', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(166, '105124025-0200', 'HHSM12X1.75X25 GR 10.9', 'X', '73181500', 12.30, 300.00, 100.00, 6.330, 48.50, 5.97, 14.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(167, '105124030-0200', 'HHSM12X1.75X30 GR 10.9', 'X', '73181500', 12.90, 400.00, 50.00, 6.640, 48.50, 6.26, 15.48, 9.00, 0.60, 9.00, 0.60, 18.00, 1.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(168, '105124035-0200', 'HHSM12X1.75X35 GR 10.9', 'X', '73181500', 13.00, 400.00, 50.00, 6.700, 48.50, 6.31, 15.60, 9.00, 0.60, 9.00, 0.60, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(169, '105124040-0200', 'HHSM12X1.75X40 GR 10.9', 'X', '73181500', 12.50, 400.00, 50.00, 6.440, 48.50, 6.06, 15.00, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(170, '105124045-0200', 'HHSM12X1.75X45 GR 10.9', 'X', '73181500', 15.60, 400.00, 50.00, 8.030, 48.50, 7.57, 18.72, 9.00, 0.72, 9.00, 0.72, 18.00, 1.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(171, '105124050-0200', 'HHSM12X1.75X50 GR 10.9', 'X', '73181500', 16.70, 400.00, 50.00, 8.600, 48.50, 8.10, 20.04, 9.00, 0.77, 9.00, 0.77, 18.00, 1.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(172, '105124055-0200', 'HHSM12X1.75X55 GR 10.9', 'X', '73181500', 17.35, 150.00, 50.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(173, '105124060-0200', 'HHSM12X1.75X60 GR 10.9', 'X', '73181500', 18.25, 150.00, 50.00, 9.400, 48.50, 8.85, 21.90, 9.00, 0.85, 9.00, 0.85, 18.00, 1.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(174, '105124065-0200', 'HHSM12X1.75X65 GR 10.9', 'X', '73181500', 18.55, 200.00, 50.00, 9.550, 48.50, 9.00, 22.26, 9.00, 0.86, 9.00, 0.86, 18.00, 1.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(175, '105124070-0200', 'HHSM12X1.75X70 GR 10.9', 'X', '73181500', 21.35, 80.00, 20.00, 11.000, 48.50, 10.35, 25.62, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(176, '105124075-0200', 'HHSM12X1.75X75 GR 10.9', 'X', '73181500', 22.25, 80.00, 20.00, 11.460, 48.50, 10.79, 26.70, 9.00, 1.03, 9.00, 1.03, 18.00, 2.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(177, '105124080-0200', 'HHSM12X1.75X80 GR 10.9', 'X', '73181500', 23.60, 80.00, 20.00, 12.150, 48.50, 11.45, 28.32, 9.00, 1.09, 9.00, 1.09, 18.00, 2.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(178, '105124090-0200', 'HHSM12X1.75X90 GR 10.9', 'X', '73181500', 25.85, 80.00, 20.00, 13.310, 48.50, 12.54, 31.02, 9.00, 1.20, 9.00, 1.20, 18.00, 2.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(179, '105124100-0200', 'HHSM12X1.75X100 GR 10.9', 'X', '73181500', 30.15, 80.00, 20.00, 15.530, 48.50, 14.62, 36.18, 9.00, 1.40, 9.00, 1.40, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(180, '105124110-0200', 'HHSM12X1.75X110 GR 10.9', 'X', '73181500', 33.55, 80.00, 20.00, 17.280, 48.50, 16.27, 40.26, 9.00, 1.56, 9.00, 1.56, 18.00, 3.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(181, '105124120-0200', 'HHSM12X1.75X120 GR 10.9', 'X', '73181500', 35.70, 0.00, 0.00, 18.390, 48.50, 17.31, 42.84, 9.00, 1.65, 9.00, 1.65, 18.00, 3.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(182, '105124130-0200', 'HHSM12X1.75X130 GR 10.9', 'X', '73181500', 37.95, 60.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(183, '105124150-0200', 'HHSM12X1.75X150 GR 10.9', 'X', '73181500', 65.65, 60.00, 20.00, 33.810, 48.50, 31.84, 78.78, 9.00, 3.04, 9.00, 3.04, 18.00, 6.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(184, '105145025-0200', 'HHSM14X2X25 GR 10.9', 'X', '73181500', 19.00, 200.00, 50.00, 9.790, 48.50, 9.22, 22.80, 9.00, 0.88, 9.00, 0.88, 18.00, 1.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(185, '105145030-0200', 'HHSM14X2X30 GR 10.9', 'X', '73181500', 19.50, 200.00, 50.00, 10.040, 48.50, 9.46, 23.40, 9.00, 0.90, 9.00, 0.90, 18.00, 1.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(186, '105145035-0200', 'HHSM14X2X35 GR 10.9', 'X', '73181500', 20.30, 150.00, 50.00, 10.450, 48.50, 9.85, 24.36, 9.00, 0.94, 9.00, 0.94, 18.00, 1.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(187, '105145040-0200', 'HHSM14X2X40 GR 10.9', 'X', '73181500', 21.45, 150.00, 50.00, 11.050, 48.50, 10.40, 25.74, 9.00, 0.99, 9.00, 0.99, 18.00, 1.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(188, '105145045-0200', 'HHSM14X2X45 GR 10.9', 'X', '73181500', 18.85, 300.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(189, '105145050-0200', 'HHSM14X2X50 GR 10.9', 'X', '73181500', 20.95, 200.00, 50.00, 10.790, 48.50, 10.16, 25.14, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(190, '105145055-0200', 'HHSM14X2X55 GR 10.9', 'X', '73181500', 26.85, 200.00, 50.00, 13.830, 48.50, 13.02, 32.22, 9.00, 1.24, 9.00, 1.24, 18.00, 2.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(191, '105145060-0200', 'HHSM14X2X60 GR 10.9', 'X', '73181500', 24.80, 120.00, 20.00, 12.770, 48.50, 12.03, 29.76, 9.00, 1.15, 9.00, 1.15, 18.00, 2.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(192, '105145065-0200', 'HHSM14X2X65 GR 10.9', 'X', '73181500', 28.70, 80.00, 20.00, 14.780, 48.50, 13.92, 34.44, 9.00, 1.33, 9.00, 1.33, 18.00, 2.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(193, '105145070-0200', 'HHSM14X2X70 GR 10.9', 'X', '73181500', 31.95, 80.00, 20.00, 16.450, 48.50, 15.50, 38.34, 9.00, 1.48, 9.00, 1.48, 18.00, 2.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(194, '105145075-0200', 'HHSM14X2X75 GR 10.9', 'X', '73181500', 33.55, 80.00, 20.00, 17.280, 48.50, 16.27, 40.26, 9.00, 1.56, 9.00, 1.56, 18.00, 3.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(195, '106103020-0200', 'HHSM10X1.5X20 GR 12.9', 'X', '73181500', 9.35, 400.00, 100.00, 4.820, 48.50, 4.53, 11.22, 9.00, 0.43, 9.00, 0.43, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(196, '106103040-0200', 'HHSM10X1.5X40 GR 12.9', 'X', '73181500', 12.80, 300.00, 100.00, 6.590, 48.50, 6.21, 15.36, 9.00, 0.59, 9.00, 0.59, 18.00, 1.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(197, '106103050-0200', 'HHSM10X1.5X50 GR 12.9', 'X', '73181500', 11.75, 200.00, 50.00, 6.050, 48.50, 5.70, 14.10, 9.00, 0.54, 9.00, 0.54, 18.00, 1.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(198, '112051008-0200', 'HHSM5X0.8X8 GR 8.8', 'X', '73181500', 3.45, 4000.00, 1000.00, 1.780, 48.50, 1.67, 4.14, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(199, '112051010-0200', 'HHSM5X0.8X10 GR 8.8', 'X', '73181500', 3.45, 4000.00, 1000.00, 1.780, 48.50, 1.67, 4.14, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(200, '112051012-0200', 'HHSM5X0.8X12 GR 8.8', 'X', '73181500', 3.55, 4000.00, 1000.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(201, '112051014-0200', 'HHSM5X0.8X14 GR 8.8', 'X', '73181500', 3.55, 4000.00, 1000.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(202, '112051015-0200', 'HHSM5X0.8X15 GR 8.8', 'X', '73181500', 3.55, 4000.00, 1000.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(203, '112051016-0200', 'HHSM5X0.8X16 GR 8.8', 'X', '73181500', 3.55, 4000.00, 1000.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(204, '112051018-0200', 'HHSM5X0.8X18 GR 8.8', 'X', '73181500', 3.90, 1000.00, 1000.00, 2.010, 48.50, 1.89, 4.68, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1000.00, 1000.00, 1000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(205, '112051020-0200', 'HHSM5X0.8X20 GR 8.8', 'X', '73181500', 4.15, 2000.00, 500.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(206, '112051022-0200', 'HHSM5X0.8X22 GR 8.8', 'X', '73181500', 4.15, 1000.00, 1000.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1000.00, 1000.00, 1000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(207, '112051025-0200', 'HHSM5X0.8X25 GR 8.8', 'X', '73181500', 4.15, 1500.00, 500.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1500.00, 1500.00, 1500.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(208, '112051030-0200', 'HHSM5X0.8X30 GR 8.8', 'X', '73181500', 4.40, 1500.00, 500.00, 2.270, 48.50, 2.13, 5.28, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1500.00, 1500.00, 1500.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(209, '112051035-0200', 'HHSM5X0.8X35 GR 8.8', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(210, '112051040-0200', 'HHSM5X0.8X40 GR 8.8', 'X', '73181500', 4.90, 600.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(211, '112051045-0200', 'HHSM5X0.8X45 GR 8.8', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(212, '112051050-0200', 'HHSM5X0.8X50 GR 8.8', 'X', '73181500', 6.90, 600.00, 200.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(213, '112061010-0200', 'HHSM6X1X10 GR 8.8', 'X', '73181500', 3.15, 2000.00, 500.00, 1.620, 48.50, 1.53, 3.78, 9.00, 0.15, 9.00, 0.15, 18.00, 0.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(214, '112061012-0200', 'HHSM6X1X12 GR 8.8', 'X', '73181500', 3.45, 2000.00, 500.00, 1.780, 48.50, 1.67, 4.14, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(215, '112061014-0200', 'HHSM6X1X14 GR 8.8', 'X', '73181500', 4.00, 2000.00, 500.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(216, '112061015-0200', 'HHSM6X1X15 GR 8.8', 'X', '73181500', 3.70, 2000.00, 500.00, 1.910, 48.50, 1.79, 4.44, 9.00, 0.17, 9.00, 0.17, 18.00, 0.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(217, '112061016-0200', 'HHSM6X1X16 GR 8.8', 'X', '73181500', 3.55, 2000.00, 500.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(218, '112061018-0200', 'HHSM6X1X18 GR 8.8', 'X', '73181500', 3.90, 2000.00, 500.00, 2.010, 48.50, 1.89, 4.68, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(219, '112061020-0200', 'HHSM6X1X20 GR 8.8', 'X', '73181500', 4.00, 2000.00, 500.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(220, '112061022-0200', 'HHSM6X1X22 GR 8.8', 'X', '73181500', 4.15, 2000.00, 500.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(221, '112061025-0200', 'HHSM6X1X25 GR 8.8', 'X', '73181500', 4.15, 1200.00, 200.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(222, '112061028-0200', 'HHSM6X1X28 GR 8.8', 'X', '73181500', 4.55, 1200.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(223, '112061030-0200', 'HHSM6X1X30 GR 8.8', 'X', '73181500', 4.40, 1200.00, 200.00, 2.270, 48.50, 2.13, 5.28, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(224, '112061035-0200', 'HHSM6X1X35 GR 8.8', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(225, '112061040-0200', 'HHSM6X1X40 GR 8.8', 'X', '73181500', 4.90, 800.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(226, '112061045-0200', 'HHSM6X1X45 GR 8.8', 'X', '73181500', 4.90, 800.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(227, '112061050-0200', 'HHSM6X1X50 GR 8.8', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(228, '112081022-0200', 'HHSM8X1X22 GR 8.8', 'X', '73181500', 4.80, 200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(229, '112082010-0200', 'HHSM8X1.25X10 GR 8.8', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(230, '112082012-0200', 'HHSM8X1.25X12 GR 8.8', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(231, '112082014-0200', 'HHSM8X1.25X14 GR 8.8', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(232, '112082015-0200', 'HHSM8X1.25X15 GR 8.8', 'X', '73181500', 5.20, 1200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(233, '112082016-0200', 'HHSM8X1.25X16 GR 8.8', 'X', '73181500', 4.90, 1200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(234, '112082020-0200', 'HHSM8X1.25X20 GR 8.8', 'X', '73181500', 3.55, 800.00, 200.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(235, '112082022-0200', 'HHSM8X1.25X22 GR 8.8', 'X', '73181500', 4.80, 800.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(236, '112082025-0200', 'HHSM8X1.25X25 GR 8.8', 'X', '73181500', 4.55, 800.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(237, '112082028-0200', 'HHSM8X1.25X28 GR 8.8', 'X', '73181500', 5.10, 800.00, 200.00, 2.630, 48.50, 2.47, 6.12, 9.00, 0.24, 9.00, 0.24, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(238, '112082030-0200', 'HHSM8X1.25X30 GR 8.8', 'X', '73181500', 5.10, 600.00, 200.00, 2.630, 48.50, 2.47, 6.12, 9.00, 0.24, 9.00, 0.24, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(239, '112082032-0200', 'HHSM8X1.25X32 GR 8.8', 'X', '73181500', 5.55, 600.00, 200.00, 2.860, 48.50, 2.69, 6.66, 9.00, 0.26, 9.00, 0.26, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(240, '112082035-0200', 'HHSM8X1.25X35 GR 8.8', 'X', '73181500', 4.55, 600.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(241, '112082038-0200', 'HHSM8X1.25X38 GR 8.8', 'X', '73181500', 5.95, 600.00, 200.00, 3.060, 48.50, 2.89, 7.14, 9.00, 0.28, 9.00, 0.28, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(242, '112082040-0200', 'HHSM8X1.25X40 GR 8.8', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(243, '112082045-0200', 'HHSM8X1.25X45 GR 8.8', 'X', '73181500', 5.35, 800.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(244, '112082050-0200', 'HHSM8X1.25X50 GR 8.8', 'X', '73181500', 5.80, 800.00, 200.00, 2.990, 48.50, 2.81, 6.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(245, '112082055-0200', 'HHSM8X1.25X55 GR 8.8', 'X', '73181500', 7.00, 400.00, 100.00, 3.610, 48.50, 3.40, 8.40, 9.00, 0.32, 9.00, 0.32, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(246, '112082060-0200', 'HHSM8X1.25X60 GR 8.8', 'X', '73181500', 8.10, 600.00, 100.00, 4.170, 48.50, 3.93, 9.72, 9.00, 0.38, 9.00, 0.38, 18.00, 0.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(247, '112082065-0200', 'HHSM8X1.25X65 GR 8.8', 'X', '73181500', 8.35, 300.00, 50.00, 4.300, 48.50, 4.05, 10.02, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(248, '112082070-0200', 'HHSM8X1.25X70 GR 8.8', 'X', '73181500', 8.80, 300.00, 50.00, 4.530, 48.50, 4.27, 10.56, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(249, '112082075-0200', 'HHSM8X1.25X75 GR 8.8', 'X', '73181500', 9.15, 300.00, 50.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(250, '112165025-0200', 'HHSM16X2X25 GR 8.8', 'X', '73181500', 27.95, 120.00, 20.00, 14.390, 48.50, 13.56, 33.54, 9.00, 1.30, 9.00, 1.30, 18.00, 2.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(251, '112165030-0200', 'HHSM16X2X30 GR 8.8', 'X', '73181500', 27.95, 120.00, 20.00, 14.390, 48.50, 13.56, 33.54, 9.00, 1.30, 9.00, 1.30, 18.00, 2.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(252, '112165035-0200', 'HHSM16X2X35 GR 8.8', 'X', '73181500', 28.05, 120.00, 20.00, 14.450, 48.50, 13.60, 33.66, 9.00, 1.30, 9.00, 1.30, 18.00, 2.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(253, '112165040-0200', 'HHSM16X2X40 GR 8.8', 'X', '73181500', 28.40, 120.00, 20.00, 14.630, 48.50, 13.77, 34.08, 9.00, 1.32, 9.00, 1.32, 18.00, 2.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(254, '112165045-0200', 'HHSM16X2X45 GR 8.8', 'X', '73181500', 30.70, 80.00, 20.00, 15.810, 48.50, 14.89, 36.84, 9.00, 1.42, 9.00, 1.42, 18.00, 2.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(255, '112165050-0200', 'HHSM16X2X50 GR 8.8', 'X', '73181500', 32.25, 80.00, 20.00, 16.610, 48.50, 15.64, 38.70, 9.00, 1.49, 9.00, 1.49, 18.00, 2.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(256, '112165055-0200', 'HHSM16X2X55 GR 8.8', 'X', '73181500', 34.40, 80.00, 20.00, 17.720, 48.50, 16.68, 41.28, 9.00, 1.59, 9.00, 1.59, 18.00, 3.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(257, '112165060-0200', 'HHSM16X2X60 GR 8.8', 'X', '73181500', 36.95, 80.00, 20.00, 19.030, 48.50, 17.92, 44.34, 9.00, 1.71, 9.00, 1.71, 18.00, 3.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(258, '112165065-0200', 'HHSM16X2X65 GR 8.8', 'X', '73181500', 39.05, 60.00, 20.00, 20.110, 48.50, 18.94, 46.86, 9.00, 1.81, 9.00, 1.81, 18.00, 3.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(259, '112165070-0200', 'HHSM16X2X70 GR 8.8', 'X', '73181500', 41.45, 60.00, 20.00, 21.350, 48.50, 20.10, 49.74, 9.00, 1.92, 9.00, 1.92, 18.00, 3.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(260, '112165075-0200', 'HHSM16X2X75 GR 8.8', 'X', '73181500', 44.45, 60.00, 20.00, 22.890, 48.50, 21.56, 53.34, 9.00, 2.06, 9.00, 2.06, 18.00, 4.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(261, '112165080-0200', 'HHSM16X2X80 GR 8.8', 'X', '73181500', 48.50, 60.00, 20.00, 24.980, 48.50, 23.52, 58.20, 9.00, 2.25, 9.00, 2.25, 18.00, 4.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(262, '112165085-0200', 'HHSM16X2X85 GR 8.8', 'X', '73181500', 49.95, 60.00, 20.00, 25.720, 48.50, 24.23, 59.94, 9.00, 2.32, 9.00, 2.32, 18.00, 4.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(263, '112165090-0200', 'HHSM16X2X90 GR 8.8', 'X', '73181500', 51.90, 60.00, 20.00, 26.730, 48.50, 25.17, 62.28, 9.00, 2.41, 9.00, 2.41, 18.00, 4.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(264, '112165100-0200', 'HHSM16X2X100 GR 8.8', 'X', '73181500', 56.35, 80.00, 20.00, 29.020, 48.50, 27.33, 67.62, 9.00, 2.61, 9.00, 2.61, 18.00, 5.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(265, '112165110-0200', 'HHSM16X2X110 GR 8.8', 'X', '73181500', 61.25, 80.00, 20.00, 31.540, 48.50, 29.71, 73.50, 9.00, 2.84, 9.00, 2.84, 18.00, 5.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(266, '112165130-0200', 'HHSM16X2X130 GR 8.8', 'X', '73181500', 81.70, 80.00, 20.00, 42.080, 48.50, 39.62, 98.04, 9.00, 3.79, 9.00, 3.79, 18.00, 7.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(267, '112165150-0200', 'HHSM16X2X150 GR 8.8', 'X', '73181500', 99.15, 80.00, 20.00, 51.060, 48.50, 48.09, 118.98, 9.00, 4.60, 9.00, 4.60, 18.00, 9.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(268, '112183040-0200', 'HHSM18X1.5X40 GR 8.8', 'X', '73181500', 57.65, 80.00, 20.00, 29.690, 48.50, 27.96, 69.18, 9.00, 2.67, 9.00, 2.67, 18.00, 5.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(269, '112183045-0200', 'HHSM18X1.5X45 GR 8.8', 'X', '73181500', 60.10, 80.00, 20.00, 30.950, 48.50, 29.15, 72.12, 9.00, 2.79, 9.00, 2.79, 18.00, 5.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(270, '112183050-0200', 'HHSM18X1.5X50 GR 8.8', 'X', '73181500', 62.05, 80.00, 20.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(271, '112183055-0200', 'HHSM18X1.5X55 GR 8.8', 'X', '73181500', 66.15, 60.00, 20.00, 34.070, 48.50, 32.08, 79.38, 9.00, 3.07, 9.00, 3.07, 18.00, 6.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(272, '112183080-0200', 'HHSM18X1.5X80 GR 8.8', 'X', '73181500', 77.90, 40.00, 10.00, 40.120, 48.50, 37.78, 93.48, 9.00, 3.61, 9.00, 3.61, 18.00, 7.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(273, '112187040-0200', 'HHSM18X2.5X40 GR 8.8', 'X', '73181500', 52.45, 80.00, 20.00, 27.010, 48.50, 25.44, 62.94, 9.00, 2.43, 9.00, 2.43, 18.00, 4.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(274, '112187045-0200', 'HHSM18X2.5X45 GR 8.8', 'X', '73181500', 54.75, 80.00, 20.00, 28.200, 48.50, 26.55, 65.70, 9.00, 2.54, 9.00, 2.54, 18.00, 5.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(275, '112187050-0200', 'HHSM18X2.5X50 GR 8.8', 'X', '73181500', 56.25, 80.00, 20.00, 28.970, 48.50, 27.28, 67.50, 9.00, 2.61, 9.00, 2.61, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(276, '112187055-0200', 'HHSM18X2.5X55 GR 8.8', 'X', '73181500', 60.10, 60.00, 20.00, 30.950, 48.50, 29.15, 72.12, 9.00, 2.79, 9.00, 2.79, 18.00, 5.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(277, '112187060-0200', 'HHSM18X2.5X60 GR 8.8', 'X', '73181500', 62.05, 60.00, 20.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(278, '112187065-0200', 'HHSM18X2.5X65 GR 8.8', 'X', '73181500', 64.20, 60.00, 20.00, 33.060, 48.50, 31.14, 77.04, 9.00, 2.98, 9.00, 2.98, 18.00, 5.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(279, '112187070-0200', 'HHSM18X2.5X70 GR 8.8', 'X', '73181500', 66.85, 80.00, 20.00, 34.430, 48.50, 32.42, 80.22, 9.00, 3.10, 9.00, 3.10, 18.00, 6.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(280, '112187075-0200', 'HHSM18X2.5X75 GR 8.8', 'X', '73181500', 70.85, 80.00, 20.00, 36.490, 48.50, 34.36, 85.02, 9.00, 3.28, 9.00, 3.28, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(281, '112187080-0200', 'HHSM18X2.5X80 GR 8.8', 'X', '73181500', 70.85, 40.00, 10.00, 36.490, 48.50, 34.36, 85.02, 9.00, 3.28, 9.00, 3.28, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(282, '112187090-0200', 'HHSM18X2.5X90 GR 8.8', 'X', '73181500', 75.30, 30.00, 10.00, 38.780, 48.50, 36.52, 90.36, 9.00, 3.49, 9.00, 3.49, 18.00, 6.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(283, '112187100-0200', 'HHSM18X2.5X100 GR 8.8', 'X', '73181500', 79.90, 30.00, 10.00, 41.150, 48.50, 38.75, 95.88, 9.00, 3.70, 9.00, 3.70, 18.00, 7.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(284, '112203040-0200', 'HHSM20X1.5X40 GR 8.8', 'X', '73181500', 64.50, 60.00, 20.00, 33.220, 48.50, 31.28, 77.40, 9.00, 2.99, 9.00, 2.99, 18.00, 5.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(285, '112203045-0200', 'HHSM20X1.5X45 GR 8.8', 'X', '73181500', 66.75, 60.00, 20.00, 34.380, 48.50, 32.37, 80.10, 9.00, 3.09, 9.00, 3.09, 18.00, 6.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(286, '112203055-0200', 'HHSM20X1.5X55 GR 8.8', 'X', '73181500', 69.30, 80.00, 20.00, 35.690, 48.50, 33.61, 83.16, 9.00, 3.21, 9.00, 3.21, 18.00, 6.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(287, '112203060-0200', 'HHSM20X1.5X60 GR 8.8', 'X', '73181500', 73.50, 80.00, 20.00, 37.850, 48.50, 35.65, 88.20, 9.00, 3.41, 9.00, 3.41, 18.00, 6.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(288, '112203070-0200', 'HHSM20X1.5X70 GR 8.8', 'X', '73181500', 78.75, 30.00, 10.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(289, '112203075-0200', 'HHSM20X1.5X75 GR 8.8', 'X', '73181500', 81.90, 30.00, 10.00, 42.180, 48.50, 39.72, 98.28, 9.00, 3.80, 9.00, 3.80, 18.00, 7.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(290, '112207035-0200', 'HHSM20X2.5X35 GR 8.8', 'X', '73181500', 58.65, 60.00, 20.00, 30.200, 48.50, 28.45, 70.38, 9.00, 2.72, 9.00, 2.72, 18.00, 5.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(291, '112207040-0200', 'HHSM20X2.5X40 GR 8.8', 'X', '73181500', 58.65, 60.00, 20.00, 30.200, 48.50, 28.45, 70.38, 9.00, 2.72, 9.00, 2.72, 18.00, 5.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(292, '112207045-0200', 'HHSM20X2.5X45 GR 8.8', 'X', '73181500', 58.65, 60.00, 20.00, 30.200, 48.50, 28.45, 70.38, 9.00, 2.72, 9.00, 2.72, 18.00, 5.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(293, '112207050-0200', 'HHSM20X2.5X50 GR 8.8', 'X', '73181500', 60.65, 80.00, 20.00, 31.230, 48.50, 29.42, 72.78, 9.00, 2.81, 9.00, 2.81, 18.00, 5.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(294, '112207055-0200', 'HHSM20X2.5X55 GR 8.8', 'X', '73181500', 63.10, 80.00, 20.00, 32.500, 48.50, 30.60, 75.72, 9.00, 2.92, 9.00, 2.92, 18.00, 5.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(295, '112207060-0200', 'HHSM20X2.5X60 GR 8.8', 'X', '73181500', 66.85, 80.00, 20.00, 34.430, 48.50, 32.42, 80.22, 9.00, 3.10, 9.00, 3.10, 18.00, 6.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(296, '112207065-0200', 'HHSM20X2.5X65 GR 8.8', 'X', '73181500', 69.00, 80.00, 20.00, 35.540, 48.50, 33.47, 82.80, 9.00, 3.20, 9.00, 3.20, 18.00, 6.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(297, '112207070-0200', 'HHSM20X2.5X70 GR 8.8', 'X', '73181500', 71.60, 30.00, 10.00, 36.870, 48.50, 34.73, 85.92, 9.00, 3.32, 9.00, 3.32, 18.00, 6.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(298, '112207075-0200', 'HHSM20X2.5X75 GR 8.8', 'X', '73181500', 74.50, 30.00, 10.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(299, '112207080-0200', 'HHSM20X2.5X80 GR 8.8', 'X', '73181500', 76.65, 30.00, 10.00, 39.470, 48.50, 37.18, 91.98, 9.00, 3.55, 9.00, 3.55, 18.00, 7.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(300, '112207085-0200', 'HHSM20X2.5X85 GR 8.8', 'X', '73181500', 78.95, 30.00, 10.00, 40.660, 48.50, 38.29, 94.74, 9.00, 3.66, 9.00, 3.66, 18.00, 7.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(301, '112207090-0200', 'HHSM20X2.5X90 GR 8.8', 'X', '73181500', 81.50, 30.00, 10.00, 41.970, 48.50, 39.53, 97.80, 9.00, 3.78, 9.00, 3.78, 18.00, 7.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(302, '112207100-0200', 'HHSM20X2.5X100 GR 8.8', 'X', '73181500', 86.25, 30.00, 10.00, 44.420, 48.50, 41.83, 103.50, 9.00, 4.00, 9.00, 4.00, 18.00, 8.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(303, '112207110-0200', 'HHSM20X2.5X110 GR 8.8', 'X', '73181500', 91.05, 30.00, 10.00, 46.890, 48.50, 44.16, 109.26, 9.00, 4.22, 9.00, 4.22, 18.00, 8.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(304, '112207120-0200', 'HHSM20X2.5X120 GR 8.8', 'X', '73181500', 98.60, 30.00, 10.00, 50.780, 48.50, 47.82, 118.32, 9.00, 4.57, 9.00, 4.57, 18.00, 9.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(305, '112207130-0200', 'HHSM20X2.5X130 GR 8.8', 'X', '73181500', 105.35, 30.00, 10.00, 54.260, 48.50, 51.09, 126.42, 9.00, 4.88, 9.00, 4.88, 18.00, 9.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(306, '112207140-0200', 'HHSM20X2.5X140 GR 8.8', 'X', '73181500', 111.15, 40.00, 10.00, 57.240, 48.50, 53.91, 133.38, 9.00, 5.15, 9.00, 5.15, 18.00, 10.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(307, '112207150-0200', 'HHSM20X2.5X150 GR 8.8', 'X', '73181500', 115.65, 40.00, 10.00, 59.560, 48.50, 56.09, 138.78, 9.00, 5.36, 9.00, 5.36, 18.00, 10.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(308, '112207160-0200', 'HHSM20X2.5X160 GR 8.8', 'X', '73181500', 144.20, 40.00, 10.00, 74.260, 48.50, 69.94, 173.04, 9.00, 6.68, 9.00, 6.68, 18.00, 13.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(309, '112207180-0200', 'HHSM20X2.5X180 GR 8.8', 'X', '73181500', 157.25, 20.00, 10.00, 80.980, 48.50, 76.27, 188.70, 9.00, 7.29, 9.00, 7.29, 18.00, 14.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(310, '112227045-0200', 'HHSM22X2.5X45 GR 8.8', 'X', '73181500', 69.65, 40.00, 10.00, 35.870, 48.50, 33.78, 83.58, 9.00, 3.23, 9.00, 3.23, 18.00, 6.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(311, '112227050-0200', 'HHSM22X2.5X50 GR 8.8', 'X', '73181500', 77.20, 40.00, 10.00, 39.760, 48.50, 37.44, 92.64, 9.00, 3.58, 9.00, 3.58, 18.00, 7.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(312, '112227055-0200', 'HHSM22X2.5X55 GR 8.8', 'X', '73181500', 83.10, 30.00, 10.00, 42.800, 48.50, 40.30, 99.72, 9.00, 3.85, 9.00, 3.85, 18.00, 7.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(313, '112227060-0200', 'HHSM22X2.5X60 GR 8.8', 'X', '73181500', 86.10, 30.00, 10.00, 44.340, 48.50, 41.76, 103.32, 9.00, 3.99, 9.00, 3.99, 18.00, 7.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(314, '112227065-0200', 'HHSM22X2.5X65 GR 8.8', 'X', '73181500', 96.70, 30.00, 10.00, 49.800, 48.50, 46.90, 116.04, 9.00, 4.48, 9.00, 4.48, 18.00, 8.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(315, '112227070-0200', 'HHSM22X2.5X70 GR 8.8', 'X', '73181500', 99.95, 30.00, 10.00, 51.470, 48.50, 48.48, 119.94, 9.00, 4.63, 9.00, 4.63, 18.00, 9.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(316, '112227075-0200', 'HHSM22X2.5X75 GR 8.8', 'X', '73181500', 103.35, 30.00, 10.00, 53.230, 48.50, 50.12, 124.02, 9.00, 4.79, 9.00, 4.79, 18.00, 9.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(317, '112227080-0200', 'HHSM22X2.5X80 GR 8.8', 'X', '73181500', 107.40, 40.00, 10.00, 55.310, 48.50, 52.09, 128.88, 9.00, 4.98, 9.00, 4.98, 18.00, 9.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(318, '112227100-0200', 'HHSM22X2.5X100 GR 8.8', 'X', '73181500', 116.15, 15.00, 5.00, 59.820, 48.50, 56.33, 139.38, 9.00, 5.38, 9.00, 5.38, 18.00, 10.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(319, '112227120-0200', 'HHSM22X2.5X120 GR 8.8', 'X', '73181500', 141.75, 15.00, 5.00, 73.000, 48.50, 68.75, 170.10, 9.00, 6.57, 9.00, 6.57, 18.00, 13.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(320, '112243055-0200', 'HHSM24X1.5X55 GR 8.8', 'X', '73181500', 97.55, 30.00, 10.00, 50.240, 48.50, 47.31, 117.06, 9.00, 4.52, 9.00, 4.52, 18.00, 9.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(321, '112249045-0200', 'HHSM24X3X45 GR 8.8', 'X', '73181500', 97.25, 40.00, 10.00, 50.080, 48.50, 47.17, 116.70, 9.00, 4.51, 9.00, 4.51, 18.00, 9.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(322, '112249050-0200', 'HHSM24X3X50 GR 8.8', 'X', '73181500', 97.25, 30.00, 10.00, 50.080, 48.50, 47.17, 116.70, 9.00, 4.51, 9.00, 4.51, 18.00, 9.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(323, '112249055-0200', 'HHSM24X3X55 GR 8.8', 'X', '73181500', 97.55, 30.00, 10.00, 50.240, 48.50, 47.31, 117.06, 9.00, 4.52, 9.00, 4.52, 18.00, 9.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(324, '112249060-0200', 'HHSM24X3X60 GR 8.8', 'X', '73181500', 101.10, 30.00, 10.00, 52.070, 48.50, 49.03, 121.32, 9.00, 4.69, 9.00, 4.69, 18.00, 9.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(325, '112249065-0200', 'HHSM24X3X65 GR 8.8', 'X', '73181500', 104.75, 30.00, 10.00, 53.950, 48.50, 50.80, 125.70, 9.00, 4.86, 9.00, 4.86, 18.00, 9.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(326, '112249070-0200', 'HHSM24X3X70 GR 8.8', 'X', '73181500', 110.95, 40.00, 10.00, 57.140, 48.50, 53.81, 133.14, 9.00, 5.14, 9.00, 5.14, 18.00, 10.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(327, '112249075-0200', 'HHSM24X3X75 GR 8.8', 'X', '73181500', 115.05, 40.00, 10.00, 59.250, 48.50, 55.80, 138.06, 9.00, 5.33, 9.00, 5.33, 18.00, 10.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(328, '112249080-0200', 'HHSM24X3X80 GR 8.8', 'X', '73181500', 126.40, 40.00, 10.00, 65.100, 48.50, 61.30, 151.68, 9.00, 5.86, 9.00, 5.86, 18.00, 11.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(329, '112249085-0200', 'HHSM24X3X85 GR 8.8', 'X', '73181500', 130.55, 40.00, 10.00, 67.230, 48.50, 63.32, 156.66, 9.00, 6.05, 9.00, 6.05, 18.00, 12.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(330, '112249090-0200', 'HHSM24X3X90 GR 8.8', 'X', '73181500', 134.95, 40.00, 10.00, 69.500, 48.50, 65.45, 161.94, 9.00, 6.25, 9.00, 6.25, 18.00, 12.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(331, '112249100-0200', 'HHSM24X3X100 GR 8.8', 'X', '73181500', 145.90, 40.00, 10.00, 75.140, 48.50, 70.76, 175.08, 9.00, 6.76, 9.00, 6.76, 18.00, 13.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(332, '112249110-0200', 'HHSM24X3X110 GR 8.8', 'X', '73181500', 151.65, 15.00, 5.00, 78.100, 48.50, 73.55, 181.98, 9.00, 7.03, 9.00, 7.03, 18.00, 14.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(333, '112249120-0200', 'HHSM24X3X120 GR 8.8', 'X', '73181500', 160.15, 15.00, 5.00, 82.480, 48.50, 77.67, 192.18, 9.00, 7.42, 9.00, 7.42, 18.00, 14.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(334, '112249130-0200', 'HHSM24X3X130 GR 8.8', 'X', '73181500', 167.75, 15.00, 5.00, 86.390, 48.50, 81.36, 201.30, 9.00, 7.78, 9.00, 7.78, 18.00, 15.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(335, '112249140-0200', 'HHSM24X3X140 GR 8.8', 'X', '73181500', 175.75, 20.00, 5.00, 90.510, 48.50, 85.24, 210.90, 9.00, 8.15, 9.00, 8.15, 18.00, 16.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(336, '112249150-0200', 'HHSM24X3X150 GR 8.8', 'X', '73181500', 184.35, 20.00, 5.00, 94.940, 48.50, 89.41, 221.22, 9.00, 8.54, 9.00, 8.54, 18.00, 17.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(337, '112249160-0200', 'HHSM24X3X160 GR 8.8', 'X', '73181500', 200.50, 20.00, 5.00, 103.260, 48.50, 97.24, 240.60, 9.00, 9.29, 9.00, 9.29, 18.00, 18.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(338, '112249170-0200', 'HHSM24X3X170 GR 8.8', 'X', '73181500', 209.35, 10.00, 5.00, 107.820, 48.50, 101.53, 251.22, 9.00, 9.70, 9.00, 9.70, 18.00, 19.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(339, '112249180-0200', 'HHSM24X3X180 GR 8.8', 'X', '73181500', 217.85, 20.00, 5.00, 112.190, 48.50, 105.66, 261.42, 9.00, 10.10, 9.00, 10.10, 18.00, 20.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(340, '112249190-0200', 'HHSM24X3X190 GR 8.8', 'X', '73181500', 243.15, 20.00, 5.00, 125.220, 48.50, 117.93, 291.78, 9.00, 11.27, 9.00, 11.27, 18.00, 22.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(341, '112249200-0200', 'HHSM24X3X200 GR 8.8', 'X', '73181500', 235.00, 20.00, 5.00, 121.030, 48.50, 113.98, 282.00, 9.00, 10.89, 9.00, 10.89, 18.00, 21.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(342, '112249220-0200', 'HHSM24X3X220 GR 8.8', 'X', '73181500', 455.25, 20.00, 5.00, 234.450, 48.50, 220.80, 546.30, 9.00, 21.10, 9.00, 21.10, 18.00, 42.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(343, '112249280-0200', 'HHSM24X3X280 GR 8.8', 'X', '73181500', 536.50, 5.00, 5.00, 276.300, 48.50, 260.20, 643.80, 9.00, 24.87, 9.00, 24.87, 18.00, 49.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(344, '112279070-0200', 'HHSM27X3X70 GR 8.8', 'X', '73181500', 222.45, 20.00, 5.00, 114.560, 48.50, 107.89, 266.94, 9.00, 10.31, 9.00, 10.31, 18.00, 20.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(345, '112279080-0200', 'HHSM27X3X80 GR 8.8', 'X', '73181500', 250.00, 15.00, 15.00, 128.750, 48.50, 121.25, 300.00, 9.00, 11.59, 9.00, 11.59, 18.00, 23.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(346, '112279090-0200', 'HHSM27X3X90 GR 8.8', 'X', '73181500', 273.25, 20.00, 5.00, 140.720, 48.50, 132.53, 327.90, 9.00, 12.67, 9.00, 12.67, 18.00, 25.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(347, '112279100-0200', 'HHSM27X3X100 GR 8.8', 'X', '73181500', 296.55, 15.00, 15.00, 152.720, 48.50, 143.83, 355.86, 9.00, 13.75, 9.00, 13.75, 18.00, 27.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(348, '112307070-0200', 'HHSM30X3.5X70 GR 8.8', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(349, '112307080-0200', 'HHSM30X3.5X80 GR 8.8', 'X', '73181500', 307.15, 0.00, 0.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(350, '112307090-0200', 'HHSM30X3.5X090 GR 8.8', 'X', '73181500', 334.70, 20.00, 5.00, 172.370, 48.50, 162.33, 401.64, 9.00, 15.51, 9.00, 15.51, 18.00, 31.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(351, '112307100-0200', 'HHSM30X3.5X100 GR 8.8', 'X', '73181500', 360.05, 20.00, 5.00, 185.430, 48.50, 174.62, 432.06, 9.00, 16.69, 9.00, 16.69, 18.00, 33.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(352, '112307110-0200', 'HHSM30X3.5X110 GR 8.8', 'X', '73181500', 396.15, 20.00, 5.00, 204.020, 48.50, 192.13, 475.38, 9.00, 18.36, 9.00, 18.36, 18.00, 36.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(353, '112307120-0200', 'HHSM30X3.5X120 GR 8.8', 'X', '73181500', 404.55, 10.00, 5.00, 208.340, 48.50, 196.21, 485.46, 9.00, 18.75, 9.00, 18.75, 18.00, 37.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(354, '112307130-0200', 'HHSM30X3.5X130 GR 8.8', 'X', '73181500', 423.65, 10.00, 10.00, 218.180, 48.50, 205.47, 508.38, 9.00, 19.64, 9.00, 19.64, 18.00, 39.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(355, '112307140-0200', 'HHSM30X3.5X140 GR 8.8', 'X', '73181500', 449.00, 5.00, 5.00, 231.240, 48.50, 217.77, 538.80, 9.00, 20.81, 9.00, 20.81, 18.00, 41.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(356, '112307150-0200', 'HHSM30X3.5X150 GR 8.8', 'X', '73181500', 474.40, 5.00, 5.00, 244.320, 48.50, 230.08, 569.28, 9.00, 21.99, 9.00, 21.99, 18.00, 43.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(357, '112307160-0200', 'HHSM30X3.5X160 GR 8.8', 'X', '73181500', 512.55, 10.00, 10.00, 263.960, 48.50, 248.59, 615.06, 9.00, 23.76, 9.00, 23.76, 18.00, 47.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(358, '112307180-0200', 'HHSM30X3.5X180 GR 8.8', 'X', '73181500', 565.40, 5.00, 5.00, 291.180, 48.50, 274.22, 678.48, 9.00, 26.21, 9.00, 26.21, 18.00, 52.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(359, '112337125-0200', 'HHSM33X3.5X125 GR 8.8', 'X', '73181500', 542.15, 5.00, 5.00, 279.210, 48.50, 262.94, 650.58, 9.00, 25.13, 9.00, 25.13, 18.00, 50.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(360, '112337130-0200', 'HHSM33X3.5X130 GR 8.8', 'X', '73181500', 542.15, 10.00, 10.00, 279.210, 48.50, 262.94, 650.58, 9.00, 25.13, 9.00, 25.13, 18.00, 50.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(361, '112337150-0200', 'HHSM33X3.5X150 GR 8.8', 'X', '73181500', 607.70, 0.00, 0.00, 312.970, 48.50, 294.73, 729.24, 9.00, 28.17, 9.00, 28.17, 18.00, 56.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(362, '112369080-0200', 'HHSM36X4X80 GR 8.8', 'X', '73181500', 514.60, 5.00, 5.00, 265.020, 48.50, 249.58, 617.52, 9.00, 23.85, 9.00, 23.85, 18.00, 47.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(363, '112369090-0200', 'HHSM36X4X90 GR 8.8', 'X', '73181500', 552.80, 20.00, 5.00, 284.690, 48.50, 268.11, 663.36, 9.00, 25.62, 9.00, 25.62, 18.00, 51.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(364, '112369110-0200', 'HHSM36X4X110 GR 8.8', 'X', '73181500', 614.10, 5.00, 5.00, 316.260, 48.50, 297.84, 736.92, 9.00, 28.46, 9.00, 28.46, 18.00, 56.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(365, '112369130-0200', 'HHSM36X4X130 GR 8.8', 'X', '73181500', 658.65, 5.00, 5.00, 339.200, 48.50, 319.45, 790.38, 9.00, 30.53, 9.00, 30.53, 18.00, 61.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(366, '112369150-0200', 'HHSM36X4X150 GR 8.8', 'X', '73181500', 734.80, 5.00, 5.00, 378.420, 48.50, 356.38, 881.76, 9.00, 34.06, 9.00, 34.06, 18.00, 68.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(367, '112369160-0200', 'HHSM36X4X160 GR 8.8', 'X', '73181500', 770.85, 2.00, 2.00, 396.990, 48.50, 373.86, 925.02, 9.00, 35.73, 9.00, 35.73, 18.00, 71.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(368, '112369170-0200', 'HHSM36X4X170 GR 8.8', 'X', '73181500', 895.65, 0.00, 0.00, 461.260, 48.50, 434.39, 1074.78, 9.00, 41.51, 9.00, 41.51, 18.00, 83.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(369, '112422100-0200', 'HHSM42X4.5X100 GR 8.8', 'X', '73181500', 1006.35, 5.00, 5.00, 518.270, 48.50, 488.08, 1207.62, 9.00, 46.64, 9.00, 46.64, 18.00, 93.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(370, '112422180-0200', 'HHSM42X4.5X180 GR 8.8', 'X', '73181500', 1528.40, 5.00, 5.00, 787.130, 48.50, 741.27, 1834.08, 9.00, 70.84, 9.00, 70.84, 18.00, 141.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(371, '115051010-0200', 'HHSM5X0.8X10 GR 10.9', 'X', '73181500', 3.45, 4000.00, 1000.00, 1.780, 48.50, 1.67, 4.14, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(372, '115051012-0200', 'HHSM5X0.8X12 GR 10.9', 'X', '73181500', 3.55, 4000.00, 1000.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(373, '115051015-0200', 'HHSM5X0.8X15 GR 10.9', 'X', '73181500', 3.55, 2000.00, 500.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(374, '115051016-0200', 'HHSM5X0.8X16 GR 10.9', 'X', '73181500', 3.55, 4000.00, 1000.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(375, '115051018-0200', 'HHSM5X0.8X18 GR 10.9', 'X', '73181500', 3.90, 2000.00, 500.00, 2.010, 48.50, 1.89, 4.68, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(376, '115051020-0200', 'HHSM5X0.8X20 GR 10.9', 'X', '73181500', 4.15, 2000.00, 500.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(377, '115051022-0200', 'HHSM5X0.8X22 GR 10.9', 'X', '73181500', 4.15, 4000.00, 1000.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(378, '115051025-0200', 'HHSM5X0.8X25 GR 10.9', 'X', '73181500', 4.15, 2000.00, 500.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(379, '115051030-0200', 'HHSM5X0.8X30 GR 10.9', 'X', '73181500', 4.40, 1500.00, 500.00, 2.270, 48.50, 2.13, 5.28, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1500.00, 1500.00, 1500.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(380, '115061010-0200', 'HHSM6X1X10 GR 10.9', 'X', '73181500', 3.15, 2000.00, 500.00, 1.620, 48.50, 1.53, 3.78, 9.00, 0.15, 9.00, 0.15, 18.00, 0.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(381, '115061012-0200', 'HHSM6X1X12 GR 10.9', 'X', '73181500', 3.45, 2000.00, 500.00, 1.780, 48.50, 1.67, 4.14, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(382, '115061014-0200', 'HHSM6X1X14 GR 10.9', 'X', '73181500', 4.00, 4000.00, 500.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(383, '115061015-0200', 'HHSM6X1X15 GR 10.9', 'X', '73181500', 3.70, 3000.00, 500.00, 1.910, 48.50, 1.79, 4.44, 9.00, 0.17, 9.00, 0.17, 18.00, 0.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3000.00, 3000.00, 3000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(384, '115061016-0200', 'HHSM6X1X16 GR 10.9', 'X', '73181500', 3.55, 4000.00, 500.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(385, '115061018-0200', 'HHSM6X1X18 GR 10.9', 'X', '73181500', 3.90, 4000.00, 500.00, 2.010, 48.50, 1.89, 4.68, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(386, '115061020-0200', 'HHSM6X1X20 GR 10.9', 'X', '73181500', 4.00, 4000.00, 500.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4000.00, 4000.00, 4000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(387, '115061022-0200', 'HHSM6X1X22 GR 10.9', 'X', '73181500', 4.15, 2000.00, 500.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(388, '115061025-0200', 'HHSM6X1X25 GR 10.9', 'X', '73181500', 4.15, 1200.00, 200.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(389, '115061030-0200', 'HHSM6X1X30 GR 10.9', 'X', '73181500', 4.40, 1200.00, 200.00, 2.270, 48.50, 2.13, 5.28, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(390, '115061035-0200', 'HHSM6X1X35 GR 10.9', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(391, '115061040-0200', 'HHSM6X1X40 GR 10.9', 'X', '73181500', 4.90, 1200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(392, '115061045-0200', 'HHSM6X1X45 GR 10.9', 'X', '73181500', 4.90, 1200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(393, '115061050-0200', 'HHSM6X1X50 GR 10.9', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(394, '115082010-0200', 'HHSM8X1.25X10 GR 10.9', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(395, '115082012-0200', 'HHSM8X1.25X12 GR 10.9', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(396, '115082014-0200', 'HHSM8X1.25X14 GR 10.9', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(397, '115082015-0200', 'HHSM8X1.25X15 GR 10.9', 'X', '73181500', 5.20, 1200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(398, '115082016-0200', 'HHSM8X1.25X16 GR 10.9', 'X', '73181500', 4.90, 1200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(399, '115082018-0200', 'HHSM8X1.25X18 GR 10.9', 'X', '73181500', 3.55, 1200.00, 200.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(400, '115082020-0200', 'HHSM8X1.25X20 GR 10.9', 'X', '73181500', 3.55, 1600.00, 200.00, 1.830, 48.50, 1.72, 4.26, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 900.00, 1647.00, 'PCS', 0.00, 1100.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(401, '115082022-0200', 'HHSM8X1.25X22 GR 10.9', 'X', '73181500', 4.80, 800.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(402, '115082025-0200', 'HHSM8X1.25X25 GR 10.9', 'X', '73181500', 4.55, 1600.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(403, '115082028-0200', 'HHSM8X1.25X28 GR 10.9', 'X', '73181500', 5.10, 600.00, 200.00, 2.630, 48.50, 2.47, 6.12, 9.00, 0.24, 9.00, 0.24, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(404, '115082030-0200', 'HHSM8X1.25X30 GR 10.9', 'X', '73181500', 5.10, 600.00, 200.00, 2.630, 48.50, 2.47, 6.12, 9.00, 0.24, 9.00, 0.24, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(405, '115082035-0200', 'HHSM8X1.25X35 GR 10.9', 'X', '73181500', 4.55, 600.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(406, '115082040-0200', 'HHSM8X1.25X40 GR 10.9', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(407, '115082045-0200', 'HHSM8X1.25X45 GR 10.9', 'X', '73181500', 5.35, 800.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(408, '115082050-0200', 'HHSM8X1.25X50 GR 10.9', 'X', '73181500', 5.80, 800.00, 200.00, 2.990, 48.50, 2.81, 6.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(409, '115082055-0200', 'HHSM8X1.25X55 GR 10.9', 'X', '73181500', 7.00, 400.00, 100.00, 3.610, 48.50, 3.40, 8.40, 9.00, 0.32, 9.00, 0.32, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(410, '115082060-0200', 'HHSM8X1.25X60 GR 10.9', 'X', '73181500', 8.10, 300.00, 100.00, 4.170, 48.50, 3.93, 9.72, 9.00, 0.38, 9.00, 0.38, 18.00, 0.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(411, '115082065-0200', 'HHSM8X1.25X65 GR 10.9', 'X', '73181500', 8.35, 600.00, 50.00, 4.300, 48.50, 4.05, 10.02, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(412, '115082070-0200', 'HHSM8X1.25X70 GR 10.9', 'X', '73181500', 8.80, 400.00, 100.00, 4.530, 48.50, 4.27, 10.56, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(413, '115082075-0200', 'HHSM8X1.25X75 GR 10.9', 'X', '73181500', 9.15, 600.00, 50.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(414, '115082090-0200', 'HHSM8X1.25X90 GR 10.9', 'X', '73181500', 12.75, 200.00, 100.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(415, '115163060-0200', 'HHSM16X1.5X60 GR 10.9', 'X', '73181500', 36.95, 0.00, 0.00, 19.030, 48.50, 17.92, 44.34, 9.00, 1.71, 9.00, 1.71, 18.00, 3.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(416, '115165025-0200', 'HHSM16X2X25 GR 10.9', 'X', '73181500', 27.95, 120.00, 20.00, 14.390, 48.50, 13.56, 33.54, 9.00, 1.30, 9.00, 1.30, 18.00, 2.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(417, '115165030-0200', 'HHSM16X2X30 GR 10.9', 'X', '73181500', 27.95, 120.00, 20.00, 14.390, 48.50, 13.56, 33.54, 9.00, 1.30, 9.00, 1.30, 18.00, 2.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(418, '115165035-0200', 'HHSM16X2X35 GR 10.9', 'X', '73181500', 28.05, 120.00, 20.00, 14.450, 48.50, 13.60, 33.66, 9.00, 1.30, 9.00, 1.30, 18.00, 2.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(419, '115165040-0200', 'HHSM16X2X40 GR 10.9', 'X', '73181500', 28.40, 120.00, 20.00, 14.630, 48.50, 13.77, 34.08, 9.00, 1.32, 9.00, 1.32, 18.00, 2.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(420, '115165045-0200', 'HHSM16X2X45 GR 10.9', 'X', '73181500', 30.70, 80.00, 20.00, 15.810, 48.50, 14.89, 36.84, 9.00, 1.42, 9.00, 1.42, 18.00, 2.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(421, '115165050-0200', 'HHSM16X2X50 GR 10.9', 'X', '73181500', 32.25, 80.00, 20.00, 16.610, 48.50, 15.64, 38.70, 9.00, 1.49, 9.00, 1.49, 18.00, 2.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(422, '115165055-0200', 'HHSM16X2X55 GR 10.9', 'X', '73181500', 34.40, 80.00, 20.00, 17.720, 48.50, 16.68, 41.28, 9.00, 1.59, 9.00, 1.59, 18.00, 3.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(423, '115165060-0200', 'HHSM16X2X60 GR 10.9', 'X', '73181500', 36.95, 80.00, 20.00, 19.030, 48.50, 17.92, 44.34, 9.00, 1.71, 9.00, 1.71, 18.00, 3.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(424, '115165065-0200', 'HHSM16X2X65 GR 10.9', 'X', '73181500', 39.05, 60.00, 20.00, 20.110, 48.50, 18.94, 46.86, 9.00, 1.81, 9.00, 1.81, 18.00, 3.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(425, '115165070-0200', 'HHSM16X2X70 GR 10.9', 'X', '73181500', 41.45, 60.00, 20.00, 21.350, 48.50, 20.10, 49.74, 9.00, 1.92, 9.00, 1.92, 18.00, 3.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(426, '115165075-0200', 'HHSM16X2X75 GR 10.9', 'X', '73181500', 44.45, 60.00, 20.00, 22.890, 48.50, 21.56, 53.34, 9.00, 2.06, 9.00, 2.06, 18.00, 4.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(427, '115165080-0200', 'HHSM16X2X80 GR 10.9', 'X', '73181500', 48.50, 60.00, 20.00, 24.980, 48.50, 23.52, 58.20, 9.00, 2.25, 9.00, 2.25, 18.00, 4.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(428, '115165085-0200', 'HHSM16X2X85 GR 10.9', 'X', '73181500', 49.95, 60.00, 20.00, 25.720, 48.50, 24.23, 59.94, 9.00, 2.32, 9.00, 2.32, 18.00, 4.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(429, '115165090-0200', 'HHSM16X2X90 GR 10.9', 'X', '73181500', 51.90, 60.00, 20.00, 26.730, 48.50, 25.17, 62.28, 9.00, 2.41, 9.00, 2.41, 18.00, 4.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(430, '115165100-0200', 'HHSM16X2X100 GR 10.9', 'X', '73181500', 56.35, 80.00, 20.00, 29.020, 48.50, 27.33, 67.62, 9.00, 2.61, 9.00, 2.61, 18.00, 5.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(431, '115165110-0200', 'HHSM16X2X110 GR 10.9', 'X', '73181500', 61.25, 80.00, 20.00, 31.540, 48.50, 29.71, 73.50, 9.00, 2.84, 9.00, 2.84, 18.00, 5.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(432, '115165120-0200', 'HHSM16X2X120 GR 10.9', 'X', '73181500', 68.30, 80.00, 20.00, 35.170, 48.50, 33.13, 81.96, 9.00, 3.17, 9.00, 3.17, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(433, '115165140-0200', 'HHSM16X2X140 GR 10.9', 'X', '73181500', 83.40, 80.00, 20.00, 42.950, 48.50, 40.45, 100.08, 9.00, 3.87, 9.00, 3.87, 18.00, 7.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(434, '115165150-0200', 'HHSM16X2X150 GR 10.9', 'X', '73181500', 99.15, 40.00, 20.00, 51.060, 48.50, 48.09, 118.98, 9.00, 4.60, 9.00, 4.60, 18.00, 9.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(435, '115165160-0200', 'HHSM16X2X160 GR 10.9', 'X', '73181500', 102.75, 80.00, 20.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(436, '115183040-0200', 'HHSM18X1.5X40 GR 10.9', 'X', '73181500', 57.65, 80.00, 20.00, 29.690, 48.50, 27.96, 69.18, 9.00, 2.67, 9.00, 2.67, 18.00, 5.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(437, '115183045-0200', 'HHSM18X1.5X45 GR 10.9', 'X', '73181500', 60.10, 80.00, 20.00, 30.950, 48.50, 29.15, 72.12, 9.00, 2.79, 9.00, 2.79, 18.00, 5.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(438, '115183050-0200', 'HHSM18X1.5X50 GR 10.9', 'X', '73181500', 62.05, 80.00, 20.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(439, '115183055-0200', 'HHSM18X1.5X55 GR 10.9', 'X', '73181500', 66.15, 60.00, 20.00, 34.070, 48.50, 32.08, 79.38, 9.00, 3.07, 9.00, 3.07, 18.00, 6.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(440, '115183060-0200', 'HHSM18X1.5X60 GR 10.9', 'X', '73181500', 68.15, 60.00, 20.00, 35.100, 48.50, 33.05, 81.78, 9.00, 3.16, 9.00, 3.16, 18.00, 6.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(441, '115185050-0200', 'HHSM18X2X50 GR 10.9', 'X', '73181500', 56.25, 80.00, 20.00, 28.970, 48.50, 27.28, 67.50, 9.00, 2.61, 9.00, 2.61, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(442, '115187035-0200', 'HHSM18X2.5X35 GR 10.9', 'X', '73181500', 52.45, 80.00, 20.00, 27.010, 48.50, 25.44, 62.94, 9.00, 2.43, 9.00, 2.43, 18.00, 4.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(443, '115187040-0200', 'HHSM18X2.5X40 GR 10.9', 'X', '73181500', 52.45, 80.00, 20.00, 27.010, 48.50, 25.44, 62.94, 9.00, 2.43, 9.00, 2.43, 18.00, 4.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(444, '115187045-0200', 'HHSM18X2.5X45 GR 10.9', 'X', '73181500', 54.75, 80.00, 20.00, 28.200, 48.50, 26.55, 65.70, 9.00, 2.54, 9.00, 2.54, 18.00, 5.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(445, '115187050-0200', 'HHSM18X2.5X50 GR 10.9', 'X', '73181500', 56.25, 80.00, 20.00, 28.970, 48.50, 27.28, 67.50, 9.00, 2.61, 9.00, 2.61, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(446, '115187055-0200', 'HHSM18X2.5X55 GR 10.9', 'X', '73181500', 60.10, 60.00, 20.00, 30.950, 48.50, 29.15, 72.12, 9.00, 2.79, 9.00, 2.79, 18.00, 5.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(447, '115187060-0200', 'HHSM18X2.5X60 GR 10.9', 'X', '73181500', 62.05, 60.00, 20.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(448, '115187065-0200', 'HHSM18X2.5X65 GR 10.9', 'X', '73181500', 64.20, 60.00, 20.00, 33.060, 48.50, 31.14, 77.04, 9.00, 2.98, 9.00, 2.98, 18.00, 5.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(449, '115187070-0200', 'HHSM18X2.5X70 GR 10.9', 'X', '73181500', 66.85, 80.00, 20.00, 34.430, 48.50, 32.42, 80.22, 9.00, 3.10, 9.00, 3.10, 18.00, 6.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(450, '115187075-0200', 'HHSM18X2.5X75 GR 10.9', 'X', '73181500', 70.85, 80.00, 20.00, 36.490, 48.50, 34.36, 85.02, 9.00, 3.28, 9.00, 3.28, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(451, '115187080-0200', 'HHSM18X2.5X80 GR 10.9', 'X', '73181500', 70.85, 40.00, 10.00, 36.490, 48.50, 34.36, 85.02, 9.00, 3.28, 9.00, 3.28, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(452, '115187090-0200', 'HHSM18X2.5X90 GR 10.9', 'X', '73181500', 75.30, 30.00, 10.00, 38.780, 48.50, 36.52, 90.36, 9.00, 3.49, 9.00, 3.49, 18.00, 6.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(453, '115187100-0200', 'HHSM18X2.5X100 GR 10.9', 'X', '73181500', 79.90, 30.00, 10.00, 41.150, 48.50, 38.75, 95.88, 9.00, 3.70, 9.00, 3.70, 18.00, 7.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(454, '115203040-0200', 'HHSM20X1.5X40 GR 10.9', 'X', '73181500', 64.50, 60.00, 20.00, 33.220, 48.50, 31.28, 77.40, 9.00, 2.99, 9.00, 2.99, 18.00, 5.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(455, '115203045-0200', 'HHSM20X1.5X45 GR 10.9', 'X', '73181500', 66.75, 60.00, 20.00, 34.380, 48.50, 32.37, 80.10, 9.00, 3.09, 9.00, 3.09, 18.00, 6.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(456, '115203055-0200', 'HHSM20X1.5X55 GR 10.9', 'X', '73181500', 69.30, 80.00, 20.00, 35.690, 48.50, 33.61, 83.16, 9.00, 3.21, 9.00, 3.21, 18.00, 6.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(457, '115203060-0200', 'HHSM20X1.5X60 GR 10.9', 'X', '73181500', 73.50, 80.00, 20.00, 37.850, 48.50, 35.65, 88.20, 9.00, 3.41, 9.00, 3.41, 18.00, 6.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(458, '115203065-0200', 'HHSM20X1.5X65 GR 10.9', 'X', '73181500', 78.75, 40.00, 20.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(459, '115203070-0200', 'HHSM20X1.5X70 GR 10.9', 'X', '73181500', 78.75, 30.00, 10.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(460, '115203075-0200', 'HHSM20X1.5X75 GR 10.9', 'X', '73181500', 81.90, 30.00, 10.00, 42.180, 48.50, 39.72, 98.28, 9.00, 3.80, 9.00, 3.80, 18.00, 7.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(461, '115207030-0200', 'HHSM20X2.5X30 GR 10.9', 'X', '73181500', 58.65, 60.00, 20.00, 30.200, 48.50, 28.45, 70.38, 9.00, 2.72, 9.00, 2.72, 18.00, 5.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(462, '115207035-0200', 'HHSM20X2.5X35 GR 10.9', 'X', '73181500', 58.65, 60.00, 20.00, 30.200, 48.50, 28.45, 70.38, 9.00, 2.72, 9.00, 2.72, 18.00, 5.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(463, '115207040-0200', 'HHSM20X2.5X40 GR 10.9', 'X', '73181500', 58.65, 60.00, 20.00, 30.200, 48.50, 28.45, 70.38, 9.00, 2.72, 9.00, 2.72, 18.00, 5.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(464, '115207045-0200', 'HHSM20X2.5X45 GR 10.9', 'X', '73181500', 58.65, 60.00, 20.00, 30.200, 48.50, 28.45, 70.38, 9.00, 2.72, 9.00, 2.72, 18.00, 5.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(465, '115207050-0200', 'HHSM20X2.5X50 GR 10.9', 'X', '73181500', 60.65, 80.00, 20.00, 31.230, 48.50, 29.42, 72.78, 9.00, 2.81, 9.00, 2.81, 18.00, 5.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(466, '115207055-0200', 'HHSM20X2.5X55 GR 10.9', 'X', '73181500', 63.10, 80.00, 20.00, 32.500, 48.50, 30.60, 75.72, 9.00, 2.92, 9.00, 2.92, 18.00, 5.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(467, '115207060-0200', 'HHSM20X2.5X60 GR 10.9', 'X', '73181500', 66.85, 80.00, 20.00, 34.430, 48.50, 32.42, 80.22, 9.00, 3.10, 9.00, 3.10, 18.00, 6.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(468, '115207065-0200', 'HHSM20X2.5X65 GR 10.9', 'X', '73181500', 69.00, 80.00, 20.00, 35.540, 48.50, 33.47, 82.80, 9.00, 3.20, 9.00, 3.20, 18.00, 6.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(469, '115207070-0200', 'HHSM20X2.5X70 GR 10.9', 'X', '73181500', 71.60, 30.00, 10.00, 36.870, 48.50, 34.73, 85.92, 9.00, 3.32, 9.00, 3.32, 18.00, 6.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(470, '115207075-0200', 'HHSM20X2.5X75 GR 10.9', 'X', '73181500', 74.50, 30.00, 10.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(471, '115207080-0200', 'HHSM20X2.5X80 GR 10.9', 'X', '73181500', 76.65, 30.00, 10.00, 39.470, 48.50, 37.18, 91.98, 9.00, 3.55, 9.00, 3.55, 18.00, 7.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(472, '115207085-0200', 'HHSM20X2.5X85 GR 10.9', 'X', '73181500', 78.95, 30.00, 10.00, 40.660, 48.50, 38.29, 94.74, 9.00, 3.66, 9.00, 3.66, 18.00, 7.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(473, '115207090-0200', 'HHSM20X2.5X90 GR 10.9', 'X', '73181500', 81.50, 30.00, 10.00, 41.970, 48.50, 39.53, 97.80, 9.00, 3.78, 9.00, 3.78, 18.00, 7.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(474, '115207100-0200', 'HHSM20X2.5X100 GR 10.9', 'X', '73181500', 86.25, 30.00, 10.00, 44.420, 48.50, 41.83, 103.50, 9.00, 4.00, 9.00, 4.00, 18.00, 8.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(475, '115207110-0200', 'HHSM20X2.5X110 GR 10.9', 'X', '73181500', 91.05, 30.00, 10.00, 46.890, 48.50, 44.16, 109.26, 9.00, 4.22, 9.00, 4.22, 18.00, 8.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(476, '115207120-0200', 'HHSM20X2.5X120 GR 10.9', 'X', '73181500', 98.60, 30.00, 10.00, 50.780, 48.50, 47.82, 118.32, 9.00, 4.57, 9.00, 4.57, 18.00, 9.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(477, '115207130-0200', 'HHSM20X2.5X130 GR 10.9', 'X', '73181500', 105.35, 30.00, 10.00, 54.260, 48.50, 51.09, 126.42, 9.00, 4.88, 9.00, 4.88, 18.00, 9.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(478, '115207140-0200', 'HHSM20X2.5X140 GR 10.9', 'X', '73181500', 109.60, 40.00, 10.00, 56.440, 48.50, 53.16, 131.52, 9.00, 5.08, 9.00, 5.08, 18.00, 10.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(479, '115207150-0200', 'HHSM20X2.5X150 GR 10.9', 'X', '73181500', 115.65, 20.00, 10.00, 59.560, 48.50, 56.09, 138.78, 9.00, 5.36, 9.00, 5.36, 18.00, 10.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(480, '115207160-0200', 'HHSM20X2.5X160 GR 10.9', 'X', '73181500', 131.45, 40.00, 10.00, 67.700, 48.50, 63.75, 157.74, 9.00, 6.09, 9.00, 6.09, 18.00, 12.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(481, '115207180-0200', 'HHSM20X2.5X180 GR 10.9', 'X', '73181500', 157.25, 20.00, 10.00, 80.980, 48.50, 76.27, 188.70, 9.00, 7.29, 9.00, 7.29, 18.00, 14.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(482, '115223050-0200', 'HHSM22X1.5X50 GR 10.9', 'X', '73181500', 77.20, 40.00, 10.00, 39.760, 48.50, 37.44, 92.64, 9.00, 3.58, 9.00, 3.58, 18.00, 7.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(483, '115227045-0200', 'HHSM22X2.5X45 GR 10.9', 'X', '73181500', 69.65, 40.00, 10.00, 35.870, 48.50, 33.78, 83.58, 9.00, 3.23, 9.00, 3.23, 18.00, 6.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(484, '115227050-0200', 'HHSM22X2.5X50 GR 10.9', 'X', '73181500', 77.20, 40.00, 10.00, 39.760, 48.50, 37.44, 92.64, 9.00, 3.58, 9.00, 3.58, 18.00, 7.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(485, '115227055-0200', 'HHSM22X2.5X55 GR 10.9', 'X', '73181500', 83.10, 30.00, 10.00, 42.800, 48.50, 40.30, 99.72, 9.00, 3.85, 9.00, 3.85, 18.00, 7.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(486, '115227060-0200', 'HHSM22X2.5X60 GR 10.9', 'X', '73181500', 86.10, 30.00, 10.00, 44.340, 48.50, 41.76, 103.32, 9.00, 3.99, 9.00, 3.99, 18.00, 7.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(487, '115227065-0200', 'HHSM22X2.5X65 GR 10.9', 'X', '73181500', 96.70, 30.00, 10.00, 49.800, 48.50, 46.90, 116.04, 9.00, 4.48, 9.00, 4.48, 18.00, 8.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(488, '115227070-0200', 'HHSM22X2.5X70 GR 10.9', 'X', '73181500', 99.95, 30.00, 10.00, 51.470, 48.50, 48.48, 119.94, 9.00, 4.63, 9.00, 4.63, 18.00, 9.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(489, '115227075-0200', 'HHSM22X2.5X75 GR 10.9', 'X', '73181500', 103.35, 60.00, 10.00, 53.230, 48.50, 50.12, 124.02, 9.00, 4.79, 9.00, 4.79, 18.00, 9.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(490, '115227080-0200', 'HHSM22X2.5X80 GR 10.9', 'X', '73181500', 107.40, 40.00, 10.00, 55.310, 48.50, 52.09, 128.88, 9.00, 4.98, 9.00, 4.98, 18.00, 9.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(491, '115227090-0200', 'HHSM22X2.5X90 GR 10.9', 'X', '73181500', 114.40, 40.00, 10.00, 58.920, 48.50, 55.48, 137.28, 9.00, 5.30, 9.00, 5.30, 18.00, 10.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(492, '115227100-0200', 'HHSM22X2.5X100 GR 10.9', 'X', '73181500', 116.15, 40.00, 10.00, 59.820, 48.50, 56.33, 139.38, 9.00, 5.38, 9.00, 5.38, 18.00, 10.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(493, '115227110-0200', 'HHSM22X2.5X110 GR 10.9', 'X', '73181500', 132.80, 40.00, 10.00, 68.390, 48.50, 64.41, 159.36, 9.00, 6.16, 9.00, 6.16, 18.00, 12.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(494, '115249045-0200', 'HHSM24X3X45 GR 10.9', 'X', '73181500', 97.25, 40.00, 10.00, 50.080, 48.50, 47.17, 116.70, 9.00, 4.51, 9.00, 4.51, 18.00, 9.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(495, '115249050-0200', 'HHSM24X3X50 GR 10.9', 'X', '73181500', 97.25, 30.00, 10.00, 50.080, 48.50, 47.17, 116.70, 9.00, 4.51, 9.00, 4.51, 18.00, 9.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(496, '115249055-0200', 'HHSM24X3X55 GR 10.9', 'X', '73181500', 97.55, 30.00, 10.00, 50.240, 48.50, 47.31, 117.06, 9.00, 4.52, 9.00, 4.52, 18.00, 9.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(497, '115249060-0200', 'HHSM24X3X60 GR 10.9', 'X', '73181500', 101.10, 30.00, 10.00, 52.070, 48.50, 49.03, 121.32, 9.00, 4.69, 9.00, 4.69, 18.00, 9.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(498, '115249065-0200', 'HHSM24X3X65 GR 10.9', 'X', '73181500', 104.75, 30.00, 10.00, 53.950, 48.50, 50.80, 125.70, 9.00, 4.86, 9.00, 4.86, 18.00, 9.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(499, '115249070-0200', 'HHSM24X3X70 GR 10.9', 'X', '73181500', 110.95, 40.00, 10.00, 57.140, 48.50, 53.81, 133.14, 9.00, 5.14, 9.00, 5.14, 18.00, 10.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(500, '115249075-0200', 'HHSM24X3X75 GR 10.9', 'X', '73181500', 115.05, 40.00, 10.00, 59.250, 48.50, 55.80, 138.06, 9.00, 5.33, 9.00, 5.33, 18.00, 10.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(501, '115249080-0200', 'HHSM24X3X80 GR 10.9', 'X', '73181500', 126.40, 40.00, 10.00, 65.100, 48.50, 61.30, 151.68, 9.00, 5.86, 9.00, 5.86, 18.00, 11.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(502, '115249085-0200', 'HHSM24X3X85 GR 10.9', 'X', '73181500', 130.55, 40.00, 10.00, 67.230, 48.50, 63.32, 156.66, 9.00, 6.05, 9.00, 6.05, 18.00, 12.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(503, '115249090-0200', 'HHSM24X3X90 GR 10.9', 'X', '73181500', 134.95, 40.00, 10.00, 69.500, 48.50, 65.45, 161.94, 9.00, 6.25, 9.00, 6.25, 18.00, 12.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(504, '115249095-0200', 'HHSM24X3X95 GR 10.9', 'X', '73181500', 138.75, 40.00, 10.00, 71.460, 48.50, 67.29, 166.50, 9.00, 6.43, 9.00, 6.43, 18.00, 12.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(505, '115249100-0200', 'HHSM24X3X100 GR 10.9', 'X', '73181500', 145.90, 40.00, 10.00, 75.140, 48.50, 70.76, 175.08, 9.00, 6.76, 9.00, 6.76, 18.00, 13.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(506, '115249110-0200', 'HHSM24X3X110 GR 10.9', 'X', '73181500', 151.65, 15.00, 5.00, 78.100, 48.50, 73.55, 181.98, 9.00, 7.03, 9.00, 7.03, 18.00, 14.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(507, '115249120-0200', 'HHSM24X3X120 GR 10.9', 'X', '73181500', 160.15, 15.00, 5.00, 82.480, 48.50, 77.67, 192.18, 9.00, 7.42, 9.00, 7.42, 18.00, 14.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(508, '115249125-0200', 'HHSM24X3X125 GR 10.9', 'X', '73181500', 163.95, 15.00, 5.00, 84.430, 48.50, 79.52, 196.74, 9.00, 7.60, 9.00, 7.60, 18.00, 15.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(509, '115249130-0200', 'HHSM24X3X130 GR 10.9', 'X', '73181500', 167.75, 15.00, 5.00, 86.390, 48.50, 81.36, 201.30, 9.00, 7.78, 9.00, 7.78, 18.00, 15.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(510, '115249140-0200', 'HHSM24X3X140 GR 10.9', 'X', '73181500', 175.75, 20.00, 5.00, 90.510, 48.50, 85.24, 210.90, 9.00, 8.15, 9.00, 8.15, 18.00, 16.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(511, '115249150-0200', 'HHSM24X3X150 GR 10.9', 'X', '73181500', 184.35, 20.00, 5.00, 94.940, 48.50, 89.41, 221.22, 9.00, 8.54, 9.00, 8.54, 18.00, 17.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(512, '115249160-0200', 'HHSM24X3X160 GR 10.9', 'X', '73181500', 200.50, 20.00, 5.00, 103.260, 48.50, 97.24, 240.60, 9.00, 9.29, 9.00, 9.29, 18.00, 18.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(513, '115249170-0200', 'HHSM24X3X170 GR 10.9', 'X', '73181500', 209.35, 10.00, 5.00, 107.820, 48.50, 101.53, 251.22, 9.00, 9.70, 9.00, 9.70, 18.00, 19.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(514, '115249180-0200', 'HHSM24X3X180 GR 10.9', 'X', '73181500', 217.85, 20.00, 5.00, 112.190, 48.50, 105.66, 261.42, 9.00, 10.10, 9.00, 10.10, 18.00, 20.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(515, '115249200-0200', 'HHSM24X3X200 GR 10.9', 'X', '73181500', 235.00, 10.00, 5.00, 121.030, 48.50, 113.98, 282.00, 9.00, 10.89, 9.00, 10.89, 18.00, 21.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(516, '115279065-0200', 'HHSM27X3X65 GR 10.9', 'X', '73181500', 222.45, 15.00, 5.00, 114.560, 48.50, 107.89, 266.94, 9.00, 10.31, 9.00, 10.31, 18.00, 20.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(517, '115279070-0200', 'HHSM27X3X70 GR 10.9', 'X', '73181500', 222.45, 15.00, 5.00, 114.560, 48.50, 107.89, 266.94, 9.00, 10.31, 9.00, 10.31, 18.00, 20.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(518, '115279075-0200', 'HHSM27X3X75 GR 10.9', 'X', '73181500', 239.40, 15.00, 5.00, 123.290, 48.50, 116.11, 287.28, 9.00, 11.10, 9.00, 11.10, 18.00, 22.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(519, '115279080-0200', 'HHSM27X3X80 GR 10.9', 'X', '73181500', 250.00, 15.00, 5.00, 128.750, 48.50, 121.25, 300.00, 9.00, 11.59, 9.00, 11.59, 18.00, 23.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(520, '115279090-0200', 'HHSM27X3X90 GR 10.9', 'X', '73181500', 273.25, 15.00, 5.00, 140.720, 48.50, 132.53, 327.90, 9.00, 12.67, 9.00, 12.67, 18.00, 25.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(521, '115279100-0200', 'HHSM27X3X100 GR 10.9', 'X', '73181500', 296.55, 15.00, 5.00, 152.720, 48.50, 143.83, 355.86, 9.00, 13.75, 9.00, 13.75, 18.00, 27.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(522, '115279110-0200', 'HHSM27X3X110 GR 10.9', 'X', '73181500', 319.90, 20.00, 5.00, 164.750, 48.50, 155.15, 383.88, 9.00, 14.83, 9.00, 14.83, 18.00, 29.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(523, '115279120-0200', 'HHSM27X3X120 GR 10.9', 'X', '73181500', 326.20, 20.00, 5.00, 167.990, 48.50, 158.21, 391.44, 9.00, 15.12, 9.00, 15.12, 18.00, 30.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(524, '115279150-0200', 'HHSM27X3X150 GR 10.9', 'X', '73181500', 381.30, 20.00, 5.00, 196.370, 48.50, 184.93, 457.56, 9.00, 17.67, 9.00, 17.67, 18.00, 35.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(525, '115279180-0200', 'HHSM27X3X180 GR 10.9', 'X', '73181500', 444.75, 10.00, 5.00, 229.050, 48.50, 215.70, 533.70, 9.00, 20.61, 9.00, 20.61, 18.00, 41.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(526, '115307050-0200', 'HHSM30X3.5X50 GR 10.9', 'X', '73181500', 307.15, 15.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(527, '115307060-0200', 'HHSM30X3.5X60 GR 10.9', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(528, '115307065-0200', 'HHSM30X3.5X65 GR 10.9', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(529, '115307070-0200', 'HHSM30X3.5X70 GR 10.9', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(530, '115307075-0200', 'HHSM30X3.5X75 GR 10.9', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(531, '115307080-0200', 'HHSM30X3.5X80 GR 10.9', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(532, '115307085-0200', 'HHSM30X3.5X85 GR 10.9', 'X', '73181500', 334.70, 20.00, 5.00, 172.370, 48.50, 162.33, 401.64, 9.00, 15.51, 9.00, 15.51, 18.00, 31.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(533, '115307090-0200', 'HHSM30X3.5X90 GR 10.9', 'X', '73181500', 334.70, 10.00, 5.00, 172.370, 48.50, 162.33, 401.64, 9.00, 15.51, 9.00, 15.51, 18.00, 31.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(534, '115307100-0200', 'HHSM30X3.5X100 GR 10.9', 'X', '73181500', 360.05, 20.00, 5.00, 185.430, 48.50, 174.62, 432.06, 9.00, 16.69, 9.00, 16.69, 18.00, 33.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(535, '115307110-0200', 'HHSM30X3.5X110 GR 10.9', 'X', '73181500', 396.15, 20.00, 5.00, 204.020, 48.50, 192.13, 475.38, 9.00, 18.36, 9.00, 18.36, 18.00, 36.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(536, '115307120-0200', 'HHSM30X3.5X120 GR 10.9', 'X', '73181500', 404.55, 20.00, 5.00, 208.340, 48.50, 196.21, 485.46, 9.00, 18.75, 9.00, 18.75, 18.00, 37.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(537, '115307130-0200', 'HHSM30X3.5X130 GR 10.9', 'X', '73181500', 423.65, 5.00, 5.00, 218.180, 48.50, 205.47, 508.38, 9.00, 19.64, 9.00, 19.64, 18.00, 39.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(538, '115307140-0200', 'HHSM30X3.5X140 GR 10.9', 'X', '73181500', 449.00, 10.00, 5.00, 231.240, 48.50, 217.77, 538.80, 9.00, 20.81, 9.00, 20.81, 18.00, 41.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(539, '115307150-0200', 'HHSM30X3.5X150 GR 10.9', 'X', '73181500', 474.40, 10.00, 5.00, 244.320, 48.50, 230.08, 569.28, 9.00, 21.99, 9.00, 21.99, 18.00, 43.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(540, '115307160-0200', 'HHSM30X3.5X160 GR 10.9', 'X', '73181500', 512.55, 5.00, 5.00, 263.960, 48.50, 248.59, 615.06, 9.00, 23.76, 9.00, 23.76, 18.00, 47.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(541, '115307170-0200', 'HHSM30X3.5X170 GR 10.9', 'X', '73181500', 565.40, 20.00, 5.00, 291.180, 48.50, 274.22, 678.48, 9.00, 26.21, 9.00, 26.21, 18.00, 52.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(542, '115307180-0200', 'HHSM30X3.5X180 GR 10.9', 'X', '73181500', 565.40, 5.00, 5.00, 291.180, 48.50, 274.22, 678.48, 9.00, 26.21, 9.00, 26.21, 18.00, 52.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(543, '115307200-0200', 'HHSM30X3.5X200 GR 10.9', 'X', '73181500', 616.30, 5.00, 5.00, 317.390, 48.50, 298.91, 739.56, 9.00, 28.57, 9.00, 28.57, 18.00, 57.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(544, '115337075-0200', 'HHSM33X3.5X75 GR 10.9', 'X', '73181500', 410.85, 20.00, 5.00, 211.590, 48.50, 199.26, 493.02, 9.00, 19.04, 9.00, 19.04, 18.00, 38.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(545, '115337080-0200', 'HHSM33X3.5X80 GR 10.9', 'X', '73181500', 410.85, 8.00, 2.00, 211.590, 48.50, 199.26, 493.02, 9.00, 19.04, 9.00, 19.04, 18.00, 38.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(546, '115337090-0200', 'HHSM33X3.5X90 GR 10.9', 'X', '73181500', 436.25, 8.00, 2.00, 224.670, 48.50, 211.58, 523.50, 9.00, 20.22, 9.00, 20.22, 18.00, 40.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(547, '115337100-0200', 'HHSM33X3.5X100 GR 10.9', 'X', '73181500', 465.95, 20.00, 5.00, 239.960, 48.50, 225.99, 559.14, 9.00, 21.60, 9.00, 21.60, 18.00, 43.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(548, '115337110-0200', 'HHSM33X3.5X110 GR 10.9', 'X', '73181500', 502.00, 20.00, 5.00, 258.530, 48.50, 243.47, 602.40, 9.00, 23.27, 9.00, 23.27, 18.00, 46.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(549, '115337120-0200', 'HHSM33X3.5X120 GR 10.9', 'X', '73181500', 514.60, 8.00, 8.00, 265.020, 48.50, 249.58, 617.52, 9.00, 23.85, 9.00, 23.85, 18.00, 47.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(550, '115337130-0200', 'HHSM33X3.5X130 GR 10.9', 'X', '73181500', 542.15, 5.00, 5.00, 279.210, 48.50, 262.94, 650.58, 9.00, 25.13, 9.00, 25.13, 18.00, 50.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(551, '115337150-0200', 'HHSM33X3.5X150 GR 10.9', 'X', '73181500', 607.70, 5.00, 5.00, 312.970, 48.50, 294.73, 729.24, 9.00, 28.17, 9.00, 28.17, 18.00, 56.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(552, '115369075-0200', 'HHSM36X4X75 GR 10.9', 'X', '73181500', 514.60, 8.00, 2.00, 265.020, 48.50, 249.58, 617.52, 9.00, 23.85, 9.00, 23.85, 18.00, 47.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(553, '115369080-0200', 'HHSM36X4X80 GR 10.9', 'X', '73181500', 514.60, 8.00, 2.00, 265.020, 48.50, 249.58, 617.52, 9.00, 23.85, 9.00, 23.85, 18.00, 47.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(554, '115369085-0200', 'HHSM36X4X85 GR 10.9', 'X', '73181500', 552.80, 5.00, 5.00, 284.690, 48.50, 268.11, 663.36, 9.00, 25.62, 9.00, 25.62, 18.00, 51.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(555, '115369090-0200', 'HHSM36X4X90 GR 10.9', 'X', '73181500', 552.80, 8.00, 2.00, 284.690, 48.50, 268.11, 663.36, 9.00, 25.62, 9.00, 25.62, 18.00, 51.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(556, '115369100-0200', 'HHSM36X4X100 GR 10.9', 'X', '73181500', 576.00, 5.00, 5.00, 296.640, 48.50, 279.36, 691.20, 9.00, 26.70, 9.00, 26.70, 18.00, 53.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(557, '115369110-0200', 'HHSM36X4X110 GR 10.9', 'X', '73181500', 614.10, 5.00, 5.00, 316.260, 48.50, 297.84, 736.92, 9.00, 28.46, 9.00, 28.46, 18.00, 56.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(558, '115369120-0200', 'HHSM36X4X120 GR 10.9', 'X', '73181500', 626.80, 5.00, 5.00, 322.800, 48.50, 304.00, 752.16, 9.00, 29.05, 9.00, 29.05, 18.00, 58.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(559, '115369125-0200', 'HHSM36X4X125 GR 10.9', 'X', '73181500', 658.65, 5.00, 5.00, 339.200, 48.50, 319.45, 790.38, 9.00, 30.53, 9.00, 30.53, 18.00, 61.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(560, '115369130-0200', 'HHSM36X4X130 GR 10.9', 'X', '73181500', 658.65, 5.00, 5.00, 339.200, 48.50, 319.45, 790.38, 9.00, 30.53, 9.00, 30.53, 18.00, 61.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(561, '115369140-0200', 'HHSM36X4X140 GR 10.9', 'X', '73181500', 696.65, 5.00, 5.00, 358.770, 48.50, 337.88, 835.98, 9.00, 32.29, 9.00, 32.29, 18.00, 64.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(562, '115369150-0200', 'HHSM36X4X150 GR 10.9', 'X', '73181500', 734.80, 5.00, 5.00, 378.420, 48.50, 356.38, 881.76, 9.00, 34.06, 9.00, 34.06, 18.00, 68.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(563, '115369160-0200', 'HHSM36X4X160 GR 10.9', 'X', '73181500', 770.85, 5.00, 5.00, 396.990, 48.50, 373.86, 925.02, 9.00, 35.73, 9.00, 35.73, 18.00, 71.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(564, '115369200-0200', 'HHSM36X4X200 GR 10.9', 'X', '73181500', 969.80, 5.00, 5.00, 499.450, 48.50, 470.35, 1163.76, 9.00, 44.95, 9.00, 44.95, 18.00, 89.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(565, '115399100-0200', 'HHSM39X4X100 GR 10.9', 'X', '73181500', 538.95, 10.00, 10.00, 277.560, 48.50, 261.39, 646.74, 9.00, 24.98, 9.00, 24.98, 18.00, 49.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(566, '115399110-0200', 'HHSM39X4X110 GR 10.9', 'X', '73181500', 618.80, 5.00, 5.00, 318.680, 48.50, 300.12, 742.56, 9.00, 28.68, 9.00, 28.68, 18.00, 57.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(567, '115399140-0200', 'HHSM39X4X140 GR 10.9', 'X', '73181500', 833.50, 5.00, 5.00, 429.250, 48.50, 404.25, 1000.20, 9.00, 38.63, 9.00, 38.63, 18.00, 77.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(568, '115399160-0200', 'HHSM39X4X160 GR 10.9', 'X', '73181500', 1031.95, 8.00, 8.00, 531.450, 48.50, 500.50, 1238.34, 9.00, 47.83, 9.00, 47.83, 18.00, 95.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(569, '115399160-1200', 'HHSM39X4X160 GR 10.9', 'X', '73181500', 1031.95, 8.00, 8.00, 531.450, 48.50, 500.50, 1238.34, 9.00, 47.83, 9.00, 47.83, 18.00, 95.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(570, '115399180-0200', 'HHSM39X4X180 GR 10.9', 'X', '73181500', 1144.40, 8.00, 8.00, 589.370, 48.50, 555.03, 1373.28, 9.00, 53.04, 9.00, 53.04, 18.00, 106.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(571, '115422100-0200', 'HHSM42X4.5X100 GR 10.9', 'X', '73181500', 1006.35, 5.00, 5.00, 518.270, 48.50, 488.08, 1207.62, 9.00, 46.64, 9.00, 46.64, 18.00, 93.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(572, '115422120-0200', 'HHSM42X4.5X120 GR 10.9', 'X', '73181500', 1135.15, 5.00, 5.00, 584.600, 48.50, 550.55, 1362.18, 9.00, 52.61, 9.00, 52.61, 18.00, 105.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(573, '115422135-0200', 'HHSM42X4.5X135 GR 10.9', 'X', '73181500', 1199.50, 5.00, 5.00, 617.740, 48.50, 581.76, 1439.40, 9.00, 55.60, 9.00, 55.60, 18.00, 111.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(574, '115422150-0200', 'HHSM42X4.5X150 GR 10.9', 'X', '73181500', 1333.90, 5.00, 5.00, 686.960, 48.50, 646.94, 1600.68, 9.00, 61.83, 9.00, 61.83, 18.00, 123.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(575, '116082030-0200', 'HHSM8X1.25X30 GR 12.9', 'X', '73181500', 6.45, 600.00, 200.00, 3.320, 48.50, 3.13, 7.74, 9.00, 0.30, 9.00, 0.30, 18.00, 0.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(576, '116102022-0200', 'HHSM10X1.25X22 GR 12.9', 'X', '73181500', 10.20, 400.00, 100.00, 5.250, 48.50, 4.95, 12.24, 9.00, 0.47, 9.00, 0.47, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(577, '116187055-0200', 'HHSM18X2.5X55 GR 12.9', 'X', '73181500', 75.10, 60.00, 20.00, 38.680, 48.50, 36.42, 90.12, 9.00, 3.48, 9.00, 3.48, 18.00, 6.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(578, '116249150-0200', 'HHSM24X3X150 GR 12.9', 'X', '73181500', 230.45, 20.00, 5.00, 118.680, 48.50, 111.77, 276.54, 9.00, 10.68, 9.00, 10.68, 18.00, 21.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(579, '116249160-0200', 'HHSM24X3X160 GR 12.9', 'X', '73181500', 250.65, 20.00, 5.00, 129.080, 48.50, 121.57, 300.78, 9.00, 11.62, 9.00, 11.62, 18.00, 23.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(580, '122081008-0200', 'HHS1/4BSWX1/2 GR R', 'X', '73181500', 4.00, 1200.00, 200.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(581, '122081012-0200', 'HHS1/4BSWX3/4 GR R', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(582, '122081100-0200', 'HHS1/4BSWX1 GR R', 'X', '73181500', 4.55, 1200.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(583, '122081102-0200', 'HHS1/4BSWX1-1/8 GR R', 'X', '73181500', 4.80, 800.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(584, '122081104-0200', 'HHS1/4BSWX1-1/4 GR R', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(585, '122101008-0200', 'HHS5/16BSWX1/2 GR R', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(586, '122101012-0200', 'HHS5/16BSWX3/4 GR R', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(587, '122101100-0200', 'HHS5/16BSWX1 GR R', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(588, '122101200-0200', 'HHS5/16BSWX2 GR R', 'X', '73181500', 7.15, 600.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(589, '122121008-0200', 'HHS3/8BSWX1/2 GR R', 'X', '73181500', 8.35, 1200.00, 200.00, 4.300, 48.50, 4.05, 10.02, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(590, '122121012-0200', 'HHS3/8BSWX3/4 GR R', 'X', '73181500', 7.25, 600.00, 200.00, 3.730, 48.50, 3.52, 8.70, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(591, '122121100-0200', 'HHS3/8BSWX1 GR R', 'X', '73181500', 6.55, 400.00, 100.00, 3.370, 48.50, 3.18, 7.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(592, '122121104-0200', 'HHS3/8BSWX1-1/4 GR R', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(593, '122121108-0200', 'HHS3/8BSWX1-1/2 GR R', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(594, '122121200-0200', 'HHS3/8BSWX2 GR R', 'X', '73181500', 9.25, 300.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(595, '122161012-0200', 'HHS1/2BSWX3/4 GR R', 'X', '73181500', 13.80, 400.00, 100.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(596, '122161100-0200', 'HHS1/2BSWX1 GR R', 'X', '73181500', 14.55, 300.00, 50.00, 7.490, 48.50, 7.06, 17.46, 9.00, 0.67, 9.00, 0.67, 18.00, 1.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(597, '122161102-0200', 'HHS1/2BSWX1-1/8 GR R', 'X', '73181500', 15.85, 200.00, 50.00, 8.160, 48.50, 7.69, 19.02, 9.00, 0.73, 9.00, 0.73, 18.00, 1.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(598, '122161104-0200', 'HHS1/2BSWX1-1/4 GR R', 'X', '73181500', 15.45, 200.00, 50.00, 7.960, 48.50, 7.49, 18.54, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(599, '122161108-0200', 'HHS1/2BSWX1-1/2 GR R', 'X', '73181500', 15.25, 400.00, 50.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(600, '122161112-0200', 'HHS1/2BSWX1-3/4 GR R', 'X', '73181500', 17.25, 300.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(601, '122161200-0200', 'HHS1/2BSWX2 GR R', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(602, '122161208-0200', 'HHS1/2BSWX2-1/2 GR R', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(603, '122161300-0200', 'HHS1/2BSWX3 GR R', 'X', '73181500', 22.35, 80.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(604, '122201108-0200', 'HHS5/8BSWX1-1/2 GR R', 'X', '73181500', 30.55, 60.00, 20.00, 15.730, 48.50, 14.82, 36.66, 9.00, 1.42, 9.00, 1.42, 18.00, 2.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(605, '122201200-0200', 'HHS5/8BSWX2 GR R', 'X', '73181500', 32.70, 80.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(606, '122201208-0200', 'HHS5/8BSWX2-1/2 GR R', 'X', '73181500', 37.95, 20.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(607, '122201300-0200', 'HHS5/8BSWX3 GR R', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(608, '122241108-0200', 'HHS3/4BSWX1-1/2 GR R', 'X', '73181500', 56.15, 120.00, 20.00, 28.920, 48.50, 27.23, 67.38, 9.00, 2.60, 9.00, 2.60, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(609, '122241200-0200', 'HHS3/4BSWX2 GR R', 'X', '73181500', 62.15, 60.00, 20.00, 32.010, 48.50, 30.14, 74.58, 9.00, 2.88, 9.00, 2.88, 18.00, 5.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(610, '122241208-0200', 'HHS3/4BSWX2-1/2 GR R', 'X', '73181500', 68.25, 40.00, 10.00, 35.150, 48.50, 33.10, 81.90, 9.00, 3.16, 9.00, 3.16, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(611, '122281208-0200', 'HHS7/8BSWX2-1/2 GR R', 'X', '73181500', 95.85, 30.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(612, '122321208-0200', 'HHS1BSWX2-1/2 GR R', 'X', '73181500', 118.50, 30.00, 10.00, 61.030, 48.50, 57.47, 142.20, 9.00, 5.49, 9.00, 5.49, 18.00, 10.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(613, '122321300-0200', 'HHS1BSWX3 GR R', 'X', '73181500', 132.30, 40.00, 10.00, 68.130, 48.50, 64.17, 158.76, 9.00, 6.13, 9.00, 6.13, 18.00, 12.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(614, '128084008-0200', 'HHS1/4UNCX1/2 GR 5', 'X', '73181500', 4.00, 3000.00, 500.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3000.00, 3000.00, 3000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(615, '128084010-0200', 'HHS1/4UNCX5/8 GR 5', 'X', '73181500', 5.20, 1200.00, 1200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(616, '128084012-0200', 'HHS1/4UNCX3/4 GR 5', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(617, '128084014-0200', 'HHS1/4UNCX7/8 GR 5', 'X', '73181500', 4.30, 1200.00, 200.00, 2.210, 48.50, 2.09, 5.16, 9.00, 0.20, 9.00, 0.20, 18.00, 0.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(618, '128084100-0200', 'HHS1/4UNCX1 GR 5', 'X', '73181500', 4.55, 1200.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(619, '128084102-0200', 'HHS1/4UNCX1-1/8 GR 5', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(620, '128084104-0200', 'HHS1/4UNCX1-1/4 GR 5', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(621, '128084108-0200', 'HHS1/4UNCX1-1/2 GR 5', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(622, '128084112-0200', 'HHS1/4UNCX1-3/4 GR 5', 'X', '73181500', 5.20, 1200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(623, '128084200-0200', 'HHS1/4UNCX2 GR 5', 'X', '73181500', 5.70, 1200.00, 200.00, 2.940, 48.50, 2.76, 6.84, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(624, '128085008-0200', 'HHS1/4UNFX1/2 GR 5', 'X', '73181500', 4.00, 1500.00, 500.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1500.00, 1500.00, 1500.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(625, '128085010-0200', 'HHS1/4UNFX5/8 GR 5', 'X', '73181500', 5.20, 1200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(626, '128085012-0200', 'HHS1/4UNFX3/4 GR 5', 'X', '73181500', 4.65, 1200.00, 1200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(627, '128085014-0200', 'HHS1/4UNFX7/8 GR 5', 'X', '73181500', 4.30, 1200.00, 200.00, 2.210, 48.50, 2.09, 5.16, 9.00, 0.20, 9.00, 0.20, 18.00, 0.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(628, '128085100-0200', 'HHS1/4UNFX1 GR 5', 'X', '73181500', 4.55, 1200.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(629, '128085102-0200', 'HHS1/4UNFX1-1/8 GR 5', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(630, '128085104-0200', 'HHS1/4UNFX1-1/4 GR 5', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(631, '128085108-0200', 'HHS1/4UNFX1-1/2 GR 5', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(632, '128085112-0200', 'HHS1/4UNFX1-3/4 GR 5', 'X', '73181500', 5.20, 1200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(633, '128085200-0200', 'HHS1/4UNFX2 GR 5', 'X', '73181500', 5.70, 600.00, 100.00, 2.940, 48.50, 2.76, 6.84, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(634, '128104008-0200', 'HHS5/16UNCX1/2 GR 5', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(635, '128104010-0200', 'HHS5/16UNCX5/8 GR 5', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(636, '128104012-0200', 'HHS5/16UNCX3/4 GR 5', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(637, '128104014-0200', 'HHS5/16UNCX7/8 GR 5', 'X', '73181500', 5.55, 800.00, 200.00, 2.860, 48.50, 2.69, 6.66, 9.00, 0.26, 9.00, 0.26, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(638, '128104100-0200', 'HHS5/16UNCX1 GR 5', 'X', '73181500', 5.35, 800.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(639, '128104102-0200', 'HHS5/16UNCX1-1/8 GR 5', 'X', '73181500', 5.55, 800.00, 200.00, 2.860, 48.50, 2.69, 6.66, 9.00, 0.26, 9.00, 0.26, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(640, '128104104-0200', 'HHS5/16UNCX1-1/4 GR 5', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(641, '128104108-0200', 'HHS5/16UNCX1-1/2 GR 5', 'X', '73181500', 6.30, 600.00, 200.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(642, '128104110-0200', 'HHS5/16UNCX1-5/8 GR 5', 'X', '73181500', 6.65, 800.00, 200.00, 3.420, 48.50, 3.23, 7.98, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(643, '128104112-0200', 'HHS5/16UNCX1-3/4 GR 5', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(644, '128104200-0200', 'HHS5/16UNCX2 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(645, '128105008-0200', 'HHS5/16UNFX1/2 GR 5', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(646, '128105010-0200', 'HHS5/16UNFX5/8 GR 5', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(647, '128105012-0200', 'HHS5/16UNFX3/4 GR 5', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(648, '128105014-0200', 'HHS5/16UNFX7/8 GR 5', 'X', '73181500', 5.55, 800.00, 200.00, 2.860, 48.50, 2.69, 6.66, 9.00, 0.26, 9.00, 0.26, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(649, '128105100-0200', 'HHS5/16UNFX1 GR 5', 'X', '73181500', 5.35, 800.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(650, '128105102-0200', 'HHS5/16UNFX1-1/8 GR 5', 'X', '73181500', 5.55, 800.00, 200.00, 2.860, 48.50, 2.69, 6.66, 9.00, 0.26, 9.00, 0.26, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(651, '128105104-0200', 'HHS5/16UNFX1-1/4 GR 5', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(652, '128105108-0200', 'HHS5/16UNFX1-1/2 GR 5', 'X', '73181500', 6.30, 600.00, 200.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(653, '128105112-0200', 'HHS5/16UNFX1-3/4 GR 5', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(654, '128105200-0200', 'HHS5/16UNFX2 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(655, '128124008-0200', 'HHS3/8UNCX1/2 GR 5', 'X', '73181500', 8.35, 800.00, 200.00, 4.300, 48.50, 4.05, 10.02, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(656, '128124010-0200', 'HHS3/8UNCX5/8 GR 5', 'X', '73181500', 8.70, 1200.00, 200.00, 4.480, 48.50, 4.22, 10.44, 9.00, 0.40, 9.00, 0.40, 18.00, 0.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(657, '128124012-0200', 'HHS3/8UNCX3/4 GR 5', 'X', '73181500', 7.25, 600.00, 200.00, 3.730, 48.50, 3.52, 8.70, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(658, '128124014-0200', 'HHS3/8UNCX7/8 GR 5', 'X', '73181500', 9.15, 600.00, 200.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(659, '128124100-0200', 'HHS3/8UNCX1 GR 5', 'X', '73181500', 6.55, 800.00, 200.00, 3.370, 48.50, 3.18, 7.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(660, '128124102-0200', 'HHS3/8UNCX1-1/8 GR 5', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(661, '128124104-0200', 'HHS3/8UNCX1-1/4 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(662, '128124106-0200', 'HHS3/8UNCX1-3/8 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(663, '128124108-0200', 'HHS3/8UNCX1-1/2 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(664, '128124110-0200', 'HHS3/8UNCX1-5/8 GR 5', 'X', '73181500', 8.95, 400.00, 100.00, 4.610, 48.50, 4.34, 10.74, 9.00, 0.41, 9.00, 0.41, 18.00, 0.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(665, '128124112-0200', 'HHS3/8UNCX1-3/4 GR 5', 'X', '73181500', 8.50, 300.00, 100.00, 4.380, 48.50, 4.12, 10.20, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(666, '128124200-0200', 'HHS3/8UNCX2 GR 5', 'X', '73181500', 9.25, 300.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(667, '128125008-0200', 'HHS3/8UNFX1/2 GR 5', 'X', '73181500', 8.35, 600.00, 200.00, 4.300, 48.50, 4.05, 10.02, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(668, '128125010-0200', 'HHS3/8UNFX5/8 GR 5', 'X', '73181500', 8.70, 600.00, 200.00, 4.480, 48.50, 4.22, 10.44, 9.00, 0.40, 9.00, 0.40, 18.00, 0.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(669, '128125012-0200', 'HHS3/8UNFX3/4 GR 5', 'X', '73181500', 7.25, 600.00, 200.00, 3.730, 48.50, 3.52, 8.70, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(670, '128125014-0200', 'HHS3/8UNFX7/8 GR 5', 'X', '73181500', 9.15, 600.00, 200.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(671, '128125100-0200', 'HHS3/8UNFX1 GR 5', 'X', '73181500', 6.55, 800.00, 200.00, 3.370, 48.50, 3.18, 7.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(672, '128125102-0200', 'HHS3/8UNFX1-1/8 GR 5', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(673, '128125104-0200', 'HHS3/8UNFX1-1/4 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(674, '128125106-0200', 'HHS3/8UNFX1-3/8 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(675, '128125108-0200', 'HHS3/8UNFX1-1/2 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(676, '128125112-0200', 'HHS3/8UNFX1-3/4 GR 5', 'X', '73181500', 8.50, 300.00, 100.00, 4.380, 48.50, 4.12, 10.20, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(677, '128125200-0200', 'HHS3/8UNFX2 GR 5', 'X', '73181500', 9.25, 300.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(678, '128144010-0200', 'HHS7/16UNCX5/8 GR 5', 'X', '73181500', 7.70, 600.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(679, '128144012-0200', 'HHS7/16UNCX3/4 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(680, '128144014-0200', 'HHS7/16UNCX7/8 GR 5', 'X', '73181500', 8.70, 600.00, 100.00, 4.480, 48.50, 4.22, 10.44, 9.00, 0.40, 9.00, 0.40, 18.00, 0.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(681, '128144100-0200', 'HHS7/16UNCX1 GR 5', 'X', '73181500', 8.95, 800.00, 100.00, 4.610, 48.50, 4.34, 10.74, 9.00, 0.41, 9.00, 0.41, 18.00, 0.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(682, '128144102-0200', 'HHS7/16UNCX1-1/8 GR 5', 'X', '73181500', 9.75, 400.00, 100.00, 5.020, 48.50, 4.73, 11.70, 9.00, 0.45, 9.00, 0.45, 18.00, 0.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(683, '128144104-0200', 'HHS7/16UNCX1-1/4 GR 5', 'X', '73181500', 9.65, 300.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(684, '128144108-0200', 'HHS7/16UNCX1-1/2 GR 5', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(685, '128144112-0200', 'HHS7/16UNCX1-3/4 GR 5', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(686, '128144200-0200', 'HHS7/16UNCX2 GR 5', 'X', '73181500', 12.75, 200.00, 50.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(687, '128145010-0200', 'HHS7/16UNFX5/8 GR 5', 'X', '73181500', 7.70, 600.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(688, '128145012-0200', 'HHS7/16UNFX3/4 GR 5', 'X', '73181500', 7.70, 600.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(689, '128145014-0200', 'HHS7/16UNFX7/8 GR 5', 'X', '73181500', 8.70, 600.00, 100.00, 4.480, 48.50, 4.22, 10.44, 9.00, 0.40, 9.00, 0.40, 18.00, 0.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(690, '128145100-0200', 'HHS7/16UNFX1 GR 5', 'X', '73181500', 8.95, 400.00, 100.00, 4.610, 48.50, 4.34, 10.74, 9.00, 0.41, 9.00, 0.41, 18.00, 0.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(691, '128145102-0200', 'HHS7/16UNFX1-1/8 GR 5', 'X', '73181500', 9.75, 400.00, 100.00, 5.020, 48.50, 4.73, 11.70, 9.00, 0.45, 9.00, 0.45, 18.00, 0.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(692, '128145104-0200', 'HHS7/16UNFX1-1/4 GR 5', 'X', '73181500', 9.65, 300.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(693, '128145106-0200', 'HHS7/16UNFX1-3/8 GR 5', 'X', '73181500', 9.95, 400.00, 100.00, 5.120, 48.50, 4.83, 11.94, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(694, '128145108-0200', 'HHS7/16UNFX1-1/2 GR 5', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(695, '128145112-0200', 'HHS7/16UNFX1-3/4 GR 5', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(696, '128145200-0200', 'HHS7/16UNFX2 GR 5', 'X', '73181500', 12.75, 200.00, 50.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(697, '128164012-0200', 'HHS1/2UNCX3/4 GR 5', 'X', '73181500', 13.80, 400.00, 100.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(698, '128164014-0200', 'HHS1/2UNCX7/8 GR 5', 'X', '73181500', 15.00, 300.00, 50.00, 7.730, 48.50, 7.28, 18.00, 9.00, 0.70, 9.00, 0.70, 18.00, 1.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(699, '128164100-0200', 'HHS1/2UNCX1 GR 5', 'X', '73181500', 14.55, 300.00, 50.00, 7.490, 48.50, 7.06, 17.46, 9.00, 0.67, 9.00, 0.67, 18.00, 1.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(700, '128164102-0200', 'HHS1/2UNCX1-1/8 GR 5', 'X', '73181500', 15.85, 300.00, 50.00, 8.160, 48.50, 7.69, 19.02, 9.00, 0.73, 9.00, 0.73, 18.00, 1.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(701, '128164104-0200', 'HHS1/2UNCX1-1/4 GR 5', 'X', '73181500', 15.45, 400.00, 50.00, 7.960, 48.50, 7.49, 18.54, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(702, '128164106-0200', 'HHS1/2UNCX1-3/8 GR 5', 'X', '73181500', 16.80, 200.00, 50.00, 8.650, 48.50, 8.15, 20.16, 9.00, 0.78, 9.00, 0.78, 18.00, 1.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(703, '128164108-0200', 'HHS1/2UNCX1-1/2 GR 5', 'X', '73181500', 15.25, 200.00, 50.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(704, '128164110-0200', 'HHS1/2UNCX1-5/8 GR 5', 'X', '73181500', 17.85, 300.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(705, '128164112-0200', 'HHS1/2UNCX1-3/4 GR 5', 'X', '73181500', 17.25, 150.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(706, '128164114-0200', 'HHS1/2UNCX1-7/8 GR 5', 'X', '73181500', 19.60, 150.00, 50.00, 10.090, 48.50, 9.51, 23.52, 9.00, 0.91, 9.00, 0.91, 18.00, 1.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(707, '128164200-0200', 'HHS1/2UNCX2 GR 5', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(708, '128164204-0200', 'HHS1/2UNCX2-1/4 GR 5', 'X', '73181500', 19.85, 200.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(709, '128164208-0200', 'HHS1/2UNCX2-1/2 GR 5', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(710, '128164300-0200', 'HHS1/2UNCX3 GR 5', 'X', '73181500', 22.35, 80.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(711, '128165012-0200', 'HHS1/2UNFX3/4 GR 5', 'X', '73181500', 13.80, 400.00, 100.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(712, '128165100-0200', 'HHS1/2UNFX1 GR 5', 'X', '73181500', 14.55, 300.00, 50.00, 7.490, 48.50, 7.06, 17.46, 9.00, 0.67, 9.00, 0.67, 18.00, 1.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(713, '128165102-0200', 'HHS1/2UNFX1-1/8 GR 5', 'X', '73181500', 15.85, 300.00, 50.00, 8.160, 48.50, 7.69, 19.02, 9.00, 0.73, 9.00, 0.73, 18.00, 1.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(714, '128165104-0200', 'HHS1/2UNFX1-1/4 GR 5', 'X', '73181500', 15.45, 200.00, 50.00, 7.960, 48.50, 7.49, 18.54, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(715, '128165108-0200', 'HHS1/2UNFX1-1/2 GR 5', 'X', '73181500', 15.25, 200.00, 50.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(716, '128165110-0200', 'HHS1/2UNFX1-5/8 GR 5', 'X', '73181500', 17.85, 150.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(717, '128165112-0200', 'HHS1/2UNFX1-3/4 GR 5', 'X', '73181500', 17.25, 150.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(718, '128165200-0200', 'HHS1/2UNFX2 GR 5', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(719, '128165208-0200', 'HHS1/2UNFX2-1/2 GR 5', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(720, '128165300-0200', 'HHS1/2UNFX3 GR 5', 'X', '73181500', 22.35, 80.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(721, '128184100-0200', 'HHS9/16UNCX1 GR 5', 'X', '73181500', 16.95, 200.00, 50.00, 8.730, 48.50, 8.22, 20.34, 9.00, 0.79, 9.00, 0.79, 18.00, 1.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(722, '128184104-0200', 'HHS9/16UNCX1-1/4 GR 5', 'X', '73181500', 18.45, 200.00, 50.00, 9.500, 48.50, 8.95, 22.14, 9.00, 0.86, 9.00, 0.86, 18.00, 1.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(723, '128184108-0200', 'HHS9/16UNCX1-1/2 GR 5', 'X', '73181500', 21.55, 200.00, 50.00, 11.100, 48.50, 10.45, 25.86, 9.00, 1.00, 9.00, 1.00, 18.00, 2.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(724, '128185100-0200', 'HHS9/16UNFX1 GR 5', 'X', '73181500', 16.95, 50.00, 50.00, 8.730, 48.50, 8.22, 20.34, 9.00, 0.79, 9.00, 0.79, 18.00, 1.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(725, '128185104-0200', 'HHS9/16UNFX1-1/4 GR 5', 'X', '73181500', 18.45, 50.00, 50.00, 9.500, 48.50, 8.95, 22.14, 9.00, 0.86, 9.00, 0.86, 18.00, 1.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(726, '128185108-0200', 'HHS9/16UNFX1-1/2 GR 5', 'X', '73181500', 21.55, 50.00, 50.00, 11.100, 48.50, 10.45, 25.86, 9.00, 1.00, 9.00, 1.00, 18.00, 2.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(727, '128185112-0200', 'HHS9/16UNFX1-3/4 GR 5', 'X', '73181500', 18.55, 50.00, 50.00, 9.550, 48.50, 9.00, 22.26, 9.00, 0.86, 9.00, 0.86, 18.00, 1.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(728, '128204100-0200', 'HHS5/8UNCX1 GR 5', 'X', '73181500', 27.40, 120.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(729, '128204104-0200', 'HHS5/8UNCX1-1/4 GR 5', 'X', '73181500', 29.10, 120.00, 20.00, 14.990, 48.50, 14.11, 34.92, 9.00, 1.35, 9.00, 1.35, 18.00, 2.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(730, '128204108-0200', 'HHS5/8UNCX1-1/2 GR 5', 'X', '73181500', 30.55, 120.00, 20.00, 15.730, 48.50, 14.82, 36.66, 9.00, 1.42, 9.00, 1.42, 18.00, 2.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(731, '128204110-0200', 'HHS5/8UNCX1-5/8 GR 5', 'X', '73181500', 32.55, 80.00, 20.00, 16.760, 48.50, 15.79, 39.06, 9.00, 1.51, 9.00, 1.51, 18.00, 3.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(732, '128204112-0200', 'HHS5/8UNCX1-3/4 GR 5', 'X', '73181500', 31.20, 80.00, 20.00, 16.070, 48.50, 15.13, 37.44, 9.00, 1.45, 9.00, 1.45, 18.00, 2.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(733, '128204200-0200', 'HHS5/8UNCX2 GR 5', 'X', '73181500', 32.70, 160.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(734, '128204204-0200', 'HHS5/8UNCX2-1/4 GR 5', 'X', '73181500', 34.55, 80.00, 20.00, 17.790, 48.50, 16.76, 41.46, 9.00, 1.60, 9.00, 1.60, 18.00, 3.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(735, '128204208-0200', 'HHS5/8UNCX2-1/2 GR 5', 'X', '73181500', 37.95, 160.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(736, '128204300-0200', 'HHS5/8UNCX3 GR 5', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(737, '128205100-0200', 'HHS5/8UNFX1 GR 5', 'X', '73181500', 27.40, 120.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(738, '128205102-0200', 'HHS5/8UNFX1-1/8 GR 5', 'X', '73181500', 29.55, 80.00, 20.00, 15.220, 48.50, 14.33, 35.46, 9.00, 1.37, 9.00, 1.37, 18.00, 2.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(739, '128205104-0200', 'HHS5/8UNFX1-1/4 GR 5', 'X', '73181500', 29.10, 120.00, 20.00, 14.990, 48.50, 14.11, 34.92, 9.00, 1.35, 9.00, 1.35, 18.00, 2.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(740, '128205108-0200', 'HHS5/8UNFX1-1/2 GR 5', 'X', '73181500', 30.55, 120.00, 20.00, 15.730, 48.50, 14.82, 36.66, 9.00, 1.42, 9.00, 1.42, 18.00, 2.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(741, '128205112-0200', 'HHS5/8UNFX1-3/4 GR 5', 'X', '73181500', 31.20, 80.00, 20.00, 16.070, 48.50, 15.13, 37.44, 9.00, 1.45, 9.00, 1.45, 18.00, 2.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(742, '128205200-0200', 'HHS5/8UNFX2 GR 5', 'X', '73181500', 32.70, 80.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(743, '128205208-0200', 'HHS5/8UNFX2-1/2 GR 5', 'X', '73181500', 37.95, 80.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(744, '128205300-0200', 'HHS5/8UNFX3 GR 5', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(745, '128244104-0200', 'HHS3/4UNCX1-1/4 GR 5', 'X', '73181500', 53.65, 80.00, 20.00, 27.630, 48.50, 26.02, 64.38, 9.00, 2.49, 9.00, 2.49, 18.00, 4.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(746, '128244106-0200', 'HHS3/4UNCX1-3/8 GR 5', 'X', '73181500', 58.75, 80.00, 20.00, 30.260, 48.50, 28.49, 70.50, 9.00, 2.72, 9.00, 2.72, 18.00, 5.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(747, '128244108-0200', 'HHS3/4UNCX1-1/2 GR 5', 'X', '73181500', 56.15, 160.00, 20.00, 28.920, 48.50, 27.23, 67.38, 9.00, 2.60, 9.00, 2.60, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(748, '128244112-0200', 'HHS3/4UNCX1-3/4 GR 5', 'X', '73181500', 58.30, 80.00, 20.00, 30.020, 48.50, 28.28, 69.96, 9.00, 2.70, 9.00, 2.70, 18.00, 5.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(749, '128244200-0200', 'HHS3/4UNCX2 GR 5', 'X', '73181500', 62.15, 60.00, 20.00, 32.010, 48.50, 30.14, 74.58, 9.00, 2.88, 9.00, 2.88, 18.00, 5.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(750, '128244204-0200', 'HHS3/4UNCX2-1/4 GR 5', 'X', '73181500', 65.05, 40.00, 10.00, 33.500, 48.50, 31.55, 78.06, 9.00, 3.02, 9.00, 3.02, 18.00, 6.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(751, '128244208-0200', 'HHS3/4UNCX2-1/2 GR 5', 'X', '73181500', 68.25, 80.00, 10.00, 35.150, 48.50, 33.10, 81.90, 9.00, 3.16, 9.00, 3.16, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(752, '128244212-0200', 'HHS3/4UNCX2-3/4 GR 5', 'X', '73181500', 74.50, 40.00, 10.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(753, '128244300-0200', 'HHS3/4UNCX3 GR 5', 'X', '73181500', 77.35, 40.00, 10.00, 39.840, 48.50, 37.51, 92.82, 9.00, 3.59, 9.00, 3.59, 18.00, 7.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(754, '128245104-0200', 'HHS3/4UNFX1-1/4 GR 5', 'X', '73181500', 53.65, 80.00, 20.00, 27.630, 48.50, 26.02, 64.38, 9.00, 2.49, 9.00, 2.49, 18.00, 4.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(755, '128245108-0200', 'HHS3/4UNFX1-1/2 GR 5', 'X', '73181500', 56.15, 80.00, 20.00, 28.920, 48.50, 27.23, 67.38, 9.00, 2.60, 9.00, 2.60, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(756, '128245110-0200', 'HHS3/4UNFX1-5/8 GR 5', 'X', '73181500', 61.05, 60.00, 20.00, 31.440, 48.50, 29.61, 73.26, 9.00, 2.83, 9.00, 2.83, 18.00, 5.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(757, '128245112-0200', 'HHS3/4UNFX1-3/4 GR 5', 'X', '73181500', 58.30, 80.00, 20.00, 30.020, 48.50, 28.28, 69.96, 9.00, 2.70, 9.00, 2.70, 18.00, 5.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(758, '128245200-0200', 'HHS3/4UNFX2 GR 5', 'X', '73181500', 62.15, 60.00, 20.00, 32.010, 48.50, 30.14, 74.58, 9.00, 2.88, 9.00, 2.88, 18.00, 5.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(759, '128245204-0200', 'HHS3/4UNFX2-1/4 GR 5', 'X', '73181500', 65.05, 40.00, 10.00, 33.500, 48.50, 31.55, 78.06, 9.00, 3.02, 9.00, 3.02, 18.00, 6.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(760, '128245208-0200', 'HHS3/4UNFX2-1/2 GR 5', 'X', '73181500', 68.25, 40.00, 10.00, 35.150, 48.50, 33.10, 81.90, 9.00, 3.16, 9.00, 3.16, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(761, '128245212-0200', 'HHS3/4UNFX2-3/4 GR 5', 'X', '73181500', 74.50, 160.00, 40.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(762, '128245300-0200', 'HHS3/4UNFX3 GR 5', 'X', '73181500', 77.35, 40.00, 10.00, 39.840, 48.50, 37.51, 92.82, 9.00, 3.59, 9.00, 3.59, 18.00, 7.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(763, '128284108-0200', 'HHS7/8UNCX1-1/2 GR 5', 'X', '73181500', 78.55, 40.00, 10.00, 40.450, 48.50, 38.10, 94.26, 9.00, 3.64, 9.00, 3.64, 18.00, 7.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(764, '128284112-0200', 'HHS7/8UNCX1-3/4 GR 5', 'X', '73181500', 82.25, 40.00, 10.00, 42.360, 48.50, 39.89, 98.70, 9.00, 3.81, 9.00, 3.81, 18.00, 7.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(765, '128284200-0200', 'HHS7/8UNCX2 GR 5', 'X', '73181500', 86.35, 40.00, 10.00, 44.470, 48.50, 41.88, 103.62, 9.00, 4.00, 9.00, 4.00, 18.00, 8.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(766, '128284204-0200', 'HHS7/8UNCX2-1/4 GR 5', 'X', '73181500', 91.35, 40.00, 10.00, 47.050, 48.50, 44.30, 109.62, 9.00, 4.23, 9.00, 4.23, 18.00, 8.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(767, '128284208-0200', 'HHS7/8UNCX2-1/2 GR 5', 'X', '73181500', 95.85, 30.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(768, '128284300-0200', 'HHS7/8UNCX3 GR 5', 'X', '73181500', 104.90, 30.00, 10.00, 54.020, 48.50, 50.88, 125.88, 9.00, 4.86, 9.00, 4.86, 18.00, 9.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(769, '128285208-0200', 'HHS7/8UNFX2-1/2 GR 5', 'X', '73181500', 100.25, 30.00, 10.00, 51.630, 48.50, 48.62, 120.30, 9.00, 4.65, 9.00, 4.65, 18.00, 9.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(770, '128324108-0200', 'HHS1UNCX1-1/2 GR 5', 'X', '73181500', 108.95, 40.00, 10.00, 56.110, 48.50, 52.84, 130.74, 9.00, 5.05, 9.00, 5.05, 18.00, 10.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(771, '128324112-0200', 'HHS1UNCX1-3/4 GR 5', 'X', '73181500', 108.95, 40.00, 10.00, 56.110, 48.50, 52.84, 130.74, 9.00, 5.05, 9.00, 5.05, 18.00, 10.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(772, '128324200-0200', 'HHS1UNCX2 GR 5', 'X', '73181500', 109.15, 30.00, 10.00, 56.210, 48.50, 52.94, 130.98, 9.00, 5.06, 9.00, 5.06, 18.00, 10.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(773, '128324208-0200', 'HHS1UNCX2-1/2 GR 5', 'X', '73181500', 118.50, 30.00, 10.00, 61.030, 48.50, 57.47, 142.20, 9.00, 5.49, 9.00, 5.49, 18.00, 10.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(774, '128324300-0200', 'HHS1UNCX3 GR 5', 'X', '73181500', 132.30, 40.00, 10.00, 68.130, 48.50, 64.17, 158.76, 9.00, 6.13, 9.00, 6.13, 18.00, 12.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(775, '128325208-0200', 'HHS1UNFX2-1/2 GR 5', 'X', '73181500', 118.50, 30.00, 10.00, 61.030, 48.50, 57.47, 142.20, 9.00, 5.49, 9.00, 5.49, 18.00, 10.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(776, '128325300-0200', 'HHS1UNFX3 GR 5', 'X', '73181500', 132.30, 40.00, 10.00, 68.130, 48.50, 64.17, 158.76, 9.00, 6.13, 9.00, 6.13, 18.00, 12.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(777, '129084008-0200', 'HHS1/4UNCX1/2 GR 5', 'X', '73181500', 4.00, 3000.00, 500.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3000.00, 3000.00, 3000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(778, '129084012-0200', 'HHS1/4UNCX3/4 GR 5', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(779, '129084014-0200', 'HHS1/4UNCX7/8 GR 5', 'X', '73181500', 4.30, 1200.00, 200.00, 2.210, 48.50, 2.09, 5.16, 9.00, 0.20, 9.00, 0.20, 18.00, 0.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(780, '129084100-0200', 'HHS1/4UNCX1 GR 5', 'X', '73181500', 4.55, 1200.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(781, '129084104-0200', 'HHS1/4UNCX1-1/4 GR 5', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(782, '129085008-0200', 'HHS1/4UNFX1/2 GR 5', 'X', '73181500', 4.00, 3000.00, 500.00, 2.060, 48.50, 1.94, 4.80, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3000.00, 3000.00, 3000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(783, '129085010-0200', 'HHS1/4UNFX5/8 GR 5', 'X', '73181500', 5.20, 1200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(784, '129085012-0200', 'HHS1/4UNFX3/4 GR 5', 'X', '73181500', 4.65, 3000.00, 500.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3000.00, 3000.00, 3000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(785, '129085100-0200', 'HHS1/4UNFX1 GR 5', 'X', '73181500', 4.55, 1200.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(786, '129085104-0200', 'HHS1/4UNFX1-1/4 GR 5', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(787, '129104008-0200', 'HHS5/16UNCX1/2 GR 5', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(788, '129104010-0200', 'HHS5/16UNCX5/8 GR 5', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(789, '129104012-0200', 'HHS5/16UNCX3/4 GR 5', 'X', '73181500', 5.00, 1600.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(790, '129104014-0200', 'HHS5/16UNCX7/8 GR 5', 'X', '73181500', 5.55, 800.00, 200.00, 2.860, 48.50, 2.69, 6.66, 9.00, 0.26, 9.00, 0.26, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(791, '129104100-0200', 'HHS5/16UNCX1 GR 5', 'X', '73181500', 5.35, 800.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(792, '129104108-0200', 'HHS5/16UNCX1-1/2 GR 5', 'X', '73181500', 6.30, 600.00, 200.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(793, '129104112-0200', 'HHS5/16UNCX1-3/4 GR 5', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(794, '129104200-0200', 'HHS5/16UNCX2 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(795, '129105008-0200', 'HHS5/16UNFX1/2 GR 5', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(796, '129105012-0200', 'HHS5/16UNFX3/4 GR 5', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(797, '129105100-0200', 'HHS5/16UNFX1 GR 5', 'X', '73181500', 5.35, 800.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(798, '129105104-0200', 'HHS5/16UNFX1-1/4 GR 5', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(799, '129124008-0200', 'HHS3/8UNCX1/2 GR 5', 'X', '73181500', 8.35, 1200.00, 200.00, 4.300, 48.50, 4.05, 10.02, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(800, '129124010-0200', 'HHS3/8UNCX5/8 GR 5', 'X', '73181500', 8.70, 600.00, 200.00, 4.480, 48.50, 4.22, 10.44, 9.00, 0.40, 9.00, 0.40, 18.00, 0.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(801, '129124012-0200', 'HHS3/8UNCX3/4 GR 5', 'X', '73181500', 7.25, 600.00, 200.00, 3.730, 48.50, 3.52, 8.70, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(802, '129124014-0200', 'HHS3/8UNCX7/8 GR 5', 'X', '73181500', 9.15, 600.00, 200.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(803, '129124100-0200', 'HHS3/8UNCX1 GR 5', 'X', '73181500', 6.55, 800.00, 200.00, 3.370, 48.50, 3.18, 7.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(804, '129124104-0200', 'HHS3/8UNCX1-1/4 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(805, '129124106-0200', 'HHS3/8UNCX1-3/8 GR 5', 'X', '73181500', 7.70, 600.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(806, '129124108-0200', 'HHS3/8UNCX1-1/2 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(807, '129124112-0200', 'HHS3/8UNCX1-3/4 GR 5', 'X', '73181500', 8.50, 300.00, 100.00, 4.380, 48.50, 4.12, 10.20, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(808, '129124200-0200', 'HHS3/8UNCX2 GR 5', 'X', '73181500', 9.25, 300.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(809, '129125012-0200', 'HHS3/8UNFX3/4 GR 5', 'X', '73181500', 7.25, 600.00, 200.00, 3.730, 48.50, 3.52, 8.70, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(810, '129125100-0200', 'HHS3/8UNFX1 GR 5', 'X', '73181500', 6.55, 800.00, 200.00, 3.370, 48.50, 3.18, 7.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(811, '129125104-0200', 'HHS3/8UNFX1-1/4 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(812, '129125108-0200', 'HHS3/8UNFX1-1/2 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(813, '129144100-0200', 'HHS7/16UNCX1 GR 5', 'X', '73181500', 8.95, 400.00, 100.00, 4.610, 48.50, 4.34, 10.74, 9.00, 0.41, 9.00, 0.41, 18.00, 0.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(814, '129144104-0200', 'HHS7/16UNCX1-1/4 GR 5', 'X', '73181500', 9.65, 300.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(815, '129144108-0200', 'HHS7/16UNCX1-1/2 GR 5', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(816, '129144112-0200', 'HHS7/16UNCX1-3/4 GR 5', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(817, '129145100-0200', 'HHS7/16UNFX1 GR 5', 'X', '73181500', 8.95, 800.00, 100.00, 4.610, 48.50, 4.34, 10.74, 9.00, 0.41, 9.00, 0.41, 18.00, 0.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(818, '129145104-0200', 'HHS7/16UNFX1-1/4 GR 5', 'X', '73181500', 9.65, 300.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(819, '129145108-0200', 'HHS7/16UNFX1-1/2 GR 5', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(820, '129164012-0200', 'HHS1/2UNCX3/4 GR 5', 'X', '73181500', 13.80, 400.00, 100.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(821, '129164014-0200', 'HHS1/2UNCX7/8 GR 5', 'X', '73181500', 15.00, 300.00, 100.00, 7.730, 48.50, 7.28, 18.00, 9.00, 0.70, 9.00, 0.70, 18.00, 1.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(822, '129164100-0200', 'HHS1/2UNCX1 GR 5', 'X', '73181500', 14.55, 600.00, 50.00, 7.490, 48.50, 7.06, 17.46, 9.00, 0.67, 9.00, 0.67, 18.00, 1.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(823, '129164104-0200', 'HHS1/2UNCX1-1/4 GR 5', 'X', '73181500', 15.45, 200.00, 50.00, 7.960, 48.50, 7.49, 18.54, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(824, '129164108-0200', 'HHS1/2UNCX1-1/2 GR 5', 'X', '73181500', 15.25, 400.00, 50.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(825, '129164110-0200', 'HHS1/2UNCX1-5/8 GR 5', 'X', '73181500', 17.85, 150.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(826, '129164112-0200', 'HHS1/2UNCX1-3/4 GR 5', 'X', '73181500', 17.25, 150.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(827, '129164200-0200', 'HHS1/2UNCX2 GR 5', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(828, '129164208-0200', 'HHS1/2UNCX2-1/2 GR 5', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(829, '129165012-0200', 'HHS1/2UNFX3/4 GR 5', 'X', '73181500', 13.80, 300.00, 50.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(830, '129165100-0200', 'HHS1/2UNFX1 GR 5', 'X', '73181500', 14.55, 300.00, 50.00, 7.490, 48.50, 7.06, 17.46, 9.00, 0.67, 9.00, 0.67, 18.00, 1.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(831, '129165104-0200', 'HHS1/2UNFX1-1/4 GR 5', 'X', '73181500', 15.45, 200.00, 50.00, 7.960, 48.50, 7.49, 18.54, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(832, '129165108-0200', 'HHS1/2UNFX1-1/2 GR 5', 'X', '73181500', 15.25, 200.00, 50.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(833, '129204100-0200', 'HHS5/8UNCX1 GR 5', 'X', '73181500', 27.40, 120.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(834, '129204104-0200', 'HHS5/8UNCX1-1/4 GR 5', 'X', '73181500', 29.10, 120.00, 20.00, 14.990, 48.50, 14.11, 34.92, 9.00, 1.35, 9.00, 1.35, 18.00, 2.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(835, '129204108-0200', 'HHS5/8UNCX1-1/2 GR 5', 'X', '73181500', 30.55, 120.00, 20.00, 15.730, 48.50, 14.82, 36.66, 9.00, 1.42, 9.00, 1.42, 18.00, 2.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(836, '129204112-0200', 'HHS5/8UNCX1-3/4 GR 5', 'X', '73181500', 31.20, 80.00, 20.00, 16.070, 48.50, 15.13, 37.44, 9.00, 1.45, 9.00, 1.45, 18.00, 2.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(837, '129204200-0200', 'HHS5/8UNCX2 GR 5', 'X', '73181500', 32.70, 160.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(838, '129204208-0200', 'HHS5/8UNCX2-1/2 GR 5', 'X', '73181500', 37.95, 80.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(839, '129204300-0200', 'HHS5/8UNCX3 GR 5', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(840, '129205100-0200', 'HHS5/8UNFX1 GR 5', 'X', '73181500', 27.40, 20.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(841, '129205104-0200', 'HHS5/8UNFX1-1/4 GR 5', 'X', '73181500', 29.10, 80.00, 20.00, 14.990, 48.50, 14.11, 34.92, 9.00, 1.35, 9.00, 1.35, 18.00, 2.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(842, '129205108-0200', 'HHS5/8UNFX1-1/2 GR 5', 'X', '73181500', 30.55, 120.00, 20.00, 15.730, 48.50, 14.82, 36.66, 9.00, 1.42, 9.00, 1.42, 18.00, 2.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(843, '129244104-0200', 'HHS3/4UNCX1-1/4 GR 5', 'X', '73181500', 56.15, 80.00, 20.00, 28.920, 48.50, 27.23, 67.38, 9.00, 2.60, 9.00, 2.60, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(844, '129244108-0200', 'HHS3/4UNCX1-1/2 GR 5', 'X', '73181500', 56.15, 80.00, 20.00, 28.920, 48.50, 27.23, 67.38, 9.00, 2.60, 9.00, 2.60, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(845, '129244112-0200', 'HHS3/4UNCX1-3/4 GR 5', 'X', '73181500', 58.30, 80.00, 20.00, 30.020, 48.50, 28.28, 69.96, 9.00, 2.70, 9.00, 2.70, 18.00, 5.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(846, '129244200-0200', 'HHS3/4UNCX2 GR 5', 'X', '73181500', 62.15, 60.00, 20.00, 32.010, 48.50, 30.14, 74.58, 9.00, 2.88, 9.00, 2.88, 18.00, 5.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(847, '129244204-0200', 'HHS3/4UNCX2-1/4 GR 5', 'X', '73181500', 65.05, 40.00, 10.00, 33.500, 48.50, 31.55, 78.06, 9.00, 3.02, 9.00, 3.02, 18.00, 6.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(848, '129244208-0200', 'HHS3/4UNCX2-1/2 GR 5', 'X', '73181500', 68.25, 40.00, 10.00, 35.150, 48.50, 33.10, 81.90, 9.00, 3.16, 9.00, 3.16, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(849, '129244300-0200', 'HHS3/4UNCX3 GR 5', 'X', '73181500', 77.35, 40.00, 10.00, 39.840, 48.50, 37.51, 92.82, 9.00, 3.59, 9.00, 3.59, 18.00, 7.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(850, '129245104-0200', 'HHS3/4UNFX1-1/4 GR 5', 'X', '73181500', 56.15, 80.00, 20.00, 28.920, 48.50, 27.23, 67.38, 9.00, 2.60, 9.00, 2.60, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(851, '129245108-0200', 'HHS3/4UNFX1-1/2 GR 5', 'X', '73181500', 56.15, 80.00, 20.00, 28.920, 48.50, 27.23, 67.38, 9.00, 2.60, 9.00, 2.60, 18.00, 5.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(852, '129245112-0200', 'HHS3/4UNFX1-3/4 GR 5', 'X', '73181500', 58.30, 80.00, 20.00, 30.020, 48.50, 28.28, 69.96, 9.00, 2.70, 9.00, 2.70, 18.00, 5.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(853, '129245200-0200', 'HHS3/4UNFX2 GR 5', 'X', '73181500', 62.15, 60.00, 20.00, 32.010, 48.50, 30.14, 74.58, 9.00, 2.88, 9.00, 2.88, 18.00, 5.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(854, '129245204-0200', 'HHS3/4UNFX2-1/4 GR 5', 'X', '73181500', 65.05, 40.00, 10.00, 33.500, 48.50, 31.55, 78.06, 9.00, 3.02, 9.00, 3.02, 18.00, 6.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(855, '129284108-0200', 'HHS7/8UNCX1-1/2 GR 5', 'X', '73181500', 78.55, 40.00, 10.00, 40.450, 48.50, 38.10, 94.26, 9.00, 3.64, 9.00, 3.64, 18.00, 7.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(856, '129284112-0200', 'HHS7/8UNCX1-3/4 GR 5', 'X', '73181500', 82.25, 40.00, 10.00, 42.360, 48.50, 39.89, 98.70, 9.00, 3.81, 9.00, 3.81, 18.00, 7.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(857, '129284200-0200', 'HHS7/8UNCX2 GR 5', 'X', '73181500', 86.35, 40.00, 10.00, 44.470, 48.50, 41.88, 103.62, 9.00, 4.00, 9.00, 4.00, 18.00, 8.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(858, '129284204-0200', 'HHS7/8UNCX2-1/4 GR 5', 'X', '73181500', 91.35, 40.00, 10.00, 47.050, 48.50, 44.30, 109.62, 9.00, 4.23, 9.00, 4.23, 18.00, 8.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(859, '129284208-0200', 'HHS7/8UNCX2-1/2 GR 5', 'X', '73181500', 95.85, 30.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(860, '129284212-0200', 'HHS7/8UNCX2-3/4 GR 5', 'X', '73181500', 100.25, 0.00, 0.00, 51.630, 48.50, 48.62, 120.30, 9.00, 4.65, 9.00, 4.65, 18.00, 9.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(861, '129284300-0200', 'HHS7/8UNCX3 GR 5', 'X', '73181500', 104.90, 30.00, 10.00, 54.020, 48.50, 50.88, 125.88, 9.00, 4.86, 9.00, 4.86, 18.00, 9.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(862, '129285200-0200', 'HHS7/8UNFX2 GR 5', 'X', '73181500', 86.35, 80.00, 20.00, 44.470, 48.50, 41.88, 103.62, 9.00, 4.00, 9.00, 4.00, 18.00, 8.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(863, '129285202-0200', 'HHS7/8UNFX2-1/8 GR 5', 'X', '73181500', 90.10, 10.00, 10.00, 46.400, 48.50, 43.70, 108.12, 9.00, 4.18, 9.00, 4.18, 18.00, 8.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(864, '129285204-0200', 'HHS7/8UNFX2-1/4 GR 5', 'X', '73181500', 91.35, 40.00, 10.00, 47.050, 48.50, 44.30, 109.62, 9.00, 4.23, 9.00, 4.23, 18.00, 8.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(865, '129324108-0200', 'HHS1UNCX1-1/2 GR 5', 'X', '73181500', 108.95, 40.00, 10.00, 56.110, 48.50, 52.84, 130.74, 9.00, 5.05, 9.00, 5.05, 18.00, 10.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(866, '129324200-0200', 'HHS1UNCX2 GR 5', 'X', '73181500', 109.15, 60.00, 10.00, 56.210, 48.50, 52.94, 130.98, 9.00, 5.06, 9.00, 5.06, 18.00, 10.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(867, '129324204-0200', 'HHS1UNCX2-1/4 GR 5', 'X', '73181500', 113.50, 30.00, 10.00, 58.450, 48.50, 55.05, 136.20, 9.00, 5.26, 9.00, 5.26, 18.00, 10.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(868, '129324208-0200', 'HHS1UNCX2-1/2 GR 5', 'X', '73181500', 118.50, 30.00, 10.00, 61.030, 48.50, 57.47, 142.20, 9.00, 5.49, 9.00, 5.49, 18.00, 10.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(869, '129324212-0200', 'HHS1UNCX2-3/4 GR 5', 'X', '73181500', 126.50, 20.00, 20.00, 65.150, 48.50, 61.35, 151.80, 9.00, 5.86, 9.00, 5.86, 18.00, 11.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(870, '129324300-0200', 'HHS1UNCX3 GR 5', 'X', '73181500', 132.30, 20.00, 10.00, 68.130, 48.50, 64.17, 158.76, 9.00, 6.13, 9.00, 6.13, 18.00, 12.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(871, '129324308-0200', 'HHS1UNCX3-1/2 GR 5', 'X', '73181500', 150.10, 40.00, 10.00, 77.300, 48.50, 72.80, 180.12, 9.00, 6.96, 9.00, 6.96, 18.00, 13.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(872, '129325208-0200', 'HHS1UNFX2-1/2 GR 5', 'X', '73181500', 118.50, 40.00, 10.00, 61.030, 48.50, 57.47, 142.20, 9.00, 5.49, 9.00, 5.49, 18.00, 10.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(873, '129325300-0200', 'HHS1UNFX3 GR 5', 'X', '73181500', 132.30, 30.00, 10.00, 68.130, 48.50, 64.17, 158.76, 9.00, 6.13, 9.00, 6.13, 18.00, 12.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(874, '129404212-0200', 'HHS1-1/4UNCX2-3/4 GR 5', 'X', '73181500', 441.70, 10.00, 10.00, 227.480, 48.50, 214.22, 530.04, 9.00, 20.47, 9.00, 20.47, 18.00, 40.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(875, '129404300-0200', 'HHS1-1/4UNCX3 GR 5', 'X', '73181500', 431.85, 10.00, 10.00, 222.400, 48.50, 209.45, 518.22, 9.00, 20.02, 9.00, 20.02, 18.00, 40.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(876, '129404308-0200', 'HHS1-1/4UNCX3-1/2 GR 5', 'X', '73181500', 445.95, 5.00, 5.00, 229.660, 48.50, 216.29, 535.14, 9.00, 20.67, 9.00, 20.67, 18.00, 41.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(877, '202103035-0200', 'HHBM10X1.5X35 GR 8.8', 'X', '73181500', 7.85, 300.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(878, '202103040-0200', 'HHBM10X1.5X40 GR 8.8', 'X', '73181500', 9.95, 300.00, 100.00, 5.120, 48.50, 4.83, 11.94, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(879, '202103045-0200', 'HHBM10X1.5X45 GR 8.8', 'X', '73181500', 8.65, 300.00, 100.00, 4.450, 48.50, 4.20, 10.38, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(880, '202103050-0200', 'HHBM10X1.5X50 GR 8.8', 'X', '73181500', 9.35, 400.00, 100.00, 4.820, 48.50, 4.53, 11.22, 9.00, 0.43, 9.00, 0.43, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(881, '202103055-0200', 'HHBM10X1.5X55 GR 8.8', 'X', '73181500', 11.40, 400.00, 100.00, 5.870, 48.50, 5.53, 13.68, 9.00, 0.53, 9.00, 0.53, 18.00, 1.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(882, '202103060-0200', 'HHBM10X1.5X60 GR 8.8', 'X', '73181500', 12.50, 400.00, 100.00, 6.440, 48.50, 6.06, 15.00, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(883, '202103065-0200', 'HHBM10X1.5X65 GR 8.8', 'X', '73181500', 13.10, 400.00, 100.00, 6.750, 48.50, 6.35, 15.72, 9.00, 0.61, 9.00, 0.61, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(884, '202103070-0200', 'HHBM10X1.5X70 GR 8.8', 'X', '73181500', 13.80, 150.00, 50.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(885, '202103075-0200', 'HHBM10X1.5X75 GR 8.8', 'X', '73181500', 15.10, 150.00, 50.00, 7.780, 48.50, 7.32, 18.12, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(886, '202103080-0200', 'HHBM10X1.5X80 GR 8.8', 'X', '73181500', 17.85, 150.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(887, '202103085-0200', 'HHBM10X1.5X85 GR 8.8', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(888, '202103090-0200', 'HHBM10X1.5X90 GR 8.8', 'X', '73181500', 19.85, 150.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(889, '202103095-0200', 'HHBM10X1.5X95 GR 8.8', 'X', '73181500', 21.25, 150.00, 50.00, 10.940, 48.50, 10.31, 25.50, 9.00, 0.98, 9.00, 0.98, 18.00, 1.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(890, '202103100-0200', 'HHBM10X1.5X100 GR 8.8', 'X', '73181500', 21.55, 150.00, 50.00, 11.100, 48.50, 10.45, 25.86, 9.00, 1.00, 9.00, 1.00, 18.00, 2.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(891, '202103105-0200', 'HHBM10X1.5X105 GR 8.8', 'X', '73181500', 23.05, 150.00, 50.00, 11.870, 48.50, 11.18, 27.66, 9.00, 1.07, 9.00, 1.07, 18.00, 2.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(892, '202103110-0200', 'HHBM10X1.5X110 GR 8.8', 'X', '73181500', 23.40, 150.00, 50.00, 12.050, 48.50, 11.35, 28.08, 9.00, 1.08, 9.00, 1.08, 18.00, 2.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(893, '202103115-0200', 'HHBM10X1.5X115 GR 8.8', 'X', '73181500', 29.70, 200.00, 50.00, 15.300, 48.50, 14.40, 35.64, 9.00, 1.38, 9.00, 1.38, 18.00, 2.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(894, '202103120-0200', 'HHBM10X1.5X120 GR 8.8', 'X', '73181500', 27.60, 200.00, 50.00, 14.210, 48.50, 13.39, 33.12, 9.00, 1.28, 9.00, 1.28, 18.00, 2.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(895, '202103125-0200', 'HHBM10X1.5X125 GR 8.8', 'X', '73181500', 28.25, 200.00, 50.00, 14.550, 48.50, 13.70, 33.90, 9.00, 1.31, 9.00, 1.31, 18.00, 2.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(896, '202103130-0200', 'HHBM10X1.5X130 GR 8.8', 'X', '73181500', 33.25, 200.00, 50.00, 17.120, 48.50, 16.13, 39.90, 9.00, 1.54, 9.00, 1.54, 18.00, 3.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(897, '202103140-0200', 'HHBM10X1.5X140 GR 8.8', 'X', '73181500', 34.35, 200.00, 50.00, 17.690, 48.50, 16.66, 41.22, 9.00, 1.59, 9.00, 1.59, 18.00, 3.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(898, '202103145-0200', 'HHBM10X1.5X145 GR 8.8', 'X', '73181500', 53.05, 200.00, 50.00, 27.320, 48.50, 25.73, 63.66, 9.00, 2.46, 9.00, 2.46, 18.00, 4.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(899, '202103150-0200', 'HHBM10X1.5X150 GR 8.8', 'X', '73181500', 53.05, 200.00, 50.00, 27.320, 48.50, 25.73, 63.66, 9.00, 2.46, 9.00, 2.46, 18.00, 4.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(900, '202103160-0200', 'HHBM10X1.5X160 GR 8.8', 'X', '73181500', 55.30, 60.00, 20.00, 28.480, 48.50, 26.82, 66.36, 9.00, 2.56, 9.00, 2.56, 18.00, 5.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(901, '202103170-0200', 'HHBM10X1.5X170 GR 8.8', 'X', '73181500', 57.85, 100.00, 20.00, 29.790, 48.50, 28.06, 69.42, 9.00, 2.68, 9.00, 2.68, 18.00, 5.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(902, '202103175-0200', 'HHBM10X1.5X175 GR 8.8', 'X', '73181500', 57.85, 100.00, 20.00, 29.790, 48.50, 28.06, 69.42, 9.00, 2.68, 9.00, 2.68, 18.00, 5.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(903, '202124040-0200', 'HHBM12X1.75X40 GR 8.8', 'X', '73181500', 12.50, 200.00, 50.00, 6.440, 48.50, 6.06, 15.00, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(904, '202124045-0200', 'HHBM12X1.75X45 GR 8.8', 'X', '73181500', 15.60, 400.00, 50.00, 8.030, 48.50, 7.57, 18.72, 9.00, 0.72, 9.00, 0.72, 18.00, 1.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(905, '202124050-0200', 'HHBM12X1.75X50 GR 8.8', 'X', '73181500', 16.70, 200.00, 50.00, 8.600, 48.50, 8.10, 20.04, 9.00, 0.77, 9.00, 0.77, 18.00, 1.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(906, '202124055-0200', 'HHBM12X1.75X55 GR 8.8', 'X', '73181500', 17.35, 150.00, 50.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(907, '202124060-0200', 'HHBM12X1.75X60 GR 8.8', 'X', '73181500', 18.25, 150.00, 50.00, 9.400, 48.50, 8.85, 21.90, 9.00, 0.85, 9.00, 0.85, 18.00, 1.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(908, '202124065-0200', 'HHBM12X1.75X65 GR 8.8', 'X', '73181500', 18.55, 200.00, 50.00, 9.550, 48.50, 9.00, 22.26, 9.00, 0.86, 9.00, 0.86, 18.00, 1.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(909, '202124070-0200', 'HHBM12X1.75X70 GR 8.8', 'X', '73181500', 21.35, 160.00, 20.00, 11.000, 48.50, 10.35, 25.62, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(910, '202124075-0200', 'HHBM12X1.75X75 GR 8.8', 'X', '73181500', 22.25, 160.00, 20.00, 11.460, 48.50, 10.79, 26.70, 9.00, 1.03, 9.00, 1.03, 18.00, 2.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(911, '202124080-0200', 'HHBM12X1.75X80 GR 8.8', 'X', '73181500', 23.60, 160.00, 20.00, 12.150, 48.50, 11.45, 28.32, 9.00, 1.09, 9.00, 1.09, 18.00, 2.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(912, '202124085-0200', 'HHBM12X1.75X85 GR 8.8', 'X', '73181500', 24.60, 80.00, 20.00, 12.670, 48.50, 11.93, 29.52, 9.00, 1.14, 9.00, 1.14, 18.00, 2.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(913, '202124090-0200', 'HHBM12X1.75X90 GR 8.8', 'X', '73181500', 25.85, 160.00, 20.00, 13.310, 48.50, 12.54, 31.02, 9.00, 1.20, 9.00, 1.20, 18.00, 2.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(914, '202124095-0200', 'HHBM12X1.75X95 GR 8.8', 'X', '73181500', 27.50, 80.00, 20.00, 14.160, 48.50, 13.34, 33.00, 9.00, 1.27, 9.00, 1.27, 18.00, 2.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(915, '202124100-0200', 'HHBM12X1.75X100 GR 8.8', 'X', '73181500', 30.15, 80.00, 20.00, 15.530, 48.50, 14.62, 36.18, 9.00, 1.40, 9.00, 1.40, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(916, '202124105-0200', 'HHBM12X1.75X105 GR 8.8', 'X', '73181500', 32.10, 80.00, 20.00, 16.530, 48.50, 15.57, 38.52, 9.00, 1.49, 9.00, 1.49, 18.00, 2.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(917, '202124110-0200', 'HHBM12X1.75X110 GR 8.8', 'X', '73181500', 33.55, 160.00, 20.00, 17.280, 48.50, 16.27, 40.26, 9.00, 1.56, 9.00, 1.56, 18.00, 3.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(918, '202124115-0200', 'HHBM12X1.75X115 GR 8.8', 'X', '73181500', 40.80, 80.00, 20.00, 21.010, 48.50, 19.79, 48.96, 9.00, 1.89, 9.00, 1.89, 18.00, 3.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(919, '202124120-0200', 'HHBM12X1.75X120 GR 8.8', 'X', '73181500', 35.70, 60.00, 20.00, 18.390, 48.50, 17.31, 42.84, 9.00, 1.65, 9.00, 1.65, 18.00, 3.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(920, '202124125-0200', 'HHBM12X1.75X125 GR 8.8', 'X', '73181500', 37.30, 60.00, 20.00, 19.210, 48.50, 18.09, 44.76, 9.00, 1.73, 9.00, 1.73, 18.00, 3.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(921, '202124130-0200', 'HHBM12X1.75X130 GR 8.8', 'X', '73181500', 37.95, 60.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(922, '202124135-0200', 'HHBM12X1.75X135 GR 8.8', 'X', '73181500', 48.15, 60.00, 20.00, 24.800, 48.50, 23.35, 57.78, 9.00, 2.23, 9.00, 2.23, 18.00, 4.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(923, '202124140-0200', 'HHBM12X1.75X140 GR 8.8', 'X', '73181500', 45.75, 60.00, 20.00, 23.560, 48.50, 22.19, 54.90, 9.00, 2.12, 9.00, 2.12, 18.00, 4.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(924, '202124145-0200', 'HHBM12X1.75X145 GR 8.8', 'X', '73181500', 54.95, 60.00, 20.00, 28.300, 48.50, 26.65, 65.94, 9.00, 2.55, 9.00, 2.55, 18.00, 5.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(925, '202124150-0200', 'HHBM12X1.75X150 GR 8.8', 'X', '73181500', 65.65, 60.00, 20.00, 33.810, 48.50, 31.84, 78.78, 9.00, 3.04, 9.00, 3.04, 18.00, 6.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(926, '202124160-0200', 'HHBM12X1.75X160 GR 8.8', 'X', '73181500', 65.65, 100.00, 20.00, 33.810, 48.50, 31.84, 78.78, 9.00, 3.04, 9.00, 3.04, 18.00, 6.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(927, '202124170-0200', 'HHBM12X1.75X170 GR 8.8', 'X', '73181500', 65.90, 100.00, 20.00, 33.940, 48.50, 31.96, 79.08, 9.00, 3.05, 9.00, 3.05, 18.00, 6.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(928, '202124175-0200', 'HHBM12X1.75X175 GR 8.8', 'X', '73181500', 68.80, 100.00, 20.00, 35.430, 48.50, 33.37, 82.56, 9.00, 3.19, 9.00, 3.19, 18.00, 6.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(929, '202124180-0200', 'HHBM12X1.75X180 GR 8.8', 'X', '73181500', 71.25, 100.00, 20.00, 36.690, 48.50, 34.56, 85.50, 9.00, 3.30, 9.00, 3.30, 18.00, 6.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(930, '202124185-0200', 'HHBM12X1.75X185 GR 8.8', 'X', '73181500', 88.70, 20.00, 20.00, 45.680, 48.50, 43.02, 106.44, 9.00, 4.11, 9.00, 4.11, 18.00, 8.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(931, '202124190-0200', 'HHBM12X1.75X190 GR 8.8', 'X', '73181500', 88.70, 100.00, 20.00, 45.680, 48.50, 43.02, 106.44, 9.00, 4.11, 9.00, 4.11, 18.00, 8.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(932, '202124200-0200', 'HHBM12X1.75X200 GR 8.8', 'X', '73181500', 94.20, 100.00, 20.00, 48.510, 48.50, 45.69, 113.04, 9.00, 4.37, 9.00, 4.37, 18.00, 8.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(933, '202124255-0200', 'HHBM12X1.75X255 GR 8.8', 'X', '73181500', 269.15, 10.00, 10.00, 138.610, 48.50, 130.54, 322.98, 9.00, 12.48, 9.00, 12.48, 18.00, 24.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(934, '202145045-0200', 'HHBM14X2X45 GR 8.8', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(935, '202145050-0200', 'HHBM14X2X50 GR 8.8', 'X', '73181500', 20.95, 200.00, 50.00, 10.790, 48.50, 10.16, 25.14, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(936, '202145055-0200', 'HHBM14X2X55 GR 8.8', 'X', '73181500', 26.85, 200.00, 50.00, 13.830, 48.50, 13.02, 32.22, 9.00, 1.24, 9.00, 1.24, 18.00, 2.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(937, '202145060-0200', 'HHBM14X2X60 GR 8.8', 'X', '73181500', 24.80, 120.00, 20.00, 12.770, 48.50, 12.03, 29.76, 9.00, 1.15, 9.00, 1.15, 18.00, 2.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(938, '202145065-0200', 'HHBM14X2X65 GR 8.8', 'X', '73181500', 28.70, 80.00, 20.00, 14.780, 48.50, 13.92, 34.44, 9.00, 1.33, 9.00, 1.33, 18.00, 2.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(939, '202145070-0200', 'HHBM14X2X70 GR 8.8', 'X', '73181500', 31.95, 80.00, 20.00, 16.450, 48.50, 15.50, 38.34, 9.00, 1.48, 9.00, 1.48, 18.00, 2.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(940, '202145075-0200', 'HHBM14X2X75 GR 8.8', 'X', '73181500', 33.55, 80.00, 20.00, 17.280, 48.50, 16.27, 40.26, 9.00, 1.56, 9.00, 1.56, 18.00, 3.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(941, '202145080-0200', 'HHBM14X2X80 GR 8.8', 'X', '73181500', 35.40, 80.00, 20.00, 18.230, 48.50, 17.17, 42.48, 9.00, 1.64, 9.00, 1.64, 18.00, 3.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(942, '202145085-0200', 'HHBM14X2X85 GR 8.8', 'X', '73181500', 36.25, 80.00, 20.00, 18.670, 48.50, 17.58, 43.50, 9.00, 1.68, 9.00, 1.68, 18.00, 3.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(943, '202145090-0200', 'HHBM14X2X90 GR 8.8', 'X', '73181500', 38.75, 80.00, 20.00, 19.960, 48.50, 18.79, 46.50, 9.00, 1.80, 9.00, 1.80, 18.00, 3.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(944, '202145095-0200', 'HHBM14X2X95 GR 8.8', 'X', '73181500', 43.95, 80.00, 20.00, 22.630, 48.50, 21.32, 52.74, 9.00, 2.04, 9.00, 2.04, 18.00, 4.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(945, '202145100-0200', 'HHBM14X2X100 GR 8.8', 'X', '73181500', 44.70, 160.00, 20.00, 23.020, 48.50, 21.68, 53.64, 9.00, 2.07, 9.00, 2.07, 18.00, 4.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(946, '202145110-0200', 'HHBM14X2X110 GR 8.8', 'X', '73181500', 50.75, 80.00, 20.00, 26.140, 48.50, 24.61, 60.90, 9.00, 2.35, 9.00, 2.35, 18.00, 4.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(947, '202145115-0200', 'HHBM14X2X115 GR 8.8', 'X', '73181500', 61.05, 80.00, 20.00, 31.440, 48.50, 29.61, 73.26, 9.00, 2.83, 9.00, 2.83, 18.00, 5.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(948, '202145120-0200', 'HHBM14X2X120 GR 8.8', 'X', '73181500', 53.75, 60.00, 20.00, 27.680, 48.50, 26.07, 64.50, 9.00, 2.49, 9.00, 2.49, 18.00, 4.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(949, '202145125-0200', 'HHBM14X2X125 GR 8.8', 'X', '73181500', 54.85, 60.00, 20.00, 28.250, 48.50, 26.60, 65.82, 9.00, 2.54, 9.00, 2.54, 18.00, 5.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(950, '202145130-0200', 'HHBM14X2X130 GR 8.8', 'X', '73181500', 57.85, 60.00, 20.00, 29.790, 48.50, 28.06, 69.42, 9.00, 2.68, 9.00, 2.68, 18.00, 5.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(951, '202145140-0200', 'HHBM14X2X140 GR 8.8', 'X', '73181500', 82.50, 60.00, 20.00, 42.490, 48.50, 40.01, 99.00, 9.00, 3.82, 9.00, 3.82, 18.00, 7.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(952, '202145150-0200', 'HHBM14X2X150 GR 8.8', 'X', '73181500', 90.85, 60.00, 20.00, 46.790, 48.50, 44.06, 109.02, 9.00, 4.21, 9.00, 4.21, 18.00, 8.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(953, '202145160-0200', 'HHBM14X2X160 GR 8.8', 'X', '73181500', 101.60, 100.00, 20.00, 52.320, 48.50, 49.28, 121.92, 9.00, 4.71, 9.00, 4.71, 18.00, 9.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(954, '202145170-0200', 'HHBM14X2X170 GR 8.8', 'X', '73181500', 105.65, 10.00, 10.00, 54.410, 48.50, 51.24, 126.78, 9.00, 4.90, 9.00, 4.90, 18.00, 9.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(955, '205103035-0200', 'HHBM10X1.5X35 GR 10.9', 'X', '73181500', 7.85, 300.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(956, '205103040-0200', 'HHBM10X1.5X40 GR 10.9', 'X', '73181500', 9.95, 300.00, 100.00, 5.120, 48.50, 4.83, 11.94, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(957, '205103045-0200', 'HHBM10X1.5X45 GR 10.9', 'X', '73181500', 8.65, 300.00, 100.00, 4.450, 48.50, 4.20, 10.38, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(958, '205103050-0200', 'HHBM10X1.5X50 GR 10.9', 'X', '73181500', 9.35, 400.00, 100.00, 4.820, 48.50, 4.53, 11.22, 9.00, 0.43, 9.00, 0.43, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(959, '205103055-0200', 'HHBM10X1.5X55 GR 10.9', 'X', '73181500', 11.40, 400.00, 100.00, 5.870, 48.50, 5.53, 13.68, 9.00, 0.53, 9.00, 0.53, 18.00, 1.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(960, '205103060-0200', 'HHBM10X1.5X60 GR 10.9', 'X', '73181500', 12.50, 400.00, 100.00, 6.440, 48.50, 6.06, 15.00, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(961, '205103065-0200', 'HHBM10X1.5X65 GR 10.9', 'X', '73181500', 13.10, 400.00, 100.00, 6.750, 48.50, 6.35, 15.72, 9.00, 0.61, 9.00, 0.61, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(962, '205103070-0200', 'HHBM10X1.5X70 GR 10.9', 'X', '73181500', 13.80, 150.00, 50.00, 7.110, 48.50, 6.69, 16.56, 9.00, 0.64, 9.00, 0.64, 18.00, 1.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(963, '205103075-0200', 'HHBM10X1.5X75 GR 10.9', 'X', '73181500', 15.10, 150.00, 50.00, 7.780, 48.50, 7.32, 18.12, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(964, '205103080-0200', 'HHBM10X1.5X80 GR 10.9', 'X', '73181500', 17.85, 150.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(965, '205103085-0200', 'HHBM10X1.5X85 GR 10.9', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(966, '205103090-0200', 'HHBM10X1.5X90 GR 10.9', 'X', '73181500', 19.85, 150.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(967, '205103095-0200', 'HHBM10X1.5X95 GR 10.9', 'X', '73181500', 21.25, 150.00, 50.00, 10.940, 48.50, 10.31, 25.50, 9.00, 0.98, 9.00, 0.98, 18.00, 1.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(968, '205103100-0200', 'HHBM10X1.5X100 GR 10.9', 'X', '73181500', 21.55, 150.00, 50.00, 11.100, 48.50, 10.45, 25.86, 9.00, 1.00, 9.00, 1.00, 18.00, 2.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(969, '205103105-0200', 'HHBM10X1.5X105 GR 10.9', 'X', '73181500', 23.05, 150.00, 50.00, 11.870, 48.50, 11.18, 27.66, 9.00, 1.07, 9.00, 1.07, 18.00, 2.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(970, '205103110-0200', 'HHBM10X1.5X110 GR 10.9', 'X', '73181500', 23.40, 150.00, 50.00, 12.050, 48.50, 11.35, 28.08, 9.00, 1.08, 9.00, 1.08, 18.00, 2.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(971, '205103115-0200', 'HHBM10X1.5X115 GR 10.9', 'X', '73181500', 29.70, 100.00, 50.00, 15.300, 48.50, 14.40, 35.64, 9.00, 1.38, 9.00, 1.38, 18.00, 2.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(972, '205103120-0200', 'HHBM10X1.5X120 GR 10.9', 'X', '73181500', 27.60, 200.00, 50.00, 14.210, 48.50, 13.39, 33.12, 9.00, 1.28, 9.00, 1.28, 18.00, 2.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(973, '205103125-0200', 'HHBM10X1.5X125 GR 10.9', 'X', '73181500', 28.25, 200.00, 50.00, 14.550, 48.50, 13.70, 33.90, 9.00, 1.31, 9.00, 1.31, 18.00, 2.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(974, '205103130-0200', 'HHBM10X1.5X130 GR 10.9', 'X', '73181500', 33.25, 200.00, 50.00, 17.120, 48.50, 16.13, 39.90, 9.00, 1.54, 9.00, 1.54, 18.00, 3.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(975, '205103135-0200', 'HHBM10X1.5X135 GR 10.9', 'X', '73181500', 39.25, 200.00, 50.00, 20.210, 48.50, 19.04, 47.10, 9.00, 1.82, 9.00, 1.82, 18.00, 3.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(976, '205103140-0200', 'HHBM10X1.5X140 GR 10.9', 'X', '73181500', 34.35, 200.00, 50.00, 17.690, 48.50, 16.66, 41.22, 9.00, 1.59, 9.00, 1.59, 18.00, 3.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(977, '205103150-0200', 'HHBM10X1.5X150 GR 10.9', 'X', '73181500', 53.05, 200.00, 50.00, 27.320, 48.50, 25.73, 63.66, 9.00, 2.46, 9.00, 2.46, 18.00, 4.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(978, '205103160-0200', 'HHBM10X1.5X160 GR 10.9', 'X', '73181500', 55.30, 120.00, 20.00, 28.480, 48.50, 26.82, 66.36, 9.00, 2.56, 9.00, 2.56, 18.00, 5.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(979, '205103170-0200', 'HHBM10X1.5X170 GR 10.9', 'X', '73181500', 57.85, 20.00, 20.00, 29.790, 48.50, 28.06, 69.42, 9.00, 2.68, 9.00, 2.68, 18.00, 5.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(980, '205103175-0200', 'HHBM10X1.5X175 GR 10.9', 'X', '73181500', 57.85, 100.00, 20.00, 29.790, 48.50, 28.06, 69.42, 9.00, 2.68, 9.00, 2.68, 18.00, 5.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(981, '205103180-0200', 'HHBM10X1.5X180 GR 10.9', 'X', '73181500', 60.00, 20.00, 20.00, 30.900, 48.50, 29.10, 72.00, 9.00, 2.78, 9.00, 2.78, 18.00, 5.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(982, '205122050-0200', 'HHBM12X1.25X50 GR 10.9', 'X', '73181500', 16.70, 400.00, 50.00, 8.600, 48.50, 8.10, 20.04, 9.00, 0.77, 9.00, 0.77, 18.00, 1.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(983, '205123100-0200', 'HHBM12X1.5X100 GR 10.9', 'X', '73181500', 30.15, 80.00, 20.00, 15.530, 48.50, 14.62, 36.18, 9.00, 1.40, 9.00, 1.40, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(984, '205124040-0200', 'HHBM12X1.75X40 GR 10.9', 'X', '73181500', 12.50, 400.00, 50.00, 6.440, 48.50, 6.06, 15.00, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(985, '205124045-0200', 'HHBM12X1.75X45 GR 10.9', 'X', '73181500', 15.60, 400.00, 50.00, 8.030, 48.50, 7.57, 18.72, 9.00, 0.72, 9.00, 0.72, 18.00, 1.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(986, '205124050-0200', 'HHBM12X1.75X50 GR 10.9', 'X', '73181500', 16.70, 400.00, 50.00, 8.600, 48.50, 8.10, 20.04, 9.00, 0.77, 9.00, 0.77, 18.00, 1.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(987, '205124055-0200', 'HHBM12X1.75X55 GR 10.9', 'X', '73181500', 17.35, 150.00, 50.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(988, '205124060-0200', 'HHBM12X1.75X60 GR 10.9', 'X', '73181500', 18.25, 150.00, 50.00, 9.400, 48.50, 8.85, 21.90, 9.00, 0.85, 9.00, 0.85, 18.00, 1.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(989, '205124065-0200', 'HHBM12X1.75X65 GR 10.9', 'X', '73181500', 18.55, 200.00, 50.00, 9.550, 48.50, 9.00, 22.26, 9.00, 0.86, 9.00, 0.86, 18.00, 1.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(990, '205124070-0200', 'HHBM12X1.75X70 GR 10.9', 'X', '73181500', 21.35, 160.00, 20.00, 11.000, 48.50, 10.35, 25.62, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(991, '205124075-0200', 'HHBM12X1.75X75 GR 10.9', 'X', '73181500', 22.25, 160.00, 20.00, 11.460, 48.50, 10.79, 26.70, 9.00, 1.03, 9.00, 1.03, 18.00, 2.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(992, '205124080-0200', 'HHBM12X1.75X80 GR 10.9', 'X', '73181500', 23.60, 160.00, 20.00, 12.150, 48.50, 11.45, 28.32, 9.00, 1.09, 9.00, 1.09, 18.00, 2.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(993, '205124085-0200', 'HHBM12X1.75X85 GR 10.9', 'X', '73181500', 24.60, 80.00, 20.00, 12.670, 48.50, 11.93, 29.52, 9.00, 1.14, 9.00, 1.14, 18.00, 2.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(994, '205124090-0200', 'HHBM12X1.75X90 GR 10.9', 'X', '73181500', 25.85, 160.00, 20.00, 13.310, 48.50, 12.54, 31.02, 9.00, 1.20, 9.00, 1.20, 18.00, 2.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(995, '205124095-0200', 'HHBM12X1.75X95 GR 10.9', 'X', '73181500', 27.50, 80.00, 20.00, 14.160, 48.50, 13.34, 33.00, 9.00, 1.27, 9.00, 1.27, 18.00, 2.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(996, '205124100-0200', 'HHBM12X1.75X100 GR 10.9', 'X', '73181500', 30.15, 80.00, 20.00, 15.530, 48.50, 14.62, 36.18, 9.00, 1.40, 9.00, 1.40, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(997, '205124105-0200', 'HHBM12X1.75X105 GR 10.9', 'X', '73181500', 32.10, 80.00, 20.00, 16.530, 48.50, 15.57, 38.52, 9.00, 1.49, 9.00, 1.49, 18.00, 2.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(998, '205124110-0200', 'HHBM12X1.75X110 GR 10.9', 'X', '73181500', 33.55, 80.00, 20.00, 17.280, 48.50, 16.27, 40.26, 9.00, 1.56, 9.00, 1.56, 18.00, 3.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(999, '205124115-0200', 'HHBM12X1.75X115 GR 10.9', 'X', '73181500', 40.80, 80.00, 20.00, 21.010, 48.50, 19.79, 48.96, 9.00, 1.89, 9.00, 1.89, 18.00, 3.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1000, '205124117-0200', 'HHBM12X1.75X117 GR 10.9', 'X', '73181500', 34.65, 80.00, 20.00, 17.840, 48.50, 16.81, 41.58, 9.00, 1.61, 9.00, 1.61, 18.00, 3.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1001, '205124120-0200', 'HHBM12X1.75X120 GR 10.9', 'X', '73181500', 35.70, 60.00, 20.00, 18.390, 48.50, 17.31, 42.84, 9.00, 1.65, 9.00, 1.65, 18.00, 3.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1002, '205124125-0200', 'HHBM12X1.75X125 GR 10.9', 'X', '73181500', 37.30, 60.00, 20.00, 19.210, 48.50, 18.09, 44.76, 9.00, 1.73, 9.00, 1.73, 18.00, 3.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1003, '205124130-0200', 'HHBM12X1.75X130 GR 10.9', 'X', '73181500', 37.95, 60.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1004, '205124140-0200', 'HHBM12X1.75X140 GR 10.9', 'X', '73181500', 45.75, 60.00, 20.00, 23.560, 48.50, 22.19, 54.90, 9.00, 2.12, 9.00, 2.12, 18.00, 4.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1005, '205124150-0200', 'HHBM12X1.75X150 GR 10.9', 'X', '73181500', 65.65, 60.00, 20.00, 33.810, 48.50, 31.84, 78.78, 9.00, 3.04, 9.00, 3.04, 18.00, 6.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1006, '205124160-0200', 'HHBM12X1.75X160 GR 10.9', 'X', '73181500', 65.65, 100.00, 20.00, 33.810, 48.50, 31.84, 78.78, 9.00, 3.04, 9.00, 3.04, 18.00, 6.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1007, '205124170-0200', 'HHBM12X1.75X170 GR 10.9', 'X', '73181500', 65.90, 100.00, 20.00, 33.940, 48.50, 31.96, 79.08, 9.00, 3.05, 9.00, 3.05, 18.00, 6.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1008, '205124175-0200', 'HHBM12X1.75X175 GR 10.9', 'X', '73181500', 68.80, 60.00, 20.00, 35.430, 48.50, 33.37, 82.56, 9.00, 3.19, 9.00, 3.19, 18.00, 6.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1009, '205124180-0200', 'HHBM12X1.75X180 GR 10.9', 'X', '73181500', 71.25, 100.00, 20.00, 36.690, 48.50, 34.56, 85.50, 9.00, 3.30, 9.00, 3.30, 18.00, 6.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1010, '205124190-0200', 'HHBM12X1.75X190 GR 10.9', 'X', '73181500', 88.70, 80.00, 20.00, 45.680, 48.50, 43.02, 106.44, 9.00, 4.11, 9.00, 4.11, 18.00, 8.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1011, '205124200-0200', 'HHBM12X1.75X200 GR 10.9', 'X', '73181500', 94.20, 100.00, 20.00, 48.510, 48.50, 45.69, 113.04, 9.00, 4.37, 9.00, 4.37, 18.00, 8.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1012, '205124220-0200', 'HHBM12X1.75X220 GR 10.9', 'X', '73181500', 167.05, 240.00, 60.00, 86.030, 48.50, 81.02, 200.46, 9.00, 7.74, 9.00, 7.74, 18.00, 15.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 240.00, 240.00, 240.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1013, '205124230-0200', 'HHBM12X1.75X230 GR 10.9', 'X', '73181500', 202.60, 0.00, 0.00, 104.340, 48.50, 98.26, 243.12, 9.00, 9.39, 9.00, 9.39, 18.00, 18.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1014, '205124240-0200', 'HHBM12X1.75X240 GR 10.9', 'X', '73181500', 225.35, 100.00, 20.00, 116.060, 48.50, 109.29, 270.42, 9.00, 10.44, 9.00, 10.44, 18.00, 20.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1015, '205124250-0200', 'HHBM12X1.75X250 GR 10.9', 'X', '73181500', 260.70, 100.00, 20.00, 134.260, 48.50, 126.44, 312.84, 9.00, 12.08, 9.00, 12.08, 18.00, 24.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1016, '205143060-0200', 'HHBM14X1.5X60 GR 10.9', 'X', '73181500', 24.80, 120.00, 20.00, 12.770, 48.50, 12.03, 29.76, 9.00, 1.15, 9.00, 1.15, 18.00, 2.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1017, '205143085-0200', 'HHBM14X1.5X85 GR 10.9', 'X', '73181500', 36.25, 160.00, 20.00, 18.670, 48.50, 17.58, 43.50, 9.00, 1.68, 9.00, 1.68, 18.00, 3.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1018, '205145045-0200', 'HHBM14X2X45 GR 10.9', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1019, '205145050-0200', 'HHBM14X2X50 GR 10.9', 'X', '73181500', 20.95, 200.00, 50.00, 10.790, 48.50, 10.16, 25.14, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1020, '205145055-0200', 'HHBM14X2X55 GR 10.9', 'X', '73181500', 26.85, 200.00, 50.00, 13.830, 48.50, 13.02, 32.22, 9.00, 1.24, 9.00, 1.24, 18.00, 2.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1021, '205145060-0200', 'HHBM14X2X60 GR 10.9', 'X', '73181500', 24.80, 120.00, 20.00, 12.770, 48.50, 12.03, 29.76, 9.00, 1.15, 9.00, 1.15, 18.00, 2.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1022, '205145065-0200', 'HHBM14X2X65 GR 10.9', 'X', '73181500', 28.70, 80.00, 20.00, 14.780, 48.50, 13.92, 34.44, 9.00, 1.33, 9.00, 1.33, 18.00, 2.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1023, '205145070-0200', 'HHBM14X2X70 GR 10.9', 'X', '73181500', 31.95, 80.00, 20.00, 16.450, 48.50, 15.50, 38.34, 9.00, 1.48, 9.00, 1.48, 18.00, 2.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1024, '205145075-0200', 'HHBM14X2X75 GR 10.9', 'X', '73181500', 33.55, 80.00, 20.00, 17.280, 48.50, 16.27, 40.26, 9.00, 1.56, 9.00, 1.56, 18.00, 3.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1025, '205145080-0200', 'HHBM14X2X80 GR 10.9', 'X', '73181500', 35.40, 80.00, 20.00, 18.230, 48.50, 17.17, 42.48, 9.00, 1.64, 9.00, 1.64, 18.00, 3.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1026, '205145085-0200', 'HHBM14X2X85 GR 10.9', 'X', '73181500', 36.25, 80.00, 20.00, 18.670, 48.50, 17.58, 43.50, 9.00, 1.68, 9.00, 1.68, 18.00, 3.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1027, '205145090-0200', 'HHBM14X2X90 GR 10.9', 'X', '73181500', 38.75, 80.00, 20.00, 19.960, 48.50, 18.79, 46.50, 9.00, 1.80, 9.00, 1.80, 18.00, 3.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1028, '205145095-0200', 'HHBM14X2X95 GR 10.9', 'X', '73181500', 43.95, 80.00, 20.00, 22.630, 48.50, 21.32, 52.74, 9.00, 2.04, 9.00, 2.04, 18.00, 4.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1029, '205145100-0200', 'HHBM14X2X100 GR 10.9', 'X', '73181500', 44.70, 80.00, 20.00, 23.020, 48.50, 21.68, 53.64, 9.00, 2.07, 9.00, 2.07, 18.00, 4.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1030, '205145110-0200', 'HHBM14X2X110 GR 10.9', 'X', '73181500', 50.75, 80.00, 20.00, 26.140, 48.50, 24.61, 60.90, 9.00, 2.35, 9.00, 2.35, 18.00, 4.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1031, '205145115-0200', 'HHBM14X2X115 GR 10.9', 'X', '73181500', 61.05, 80.00, 20.00, 31.440, 48.50, 29.61, 73.26, 9.00, 2.83, 9.00, 2.83, 18.00, 5.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1032, '205145120-0200', 'HHBM14X2X120 GR 10.9', 'X', '73181500', 53.75, 60.00, 20.00, 27.680, 48.50, 26.07, 64.50, 9.00, 2.49, 9.00, 2.49, 18.00, 4.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1033, '205145125-0200', 'HHBM14X2X125 GR 10.9', 'X', '73181500', 54.85, 60.00, 20.00, 28.250, 48.50, 26.60, 65.82, 9.00, 2.54, 9.00, 2.54, 18.00, 5.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1034, '205145130-0200', 'HHBM14X2X130 GR 10.9', 'X', '73181500', 57.85, 60.00, 20.00, 29.790, 48.50, 28.06, 69.42, 9.00, 2.68, 9.00, 2.68, 18.00, 5.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1035, '205145140-0200', 'HHBM14X2X140 GR 10.9', 'X', '73181500', 82.50, 60.00, 20.00, 42.490, 48.50, 40.01, 99.00, 9.00, 3.82, 9.00, 3.82, 18.00, 7.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1036, '205145150-0200', 'HHBM14X2X150 GR 10.9', 'X', '73181500', 90.85, 60.00, 20.00, 46.790, 48.50, 44.06, 109.02, 9.00, 4.21, 9.00, 4.21, 18.00, 8.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1037, '205145160-0200', 'HHBM14X2X160 GR 10.9', 'X', '73181500', 101.60, 100.00, 20.00, 52.320, 48.50, 49.28, 121.92, 9.00, 4.71, 9.00, 4.71, 18.00, 9.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1038, '205145170-0200', 'HHBM14X2X170 GR 10.9', 'X', '73181500', 105.65, 5.00, 5.00, 54.410, 48.50, 51.24, 126.78, 9.00, 4.90, 9.00, 4.90, 18.00, 9.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1039, '205145180-0200', 'HHBM14X2X180 GR 10.9', 'X', '73181500', 108.95, 60.00, 20.00, 56.110, 48.50, 52.84, 130.74, 9.00, 5.05, 9.00, 5.05, 18.00, 10.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1040, '205145230-0200', 'HHBM14X2X230 GR 10.9', 'X', '73181500', 204.45, 20.00, 10.00, 105.290, 48.50, 99.16, 245.34, 9.00, 9.48, 9.00, 9.48, 18.00, 18.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1041, '205227080-0200', 'HHBM22X2.5X80 GR 10.9', 'X', '73181500', 107.40, 40.00, 10.00, 55.310, 48.50, 52.09, 128.88, 9.00, 4.98, 9.00, 4.98, 18.00, 9.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1042, '205227090-0200', 'HHBM22X2.5X90 GR 10.9', 'X', '73181500', 114.40, 40.00, 10.00, 58.920, 48.50, 55.48, 137.28, 9.00, 5.30, 9.00, 5.30, 18.00, 10.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1043, '205227100-0200', 'HHBM22X2.5X100 GR 10.9', 'X', '73181500', 116.15, 40.00, 10.00, 59.820, 48.50, 56.33, 139.38, 9.00, 5.38, 9.00, 5.38, 18.00, 10.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1044, '205227105-0200', 'HHBM22X2.5X105 GR 10.9', 'X', '73181500', 130.45, 30.00, 5.00, 67.180, 48.50, 63.27, 156.54, 9.00, 6.05, 9.00, 6.05, 18.00, 12.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1045, '212051020-0200', 'HHBM5X0.8X20 GR 8.8', 'X', '73181500', 4.15, 400.00, 100.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1046, '212051025-0200', 'HHBM5X0.8X25 GR 8.8', 'X', '73181500', 4.15, 500.00, 500.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 500.00, 500.00, 500.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1047, '212051030-0200', 'HHBM5X0.8X30 GR 8.8', 'X', '73181500', 4.40, 800.00, 200.00, 2.270, 48.50, 2.13, 5.28, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1048, '212051035-0200', 'HHBM5X0.8X35 GR 8.8', 'X', '73181500', 4.80, 2000.00, 500.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1049, '212051040-0200', 'HHBM5X0.8X40 GR 8.8', 'X', '73181500', 4.90, 800.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1050, '212051045-0200', 'HHBM5X0.8X45 GR 8.8', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1051, '212061025-0200', 'HHBM6X1X25 GR 8.8', 'X', '73181500', 4.15, 1200.00, 200.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1052, '212061030-0200', 'HHBM6X1X30 GR 8.8', 'X', '73181500', 4.40, 1200.00, 200.00, 2.270, 48.50, 2.13, 5.28, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1053, '212061035-0200', 'HHBM6X1X35 GR 8.8', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1054, '212061038-0200', 'HHBM6X1X38 GR 8.8', 'X', '73181500', 4.90, 1200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1055, '212061040-0200', 'HHBM6X1X40 GR 8.8', 'X', '73181500', 4.90, 1200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1056, '212061045-0200', 'HHBM6X1X45 GR 8.8', 'X', '73181500', 4.90, 600.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1057, '212061050-0200', 'HHBM6X1X50 GR 8.8', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1058, '212061055-0200', 'HHBM6X1X55 GR 8.8', 'X', '73181500', 5.80, 600.00, 100.00, 2.990, 48.50, 2.81, 6.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1059, '212061060-0200', 'HHBM6X1X60 GR 8.8', 'X', '73181500', 5.80, 600.00, 100.00, 2.990, 48.50, 2.81, 6.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1060, '212061065-0200', 'HHBM6X1X65 GR 8.8', 'X', '73181500', 6.65, 600.00, 100.00, 3.420, 48.50, 3.23, 7.98, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1061, '212061070-0200', 'HHBM6X1X70 GR 8.8', 'X', '73181500', 6.65, 600.00, 100.00, 3.420, 48.50, 3.23, 7.98, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1062, '212061075-0200', 'HHBM6X1X75 GR 8.8', 'X', '73181500', 7.25, 600.00, 100.00, 3.730, 48.50, 3.52, 8.70, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1063, '212061080-0200', 'HHBM6X1X80 GR 8.8', 'X', '73181500', 7.50, 400.00, 100.00, 3.860, 48.50, 3.64, 9.00, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1064, '212061085-0200', 'HHBM6X1X85 GR 8.8', 'X', '73181500', 8.25, 100.00, 100.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1065, '212082030-0200', 'HHBM8X1.25X30 GR 8.8', 'X', '73181500', 5.10, 600.00, 200.00, 2.630, 48.50, 2.47, 6.12, 9.00, 0.24, 9.00, 0.24, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1066, '212082032-0200', 'HHBM8X1.25X32 GR 8.8', 'X', '73181500', 5.55, 600.00, 200.00, 2.860, 48.50, 2.69, 6.66, 9.00, 0.26, 9.00, 0.26, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1067, '212082035-0200', 'HHBM8X1.25X35 GR 8.8', 'X', '73181500', 4.55, 600.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1068, '212082038-0200', 'HHBM8X1.25X38 GR 8.8', 'X', '73181500', 5.95, 600.00, 200.00, 3.060, 48.50, 2.89, 7.14, 9.00, 0.28, 9.00, 0.28, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1069, '212082040-0200', 'HHBM8X1.25X40 GR 8.8', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1070, '212082045-0200', 'HHBM8X1.25X45 GR 8.8', 'X', '73181500', 5.35, 800.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1071, '212082050-0200', 'HHBM8X1.25X50 GR 8.8', 'X', '73181500', 5.80, 800.00, 200.00, 2.990, 48.50, 2.81, 6.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1072, '212082055-0200', 'HHBM8X1.25X55 GR 8.8', 'X', '73181500', 7.00, 400.00, 100.00, 3.610, 48.50, 3.40, 8.40, 9.00, 0.32, 9.00, 0.32, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1073, '212082060-0200', 'HHBM8X1.25X60 GR 8.8', 'X', '73181500', 8.10, 300.00, 100.00, 4.170, 48.50, 3.93, 9.72, 9.00, 0.38, 9.00, 0.38, 18.00, 0.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1074, '212082065-0200', 'HHBM8X1.25X65 GR 8.8', 'X', '73181500', 8.35, 300.00, 100.00, 4.300, 48.50, 4.05, 10.02, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1075, '212082070-0200', 'HHBM8X1.25X70 GR 8.8', 'X', '73181500', 8.80, 400.00, 100.00, 4.530, 48.50, 4.27, 10.56, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1076, '212082075-0200', 'HHBM8X1.25X75 GR 8.8', 'X', '73181500', 9.15, 400.00, 100.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1077, '212082080-0200', 'HHBM8X1.25X80 GR 8.8', 'X', '73181500', 9.65, 400.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1078, '212082085-0200', 'HHBM8X1.25X85 GR 8.8', 'X', '73181500', 10.25, 400.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1079, '212082090-0200', 'HHBM8X1.25X90 GR 8.8', 'X', '73181500', 12.75, 400.00, 100.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1080, '212082095-0200', 'HHBM8X1.25X95 GR 8.8', 'X', '73181500', 13.55, 400.00, 100.00, 6.980, 48.50, 6.57, 16.26, 9.00, 0.63, 9.00, 0.63, 18.00, 1.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1081, '212082100-0200', 'HHBM8X1.25X100 GR 8.8', 'X', '73181500', 14.30, 400.00, 100.00, 7.360, 48.50, 6.94, 17.16, 9.00, 0.66, 9.00, 0.66, 18.00, 1.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1082, '212082105-0200', 'HHBM8X1.25X105 GR 8.8', 'X', '73181500', 15.10, 200.00, 50.00, 7.780, 48.50, 7.32, 18.12, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1083, '212082110-0200', 'HHBM8X1.25X110 GR 8.8', 'X', '73181500', 16.20, 400.00, 50.00, 8.340, 48.50, 7.86, 19.44, 9.00, 0.75, 9.00, 0.75, 18.00, 1.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1084, '212082115-0200', 'HHBM8X1.25X115 GR 8.8', 'X', '73181500', 20.60, 200.00, 50.00, 10.610, 48.50, 9.99, 24.72, 9.00, 0.95, 9.00, 0.95, 18.00, 1.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1085, '212082120-0200', 'HHBM8X1.25X120 GR 8.8', 'X', '73181500', 20.60, 150.00, 50.00, 10.610, 48.50, 9.99, 24.72, 9.00, 0.95, 9.00, 0.95, 18.00, 1.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1086, '212082125-0200', 'HHBM8X1.25X125 GR 8.8', 'X', '73181500', 21.15, 150.00, 50.00, 10.890, 48.50, 10.26, 25.38, 9.00, 0.98, 9.00, 0.98, 18.00, 1.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1087, '212082130-0200', 'HHBM8X1.25X130 GR 8.8', 'X', '73181500', 21.75, 150.00, 50.00, 11.200, 48.50, 10.55, 26.10, 9.00, 1.01, 9.00, 1.01, 18.00, 2.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1088, '212082135-0200', 'HHBM8X1.25X135 GR 8.8', 'X', '73181500', 24.80, 150.00, 50.00, 12.770, 48.50, 12.03, 29.76, 9.00, 1.15, 9.00, 1.15, 18.00, 2.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1089, '212082140-0200', 'HHBM8X1.25X140 GR 8.8', 'X', '73181500', 26.00, 150.00, 50.00, 13.390, 48.50, 12.61, 31.20, 9.00, 1.21, 9.00, 1.21, 18.00, 2.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1090, '212082145-0200', 'HHBM8X1.25X145 GR 8.8', 'X', '73181500', 29.00, 300.00, 50.00, 14.940, 48.50, 14.07, 34.80, 9.00, 1.34, 9.00, 1.34, 18.00, 2.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1091, '212082150-0200', 'HHBM8X1.25X150 GR 8.8', 'X', '73181500', 29.00, 150.00, 50.00, 14.940, 48.50, 14.07, 34.80, 9.00, 1.34, 9.00, 1.34, 18.00, 2.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1092, '212165050-0200', 'HHBM16X2X50 GR 8.8', 'X', '73181500', 32.25, 80.00, 20.00, 16.610, 48.50, 15.64, 38.70, 9.00, 1.49, 9.00, 1.49, 18.00, 2.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1093, '212165055-0200', 'HHBM16X2X55 GR 8.8', 'X', '73181500', 34.40, 80.00, 20.00, 17.720, 48.50, 16.68, 41.28, 9.00, 1.59, 9.00, 1.59, 18.00, 3.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1094, '212165060-0200', 'HHBM16X2X60 GR 8.8', 'X', '73181500', 36.95, 80.00, 20.00, 19.030, 48.50, 17.92, 44.34, 9.00, 1.71, 9.00, 1.71, 18.00, 3.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1095, '212165065-0200', 'HHBM16X2X65 GR 8.8', 'X', '73181500', 39.05, 60.00, 20.00, 20.110, 48.50, 18.94, 46.86, 9.00, 1.81, 9.00, 1.81, 18.00, 3.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1096, '212165070-0200', 'HHBM16X2X70 GR 8.8', 'X', '73181500', 41.45, 60.00, 20.00, 21.350, 48.50, 20.10, 49.74, 9.00, 1.92, 9.00, 1.92, 18.00, 3.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1097, '212165075-0200', 'HHBM16X2X75 GR 8.8', 'X', '73181500', 44.45, 60.00, 20.00, 22.890, 48.50, 21.56, 53.34, 9.00, 2.06, 9.00, 2.06, 18.00, 4.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1098, '212165080-0200', 'HHBM16X2X80 GR 8.8', 'X', '73181500', 48.50, 60.00, 20.00, 24.980, 48.50, 23.52, 58.20, 9.00, 2.25, 9.00, 2.25, 18.00, 4.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1099, '212165085-0200', 'HHBM16X2X85 GR 8.8', 'X', '73181500', 49.95, 60.00, 20.00, 25.720, 48.50, 24.23, 59.94, 9.00, 2.32, 9.00, 2.32, 18.00, 4.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1100, '212165090-0200', 'HHBM16X2X90 GR 8.8', 'X', '73181500', 51.90, 60.00, 20.00, 26.730, 48.50, 25.17, 62.28, 9.00, 2.41, 9.00, 2.41, 18.00, 4.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1101, '212165095-0200', 'HHBM16X2X95 GR 8.8', 'X', '73181500', 56.10, 60.00, 20.00, 28.890, 48.50, 27.21, 67.32, 9.00, 2.60, 9.00, 2.60, 18.00, 5.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1102, '212165100-0200', 'HHBM16X2X100 GR 8.8', 'X', '73181500', 56.35, 80.00, 20.00, 29.020, 48.50, 27.33, 67.62, 9.00, 2.61, 9.00, 2.61, 18.00, 5.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1103, '212165105-0200', 'HHBM16X2X105 GR 8.8', 'X', '73181500', 59.95, 80.00, 20.00, 30.870, 48.50, 29.08, 71.94, 9.00, 2.78, 9.00, 2.78, 18.00, 5.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1104, '212165110-0200', 'HHBM16X2X110 GR 8.8', 'X', '73181500', 61.25, 80.00, 20.00, 31.540, 48.50, 29.71, 73.50, 9.00, 2.84, 9.00, 2.84, 18.00, 5.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1105, '212165115-0200', 'HHBM16X2X115 GR 8.8', 'X', '73181500', 78.75, 80.00, 20.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1106, '212165120-0200', 'HHBM16X2X120 GR 8.8', 'X', '73181500', 68.30, 80.00, 20.00, 35.170, 48.50, 33.13, 81.96, 9.00, 3.17, 9.00, 3.17, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1107, '212165125-0200', 'HHBM16X2X125 GR 8.8', 'X', '73181500', 69.00, 80.00, 20.00, 35.540, 48.50, 33.47, 82.80, 9.00, 3.20, 9.00, 3.20, 18.00, 6.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1108, '212165130-0200', 'HHBM16X2X130 GR 8.8', 'X', '73181500', 81.70, 80.00, 20.00, 42.080, 48.50, 39.62, 98.04, 9.00, 3.79, 9.00, 3.79, 18.00, 7.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1109, '212165135-0200', 'HHBM16X2X135 GR 8.8', 'X', '73181500', 95.65, 80.00, 20.00, 49.260, 48.50, 46.39, 114.78, 9.00, 4.43, 9.00, 4.43, 18.00, 8.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1110, '212165140-0200', 'HHBM16X2X140 GR 8.8', 'X', '73181500', 83.40, 80.00, 20.00, 42.950, 48.50, 40.45, 100.08, 9.00, 3.87, 9.00, 3.87, 18.00, 7.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1111, '212165150-0200', 'HHBM16X2X150 GR 8.8', 'X', '73181500', 99.15, 80.00, 20.00, 51.060, 48.50, 48.09, 118.98, 9.00, 4.60, 9.00, 4.60, 18.00, 9.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1112, '212165160-0200', 'HHBM16X2X160 GR 8.8', 'X', '73181500', 102.75, 80.00, 20.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1113, '212165165-0200', 'HHBM16X2X165 GR 8.8', 'X', '73181500', 109.60, 20.00, 10.00, 56.440, 48.50, 53.16, 131.52, 9.00, 5.08, 9.00, 5.08, 18.00, 10.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1114, '212165170-0200', 'HHBM16X2X170 GR 8.8', 'X', '73181500', 111.75, 20.00, 10.00, 57.550, 48.50, 54.20, 134.10, 9.00, 5.18, 9.00, 5.18, 18.00, 10.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1115, '212165175-0200', 'HHBM16X2X175 GR 8.8', 'X', '73181500', 113.45, 20.00, 10.00, 58.430, 48.50, 55.02, 136.14, 9.00, 5.26, 9.00, 5.26, 18.00, 10.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1116, '212165180-0200', 'HHBM16X2X180 GR 8.8', 'X', '73181500', 115.55, 20.00, 10.00, 59.510, 48.50, 56.04, 138.66, 9.00, 5.36, 9.00, 5.36, 18.00, 10.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1117, '212165190-0200', 'HHBM16X2X190 GR 8.8', 'X', '73181500', 119.20, 20.00, 10.00, 61.390, 48.50, 57.81, 143.04, 9.00, 5.52, 9.00, 5.52, 18.00, 11.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1118, '212165200-0200', 'HHBM16X2X200 GR 8.8', 'X', '73181500', 125.05, 20.00, 10.00, 64.400, 48.50, 60.65, 150.06, 9.00, 5.80, 9.00, 5.80, 18.00, 11.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1119, '212165210-0200', 'HHBM16X2X210 GR 8.8', 'X', '73181500', 179.70, 20.00, 10.00, 92.550, 48.50, 87.15, 215.64, 9.00, 8.33, 9.00, 8.33, 18.00, 16.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1120, '212165220-0200', 'HHBM16X2X220 GR 8.8', 'X', '73181500', 179.70, 20.00, 10.00, 92.550, 48.50, 87.15, 215.64, 9.00, 8.33, 9.00, 8.33, 18.00, 16.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1121, '212165240-0200', 'HHBM16X2X240 GR 8.8', 'X', '73181500', 193.25, 20.00, 10.00, 99.520, 48.50, 93.73, 231.90, 9.00, 8.96, 9.00, 8.96, 18.00, 17.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1122, '212165280-0200', 'HHBM16X2X280 GR 8.8', 'X', '73181500', 217.65, 10.00, 10.00, 112.090, 48.50, 105.56, 261.18, 9.00, 10.09, 9.00, 10.09, 18.00, 20.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1123, '212165300-0200', 'HHBM16X2X300 GR 8.8', 'X', '73181500', 239.40, 10.00, 10.00, 123.290, 48.50, 116.11, 287.28, 9.00, 11.10, 9.00, 11.10, 18.00, 22.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1124, '212183055-0200', 'HHBM18X1.5X55 GR 8.8', 'X', '73181500', 66.15, 60.00, 20.00, 34.070, 48.50, 32.08, 79.38, 9.00, 3.07, 9.00, 3.07, 18.00, 6.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1125, '212183060-0200', 'HHBM18X1.5X60 GR 8.8', 'X', '73181500', 68.15, 60.00, 20.00, 35.100, 48.50, 33.05, 81.78, 9.00, 3.16, 9.00, 3.16, 18.00, 6.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1126, '212183065-0200', 'HHBM18X1.5X65 GR 8.8', 'X', '73181500', 70.55, 60.00, 20.00, 36.330, 48.50, 34.22, 84.66, 9.00, 3.27, 9.00, 3.27, 18.00, 6.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1127, '212183070-0200', 'HHBM18X1.5X70 GR 8.8', 'X', '73181500', 73.50, 80.00, 20.00, 37.850, 48.50, 35.65, 88.20, 9.00, 3.41, 9.00, 3.41, 18.00, 6.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1128, '212183075-0200', 'HHBM18X1.5X75 GR 8.8', 'X', '73181500', 77.90, 80.00, 20.00, 40.120, 48.50, 37.78, 93.48, 9.00, 3.61, 9.00, 3.61, 18.00, 7.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1129, '212183080-0200', 'HHBM18X1.5X80 GR 8.8', 'X', '73181500', 77.90, 40.00, 10.00, 40.120, 48.50, 37.78, 93.48, 9.00, 3.61, 9.00, 3.61, 18.00, 7.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1130, '212183085-0200', 'HHBM18X1.5X85 GR 8.8', 'X', '73181500', 82.95, 30.00, 10.00, 42.720, 48.50, 40.23, 99.54, 9.00, 3.84, 9.00, 3.84, 18.00, 7.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1131, '212183090-0200', 'HHBM18X1.5X90 GR 8.8', 'X', '73181500', 82.95, 30.00, 10.00, 42.720, 48.50, 40.23, 99.54, 9.00, 3.84, 9.00, 3.84, 18.00, 7.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1132, '212183120-0200', 'HHBM18X1.5X120 GR 8.8', 'X', '73181500', 104.20, 30.00, 10.00, 53.660, 48.50, 50.54, 125.04, 9.00, 4.83, 9.00, 4.83, 18.00, 9.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1133, '212187055-0200', 'HHBM18X2.5X55 GR 8.8', 'X', '73181500', 60.10, 60.00, 20.00, 30.950, 48.50, 29.15, 72.12, 9.00, 2.79, 9.00, 2.79, 18.00, 5.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1134, '212187060-0200', 'HHBM18X2.5X60 GR 8.8', 'X', '73181500', 62.05, 60.00, 20.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1135, '212187065-0200', 'HHBM18X2.5X65 GR 8.8', 'X', '73181500', 64.20, 60.00, 20.00, 33.060, 48.50, 31.14, 77.04, 9.00, 2.98, 9.00, 2.98, 18.00, 5.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1136, '212187070-0200', 'HHBM18X2.5X70 GR 8.8', 'X', '73181500', 66.85, 40.00, 20.00, 34.430, 48.50, 32.42, 80.22, 9.00, 3.10, 9.00, 3.10, 18.00, 6.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1137, '212187075-0200', 'HHBM18X2.5X75 GR 8.8', 'X', '73181500', 70.85, 40.00, 20.00, 36.490, 48.50, 34.36, 85.02, 9.00, 3.28, 9.00, 3.28, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1138, '212187080-0200', 'HHBM18X2.5X80 GR 8.8', 'X', '73181500', 70.85, 40.00, 10.00, 36.490, 48.50, 34.36, 85.02, 9.00, 3.28, 9.00, 3.28, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1139, '212187085-0200', 'HHBM18X2.5X85 GR 8.8', 'X', '73181500', 72.95, 30.00, 10.00, 37.570, 48.50, 35.38, 87.54, 9.00, 3.38, 9.00, 3.38, 18.00, 6.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1140, '212187090-0200', 'HHBM18X2.5X90 GR 8.8', 'X', '73181500', 75.30, 30.00, 10.00, 38.780, 48.50, 36.52, 90.36, 9.00, 3.49, 9.00, 3.49, 18.00, 6.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1141, '212187100-0200', 'HHBM18X2.5X100 GR 8.8', 'X', '73181500', 79.90, 30.00, 10.00, 41.150, 48.50, 38.75, 95.88, 9.00, 3.70, 9.00, 3.70, 18.00, 7.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1142, '212187110-0200', 'HHBM18X2.5X110 GR 8.8', 'X', '73181500', 87.85, 30.00, 10.00, 45.240, 48.50, 42.61, 105.42, 9.00, 4.07, 9.00, 4.07, 18.00, 8.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1143, '212187115-0200', 'HHBM18X2.5X115 GR 8.8', 'X', '73181500', 102.75, 30.00, 10.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1144, '212187120-0200', 'HHBM18X2.5X120 GR 8.8', 'X', '73181500', 92.60, 30.00, 10.00, 47.690, 48.50, 44.91, 111.12, 9.00, 4.29, 9.00, 4.29, 18.00, 8.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1145, '212187125-0200', 'HHBM18X2.5X125 GR 8.8', 'X', '73181500', 94.65, 30.00, 10.00, 48.740, 48.50, 45.91, 113.58, 9.00, 4.39, 9.00, 4.39, 18.00, 8.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1146, '212187130-0200', 'HHBM18X2.5X130 GR 8.8', 'X', '73181500', 96.80, 30.00, 10.00, 49.850, 48.50, 46.95, 116.16, 9.00, 4.49, 9.00, 4.49, 18.00, 8.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1147, '212187140-0200', 'HHBM18X2.5X140 GR 8.8', 'X', '73181500', 101.10, 30.00, 10.00, 52.070, 48.50, 49.03, 121.32, 9.00, 4.69, 9.00, 4.69, 18.00, 9.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1148, '212187150-0200', 'HHBM18X2.5X150 GR 8.8', 'X', '73181500', 108.15, 40.00, 10.00, 55.700, 48.50, 52.45, 129.78, 9.00, 5.01, 9.00, 5.01, 18.00, 10.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1149, '212187160-0200', 'HHBM18X2.5X160 GR 8.8', 'X', '73181500', 119.95, 20.00, 10.00, 61.770, 48.50, 58.18, 143.94, 9.00, 5.56, 9.00, 5.56, 18.00, 11.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1150, '212187165-0200', 'HHBM18X2.5X165 GR 8.8', 'X', '73181500', 122.30, 20.00, 10.00, 62.980, 48.50, 59.32, 146.76, 9.00, 5.67, 9.00, 5.67, 18.00, 11.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1151, '212187170-0200', 'HHBM18X2.5X170 GR 8.8', 'X', '73181500', 124.55, 30.00, 10.00, 64.140, 48.50, 60.41, 149.46, 9.00, 5.77, 9.00, 5.77, 18.00, 11.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1152, '212187180-0200', 'HHBM18X2.5X180 GR 8.8', 'X', '73181500', 129.85, 20.00, 10.00, 66.870, 48.50, 62.98, 155.82, 9.00, 6.02, 9.00, 6.02, 18.00, 12.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1153, '212203060-0200', 'HHBM20X1.5X60 GR 8.8', 'X', '73181500', 73.50, 40.00, 20.00, 37.850, 48.50, 35.65, 88.20, 9.00, 3.41, 9.00, 3.41, 18.00, 6.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1154, '212203065-0200', 'HHBM20X1.5X65 GR 8.8', 'X', '73181500', 78.75, 40.00, 20.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1155, '212203070-0200', 'HHBM20X1.5X70 GR 8.8', 'X', '73181500', 78.75, 30.00, 10.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1156, '212203075-0200', 'HHBM20X1.5X75 GR 8.8', 'X', '73181500', 81.90, 30.00, 10.00, 42.180, 48.50, 39.72, 98.28, 9.00, 3.80, 9.00, 3.80, 18.00, 7.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1157, '212203080-0200', 'HHBM20X1.5X80 GR 8.8', 'X', '73181500', 84.30, 30.00, 10.00, 43.410, 48.50, 40.89, 101.16, 9.00, 3.91, 9.00, 3.91, 18.00, 7.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1158, '212203085-0200', 'HHBM20X1.5X85 GR 8.8', 'X', '73181500', 86.75, 20.00, 10.00, 44.680, 48.50, 42.07, 104.10, 9.00, 4.02, 9.00, 4.02, 18.00, 8.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1159, '212203090-0200', 'HHBM20X1.5X90 GR 8.8', 'X', '73181500', 89.70, 30.00, 10.00, 46.200, 48.50, 43.50, 107.64, 9.00, 4.16, 9.00, 4.16, 18.00, 8.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1160, '212203100-0200', 'HHBM20X1.5X100 GR 8.8', 'X', '73181500', 94.75, 30.00, 10.00, 48.800, 48.50, 45.95, 113.70, 9.00, 4.39, 9.00, 4.39, 18.00, 8.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1161, '212203120-0200', 'HHBM20X1.5X120 GR 8.8', 'X', '73181500', 108.50, 30.00, 10.00, 55.880, 48.50, 52.62, 130.20, 9.00, 5.03, 9.00, 5.03, 18.00, 10.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1162, '212203130-0200', 'HHBM20X1.5X130 GR 8.8', 'X', '73181500', 116.05, 30.00, 10.00, 59.770, 48.50, 56.28, 139.26, 9.00, 5.38, 9.00, 5.38, 18.00, 10.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1163, '212203140-0200', 'HHBM20X1.5X140 GR 8.8', 'X', '73181500', 120.55, 40.00, 10.00, 62.080, 48.50, 58.47, 144.66, 9.00, 5.59, 9.00, 5.59, 18.00, 11.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1164, '212203150-0200', 'HHBM20X1.5X150 GR 8.8', 'X', '73181500', 127.20, 40.00, 10.00, 65.510, 48.50, 61.69, 152.64, 9.00, 5.90, 9.00, 5.90, 18.00, 11.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1165, '212207060-0200', 'HHBM20X2.5X60 GR 8.8', 'X', '73181500', 66.85, 80.00, 20.00, 34.430, 48.50, 32.42, 80.22, 9.00, 3.10, 9.00, 3.10, 18.00, 6.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1166, '212207065-0200', 'HHBM20X2.5X65 GR 8.8', 'X', '73181500', 69.00, 80.00, 20.00, 35.540, 48.50, 33.47, 82.80, 9.00, 3.20, 9.00, 3.20, 18.00, 6.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1167, '212207070-0200', 'HHBM20X2.5X70 GR 8.8', 'X', '73181500', 71.60, 30.00, 10.00, 36.870, 48.50, 34.73, 85.92, 9.00, 3.32, 9.00, 3.32, 18.00, 6.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1168, '212207075-0200', 'HHBM20X2.5X75 GR 8.8', 'X', '73181500', 74.50, 30.00, 10.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1169, '212207080-0200', 'HHBM20X2.5X80 GR 8.8', 'X', '73181500', 76.65, 30.00, 10.00, 39.470, 48.50, 37.18, 91.98, 9.00, 3.55, 9.00, 3.55, 18.00, 7.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1170, '212207085-0200', 'HHBM20X2.5X85 GR 8.8', 'X', '73181500', 78.95, 30.00, 10.00, 40.660, 48.50, 38.29, 94.74, 9.00, 3.66, 9.00, 3.66, 18.00, 7.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1171, '212207090-0200', 'HHBM20X2.5X90 GR 8.8', 'X', '73181500', 81.50, 30.00, 10.00, 41.970, 48.50, 39.53, 97.80, 9.00, 3.78, 9.00, 3.78, 18.00, 7.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1172, '212207095-0200', 'HHBM20X2.5X95 GR 8.8', 'X', '73181500', 84.30, 30.00, 10.00, 43.410, 48.50, 40.89, 101.16, 9.00, 3.91, 9.00, 3.91, 18.00, 7.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1173, '212207100-0200', 'HHBM20X2.5X100 GR 8.8', 'X', '73181500', 86.25, 30.00, 10.00, 44.420, 48.50, 41.83, 103.50, 9.00, 4.00, 9.00, 4.00, 18.00, 8.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1174, '212207105-0200', 'HHBM20X2.5X105 GR 8.8', 'X', '73181500', 90.20, 30.00, 10.00, 46.450, 48.50, 43.75, 108.24, 9.00, 4.18, 9.00, 4.18, 18.00, 8.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(1175, '212207110-0200', 'HHBM20X2.5X110 GR 8.8', 'X', '73181500', 91.05, 30.00, 10.00, 46.890, 48.50, 44.16, 109.26, 9.00, 4.22, 9.00, 4.22, 18.00, 8.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1176, '212207115-0200', 'HHBM20X2.5X115 GR 8.8', 'X', '73181500', 105.10, 30.00, 10.00, 54.130, 48.50, 50.97, 126.12, 9.00, 4.87, 9.00, 4.87, 18.00, 9.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1177, '212207120-0200', 'HHBM20X2.5X120 GR 8.8', 'X', '73181500', 98.60, 30.00, 10.00, 50.780, 48.50, 47.82, 118.32, 9.00, 4.57, 9.00, 4.57, 18.00, 9.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1178, '212207125-0200', 'HHBM20X2.5X125 GR 8.8', 'X', '73181500', 102.40, 30.00, 10.00, 52.740, 48.50, 49.66, 122.88, 9.00, 4.75, 9.00, 4.75, 18.00, 9.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1179, '212207130-0200', 'HHBM20X2.5X130 GR 8.8', 'X', '73181500', 105.35, 30.00, 10.00, 54.260, 48.50, 51.09, 126.42, 9.00, 4.88, 9.00, 4.88, 18.00, 9.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1180, '212207135-0200', 'HHBM20X2.5X135 GR 8.8', 'X', '73181500', 123.20, 80.00, 20.00, 63.450, 48.50, 59.75, 147.84, 9.00, 5.71, 9.00, 5.71, 18.00, 11.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1181, '212207140-0200', 'HHBM20X2.5X140 GR 8.8', 'X', '73181500', 109.60, 40.00, 10.00, 56.440, 48.50, 53.16, 131.52, 9.00, 5.08, 9.00, 5.08, 18.00, 10.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1182, '212207150-0200', 'HHBM20X2.5X150 GR 8.8', 'X', '73181500', 115.65, 40.00, 10.00, 59.560, 48.50, 56.09, 138.78, 9.00, 5.36, 9.00, 5.36, 18.00, 10.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1183, '212207160-0200', 'HHBM20X2.5X160 GR 8.8', 'X', '73181500', 131.45, 20.00, 10.00, 67.700, 48.50, 63.75, 157.74, 9.00, 6.09, 9.00, 6.09, 18.00, 12.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1184, '212207170-0200', 'HHBM20X2.5X170 GR 8.8', 'X', '73181500', 136.90, 20.00, 10.00, 70.500, 48.50, 66.40, 164.28, 9.00, 6.35, 9.00, 6.35, 18.00, 12.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1185, '212207175-0200', 'HHBM20X2.5X175 GR 8.8', 'X', '73181500', 139.60, 20.00, 10.00, 71.890, 48.50, 67.71, 167.52, 9.00, 6.47, 9.00, 6.47, 18.00, 12.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1186, '212207180-0200', 'HHBM20X2.5X180 GR 8.8', 'X', '73181500', 142.95, 20.00, 10.00, 73.620, 48.50, 69.33, 171.54, 9.00, 6.63, 9.00, 6.63, 18.00, 13.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1187, '212207190-0200', 'HHBM20X2.5X190 GR 8.8', 'X', '73181500', 147.95, 20.00, 10.00, 76.190, 48.50, 71.76, 177.54, 9.00, 6.86, 9.00, 6.86, 18.00, 13.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1188, '212207200-0200', 'HHBM20X2.5X200 GR 8.8', 'X', '73181500', 153.90, 20.00, 10.00, 79.260, 48.50, 74.64, 184.68, 9.00, 7.13, 9.00, 7.13, 18.00, 14.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1189, '212207220-0200', 'HHBM20X2.5X220 GR 8.8', 'X', '73181500', 333.45, 10.00, 10.00, 171.730, 48.50, 161.72, 400.14, 9.00, 15.46, 9.00, 15.46, 18.00, 30.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1190, '212207250-0200', 'HHBM20X2.5X250 GR 8.8', 'X', '73181500', 317.85, 10.00, 10.00, 163.690, 48.50, 154.16, 381.42, 9.00, 14.73, 9.00, 14.73, 18.00, 29.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1191, '212207260-0200', 'HHBM20X2.5X260 GR 8.8', 'X', '73181500', 317.85, 10.00, 10.00, 163.690, 48.50, 154.16, 381.42, 9.00, 14.73, 9.00, 14.73, 18.00, 29.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1192, '212207280-0200', 'HHBM20X2.5X280 GR 8.8', 'X', '73181500', 346.65, 10.00, 5.00, 178.520, 48.50, 168.13, 415.98, 9.00, 16.07, 9.00, 16.07, 18.00, 32.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1193, '212207300-0200', 'HHBM20X2.5X300 GR 8.8', 'X', '73181500', 377.75, 10.00, 10.00, 194.540, 48.50, 183.21, 453.30, 9.00, 17.51, 9.00, 17.51, 18.00, 35.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1194, '212227060-0200', 'HHBM22X2.5X60 GR 8.8', 'X', '73181500', 86.10, 30.00, 10.00, 44.340, 48.50, 41.76, 103.32, 9.00, 3.99, 9.00, 3.99, 18.00, 7.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1195, '212227065-0200', 'HHBM22X2.5X65 GR 8.8', 'X', '73181500', 96.70, 30.00, 10.00, 49.800, 48.50, 46.90, 116.04, 9.00, 4.48, 9.00, 4.48, 18.00, 8.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1196, '212227070-0200', 'HHBM22X2.5X70 GR 8.8', 'X', '73181500', 99.95, 30.00, 10.00, 51.470, 48.50, 48.48, 119.94, 9.00, 4.63, 9.00, 4.63, 18.00, 9.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1197, '212227075-0200', 'HHBM22X2.5X75 GR 8.8', 'X', '73181500', 103.35, 30.00, 10.00, 53.230, 48.50, 50.12, 124.02, 9.00, 4.79, 9.00, 4.79, 18.00, 9.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1198, '212227080-0200', 'HHBM22X2.5X80 GR 8.8', 'X', '73181500', 107.40, 40.00, 10.00, 55.310, 48.50, 52.09, 128.88, 9.00, 4.98, 9.00, 4.98, 18.00, 9.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1199, '212227085-0200', 'HHBM22X2.5X85 GR 8.8', 'X', '73181500', 110.85, 40.00, 10.00, 57.090, 48.50, 53.76, 133.02, 9.00, 5.14, 9.00, 5.14, 18.00, 10.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1200, '212227090-0200', 'HHBM22X2.5X90 GR 8.8', 'X', '73181500', 114.40, 40.00, 10.00, 58.920, 48.50, 55.48, 137.28, 9.00, 5.30, 9.00, 5.30, 18.00, 10.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1201, '212227100-0200', 'HHBM22X2.5X100 GR 8.8', 'X', '73181500', 116.15, 40.00, 10.00, 59.820, 48.50, 56.33, 139.38, 9.00, 5.38, 9.00, 5.38, 18.00, 10.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1202, '212227110-0200', 'HHBM22X2.5X110 GR 8.8', 'X', '73181500', 132.80, 15.00, 5.00, 68.390, 48.50, 64.41, 159.36, 9.00, 6.16, 9.00, 6.16, 18.00, 12.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1203, '212227115-0200', 'HHBM22X2.5X115 GR 8.8', 'X', '73181500', 157.80, 15.00, 5.00, 81.270, 48.50, 76.53, 189.36, 9.00, 7.31, 9.00, 7.31, 18.00, 14.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1204, '212227120-0200', 'HHBM22X2.5X120 GR 8.8', 'X', '73181500', 141.75, 15.00, 5.00, 73.000, 48.50, 68.75, 170.10, 9.00, 6.57, 9.00, 6.57, 18.00, 13.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1205, '212227125-0200', 'HHBM22X2.5X125 GR 8.8', 'X', '73181500', 146.10, 15.00, 5.00, 75.240, 48.50, 70.86, 175.32, 9.00, 6.77, 9.00, 6.77, 18.00, 13.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1206, '212227130-0200', 'HHBM22X2.5X130 GR 8.8', 'X', '73181500', 149.55, 15.00, 5.00, 77.020, 48.50, 72.53, 179.46, 9.00, 6.93, 9.00, 6.93, 18.00, 13.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1207, '212227135-0200', 'HHBM22X2.5X135 GR 8.8', 'X', '73181500', 175.10, 15.00, 5.00, 90.180, 48.50, 84.92, 210.12, 9.00, 8.12, 9.00, 8.12, 18.00, 16.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1208, '212227140-0200', 'HHBM22X2.5X140 GR 8.8', 'X', '73181500', 156.90, 15.00, 5.00, 80.800, 48.50, 76.10, 188.28, 9.00, 7.27, 9.00, 7.27, 18.00, 14.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1209, '212227150-0200', 'HHBM22X2.5X150 GR 8.8', 'X', '73181500', 164.40, 15.00, 5.00, 84.670, 48.50, 79.73, 197.28, 9.00, 7.62, 9.00, 7.62, 18.00, 15.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1210, '212227160-0200', 'HHBM22X2.5X160 GR 8.8', 'X', '73181500', 178.85, 10.00, 5.00, 92.110, 48.50, 86.74, 214.62, 9.00, 8.29, 9.00, 8.29, 18.00, 16.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1211, '212227170-0200', 'HHBM22X2.5X170 GR 8.8', 'X', '73181500', 186.30, 10.00, 5.00, 95.940, 48.50, 90.36, 223.56, 9.00, 8.64, 9.00, 8.64, 18.00, 17.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1212, '212227175-0200', 'HHBM22X2.5X175 GR 8.8', 'X', '73181500', 190.70, 10.00, 5.00, 98.210, 48.50, 92.49, 228.84, 9.00, 8.84, 9.00, 8.84, 18.00, 17.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1213, '212227180-0200', 'HHBM22X2.5X180 GR 8.8', 'X', '73181500', 194.20, 10.00, 5.00, 100.010, 48.50, 94.19, 233.04, 9.00, 9.00, 9.00, 9.00, 18.00, 18.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1214, '212227190-0200', 'HHBM22X2.5X190 GR 8.8', 'X', '73181500', 202.20, 10.00, 5.00, 104.130, 48.50, 98.07, 242.64, 9.00, 9.37, 9.00, 9.37, 18.00, 18.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1215, '212227200-0200', 'HHBM22X2.5X200 GR 8.8', 'X', '73181500', 199.75, 10.00, 5.00, 102.870, 48.50, 96.88, 239.70, 9.00, 9.26, 9.00, 9.26, 18.00, 18.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1216, '212227220-0200', 'HHBM22X2.5X220 GR 8.8', 'X', '73181500', 395.60, 5.00, 5.00, 203.730, 48.50, 191.87, 474.72, 9.00, 18.34, 9.00, 18.34, 18.00, 36.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1217, '212249060-0200', 'HHBM24X3X60 GR 8.8', 'X', '73181500', 101.10, 20.00, 10.00, 52.070, 48.50, 49.03, 121.32, 9.00, 4.69, 9.00, 4.69, 18.00, 9.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1218, '212249065-0200', 'HHBM24X3X65 GR 8.8', 'X', '73181500', 104.75, 30.00, 10.00, 53.950, 48.50, 50.80, 125.70, 9.00, 4.86, 9.00, 4.86, 18.00, 9.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1219, '212249070-0200', 'HHBM24X3X70 GR 8.8', 'X', '73181500', 110.95, 40.00, 10.00, 57.140, 48.50, 53.81, 133.14, 9.00, 5.14, 9.00, 5.14, 18.00, 10.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1220, '212249075-0200', 'HHBM24X3X75 GR 8.8', 'X', '73181500', 115.05, 40.00, 10.00, 59.250, 48.50, 55.80, 138.06, 9.00, 5.33, 9.00, 5.33, 18.00, 10.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1221, '212249080-0200', 'HHBM24X3X80 GR 8.8', 'X', '73181500', 126.40, 40.00, 10.00, 65.100, 48.50, 61.30, 151.68, 9.00, 5.86, 9.00, 5.86, 18.00, 11.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1222, '212249085-0200', 'HHBM24X3X85 GR 8.8', 'X', '73181500', 130.55, 40.00, 10.00, 67.230, 48.50, 63.32, 156.66, 9.00, 6.05, 9.00, 6.05, 18.00, 12.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1223, '212249090-0200', 'HHBM24X3X90 GR 8.8', 'X', '73181500', 134.95, 40.00, 10.00, 69.500, 48.50, 65.45, 161.94, 9.00, 6.25, 9.00, 6.25, 18.00, 12.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1224, '212249095-0200', 'HHBM24X3X95 GR 8.8', 'X', '73181500', 138.75, 40.00, 10.00, 71.460, 48.50, 67.29, 166.50, 9.00, 6.43, 9.00, 6.43, 18.00, 12.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1225, '212249100-0200', 'HHBM24X3X100 GR 8.8', 'X', '73181500', 145.90, 40.00, 10.00, 75.140, 48.50, 70.76, 175.08, 9.00, 6.76, 9.00, 6.76, 18.00, 13.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1226, '212249105-0200', 'HHBM24X3X105 GR 8.8', 'X', '73181500', 147.30, 20.00, 5.00, 75.860, 48.50, 71.44, 176.76, 9.00, 6.83, 9.00, 6.83, 18.00, 13.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1227, '212249110-0200', 'HHBM24X3X110 GR 8.8', 'X', '73181500', 151.65, 15.00, 5.00, 78.100, 48.50, 73.55, 181.98, 9.00, 7.03, 9.00, 7.03, 18.00, 14.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1228, '212249115-0200', 'HHBM24X3X115 GR 8.8', 'X', '73181500', 178.10, 20.00, 5.00, 91.720, 48.50, 86.38, 213.72, 9.00, 8.25, 9.00, 8.25, 18.00, 16.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1229, '212249120-0200', 'HHBM24X3X120 GR 8.8', 'X', '73181500', 160.15, 15.00, 5.00, 82.480, 48.50, 77.67, 192.18, 9.00, 7.42, 9.00, 7.42, 18.00, 14.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1230, '212249125-0200', 'HHBM24X3X125 GR 8.8', 'X', '73181500', 163.95, 15.00, 5.00, 84.430, 48.50, 79.52, 196.74, 9.00, 7.60, 9.00, 7.60, 18.00, 15.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1231, '212249130-0200', 'HHBM24X3X130 GR 8.8', 'X', '73181500', 167.75, 15.00, 5.00, 86.390, 48.50, 81.36, 201.30, 9.00, 7.78, 9.00, 7.78, 18.00, 15.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1232, '212249135-0200', 'HHBM24X3X135 GR 8.8', 'X', '73181500', 196.60, 20.00, 5.00, 101.250, 48.50, 95.35, 235.92, 9.00, 9.11, 9.00, 9.11, 18.00, 18.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1233, '212249140-0200', 'HHBM24X3X140 GR 8.8', 'X', '73181500', 175.75, 20.00, 5.00, 90.510, 48.50, 85.24, 210.90, 9.00, 8.15, 9.00, 8.15, 18.00, 16.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1234, '212249145-0200', 'HHBM24X3X145 GR 8.8', 'X', '73181500', 180.55, 20.00, 5.00, 92.980, 48.50, 87.57, 216.66, 9.00, 8.37, 9.00, 8.37, 18.00, 16.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1235, '212249150-0200', 'HHBM24X3X150 GR 8.8', 'X', '73181500', 184.35, 20.00, 5.00, 94.940, 48.50, 89.41, 221.22, 9.00, 8.54, 9.00, 8.54, 18.00, 17.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1236, '212249155-0200', 'HHBM24X3X155 GR 8.8', 'X', '73181500', 196.60, 20.00, 5.00, 101.250, 48.50, 95.35, 235.92, 9.00, 9.11, 9.00, 9.11, 18.00, 18.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1237, '212249160-0200', 'HHBM24X3X160 GR 8.8', 'X', '73181500', 200.50, 20.00, 5.00, 103.260, 48.50, 97.24, 240.60, 9.00, 9.29, 9.00, 9.29, 18.00, 18.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1238, '212249165-0200', 'HHBM24X3X165 GR 8.8', 'X', '73181500', 204.95, 10.00, 5.00, 105.550, 48.50, 99.40, 245.94, 9.00, 9.50, 9.00, 9.50, 18.00, 19.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1239, '212249170-0200', 'HHBM24X3X170 GR 8.8', 'X', '73181500', 209.35, 10.00, 5.00, 107.820, 48.50, 101.53, 251.22, 9.00, 9.70, 9.00, 9.70, 18.00, 19.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1240, '212249175-0200', 'HHBM24X3X175 GR 8.8', 'X', '73181500', 213.35, 10.00, 5.00, 109.880, 48.50, 103.47, 256.02, 9.00, 9.89, 9.00, 9.89, 18.00, 19.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1241, '212249180-0200', 'HHBM24X3X180 GR 8.8', 'X', '73181500', 217.85, 20.00, 5.00, 112.190, 48.50, 105.66, 261.42, 9.00, 10.10, 9.00, 10.10, 18.00, 20.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1242, '212249190-0200', 'HHBM24X3X190 GR 8.8', 'X', '73181500', 226.20, 20.00, 5.00, 116.490, 48.50, 109.71, 271.44, 9.00, 10.48, 9.00, 10.48, 18.00, 20.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1243, '212249200-0200', 'HHBM24X3X200 GR 8.8', 'X', '73181500', 235.00, 20.00, 5.00, 121.030, 48.50, 113.98, 282.00, 9.00, 10.89, 9.00, 10.89, 18.00, 21.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1244, '212249220-0200', 'HHBM24X3X220 GR 8.8', 'X', '73181500', 455.25, 20.00, 5.00, 234.450, 48.50, 220.80, 546.30, 9.00, 21.10, 9.00, 21.10, 18.00, 42.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1245, '212249220-0800', 'HHBM24X3X220 GR 8.8', 'X', '73181500', 455.25, 20.00, 5.00, 234.450, 48.50, 220.80, 546.30, 9.00, 21.10, 9.00, 21.10, 18.00, 42.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1246, '212249230-0200', 'HHBM24X3X230 GR 8.8', 'X', '73181500', 471.60, 5.00, 5.00, 242.870, 48.50, 228.73, 565.92, 9.00, 21.86, 9.00, 21.86, 18.00, 43.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1247, '212249240-0200', 'HHBM24X3X240 GR 8.8', 'X', '73181500', 471.60, 5.00, 5.00, 242.870, 48.50, 228.73, 565.92, 9.00, 21.86, 9.00, 21.86, 18.00, 43.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1248, '212249260-0200', 'HHBM24X3X260 GR 8.8', 'X', '73181500', 487.90, 5.00, 5.00, 251.270, 48.50, 236.63, 585.48, 9.00, 22.61, 9.00, 22.61, 18.00, 45.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1249, '212249300-0200', 'HHBM24X3X300 GR 8.8', 'X', '73181500', 840.85, 5.00, 5.00, 433.040, 48.50, 407.81, 1009.02, 9.00, 38.97, 9.00, 38.97, 18.00, 77.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1250, '212279100-0200', 'HHBM27X3X100 GR 8.8', 'X', '73181500', 296.55, 15.00, 5.00, 152.720, 48.50, 143.83, 355.86, 9.00, 13.75, 9.00, 13.75, 18.00, 27.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1251, '212279110-0200', 'HHBM27X3X110 GR 8.8', 'X', '73181500', 319.90, 10.00, 5.00, 164.750, 48.50, 155.15, 383.88, 9.00, 14.83, 9.00, 14.83, 18.00, 29.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1252, '212279120-0200', 'HHBM27X3X120. GR 8.8', 'X', '73181500', 326.20, 20.00, 5.00, 167.990, 48.50, 158.21, 391.44, 9.00, 15.12, 9.00, 15.12, 18.00, 30.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1253, '212279160-0200', 'HHBM27X3X160 GR 8.8', 'X', '73181500', 402.40, 20.00, 5.00, 207.240, 48.50, 195.16, 482.88, 9.00, 18.65, 9.00, 18.65, 18.00, 37.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1254, '212307080-0200', 'HHBM30X3.5X80 GR 8.8', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1255, '212307090-0200', 'HHBM30X3.5X90 GR 8.8', 'X', '73181500', 334.70, 20.00, 5.00, 172.370, 48.50, 162.33, 401.64, 9.00, 15.51, 9.00, 15.51, 18.00, 31.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1256, '212307100-0200', 'HHBM30X3.5X100 GR 8.8', 'X', '73181500', 360.05, 20.00, 5.00, 185.430, 48.50, 174.62, 432.06, 9.00, 16.69, 9.00, 16.69, 18.00, 33.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1257, '212307110-0200', 'HHBM30X3.5X110 GR 8.8', 'X', '73181500', 396.15, 20.00, 5.00, 204.020, 48.50, 192.13, 475.38, 9.00, 18.36, 9.00, 18.36, 18.00, 36.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1258, '212307120-0200', 'HHBM30X3.5X120 GR 8.8', 'X', '73181500', 404.55, 10.00, 10.00, 208.340, 48.50, 196.21, 485.46, 9.00, 18.75, 9.00, 18.75, 18.00, 37.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1259, '212307130-0200', 'HHBM30X3.5X130 GR 8.8', 'X', '73181500', 423.65, 10.00, 5.00, 218.180, 48.50, 205.47, 508.38, 9.00, 19.64, 9.00, 19.64, 18.00, 39.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1260, '212307140-0200', 'HHBM30X3.5X140 GR 8.8', 'X', '73181500', 449.00, 10.00, 10.00, 231.240, 48.50, 217.77, 538.80, 9.00, 20.81, 9.00, 20.81, 18.00, 41.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1261, '212307150-0200', 'HHBM30X3.5X150 GR 8.8', 'X', '73181500', 474.40, 5.00, 5.00, 244.320, 48.50, 230.08, 569.28, 9.00, 21.99, 9.00, 21.99, 18.00, 43.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1262, '212307160-0200', 'HHBM30X3.5X160 GR 8.8', 'X', '73181500', 512.55, 5.00, 5.00, 263.960, 48.50, 248.59, 615.06, 9.00, 23.76, 9.00, 23.76, 18.00, 47.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1263, '212307180-0200', 'HHBM30X3.5X180 GR 8.8', 'X', '73181500', 565.40, 5.00, 5.00, 291.180, 48.50, 274.22, 678.48, 9.00, 26.21, 9.00, 26.21, 18.00, 52.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1264, '212307200-0200', 'HHBM30X3.5X200 GR 8.8', 'X', '73181500', 616.30, 5.00, 5.00, 317.390, 48.50, 298.91, 739.56, 9.00, 28.57, 9.00, 28.57, 18.00, 57.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1265, '212307210-0200', 'HHBM30X3.5X210 GR 8.8', 'X', '73181500', 743.25, 5.00, 5.00, 382.770, 48.50, 360.48, 891.90, 9.00, 34.45, 9.00, 34.45, 18.00, 68.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1266, '212307220-0200', 'HHBM30X3.5X220 GR 8.8', 'X', '73181500', 743.25, 5.00, 5.00, 382.770, 48.50, 360.48, 891.90, 9.00, 34.45, 9.00, 34.45, 18.00, 68.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1267, '212307280-0200', 'HHBM30X3.5X280 GR 8.8', 'X', '73181500', 902.15, 5.00, 5.00, 464.610, 48.50, 437.54, 1082.58, 9.00, 41.81, 9.00, 41.81, 18.00, 83.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1268, '212307300-0200', 'HHBM30X3.5X300 GR 8.8', 'X', '73181500', 962.15, 5.00, 5.00, 495.510, 48.50, 466.64, 1154.58, 9.00, 44.60, 9.00, 44.60, 18.00, 89.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1269, '212337125-0200', 'HHBM33X3.5X125 GR 8.8', 'X', '73181500', 542.15, 5.00, 5.00, 279.210, 48.50, 262.94, 650.58, 9.00, 25.13, 9.00, 25.13, 18.00, 50.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1270, '212369110-0200', 'HHBM36X4X110 GR 8.8', 'X', '73181500', 614.10, 5.00, 5.00, 316.260, 48.50, 297.84, 736.92, 9.00, 28.46, 9.00, 28.46, 18.00, 56.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1271, '212369130-0200', 'HHBM36X4X130 GR 8.8', 'X', '73181500', 658.65, 5.00, 5.00, 339.200, 48.50, 319.45, 790.38, 9.00, 30.53, 9.00, 30.53, 18.00, 61.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1272, '212369140-0200', 'HHBM36X4X140 GR 8.8', 'X', '73181500', 696.65, 5.00, 5.00, 358.770, 48.50, 337.88, 835.98, 9.00, 32.29, 9.00, 32.29, 18.00, 64.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1273, '212369150-0200', 'HHBM36X4X150 GR 8.8', 'X', '73181500', 734.80, 5.00, 5.00, 378.420, 48.50, 356.38, 881.76, 9.00, 34.06, 9.00, 34.06, 18.00, 68.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1274, '212369200-0200', 'HHBM36X4X200 GR 8.8', 'X', '73181500', 969.80, 2.00, 2.00, 499.450, 48.50, 470.35, 1163.76, 9.00, 44.95, 9.00, 44.95, 18.00, 89.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1275, '212369220-0200', 'HHBM36X4X220 GR 8.8', 'X', '73181500', 1162.55, 2.00, 2.00, 598.710, 48.50, 563.84, 1395.06, 9.00, 53.88, 9.00, 53.88, 18.00, 107.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1276, '212369240-0200', 'HHBM36X4X240 GR 8.8', 'X', '73181500', 1247.20, 2.00, 2.00, 642.310, 48.50, 604.89, 1496.64, 9.00, 57.81, 9.00, 57.81, 18.00, 115.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1277, '215051020-0200', 'HHBM5X0.8X20 GR 10.9', 'X', '73181500', 4.15, 1000.00, 1000.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1000.00, 1000.00, 1000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1278, '215051025-0200', 'HHBM5X0.8X25 GR 10.9', 'X', '73181500', 4.15, 500.00, 500.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 500.00, 500.00, 500.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1279, '215051030-0200', 'HHBM5X0.8X30 GR 10.9', 'X', '73181500', 4.40, 2000.00, 2000.00, 2.270, 48.50, 2.13, 5.28, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1280, '215051035-0200', 'HHBM5X0.8X35 GR 10.9', 'X', '73181500', 4.80, 500.00, 500.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 500.00, 500.00, 500.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1281, '215051040-0200', 'HHBM5X0.8X40 GR 10.9', 'X', '73181500', 4.90, 800.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1282, '215051045-0200', 'HHBM5X0.8X45 GR 10.9', 'X', '73181500', 5.00, 2000.00, 500.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2000.00, 2000.00, 2000.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1283, '215061025-0200', 'HHBM6X1X25 GR 10.9', 'X', '73181500', 4.15, 1200.00, 200.00, 2.140, 48.50, 2.01, 4.98, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1284, '215061030-0200', 'HHBM6X1X30 GR 10.9', 'X', '73181500', 4.40, 1200.00, 200.00, 2.270, 48.50, 2.13, 5.28, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1285, '215061035-0200', 'HHBM6X1X35 GR 10.9', 'X', '73181500', 4.80, 1200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1286, '215061040-0200', 'HHBM6X1X40 GR 10.9', 'X', '73181500', 4.90, 1200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1287, '215061045-0200', 'HHBM6X1X45 GR 10.9', 'X', '73181500', 4.90, 1200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1288, '215061050-0200', 'HHBM6X1X50 GR 10.9', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1289, '215061055-0200', 'HHBM6X1X55 GR 10.9', 'X', '73181500', 5.80, 600.00, 100.00, 2.990, 48.50, 2.81, 6.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1290, '215061060-0200', 'HHBM6X1X60 GR 10.9', 'X', '73181500', 5.80, 600.00, 100.00, 2.990, 48.50, 2.81, 6.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1291, '215061065-0200', 'HHBM6X1X65 GR 10.9', 'X', '73181500', 6.65, 600.00, 100.00, 3.420, 48.50, 3.23, 7.98, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1292, '215061070-0200', 'HHBM6X1X70 GR 10.9', 'X', '73181500', 6.65, 600.00, 100.00, 3.420, 48.50, 3.23, 7.98, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1293, '215061075-0200', 'HHBM6X1X75 GR 10.9', 'X', '73181500', 7.25, 600.00, 100.00, 3.730, 48.50, 3.52, 8.70, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1294, '215061080-0200', 'HHBM6X1X80 GR 10.9', 'X', '73181500', 7.50, 400.00, 100.00, 3.860, 48.50, 3.64, 9.00, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1295, '215082030-0200', 'HHBM8X1.25X30 GR 10.9', 'X', '73181500', 5.10, 600.00, 200.00, 2.630, 48.50, 2.47, 6.12, 9.00, 0.24, 9.00, 0.24, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1296, '215082035-0200', 'HHBM8X1.25X35 GR 10.9', 'X', '73181500', 4.55, 600.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1297, '215082038-0200', 'HHBM8X1.25X38 GR 10.9', 'X', '73181500', 5.95, 600.00, 200.00, 3.060, 48.50, 2.89, 7.14, 9.00, 0.28, 9.00, 0.28, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1298, '215082040-0200', 'HHBM8X1.25X40 GR 10.9', 'X', '73181500', 5.00, 800.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1299, '215082043-0200', 'HHBM8X1.25X43 GR 10.9', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1300, '215082045-0200', 'HHBM8X1.25X45 GR 10.9', 'X', '73181500', 5.35, 800.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1301, '215082050-0200', 'HHBM8X1.25X50 GR 10.9', 'X', '73181500', 5.80, 800.00, 200.00, 2.990, 48.50, 2.81, 6.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1302, '215082055-0200', 'HHBM8X1.25X55 GR 10.9', 'X', '73181500', 7.00, 800.00, 100.00, 3.610, 48.50, 3.40, 8.40, 9.00, 0.32, 9.00, 0.32, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1303, '215082060-0200', 'HHBM8X1.25X60 GR 10.9', 'X', '73181500', 8.10, 300.00, 100.00, 4.170, 48.50, 3.93, 9.72, 9.00, 0.38, 9.00, 0.38, 18.00, 0.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1304, '215082065-0200', 'HHBM8X1.25X65 GR 10.9', 'X', '73181500', 8.35, 300.00, 100.00, 4.300, 48.50, 4.05, 10.02, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1305, '215082070-0200', 'HHBM8X1.25X70 GR 10.9', 'X', '73181500', 8.80, 400.00, 100.00, 4.530, 48.50, 4.27, 10.56, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1306, '215082075-0200', 'HHBM8X1.25X75 GR 10.9', 'X', '73181500', 9.15, 400.00, 100.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1307, '215082080-0200', 'HHBM8X1.25X80 GR 10.9', 'X', '73181500', 9.65, 400.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1308, '215082085-0200', 'HHBM8X1.25X85 GR 10.9', 'X', '73181500', 10.25, 400.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1309, '215082090-0200', 'HHBM8X1.25X90 GR 10.9', 'X', '73181500', 12.75, 400.00, 100.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1310, '215082095-0200', 'HHBM8X1.25X95 GR 10.9', 'X', '73181500', 13.55, 400.00, 100.00, 6.980, 48.50, 6.57, 16.26, 9.00, 0.63, 9.00, 0.63, 18.00, 1.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1311, '215082100-0200', 'HHBM8X1.25X100 GR 10.9', 'X', '73181500', 14.30, 400.00, 100.00, 7.360, 48.50, 6.94, 17.16, 9.00, 0.66, 9.00, 0.66, 18.00, 1.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1312, '215082105-0200', 'HHBM8X1.25X105 GR 10.9', 'X', '73181500', 15.10, 200.00, 50.00, 7.780, 48.50, 7.32, 18.12, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1313, '215082110-0200', 'HHBM8X1.25X110 GR 10.9', 'X', '73181500', 16.20, 200.00, 50.00, 8.340, 48.50, 7.86, 19.44, 9.00, 0.75, 9.00, 0.75, 18.00, 1.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1314, '215082120-0200', 'HHBM8X1.25X120 GR 10.9', 'X', '73181500', 20.60, 150.00, 50.00, 10.610, 48.50, 9.99, 24.72, 9.00, 0.95, 9.00, 0.95, 18.00, 1.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1315, '215082125-0200', 'HHBM8X1.25X125 GR 10.9', 'X', '73181500', 21.15, 150.00, 50.00, 10.890, 48.50, 10.26, 25.38, 9.00, 0.98, 9.00, 0.98, 18.00, 1.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1316, '215082130-0200', 'HHBM8X1.25X130 GR 10.9', 'X', '73181500', 21.75, 150.00, 50.00, 11.200, 48.50, 10.55, 26.10, 9.00, 1.01, 9.00, 1.01, 18.00, 2.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1317, '215082135-0200', 'HHBM8X1.25X135 GR 10.9', 'X', '73181500', 24.80, 300.00, 50.00, 12.770, 48.50, 12.03, 29.76, 9.00, 1.15, 9.00, 1.15, 18.00, 2.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1318, '215082140-0200', 'HHBM8X1.25X140 GR 10.9', 'X', '73181500', 26.00, 150.00, 50.00, 13.390, 48.50, 12.61, 31.20, 9.00, 1.21, 9.00, 1.21, 18.00, 2.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1319, '215082150-0200', 'HHBM8X1.25X150 GR 10.9', 'X', '73181500', 29.00, 150.00, 50.00, 14.940, 48.50, 14.07, 34.80, 9.00, 1.34, 9.00, 1.34, 18.00, 2.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1320, '215123100-0200', 'HHBM12X1.5X100 GR 10.9', 'X', '73181500', 30.15, 80.00, 20.00, 15.530, 48.50, 14.62, 36.18, 9.00, 1.40, 9.00, 1.40, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1321, '215123115-0200', 'HHBM12X1.5X115 GR 10.9', 'X', '73181500', 40.80, 80.00, 20.00, 21.010, 48.50, 19.79, 48.96, 9.00, 1.89, 9.00, 1.89, 18.00, 3.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1322, '215123120-0200', 'HHBM12X1.5X120 GR 10.9', 'X', '73181500', 35.70, 60.00, 20.00, 18.390, 48.50, 17.31, 42.84, 9.00, 1.65, 9.00, 1.65, 18.00, 3.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1323, '215124060-0200', 'HHBM12X1.75X60 GR 10.9', 'X', '73181500', 18.25, 150.00, 50.00, 9.400, 48.50, 8.85, 21.90, 9.00, 0.85, 9.00, 0.85, 18.00, 1.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1324, '215165050-0200', 'HHBM16X2X50 GR 10.9', 'X', '73181500', 32.25, 80.00, 20.00, 16.610, 48.50, 15.64, 38.70, 9.00, 1.49, 9.00, 1.49, 18.00, 2.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1325, '215165055-0200', 'HHBM16X2X55 GR 10.9', 'X', '73181500', 34.40, 80.00, 20.00, 17.720, 48.50, 16.68, 41.28, 9.00, 1.59, 9.00, 1.59, 18.00, 3.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1326, '215165060-0200', 'HHBM16X2X60 GR 10.9', 'X', '73181500', 36.95, 80.00, 20.00, 19.030, 48.50, 17.92, 44.34, 9.00, 1.71, 9.00, 1.71, 18.00, 3.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1327, '215165065-0200', 'HHBM16X2X65 GR 10.9', 'X', '73181500', 39.05, 60.00, 20.00, 20.110, 48.50, 18.94, 46.86, 9.00, 1.81, 9.00, 1.81, 18.00, 3.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1328, '215165070-0200', 'HHBM16X2X70 GR 10.9', 'X', '73181500', 41.45, 120.00, 20.00, 21.350, 48.50, 20.10, 49.74, 9.00, 1.92, 9.00, 1.92, 18.00, 3.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1329, '215165075-0200', 'HHBM16X2X75 GR 10.9', 'X', '73181500', 44.45, 60.00, 20.00, 22.890, 48.50, 21.56, 53.34, 9.00, 2.06, 9.00, 2.06, 18.00, 4.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1330, '215165080-0200', 'HHBM16X2X80 GR 10.9', 'X', '73181500', 48.50, 60.00, 20.00, 24.980, 48.50, 23.52, 58.20, 9.00, 2.25, 9.00, 2.25, 18.00, 4.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1331, '215165085-0200', 'HHBM16X2X85 GR 10.9', 'X', '73181500', 49.95, 60.00, 20.00, 25.720, 48.50, 24.23, 59.94, 9.00, 2.32, 9.00, 2.32, 18.00, 4.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1332, '215165090-0200', 'HHBM16X2X90 GR 10.9', 'X', '73181500', 51.90, 60.00, 20.00, 26.730, 48.50, 25.17, 62.28, 9.00, 2.41, 9.00, 2.41, 18.00, 4.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1333, '215165095-0200', 'HHBM16X2X95 GR 10.9', 'X', '73181500', 56.10, 60.00, 20.00, 28.890, 48.50, 27.21, 67.32, 9.00, 2.60, 9.00, 2.60, 18.00, 5.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1334, '215165100-0200', 'HHBM16X2X100 GR 10.9', 'X', '73181500', 56.35, 80.00, 20.00, 29.020, 48.50, 27.33, 67.62, 9.00, 2.61, 9.00, 2.61, 18.00, 5.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1335, '215165105-0200', 'HHBM16X2X105 GR 10.9', 'X', '73181500', 59.95, 80.00, 20.00, 30.870, 48.50, 29.08, 71.94, 9.00, 2.78, 9.00, 2.78, 18.00, 5.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1336, '215165110-0200', 'HHBM16X2X110 GR 10.9', 'X', '73181500', 61.25, 80.00, 20.00, 31.540, 48.50, 29.71, 73.50, 9.00, 2.84, 9.00, 2.84, 18.00, 5.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1337, '215165115-0200', 'HHBM16X2X115 GR 10.9', 'X', '73181500', 78.75, 80.00, 20.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1338, '215165120-0200', 'HHBM16X2X120 GR 10.9', 'X', '73181500', 68.30, 80.00, 20.00, 35.170, 48.50, 33.13, 81.96, 9.00, 3.17, 9.00, 3.17, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1339, '215165125-0200', 'HHBM16X2X125 GR 10.9', 'X', '73181500', 69.00, 80.00, 20.00, 35.540, 48.50, 33.47, 82.80, 9.00, 3.20, 9.00, 3.20, 18.00, 6.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1340, '215165130-0200', 'HHBM16X2X130 GR 10.9', 'X', '73181500', 81.70, 80.00, 20.00, 42.080, 48.50, 39.62, 98.04, 9.00, 3.79, 9.00, 3.79, 18.00, 7.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1341, '215165135-0200', 'HHBM16X2X135 GR 10.9', 'X', '73181500', 95.65, 80.00, 20.00, 49.260, 48.50, 46.39, 114.78, 9.00, 4.43, 9.00, 4.43, 18.00, 8.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1342, '215165140-0200', 'HHBM16X2X140 GR 10.9', 'X', '73181500', 83.40, 80.00, 20.00, 42.950, 48.50, 40.45, 100.08, 9.00, 3.87, 9.00, 3.87, 18.00, 7.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1343, '215165150-0200', 'HHBM16X2X150 GR 10.9', 'X', '73181500', 99.15, 80.00, 20.00, 51.060, 48.50, 48.09, 118.98, 9.00, 4.60, 9.00, 4.60, 18.00, 9.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1344, '215165155-0200', 'HHBM16X2X155 GR 10.9', 'X', '73181500', 101.25, 10.00, 10.00, 52.140, 48.50, 49.11, 121.50, 9.00, 4.69, 9.00, 4.69, 18.00, 9.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1345, '215165160-0200', 'HHBM16X2X160 GR 10.9', 'X', '73181500', 102.75, 80.00, 20.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1346, '215165165-0200', 'HHBM16X2X165 GR 10.9', 'X', '73181500', 109.60, 10.00, 10.00, 56.440, 48.50, 53.16, 131.52, 9.00, 5.08, 9.00, 5.08, 18.00, 10.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1347, '215165170-0200', 'HHBM16X2X170 GR 10.9', 'X', '73181500', 111.75, 40.00, 10.00, 57.550, 48.50, 54.20, 134.10, 9.00, 5.18, 9.00, 5.18, 18.00, 10.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1348, '215165175-0200', 'HHBM16X2X175 GR 10.9', 'X', '73181500', 113.45, 40.00, 10.00, 58.430, 48.50, 55.02, 136.14, 9.00, 5.26, 9.00, 5.26, 18.00, 10.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1349, '215165180-0200', 'HHBM16X2X180 GR 10.9', 'X', '73181500', 115.55, 40.00, 10.00, 59.510, 48.50, 56.04, 138.66, 9.00, 5.36, 9.00, 5.36, 18.00, 10.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1350, '215165190-0200', 'HHBM16X2X190 GR 10.9', 'X', '73181500', 119.20, 40.00, 10.00, 61.390, 48.50, 57.81, 143.04, 9.00, 5.52, 9.00, 5.52, 18.00, 11.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1351, '215165200-0200', 'HHBM16X2X200 GR 10.9', 'X', '73181500', 125.05, 40.00, 10.00, 64.400, 48.50, 60.65, 150.06, 9.00, 5.80, 9.00, 5.80, 18.00, 11.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1352, '215165210-0200', 'HHBM16X2X210 GR 10.9', 'X', '73181500', 179.70, 10.00, 10.00, 92.550, 48.50, 87.15, 215.64, 9.00, 8.33, 9.00, 8.33, 18.00, 16.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1353, '215165220-0200', 'HHBM16X2X220 GR 10.9', 'X', '73181500', 179.70, 40.00, 10.00, 92.550, 48.50, 87.15, 215.64, 9.00, 8.33, 9.00, 8.33, 18.00, 16.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1354, '215165240-0200', 'HHBM16X2X240 GR 10.9', 'X', '73181500', 193.25, 40.00, 10.00, 99.520, 48.50, 93.73, 231.90, 9.00, 8.96, 9.00, 8.96, 18.00, 17.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1355, '215165250-0200', 'HHBM16X2X250 GR 10.9', 'X', '73181500', 197.20, 20.00, 20.00, 101.560, 48.50, 95.64, 236.64, 9.00, 9.14, 9.00, 9.14, 18.00, 18.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1356, '215165260-0200', 'HHBM16X2X260 GR 10.9', 'X', '73181500', 197.20, 10.00, 10.00, 101.560, 48.50, 95.64, 236.64, 9.00, 9.14, 9.00, 9.14, 18.00, 18.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1357, '215165280-0200', 'HHBM16X2X280 GR 10.9', 'X', '73181500', 217.65, 10.00, 10.00, 112.090, 48.50, 105.56, 261.18, 9.00, 10.09, 9.00, 10.09, 18.00, 20.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1358, '215165300-0200', 'HHBM16X2X300 GR 10.9', 'X', '73181500', 239.40, 10.00, 10.00, 123.290, 48.50, 116.11, 287.28, 9.00, 11.10, 9.00, 11.10, 18.00, 22.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1359, '215165310-0200', 'HHBM16X2X310 GR 10.9', 'X', '73181500', 287.35, 10.00, 10.00, 147.990, 48.50, 139.36, 344.82, 9.00, 13.32, 9.00, 13.32, 18.00, 26.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1360, '215165320-0200', 'HHBM16X2X320 GR 10.9', 'X', '73181500', 287.35, 10.00, 10.00, 147.990, 48.50, 139.36, 344.82, 9.00, 13.32, 9.00, 13.32, 18.00, 26.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1361, '215165350-0200', 'HHBM16X2X350 GR 10.9', 'X', '73181500', 330.50, 10.00, 10.00, 170.210, 48.50, 160.29, 396.60, 9.00, 15.32, 9.00, 15.32, 18.00, 30.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1362, '215165400-0200', 'HHBM16X2X400. GR 10.9', 'X', '73181500', 380.10, 10.00, 10.00, 195.750, 48.50, 184.35, 456.12, 9.00, 17.62, 9.00, 17.62, 18.00, 35.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1363, '215183055-0200', 'HHBM18X1.5X55 GR 10.9', 'X', '73181500', 66.15, 60.00, 20.00, 34.070, 48.50, 32.08, 79.38, 9.00, 3.07, 9.00, 3.07, 18.00, 6.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1364, '215183060-0200', 'HHBM18X1.5X60 GR 10.9', 'X', '73181500', 68.15, 60.00, 20.00, 35.100, 48.50, 33.05, 81.78, 9.00, 3.16, 9.00, 3.16, 18.00, 6.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1365, '215183065-0200', 'HHBM18X1.5X65 GR 10.9', 'X', '73181500', 70.55, 60.00, 20.00, 36.330, 48.50, 34.22, 84.66, 9.00, 3.27, 9.00, 3.27, 18.00, 6.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1366, '215183070-0200', 'HHBM18X1.5X70 GR 10.9', 'X', '73181500', 73.50, 80.00, 20.00, 37.850, 48.50, 35.65, 88.20, 9.00, 3.41, 9.00, 3.41, 18.00, 6.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1367, '215183075-0200', 'HHBM18X1.5X75 GR 10.9', 'X', '73181500', 77.90, 80.00, 20.00, 40.120, 48.50, 37.78, 93.48, 9.00, 3.61, 9.00, 3.61, 18.00, 7.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1368, '215183080-0200', 'HHBM18X1.5X80 GR 10.9', 'X', '73181500', 77.90, 40.00, 10.00, 40.120, 48.50, 37.78, 93.48, 9.00, 3.61, 9.00, 3.61, 18.00, 7.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(1369, '215183085-0200', 'HHBM18X1.5X85 GR 10.9', 'X', '73181500', 82.95, 30.00, 10.00, 42.720, 48.50, 40.23, 99.54, 9.00, 3.84, 9.00, 3.84, 18.00, 7.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1370, '215183090-0200', 'HHBM18X1.5X90 GR 10.9', 'X', '73181500', 82.95, 30.00, 10.00, 42.720, 48.50, 40.23, 99.54, 9.00, 3.84, 9.00, 3.84, 18.00, 7.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1371, '215183100-0200', 'HHBM18X1.5X100 GR 10.9', 'X', '73181500', 87.85, 30.00, 10.00, 45.240, 48.50, 42.61, 105.42, 9.00, 4.07, 9.00, 4.07, 18.00, 8.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1372, '215183110-0200', 'HHBM18X1.5X110 GR 10.9', 'X', '73181500', 96.70, 30.00, 10.00, 49.800, 48.50, 46.90, 116.04, 9.00, 4.48, 9.00, 4.48, 18.00, 8.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1373, '215183115-0200', 'HHBM18X1.5X115 GR 10.9', 'X', '73181500', 119.05, 30.00, 10.00, 61.310, 48.50, 57.74, 142.86, 9.00, 5.52, 9.00, 5.52, 18.00, 11.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1374, '215183120-0200', 'HHBM18X1.5X120 GR 10.9', 'X', '73181500', 104.20, 30.00, 10.00, 53.660, 48.50, 50.54, 125.04, 9.00, 4.83, 9.00, 4.83, 18.00, 9.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1375, '215183125-0200', 'HHBM18X1.5X125 GR 10.9', 'X', '73181500', 104.20, 30.00, 10.00, 53.660, 48.50, 50.54, 125.04, 9.00, 4.83, 9.00, 4.83, 18.00, 9.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1376, '215183160-0200', 'HHBM18X1.5X160 GR 10.9', 'X', '73181500', 131.95, 40.00, 10.00, 67.950, 48.50, 64.00, 158.34, 9.00, 6.12, 9.00, 6.12, 18.00, 12.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1377, '215183180-0200', 'HHBM18X1.5X180 GR 10.9', 'X', '73181500', 142.80, 0.00, 0.00, 73.540, 48.50, 69.26, 171.36, 9.00, 6.62, 9.00, 6.62, 18.00, 13.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1378, '215183200-0200', 'HHBM18X1.5X200 GR 10.9', 'X', '73181500', 153.80, 20.00, 10.00, 79.210, 48.50, 74.59, 184.56, 9.00, 7.13, 9.00, 7.13, 18.00, 14.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1379, '215183210-0200', 'HHBM18X1.5X210 GR 10.9', 'X', '73181500', 169.65, 20.00, 10.00, 87.370, 48.50, 82.28, 203.58, 9.00, 7.86, 9.00, 7.86, 18.00, 15.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1380, '215183220-0200', 'HHBM18X1.5X220 GR 10.9', 'X', '73181500', 185.10, 20.00, 10.00, 95.330, 48.50, 89.77, 222.12, 9.00, 8.58, 9.00, 8.58, 18.00, 17.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1381, '215183240-0200', 'HHBM18X1.5X240 GR 10.9', 'X', '73181500', 205.40, 40.00, 10.00, 105.780, 48.50, 99.62, 246.48, 9.00, 9.52, 9.00, 9.52, 18.00, 19.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1382, '215183250-0200', 'HHBM18X1.5X250 GR 10.9', 'X', '73181500', 214.10, 20.00, 10.00, 110.260, 48.50, 103.84, 256.92, 9.00, 9.92, 9.00, 9.92, 18.00, 19.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1383, '215183280-0200', 'HHBM18X1.5X280 GR 10.9', 'X', '73181500', 324.80, 10.00, 10.00, 167.270, 48.50, 157.53, 389.76, 9.00, 15.05, 9.00, 15.05, 18.00, 30.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1384, '215185085-0200', 'HHBM18X2X85 GR 10.9', 'X', '73181500', 72.95, 30.00, 10.00, 37.570, 48.50, 35.38, 87.54, 9.00, 3.38, 9.00, 3.38, 18.00, 6.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1385, '215187055-0200', 'HHBM18X2.5X55 GR 10.9', 'X', '73181500', 60.10, 60.00, 20.00, 30.950, 48.50, 29.15, 72.12, 9.00, 2.79, 9.00, 2.79, 18.00, 5.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1386, '215187060-0200', 'HHBM18X2.5X60 GR 10.9', 'X', '73181500', 62.05, 60.00, 20.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1387, '215187065-0200', 'HHBM18X2.5X65 GR 10.9', 'X', '73181500', 64.20, 60.00, 20.00, 33.060, 48.50, 31.14, 77.04, 9.00, 2.98, 9.00, 2.98, 18.00, 5.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1388, '215187070-0200', 'HHBM18X2.5X70 GR 10.9', 'X', '73181500', 66.85, 80.00, 20.00, 34.430, 48.50, 32.42, 80.22, 9.00, 3.10, 9.00, 3.10, 18.00, 6.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1389, '215187075-0200', 'HHBM18X2.5X75 GR 10.9', 'X', '73181500', 70.85, 80.00, 20.00, 36.490, 48.50, 34.36, 85.02, 9.00, 3.28, 9.00, 3.28, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1390, '215187080-0200', 'HHBM18X2.5X80 GR 10.9', 'X', '73181500', 70.85, 40.00, 10.00, 36.490, 48.50, 34.36, 85.02, 9.00, 3.28, 9.00, 3.28, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1391, '215187085-0200', 'HHBM18X2.5X85 GR 10.9', 'X', '73181500', 72.95, 30.00, 10.00, 37.570, 48.50, 35.38, 87.54, 9.00, 3.38, 9.00, 3.38, 18.00, 6.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1392, '215187090-0200', 'HHBM18X2.5X90 GR 10.9', 'X', '73181500', 75.30, 30.00, 10.00, 38.780, 48.50, 36.52, 90.36, 9.00, 3.49, 9.00, 3.49, 18.00, 6.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1393, '215187095-0200', 'HHBM18X2.5X95 GR 10.9', 'X', '73181500', 77.35, 30.00, 10.00, 39.840, 48.50, 37.51, 92.82, 9.00, 3.59, 9.00, 3.59, 18.00, 7.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1394, '215187100-0200', 'HHBM18X2.5X100 GR 10.9', 'X', '73181500', 79.90, 30.00, 10.00, 41.150, 48.50, 38.75, 95.88, 9.00, 3.70, 9.00, 3.70, 18.00, 7.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1395, '215187110-0200', 'HHBM18X2.5X110 GR 10.9', 'X', '73181500', 87.85, 30.00, 10.00, 45.240, 48.50, 42.61, 105.42, 9.00, 4.07, 9.00, 4.07, 18.00, 8.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1396, '215187120-0200', 'HHBM18X2.5X120 GR 10.9', 'X', '73181500', 92.60, 30.00, 10.00, 47.690, 48.50, 44.91, 111.12, 9.00, 4.29, 9.00, 4.29, 18.00, 8.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1397, '215187125-0200', 'HHBM18X2.5X125 GR 10.9', 'X', '73181500', 94.65, 30.00, 10.00, 48.740, 48.50, 45.91, 113.58, 9.00, 4.39, 9.00, 4.39, 18.00, 8.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1398, '215187130-0200', 'HHBM18X2.5X130 GR 10.9', 'X', '73181500', 96.80, 30.00, 10.00, 49.850, 48.50, 46.95, 116.16, 9.00, 4.49, 9.00, 4.49, 18.00, 8.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1399, '215187135-0200', 'HHBM18X2.5X135 GR 10.9', 'X', '73181500', 112.95, 10.00, 10.00, 58.170, 48.50, 54.78, 135.54, 9.00, 5.24, 9.00, 5.24, 18.00, 10.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1400, '215187140-0200', 'HHBM18X2.5X140 GR 10.9', 'X', '73181500', 101.10, 30.00, 10.00, 52.070, 48.50, 49.03, 121.32, 9.00, 4.69, 9.00, 4.69, 18.00, 9.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1401, '215187150-0200', 'HHBM18X2.5X150 GR 10.9', 'X', '73181500', 108.15, 40.00, 10.00, 55.700, 48.50, 52.45, 129.78, 9.00, 5.01, 9.00, 5.01, 18.00, 10.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1402, '215187160-0200', 'HHBM18X2.5X160 GR 10.9', 'X', '73181500', 119.95, 40.00, 10.00, 61.770, 48.50, 58.18, 143.94, 9.00, 5.56, 9.00, 5.56, 18.00, 11.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1403, '215187170-0200', 'HHBM18X2.5X170 GR 10.9', 'X', '73181500', 124.55, 20.00, 10.00, 64.140, 48.50, 60.41, 149.46, 9.00, 5.77, 9.00, 5.77, 18.00, 11.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1404, '215187175-0200', 'HHBM18X2.5X175 GR 10.9', 'X', '73181500', 127.80, 40.00, 10.00, 65.820, 48.50, 61.98, 153.36, 9.00, 5.92, 9.00, 5.92, 18.00, 11.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1405, '215187180-0200', 'HHBM18X2.5X180 GR 10.9', 'X', '73181500', 129.85, 40.00, 10.00, 66.870, 48.50, 62.98, 155.82, 9.00, 6.02, 9.00, 6.02, 18.00, 12.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1406, '215187190-0200', 'HHBM18X2.5X190 GR 10.9', 'X', '73181500', 134.75, 20.00, 10.00, 69.400, 48.50, 65.35, 161.70, 9.00, 6.25, 9.00, 6.25, 18.00, 12.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1407, '215187200-0200', 'HHBM18X2.5X200 GR 10.9', 'X', '73181500', 139.75, 40.00, 10.00, 71.970, 48.50, 67.78, 167.70, 9.00, 6.48, 9.00, 6.48, 18.00, 12.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1408, '215187220-0200', 'HHBM18X2.5X220 GR 10.9', 'X', '73181500', 168.25, 20.00, 10.00, 86.650, 48.50, 81.60, 201.90, 9.00, 7.80, 9.00, 7.80, 18.00, 15.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1409, '215187240-0200', 'HHBM18X2.5X240 GR 10.9', 'X', '73181500', 186.70, 10.00, 10.00, 96.150, 48.50, 90.55, 224.04, 9.00, 8.65, 9.00, 8.65, 18.00, 17.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1410, '215187250-0200', 'HHBM18X2.5X250 GR 10.9', 'X', '73181500', 194.70, 20.00, 10.00, 100.270, 48.50, 94.43, 233.64, 9.00, 9.02, 9.00, 9.02, 18.00, 18.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1411, '215187260-0200', 'HHBM18X2.5X260 GR 10.9', 'X', '73181500', 254.05, 10.00, 10.00, 130.840, 48.50, 123.21, 304.86, 9.00, 11.78, 9.00, 11.78, 18.00, 23.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1412, '215187280-0200', 'HHBM18X2.5X280 GR 10.9', 'X', '73181500', 295.20, 10.00, 10.00, 152.030, 48.50, 143.17, 354.24, 9.00, 13.68, 9.00, 13.68, 18.00, 27.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1413, '215203060-0200', 'HHBM20X1.5X60 GR 10.9', 'X', '73181500', 73.50, 80.00, 20.00, 37.850, 48.50, 35.65, 88.20, 9.00, 3.41, 9.00, 3.41, 18.00, 6.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1414, '215203065-0200', 'HHBM20X1.5X65 GR 10.9', 'X', '73181500', 78.75, 80.00, 20.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1415, '215203070-0200', 'HHBM20X1.5X70 GR 10.9', 'X', '73181500', 78.75, 30.00, 10.00, 40.560, 48.50, 38.19, 94.50, 9.00, 3.65, 9.00, 3.65, 18.00, 7.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1416, '215203075-0200', 'HHBM20X1.5X75 GR 10.9', 'X', '73181500', 81.90, 30.00, 10.00, 42.180, 48.50, 39.72, 98.28, 9.00, 3.80, 9.00, 3.80, 18.00, 7.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1417, '215203080-0200', 'HHBM20X1.5X80 GR 10.9', 'X', '73181500', 84.30, 30.00, 10.00, 43.410, 48.50, 40.89, 101.16, 9.00, 3.91, 9.00, 3.91, 18.00, 7.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1418, '215203090-0200', 'HHBM20X1.5X90 GR 10.9', 'X', '73181500', 89.70, 30.00, 10.00, 46.200, 48.50, 43.50, 107.64, 9.00, 4.16, 9.00, 4.16, 18.00, 8.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1419, '215203100-0200', 'HHBM20X1.5X100 GR 10.9', 'X', '73181500', 94.75, 30.00, 10.00, 48.800, 48.50, 45.95, 113.70, 9.00, 4.39, 9.00, 4.39, 18.00, 8.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1420, '215203110-0200', 'HHBM20X1.5X110 GR 10.9', 'X', '73181500', 100.15, 30.00, 10.00, 51.580, 48.50, 48.57, 120.18, 9.00, 4.64, 9.00, 4.64, 18.00, 9.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1421, '215203120-0200', 'HHBM20X1.5X120 GR 10.9', 'X', '73181500', 108.50, 30.00, 10.00, 55.880, 48.50, 52.62, 130.20, 9.00, 5.03, 9.00, 5.03, 18.00, 10.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1422, '215203130-0200', 'HHBM20X1.5X130 GR 10.9', 'X', '73181500', 116.05, 30.00, 10.00, 59.770, 48.50, 56.28, 139.26, 9.00, 5.38, 9.00, 5.38, 18.00, 10.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1423, '215203140-0200', 'HHBM20X1.5X140 GR 10.9', 'X', '73181500', 120.55, 40.00, 10.00, 62.080, 48.50, 58.47, 144.66, 9.00, 5.59, 9.00, 5.59, 18.00, 11.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1424, '215203150-0200', 'HHBM20X1.5X150 GR 10.9', 'X', '73181500', 127.20, 40.00, 10.00, 65.510, 48.50, 61.69, 152.64, 9.00, 5.90, 9.00, 5.90, 18.00, 11.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1425, '215207060-0200', 'HHBM20X2.5X60 GR 10.9', 'X', '73181500', 66.85, 80.00, 20.00, 34.430, 48.50, 32.42, 80.22, 9.00, 3.10, 9.00, 3.10, 18.00, 6.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1426, '215207065-0200', 'HHBM20X2.5X65 GR 10.9', 'X', '73181500', 69.00, 80.00, 20.00, 35.540, 48.50, 33.47, 82.80, 9.00, 3.20, 9.00, 3.20, 18.00, 6.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1427, '215207070-0200', 'HHBM20X2.5X70 GR 10.9', 'X', '73181500', 71.60, 30.00, 10.00, 36.870, 48.50, 34.73, 85.92, 9.00, 3.32, 9.00, 3.32, 18.00, 6.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1428, '215207075-0200', 'HHBM20X2.5X75 GR 10.9', 'X', '73181500', 74.50, 30.00, 10.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1429, '215207080-0200', 'HHBM20X2.5X80 GR 10.9', 'X', '73181500', 76.65, 30.00, 10.00, 39.470, 48.50, 37.18, 91.98, 9.00, 3.55, 9.00, 3.55, 18.00, 7.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1430, '215207085-0200', 'HHBM20X2.5X85 GR 10.9', 'X', '73181500', 78.95, 30.00, 10.00, 40.660, 48.50, 38.29, 94.74, 9.00, 3.66, 9.00, 3.66, 18.00, 7.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1431, '215207090-0200', 'HHBM20X2.5X90 GR 10.9', 'X', '73181500', 81.50, 30.00, 10.00, 41.970, 48.50, 39.53, 97.80, 9.00, 3.78, 9.00, 3.78, 18.00, 7.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1432, '215207095-0200', 'HHBM20X2.5X95 GR 10.9', 'X', '73181500', 84.30, 30.00, 10.00, 43.410, 48.50, 40.89, 101.16, 9.00, 3.91, 9.00, 3.91, 18.00, 7.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1433, '215207100-0200', 'HHBM20X2.5X100 GR 10.9', 'X', '73181500', 86.25, 30.00, 10.00, 44.420, 48.50, 41.83, 103.50, 9.00, 4.00, 9.00, 4.00, 18.00, 8.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1434, '215207105-0200', 'HHBM20X2.5X105 GR 10.9', 'X', '73181500', 90.20, 30.00, 10.00, 46.450, 48.50, 43.75, 108.24, 9.00, 4.18, 9.00, 4.18, 18.00, 8.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1435, '215207110-0200', 'HHBM20X2.5X110 GR 10.9', 'X', '73181500', 91.05, 30.00, 10.00, 46.890, 48.50, 44.16, 109.26, 9.00, 4.22, 9.00, 4.22, 18.00, 8.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1436, '215207115-0200', 'HHBM20X2.5X115 GR 10.9', 'X', '73181500', 105.10, 30.00, 10.00, 54.130, 48.50, 50.97, 126.12, 9.00, 4.87, 9.00, 4.87, 18.00, 9.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1437, '215207120-0200', 'HHBM20X2.5X120 GR 10.9', 'X', '73181500', 98.60, 30.00, 10.00, 50.780, 48.50, 47.82, 118.32, 9.00, 4.57, 9.00, 4.57, 18.00, 9.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1438, '215207125-0200', 'HHBM20X2.5X125 GR 10.9', 'X', '73181500', 102.40, 30.00, 10.00, 52.740, 48.50, 49.66, 122.88, 9.00, 4.75, 9.00, 4.75, 18.00, 9.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1439, '215207130-0200', 'HHBM20X2.5X130 GR 10.9', 'X', '73181500', 105.35, 30.00, 10.00, 54.260, 48.50, 51.09, 126.42, 9.00, 4.88, 9.00, 4.88, 18.00, 9.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1440, '215207135-0200', 'HHBM20X2.5X135 GR 10.9', 'X', '73181500', 123.20, 40.00, 10.00, 63.450, 48.50, 59.75, 147.84, 9.00, 5.71, 9.00, 5.71, 18.00, 11.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1441, '215207140-0200', 'HHBM20X2.5X140 GR 10.9', 'X', '73181500', 109.60, 40.00, 10.00, 56.440, 48.50, 53.16, 131.52, 9.00, 5.08, 9.00, 5.08, 18.00, 10.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1442, '215207150-0200', 'HHBM20X2.5X150 GR 10.9', 'X', '73181500', 115.65, 40.00, 10.00, 59.560, 48.50, 56.09, 138.78, 9.00, 5.36, 9.00, 5.36, 18.00, 10.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1443, '215207160-0200', 'HHBM20X2.5X160 GR 10.9', 'X', '73181500', 131.45, 40.00, 10.00, 67.700, 48.50, 63.75, 157.74, 9.00, 6.09, 9.00, 6.09, 18.00, 12.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1444, '215207170-0200', 'HHBM20X2.5X170 GR 10.9', 'X', '73181500', 136.90, 40.00, 10.00, 70.500, 48.50, 66.40, 164.28, 9.00, 6.35, 9.00, 6.35, 18.00, 12.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1445, '215207175-0200', 'HHBM20X2.5X175 GR 10.9', 'X', '73181500', 139.60, 40.00, 10.00, 71.890, 48.50, 67.71, 167.52, 9.00, 6.47, 9.00, 6.47, 18.00, 12.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1446, '215207180-0200', 'HHBM20X2.5X180 GR 10.9', 'X', '73181500', 142.95, 40.00, 10.00, 73.620, 48.50, 69.33, 171.54, 9.00, 6.63, 9.00, 6.63, 18.00, 13.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1447, '215207190-0200', 'HHBM20X2.5X190 GR 10.9', 'X', '73181500', 147.95, 40.00, 10.00, 76.190, 48.50, 71.76, 177.54, 9.00, 6.86, 9.00, 6.86, 18.00, 13.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1448, '215207200-0200', 'HHBM20X2.5X200 GR 10.9', 'X', '73181500', 153.90, 40.00, 10.00, 79.260, 48.50, 74.64, 184.68, 9.00, 7.13, 9.00, 7.13, 18.00, 14.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1449, '215207210-0200', 'HHBM20X2.5X210 GR 10.9', 'X', '73181500', 333.45, 10.00, 10.00, 171.730, 48.50, 161.72, 400.14, 9.00, 15.46, 9.00, 15.46, 18.00, 30.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1450, '215207220-0200', 'HHBM20X2.5X220 GR 10.9', 'X', '73181500', 333.45, 10.00, 10.00, 171.730, 48.50, 161.72, 400.14, 9.00, 15.46, 9.00, 15.46, 18.00, 30.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1451, '215207230-0200', 'HHBM20X2.5X230 GR 10.9', 'X', '73181500', 303.15, 10.00, 10.00, 156.120, 48.50, 147.03, 363.78, 9.00, 14.05, 9.00, 14.05, 18.00, 28.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1452, '215207240-0200', 'HHBM20X2.5X240 GR 10.9', 'X', '73181500', 303.15, 10.00, 10.00, 156.120, 48.50, 147.03, 363.78, 9.00, 14.05, 9.00, 14.05, 18.00, 28.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1453, '215207250-0200', 'HHBM20X2.5X250 GR 10.9', 'X', '73181500', 317.85, 10.00, 10.00, 163.690, 48.50, 154.16, 381.42, 9.00, 14.73, 9.00, 14.73, 18.00, 29.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1454, '215207260-0200', 'HHBM20X2.5X260 GR 10.9', 'X', '73181500', 317.85, 10.00, 10.00, 163.690, 48.50, 154.16, 381.42, 9.00, 14.73, 9.00, 14.73, 18.00, 29.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1455, '215207280-0200', 'HHBM20X2.5X280 GR 10.9', 'X', '73181500', 346.65, 10.00, 10.00, 178.520, 48.50, 168.13, 415.98, 9.00, 16.07, 9.00, 16.07, 18.00, 32.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1456, '215207300-0200', 'HHBM20X2.5X300 GR 10.9', 'X', '73181500', 377.75, 10.00, 10.00, 194.540, 48.50, 183.21, 453.30, 9.00, 17.51, 9.00, 17.51, 18.00, 35.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1457, '215223120-0200', 'HHBM22X1.5X120 GR 10.9', 'X', '73181500', 141.75, 10.00, 5.00, 73.000, 48.50, 68.75, 170.10, 9.00, 6.57, 9.00, 6.57, 18.00, 13.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1458, '215223290-0200', 'HHBM22X1.5X290 GR 10.9', 'X', '73181500', 548.85, 5.00, 5.00, 282.660, 48.50, 266.19, 658.62, 9.00, 25.44, 9.00, 25.44, 18.00, 50.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1459, '215227060-0200', 'HHBM22X2.5X60 GR 10.9', 'X', '73181500', 86.10, 30.00, 10.00, 44.340, 48.50, 41.76, 103.32, 9.00, 3.99, 9.00, 3.99, 18.00, 7.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1460, '215227065-0200', 'HHBM22X2.5X65 GR 10.9', 'X', '73181500', 96.70, 30.00, 10.00, 49.800, 48.50, 46.90, 116.04, 9.00, 4.48, 9.00, 4.48, 18.00, 8.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1461, '215227070-0200', 'HHBM22X2.5X70 GR 10.9', 'X', '73181500', 99.95, 30.00, 10.00, 51.470, 48.50, 48.48, 119.94, 9.00, 4.63, 9.00, 4.63, 18.00, 9.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1462, '215227075-0200', 'HHBM22X2.5X75 GR 10.9', 'X', '73181500', 103.35, 30.00, 10.00, 53.230, 48.50, 50.12, 124.02, 9.00, 4.79, 9.00, 4.79, 18.00, 9.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1463, '215227080-0200', 'HHBM22X2.5X80 GR 10.9', 'X', '73181500', 107.40, 40.00, 10.00, 55.310, 48.50, 52.09, 128.88, 9.00, 4.98, 9.00, 4.98, 18.00, 9.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1464, '215227085-0200', 'HHBM22X2.5X85 GR 10.9', 'X', '73181500', 110.85, 40.00, 10.00, 57.090, 48.50, 53.76, 133.02, 9.00, 5.14, 9.00, 5.14, 18.00, 10.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1465, '215227090-0200', 'HHBM22X2.5X90 GR 10.9', 'X', '73181500', 114.40, 40.00, 10.00, 58.920, 48.50, 55.48, 137.28, 9.00, 5.30, 9.00, 5.30, 18.00, 10.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1466, '215227100-0200', 'HHBM22X2.5X100 GR 10.9', 'X', '73181500', 116.15, 40.00, 10.00, 59.820, 48.50, 56.33, 139.38, 9.00, 5.38, 9.00, 5.38, 18.00, 10.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1467, '215227105-0200', 'HHBM22X2.5X105 GR 10.9', 'X', '73181500', 130.45, 15.00, 5.00, 67.180, 48.50, 63.27, 156.54, 9.00, 6.05, 9.00, 6.05, 18.00, 12.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1468, '215227110-0200', 'HHBM22X2.5X110 GR 10.9', 'X', '73181500', 132.80, 15.00, 5.00, 68.390, 48.50, 64.41, 159.36, 9.00, 6.16, 9.00, 6.16, 18.00, 12.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1469, '215227115-0200', 'HHBM22X2.5X115 GR 10.9', 'X', '73181500', 157.80, 15.00, 5.00, 81.270, 48.50, 76.53, 189.36, 9.00, 7.31, 9.00, 7.31, 18.00, 14.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1470, '215227120-0200', 'HHBM22X2.5X120 GR 10.9', 'X', '73181500', 141.75, 15.00, 5.00, 73.000, 48.50, 68.75, 170.10, 9.00, 6.57, 9.00, 6.57, 18.00, 13.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1471, '215227125-0200', 'HHBM22X2.5X125 GR 10.9', 'X', '73181500', 146.10, 15.00, 5.00, 75.240, 48.50, 70.86, 175.32, 9.00, 6.77, 9.00, 6.77, 18.00, 13.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1472, '215227130-0200', 'HHBM22X2.5X130 GR 10.9', 'X', '73181500', 149.55, 15.00, 5.00, 77.020, 48.50, 72.53, 179.46, 9.00, 6.93, 9.00, 6.93, 18.00, 13.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1473, '215227135-0200', 'HHBM22X2.5X135 GR 10.9', 'X', '73181500', 175.10, 20.00, 5.00, 90.180, 48.50, 84.92, 210.12, 9.00, 8.12, 9.00, 8.12, 18.00, 16.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1474, '215227140-0200', 'HHBM22X2.5X140 GR 10.9', 'X', '73181500', 156.90, 15.00, 5.00, 80.800, 48.50, 76.10, 188.28, 9.00, 7.27, 9.00, 7.27, 18.00, 14.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1475, '215227150-0200', 'HHBM22X2.5X150 GR 10.9', 'X', '73181500', 164.40, 15.00, 5.00, 84.670, 48.50, 79.73, 197.28, 9.00, 7.62, 9.00, 7.62, 18.00, 15.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1476, '215227160-0200', 'HHBM22X2.5X160 GR 10.9', 'X', '73181500', 178.85, 20.00, 5.00, 92.110, 48.50, 86.74, 214.62, 9.00, 8.29, 9.00, 8.29, 18.00, 16.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1477, '215227170-0200', 'HHBM22X2.5X170 GR 10.9', 'X', '73181500', 186.30, 20.00, 5.00, 95.940, 48.50, 90.36, 223.56, 9.00, 8.64, 9.00, 8.64, 18.00, 17.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1478, '215227175-0200', 'HHBM22X2.5X175 GR 10.9', 'X', '73181500', 190.70, 20.00, 5.00, 98.210, 48.50, 92.49, 228.84, 9.00, 8.84, 9.00, 8.84, 18.00, 17.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1479, '215227180-0200', 'HHBM22X2.5X180 GR 10.9', 'X', '73181500', 194.20, 20.00, 5.00, 100.010, 48.50, 94.19, 233.04, 9.00, 9.00, 9.00, 9.00, 18.00, 18.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1480, '215227190-0200', 'HHBM22X2.5X190 GR 10.9', 'X', '73181500', 202.20, 20.00, 5.00, 104.130, 48.50, 98.07, 242.64, 9.00, 9.37, 9.00, 9.37, 18.00, 18.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1481, '215227200-0200', 'HHBM22X2.5X200 GR 10.9', 'X', '73181500', 199.75, 20.00, 5.00, 102.870, 48.50, 96.88, 239.70, 9.00, 9.26, 9.00, 9.26, 18.00, 18.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1482, '215227220-0200', 'HHBM22X2.5X220 GR 10.9', 'X', '73181500', 395.60, 20.00, 5.00, 203.730, 48.50, 191.87, 474.72, 9.00, 18.34, 9.00, 18.34, 18.00, 36.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1483, '215227240-0200', 'HHBM22X2.5X240 GR 10.9', 'X', '73181500', 428.55, 40.00, 5.00, 220.700, 48.50, 207.85, 514.26, 9.00, 19.86, 9.00, 19.86, 18.00, 39.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1484, '215227250-0200', 'HHBM22X2.5X250 GR 10.9', 'X', '73181500', 444.85, 40.00, 5.00, 229.100, 48.50, 215.75, 533.82, 9.00, 20.62, 9.00, 20.62, 18.00, 41.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1485, '215227260-0200', 'HHBM22X2.5X260 GR 10.9', 'X', '73181500', 444.85, 40.00, 5.00, 229.100, 48.50, 215.75, 533.82, 9.00, 20.62, 9.00, 20.62, 18.00, 41.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1486, '215227270-0200', 'HHBM22X2.5X270 GR 10.9', 'X', '73181500', 494.45, 40.00, 5.00, 254.640, 48.50, 239.81, 593.34, 9.00, 22.92, 9.00, 22.92, 18.00, 45.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1487, '215227280-0200', 'HHBM22X2.5X280 GR 10.9', 'X', '73181500', 494.45, 40.00, 5.00, 254.640, 48.50, 239.81, 593.34, 9.00, 22.92, 9.00, 22.92, 18.00, 45.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1488, '215227290-0200', 'HHBM22X2.5X290 GR 10.9', 'X', '73181500', 548.85, 40.00, 5.00, 282.660, 48.50, 266.19, 658.62, 9.00, 25.44, 9.00, 25.44, 18.00, 50.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1489, '215227300-0200', 'HHBM22X2.5X300 GR 10.9', 'X', '73181500', 548.85, 5.00, 5.00, 282.660, 48.50, 266.19, 658.62, 9.00, 25.44, 9.00, 25.44, 18.00, 50.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1490, '215243100-0200', 'HHBM24X1.5X100 GR 10.9', 'X', '73181500', 145.90, 20.00, 10.00, 75.140, 48.50, 70.76, 175.08, 9.00, 6.76, 9.00, 6.76, 18.00, 13.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1491, '215249050-0200', 'HHBM24X3X50 GR 10.9', 'X', '73181500', 97.25, 30.00, 10.00, 50.080, 48.50, 47.17, 116.70, 9.00, 4.51, 9.00, 4.51, 18.00, 9.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1492, '215249065-0200', 'HHBM24X3X65 GR 10.9', 'X', '73181500', 104.75, 30.00, 10.00, 53.950, 48.50, 50.80, 125.70, 9.00, 4.86, 9.00, 4.86, 18.00, 9.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1493, '215249070-0200', 'HHBM24X3X70 GR 10.9', 'X', '73181500', 110.95, 40.00, 10.00, 57.140, 48.50, 53.81, 133.14, 9.00, 5.14, 9.00, 5.14, 18.00, 10.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1494, '215249075-0200', 'HHBM24X3X75 GR 10.9', 'X', '73181500', 115.05, 40.00, 10.00, 59.250, 48.50, 55.80, 138.06, 9.00, 5.33, 9.00, 5.33, 18.00, 10.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1495, '215249080-0200', 'HHBM24X3X80 GR 10.9', 'X', '73181500', 126.40, 40.00, 10.00, 65.100, 48.50, 61.30, 151.68, 9.00, 5.86, 9.00, 5.86, 18.00, 11.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1496, '215249085-0200', 'HHBM24X3X85 GR 10.9', 'X', '73181500', 130.55, 40.00, 10.00, 67.230, 48.50, 63.32, 156.66, 9.00, 6.05, 9.00, 6.05, 18.00, 12.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1497, '215249090-0200', 'HHBM24X3X90 GR 10.9', 'X', '73181500', 134.95, 40.00, 10.00, 69.500, 48.50, 65.45, 161.94, 9.00, 6.25, 9.00, 6.25, 18.00, 12.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1498, '215249095-0200', 'HHBM24X3X95 GR 10.9', 'X', '73181500', 138.75, 40.00, 10.00, 71.460, 48.50, 67.29, 166.50, 9.00, 6.43, 9.00, 6.43, 18.00, 12.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1499, '215249100-0200', 'HHBM24X3X100 GR 10.9', 'X', '73181500', 145.90, 40.00, 10.00, 75.140, 48.50, 70.76, 175.08, 9.00, 6.76, 9.00, 6.76, 18.00, 13.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1500, '215249105-0200', 'HHBM24X3X105 GR 10.9', 'X', '73181500', 147.30, 15.00, 5.00, 75.860, 48.50, 71.44, 176.76, 9.00, 6.83, 9.00, 6.83, 18.00, 13.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1501, '215249110-0200', 'HHBM24X3X110 GR 10.9', 'X', '73181500', 151.65, 15.00, 5.00, 78.100, 48.50, 73.55, 181.98, 9.00, 7.03, 9.00, 7.03, 18.00, 14.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1502, '215249115-0200', 'HHBM24X3X115 GR 10.9', 'X', '73181500', 178.10, 15.00, 5.00, 91.720, 48.50, 86.38, 213.72, 9.00, 8.25, 9.00, 8.25, 18.00, 16.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1503, '215249120-0200', 'HHBM24X3X120 GR 10.9', 'X', '73181500', 160.15, 15.00, 5.00, 82.480, 48.50, 77.67, 192.18, 9.00, 7.42, 9.00, 7.42, 18.00, 14.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1504, '215249125-0200', 'HHBM24X3X125 GR 10.9', 'X', '73181500', 163.95, 15.00, 5.00, 84.430, 48.50, 79.52, 196.74, 9.00, 7.60, 9.00, 7.60, 18.00, 15.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1505, '215249130-0200', 'HHBM24X3X130 GR 10.9', 'X', '73181500', 167.75, 15.00, 5.00, 86.390, 48.50, 81.36, 201.30, 9.00, 7.78, 9.00, 7.78, 18.00, 15.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1506, '215249135-0200', 'HHBM24X3X135 GR 10.9', 'X', '73181500', 196.60, 20.00, 5.00, 101.250, 48.50, 95.35, 235.92, 9.00, 9.11, 9.00, 9.11, 18.00, 18.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1507, '215249140-0200', 'HHBM24X3X140 GR 10.9', 'X', '73181500', 175.75, 20.00, 5.00, 90.510, 48.50, 85.24, 210.90, 9.00, 8.15, 9.00, 8.15, 18.00, 16.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1508, '215249145-0200', 'HHBM24X3X145 GR 10.9', 'X', '73181500', 180.55, 20.00, 5.00, 92.980, 48.50, 87.57, 216.66, 9.00, 8.37, 9.00, 8.37, 18.00, 16.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1509, '215249150-0200', 'HHBM24X3X150 GR 10.9', 'X', '73181500', 184.35, 20.00, 5.00, 94.940, 48.50, 89.41, 221.22, 9.00, 8.54, 9.00, 8.54, 18.00, 17.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1510, '215249160-0200', 'HHBM24X3X160 GR 10.9', 'X', '73181500', 200.50, 20.00, 5.00, 103.260, 48.50, 97.24, 240.60, 9.00, 9.29, 9.00, 9.29, 18.00, 18.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1511, '215249165-0200', 'HHBM24X3X165 GR 10.9', 'X', '73181500', 204.95, 10.00, 5.00, 105.550, 48.50, 99.40, 245.94, 9.00, 9.50, 9.00, 9.50, 18.00, 19.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1512, '215249170-0200', 'HHBM24X3X170 GR 10.9', 'X', '73181500', 209.35, 20.00, 5.00, 107.820, 48.50, 101.53, 251.22, 9.00, 9.70, 9.00, 9.70, 18.00, 19.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1513, '215249175-0200', 'HHBM24X3X175 GR 10.9', 'X', '73181500', 213.35, 20.00, 5.00, 109.880, 48.50, 103.47, 256.02, 9.00, 9.89, 9.00, 9.89, 18.00, 19.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1514, '215249180-0200', 'HHBM24X3X180 GR 10.9', 'X', '73181500', 217.85, 20.00, 5.00, 112.190, 48.50, 105.66, 261.42, 9.00, 10.10, 9.00, 10.10, 18.00, 20.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1515, '215249190-0200', 'HHBM24X3X190 GR 10.9', 'X', '73181500', 226.20, 20.00, 5.00, 116.490, 48.50, 109.71, 271.44, 9.00, 10.48, 9.00, 10.48, 18.00, 20.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1516, '215249200-0200', 'HHBM24X3X200 GR 10.9', 'X', '73181500', 235.00, 20.00, 5.00, 121.030, 48.50, 113.98, 282.00, 9.00, 10.89, 9.00, 10.89, 18.00, 21.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1517, '215249210-0200', 'HHBM24X3X210 GR 10.9', 'X', '73181500', 455.25, 10.00, 5.00, 234.450, 48.50, 220.80, 546.30, 9.00, 21.10, 9.00, 21.10, 18.00, 42.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1518, '215249220-0200', 'HHBM24X3X220 GR 10.9', 'X', '73181500', 455.25, 20.00, 5.00, 234.450, 48.50, 220.80, 546.30, 9.00, 21.10, 9.00, 21.10, 18.00, 42.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1519, '215249230-0200', 'HHBM24X3X230 GR 10.9', 'X', '73181500', 471.60, 20.00, 5.00, 242.870, 48.50, 228.73, 565.92, 9.00, 21.86, 9.00, 21.86, 18.00, 43.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1520, '215249240-0200', 'HHBM24X3X240 GR 10.9', 'X', '73181500', 471.60, 20.00, 5.00, 242.870, 48.50, 228.73, 565.92, 9.00, 21.86, 9.00, 21.86, 18.00, 43.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1521, '215249250-0200', 'HHBM24X3X250 GR 10.9', 'X', '73181500', 487.90, 10.00, 5.00, 251.270, 48.50, 236.63, 585.48, 9.00, 22.61, 9.00, 22.61, 18.00, 45.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1522, '215249260-0200', 'HHBM24X3X260 GR 10.9', 'X', '73181500', 487.90, 5.00, 5.00, 251.270, 48.50, 236.63, 585.48, 9.00, 22.61, 9.00, 22.61, 18.00, 45.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1523, '215249280-0200', 'HHBM24X3X280 GR 10.9', 'X', '73181500', 536.50, 5.00, 5.00, 276.300, 48.50, 260.20, 643.80, 9.00, 24.87, 9.00, 24.87, 18.00, 49.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1524, '215249300-0200', 'HHBM24X3X300 GR 10.9', 'X', '73181500', 840.85, 5.00, 5.00, 433.040, 48.50, 407.81, 1009.02, 9.00, 38.97, 9.00, 38.97, 18.00, 77.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1525, '215249330-0200', 'HHBM24X3X330 GR 10.9', 'X', '73181500', 955.10, 5.00, 5.00, 491.880, 48.50, 463.22, 1146.12, 9.00, 44.27, 9.00, 44.27, 18.00, 88.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1526, '215249340-0200', 'HHBM24X3X340 GR 10.9', 'X', '73181500', 924.85, 5.00, 5.00, 476.300, 48.50, 448.55, 1109.82, 9.00, 42.87, 9.00, 42.87, 18.00, 85.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1527, '215249400-0200', 'HHBM24X3X400 GR 10.9', 'X', '73181500', 1019.50, 0.00, 0.00, 525.040, 48.50, 494.46, 1223.40, 9.00, 47.25, 9.00, 47.25, 18.00, 94.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1528, '215279065-0200', 'HHBM27X3X65 GR 10.9', 'X', '73181500', 222.45, 5.00, 5.00, 114.560, 48.50, 107.89, 266.94, 9.00, 10.31, 9.00, 10.31, 18.00, 20.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1529, '215279070-0200', 'HHBM27X3X70 GR 10.9', 'X', '73181500', 222.45, 5.00, 5.00, 114.560, 48.50, 107.89, 266.94, 9.00, 10.31, 9.00, 10.31, 18.00, 20.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1530, '215279075-0200', 'HHBM27X3X75 GR 10.9', 'X', '73181500', 239.40, 15.00, 5.00, 123.290, 48.50, 116.11, 287.28, 9.00, 11.10, 9.00, 11.10, 18.00, 22.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1531, '215279080-0200', 'HHBM27X3X80 GR 10.9', 'X', '73181500', 250.00, 15.00, 5.00, 128.750, 48.50, 121.25, 300.00, 9.00, 11.59, 9.00, 11.59, 18.00, 23.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1532, '215279090-0200', 'HHBM27X3X90 GR 10.9', 'X', '73181500', 273.25, 15.00, 5.00, 140.720, 48.50, 132.53, 327.90, 9.00, 12.67, 9.00, 12.67, 18.00, 25.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1533, '215279100-0200', 'HHBM27X3X100 GR 10.9', 'X', '73181500', 296.55, 15.00, 5.00, 152.720, 48.50, 143.83, 355.86, 9.00, 13.75, 9.00, 13.75, 18.00, 27.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1534, '215279110-0200', 'HHBM27X3X110 GR 10.9', 'X', '73181500', 319.90, 20.00, 5.00, 164.750, 48.50, 155.15, 383.88, 9.00, 14.83, 9.00, 14.83, 18.00, 29.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1535, '215279120-0200', 'HHBM27X3X120 GR 10.9', 'X', '73181500', 326.20, 20.00, 5.00, 167.990, 48.50, 158.21, 391.44, 9.00, 15.12, 9.00, 15.12, 18.00, 30.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1536, '215279125-0200', 'HHBM27X3X125 GR 10.9', 'X', '73181500', 336.80, 20.00, 5.00, 173.450, 48.50, 163.35, 404.16, 9.00, 15.61, 9.00, 15.61, 18.00, 31.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1537, '215279130-0200', 'HHBM27X3X130 GR 10.9', 'X', '73181500', 336.80, 10.00, 5.00, 173.450, 48.50, 163.35, 404.16, 9.00, 15.61, 9.00, 15.61, 18.00, 31.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1538, '215279140-0200', 'HHBM27X3X140 GR 10.9', 'X', '73181500', 360.05, 10.00, 5.00, 185.430, 48.50, 174.62, 432.06, 9.00, 16.69, 9.00, 16.69, 18.00, 33.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1539, '215279150-0200', 'HHBM27X3X150 GR 10.9', 'X', '73181500', 381.30, 10.00, 10.00, 196.370, 48.50, 184.93, 457.56, 9.00, 17.67, 9.00, 17.67, 18.00, 35.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1540, '215279160-0200', 'HHBM27X3X160 GR 10.9', 'X', '73181500', 402.40, 10.00, 5.00, 207.240, 48.50, 195.16, 482.88, 9.00, 18.65, 9.00, 18.65, 18.00, 37.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1541, '215279170-0200', 'HHBM27X3X170 GR 10.9', 'X', '73181500', 444.75, 10.00, 5.00, 229.050, 48.50, 215.70, 533.70, 9.00, 20.61, 9.00, 20.61, 18.00, 41.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1542, '215279180-0200', 'HHBM27X3X180 GR 10.9', 'X', '73181500', 444.75, 10.00, 5.00, 229.050, 48.50, 215.70, 533.70, 9.00, 20.61, 9.00, 20.61, 18.00, 41.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1543, '215279190-0200', 'HHBM27X3X190 GR 10.9', 'X', '73181500', 485.00, 20.00, 5.00, 249.780, 48.50, 235.23, 582.00, 9.00, 22.48, 9.00, 22.48, 18.00, 44.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1544, '215279200-0200', 'HHBM27X3X200 GR 10.9', 'X', '73181500', 485.00, 10.00, 5.00, 249.780, 48.50, 235.23, 582.00, 9.00, 22.48, 9.00, 22.48, 18.00, 44.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1545, '215279210-0200', 'HHBM27X3X210 GR 10.9', 'X', '73181500', 669.10, 10.00, 5.00, 344.590, 48.50, 324.51, 802.92, 9.00, 31.01, 9.00, 31.01, 18.00, 62.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1546, '215279220-0200', 'HHBM27X3X220 GR 10.9', 'X', '73181500', 669.10, 5.00, 5.00, 344.590, 48.50, 324.51, 802.92, 9.00, 31.01, 9.00, 31.01, 18.00, 62.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1547, '215279220-4000', 'HHBM27X3X220 GR 10.9', 'X', '73181500', 836.35, 10.00, 10.00, 430.720, 48.50, 405.63, 1003.62, 9.00, 38.76, 9.00, 38.76, 18.00, 77.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1548, '215279230-0200', 'HHBM27X3X230 GR 10.9', 'X', '73181500', 720.05, 5.00, 5.00, 370.830, 48.50, 349.22, 864.06, 9.00, 33.37, 9.00, 33.37, 18.00, 66.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1549, '215279240-0200', 'HHBM27X3X240 GR 10.9', 'X', '73181500', 720.05, 5.00, 5.00, 370.830, 48.50, 349.22, 864.06, 9.00, 33.37, 9.00, 33.37, 18.00, 66.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1550, '215279245-4000', 'HHBM27X3X245 GR 10.9', 'X', '73181500', 960.90, 10.00, 10.00, 494.860, 48.50, 466.04, 1153.08, 9.00, 44.54, 9.00, 44.54, 18.00, 89.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1551, '215279250-0200', 'HHBM27X3X250 GR 10.9', 'X', '73181500', 768.70, 5.00, 5.00, 395.880, 48.50, 372.82, 922.44, 9.00, 35.63, 9.00, 35.63, 18.00, 71.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1552, '215279260-0200', 'HHBM27X3X260 GR 10.9', 'X', '73181500', 768.70, 5.00, 5.00, 395.880, 48.50, 372.82, 922.44, 9.00, 35.63, 9.00, 35.63, 18.00, 71.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1553, '215279280-0200', 'HHBM27X3X280 GR 10.9', 'X', '73181500', 815.35, 5.00, 5.00, 419.910, 48.50, 395.44, 978.42, 9.00, 37.79, 9.00, 37.79, 18.00, 75.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1554, '215279300-0200', 'HHBM27X3X300 GR 10.9', 'X', '73181500', 853.35, 5.00, 5.00, 439.480, 48.50, 413.87, 1024.02, 9.00, 39.55, 9.00, 39.55, 18.00, 79.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1555, '215307070-0200', 'HHBM30X3.5X70 GR 10.9', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1556, '215307075-0200', 'HHBM30X3.5X75 GR 10.9', 'X', '73181500', 307.15, 20.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1557, '215307080-0200', 'HHBM30X3.5X80 GR 10.9', 'X', '73181500', 307.15, 15.00, 5.00, 158.180, 48.50, 148.97, 368.58, 9.00, 14.24, 9.00, 14.24, 18.00, 28.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1558, '215307090-0200', 'HHBM30X3.5X90 GR 10.9', 'X', '73181500', 334.70, 20.00, 5.00, 172.370, 48.50, 162.33, 401.64, 9.00, 15.51, 9.00, 15.51, 18.00, 31.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1559, '215307100-0200', 'HHBM30X3.5X100 GR 10.9', 'X', '73181500', 360.05, 20.00, 5.00, 185.430, 48.50, 174.62, 432.06, 9.00, 16.69, 9.00, 16.69, 18.00, 33.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1560, '215307110-0200', 'HHBM30X3.5X110 GR 10.9', 'X', '73181500', 396.15, 10.00, 5.00, 204.020, 48.50, 192.13, 475.38, 9.00, 18.36, 9.00, 18.36, 18.00, 36.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1561, '215307120-0200', 'HHBM30X3.5X120 GR 10.9', 'X', '73181500', 404.55, 10.00, 5.00, 208.340, 48.50, 196.21, 485.46, 9.00, 18.75, 9.00, 18.75, 18.00, 37.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(1562, '215307125-0200', 'HHBM30X3.5X125 GR 10.9', 'X', '73181500', 423.65, 10.00, 5.00, 218.180, 48.50, 205.47, 508.38, 9.00, 19.64, 9.00, 19.64, 18.00, 39.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1563, '215307130-0200', 'HHBM30X3.5X130 GR 10.9', 'X', '73181500', 423.65, 10.00, 5.00, 218.180, 48.50, 205.47, 508.38, 9.00, 19.64, 9.00, 19.64, 18.00, 39.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1564, '215307140-0200', 'HHBM30X3.5X140 GR 10.9', 'X', '73181500', 449.00, 5.00, 5.00, 231.240, 48.50, 217.77, 538.80, 9.00, 20.81, 9.00, 20.81, 18.00, 41.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1565, '215307150-0200', 'HHBM30X3.5X150 GR 10.9', 'X', '73181500', 474.40, 10.00, 10.00, 244.320, 48.50, 230.08, 569.28, 9.00, 21.99, 9.00, 21.99, 18.00, 43.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1566, '215307160-0200', 'HHBM30X3.5X160 GR 10.9', 'X', '73181500', 512.55, 5.00, 5.00, 263.960, 48.50, 248.59, 615.06, 9.00, 23.76, 9.00, 23.76, 18.00, 47.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1567, '215307170-0200', 'HHBM30X3.5X170 GR 10.9', 'X', '73181500', 565.40, 5.00, 5.00, 291.180, 48.50, 274.22, 678.48, 9.00, 26.21, 9.00, 26.21, 18.00, 52.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1568, '215307180-0200', 'HHBM30X3.5X180 GR 10.9', 'X', '73181500', 565.40, 5.00, 5.00, 291.180, 48.50, 274.22, 678.48, 9.00, 26.21, 9.00, 26.21, 18.00, 52.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1569, '215307190-0200', 'HHBM30X3.5X190 GR 10.9', 'X', '73181500', 616.30, 5.00, 5.00, 317.390, 48.50, 298.91, 739.56, 9.00, 28.57, 9.00, 28.57, 18.00, 57.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1570, '215307200-0200', 'HHBM30X3.5X200 GR 10.9', 'X', '73181500', 616.30, 5.00, 5.00, 317.390, 48.50, 298.91, 739.56, 9.00, 28.57, 9.00, 28.57, 18.00, 57.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1571, '215307210-0200', 'HHBM30X3.5X210 GR 10.9', 'X', '73181500', 743.25, 5.00, 5.00, 382.770, 48.50, 360.48, 891.90, 9.00, 34.45, 9.00, 34.45, 18.00, 68.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1572, '215307220-0200', 'HHBM30X3.5X220 GR 10.9', 'X', '73181500', 743.25, 5.00, 5.00, 382.770, 48.50, 360.48, 891.90, 9.00, 34.45, 9.00, 34.45, 18.00, 68.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1573, '215307240-0200', 'HHBM30X3.5X240 GR 10.9', 'X', '73181500', 796.25, 5.00, 5.00, 410.070, 48.50, 386.18, 955.50, 9.00, 36.91, 9.00, 36.91, 18.00, 73.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1574, '215307250-0200', 'HHBM30X3.5X250 GR 10.9', 'X', '73181500', 849.20, 5.00, 5.00, 437.340, 48.50, 411.86, 1019.04, 9.00, 39.36, 9.00, 39.36, 18.00, 78.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1575, '215307260-0200', 'HHBM30X3.5X260 GR 10.9', 'X', '73181500', 849.20, 5.00, 5.00, 437.340, 48.50, 411.86, 1019.04, 9.00, 39.36, 9.00, 39.36, 18.00, 78.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1576, '215307280-0200', 'HHBM30X3.5X280 GR 10.9', 'X', '73181500', 902.15, 5.00, 5.00, 464.610, 48.50, 437.54, 1082.58, 9.00, 41.81, 9.00, 41.81, 18.00, 83.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1577, '215307300-0200', 'HHBM30X3.5X300 GR 10.9', 'X', '73181500', 962.15, 5.00, 5.00, 495.510, 48.50, 466.64, 1154.58, 9.00, 44.60, 9.00, 44.60, 18.00, 89.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1578, '215307305-0200', 'HHBM30X3.5X305 GR 10.9', 'X', '73181500', 967.15, 5.00, 5.00, 498.080, 48.50, 469.07, 1160.58, 9.00, 44.83, 9.00, 44.83, 18.00, 89.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1579, '215307320-0200', 'HHBM30X3.5X320 GR 10.9', 'X', '73181500', 994.60, 5.00, 5.00, 512.220, 48.50, 482.38, 1193.52, 9.00, 46.10, 9.00, 46.10, 18.00, 92.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1580, '215307340-0200', 'HHBM30X3.5X340 GR 10.9', 'X', '73181500', 1050.55, 5.00, 5.00, 541.030, 48.50, 509.52, 1260.66, 9.00, 48.69, 9.00, 48.69, 18.00, 97.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1581, '215307360-0200', 'HHBM30X3.5X360 GR 10.9', 'X', '73181500', 1137.95, 5.00, 5.00, 586.040, 48.50, 551.91, 1365.54, 9.00, 52.74, 9.00, 52.74, 18.00, 105.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1582, '215307380-0200', 'HHBM30X3.5X380 GR 10.9', 'X', '73181500', 1209.45, 5.00, 5.00, 622.870, 48.50, 586.58, 1451.34, 9.00, 56.06, 9.00, 56.06, 18.00, 112.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1583, '215307400-0200', 'HHBM30X3.5X400 GR 10.9', 'X', '73181500', 1233.35, 5.00, 5.00, 635.180, 48.50, 598.17, 1480.02, 9.00, 57.17, 9.00, 57.17, 18.00, 114.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1584, '215337080-0200', 'HHBM33X3.5X80 GR 10.9', 'X', '73181500', 410.85, 20.00, 5.00, 211.590, 48.50, 199.26, 493.02, 9.00, 19.04, 9.00, 19.04, 18.00, 38.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1585, '215337090-0200', 'HHBM33X3.5X90 GR 10.9', 'X', '73181500', 436.25, 20.00, 5.00, 224.670, 48.50, 211.58, 523.50, 9.00, 20.22, 9.00, 20.22, 18.00, 40.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1586, '215337100-0200', 'HHBM33X3.5X100 GR 10.9', 'X', '73181500', 465.95, 20.00, 5.00, 239.960, 48.50, 225.99, 559.14, 9.00, 21.60, 9.00, 21.60, 18.00, 43.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1587, '215337110-0200', 'HHBM33X3.5X110 GR 10.9', 'X', '73181500', 502.00, 8.00, 2.00, 258.530, 48.50, 243.47, 602.40, 9.00, 23.27, 9.00, 23.27, 18.00, 46.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1588, '215337120-0200', 'HHBM33X3.5X120 GR 10.9', 'X', '73181500', 514.60, 5.00, 5.00, 265.020, 48.50, 249.58, 617.52, 9.00, 23.85, 9.00, 23.85, 18.00, 47.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1589, '215337130-0200', 'HHBM33X3.5X130 GR 10.9', 'X', '73181500', 542.15, 8.00, 2.00, 279.210, 48.50, 262.94, 650.58, 9.00, 25.13, 9.00, 25.13, 18.00, 50.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1590, '215337140-0200', 'HHBM33X3.5X140 GR 10.9', 'X', '73181500', 576.00, 5.00, 5.00, 296.640, 48.50, 279.36, 691.20, 9.00, 26.70, 9.00, 26.70, 18.00, 53.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1591, '215337150-0200', 'HHBM33X3.5X150 GR 10.9', 'X', '73181500', 607.70, 5.00, 5.00, 312.970, 48.50, 294.73, 729.24, 9.00, 28.17, 9.00, 28.17, 18.00, 56.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1592, '215337160-0200', 'HHBM33X3.5X160 GR 10.9', 'X', '73181500', 635.25, 5.00, 5.00, 327.150, 48.50, 308.10, 762.30, 9.00, 29.44, 9.00, 29.44, 18.00, 58.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1593, '215337170-0200', 'HHBM33X3.5X170 GR 10.9', 'X', '73181500', 696.65, 5.00, 5.00, 358.770, 48.50, 337.88, 835.98, 9.00, 32.29, 9.00, 32.29, 18.00, 64.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1594, '215337180-0200', 'HHBM33X3.5X180 GR 10.9', 'X', '73181500', 696.65, 5.00, 5.00, 358.770, 48.50, 337.88, 835.98, 9.00, 32.29, 9.00, 32.29, 18.00, 64.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1595, '215337190-0200', 'HHBM33X3.5X190 GR 10.9', 'X', '73181500', 758.05, 5.00, 5.00, 390.400, 48.50, 367.65, 909.66, 9.00, 35.14, 9.00, 35.14, 18.00, 70.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1596, '215337200-0200', 'HHBM33X3.5X200 GR 10.9', 'X', '73181500', 758.05, 5.00, 5.00, 390.400, 48.50, 367.65, 909.66, 9.00, 35.14, 9.00, 35.14, 18.00, 70.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1597, '215337220-0200', 'HHBM33X3.5X220 GR 10.9', 'X', '73181500', 916.90, 2.00, 2.00, 472.200, 48.50, 444.70, 1100.28, 9.00, 42.50, 9.00, 42.50, 18.00, 85.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1598, '215337240-0200', 'HHBM33X3.5X240 GR 10.9', 'X', '73181500', 984.65, 5.00, 5.00, 507.090, 48.50, 477.56, 1181.58, 9.00, 45.64, 9.00, 45.64, 18.00, 91.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1599, '215337260-0200', 'HHBM33X3.5X260 GR 10.9', 'X', '73181500', 1058.80, 2.00, 2.00, 545.280, 48.50, 513.52, 1270.56, 9.00, 49.08, 9.00, 49.08, 18.00, 98.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1600, '215337280-0200', 'HHBM33X3.5X280 GR 10.9', 'X', '73181500', 1132.80, 2.00, 2.00, 583.390, 48.50, 549.41, 1359.36, 9.00, 52.51, 9.00, 52.51, 18.00, 105.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1601, '215369075-0200', 'HHBM36X4X75 GR 10.9', 'X', '73181500', 514.60, 20.00, 5.00, 265.020, 48.50, 249.58, 617.52, 9.00, 23.85, 9.00, 23.85, 18.00, 47.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1602, '215369080-0200', 'HHBM36X4X80 GR 10.9', 'X', '73181500', 514.60, 5.00, 5.00, 265.020, 48.50, 249.58, 617.52, 9.00, 23.85, 9.00, 23.85, 18.00, 47.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1603, '215369100-0200', 'HHBM36X4X100 GR 10.9', 'X', '73181500', 576.00, 5.00, 5.00, 296.640, 48.50, 279.36, 691.20, 9.00, 26.70, 9.00, 26.70, 18.00, 53.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1604, '215369110-0200', 'HHBM36X4X110 GR 10.9', 'X', '73181500', 614.10, 10.00, 5.00, 316.260, 48.50, 297.84, 736.92, 9.00, 28.46, 9.00, 28.46, 18.00, 56.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1605, '215369120-0200', 'HHBM36X4X120 GR 10.9', 'X', '73181500', 626.80, 5.00, 5.00, 322.800, 48.50, 304.00, 752.16, 9.00, 29.05, 9.00, 29.05, 18.00, 58.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1606, '215369130-0200', 'HHBM36X4X130 GR 10.9', 'X', '73181500', 658.65, 5.00, 5.00, 339.200, 48.50, 319.45, 790.38, 9.00, 30.53, 9.00, 30.53, 18.00, 61.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1607, '215369140-0200', 'HHBM36X4X140 GR 10.9', 'X', '73181500', 696.65, 5.00, 5.00, 358.770, 48.50, 337.88, 835.98, 9.00, 32.29, 9.00, 32.29, 18.00, 64.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1608, '215369150-0200', 'HHBM36X4X150 GR 10.9', 'X', '73181500', 734.80, 5.00, 5.00, 378.420, 48.50, 356.38, 881.76, 9.00, 34.06, 9.00, 34.06, 18.00, 68.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1609, '215369160-0200', 'HHBM36X4X160 GR 10.9', 'X', '73181500', 770.85, 5.00, 5.00, 396.990, 48.50, 373.86, 925.02, 9.00, 35.73, 9.00, 35.73, 18.00, 71.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1610, '215369170-0200', 'HHBM36X4X170 GR 10.9', 'X', '73181500', 895.65, 5.00, 5.00, 461.260, 48.50, 434.39, 1074.78, 9.00, 41.51, 9.00, 41.51, 18.00, 83.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1611, '215369180-0200', 'HHBM36X4X180 GR 10.9', 'X', '73181500', 895.65, 5.00, 5.00, 461.260, 48.50, 434.39, 1074.78, 9.00, 41.51, 9.00, 41.51, 18.00, 83.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1612, '215369190-0200', 'HHBM36X4X190 GR 10.9', 'X', '73181500', 969.80, 5.00, 5.00, 499.450, 48.50, 470.35, 1163.76, 9.00, 44.95, 9.00, 44.95, 18.00, 89.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1613, '215369200-0200', 'HHBM36X4X200 GR 10.9', 'X', '73181500', 969.80, 5.00, 5.00, 499.450, 48.50, 470.35, 1163.76, 9.00, 44.95, 9.00, 44.95, 18.00, 89.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1614, '215369210-0200', 'HHBM36X4X210 GR 10.9', 'X', '73181500', 1162.55, 5.00, 5.00, 598.710, 48.50, 563.84, 1395.06, 9.00, 53.88, 9.00, 53.88, 18.00, 107.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1615, '215369220-0200', 'HHBM36X4X220 GR 10.9', 'X', '73181500', 1162.55, 5.00, 5.00, 598.710, 48.50, 563.84, 1395.06, 9.00, 53.88, 9.00, 53.88, 18.00, 107.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1616, '215369230-0200', 'HHBM36X4X230 GR 10.9', 'X', '73181500', 1247.20, 5.00, 5.00, 642.310, 48.50, 604.89, 1496.64, 9.00, 57.81, 9.00, 57.81, 18.00, 115.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1617, '215369240-0200', 'HHBM36X4X240 GR 10.9', 'X', '73181500', 1247.20, 2.00, 2.00, 642.310, 48.50, 604.89, 1496.64, 9.00, 57.81, 9.00, 57.81, 18.00, 115.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1618, '215369250-0200', 'HHBM36X4X250 GR 10.9', 'X', '73181500', 1331.85, 2.00, 2.00, 685.900, 48.50, 645.95, 1598.22, 9.00, 61.73, 9.00, 61.73, 18.00, 123.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1619, '215369260-0200', 'HHBM36X4X260 GR 10.9', 'X', '73181500', 1331.85, 2.00, 2.00, 685.900, 48.50, 645.95, 1598.22, 9.00, 61.73, 9.00, 61.73, 18.00, 123.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1620, '215369280-0200', 'HHBM36X4X280 GR 10.9', 'X', '73181500', 1414.30, 2.00, 2.00, 728.360, 48.50, 685.94, 1697.16, 9.00, 65.55, 9.00, 65.55, 18.00, 131.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1621, '215369300-0200', 'HHBM36X4X300 GR 10.9', 'X', '73181500', 1698.15, 2.00, 2.00, 874.550, 48.50, 823.60, 2037.78, 9.00, 78.71, 9.00, 78.71, 18.00, 157.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1622, '215369320-0200', 'HHBM36X4X320 GR 10.9', 'X', '73181500', 1717.45, 2.00, 2.00, 884.490, 48.50, 832.96, 2060.94, 9.00, 79.60, 9.00, 79.60, 18.00, 159.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1623, '215369340-0200', 'HHBM36X4X340 GR 10.9', 'X', '73181500', 1907.80, 2.00, 2.00, 982.520, 48.50, 925.28, 2289.36, 9.00, 88.43, 9.00, 88.43, 18.00, 176.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1624, '215369350-0200', 'HHBM36X4X350 GR 10.9', 'X', '73181500', 1967.45, 2.00, 2.00, 1013.240, 48.50, 954.21, 2360.94, 9.00, 91.19, 9.00, 91.19, 18.00, 182.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1625, '215369360-0200', 'HHBM36X4X360 GR 10.9', 'X', '73181500', 1967.45, 5.00, 5.00, 1013.240, 48.50, 954.21, 2360.94, 9.00, 91.19, 9.00, 91.19, 18.00, 182.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1626, '215369400-0200', 'HHBM36X4X400 GR 10.9', 'X', '73181500', 2265.50, 5.00, 5.00, 1166.730, 48.50, 1098.77, 2718.60, 9.00, 105.01, 9.00, 105.01, 18.00, 210.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1627, '215399130-0200', 'HHBM39X4X130 GR 10.9', 'X', '73181500', 752.50, 2.00, 2.00, 387.540, 48.50, 364.96, 903.00, 9.00, 34.88, 9.00, 34.88, 18.00, 69.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1628, '215399140-0200', 'HHBM39X4X140 GR 10.9', 'X', '73181500', 833.50, 2.00, 2.00, 429.250, 48.50, 404.25, 1000.20, 9.00, 38.63, 9.00, 38.63, 18.00, 77.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1629, '215422100-0200', 'HHBM42X4.5X100 GR 10.9', 'X', '73181500', 1006.35, 5.00, 5.00, 518.270, 48.50, 488.08, 1207.62, 9.00, 46.64, 9.00, 46.64, 18.00, 93.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1630, '215422120-0200', 'HHBM42X4.5X120 GR 10.9', 'X', '73181500', 1135.15, 5.00, 5.00, 584.600, 48.50, 550.55, 1362.18, 9.00, 52.61, 9.00, 52.61, 18.00, 105.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1631, '215422130-0200', 'HHBM42X4.5X130 GR 10.9', 'X', '73181500', 1199.50, 5.00, 5.00, 617.740, 48.50, 581.76, 1439.40, 9.00, 55.60, 9.00, 55.60, 18.00, 111.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1632, '215422140-0200', 'HHBM42X4.5X140 GR 10.9', 'X', '73181500', 1199.50, 5.00, 5.00, 617.740, 48.50, 581.76, 1439.40, 9.00, 55.60, 9.00, 55.60, 18.00, 111.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1633, '215422150-0200', 'HHBM42X4.5X150 GR 10.9', 'X', '73181500', 1333.90, 5.00, 5.00, 686.960, 48.50, 646.94, 1600.68, 9.00, 61.83, 9.00, 61.83, 18.00, 123.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1634, '215422160-0200', 'HHBM42X4.5X160 GR 10.9', 'X', '73181500', 1399.55, 5.00, 5.00, 720.770, 48.50, 678.78, 1679.46, 9.00, 64.87, 9.00, 64.87, 18.00, 129.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1635, '215422170-0200', 'HHBM42X4.5X170 GR 10.9', 'X', '73181500', 1463.95, 2.00, 2.00, 753.930, 48.50, 710.02, 1756.74, 9.00, 67.85, 9.00, 67.85, 18.00, 135.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1636, '215422180-0200', 'HHBM42X4.5X180 GR 10.9', 'X', '73181500', 1528.40, 2.00, 2.00, 787.130, 48.50, 741.27, 1834.08, 9.00, 70.84, 9.00, 70.84, 18.00, 141.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1637, '215422190-0200', 'HHBM42X4.5X190 GR 10.9', 'X', '73181500', 1593.25, 2.00, 2.00, 820.520, 48.50, 772.73, 1911.90, 9.00, 73.85, 9.00, 73.85, 18.00, 147.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1638, '215422200-0200', 'HHBM42X4.5X200 GR 10.9', 'X', '73181500', 1657.95, 2.00, 2.00, 853.840, 48.50, 804.11, 1989.54, 9.00, 76.85, 9.00, 76.85, 18.00, 153.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1639, '215422220-0200', 'HHBM42X4.5X220 GR 10.9', 'X', '73181500', 1776.25, 2.00, 2.00, 914.770, 48.50, 861.48, 2131.50, 9.00, 82.33, 9.00, 82.33, 18.00, 164.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1640, '215422250-0200', 'HHBM42X4.5X250 GR 10.9', 'X', '73181500', 2008.75, 2.00, 2.00, 1034.510, 48.50, 974.24, 2410.50, 9.00, 93.11, 9.00, 93.11, 18.00, 186.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1641, '215422275-0200', 'HHBM42X4.5X275 GR 10.9', 'X', '73181500', 2165.05, 2.00, 2.00, 1115.000, 48.50, 1050.05, 2598.06, 9.00, 100.35, 9.00, 100.35, 18.00, 200.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1642, '215422280-0200', 'HHBM42X4.5X280 GR 10.9', 'X', '73181500', 2165.05, 2.00, 2.00, 1115.000, 48.50, 1050.05, 2598.06, 9.00, 100.35, 9.00, 100.35, 18.00, 200.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1643, '215422300-0200', 'HHBM42X4.5X300 GR 10.9', 'X', '73181500', 2320.10, 2.00, 2.00, 1194.850, 48.50, 1125.25, 2784.12, 9.00, 107.54, 9.00, 107.54, 18.00, 215.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1644, '215422380-0200', 'HHBM42X4.5X380 GR 10.9', 'X', '73181500', 2766.35, 2.00, 2.00, 1424.670, 48.50, 1341.68, 3319.62, 9.00, 128.22, 9.00, 128.22, 18.00, 256.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1645, '215452180-0200', 'HHBM45X4.5X180 GR 10.9', 'X', '73181500', 1711.85, 0.00, 0.00, 881.600, 48.50, 830.25, 2054.22, 9.00, 79.34, 9.00, 79.34, 18.00, 158.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1646, '215452200-0200', 'HHBM45X4.5X200 GR 10.9', 'X', '73181500', 1856.95, 0.00, 0.00, 956.330, 48.50, 900.62, 2228.34, 9.00, 86.07, 9.00, 86.07, 18.00, 172.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1647, '215452220-0200', 'HHBM45X4.5X220 GR 10.9', 'X', '73181500', 1989.40, 0.00, 0.00, 1024.540, 48.50, 964.86, 2387.28, 9.00, 92.21, 9.00, 92.21, 18.00, 184.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1648, '215452260-0200', 'HHBM45X4.5X260 GR 10.9', 'X', '73181500', 2336.65, 2.00, 2.00, 1203.370, 48.50, 1133.28, 2803.98, 9.00, 108.30, 9.00, 108.30, 18.00, 216.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1649, '215484150-0200', 'HHBM48X5X150 GR 10.9', 'X', '73181500', 1488.40, 5.00, 5.00, 766.530, 48.50, 721.87, 1786.08, 9.00, 68.99, 9.00, 68.99, 18.00, 137.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1650, '215484160-0200', 'HHBM48X5X160 GR 10.9', 'X', '73181500', 1532.50, 4.00, 4.00, 789.240, 48.50, 743.26, 1839.00, 9.00, 71.03, 9.00, 71.03, 18.00, 142.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 4.00, 4.00, 4.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1651, '215484170-0200', 'HHBM48X5X170 GR 10.9', 'X', '73181500', 1598.65, 2.00, 2.00, 823.300, 48.50, 775.35, 1918.38, 9.00, 74.10, 9.00, 74.10, 18.00, 148.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1652, '215484180-0200', 'HHBM48X5X180 GR 10.9', 'X', '73181500', 1653.75, 2.00, 2.00, 851.680, 48.50, 802.07, 1984.50, 9.00, 76.65, 9.00, 76.65, 18.00, 153.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1653, '215484200-0200', 'HHBM48X5X200 GR 10.9', 'X', '73181500', 1839.85, 2.00, 2.00, 947.520, 48.50, 892.33, 2207.82, 9.00, 85.28, 9.00, 85.28, 18.00, 170.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1654, '215484220-0200', 'HHBM48X5X220 GR 10.9', 'X', '73181500', 2025.90, 2.00, 2.00, 1043.340, 48.50, 982.56, 2431.08, 9.00, 93.90, 9.00, 93.90, 18.00, 187.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1655, '215484240-0200', 'HHBM48X5X240 GR 10.9', 'X', '73181500', 2160.90, 2.00, 2.00, 1112.860, 48.50, 1048.04, 2593.08, 9.00, 100.16, 9.00, 100.16, 18.00, 200.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1656, '215484250-0200', 'HHBM48X5X250 GR 10.9', 'X', '73181500', 2370.40, 2.00, 2.00, 1220.760, 48.50, 1149.64, 2844.48, 9.00, 109.87, 9.00, 109.87, 18.00, 219.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1657, '215484260-0200', 'HHBM48X5X260 GR 10.9', 'X', '73181500', 2546.80, 3.00, 3.00, 1311.600, 48.50, 1235.20, 3056.16, 9.00, 118.04, 9.00, 118.04, 18.00, 236.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3.00, 3.00, 3.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1658, '215484280-0200', 'HHBM48X5X280 GR 10.9', 'X', '73181500', 2745.85, 2.00, 2.00, 1414.110, 48.50, 1331.74, 3295.02, 9.00, 127.27, 9.00, 127.27, 18.00, 254.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1659, '216187120-0200', 'HHBM18X2.5X120 GR 12.9', 'X', '73181500', 115.75, 30.00, 10.00, 59.610, 48.50, 56.14, 138.90, 9.00, 5.37, 9.00, 5.37, 18.00, 10.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1660, '216187130-0200', 'HHBM18X2.5X130 GR 12.9', 'X', '73181500', 121.00, 10.00, 10.00, 62.320, 48.50, 58.69, 145.20, 9.00, 5.61, 9.00, 5.61, 18.00, 11.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1661, '216207065-0200', 'HHBM20X2.5X65 GR 12.9', 'X', '73181500', 86.30, 120.00, 20.00, 44.440, 48.50, 41.86, 103.56, 9.00, 4.00, 9.00, 4.00, 18.00, 8.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1662, '216207075-0200', 'HHBM20X2.5X75 GR 12.9', 'X', '73181500', 93.15, 60.00, 10.00, 47.970, 48.50, 45.18, 111.78, 9.00, 4.32, 9.00, 4.32, 18.00, 8.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1663, '216207090-0200', 'HHBM20X2.5X90 GR 12.9', 'X', '73181500', 101.85, 30.00, 10.00, 52.450, 48.50, 49.40, 122.22, 9.00, 4.72, 9.00, 4.72, 18.00, 9.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1664, '216207100-0200', 'HHBM20X2.5X100 GR 12.9', 'X', '73181500', 107.80, 60.00, 10.00, 55.520, 48.50, 52.28, 129.36, 9.00, 5.00, 9.00, 5.00, 18.00, 9.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1665, '216249085-0200', 'HHBM24X3X85 GR 12.9', 'X', '73181500', 163.20, 20.00, 10.00, 84.050, 48.50, 79.15, 195.84, 9.00, 7.56, 9.00, 7.56, 18.00, 15.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1666, '216249100-0200', 'HHBM24X3X100 GR 12.9', 'X', '73181500', 182.40, 20.00, 10.00, 93.940, 48.50, 88.46, 218.88, 9.00, 8.45, 9.00, 8.45, 18.00, 16.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1667, '216249110-0200', 'HHBM24X3X110 GR 12.9', 'X', '73181500', 189.55, 15.00, 5.00, 97.620, 48.50, 91.93, 227.46, 9.00, 8.79, 9.00, 8.79, 18.00, 17.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1668, '216249140-0200', 'HHBM24X3X140 GR 12.9', 'X', '73181500', 219.70, 20.00, 5.00, 113.150, 48.50, 106.55, 263.64, 9.00, 10.18, 9.00, 10.18, 18.00, 20.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1669, '216307150-0200', 'HHBM30X3.5X150 GR 12.9', 'X', '73181500', 593.00, 5.00, 5.00, 305.400, 48.50, 287.61, 711.60, 9.00, 27.49, 9.00, 27.49, 18.00, 54.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1670, '216307170-0200', 'HHBM30X3.5X170 GR 12.9', 'X', '73181500', 706.80, 5.00, 5.00, 364.000, 48.50, 342.80, 848.16, 9.00, 32.76, 9.00, 32.76, 18.00, 65.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1671, '216369130-0200', 'HHBM36X4X130 GR 12.9', 'X', '73181500', 823.35, 5.00, 5.00, 424.030, 48.50, 399.32, 988.02, 9.00, 38.16, 9.00, 38.16, 18.00, 76.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1672, '222081108-0200', 'HHB1/4BSWX1-1/2 GR R', 'X', '73181500', 5.00, 200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1673, '222081200-0200', 'HHB1/4BSWX2 GR R', 'X', '73181500', 5.70, 400.00, 100.00, 2.940, 48.50, 2.76, 6.84, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1674, '222081208-0200', 'HHB1/4BSWX2-1/2 GR R', 'X', '73181500', 6.30, 400.00, 100.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1675, '222101104-0200', 'HHB5/16BSWX1-1/4 GR R', 'X', '73181500', 5.35, 1200.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1676, '222101108-0200', 'HHB5/16BSWX1-1/2 GR R', 'X', '73181500', 6.30, 600.00, 200.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1677, '222101208-0200', 'HHB5/16BSWX2-1/2 GR R', 'X', '73181500', 8.25, 600.00, 200.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1678, '222101300-0200', 'HHB5/16BSWX3 GR R', 'X', '73181500', 9.65, 200.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1679, '222121108-0200', 'HHB3/8BSWX1-1/2 GR R', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1680, '222121200-0200', 'HHB3/8BSWX2 GR R', 'X', '73181500', 9.25, 200.00, 50.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1681, '222121208-0200', 'HHB3/8BSWX2-1/2 GR R', 'X', '73181500', 10.65, 200.00, 50.00, 5.480, 48.50, 5.17, 12.78, 9.00, 0.49, 9.00, 0.49, 18.00, 0.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1682, '222121212-0200', 'HHB3/8BSWX2-3/4 GR R', 'X', '73181500', 11.65, 200.00, 50.00, 6.000, 48.50, 5.65, 13.98, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1683, '222121300-0200', 'HHB3/8BSWX3 GR R', 'X', '73181500', 12.30, 200.00, 50.00, 6.330, 48.50, 5.97, 14.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1684, '222141104-0200', 'HHB7/16BSWX1-1/4 GR R', 'X', '73181500', 9.65, 300.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1685, '222141106-0200', 'HHB7/16BSWX1-3/8 GR R', 'X', '73181500', 9.95, 300.00, 100.00, 5.120, 48.50, 4.83, 11.94, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1686, '222141108-0200', 'HHB7/16BSWX1-1/2 GR R', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1687, '222141200-0200', 'HHB7/16BSWX2 GR R', 'X', '73181500', 12.75, 200.00, 50.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1688, '222161108-0200', 'HHB1/2BSWX1-1/2 GR R', 'X', '73181500', 15.25, 200.00, 50.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1689, '222161112-0200', 'HHB1/2BSWX1-3/4 GR R', 'X', '73181500', 17.25, 150.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1690, '222161200-0200', 'HHB1/2BSWX2 GR R', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1691, '222161204-0200', 'HHB1/2BSWX2-1/4 GR R', 'X', '73181500', 19.85, 200.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1692, '222161208-0200', 'HHB1/2BSWX2-1/2 GR R', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1693, '222161212-0200', 'HHB1/2BSWX2-3/4 GR R', 'X', '73181500', 20.50, 120.00, 20.00, 10.560, 48.50, 9.94, 24.60, 9.00, 0.95, 9.00, 0.95, 18.00, 1.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1694, '222161300-0200', 'HHB1/2BSWX3 GR R', 'X', '73181500', 22.35, 80.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1695, '222161308-0200', 'HHB1/2BSWX3-1/2 GR R', 'X', '73181500', 24.90, 80.00, 20.00, 12.820, 48.50, 12.08, 29.88, 9.00, 1.15, 9.00, 1.15, 18.00, 2.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1696, '222161400-0200', 'HHB1/2BSWX4 GR R', 'X', '73181500', 28.15, 80.00, 20.00, 14.500, 48.50, 13.65, 33.78, 9.00, 1.30, 9.00, 1.30, 18.00, 2.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1697, '222161408-0200', 'HHB1/2BSWX4-1/2 GR R', 'X', '73181500', 32.55, 80.00, 20.00, 16.760, 48.50, 15.79, 39.06, 9.00, 1.51, 9.00, 1.51, 18.00, 3.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1698, '222161500-0200', 'HHB1/2BSWX5 GR R', 'X', '73181500', 34.65, 60.00, 20.00, 17.840, 48.50, 16.81, 41.58, 9.00, 1.61, 9.00, 1.61, 18.00, 3.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1699, '222161508-0200', 'HHB1/2BSWX5-1/2 GR R', 'X', '73181500', 57.10, 120.00, 20.00, 29.410, 48.50, 27.69, 68.52, 9.00, 2.65, 9.00, 2.65, 18.00, 5.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1700, '222161600-0200', 'HHB1/2BSWX6 GR R', 'X', '73181500', 69.80, 80.00, 20.00, 35.950, 48.50, 33.85, 83.76, 9.00, 3.24, 9.00, 3.24, 18.00, 6.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1701, '222161700-0200', 'HHB1/2BSWX7 GR R', 'X', '73181500', 77.00, 20.00, 20.00, 39.660, 48.50, 37.35, 92.40, 9.00, 3.57, 9.00, 3.57, 18.00, 7.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1702, '222161800-0200', 'HHB1/2BSWX8 GR R', 'X', '73181500', 86.65, 20.00, 20.00, 44.620, 48.50, 42.03, 103.98, 9.00, 4.02, 9.00, 4.02, 18.00, 8.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1703, '222201200-0200', 'HHB5/8BSWX2 GR R', 'X', '73181500', 32.70, 80.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1704, '222201208-0200', 'HHB5/8BSWX2-1/2 GR R', 'X', '73181500', 37.95, 80.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1705, '222201300-0200', 'HHB5/8BSWX3 GR R', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1706, '222201400-0200', 'HHB5/8BSWX4 GR R', 'X', '73181500', 57.65, 40.00, 10.00, 29.690, 48.50, 27.96, 69.18, 9.00, 2.67, 9.00, 2.67, 18.00, 5.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1707, '222201500-0200', 'HHB5/8BSWX5 GR R', 'X', '73181500', 69.90, 30.00, 10.00, 36.000, 48.50, 33.90, 83.88, 9.00, 3.24, 9.00, 3.24, 18.00, 6.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1708, '222201600-0200', 'HHB5/8BSWX6 GR R', 'X', '73181500', 82.40, 80.00, 20.00, 42.440, 48.50, 39.96, 98.88, 9.00, 3.82, 9.00, 3.82, 18.00, 7.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1709, '222241200-0200', 'HHB3/4BSWX2 GR R', 'X', '73181500', 62.15, 60.00, 20.00, 32.010, 48.50, 30.14, 74.58, 9.00, 2.88, 9.00, 2.88, 18.00, 5.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1710, '222241408-0200', 'HHB3/4BSWX4-1/2 GR R', 'X', '73181500', 102.75, 10.00, 10.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1711, '222241500-0200', 'HHB3/4BSWX5 GR R', 'X', '73181500', 109.35, 40.00, 10.00, 56.320, 48.50, 53.03, 131.22, 9.00, 5.07, 9.00, 5.07, 18.00, 10.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1712, '222241600-0200', 'HHB3/4BSWX6 GR R', 'X', '73181500', 122.75, 40.00, 10.00, 63.220, 48.50, 59.53, 147.30, 9.00, 5.69, 9.00, 5.69, 18.00, 11.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1713, '222241700-0200', 'HHB3/4BSWX7 GR R', 'X', '73181500', 136.15, 40.00, 10.00, 70.120, 48.50, 66.03, 163.38, 9.00, 6.31, 9.00, 6.31, 18.00, 12.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1714, '222321300-0200', 'HHB1BSWX3 GR R', 'X', '73181500', 132.30, 40.00, 10.00, 68.130, 48.50, 64.17, 158.76, 9.00, 6.13, 9.00, 6.13, 18.00, 12.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1715, '222321400-0200', 'HHB1BSWX4 GR R', 'X', '73181500', 165.25, 40.00, 10.00, 85.100, 48.50, 80.15, 198.30, 9.00, 7.66, 9.00, 7.66, 18.00, 15.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1716, '222321500-0200', 'HHB1BSWX5 GR R', 'X', '73181500', 194.20, 15.00, 5.00, 100.010, 48.50, 94.19, 233.04, 9.00, 9.00, 9.00, 9.00, 18.00, 18.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1717, '222321600-0200', 'HHB1BSWX6 GR R', 'X', '73181500', 219.25, 5.00, 5.00, 112.910, 48.50, 106.34, 263.10, 9.00, 10.16, 9.00, 10.16, 18.00, 20.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1718, '228084100-0200', 'HHB1/4UNCX1 GR 5', 'X', '73181500', 4.55, 1200.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1719, '228084102-0200', 'HHB1/4UNCX1-1/8 GR 5', 'X', '73181500', 4.80, 200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1720, '228084104-0200', 'HHB1/4UNCX1-1/4 GR 5', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1721, '228084106-0200', 'HHB1/4UNCX1-3/8 GR 5', 'X', '73181500', 4.90, 800.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1722, '228084108-0200', 'HHB1/4UNCX1-1/2 GR 5', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1723, '228084110-0200', 'HHB1/4UNCX1-5/8 GR 5', 'X', '73181500', 5.45, 200.00, 200.00, 2.810, 48.50, 2.64, 6.54, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1724, '228084112-0200', 'HHB1/4UNCX1-3/4 GR 5', 'X', '73181500', 5.20, 1200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1725, '228084114-0200', 'HHB1/4UNCX1-7/8 GR 5', 'X', '73181500', 5.95, 200.00, 200.00, 3.060, 48.50, 2.89, 7.14, 9.00, 0.28, 9.00, 0.28, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1726, '228084200-0200', 'HHB1/4UNCX2 GR 5', 'X', '73181500', 5.70, 600.00, 100.00, 2.940, 48.50, 2.76, 6.84, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1727, '228084204-0200', 'HHB1/4UNCX2-1/4 GR 5', 'X', '73181500', 6.05, 600.00, 100.00, 3.120, 48.50, 2.93, 7.26, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1728, '228084208-0200', 'HHB1/4UNCX2-1/2 GR 5', 'X', '73181500', 6.30, 600.00, 100.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1729, '228084212-0200', 'HHB1/4UNCX2-3/4 GR 5', 'X', '73181500', 7.15, 600.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1730, '228084300-0200', 'HHB1/4UNCX3 GR 5', 'X', '73181500', 7.70, 1200.00, 200.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1731, '228085100-0200', 'HHB1/4UNFX1 GR 5', 'X', '73181500', 4.55, 1200.00, 200.00, 2.340, 48.50, 2.21, 5.46, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1732, '228085102-0200', 'HHB1/4UNFX1-1/8 GR 5', 'X', '73181500', 4.80, 200.00, 200.00, 2.470, 48.50, 2.33, 5.76, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1733, '228085104-0200', 'HHB1/4UNFX1-1/4 GR 5', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1734, '228085106-0200', 'HHB1/4UNFX1-3/8 GR 5', 'X', '73181500', 4.90, 200.00, 200.00, 2.520, 48.50, 2.38, 5.88, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1735, '228085108-0200', 'HHB1/4UNFX1-1/2 GR 5', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1736, '228085110-0200', 'HHB1/4UNFX1-5/8 GR 5', 'X', '73181500', 5.45, 200.00, 200.00, 2.810, 48.50, 2.64, 6.54, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1737, '228085112-0200', 'HHB1/4UNFX1-3/4 GR 5', 'X', '73181500', 5.20, 200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1738, '228085200-0200', 'HHB1/4UNFX2 GR 5', 'X', '73181500', 5.70, 1200.00, 200.00, 2.940, 48.50, 2.76, 6.84, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1739, '228085204-0200', 'HHB1/4UNFX2-1/4 GR 5', 'X', '73181500', 6.05, 200.00, 200.00, 3.120, 48.50, 2.93, 7.26, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1740, '228085208-0200', 'HHB1/4UNFX2-1/2 GR 5', 'X', '73181500', 6.30, 200.00, 200.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1741, '228085212-0200', 'HHB1/4UNFX2-3/4 GR 5', 'X', '73181500', 7.15, 200.00, 200.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1742, '228085300-0200', 'HHB1/4UNFX3 GR 5', 'X', '73181500', 7.70, 200.00, 200.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1743, '228085304-0200', 'HHB1/4UNFX3-1/4 GR 5', 'X', '73181500', 9.25, 100.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1744, '228104104-0200', 'HHB5/16UNCX1-1/4 GR 5', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1745, '228104106-0200', 'HHB5/16UNCX1-3/8 GR 5', 'X', '73181500', 6.05, 600.00, 200.00, 3.120, 48.50, 2.93, 7.26, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1746, '228104108-0200', 'HHB5/16UNCX1-1/2 GR 5', 'X', '73181500', 6.30, 600.00, 200.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1747, '228104112-0200', 'HHB5/16UNCX1-3/4 GR 5', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1748, '228104114-0200', 'HHB5/16UNCX1-7/8 GR 5', 'X', '73181500', 7.50, 400.00, 100.00, 3.860, 48.50, 3.64, 9.00, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1749, '228104200-0200', 'HHB5/16UNCX2 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1750, '228104202-0200', 'HHB5/16UNCX2-1/8 GR 5', 'X', '73181500', 7.85, 200.00, 200.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1751, '228104204-0200', 'HHB5/16UNCX2-1/4 GR 5', 'X', '73181500', 7.85, 300.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1752, '228104208-0200', 'HHB5/16UNCX2-1/2 GR 5', 'X', '73181500', 8.25, 300.00, 100.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1753, '228104212-0200', 'HHB5/16UNCX2-3/4 GR 5', 'X', '73181500', 9.15, 300.00, 100.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1754, '228104300-0200', 'HHB5/16UNCX3 GR 5', 'X', '73181500', 9.65, 400.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1755, '228104304-0200', 'HHB5/16UNCX3-1/4 GR 5', 'X', '73181500', 9.75, 400.00, 100.00, 5.020, 48.50, 4.73, 11.70, 9.00, 0.45, 9.00, 0.45, 18.00, 0.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(1756, '228104308-0200', 'HHB5/16UNCX3-1/2 GR 5', 'X', '73181500', 10.45, 400.00, 100.00, 5.380, 48.50, 5.07, 12.54, 9.00, 0.48, 9.00, 0.48, 18.00, 0.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1757, '228104312-0200', 'HHB5/16UNCX3-3/4 GR 5', 'X', '73181500', 14.45, 100.00, 100.00, 7.440, 48.50, 7.01, 17.34, 9.00, 0.67, 9.00, 0.67, 18.00, 1.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1758, '228104400-0200', 'HHB5/16UNCX4 GR 5', 'X', '73181500', 15.25, 400.00, 100.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1759, '228104404-0200', 'HHB5/16UNCX4-1/4 GR 5', 'X', '73181500', 15.70, 50.00, 50.00, 8.090, 48.50, 7.61, 18.84, 9.00, 0.73, 9.00, 0.73, 18.00, 1.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1760, '228104408-0200', 'HHB5/16UNCX4-1/2 GR 5', 'X', '73181500', 16.55, 150.00, 50.00, 8.520, 48.50, 8.03, 19.86, 9.00, 0.77, 9.00, 0.77, 18.00, 1.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1761, '228104412-0200', 'HHB5/16UNCX4-3/4 GR 5', 'X', '73181500', 17.25, 50.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1762, '228104500-0200', 'HHB5/16UNCX5 GR 5', 'X', '73181500', 18.00, 150.00, 50.00, 9.270, 48.50, 8.73, 21.60, 9.00, 0.83, 9.00, 0.83, 18.00, 1.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1763, '228105104-0200', 'HHB5/16UNFX1-1/4 GR 5', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1764, '228105106-0200', 'HHB5/16UNFX1-3/8 GR 5', 'X', '73181500', 6.05, 200.00, 200.00, 3.120, 48.50, 2.93, 7.26, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1765, '228105108-0200', 'HHB5/16UNFX1-1/2 GR 5', 'X', '73181500', 6.30, 600.00, 200.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1766, '228105110-0200', 'HHB5/16UNFX1-5/8 GR 5', 'X', '73181500', 6.65, 100.00, 100.00, 3.420, 48.50, 3.23, 7.98, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1767, '228105112-0200', 'HHB5/16UNFX1-3/4 GR 5', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1768, '228105200-0200', 'HHB5/16UNFX2 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1769, '228105204-0200', 'HHB5/16UNFX2-1/4 GR 5', 'X', '73181500', 7.85, 400.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1770, '228105208-0200', 'HHB5/16UNFX2-1/2 GR 5', 'X', '73181500', 8.25, 300.00, 100.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1771, '228105212-0200', 'HHB5/16UNFX2-3/4 GR 5', 'X', '73181500', 9.15, 300.00, 100.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1772, '228105300-0200', 'HHB5/16UNFX3 GR 5', 'X', '73181500', 9.65, 400.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1773, '228105304-0200', 'HHB5/16UNFX3-1/4 GR 5', 'X', '73181500', 9.75, 400.00, 100.00, 5.020, 48.50, 4.73, 11.70, 9.00, 0.45, 9.00, 0.45, 18.00, 0.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1774, '228105308-0200', 'HHB5/16UNFX3-1/2 GR 5', 'X', '73181500', 10.45, 400.00, 100.00, 5.380, 48.50, 5.07, 12.54, 9.00, 0.48, 9.00, 0.48, 18.00, 0.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1775, '228105312-0200', 'HHB5/16UNFX3-3/4 GR 5', 'X', '73181500', 14.45, 100.00, 100.00, 7.440, 48.50, 7.01, 17.34, 9.00, 0.67, 9.00, 0.67, 18.00, 1.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1776, '228105400-0200', 'HHB5/16UNFX4 GR 5', 'X', '73181500', 15.25, 400.00, 100.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1777, '228105404-0200', 'HHB5/16UNFX4-1/4 GR 5', 'X', '73181500', 15.70, 150.00, 50.00, 8.090, 48.50, 7.61, 18.84, 9.00, 0.73, 9.00, 0.73, 18.00, 1.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1778, '228105408-0200', 'HHB5/16UNFX4-1/2 GR 5', 'X', '73181500', 16.55, 150.00, 50.00, 8.520, 48.50, 8.03, 19.86, 9.00, 0.77, 9.00, 0.77, 18.00, 1.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1779, '228105500-0200', 'HHB5/16UNFX5 GR 5', 'X', '73181500', 18.00, 150.00, 50.00, 9.270, 48.50, 8.73, 21.60, 9.00, 0.83, 9.00, 0.83, 18.00, 1.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1780, '228124104-0200', 'HHB3/8UNCX1-1/4 GR 5', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1781, '228124106-0200', 'HHB3/8UNCX1-3/8 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1782, '228124108-0200', 'HHB3/8UNCX1-1/2 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1783, '228124110-0200', 'HHB3/8UNCX1-5/8 GR 5', 'X', '73181500', 8.95, 400.00, 100.00, 4.610, 48.50, 4.34, 10.74, 9.00, 0.41, 9.00, 0.41, 18.00, 0.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1784, '228124112-0200', 'HHB3/8UNCX1-3/4 GR 5', 'X', '73181500', 8.50, 300.00, 100.00, 4.380, 48.50, 4.12, 10.20, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1785, '228124114-0200', 'HHB3/8UNCX1-7/8 GR 5', 'X', '73181500', 9.75, 300.00, 100.00, 5.020, 48.50, 4.73, 11.70, 9.00, 0.45, 9.00, 0.45, 18.00, 0.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1786, '228124200-0200', 'HHB3/8UNCX2 GR 5', 'X', '73181500', 9.25, 300.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1787, '228124204-0200', 'HHB3/8UNCX2-1/4 GR 5', 'X', '73181500', 9.65, 400.00, 50.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1788, '228124208-0200', 'HHB3/8UNCX2-1/2 GR 5', 'X', '73181500', 10.65, 400.00, 50.00, 5.480, 48.50, 5.17, 12.78, 9.00, 0.49, 9.00, 0.49, 18.00, 0.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1789, '228124210-0200', 'HHB3/8UNCX2-5/8 GR 5', 'X', '73181500', 11.65, 50.00, 50.00, 6.000, 48.50, 5.65, 13.98, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1790, '228124212-0200', 'HHB3/8UNCX2-3/4 GR 5', 'X', '73181500', 11.65, 200.00, 50.00, 6.000, 48.50, 5.65, 13.98, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1791, '228124300-0200', 'HHB3/8UNCX3 GR 5', 'X', '73181500', 12.30, 200.00, 50.00, 6.330, 48.50, 5.97, 14.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1792, '228124304-0200', 'HHB3/8UNCX3-1/4 GR 5', 'X', '73181500', 13.10, 200.00, 50.00, 6.750, 48.50, 6.35, 15.72, 9.00, 0.61, 9.00, 0.61, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1793, '228124308-0200', 'HHB3/8UNCX3-1/2 GR 5', 'X', '73181500', 13.90, 300.00, 50.00, 7.160, 48.50, 6.74, 16.68, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1794, '228124312-0200', 'HHB3/8UNCX3-3/4 GR 5', 'X', '73181500', 18.00, 150.00, 50.00, 9.270, 48.50, 8.73, 21.60, 9.00, 0.83, 9.00, 0.83, 18.00, 1.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1795, '228124400-0200', 'HHB3/8UNCX4 GR 5', 'X', '73181500', 19.10, 150.00, 50.00, 9.840, 48.50, 9.26, 22.92, 9.00, 0.89, 9.00, 0.89, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1796, '228124404-0200', 'HHB3/8UNCX4-1/4 GR 5', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1797, '228124408-0200', 'HHB3/8UNCX4-1/2 GR 5', 'X', '73181500', 19.60, 150.00, 50.00, 10.090, 48.50, 9.51, 23.52, 9.00, 0.91, 9.00, 0.91, 18.00, 1.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1798, '228124412-0200', 'HHB3/8UNCX4-3/4 GR 5', 'X', '73181500', 20.20, 150.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1799, '228124500-0200', 'HHB3/8UNCX5 GR 5', 'X', '73181500', 20.95, 200.00, 50.00, 10.790, 48.50, 10.16, 25.14, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1800, '228124504-0200', 'HHB3/8UNCX5-1/4 GR 5', 'X', '73181500', 32.20, 200.00, 50.00, 16.580, 48.50, 15.62, 38.64, 9.00, 1.49, 9.00, 1.49, 18.00, 2.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1801, '228124508-0200', 'HHB3/8UNCX5-1/2 GR 5', 'X', '73181500', 33.75, 200.00, 50.00, 17.380, 48.50, 16.37, 40.50, 9.00, 1.56, 9.00, 1.56, 18.00, 3.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1802, '228124512-0200', 'HHB3/8UNCX5-3/4 GR 5', 'X', '73181500', 36.70, 50.00, 50.00, 18.900, 48.50, 17.80, 44.04, 9.00, 1.70, 9.00, 1.70, 18.00, 3.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1803, '228124600-0200', 'HHB3/8UNCX6 GR 5', 'X', '73181500', 38.25, 200.00, 50.00, 19.700, 48.50, 18.55, 45.90, 9.00, 1.77, 9.00, 1.77, 18.00, 3.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1804, '228125104-0200', 'HHB3/8UNFX1-1/4 GR 5', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1805, '228125106-0200', 'HHB3/8UNFX1-3/8 GR 5', 'X', '73181500', 7.70, 100.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1806, '228125108-0200', 'HHB3/8UNFX1-1/2 GR 5', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1807, '228125110-0200', 'HHB3/8UNFX1-5/8 GR 5', 'X', '73181500', 8.95, 400.00, 100.00, 4.610, 48.50, 4.34, 10.74, 9.00, 0.41, 9.00, 0.41, 18.00, 0.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1808, '228125112-0200', 'HHB3/8UNFX1-3/4 GR 5', 'X', '73181500', 8.50, 300.00, 100.00, 4.380, 48.50, 4.12, 10.20, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1809, '228125114-0200', 'HHB3/8UNFX1-7/8 GR 5', 'X', '73181500', 9.75, 100.00, 100.00, 5.020, 48.50, 4.73, 11.70, 9.00, 0.45, 9.00, 0.45, 18.00, 0.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1810, '228125200-0200', 'HHB3/8UNFX2 GR 5', 'X', '73181500', 9.25, 300.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1811, '228125204-0200', 'HHB3/8UNFX2-1/4 GR 5', 'X', '73181500', 9.65, 200.00, 50.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1812, '228125208-0200', 'HHB3/8UNFX2-1/2 GR 5', 'X', '73181500', 10.65, 400.00, 50.00, 5.480, 48.50, 5.17, 12.78, 9.00, 0.49, 9.00, 0.49, 18.00, 0.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1813, '228125212-0200', 'HHB3/8UNFX2-3/4 GR 5', 'X', '73181500', 11.65, 200.00, 50.00, 6.000, 48.50, 5.65, 13.98, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1814, '228125300-0200', 'HHB3/8UNFX3 GR 5', 'X', '73181500', 12.30, 200.00, 50.00, 6.330, 48.50, 5.97, 14.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1815, '228125304-0200', 'HHB3/8UNFX3-1/4 GR 5', 'X', '73181500', 13.10, 200.00, 50.00, 6.750, 48.50, 6.35, 15.72, 9.00, 0.61, 9.00, 0.61, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1816, '228125308-0200', 'HHB3/8UNFX3-1/2 GR 5', 'X', '73181500', 13.90, 150.00, 50.00, 7.160, 48.50, 6.74, 16.68, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1817, '228125312-0200', 'HHB3/8UNFX3-3/4 GR 5', 'X', '73181500', 18.00, 50.00, 50.00, 9.270, 48.50, 8.73, 21.60, 9.00, 0.83, 9.00, 0.83, 18.00, 1.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1818, '228125400-0200', 'HHB3/8UNFX4 GR 5', 'X', '73181500', 19.10, 150.00, 50.00, 9.840, 48.50, 9.26, 22.92, 9.00, 0.89, 9.00, 0.89, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1819, '228125404-0200', 'HHB3/8UNFX4-1/4 GR 5', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1820, '228125408-0200', 'HHB3/8UNFX4-1/2 GR 5', 'X', '73181500', 19.60, 150.00, 50.00, 10.090, 48.50, 9.51, 23.52, 9.00, 0.91, 9.00, 0.91, 18.00, 1.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1821, '228125412-0200', 'HHB3/8UNFX4-3/4 GR 5', 'X', '73181500', 20.20, 50.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1822, '228125500-0200', 'HHB3/8UNFX5 GR 5', 'X', '73181500', 20.95, 100.00, 50.00, 10.790, 48.50, 10.16, 25.14, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1823, '228125508-0200', 'HHB3/8UNFX5-1/2 GR 5', 'X', '73181500', 33.75, 50.00, 50.00, 17.380, 48.50, 16.37, 40.50, 9.00, 1.56, 9.00, 1.56, 18.00, 3.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1824, '228144108-0200', 'HHB7/16UNCX1-1/2 GR 5', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1825, '228144110-0200', 'HHB7/16UNCX1-5/8 GR 5', 'X', '73181500', 12.15, 100.00, 100.00, 6.260, 48.50, 5.89, 14.58, 9.00, 0.56, 9.00, 0.56, 18.00, 1.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1826, '228144112-0200', 'HHB7/16UNCX1-3/4 GR 5', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1827, '228144114-0200', 'HHB7/16UNCX1-7/8 GR 5', 'X', '73181500', 13.00, 400.00, 100.00, 6.700, 48.50, 6.31, 15.60, 9.00, 0.60, 9.00, 0.60, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1828, '228144200-0200', 'HHB7/16UNCX2 GR 5', 'X', '73181500', 12.75, 400.00, 50.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1829, '228144204-0200', 'HHB7/16UNCX2-1/4 GR 5', 'X', '73181500', 13.90, 200.00, 50.00, 7.160, 48.50, 6.74, 16.68, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1830, '228144208-0200', 'HHB7/16UNCX2-1/2 GR 5', 'X', '73181500', 15.00, 150.00, 50.00, 7.730, 48.50, 7.28, 18.00, 9.00, 0.70, 9.00, 0.70, 18.00, 1.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1831, '228144210-0200', 'HHB7/16UNCX2-5/8 GR 5', 'X', '73181500', 16.20, 100.00, 100.00, 8.340, 48.50, 7.86, 19.44, 9.00, 0.75, 9.00, 0.75, 18.00, 1.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1832, '228144212-0200', 'HHB7/16UNCX2-3/4 GR 5', 'X', '73181500', 16.20, 150.00, 50.00, 8.340, 48.50, 7.86, 19.44, 9.00, 0.75, 9.00, 0.75, 18.00, 1.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1833, '228144214-0200', 'HHB7/16UNCX2-7/8 GR 5', 'X', '73181500', 17.35, 100.00, 100.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1834, '228144300-0200', 'HHB7/16UNCX3 GR 5', 'X', '73181500', 17.35, 150.00, 50.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1835, '228144304-0200', 'HHB7/16UNCX3-1/4 GR 5', 'X', '73181500', 18.70, 80.00, 20.00, 9.630, 48.50, 9.07, 22.44, 9.00, 0.87, 9.00, 0.87, 18.00, 1.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1836, '228144308-0200', 'HHB7/16UNCX3-1/2 GR 5', 'X', '73181500', 19.10, 80.00, 20.00, 9.840, 48.50, 9.26, 22.92, 9.00, 0.89, 9.00, 0.89, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1837, '228144312-0200', 'HHB7/16UNCX3-3/4 GR 5', 'X', '73181500', 22.55, 80.00, 20.00, 11.610, 48.50, 10.94, 27.06, 9.00, 1.05, 9.00, 1.05, 18.00, 2.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1838, '228144400-0200', 'HHB7/16UNCX4 GR 5', 'X', '73181500', 24.70, 80.00, 20.00, 12.720, 48.50, 11.98, 29.64, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1839, '228144402-0200', 'HHB7/16UNCX4-1/8 GR 5', 'X', '73181500', 28.05, 20.00, 20.00, 14.450, 48.50, 13.60, 33.66, 9.00, 1.30, 9.00, 1.30, 18.00, 2.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1840, '228144404-0200', 'HHB7/16UNCX4-1/4 GR 5', 'X', '73181500', 26.85, 80.00, 20.00, 13.830, 48.50, 13.02, 32.22, 9.00, 1.24, 9.00, 1.24, 18.00, 2.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1841, '228144406-0200', 'HHB7/16UNCX4-3/8 GR 5', 'X', '73181500', 28.70, 20.00, 20.00, 14.780, 48.50, 13.92, 34.44, 9.00, 1.33, 9.00, 1.33, 18.00, 2.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1842, '228144408-0200', 'HHB7/16UNCX4-1/2 GR 5', 'X', '73181500', 27.40, 60.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1843, '228144412-0200', 'HHB7/16UNCX4-3/4 GR 5', 'X', '73181500', 27.40, 80.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1844, '228144500-0200', 'HHB7/16UNCX5 GR 5', 'X', '73181500', 30.75, 60.00, 20.00, 15.840, 48.50, 14.91, 36.90, 9.00, 1.43, 9.00, 1.43, 18.00, 2.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1845, '228144508-0200', 'HHB7/16UNCX5-1/2 GR 5', 'X', '73181500', 42.00, 80.00, 20.00, 21.630, 48.50, 20.37, 50.40, 9.00, 1.95, 9.00, 1.95, 18.00, 3.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1846, '228145108-0200', 'HHB7/16UNFX1-1/2 GR 5', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1847, '228145110-0200', 'HHB7/16UNFX1-5/8 GR 5', 'X', '73181500', 12.15, 300.00, 100.00, 6.260, 48.50, 5.89, 14.58, 9.00, 0.56, 9.00, 0.56, 18.00, 1.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1848, '228145112-0200', 'HHB7/16UNFX1-3/4 GR 5', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1849, '228145200-0200', 'HHB7/16UNFX2 GR 5', 'X', '73181500', 12.75, 400.00, 50.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1850, '228145202-0200', 'HHB7/16UNFX2-1/8 GR 5', 'X', '73181500', 13.90, 50.00, 50.00, 7.160, 48.50, 6.74, 16.68, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1851, '228145204-0200', 'HHB7/16UNFX2-1/4 GR 5', 'X', '73181500', 13.90, 200.00, 50.00, 7.160, 48.50, 6.74, 16.68, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1852, '228145208-0200', 'HHB7/16UNFX2-1/2 GR 5', 'X', '73181500', 15.00, 150.00, 50.00, 7.730, 48.50, 7.28, 18.00, 9.00, 0.70, 9.00, 0.70, 18.00, 1.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1853, '228145210-0200', 'HHB7/16UNFX2-5/8 GR 5', 'X', '73181500', 16.20, 20.00, 20.00, 8.340, 48.50, 7.86, 19.44, 9.00, 0.75, 9.00, 0.75, 18.00, 1.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1854, '228145212-0200', 'HHB7/16UNFX2-3/4 GR 5', 'X', '73181500', 16.20, 150.00, 50.00, 8.340, 48.50, 7.86, 19.44, 9.00, 0.75, 9.00, 0.75, 18.00, 1.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1855, '228145300-0200', 'HHB7/16UNFX3 GR 5', 'X', '73181500', 17.35, 150.00, 50.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1856, '228145304-0200', 'HHB7/16UNFX3-1/4 GR 5', 'X', '73181500', 18.70, 80.00, 20.00, 9.630, 48.50, 9.07, 22.44, 9.00, 0.87, 9.00, 0.87, 18.00, 1.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1857, '228145308-0200', 'HHB7/16UNFX3-1/2 GR 5', 'X', '73181500', 19.10, 80.00, 20.00, 9.840, 48.50, 9.26, 22.92, 9.00, 0.89, 9.00, 0.89, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1858, '228145312-0200', 'HHB7/16UNFX3-3/4 GR 5', 'X', '73181500', 22.55, 80.00, 20.00, 11.610, 48.50, 10.94, 27.06, 9.00, 1.05, 9.00, 1.05, 18.00, 2.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1859, '228145400-0200', 'HHB7/16UNFX4 GR 5', 'X', '73181500', 24.70, 80.00, 20.00, 12.720, 48.50, 11.98, 29.64, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1860, '228145404-0200', 'HHB7/16UNFX4-1/4 GR 5', 'X', '73181500', 26.85, 20.00, 20.00, 13.830, 48.50, 13.02, 32.22, 9.00, 1.24, 9.00, 1.24, 18.00, 2.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1861, '228145408-0200', 'HHB7/16UNFX4-1/2 GR 5', 'X', '73181500', 27.40, 80.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1862, '228145412-0200', 'HHB7/16UNFX4-3/4 GR 5', 'X', '73181500', 27.40, 20.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1863, '228145500-0200', 'HHB7/16UNFX5 GR 5', 'X', '73181500', 30.75, 80.00, 20.00, 15.840, 48.50, 14.91, 36.90, 9.00, 1.43, 9.00, 1.43, 18.00, 2.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1864, '228164110-0200', 'HHB1/2UNCX1-5/8 GR 5', 'X', '73181500', 17.85, 150.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1865, '228164112-0200', 'HHB1/2UNCX1-3/4 GR 5', 'X', '73181500', 17.25, 150.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1866, '228164114-0200', 'HHB1/2UNCX1-7/8 GR 5', 'X', '73181500', 19.60, 150.00, 50.00, 10.090, 48.50, 9.51, 23.52, 9.00, 0.91, 9.00, 0.91, 18.00, 1.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1867, '228164200-0200', 'HHB1/2UNCX2 GR 5', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1868, '228164204-0200', 'HHB1/2UNCX2-1/4 GR 5', 'X', '73181500', 19.85, 200.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1869, '228164208-0200', 'HHB1/2UNCX2-1/2 GR 5', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1870, '228164212-0200', 'HHB1/2UNCX2-3/4 GR 5', 'X', '73181500', 20.50, 120.00, 20.00, 10.560, 48.50, 9.94, 24.60, 9.00, 0.95, 9.00, 0.95, 18.00, 1.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1871, '228164300-0200', 'HHB1/2UNCX3 GR 5', 'X', '73181500', 22.35, 160.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1872, '228164304-0200', 'HHB1/2UNCX3-1/4 GR 5', 'X', '73181500', 24.70, 80.00, 20.00, 12.720, 48.50, 11.98, 29.64, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1873, '228164308-0200', 'HHB1/2UNCX3-1/2 GR 5', 'X', '73181500', 24.90, 160.00, 20.00, 12.820, 48.50, 12.08, 29.88, 9.00, 1.15, 9.00, 1.15, 18.00, 2.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1874, '228164312-0200', 'HHB1/2UNCX3-3/4 GR 5', 'X', '73181500', 27.85, 80.00, 20.00, 14.340, 48.50, 13.51, 33.42, 9.00, 1.29, 9.00, 1.29, 18.00, 2.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1875, '228164400-0200', 'HHB1/2UNCX4 GR 5', 'X', '73181500', 28.15, 80.00, 20.00, 14.500, 48.50, 13.65, 33.78, 9.00, 1.30, 9.00, 1.30, 18.00, 2.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1876, '228164404-0200', 'HHB1/2UNCX4-1/4 GR 5', 'X', '73181500', 30.05, 80.00, 20.00, 15.480, 48.50, 14.57, 36.06, 9.00, 1.39, 9.00, 1.39, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1877, '228164408-0200', 'HHB1/2UNCX4-1/2 GR 5', 'X', '73181500', 32.55, 80.00, 20.00, 16.760, 48.50, 15.79, 39.06, 9.00, 1.51, 9.00, 1.51, 18.00, 3.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1878, '228164412-0200', 'HHB1/2UNCX4-3/4 GR 5', 'X', '73181500', 36.60, 60.00, 20.00, 18.850, 48.50, 17.75, 43.92, 9.00, 1.70, 9.00, 1.70, 18.00, 3.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1879, '228164500-0200', 'HHB1/2UNCX5 GR 5', 'X', '73181500', 34.65, 60.00, 20.00, 17.840, 48.50, 16.81, 41.58, 9.00, 1.61, 9.00, 1.61, 18.00, 3.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1880, '228164504-0200', 'HHB1/2UNCX5-1/4 GR 5', 'X', '73181500', 51.45, 20.00, 20.00, 26.500, 48.50, 24.95, 61.74, 9.00, 2.38, 9.00, 2.38, 18.00, 4.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1881, '228164508-0200', 'HHB1/2UNCX5-1/2 GR 5', 'X', '73181500', 57.10, 60.00, 20.00, 29.410, 48.50, 27.69, 68.52, 9.00, 2.65, 9.00, 2.65, 18.00, 5.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1882, '228164512-0200', 'HHB1/2UNCX5-3/4 GR 5', 'X', '73181500', 63.30, 80.00, 20.00, 32.600, 48.50, 30.70, 75.96, 9.00, 2.93, 9.00, 2.93, 18.00, 5.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1883, '228164600-0200', 'HHB1/2UNCX6 GR 5', 'X', '73181500', 69.80, 40.00, 20.00, 35.950, 48.50, 33.85, 83.76, 9.00, 3.24, 9.00, 3.24, 18.00, 6.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1884, '228164604-0200', 'HHB1/2UNCX6-1/4 GR 5', 'X', '73181500', 71.05, 20.00, 20.00, 36.590, 48.50, 34.46, 85.26, 9.00, 3.29, 9.00, 3.29, 18.00, 6.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1885, '228164608-0200', 'HHB1/2UNCX6-1/2 GR 5', 'X', '73181500', 72.45, 100.00, 20.00, 37.310, 48.50, 35.14, 86.94, 9.00, 3.36, 9.00, 3.36, 18.00, 6.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1886, '228164700-0200', 'HHB1/2UNCX7 GR 5', 'X', '73181500', 77.00, 100.00, 20.00, 39.660, 48.50, 37.35, 92.40, 9.00, 3.57, 9.00, 3.57, 18.00, 7.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1887, '228164708-0200', 'HHB1/2UNCX7-1/2 GR 5', 'X', '73181500', 83.20, 100.00, 20.00, 42.850, 48.50, 40.35, 99.84, 9.00, 3.86, 9.00, 3.86, 18.00, 7.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1888, '228164800-0200', 'HHB1/2UNCX8 GR 5', 'X', '73181500', 86.65, 100.00, 20.00, 44.620, 48.50, 42.03, 103.98, 9.00, 4.02, 9.00, 4.02, 18.00, 8.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1889, '228165112-0200', 'HHB1/2UNFX1-3/4 GR 5', 'X', '73181500', 17.25, 150.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1890, '228165114-0200', 'HHB1/2UNFX1-7/8 GR 5', 'X', '73181500', 19.60, 150.00, 50.00, 10.090, 48.50, 9.51, 23.52, 9.00, 0.91, 9.00, 0.91, 18.00, 1.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1891, '228165200-0200', 'HHB1/2UNFX2 GR 5', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1892, '228165204-0200', 'HHB1/2UNFX2-1/4 GR 5', 'X', '73181500', 19.85, 200.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1893, '228165208-0200', 'HHB1/2UNFX2-1/2 GR 5', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1894, '228165212-0200', 'HHB1/2UNFX2-3/4 GR 5', 'X', '73181500', 20.50, 120.00, 20.00, 10.560, 48.50, 9.94, 24.60, 9.00, 0.95, 9.00, 0.95, 18.00, 1.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1895, '228165300-0200', 'HHB1/2UNFX3 GR 5', 'X', '73181500', 22.35, 80.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1896, '228165304-0200', 'HHB1/2UNFX3-1/4 GR 5', 'X', '73181500', 22.35, 20.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1897, '228165308-0200', 'HHB1/2UNFX3-1/2 GR 5', 'X', '73181500', 24.90, 80.00, 20.00, 12.820, 48.50, 12.08, 29.88, 9.00, 1.15, 9.00, 1.15, 18.00, 2.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1898, '228165312-0200', 'HHB1/2UNFX3-3/4 GR 5', 'X', '73181500', 27.85, 20.00, 20.00, 14.340, 48.50, 13.51, 33.42, 9.00, 1.29, 9.00, 1.29, 18.00, 2.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1899, '228165400-0200', 'HHB1/2UNFX4 GR 5', 'X', '73181500', 28.15, 80.00, 20.00, 14.500, 48.50, 13.65, 33.78, 9.00, 1.30, 9.00, 1.30, 18.00, 2.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1900, '228165404-0200', 'HHB1/2UNFX4-1/4 GR 5', 'X', '73181500', 30.05, 80.00, 20.00, 15.480, 48.50, 14.57, 36.06, 9.00, 1.39, 9.00, 1.39, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1901, '228165408-0200', 'HHB1/2UNFX4-1/2 GR 5', 'X', '73181500', 32.55, 80.00, 20.00, 16.760, 48.50, 15.79, 39.06, 9.00, 1.51, 9.00, 1.51, 18.00, 3.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1902, '228165412-0200', 'HHB1/2UNFX4-3/4 GR 5', 'X', '73181500', 36.60, 20.00, 20.00, 18.850, 48.50, 17.75, 43.92, 9.00, 1.70, 9.00, 1.70, 18.00, 3.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1903, '228165500-0200', 'HHB1/2UNFX5 GR 5', 'X', '73181500', 34.65, 60.00, 20.00, 17.840, 48.50, 16.81, 41.58, 9.00, 1.61, 9.00, 1.61, 18.00, 3.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1904, '228165504-0200', 'HHB1/2UNCX5-1/4 GR 5', 'X', '73181500', 51.45, 0.00, 0.00, 26.500, 48.50, 24.95, 61.74, 9.00, 2.38, 9.00, 2.38, 18.00, 4.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1905, '228165508-0200', 'HHB1/2UNFX5-1/2 GR 5', 'X', '73181500', 57.10, 60.00, 20.00, 29.410, 48.50, 27.69, 68.52, 9.00, 2.65, 9.00, 2.65, 18.00, 5.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1906, '228165600-0200', 'HHB1/2UNFX6 GR 5', 'X', '73181500', 69.80, 60.00, 20.00, 35.950, 48.50, 33.85, 83.76, 9.00, 3.24, 9.00, 3.24, 18.00, 6.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1907, '228165608-0200', 'HHB1/2UNFX6-1/2 GR 5', 'X', '73181500', 72.45, 20.00, 20.00, 37.310, 48.50, 35.14, 86.94, 9.00, 3.36, 9.00, 3.36, 18.00, 6.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1908, '228184200-0200', 'HHB9/16UNCX2 GR 5', 'X', '73181500', 21.85, 200.00, 50.00, 11.250, 48.50, 10.60, 26.22, 9.00, 1.01, 9.00, 1.01, 18.00, 2.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1909, '228184208-0200', 'HHB9/16UNCX2-1/2 GR 5', 'X', '73181500', 31.10, 80.00, 20.00, 16.020, 48.50, 15.08, 37.32, 9.00, 1.44, 9.00, 1.44, 18.00, 2.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1910, '228184304-0200', 'HHB9/16UNCX3-1/4 GR 5', 'X', '73181500', 39.20, 20.00, 20.00, 20.190, 48.50, 19.01, 47.04, 9.00, 1.82, 9.00, 1.82, 18.00, 3.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1911, '228184308-0200', 'HHB9/16UNCX3-1/2 GR 5', 'X', '73181500', 39.20, 20.00, 20.00, 20.190, 48.50, 19.01, 47.04, 9.00, 1.82, 9.00, 1.82, 18.00, 3.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1912, '228185200-0200', 'HHB9/16UNFX2 GR 5', 'X', '73181500', 21.85, 20.00, 20.00, 11.250, 48.50, 10.60, 26.22, 9.00, 1.01, 9.00, 1.01, 18.00, 2.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1913, '228185308-0200', 'HHB9/16UNFX3-1/2 GR 5', 'X', '73181500', 39.20, 0.00, 0.00, 20.190, 48.50, 19.01, 47.04, 9.00, 1.82, 9.00, 1.82, 18.00, 3.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1914, '228204112-0200', 'HHB5/8UNCX1-3/4 GR 5', 'X', '73181500', 31.20, 80.00, 20.00, 16.070, 48.50, 15.13, 37.44, 9.00, 1.45, 9.00, 1.45, 18.00, 2.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1915, '228204200-0200', 'HHB5/8UNCX2 GR 5', 'X', '73181500', 32.70, 160.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1916, '228204204-0200', 'HHB5/8UNCX2-1/4 GR 5', 'X', '73181500', 34.55, 80.00, 20.00, 17.790, 48.50, 16.76, 41.46, 9.00, 1.60, 9.00, 1.60, 18.00, 3.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1917, '228204208-0200', 'HHB5/8UNCX2-1/2 GR 5', 'X', '73181500', 37.95, 80.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1918, '228204212-0200', 'HHB5/8UNCX2-3/4 GR 5', 'X', '73181500', 41.05, 60.00, 20.00, 21.140, 48.50, 19.91, 49.26, 9.00, 1.90, 9.00, 1.90, 18.00, 3.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1919, '228204300-0200', 'HHB5/8UNCX3 GR 5', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1920, '228204304-0200', 'HHB5/8UNCX3-1/4 GR 5', 'X', '73181500', 46.95, 40.00, 10.00, 24.180, 48.50, 22.77, 56.34, 9.00, 2.18, 9.00, 2.18, 18.00, 4.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1921, '228204308-0200', 'HHB5/8UNCX3-1/2 GR 5', 'X', '73181500', 50.90, 80.00, 10.00, 26.210, 48.50, 24.69, 61.08, 9.00, 2.36, 9.00, 2.36, 18.00, 4.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1922, '228204312-0200', 'HHB5/8UNCX3-3/4 GR 5', 'X', '73181500', 52.80, 40.00, 10.00, 27.190, 48.50, 25.61, 63.36, 9.00, 2.45, 9.00, 2.45, 18.00, 4.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1923, '228204400-0200', 'HHB5/8UNCX4 GR 5', 'X', '73181500', 57.65, 80.00, 10.00, 29.690, 48.50, 27.96, 69.18, 9.00, 2.67, 9.00, 2.67, 18.00, 5.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1924, '228204404-0200', 'HHB5/8UNCX4-1/4 GR 5', 'X', '73181500', 59.85, 10.00, 10.00, 30.820, 48.50, 29.03, 71.82, 9.00, 2.77, 9.00, 2.77, 18.00, 5.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1925, '228204408-0200', 'HHB5/8UNCX4-1/2 GR 5', 'X', '73181500', 62.05, 30.00, 10.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1926, '228204412-0200', 'HHB5/8UNCX4-3/4 GR 5', 'X', '73181500', 69.20, 20.00, 20.00, 35.640, 48.50, 33.56, 83.04, 9.00, 3.21, 9.00, 3.21, 18.00, 6.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1927, '228204500-0200', 'HHB5/8UNCX5 GR 5', 'X', '73181500', 69.90, 30.00, 10.00, 36.000, 48.50, 33.90, 83.88, 9.00, 3.24, 9.00, 3.24, 18.00, 6.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1928, '228204504-0200', 'HHB5/8UNCX5-1/4 GR 5', 'X', '73181500', 77.20, 10.00, 10.00, 39.760, 48.50, 37.44, 92.64, 9.00, 3.58, 9.00, 3.58, 18.00, 7.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1929, '228204508-0200', 'HHB5/8UNCX5-1/2 GR 5', 'X', '73181500', 80.25, 30.00, 10.00, 41.330, 48.50, 38.92, 96.30, 9.00, 3.72, 9.00, 3.72, 18.00, 7.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1930, '228204512-0200', 'HHB5/8UNCX5-3/4 GR 5', 'X', '73181500', 81.50, 10.00, 10.00, 41.970, 48.50, 39.53, 97.80, 9.00, 3.78, 9.00, 3.78, 18.00, 7.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1931, '228204600-0200', 'HHB5/8UNCX6 GR 5', 'X', '73181500', 82.40, 80.00, 20.00, 42.440, 48.50, 39.96, 98.88, 9.00, 3.82, 9.00, 3.82, 18.00, 7.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1932, '228204604-0200', 'HHB5/8UNCX6-1/4 GR 5', 'X', '73181500', 91.35, 10.00, 10.00, 47.050, 48.50, 44.30, 109.62, 9.00, 4.23, 9.00, 4.23, 18.00, 8.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1933, '228204608-0200', 'HHB5/8UNCX6-1/2 GR 5', 'X', '73181500', 93.70, 40.00, 10.00, 48.260, 48.50, 45.44, 112.44, 9.00, 4.34, 9.00, 4.34, 18.00, 8.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1934, '228204700-0200', 'HHB5/8UNCX7 GR 5', 'X', '73181500', 98.00, 50.00, 10.00, 50.470, 48.50, 47.53, 117.60, 9.00, 4.54, 9.00, 4.54, 18.00, 9.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1935, '228204708-0200', 'HHB5/8UNCX7-1/2 GR 5', 'X', '73181500', 102.40, 10.00, 10.00, 52.740, 48.50, 49.66, 122.88, 9.00, 4.75, 9.00, 4.75, 18.00, 9.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1936, '228204800-0200', 'HHB5/8UNCX8 GR 5', 'X', '73181500', 106.90, 50.00, 10.00, 55.050, 48.50, 51.85, 128.28, 9.00, 4.95, 9.00, 4.95, 18.00, 9.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1937, '228205200-0200', 'HHB5/8UNFX2 GR 5', 'X', '73181500', 32.70, 80.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1938, '228205204-0200', 'HHB5/8UNFX2-1/4 GR 5', 'X', '73181500', 34.55, 80.00, 20.00, 17.790, 48.50, 16.76, 41.46, 9.00, 1.60, 9.00, 1.60, 18.00, 3.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1939, '228205208-0200', 'HHB5/8UNFX2-1/2 GR 5', 'X', '73181500', 37.95, 80.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1940, '228205212-0200', 'HHB5/8UNFX2-3/4 GR 5', 'X', '73181500', 41.05, 60.00, 20.00, 21.140, 48.50, 19.91, 49.26, 9.00, 1.90, 9.00, 1.90, 18.00, 3.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1941, '228205300-0200', 'HHB5/8UNFX3 GR 5', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1942, '228205304-0200', 'HHB5/8UNFX3-1/4 GR 5', 'X', '73181500', 46.95, 40.00, 10.00, 24.180, 48.50, 22.77, 56.34, 9.00, 2.18, 9.00, 2.18, 18.00, 4.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1943, '228205308-0200', 'HHB5/8UNFX3-1/2 GR 5', 'X', '73181500', 50.90, 40.00, 10.00, 26.210, 48.50, 24.69, 61.08, 9.00, 2.36, 9.00, 2.36, 18.00, 4.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1944, '228205312-0200', 'HHB5/8UNFX3-3/4 GR 5', 'X', '73181500', 52.80, 10.00, 10.00, 27.190, 48.50, 25.61, 63.36, 9.00, 2.45, 9.00, 2.45, 18.00, 4.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1945, '228205400-0200', 'HHB5/8UNFX4 GR 5', 'X', '73181500', 57.65, 40.00, 10.00, 29.690, 48.50, 27.96, 69.18, 9.00, 2.67, 9.00, 2.67, 18.00, 5.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1946, '228205404-0200', 'HHB5/8UNFX4-1/4 GR 5', 'X', '73181500', 59.85, 30.00, 10.00, 30.820, 48.50, 29.03, 71.82, 9.00, 2.77, 9.00, 2.77, 18.00, 5.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1947, '228205408-0200', 'HHB5/8UNFX4-1/2 GR 5', 'X', '73181500', 62.05, 30.00, 10.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1948, '228205500-0200', 'HHB5/8UNFX5 GR 5', 'X', '73181500', 69.90, 30.00, 10.00, 36.000, 48.50, 33.90, 83.88, 9.00, 3.24, 9.00, 3.24, 18.00, 6.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1949, '228205508-0200', 'HHB5/8UNFX5-1/2 GR 5', 'X', '73181500', 80.25, 30.00, 10.00, 41.330, 48.50, 38.92, 96.30, 9.00, 3.72, 9.00, 3.72, 18.00, 7.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1950, '228205600-0200', 'HHB5/8UNFX6 GR 5', 'X', '73181500', 82.40, 80.00, 20.00, 42.440, 48.50, 39.96, 98.88, 9.00, 3.82, 9.00, 3.82, 18.00, 7.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1951, '228205608-0200', 'HHB5/8UNFX6-1/2 GR 5', 'X', '73181500', 93.70, 10.00, 10.00, 48.260, 48.50, 45.44, 112.44, 9.00, 4.34, 9.00, 4.34, 18.00, 8.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(1952, '228205700-0200', 'HHB5/8UNFX7 GR 5', 'X', '73181500', 98.00, 10.00, 10.00, 50.470, 48.50, 47.53, 117.60, 9.00, 4.54, 9.00, 4.54, 18.00, 9.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1953, '228205800-0200', 'HHB5/8UNFX8 GR 5', 'X', '73181500', 106.90, 10.00, 10.00, 55.050, 48.50, 51.85, 128.28, 9.00, 4.95, 9.00, 4.95, 18.00, 9.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1954, '228244204-0200', 'HHB3/4UNCX2-1/4 GR 5', 'X', '73181500', 65.05, 40.00, 10.00, 33.500, 48.50, 31.55, 78.06, 9.00, 3.02, 9.00, 3.02, 18.00, 6.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1955, '228244208-0200', 'HHB3/4UNCX2-1/2 GR 5', 'X', '73181500', 68.25, 80.00, 10.00, 35.150, 48.50, 33.10, 81.90, 9.00, 3.16, 9.00, 3.16, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1956, '228244212-0200', 'HHB3/4UNCX2-3/4 GR 5', 'X', '73181500', 74.50, 40.00, 10.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1957, '228244300-0200', 'HHB3/4UNCX3 GR 5', 'X', '73181500', 77.35, 80.00, 10.00, 39.840, 48.50, 37.51, 92.82, 9.00, 3.59, 9.00, 3.59, 18.00, 7.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1958, '228244304-0200', 'HHB3/4UNCX3-1/4 GR 5', 'X', '73181500', 82.70, 30.00, 10.00, 42.590, 48.50, 40.11, 99.24, 9.00, 3.83, 9.00, 3.83, 18.00, 7.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1959, '228244308-0200', 'HHB3/4UNCX3-1/2 GR 5', 'X', '73181500', 85.45, 30.00, 10.00, 44.010, 48.50, 41.44, 102.54, 9.00, 3.96, 9.00, 3.96, 18.00, 7.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1960, '228244312-0200', 'HHB3/4UNCX3-3/4 GR 5', 'X', '73181500', 93.10, 30.00, 10.00, 47.950, 48.50, 45.15, 111.72, 9.00, 4.32, 9.00, 4.32, 18.00, 8.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1961, '228244400-0200', 'HHB3/4UNCX4 GR 5', 'X', '73181500', 95.85, 30.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1962, '228244404-0200', 'HHB3/4UNCX4-1/4 GR 5', 'X', '73181500', 99.85, 30.00, 10.00, 51.420, 48.50, 48.43, 119.82, 9.00, 4.63, 9.00, 4.63, 18.00, 9.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1963, '228244408-0200', 'HHB3/4UNCX4-1/2 GR 5', 'X', '73181500', 102.75, 30.00, 10.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1964, '228244412-0200', 'HHB3/4UNCX4-3/4 GR 5', 'X', '73181500', 106.00, 30.00, 10.00, 54.590, 48.50, 51.41, 127.20, 9.00, 4.91, 9.00, 4.91, 18.00, 9.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1965, '228244500-0200', 'HHB3/4UNCX5 GR 5', 'X', '73181500', 109.35, 40.00, 10.00, 56.320, 48.50, 53.03, 131.22, 9.00, 5.07, 9.00, 5.07, 18.00, 10.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1966, '228244504-0200', 'HHB3/4UNCX5-1/4 GR 5', 'X', '73181500', 112.80, 40.00, 10.00, 58.090, 48.50, 54.71, 135.36, 9.00, 5.23, 9.00, 5.23, 18.00, 10.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1967, '228244508-0200', 'HHB3/4UNCX5-1/2 GR 5', 'X', '73181500', 116.55, 40.00, 10.00, 60.020, 48.50, 56.53, 139.86, 9.00, 5.40, 9.00, 5.40, 18.00, 10.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1968, '228244512-0200', 'HHB3/4UNCX5-3/4 GR 5', 'X', '73181500', 121.10, 10.00, 10.00, 62.370, 48.50, 58.73, 145.32, 9.00, 5.61, 9.00, 5.61, 18.00, 11.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1969, '228244600-0200', 'HHB3/4UNCX6 GR 5', 'X', '73181500', 122.75, 40.00, 10.00, 63.220, 48.50, 59.53, 147.30, 9.00, 5.69, 9.00, 5.69, 18.00, 11.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1970, '228244608-0200', 'HHB3/4UNCX6-1/2 GR 5', 'X', '73181500', 129.50, 40.00, 10.00, 66.690, 48.50, 62.81, 155.40, 9.00, 6.00, 9.00, 6.00, 18.00, 12.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1971, '228244700-0200', 'HHB3/4UNCX7 GR 5', 'X', '73181500', 136.15, 40.00, 10.00, 70.120, 48.50, 66.03, 163.38, 9.00, 6.31, 9.00, 6.31, 18.00, 12.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1972, '228244704-0200', 'HHB3/4UNCX7-1/4 GR 5', 'X', '73181500', 139.50, 10.00, 10.00, 71.840, 48.50, 67.66, 167.40, 9.00, 6.47, 9.00, 6.47, 18.00, 12.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1973, '228244708-0200', 'HHB3/4UNCX7-1/2 GR 5', 'X', '73181500', 142.35, 40.00, 10.00, 73.310, 48.50, 69.04, 170.82, 9.00, 6.60, 9.00, 6.60, 18.00, 13.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1974, '228244800-0200', 'HHB3/4UNCX8 GR 5', 'X', '73181500', 149.00, 40.00, 10.00, 76.740, 48.50, 72.27, 178.80, 9.00, 6.91, 9.00, 6.91, 18.00, 13.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1975, '228245204-0200', 'HHB3/4UNFX2-1/4 GR 5', 'X', '73181500', 65.05, 10.00, 10.00, 33.500, 48.50, 31.55, 78.06, 9.00, 3.02, 9.00, 3.02, 18.00, 6.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1976, '228245208-0200', 'HHB3/4UNFX2-1/2 GR 5', 'X', '73181500', 68.25, 40.00, 10.00, 35.150, 48.50, 33.10, 81.90, 9.00, 3.16, 9.00, 3.16, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1977, '228245212-0200', 'HHB3/4UNFX2-3/4 GR 5', 'X', '73181500', 74.50, 10.00, 10.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1978, '228245300-0200', 'HHB3/4UNFX3 GR 5', 'X', '73181500', 77.35, 40.00, 10.00, 39.840, 48.50, 37.51, 92.82, 9.00, 3.59, 9.00, 3.59, 18.00, 7.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1979, '228245304-0200', 'HHB3/4UNFX3-1/4 GR 5', 'X', '73181500', 82.70, 40.00, 10.00, 42.590, 48.50, 40.11, 99.24, 9.00, 3.83, 9.00, 3.83, 18.00, 7.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1980, '228245308-0200', 'HHB3/4UNFX3-1/2 GR 5', 'X', '73181500', 85.45, 30.00, 10.00, 44.010, 48.50, 41.44, 102.54, 9.00, 3.96, 9.00, 3.96, 18.00, 7.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1981, '228245312-0200', 'HHB3/4UNFX3-3/4 GR 5', 'X', '73181500', 93.10, 40.00, 10.00, 47.950, 48.50, 45.15, 111.72, 9.00, 4.32, 9.00, 4.32, 18.00, 8.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1982, '228245400-0200', 'HHB3/4UNFX4 GR 5', 'X', '73181500', 95.85, 30.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1983, '228245404-0200', 'HHB3/4UNFX4-1/4 GR 5', 'X', '73181500', 99.85, 40.00, 10.00, 51.420, 48.50, 48.43, 119.82, 9.00, 4.63, 9.00, 4.63, 18.00, 9.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1984, '228245408-0200', 'HHB3/4UNFX4-1/2 GR 5', 'X', '73181500', 102.75, 30.00, 10.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1985, '228245412-0200', 'HHB3/4UNFX4-3/4 GR 5', 'X', '73181500', 106.00, 30.00, 10.00, 54.590, 48.50, 51.41, 127.20, 9.00, 4.91, 9.00, 4.91, 18.00, 9.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1986, '228245500-0200', 'HHB3/4UNFX5 GR 5', 'X', '73181500', 109.35, 40.00, 10.00, 56.320, 48.50, 53.03, 131.22, 9.00, 5.07, 9.00, 5.07, 18.00, 10.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1987, '228245504-0200', 'HHB3/4UNFX5-1/4 GR 5', 'X', '73181500', 112.80, 40.00, 10.00, 58.090, 48.50, 54.71, 135.36, 9.00, 5.23, 9.00, 5.23, 18.00, 10.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1988, '228245508-0200', 'HHB3/4UNFX5-1/2 GR 5', 'X', '73181500', 116.55, 40.00, 10.00, 60.020, 48.50, 56.53, 139.86, 9.00, 5.40, 9.00, 5.40, 18.00, 10.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1989, '228245600-0200', 'HHB3/4UNFX6 GR 5', 'X', '73181500', 122.75, 40.00, 10.00, 63.220, 48.50, 59.53, 147.30, 9.00, 5.69, 9.00, 5.69, 18.00, 11.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1990, '228284208-0200', 'HHB7/8UNCX2-1/2 GR 5', 'X', '73181500', 95.85, 30.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1991, '228284212-0200', 'HHB7/8UNCX2-3/4 GR 5', 'X', '73181500', 100.25, 30.00, 10.00, 51.630, 48.50, 48.62, 120.30, 9.00, 4.65, 9.00, 4.65, 18.00, 9.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1992, '228284300-0200', 'HHB7/8UNCX3 GR 5', 'X', '73181500', 104.90, 30.00, 10.00, 54.020, 48.50, 50.88, 125.88, 9.00, 4.86, 9.00, 4.86, 18.00, 9.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1993, '228284304-0200', 'HHB7/8UNCX3-1/4 GR 5', 'X', '73181500', 117.30, 40.00, 10.00, 60.410, 48.50, 56.89, 140.76, 9.00, 5.44, 9.00, 5.44, 18.00, 10.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1994, '228284308-0200', 'HHB7/8UNCX3-1/2 GR 5', 'X', '73181500', 121.50, 40.00, 10.00, 62.570, 48.50, 58.93, 145.80, 9.00, 5.63, 9.00, 5.63, 18.00, 11.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1995, '228284400-0200', 'HHB7/8UNCX4 GR 5', 'X', '73181500', 129.95, 40.00, 10.00, 66.920, 48.50, 63.03, 155.94, 9.00, 6.02, 9.00, 6.02, 18.00, 12.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1996, '228284404-0200', 'HHB7/8UNCX4-1/4 GR 5', 'X', '73181500', 141.10, 15.00, 5.00, 72.670, 48.50, 68.43, 169.32, 9.00, 6.54, 9.00, 6.54, 18.00, 13.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1997, '228284408-0200', 'HHB7/8UNCX4-1/2 GR 5', 'X', '73181500', 144.25, 15.00, 5.00, 74.290, 48.50, 69.96, 173.10, 9.00, 6.69, 9.00, 6.69, 18.00, 13.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1998, '228284412-0200', 'HHB7/8UNCX4-3/4 GR 5', 'X', '73181500', 150.35, 15.00, 5.00, 77.430, 48.50, 72.92, 180.42, 9.00, 6.97, 9.00, 6.97, 18.00, 13.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(1999, '228284500-0200', 'HHB7/8UNCX5 GR 5', 'X', '73181500', 155.25, 15.00, 5.00, 79.950, 48.50, 75.30, 186.30, 9.00, 7.20, 9.00, 7.20, 18.00, 14.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2000, '228284504-0200', 'HHB7/8UNCX5-1/4 GR 5', 'X', '73181500', 159.05, 15.00, 5.00, 81.910, 48.50, 77.14, 190.86, 9.00, 7.37, 9.00, 7.37, 18.00, 14.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2001, '228284508-0200', 'HHB7/8UNCX5-1/2 GR 5', 'X', '73181500', 163.50, 15.00, 5.00, 84.200, 48.50, 79.30, 196.20, 9.00, 7.58, 9.00, 7.58, 18.00, 15.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2002, '228284600-0200', 'HHB7/8UNCX6 GR 5', 'X', '73181500', 173.50, 20.00, 5.00, 89.350, 48.50, 84.15, 208.20, 9.00, 8.04, 9.00, 8.04, 18.00, 16.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2003, '228284608-0200', 'HHB7/8UNCX6-1/2 GR 5', 'X', '73181500', 183.50, 20.00, 5.00, 94.500, 48.50, 89.00, 220.20, 9.00, 8.51, 9.00, 8.51, 18.00, 17.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2004, '228284700-0200', 'HHB7/8UNCX7 GR 5', 'X', '73181500', 193.30, 20.00, 5.00, 99.550, 48.50, 93.75, 231.96, 9.00, 8.96, 9.00, 8.96, 18.00, 17.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2005, '228284800-0200', 'HHB7/8UNCX8 GR 5', 'X', '73181500', 212.65, 20.00, 5.00, 109.510, 48.50, 103.14, 255.18, 9.00, 9.86, 9.00, 9.86, 18.00, 19.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2006, '228285300-0200', 'HHB7/8UNFX3 GR 5', 'X', '73181500', 104.90, 30.00, 10.00, 54.020, 48.50, 50.88, 125.88, 9.00, 4.86, 9.00, 4.86, 18.00, 9.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2007, '228285308-0200', 'HHB7/8UNFX3-1/2 GR 5', 'X', '73181500', 121.50, 40.00, 10.00, 62.570, 48.50, 58.93, 145.80, 9.00, 5.63, 9.00, 5.63, 18.00, 11.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2008, '228285404-0200', 'HHB7/8UNFX4-1/4 GR 5', 'X', '73181500', 141.10, 15.00, 5.00, 72.670, 48.50, 68.43, 169.32, 9.00, 6.54, 9.00, 6.54, 18.00, 13.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2009, '228324212-0200', 'HHB1UNCX2-3/4 GR 5', 'X', '73181500', 126.50, 30.00, 10.00, 65.150, 48.50, 61.35, 151.80, 9.00, 5.86, 9.00, 5.86, 18.00, 11.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2010, '228324300-0200', 'HHB1UNCX3 GR 5', 'X', '73181500', 132.30, 20.00, 10.00, 68.130, 48.50, 64.17, 158.76, 9.00, 6.13, 9.00, 6.13, 18.00, 12.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2011, '228324304-0200', 'HHB1UNCX3-1/4 GR 5', 'X', '73181500', 144.05, 40.00, 10.00, 74.190, 48.50, 69.86, 172.86, 9.00, 6.68, 9.00, 6.68, 18.00, 13.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2012, '228324308-0200', 'HHB1UNCX3-1/2 GR 5', 'X', '73181500', 150.10, 40.00, 10.00, 77.300, 48.50, 72.80, 180.12, 9.00, 6.96, 9.00, 6.96, 18.00, 13.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2013, '228324400-0200', 'HHB1UNCX4 GR 5', 'X', '73181500', 165.25, 40.00, 10.00, 85.100, 48.50, 80.15, 198.30, 9.00, 7.66, 9.00, 7.66, 18.00, 15.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2014, '228324408-0200', 'HHB1UNCX4-1/2 GR 5', 'X', '73181500', 181.80, 15.00, 5.00, 93.630, 48.50, 88.17, 218.16, 9.00, 8.43, 9.00, 8.43, 18.00, 16.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2015, '228324412-0200', 'HHB1UNCX4-3/4 GR 5', 'X', '73181500', 187.80, 5.00, 5.00, 96.720, 48.50, 91.08, 225.36, 9.00, 8.70, 9.00, 8.70, 18.00, 17.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2016, '228324500-0200', 'HHB1UNCX5 GR 5', 'X', '73181500', 194.20, 15.00, 5.00, 100.010, 48.50, 94.19, 233.04, 9.00, 9.00, 9.00, 9.00, 18.00, 18.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2017, '228324508-0200', 'HHB1UNCX5-1/2 GR 5', 'X', '73181500', 206.50, 15.00, 5.00, 106.350, 48.50, 100.15, 247.80, 9.00, 9.57, 9.00, 9.57, 18.00, 19.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2018, '228324600-0200', 'HHB1UNCX6 GR 5', 'X', '73181500', 219.25, 20.00, 20.00, 112.910, 48.50, 106.34, 263.10, 9.00, 10.16, 9.00, 10.16, 18.00, 20.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2019, '228324608-0200', 'HHB1UNCX6-1/2 GR 5', 'X', '73181500', 232.15, 20.00, 5.00, 119.560, 48.50, 112.59, 278.58, 9.00, 10.76, 9.00, 10.76, 18.00, 21.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2020, '228324700-0200', 'HHB1UNCX7 GR 5', 'X', '73181500', 244.50, 20.00, 5.00, 125.920, 48.50, 118.58, 293.40, 9.00, 11.33, 9.00, 11.33, 18.00, 22.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2021, '228324800-0200', 'HHB1UNCX8 GR 5', 'X', '73181500', 273.85, 20.00, 5.00, 141.030, 48.50, 132.82, 328.62, 9.00, 12.69, 9.00, 12.69, 18.00, 25.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2022, '228325400-0200', 'HHB1UNFX4 GR 5', 'X', '73181500', 165.25, 40.00, 10.00, 85.100, 48.50, 80.15, 198.30, 9.00, 7.66, 9.00, 7.66, 18.00, 15.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2023, '228325600-0200', 'HHB1UNFX6 GR 5', 'X', '73181500', 219.25, 20.00, 5.00, 112.910, 48.50, 106.34, 263.10, 9.00, 10.16, 9.00, 10.16, 18.00, 20.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2024, '229084104-0200', 'HHB1/4UNCX1-1/4 GR 8', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2025, '229084108-0200', 'HHB1/4UNCX1-1/2 GR 8', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2026, '229084112-0200', 'HHB1/4UNCX1-3/4 GR 8', 'X', '73181500', 5.20, 1200.00, 200.00, 2.680, 48.50, 2.52, 6.24, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2027, '229084200-0200', 'HHB1/4UNCX2 GR 8', 'X', '73181500', 5.70, 1200.00, 200.00, 2.940, 48.50, 2.76, 6.84, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2028, '229084204-0200', 'HHB1/4UNCX2-1/4 GR 8', 'X', '73181500', 6.05, 1200.00, 200.00, 3.120, 48.50, 2.93, 7.26, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2029, '229084208-0200', 'HHB1/4UNCX2-1/2 GR 8', 'X', '73181500', 6.30, 600.00, 100.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2030, '229084300-0200', 'HHB1/4UNCX3 GR 8', 'X', '73181500', 7.70, 600.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2031, '229085104-0200', 'HHB1/4UNFX1-1/4 GR 8', 'X', '73181500', 4.65, 1200.00, 200.00, 2.390, 48.50, 2.26, 5.58, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2032, '229085108-0200', 'HHB1/4UNFX1-1/2 GR 8', 'X', '73181500', 5.00, 1200.00, 200.00, 2.580, 48.50, 2.43, 6.00, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2033, '229085200-0200', 'HHB1/4UNFX2 GR 8', 'X', '73181500', 5.70, 1200.00, 200.00, 2.940, 48.50, 2.76, 6.84, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2034, '229085300-0200', 'HHB1/4UNFX3 GR 8', 'X', '73181500', 7.70, 600.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2035, '229104104-0200', 'HHB5/16UNCX1-1/4 GR 8', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2036, '229104108-0200', 'HHB5/16UNCX1-1/2 GR 8', 'X', '73181500', 6.30, 600.00, 200.00, 3.240, 48.50, 3.06, 7.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2037, '229104112-0200', 'HHB5/16UNCX1-3/4 GR 8', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2038, '229104200-0200', 'HHB5/16UNCX2 GR 8', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2039, '229104204-0200', 'HHB5/16UNCX2-1/4 GR 8', 'X', '73181500', 7.85, 300.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2040, '229104208-0200', 'HHB5/16UNCX2-1/2 GR 8', 'X', '73181500', 8.25, 300.00, 100.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2041, '229104212-0200', 'HHB5/16UNCX2-3/4 GR 8', 'X', '73181500', 9.15, 300.00, 100.00, 4.710, 48.50, 4.44, 10.98, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2042, '229104308-0200', 'HHB5/16UNCX3-1/2 GR 8', 'X', '73181500', 10.45, 600.00, 100.00, 5.380, 48.50, 5.07, 12.54, 9.00, 0.48, 9.00, 0.48, 18.00, 0.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2043, '229104400-0200', 'HHB5/16UNCX4 GR 8', 'X', '73181500', 15.25, 400.00, 100.00, 7.850, 48.50, 7.40, 18.30, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2044, '229104408-0200', 'HHB5/16UNCX4-1/2 GR 8', 'X', '73181500', 16.55, 150.00, 50.00, 8.520, 48.50, 8.03, 19.86, 9.00, 0.77, 9.00, 0.77, 18.00, 1.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2045, '229104500-0200', 'HHB5/16UNCX5 GR 8', 'X', '73181500', 18.00, 150.00, 50.00, 9.270, 48.50, 8.73, 21.60, 9.00, 0.83, 9.00, 0.83, 18.00, 1.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2046, '229105104-0200', 'HHB5/16UNFX1-1/4 GR 8', 'X', '73181500', 5.35, 600.00, 200.00, 2.760, 48.50, 2.59, 6.42, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2047, '229105112-0200', 'HHB5/16UNFX1-3/4 GR 8', 'X', '73181500', 6.90, 400.00, 100.00, 3.550, 48.50, 3.35, 8.28, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2048, '229105200-0200', 'HHB5/16UNFX2 GR 8', 'X', '73181500', 7.15, 400.00, 100.00, 3.680, 48.50, 3.47, 8.58, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2049, '229105204-0200', 'HHB5/16UNFX2-1/4 GR 8', 'X', '73181500', 7.85, 300.00, 100.00, 4.040, 48.50, 3.81, 9.42, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2050, '229105208-0200', 'HHB5/16UNFX2-1/2 GR 8', 'X', '73181500', 8.25, 300.00, 100.00, 4.250, 48.50, 4.00, 9.90, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2051, '229105300-0200', 'HHB5/16UNFX3 GR 8', 'X', '73181500', 9.65, 400.00, 100.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2052, '229124106-0200', 'HHB3/8UNCX1-3/8 GR 8', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2053, '229124108-0200', 'HHB3/8UNCX1-1/2 GR 8', 'X', '73181500', 7.70, 800.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2054, '229124112-0200', 'HHB3/8UNCX1-3/4 GR 8', 'X', '73181500', 8.50, 300.00, 100.00, 4.380, 48.50, 4.12, 10.20, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2055, '229124200-0200', 'HHB3/8UNCX2 GR 8', 'X', '73181500', 9.25, 300.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2056, '229124204-0200', 'HHB3/8UNCX2-1/4 GR 8', 'X', '73181500', 9.65, 200.00, 50.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2057, '229124208-0200', 'HHB3/8UNCX2-1/2 GR 8', 'X', '73181500', 10.65, 400.00, 50.00, 5.480, 48.50, 5.17, 12.78, 9.00, 0.49, 9.00, 0.49, 18.00, 0.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2058, '229124212-0200', 'HHB3/8UNCX2-3/4 GR 8', 'X', '73181500', 11.65, 200.00, 50.00, 6.000, 48.50, 5.65, 13.98, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2059, '229124300-0200', 'HHB3/8UNCX3 GR 8', 'X', '73181500', 12.30, 200.00, 50.00, 6.330, 48.50, 5.97, 14.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2060, '229124304-0200', 'HHB3/8UNCX3-1/4 GR 8', 'X', '73181500', 13.10, 150.00, 50.00, 6.750, 48.50, 6.35, 15.72, 9.00, 0.61, 9.00, 0.61, 18.00, 1.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2061, '229124308-0200', 'HHB3/8UNCX3-1/2 GR 8', 'X', '73181500', 13.90, 150.00, 50.00, 7.160, 48.50, 6.74, 16.68, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2062, '229124312-0200', 'HHB3/8UNCX3-3/4 GR 8', 'X', '73181500', 18.00, 150.00, 50.00, 9.270, 48.50, 8.73, 21.60, 9.00, 0.83, 9.00, 0.83, 18.00, 1.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2063, '229124400-0200', 'HHB3/8UNCX4 GR 8', 'X', '73181500', 19.10, 150.00, 50.00, 9.840, 48.50, 9.26, 22.92, 9.00, 0.89, 9.00, 0.89, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2064, '229124404-0200', 'HHB3/8UNCX4-1/4 GR 8', 'X', '73181500', 18.85, 50.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2065, '229124408-0200', 'HHB3/8UNCX4-1/2 GR 8', 'X', '73181500', 19.60, 150.00, 50.00, 10.090, 48.50, 9.51, 23.52, 9.00, 0.91, 9.00, 0.91, 18.00, 1.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2066, '229124500-0200', 'HHB3/8UNCX5 GR 8', 'X', '73181500', 20.95, 200.00, 50.00, 10.790, 48.50, 10.16, 25.14, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2067, '229124504-0200', 'HHB3/8UNCX5-1/4 GR 8', 'X', '73181500', 32.20, 120.00, 20.00, 16.580, 48.50, 15.62, 38.64, 9.00, 1.49, 9.00, 1.49, 18.00, 2.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2068, '229124508-0200', 'HHB3/8UNCX5-1/2 GR 8', 'X', '73181500', 33.75, 200.00, 50.00, 17.380, 48.50, 16.37, 40.50, 9.00, 1.56, 9.00, 1.56, 18.00, 3.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2069, '229124512-0200', 'HHB3/8UNCX5-3/4 GR 8', 'X', '73181500', 36.70, 20.00, 20.00, 18.900, 48.50, 17.80, 44.04, 9.00, 1.70, 9.00, 1.70, 18.00, 3.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2070, '229124600-0200', 'HHB3/8UNCX6 GR 8', 'X', '73181500', 38.25, 100.00, 20.00, 19.700, 48.50, 18.55, 45.90, 9.00, 1.77, 9.00, 1.77, 18.00, 3.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2071, '229125108-0200', 'HHB3/8UNFX1-1/2 GR 8', 'X', '73181500', 7.70, 400.00, 100.00, 3.970, 48.50, 3.73, 9.24, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2072, '229125112-0200', 'HHB3/8UNFX1-3/4 GR 8', 'X', '73181500', 8.50, 300.00, 100.00, 4.380, 48.50, 4.12, 10.20, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2073, '229125200-0200', 'HHB3/8UNFX2 GR 8', 'X', '73181500', 9.25, 300.00, 100.00, 4.760, 48.50, 4.49, 11.10, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2074, '229125204-0200', 'HHB3/8UNFX2-1/4 GR 8', 'X', '73181500', 9.65, 200.00, 50.00, 4.970, 48.50, 4.68, 11.58, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2075, '229125208-0200', 'HHB3/8UNFX2-1/2 GR 8', 'X', '73181500', 10.65, 200.00, 50.00, 5.480, 48.50, 5.17, 12.78, 9.00, 0.49, 9.00, 0.49, 18.00, 0.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2076, '229125300-0200', 'HHB3/8UNFX3 GR 8', 'X', '73181500', 12.30, 200.00, 50.00, 6.330, 48.50, 5.97, 14.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2077, '229125400-0200', 'HHB3/8UNFX4 GR 8', 'X', '73181500', 19.10, 150.00, 50.00, 9.840, 48.50, 9.26, 22.92, 9.00, 0.89, 9.00, 0.89, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2078, '229125500-0200', 'HHB3/8UNFX5 GR 8', 'X', '73181500', 20.95, 200.00, 50.00, 10.790, 48.50, 10.16, 25.14, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2079, '229144108-0200', 'HHB7/16UNCX1-1/2 GR 8', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2080, '229144112-0200', 'HHB7/16UNCX1-3/4 GR 8', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2081, '229144200-0200', 'HHB7/16UNCX2 GR 8', 'X', '73181500', 12.75, 200.00, 50.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2082, '229144204-0200', 'HHB7/16UNCX2-1/4 GR 8', 'X', '73181500', 13.90, 200.00, 50.00, 7.160, 48.50, 6.74, 16.68, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2083, '229144208-0200', 'HHB7/16UNCX2-1/2 GR 8', 'X', '73181500', 15.00, 150.00, 50.00, 7.730, 48.50, 7.28, 18.00, 9.00, 0.70, 9.00, 0.70, 18.00, 1.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2084, '229144212-0200', 'HHB7/16UNCX2-3/4 GR 8', 'X', '73181500', 16.20, 150.00, 50.00, 8.340, 48.50, 7.86, 19.44, 9.00, 0.75, 9.00, 0.75, 18.00, 1.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2085, '229144300-0200', 'HHB7/16UNCX3 GR 8', 'X', '73181500', 17.35, 150.00, 50.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2086, '229144308-0200', 'HHB7/16UNCX3-1/2 GR 8', 'X', '73181500', 19.10, 80.00, 20.00, 9.840, 48.50, 9.26, 22.92, 9.00, 0.89, 9.00, 0.89, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2087, '229144400-0200', 'HHB7/16UNCX4 GR 8', 'X', '73181500', 24.70, 80.00, 20.00, 12.720, 48.50, 11.98, 29.64, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2088, '229144408-0200', 'HHB7/16UNCX4-1/2 GR 8', 'X', '73181500', 27.40, 80.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2089, '229144412-0200', 'HHB7/16UNCX4-3/4 GR 8', 'X', '73181500', 27.40, 120.00, 20.00, 14.110, 48.50, 13.29, 32.88, 9.00, 1.27, 9.00, 1.27, 18.00, 2.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2090, '229144500-0200', 'HHB7/16UNCX5 GR 8', 'X', '73181500', 30.75, 60.00, 20.00, 15.840, 48.50, 14.91, 36.90, 9.00, 1.43, 9.00, 1.43, 18.00, 2.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2091, '229144508-0200', 'HHB7/16UNCX5-1/2 GR 8', 'X', '73181500', 43.95, 80.00, 20.00, 22.630, 48.50, 21.32, 52.74, 9.00, 2.04, 9.00, 2.04, 18.00, 4.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2092, '229145106-0200', 'HHB7/16UNFX1-3/8 GR 8', 'X', '73181500', 9.95, 300.00, 100.00, 5.120, 48.50, 4.83, 11.94, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2093, '229145108-0200', 'HHB7/16UNFX1-1/2 GR 8', 'X', '73181500', 10.25, 300.00, 100.00, 5.280, 48.50, 4.97, 12.30, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2094, '229145112-0200', 'HHB7/16UNFX1-3/4 GR 8', 'X', '73181500', 11.90, 400.00, 100.00, 6.130, 48.50, 5.77, 14.28, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2095, '229145200-0200', 'HHB7/16UNFX2 GR 8', 'X', '73181500', 12.75, 200.00, 50.00, 6.570, 48.50, 6.18, 15.30, 9.00, 0.59, 9.00, 0.59, 18.00, 1.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2096, '229145208-0200', 'HHB7/16UNFX2-1/2 GR 8', 'X', '73181500', 15.00, 200.00, 50.00, 7.730, 48.50, 7.28, 18.00, 9.00, 0.70, 9.00, 0.70, 18.00, 1.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2097, '229145300-0200', 'HHB7/16UNFX3 GR 8', 'X', '73181500', 17.35, 150.00, 50.00, 8.940, 48.50, 8.41, 20.82, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2098, '229145304-0200', 'HHB7/16UNFX3-1/4 GR 8', 'X', '73181500', 18.70, 80.00, 20.00, 9.630, 48.50, 9.07, 22.44, 9.00, 0.87, 9.00, 0.87, 18.00, 1.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2099, '229145400-0200', 'HHB7/16UNFX4 GR 8', 'X', '73181500', 24.70, 80.00, 20.00, 12.720, 48.50, 11.98, 29.64, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2100, '229164110-0200', 'HHB1/2UNCX1-5/8 GR 8', 'X', '73181500', 17.85, 150.00, 50.00, 9.190, 48.50, 8.66, 21.42, 9.00, 0.83, 9.00, 0.83, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2101, '229164112-0200', 'HHB1/2UNCX1-3/4 GR 8', 'X', '73181500', 17.25, 150.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2102, '229164200-0200', 'HHB1/2UNCX2 GR 8', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2103, '229164204-0200', 'HHB1/2UNCX2-1/4 GR 8', 'X', '73181500', 19.85, 200.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2104, '229164208-0200', 'HHB1/2UNCX2-1/2 GR 8', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2105, '229164212-0200', 'HHB1/2UNCX2-3/4 GR 8', 'X', '73181500', 20.50, 120.00, 20.00, 10.560, 48.50, 9.94, 24.60, 9.00, 0.95, 9.00, 0.95, 18.00, 1.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2106, '229164300-0200', 'HHB1/2UNCX3 GR 8', 'X', '73181500', 22.35, 80.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2107, '229164304-0200', 'HHB1/2UNCX3-1/4 GR 8', 'X', '73181500', 24.70, 80.00, 20.00, 12.720, 48.50, 11.98, 29.64, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2108, '229164308-0200', 'HHB1/2UNCX3-1/2 GR 8', 'X', '73181500', 24.90, 80.00, 20.00, 12.820, 48.50, 12.08, 29.88, 9.00, 1.15, 9.00, 1.15, 18.00, 2.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2109, '229164312-0200', 'HHB1/2UNCX3-3/4 GR 8', 'X', '73181500', 27.85, 80.00, 20.00, 14.340, 48.50, 13.51, 33.42, 9.00, 1.29, 9.00, 1.29, 18.00, 2.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2110, '229164400-0200', 'HHB1/2UNCX4 GR 8', 'X', '73181500', 28.15, 80.00, 20.00, 14.500, 48.50, 13.65, 33.78, 9.00, 1.30, 9.00, 1.30, 18.00, 2.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2111, '229164404-0200', 'HHB1/2UNCX4-1/4 GR 8', 'X', '73181500', 30.05, 80.00, 20.00, 15.480, 48.50, 14.57, 36.06, 9.00, 1.39, 9.00, 1.39, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2112, '229164408-0200', 'HHB1/2UNCX4-1/2 GR 8', 'X', '73181500', 32.55, 160.00, 20.00, 16.760, 48.50, 15.79, 39.06, 9.00, 1.51, 9.00, 1.51, 18.00, 3.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2113, '229164500-0200', 'HHB1/2UNCX5 GR 8', 'X', '73181500', 34.65, 60.00, 20.00, 17.840, 48.50, 16.81, 41.58, 9.00, 1.61, 9.00, 1.61, 18.00, 3.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2114, '229164508-0200', 'HHB1/2UNCX5-1/2 GR 8', 'X', '73181500', 57.10, 60.00, 20.00, 29.410, 48.50, 27.69, 68.52, 9.00, 2.65, 9.00, 2.65, 18.00, 5.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2115, '229164512-0200', 'HHB1/2UNCX5-3/4 GR 8', 'X', '73181500', 63.30, 80.00, 20.00, 32.600, 48.50, 30.70, 75.96, 9.00, 2.93, 9.00, 2.93, 18.00, 5.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2116, '229164600-0200', 'HHB1/2UNCX6 GR 8', 'X', '73181500', 69.80, 40.00, 20.00, 35.950, 48.50, 33.85, 83.76, 9.00, 3.24, 9.00, 3.24, 18.00, 6.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2117, '229164608-0200', 'HHB1/2UNCX6-1/2 GR 8', 'X', '73181500', 72.45, 100.00, 20.00, 37.310, 48.50, 35.14, 86.94, 9.00, 3.36, 9.00, 3.36, 18.00, 6.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2118, '229164700-0200', 'HHB1/2UNCX7 GR 8', 'X', '73181500', 77.00, 100.00, 20.00, 39.660, 48.50, 37.35, 92.40, 9.00, 3.57, 9.00, 3.57, 18.00, 7.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2119, '229164708-0200', 'HHB1/2UNCX7-1/2 GR 8', 'X', '73181500', 83.20, 0.00, 0.00, 42.850, 48.50, 40.35, 99.84, 9.00, 3.86, 9.00, 3.86, 18.00, 7.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2120, '229164800-0200', 'HHB1/2UNCX8 GR 8', 'X', '73181500', 86.65, 1.00, 1.00, 44.620, 48.50, 42.03, 103.98, 9.00, 4.02, 9.00, 4.02, 18.00, 8.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1.00, 1.00, 1.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2121, '229165112-0200', 'HHB1/2UNFX1-3/4 GR 8', 'X', '73181500', 17.25, 150.00, 50.00, 8.880, 48.50, 8.37, 20.70, 9.00, 0.80, 9.00, 0.80, 18.00, 1.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2122, '229165200-0200', 'HHB1/2UNFX2 GR 8', 'X', '73181500', 18.85, 150.00, 50.00, 9.710, 48.50, 9.14, 22.62, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2123, '229165204-0200', 'HHB1/2UNFX2-1/4 GR 8', 'X', '73181500', 19.85, 200.00, 50.00, 10.220, 48.50, 9.63, 23.82, 9.00, 0.92, 9.00, 0.92, 18.00, 1.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2124, '229165208-0200', 'HHB1/2UNFX2-1/2 GR 8', 'X', '73181500', 20.20, 200.00, 50.00, 10.400, 48.50, 9.80, 24.24, 9.00, 0.94, 9.00, 0.94, 18.00, 1.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2125, '229165212-0200', 'HHB1/2UNFX2-3/4 GR 8', 'X', '73181500', 20.50, 120.00, 20.00, 10.560, 48.50, 9.94, 24.60, 9.00, 0.95, 9.00, 0.95, 18.00, 1.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2126, '229165300-0200', 'HHB1/2UNFX3 GR 8', 'X', '73181500', 22.35, 80.00, 20.00, 11.510, 48.50, 10.84, 26.82, 9.00, 1.04, 9.00, 1.04, 18.00, 2.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2127, '229165400-0200', 'HHB1/2UNFX4 GR 8', 'X', '73181500', 28.15, 80.00, 20.00, 14.500, 48.50, 13.65, 33.78, 9.00, 1.30, 9.00, 1.30, 18.00, 2.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2128, '229165404-0200', 'HHB1/2UNFX4-1/4 GR 8', 'X', '73181500', 30.05, 80.00, 20.00, 15.480, 48.50, 14.57, 36.06, 9.00, 1.39, 9.00, 1.39, 18.00, 2.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2129, '229165412-0200', 'HHB1/2UNFX4-3/4 GR 8', 'X', '73181500', 36.60, 80.00, 20.00, 18.850, 48.50, 17.75, 43.92, 9.00, 1.70, 9.00, 1.70, 18.00, 3.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2130, '229165700-0200', 'HHB1/2UNFX7 GR 8', 'X', '73181500', 77.00, 100.00, 20.00, 39.660, 48.50, 37.35, 92.40, 9.00, 3.57, 9.00, 3.57, 18.00, 7.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2131, '229204200-0200', 'HHB5/8UNCX2 GR 8', 'X', '73181500', 32.70, 80.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2132, '229204204-0200', 'HHB5/8UNCX2-1/4 GR 8', 'X', '73181500', 34.55, 80.00, 20.00, 17.790, 48.50, 16.76, 41.46, 9.00, 1.60, 9.00, 1.60, 18.00, 3.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2133, '229204208-0200', 'HHB5/8UNCX2-1/2 GR 8', 'X', '73181500', 37.95, 80.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2134, '229204212-0200', 'HHB5/8UNCX2-3/4 GR 8', 'X', '73181500', 41.05, 60.00, 20.00, 21.140, 48.50, 19.91, 49.26, 9.00, 1.90, 9.00, 1.90, 18.00, 3.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2135, '229204300-0200', 'HHB5/8UNCX3 GR 8', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2136, '229204304-0200', 'HHB5/8UNCX3-1/4 GR 8', 'X', '73181500', 46.95, 40.00, 10.00, 24.180, 48.50, 22.77, 56.34, 9.00, 2.18, 9.00, 2.18, 18.00, 4.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2137, '229204308-0200', 'HHB5/8UNCX3-1/2 GR 8', 'X', '73181500', 50.90, 40.00, 10.00, 26.210, 48.50, 24.69, 61.08, 9.00, 2.36, 9.00, 2.36, 18.00, 4.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2138, '229204312-0200', 'HHB5/8UNCX3-3/4 GR 8', 'X', '73181500', 52.80, 40.00, 10.00, 27.190, 48.50, 25.61, 63.36, 9.00, 2.45, 9.00, 2.45, 18.00, 4.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2139, '229204400-0200', 'HHB5/8UNCX4 GR 8', 'X', '73181500', 57.65, 40.00, 10.00, 29.690, 48.50, 27.96, 69.18, 9.00, 2.67, 9.00, 2.67, 18.00, 5.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2140, '229204408-0200', 'HHB5/8UNCX4-1/2 GR 8', 'X', '73181500', 62.05, 30.00, 10.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2141, '229204412-0200', 'HHB5/8UNCX4-3/4 GR 8', 'X', '73181500', 69.20, 40.00, 10.00, 35.640, 48.50, 33.56, 83.04, 9.00, 3.21, 9.00, 3.21, 18.00, 6.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2142, '229204500-0200', 'HHB5/8UNCX5 GR 8', 'X', '73181500', 69.90, 30.00, 10.00, 36.000, 48.50, 33.90, 83.88, 9.00, 3.24, 9.00, 3.24, 18.00, 6.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2143, '229204508-0200', 'HHB5/8UNCX5-1/2 GR 8', 'X', '73181500', 80.25, 30.00, 10.00, 41.330, 48.50, 38.92, 96.30, 9.00, 3.72, 9.00, 3.72, 18.00, 7.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2144, '229204600-0200', 'HHB5/8UNCX6 GR 8', 'X', '73181500', 82.40, 80.00, 20.00, 42.440, 48.50, 39.96, 98.88, 9.00, 3.82, 9.00, 3.82, 18.00, 7.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2145, '229204608-0200', 'HHB5/8UNCX6-1/2 GR 8', 'X', '73181500', 93.70, 50.00, 50.00, 48.260, 48.50, 45.44, 112.44, 9.00, 4.34, 9.00, 4.34, 18.00, 8.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2146, '229204700-0200', 'HHB5/8UNCX7 GR 8', 'X', '73181500', 98.00, 50.00, 10.00, 50.470, 48.50, 47.53, 117.60, 9.00, 4.54, 9.00, 4.54, 18.00, 9.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2147, '229204708-0200', 'HHB5/8UNCX7-1/2 GR 8', 'X', '73181500', 102.40, 0.00, 0.00, 52.740, 48.50, 49.66, 122.88, 9.00, 4.75, 9.00, 4.75, 18.00, 9.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 0.00, 'TVS-HEX', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(2148, '229204800-0200', 'HHB5/8UNCX8 GR 8', 'X', '73181500', 106.90, 50.00, 10.00, 55.050, 48.50, 51.85, 128.28, 9.00, 4.95, 9.00, 4.95, 18.00, 9.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 50.00, 50.00, 50.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2149, '229205200-0200', 'HHB5/8UNFX2 GR 8', 'X', '73181500', 32.70, 80.00, 20.00, 16.840, 48.50, 15.86, 39.24, 9.00, 1.52, 9.00, 1.52, 18.00, 3.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2150, '229205204-0200', 'HHB5/8UNFX2-1/4 GR 8', 'X', '73181500', 34.55, 80.00, 20.00, 17.790, 48.50, 16.76, 41.46, 9.00, 1.60, 9.00, 1.60, 18.00, 3.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2151, '229205208-0200', 'HHB5/8UNFX2-1/2 GR 8', 'X', '73181500', 37.95, 80.00, 20.00, 19.540, 48.50, 18.41, 45.54, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2152, '229205212-0200', 'HHB5/8UNFX2-3/4 GR 8', 'X', '73181500', 41.05, 60.00, 20.00, 21.140, 48.50, 19.91, 49.26, 9.00, 1.90, 9.00, 1.90, 18.00, 3.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2153, '229205300-0200', 'HHB5/8UNFX3 GR 8', 'X', '73181500', 44.10, 60.00, 20.00, 22.710, 48.50, 21.39, 52.92, 9.00, 2.04, 9.00, 2.04, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2154, '229205308-0200', 'HHB5/8UNFX3-1/2 GR 8', 'X', '73181500', 50.90, 40.00, 10.00, 26.210, 48.50, 24.69, 61.08, 9.00, 2.36, 9.00, 2.36, 18.00, 4.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2155, '229205400-0200', 'HHB5/8UNFX4 GR 8', 'X', '73181500', 57.65, 40.00, 10.00, 29.690, 48.50, 27.96, 69.18, 9.00, 2.67, 9.00, 2.67, 18.00, 5.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2156, '229205408-0200', 'HHB5/8UNFX4-1/2 GR 8', 'X', '73181500', 62.05, 30.00, 10.00, 31.960, 48.50, 30.09, 74.46, 9.00, 2.88, 9.00, 2.88, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2157, '229205500-0200', 'HHB5/8UNFX5 GR 8', 'X', '73181500', 69.90, 10.00, 10.00, 36.000, 48.50, 33.90, 83.88, 9.00, 3.24, 9.00, 3.24, 18.00, 6.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2158, '229205508-0200', 'HHB5/8UNFX5-1/2 GR 8', 'X', '73181500', 80.25, 10.00, 10.00, 41.330, 48.50, 38.92, 96.30, 9.00, 3.72, 9.00, 3.72, 18.00, 7.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2159, '229205708-0200', 'HHB5/8UNFX7-1/2 GR 8', 'X', '73181500', 102.40, 40.00, 10.00, 52.740, 48.50, 49.66, 122.88, 9.00, 4.75, 9.00, 4.75, 18.00, 9.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2160, '229244204-0200', 'HHB3/4UNCX2-1/4 GR 8', 'X', '73181500', 65.05, 40.00, 10.00, 33.500, 48.50, 31.55, 78.06, 9.00, 3.02, 9.00, 3.02, 18.00, 6.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2161, '229244208-0200', 'HHB3/4UNCX2-1/2 GR 8', 'X', '73181500', 68.25, 80.00, 10.00, 35.150, 48.50, 33.10, 81.90, 9.00, 3.16, 9.00, 3.16, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2162, '229244212-0200', 'HHB3/4UNCX2-3/4 GR 8', 'X', '73181500', 74.50, 40.00, 10.00, 38.370, 48.50, 36.13, 89.40, 9.00, 3.45, 9.00, 3.45, 18.00, 6.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2163, '229244300-0200', 'HHB3/4UNCX3 GR 8', 'X', '73181500', 77.35, 40.00, 10.00, 39.840, 48.50, 37.51, 92.82, 9.00, 3.59, 9.00, 3.59, 18.00, 7.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2164, '229244304-0200', 'HHB3/4UNCX3-1/4 GR 8', 'X', '73181500', 82.70, 30.00, 10.00, 42.590, 48.50, 40.11, 99.24, 9.00, 3.83, 9.00, 3.83, 18.00, 7.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2165, '229244308-0200', 'HHB3/4UNCX3-1/2 GR 8', 'X', '73181500', 85.45, 30.00, 10.00, 44.010, 48.50, 41.44, 102.54, 9.00, 3.96, 9.00, 3.96, 18.00, 7.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2166, '229244312-0200', 'HHB3/4UNCX3-3/4 GR 8', 'X', '73181500', 93.10, 30.00, 10.00, 47.950, 48.50, 45.15, 111.72, 9.00, 4.32, 9.00, 4.32, 18.00, 8.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2167, '229244400-0200', 'HHB3/4UNCX4 GR 8', 'X', '73181500', 95.85, 30.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2168, '229244404-0200', 'HHB3/4UNCX4-1/4 GR 8', 'X', '73181500', 99.85, 30.00, 10.00, 51.420, 48.50, 48.43, 119.82, 9.00, 4.63, 9.00, 4.63, 18.00, 9.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2169, '229244408-0200', 'HHB3/4UNCX4-1/2 GR 8', 'X', '73181500', 102.75, 30.00, 10.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2170, '229244412-0200', 'HHB3/4UNCX4-3/4 GR 8', 'X', '73181500', 106.00, 30.00, 10.00, 54.590, 48.50, 51.41, 127.20, 9.00, 4.91, 9.00, 4.91, 18.00, 9.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2171, '229244500-0200', 'HHB3/4UNCX5 GR 8', 'X', '73181500', 109.35, 40.00, 10.00, 56.320, 48.50, 53.03, 131.22, 9.00, 5.07, 9.00, 5.07, 18.00, 10.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2172, '229244508-0200', 'HHB3/4UNCX5-1/2 GR 8', 'X', '73181500', 116.55, 40.00, 10.00, 60.020, 48.50, 56.53, 139.86, 9.00, 5.40, 9.00, 5.40, 18.00, 10.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2173, '229244600-0200', 'HHB3/4UNCX6 GR 8', 'X', '73181500', 122.75, 40.00, 10.00, 63.220, 48.50, 59.53, 147.30, 9.00, 5.69, 9.00, 5.69, 18.00, 11.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2174, '229244604-0200', 'HHB3/4UNCX6-1/4 GR 8', 'X', '73181500', 126.15, 40.00, 10.00, 64.970, 48.50, 61.18, 151.38, 9.00, 5.85, 9.00, 5.85, 18.00, 11.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2175, '229244608-0200', 'HHB3/4UNCX6-1/2 GR 8', 'X', '73181500', 129.50, 40.00, 10.00, 66.690, 48.50, 62.81, 155.40, 9.00, 6.00, 9.00, 6.00, 18.00, 12.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2176, '229244700-0200', 'HHB3/4UNCX7 GR 8', 'X', '73181500', 136.15, 40.00, 10.00, 70.120, 48.50, 66.03, 163.38, 9.00, 6.31, 9.00, 6.31, 18.00, 12.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2177, '229244708-0200', 'HHB3/4UNCX7-1/2 GR 8', 'X', '73181500', 142.35, 40.00, 10.00, 73.310, 48.50, 69.04, 170.82, 9.00, 6.60, 9.00, 6.60, 18.00, 13.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2178, '229244800-0200', 'HHB3/4UNCX8 GR 8', 'X', '73181500', 149.00, 40.00, 10.00, 76.740, 48.50, 72.27, 178.80, 9.00, 6.91, 9.00, 6.91, 18.00, 13.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2179, '229245208-0200', 'HHB3/4UNFX2-1/2 GR 8', 'X', '73181500', 68.25, 40.00, 10.00, 35.150, 48.50, 33.10, 81.90, 9.00, 3.16, 9.00, 3.16, 18.00, 6.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2180, '229245300-0200', 'HHB3/4UNFX3 GR 8', 'X', '73181500', 77.35, 40.00, 10.00, 39.840, 48.50, 37.51, 92.82, 9.00, 3.59, 9.00, 3.59, 18.00, 7.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2181, '229245308-0200', 'HHB3/4UNFX3-1/2 GR 8', 'X', '73181500', 85.45, 30.00, 10.00, 44.010, 48.50, 41.44, 102.54, 9.00, 3.96, 9.00, 3.96, 18.00, 7.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2182, '229245312-0200', 'HHB3/4UNFX3-3/4 GR 8', 'X', '73181500', 93.10, 30.00, 10.00, 47.950, 48.50, 45.15, 111.72, 9.00, 4.32, 9.00, 4.32, 18.00, 8.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2183, '229245400-0200', 'HHB3/4UNFX4 GR 8', 'X', '73181500', 95.85, 40.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2184, '229245408-0200', 'HHB3/4UNFX4-1/2 GR 8', 'X', '73181500', 102.75, 30.00, 10.00, 52.920, 48.50, 49.83, 123.30, 9.00, 4.76, 9.00, 4.76, 18.00, 9.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2185, '229245500-0200', 'HHB3/4UNFX5 GR 8', 'X', '73181500', 109.35, 40.00, 10.00, 56.320, 48.50, 53.03, 131.22, 9.00, 5.07, 9.00, 5.07, 18.00, 10.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2186, '229245600-0200', 'HHB3/4UNFX6 GR 8', 'X', '73181500', 122.75, 40.00, 10.00, 63.220, 48.50, 59.53, 147.30, 9.00, 5.69, 9.00, 5.69, 18.00, 11.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2187, '229284208-0200', 'HHB7/8UNCX2-1/2 GR 8', 'X', '73181500', 95.85, 30.00, 10.00, 49.360, 48.50, 46.49, 115.02, 9.00, 4.44, 9.00, 4.44, 18.00, 8.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2188, '229284212-0200', 'HHB7/8UNCX2-3/4 GR 8', 'X', '73181500', 100.25, 30.00, 10.00, 51.630, 48.50, 48.62, 120.30, 9.00, 4.65, 9.00, 4.65, 18.00, 9.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2189, '229284300-0200', 'HHB7/8UNCX3 GR 8', 'X', '73181500', 104.90, 30.00, 10.00, 54.020, 48.50, 50.88, 125.88, 9.00, 4.86, 9.00, 4.86, 18.00, 9.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2190, '229284304-0200', 'HHB7/8UNCX3-1/4 GR 8', 'X', '73181500', 117.30, 40.00, 10.00, 60.410, 48.50, 56.89, 140.76, 9.00, 5.44, 9.00, 5.44, 18.00, 10.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2191, '229284308-0200', 'HHB7/8UNCX3-1/2 GR 8', 'X', '73181500', 121.50, 40.00, 10.00, 62.570, 48.50, 58.93, 145.80, 9.00, 5.63, 9.00, 5.63, 18.00, 11.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2192, '229284312-0200', 'HHB7/8UNCX3-3/4 GR 8', 'X', '73181500', 123.65, 40.00, 10.00, 63.680, 48.50, 59.97, 148.38, 9.00, 5.73, 9.00, 5.73, 18.00, 11.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2193, '229284400-0200', 'HHB7/8UNCX4 GR 8', 'X', '73181500', 129.95, 20.00, 10.00, 66.920, 48.50, 63.03, 155.94, 9.00, 6.02, 9.00, 6.02, 18.00, 12.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2194, '229284404-0200', 'HHB7/8UNCX4-1/4 GR 8', 'X', '73181500', 141.10, 15.00, 5.00, 72.670, 48.50, 68.43, 169.32, 9.00, 6.54, 9.00, 6.54, 18.00, 13.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2195, '229284408-0200', 'HHB7/8UNCX4-1/2 GR 8', 'X', '73181500', 144.25, 15.00, 5.00, 74.290, 48.50, 69.96, 173.10, 9.00, 6.69, 9.00, 6.69, 18.00, 13.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2196, '229284412-0200', 'HHB7/8UNCX4-3/4 GR 8', 'X', '73181500', 150.35, 15.00, 5.00, 77.430, 48.50, 72.92, 180.42, 9.00, 6.97, 9.00, 6.97, 18.00, 13.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2197, '229284500-0200', 'HHB7/8UNCX5 GR 8', 'X', '73181500', 155.25, 15.00, 5.00, 79.950, 48.50, 75.30, 186.30, 9.00, 7.20, 9.00, 7.20, 18.00, 14.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2198, '229284504-0200', 'HHB7/8UNCX5-1/4 GR 8', 'X', '73181500', 159.05, 15.00, 5.00, 81.910, 48.50, 77.14, 190.86, 9.00, 7.37, 9.00, 7.37, 18.00, 14.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2199, '229284508-0200', 'HHB7/8UNCX5-1/2 GR 8', 'X', '73181500', 163.50, 15.00, 5.00, 84.200, 48.50, 79.30, 196.20, 9.00, 7.58, 9.00, 7.58, 18.00, 15.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2200, '229284600-0200', 'HHB7/8UNCX6 GR 8', 'X', '73181500', 173.50, 20.00, 5.00, 89.350, 48.50, 84.15, 208.20, 9.00, 8.04, 9.00, 8.04, 18.00, 16.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2201, '229284608-0200', 'HHB7/8UNCX6-1/2 GR 8', 'X', '73181500', 183.50, 20.00, 20.00, 94.500, 48.50, 89.00, 220.20, 9.00, 8.51, 9.00, 8.51, 18.00, 17.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2202, '229284700-0200', 'HHB7/8UNCX7 GR 8', 'X', '73181500', 193.30, 20.00, 5.00, 99.550, 48.50, 93.75, 231.96, 9.00, 8.96, 9.00, 8.96, 18.00, 17.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2203, '229284800-0200', 'HHB7/8UNCX8 GR 8', 'X', '73181500', 212.65, 20.00, 5.00, 109.510, 48.50, 103.14, 255.18, 9.00, 9.86, 9.00, 9.86, 18.00, 19.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2204, '229285300-0200', 'HHB7/8UNFX3 GR 8', 'X', '73181500', 104.90, 30.00, 10.00, 54.020, 48.50, 50.88, 125.88, 9.00, 4.86, 9.00, 4.86, 18.00, 9.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2205, '229285304-0200', 'HHB7/8UNFX3-1/4 GR 8', 'X', '73181500', 117.30, 20.00, 10.00, 60.410, 48.50, 56.89, 140.76, 9.00, 5.44, 9.00, 5.44, 18.00, 10.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2206, '229285308-0200', 'HHB7/8UNFX3-1/2 GR 8', 'X', '73181500', 121.50, 20.00, 10.00, 62.570, 48.50, 58.93, 145.80, 9.00, 5.63, 9.00, 5.63, 18.00, 11.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2207, '229285400-0200', 'HHB7/8UNFX4 GR 8', 'X', '73181500', 129.95, 20.00, 10.00, 66.920, 48.50, 63.03, 155.94, 9.00, 6.02, 9.00, 6.02, 18.00, 12.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2208, '229285404-0200', 'HHB7/8UNFX4-1/4 GR 8', 'X', '73181500', 141.10, 5.00, 5.00, 72.670, 48.50, 68.43, 169.32, 9.00, 6.54, 9.00, 6.54, 18.00, 13.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2209, '229285408-0200', 'HHB7/8UNFX4-1/2 GR 8', 'X', '73181500', 144.25, 15.00, 5.00, 74.290, 48.50, 69.96, 173.10, 9.00, 6.69, 9.00, 6.69, 18.00, 13.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2210, '229285500-0200', 'HHB7/8UNFX5 GR 8', 'X', '73181500', 155.25, 15.00, 5.00, 79.950, 48.50, 75.30, 186.30, 9.00, 7.20, 9.00, 7.20, 18.00, 14.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2211, '229285508-0200', 'HHB7/8UNFX5-1/2 GR 8', 'X', '73181500', 163.50, 15.00, 5.00, 84.200, 48.50, 79.30, 196.20, 9.00, 7.58, 9.00, 7.58, 18.00, 15.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2212, '229285608-0200', 'HHB7/8UNFX6-1/2 GR 8', 'X', '73181500', 183.50, 20.00, 5.00, 94.500, 48.50, 89.00, 220.20, 9.00, 8.51, 9.00, 8.51, 18.00, 17.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2213, '229324300-0200', 'HHB1UNCX3 GR 8', 'X', '73181500', 132.30, 20.00, 10.00, 68.130, 48.50, 64.17, 158.76, 9.00, 6.13, 9.00, 6.13, 18.00, 12.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2214, '229324304-0200', 'HHB1UNCX3-1/4 GR 8', 'X', '73181500', 144.05, 40.00, 10.00, 74.190, 48.50, 69.86, 172.86, 9.00, 6.68, 9.00, 6.68, 18.00, 13.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2215, '229324308-0200', 'HHB1UNCX3-1/2 GR 8', 'X', '73181500', 150.10, 40.00, 10.00, 77.300, 48.50, 72.80, 180.12, 9.00, 6.96, 9.00, 6.96, 18.00, 13.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2216, '229324312-0200', 'HHB1UNCX3-3/4 GR 8', 'X', '73181500', 155.85, 40.00, 10.00, 80.260, 48.50, 75.59, 187.02, 9.00, 7.22, 9.00, 7.22, 18.00, 14.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2217, '229324400-0200', 'HHB1UNCX4 GR 8', 'X', '73181500', 165.25, 20.00, 10.00, 85.100, 48.50, 80.15, 198.30, 9.00, 7.66, 9.00, 7.66, 18.00, 15.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2218, '229324408-0200', 'HHB1UNCX4-1/2 GR 8', 'X', '73181500', 181.80, 15.00, 5.00, 93.630, 48.50, 88.17, 218.16, 9.00, 8.43, 9.00, 8.43, 18.00, 16.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2219, '229324412-0200', 'HHB1UNCX4-3/4 GR 8', 'X', '73181500', 187.80, 15.00, 5.00, 96.720, 48.50, 91.08, 225.36, 9.00, 8.70, 9.00, 8.70, 18.00, 17.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2220, '229324500-0200', 'HHB1UNCX5 GR 8', 'X', '73181500', 194.20, 15.00, 5.00, 100.010, 48.50, 94.19, 233.04, 9.00, 9.00, 9.00, 9.00, 18.00, 18.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2221, '229324504-0200', 'HHB1UNCX5-1/4 GR 8', 'X', '73181500', 200.15, 15.00, 5.00, 103.080, 48.50, 97.07, 240.18, 9.00, 9.28, 9.00, 9.28, 18.00, 18.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2222, '229324508-0200', 'HHB1UNCX5-1/2 GR 8', 'X', '73181500', 206.50, 15.00, 5.00, 106.350, 48.50, 100.15, 247.80, 9.00, 9.57, 9.00, 9.57, 18.00, 19.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2223, '229324600-0200', 'HHB1UNCX6 GR 8', 'X', '73181500', 219.25, 20.00, 5.00, 112.910, 48.50, 106.34, 263.10, 9.00, 10.16, 9.00, 10.16, 18.00, 20.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2224, '229324608-0200', 'HHB1UNCX6-1/2 GR 8', 'X', '73181500', 232.15, 20.00, 5.00, 119.560, 48.50, 112.59, 278.58, 9.00, 10.76, 9.00, 10.76, 18.00, 21.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2225, '229324700-0200', 'HHB1UNCX7 GR 8', 'X', '73181500', 244.50, 20.00, 5.00, 125.920, 48.50, 118.58, 293.40, 9.00, 11.33, 9.00, 11.33, 18.00, 22.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2226, '229324800-0200', 'HHB1UNCX8 GR 8', 'X', '73181500', 273.85, 20.00, 5.00, 141.030, 48.50, 132.82, 328.62, 9.00, 12.69, 9.00, 12.69, 18.00, 25.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2227, '229324808-0200', 'HHB1UNCX8-1/2 GR 8', 'X', '73181500', 315.00, 5.00, 5.00, 162.230, 48.50, 152.78, 378.00, 9.00, 14.60, 9.00, 14.60, 18.00, 29.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2228, '229324900-0200', 'HHB1UNCX9 GR 8', 'X', '73181500', 362.35, 5.00, 5.00, 186.610, 48.50, 175.74, 434.82, 9.00, 16.79, 9.00, 16.79, 18.00, 33.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2229, '229324908-0200', 'HHB1UNCX9-1/2 GR 8', 'X', '73181500', 416.65, 5.00, 5.00, 214.570, 48.50, 202.08, 499.98, 9.00, 19.31, 9.00, 19.31, 18.00, 38.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2230, '229325400-0200', 'HHB1UNFX4 GR 8', 'X', '73181500', 165.25, 40.00, 10.00, 85.100, 48.50, 80.15, 198.30, 9.00, 7.66, 9.00, 7.66, 18.00, 15.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2231, '229325408-0200', 'HHB1UNFX4-1/2 GR 8', 'X', '73181500', 181.80, 15.00, 5.00, 93.630, 48.50, 88.17, 218.16, 9.00, 8.43, 9.00, 8.43, 18.00, 16.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2232, '229325500-0200', 'HHB1UNFX5 GR 8', 'X', '73181500', 194.20, 15.00, 5.00, 100.010, 48.50, 94.19, 233.04, 9.00, 9.00, 9.00, 9.00, 18.00, 18.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2233, '229325508-0200', 'HHB1UNFX5-1/2 GR 8', 'X', '73181500', 206.50, 15.00, 5.00, 106.350, 48.50, 100.15, 247.80, 9.00, 9.57, 9.00, 9.57, 18.00, 19.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2234, '229325600-0200', 'HHB1UNFX6 GR 8', 'X', '73181500', 219.25, 20.00, 5.00, 112.910, 48.50, 106.34, 263.10, 9.00, 10.16, 9.00, 10.16, 18.00, 20.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2235, '229325608-0200', 'HHB1UNFX6-1/2 GR 8', 'X', '73181500', 232.15, 20.00, 5.00, 119.560, 48.50, 112.59, 278.58, 9.00, 10.76, 9.00, 10.76, 18.00, 21.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2236, '229325800-0200', 'HHB1UNFX8 GR 8', 'X', '73181500', 273.85, 20.00, 5.00, 141.030, 48.50, 132.82, 328.62, 9.00, 12.69, 9.00, 12.69, 18.00, 25.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2237, '229328100-0200', 'HHB1UNCX1 GR 8', 'X', '73181500', 14.55, 5.00, 5.00, 7.490, 48.50, 7.06, 17.46, 9.00, 0.67, 9.00, 0.67, 18.00, 1.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2238, '229328104-0200', 'HHB1UNCX1-1/4 GR 8', 'X', '73181500', 15.45, 5.00, 5.00, 7.960, 48.50, 7.49, 18.54, 9.00, 0.72, 9.00, 0.72, 18.00, 1.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2239, '229328110-0200', 'HHB1UNCX1-5/8 GR 8', 'X', '73181500', 108.95, 5.00, 5.00, 56.110, 48.50, 52.84, 130.74, 9.00, 5.05, 9.00, 5.05, 18.00, 10.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2240, '229328114-0200', 'HHB1UNCX1-7/8 GR 8', 'X', '73181500', 109.15, 20.00, 5.00, 56.210, 48.50, 52.94, 130.98, 9.00, 5.06, 9.00, 5.06, 18.00, 10.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2241, '229404400-0200', 'HHB1-1/4UNCX4 GR 8', 'X', '73181500', 465.95, 5.00, 5.00, 239.960, 48.50, 225.99, 559.14, 9.00, 21.60, 9.00, 21.60, 18.00, 43.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2242, '229404808-0200', 'HHB1-1/4UNCX8-1/2 GR 8', 'X', '73181500', 657.20, 2.00, 2.00, 338.460, 48.50, 318.74, 788.64, 9.00, 30.46, 9.00, 30.46, 18.00, 60.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2243, '229404904-0200', 'HHB1-1/4UNCX9-1/4 GR 8', 'X', '73181500', 723.10, 5.00, 5.00, 372.400, 48.50, 350.70, 867.72, 9.00, 33.52, 9.00, 33.52, 18.00, 67.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2244, '229404908-0200', 'HHB1-1/4UNCX9-1/2 GR 8', 'X', '73181500', 762.60, 5.00, 5.00, 392.740, 48.50, 369.86, 915.12, 9.00, 35.35, 9.00, 35.35, 18.00, 70.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-HEX', 'X', 0.00, '0.00'),
(2245, '316031005-0500', 'SHCSM3X0.5X5 GR 12.9', 'X', '73181500', 12.75, 600.00, 200.00, 4.650, 63.50, 8.10, 15.30, 9.00, 0.42, 9.00, 0.42, 18.00, 0.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2246, '316031006-0500', 'SHCSM3X0.5X6 GR 12.9', 'X', '73181500', 11.00, 600.00, 200.00, 4.020, 63.50, 6.99, 13.20, 9.00, 0.36, 9.00, 0.36, 18.00, 0.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2247, '316031008-0500', 'SHCSM3X0.5X8 GR 12.9', 'X', '73181500', 8.15, 600.00, 200.00, 2.970, 63.50, 5.18, 9.78, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2248, '316031010-0500', 'SHCSM3X0.5X10 GR 12.9', 'X', '73181500', 6.80, 600.00, 200.00, 2.480, 63.50, 4.32, 8.16, 9.00, 0.22, 9.00, 0.22, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2249, '316031012-0500', 'SHCSM3X0.5X12 GR 12.9', 'X', '73181500', 6.80, 600.00, 200.00, 2.480, 63.50, 4.32, 8.16, 9.00, 0.22, 9.00, 0.22, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2250, '316031016-0500', 'SHCSM3X0.5X16 GR 12.9', 'X', '73181500', 7.10, 600.00, 200.00, 2.590, 63.50, 4.51, 8.52, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2251, '316031020-0500', 'SHCSM3X0.5X2 GR 12.9', 'X', '73181500', 7.10, 600.00, 200.00, 2.590, 63.50, 4.51, 8.52, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2252, '316041005-0500', 'SHCSM4X0.7X5 GR 12.9', 'X', '73181500', 11.20, 600.00, 200.00, 4.090, 63.50, 7.11, 13.44, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2253, '316041006-0500', 'SHCSM4X0.7X6 GR 12.9', 'X', '73181500', 11.20, 600.00, 200.00, 4.090, 63.50, 7.11, 13.44, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2254, '316041008-0500', 'SHCSM4X0.7X8 GR 12.9', 'X', '73181500', 8.40, 600.00, 200.00, 3.070, 63.50, 5.33, 10.08, 9.00, 0.28, 9.00, 0.28, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2255, '316041010-0500', 'SHCSM4X0.7X10 GR 12.9', 'X', '73181500', 6.65, 600.00, 200.00, 2.430, 63.50, 4.22, 7.98, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, -2000.00, -4860.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2256, '316041012-0500', 'SHCSM4X0.7X12 GR 12.9', 'X', '73181500', 6.05, 600.00, 200.00, 2.210, 63.50, 3.84, 7.26, 9.00, 0.20, 9.00, 0.20, 18.00, 0.40, 0.00, -2000.00, -4420.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2257, '316041014-0500', 'SHCSM4X0.7X14 GR 12.9', 'X', '73181500', 6.30, 600.00, 200.00, 2.300, 63.50, 4.00, 7.56, 9.00, 0.21, 9.00, 0.21, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2258, '316041015-0500', 'SHCSM4X0.7X15 GR 12.9', 'X', '73181500', 6.30, 600.00, 200.00, 2.300, 63.50, 4.00, 7.56, 9.00, 0.21, 9.00, 0.21, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2259, '316041016-0500', 'SHCSM4X0.7X16 GR 12.9', 'X', '73181500', 5.10, 600.00, 200.00, 1.860, 63.50, 3.24, 6.12, 9.00, 0.17, 9.00, 0.17, 18.00, 0.34, 0.00, -2000.00, -3720.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2260, '316041020-0500', 'SHCSM4X0.7X20 GR 12.9', 'X', '73181500', 5.45, 600.00, 200.00, 1.990, 63.50, 3.46, 6.54, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, -2000.00, -3980.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2261, '316041022-0500', 'SHCSM4X0.7X22 GR 12.9', 'X', '73181500', 7.00, 1600.00, 200.00, 2.560, 63.50, 4.45, 8.40, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2262, '316041025-0500', 'SHCSM4X0.7X25 GR 12.9', 'X', '73181500', 5.65, 600.00, 200.00, 2.060, 63.50, 3.59, 6.78, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, -2000.00, -4120.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2263, '316041030-0500', 'SHCSM4X0.7X30 GR 12.9', 'X', '73181500', 8.25, 1600.00, 200.00, 3.010, 63.50, 5.24, 9.90, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, -2000.00, -6020.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2264, '316041035-0500', 'SHCSM4X0.7X35 GR 12.9', 'X', '73181500', 9.05, 1600.00, 200.00, 3.300, 63.50, 5.75, 10.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2265, '316051006-0500', 'SHCSM5X0.8X6 GR 12.9', 'X', '73181500', 12.50, 600.00, 200.00, 4.560, 63.50, 7.94, 15.00, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2266, '316051008-0500', 'SHCSM5X0.8X8 GR 12.9', 'X', '73181500', 8.65, 600.00, 200.00, 3.160, 63.50, 5.49, 10.38, 9.00, 0.28, 9.00, 0.28, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2267, '316051010-0500', 'SHCSM5X0.8X10 GR 12.9', 'X', '73181500', 4.85, 600.00, 200.00, 1.770, 63.50, 3.08, 5.82, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, -2000.00, -3540.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2268, '316051012-0500', 'SHCSM5X0.8X12 GR 12.9', 'X', '73181500', 4.90, 600.00, 200.00, 1.790, 63.50, 3.11, 5.88, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, -2000.00, -3580.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2269, '316051014-0500', 'SHCSM5X0.8X14 GR 12.9', 'X', '73181500', 5.55, 600.00, 200.00, 2.030, 63.50, 3.52, 6.66, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2270, '316051015-0500', 'SHCSM5X0.8X15 GR 12.9', 'X', '73181500', 5.55, 1600.00, 200.00, 2.030, 63.50, 3.52, 6.66, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2271, '316051016-0500', 'SHCSM5X0.8X16 GR 12.9', 'X', '73181500', 5.55, 1600.00, 200.00, 2.030, 63.50, 3.52, 6.66, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, -2000.00, -4060.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2272, '316051018-0500', 'SHCSM5X0.8X18 GR 12.9', 'X', '73181500', 6.00, 1600.00, 200.00, 2.190, 63.50, 3.81, 7.20, 9.00, 0.20, 9.00, 0.20, 18.00, 0.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2273, '316051020-0500', 'SHCSM5X0.8X20 GR 12.9', 'X', '73181500', 5.10, 1600.00, 200.00, 1.860, 63.50, 3.24, 6.12, 9.00, 0.17, 9.00, 0.17, 18.00, 0.34, 0.00, -2000.00, -3720.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2274, '316051022-0500', 'SHCSM5X0.8X22 GR 12.9', 'X', '73181500', 6.30, 1600.00, 200.00, 2.300, 63.50, 4.00, 7.56, 9.00, 0.21, 9.00, 0.21, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2275, '316051025-0500', 'SHCS5X0.8X25 GR 12.9', 'X', '73181500', 6.30, 1600.00, 200.00, 2.300, 63.50, 4.00, 7.56, 9.00, 0.21, 9.00, 0.21, 18.00, 0.41, 0.00, -2000.00, -4600.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2276, '316051030-0500', 'SHCSM5X0.8X30 GR 12.9', 'X', '73181500', 7.30, 2400.00, 200.00, 2.660, 63.50, 4.64, 8.76, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, -1000.00, -2660.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2277, '316051035-0500', 'SHCSM5X0.8X35 GR 12.9', 'X', '73181500', 8.00, 2400.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2278, '316061006-0500', 'SHCSM6X1X6 GR 12.9', 'X', '73181500', 12.90, 400.00, 200.00, 4.710, 63.50, 8.19, 15.48, 9.00, 0.42, 9.00, 0.42, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2279, '316061008-0500', 'SHCSM6X1X8 GR 12.9', 'X', '73181500', 8.85, 400.00, 200.00, 3.230, 63.50, 5.62, 10.62, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2280, '316061010-0500', 'SHCSM6X1X10 GR 12.9', 'X', '73181500', 5.05, 3200.00, 200.00, 1.840, 63.50, 3.21, 6.06, 9.00, 0.17, 9.00, 0.17, 18.00, 0.33, 0.00, -3000.00, -5520.00, 'PCS', 0.00, 3000.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2281, '316061012-0500', 'SHCSM6X1X12 GR 12.9', 'X', '73181500', 5.95, 3200.00, 200.00, 2.170, 63.50, 3.78, 7.14, 9.00, 0.20, 9.00, 0.20, 18.00, 0.39, 0.00, -3000.00, -6510.00, 'PCS', 0.00, 3000.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2282, '316061014-0500', 'SHCSM6X1X14 GR 12.9', 'X', '73181500', 5.70, 3200.00, 200.00, 2.080, 63.50, 3.62, 6.84, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2283, '316061015-0500', 'SHCSM6X1X15 GR 12.9', 'X', '73181500', 5.70, 3200.00, 200.00, 2.080, 63.50, 3.62, 6.84, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2284, '316061016-0500', 'SHCSM6X1X16 GR 12.9', 'X', '73181500', 5.70, 3200.00, 200.00, 2.080, 63.50, 3.62, 6.84, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, -3000.00, -6240.00, 'PCS', 0.00, 3000.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2285, '316061018-0500', 'SHCSM6X1X18 GR 12.9', 'X', '73181500', 5.95, 3200.00, 200.00, 2.170, 63.50, 3.78, 7.14, 9.00, 0.20, 9.00, 0.20, 18.00, 0.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2286, '316061020-0500', 'SHCSM6X1X20 GR 12.9', 'X', '73181500', 5.95, 3200.00, 200.00, 2.170, 63.50, 3.78, 7.14, 9.00, 0.20, 9.00, 0.20, 18.00, 0.39, 0.00, -3000.00, -6510.00, 'PCS', 0.00, 3000.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2287, '316061022-0500', 'SHCSM6X1X22 GR 12.9', 'X', '73181500', 6.60, 2400.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2288, '316061025-0500', 'SHCSM6X1X25 GR 12.9', 'X', '73181500', 6.60, 2400.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, -3000.00, -7230.00, 'PCS', 0.00, 3000.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2289, '316061030-0500', 'SHCSM6X1X30 GR 12.9', 'X', '73181500', 7.50, 2400.00, 200.00, 2.740, 63.50, 4.76, 9.00, 9.00, 0.25, 9.00, 0.25, 18.00, 0.49, 0.00, -4000.00, -10960.00, 'PCS', 0.00, 4000.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2290, '316061035-0500', 'SHCSM6X1X35 GR 12.9', 'X', '73181500', 8.15, 1600.00, 200.00, 2.970, 63.50, 5.18, 9.78, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, -1000.00, -2970.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2291, '316061040-0500', 'SHCSM6X1X40 GR 12.9', 'X', '73181500', 8.80, 1600.00, 200.00, 3.210, 63.50, 5.59, 10.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, -1000.00, -3210.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2292, '316061045-0500', 'SHCSM6X1X45 GR 12.9', 'X', '73181500', 9.55, 1600.00, 200.00, 3.490, 63.50, 6.06, 11.46, 9.00, 0.31, 9.00, 0.31, 18.00, 0.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2293, '316061050-0500', 'SHCSM6X1X50 GR 12.9', 'X', '73181500', 10.20, 1200.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2294, '316061055-0500', 'SHCSM6X1X55 GR 12.9', 'X', '73181500', 11.05, 1200.00, 200.00, 4.030, 63.50, 7.02, 13.26, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2295, '316082008-0500', 'SHCSM8X1.25X8 GR 12.9', 'X', '73181500', 10.85, 2400.00, 200.00, 3.960, 63.50, 6.89, 13.02, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2296, '316082010-0500', 'SHCSM8X1.25X10 GR 12.9', 'X', '73181500', 9.90, 2400.00, 200.00, 3.610, 63.50, 6.29, 11.88, 9.00, 0.33, 9.00, 0.33, 18.00, 0.65, 0.00, -2000.00, -7220.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2297, '316082012-0500', 'SHCSM8X1.25X12 GR 12.9', 'X', '73181500', 7.55, 2400.00, 200.00, 2.760, 63.50, 4.79, 9.06, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, -2000.00, -5520.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2298, '316082014-0500', 'SHCSM8X1.25X14 GR 12.9', 'X', '73181500', 6.60, 2400.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2299, '316082015-0500', 'SHCSM8X1.25X15 GR 12.9', 'X', '73181500', 6.60, 1600.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2300, '316082016-0500', 'SHCSM8X1.25X16 GR 12.9', 'X', '73181500', 6.60, 1600.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, -5200.00, -12532.00, 'PCS', 0.00, 9200.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2301, '316082018-0500', 'SHCSM8X1.25X18 GR 12.9', 'X', '73181500', 6.90, 1600.00, 200.00, 2.520, 63.50, 4.38, 8.28, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2302, '316082020-0500', 'SHCSM8X1.25X20 GR 12.9', 'X', '73181500', 6.90, 1600.00, 200.00, 2.520, 63.50, 4.38, 8.28, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 10100.00, 25452.00, 'PCS', 0.00, 146300.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2303, '316082022-0500', 'SHCSM8X1.25X22 GR 12.9', 'X', '73181500', 7.70, 1600.00, 200.00, 2.810, 63.50, 4.89, 9.24, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2304, '316082025-0500', 'SHCSM8X1.25X25 GR 12.9', 'X', '73181500', 7.70, 1600.00, 200.00, 2.810, 63.50, 4.89, 9.24, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 32000.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2305, '316082030-0500', 'SHCSM8X1.25X30 GR 12.9', 'X', '73181500', 8.40, 1200.00, 200.00, 3.070, 63.50, 5.33, 10.08, 9.00, 0.28, 9.00, 0.28, 18.00, 0.55, 0.00, 3000.00, 9210.00, 'PCS', 0.00, 21000.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2306, '316082035-0500', 'SHCSM8X1.25X35 GR 12.9', 'X', '73181500', 9.15, 1200.00, 200.00, 3.340, 63.50, 5.81, 10.98, 9.00, 0.30, 9.00, 0.30, 18.00, 0.60, 0.00, -3000.00, -10020.00, 'PCS', 0.00, 5000.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2307, '316082040-0500', 'SHCSM8X1.25X40 GR 12.9', 'X', '73181500', 9.90, 800.00, 200.00, 3.610, 63.50, 6.29, 11.88, 9.00, 0.33, 9.00, 0.33, 18.00, 0.65, 0.00, -1900.00, -6859.00, 'PCS', 0.00, 4100.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2308, '316082045-0500', 'SHCSM8X1.25X45 GR 12.9', 'X', '73181500', 10.60, 800.00, 200.00, 3.870, 63.50, 6.73, 12.72, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, -2000.00, -7740.00, 'PCS', 0.00, 4000.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2309, '316082050-0500', 'SHCSM8X1.25X50 GR 12.9', 'X', '73181500', 11.05, 800.00, 200.00, 4.030, 63.50, 7.02, 13.26, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 9000.00, 36270.00, 'PCS', 0.00, 15000.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2310, '316082055-0500', 'SHCSM8X1.25X55 GR 12.9', 'X', '73181500', 12.15, 800.00, 200.00, 4.430, 63.50, 7.72, 14.58, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, -3000.00, -13290.00, 'PCS', 0.00, 3000.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2311, '316082060-0500', 'SHCSM8X1.25X60 GR 12.9', 'X', '73181500', 13.05, 600.00, 100.00, 4.760, 63.50, 8.29, 15.66, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, -3000.00, -14280.00, 'PCS', 0.00, 3000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2312, '316103010-0500', 'SHCSM10X1.5X10 GR 12.9', 'X', '73181500', 11.30, 1200.00, 200.00, 4.120, 63.50, 7.18, 13.56, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2313, '316103012-0500', 'SHCSM10X1.5X12 GR 12.9', 'X', '73181500', 11.30, 1200.00, 200.00, 4.120, 63.50, 7.18, 13.56, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2314, '316103014-0500', 'SHCSM10X1.5X14 GR 12.9', 'X', '73181500', 10.40, 1200.00, 200.00, 3.800, 63.50, 6.60, 12.48, 9.00, 0.34, 9.00, 0.34, 18.00, 0.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2315, '316103015-0500', 'SHCSM10X1.5X15 GR 12.9', 'X', '73181500', 10.40, 1200.00, 200.00, 3.800, 63.50, 6.60, 12.48, 9.00, 0.34, 9.00, 0.34, 18.00, 0.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2316, '316103016-0500', 'SHCSM10X1.5X16 GR 12.9', 'X', '73181500', 10.40, 800.00, 200.00, 3.800, 63.50, 6.60, 12.48, 9.00, 0.34, 9.00, 0.34, 18.00, 0.68, 0.00, -1000.00, -3800.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2317, '316103018-0500', 'SHCSM10X1.5X18 GR 12.9', 'X', '73181500', 9.55, 1200.00, 200.00, 3.490, 63.50, 6.06, 11.46, 9.00, 0.31, 9.00, 0.31, 18.00, 0.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2318, '316103020-0500', 'SHCSM10X1.5X20 GR 12.9', 'X', '73181500', 9.55, 800.00, 200.00, 3.490, 63.50, 6.06, 11.46, 9.00, 0.31, 9.00, 0.31, 18.00, 0.63, 0.00, -2000.00, -6980.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2319, '316103022-0500', 'SHCSM10X1.5X22 GR 12.9', 'X', '73181500', 10.45, 800.00, 200.00, 3.810, 63.50, 6.64, 12.54, 9.00, 0.34, 9.00, 0.34, 18.00, 0.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2320, '316103025-0500', 'SHCSM10X1.5X25 GR 12.9', 'X', '73181500', 10.45, 800.00, 200.00, 3.810, 63.50, 6.64, 12.54, 9.00, 0.34, 9.00, 0.34, 18.00, 0.69, 0.00, -2000.00, -7620.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2321, '316103028-0500', 'SHCSM10X1.5X28 GR 12.9', 'X', '73181500', 11.50, 800.00, 100.00, 4.200, 63.50, 7.30, 13.80, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2322, '316103030-0500', 'SHCSM10X1.5X30 GR 12.9', 'X', '73181500', 11.50, 800.00, 100.00, 4.200, 63.50, 7.30, 13.80, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, -2000.00, -8400.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2323, '316103035-0500', 'SHCSM10X1.5X35 GR 12.9', 'X', '73181500', 12.45, 600.00, 100.00, 4.540, 63.50, 7.91, 14.94, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, -2000.00, -9080.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2324, '316103040-0500', 'SHCSM10X1.5X40 GR 12.9', 'X', '73181500', 13.25, 600.00, 100.00, 4.840, 63.50, 8.41, 15.90, 9.00, 0.44, 9.00, 0.44, 18.00, 0.87, 0.00, -2000.00, -9680.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2325, '316103045-0500', 'SHCSM10X1.5X45 GR 12.9', 'X', '73181500', 14.30, 600.00, 100.00, 5.220, 63.50, 9.08, 17.16, 9.00, 0.47, 9.00, 0.47, 18.00, 0.94, 0.00, -2000.00, -10440.00, 'PCS', 0.00, 2000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2326, '316103050-0500', 'SHCSM10X1.5X50 GR 12.9', 'X', '73181500', 15.25, 400.00, 100.00, 5.570, 63.50, 9.68, 18.30, 9.00, 0.50, 9.00, 0.50, 18.00, 1.00, 0.00, -1000.00, -5570.00, 'PCS', 0.00, 3000.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2327, '316103055-0500', 'SHCSM10X1.5X55 GR 12.9', 'X', '73181500', 16.45, 400.00, 100.00, 6.000, 63.50, 10.45, 19.74, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, -1000.00, -6000.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2328, '316103060-0500', 'SHCSM10X1.5X60 GR 12.9', 'X', '73181500', 17.75, 400.00, 100.00, 6.480, 63.50, 11.27, 21.30, 9.00, 0.58, 9.00, 0.58, 18.00, 1.17, 0.00, -1000.00, -6480.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2329, '316103065-0500', 'SHCSM10X1.5X65 GR 12.9', 'X', '73181500', 19.20, 400.00, 100.00, 7.010, 63.50, 12.19, 23.04, 9.00, 0.63, 9.00, 0.63, 18.00, 1.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2330, '316124016-0500', 'SHCSM12X1.75X16 GR 12.9', 'X', '73181500', 30.85, 600.00, 100.00, 11.260, 63.50, 19.59, 37.02, 9.00, 1.01, 9.00, 1.01, 18.00, 2.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2331, '316124020-0500', 'SHCSM12X1.75X20 GR 12.9', 'X', '73181500', 27.50, 600.00, 100.00, 10.040, 63.50, 17.46, 33.00, 9.00, 0.90, 9.00, 0.90, 18.00, 1.81, 0.00, -1000.00, -10040.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2332, '316124025-0500', 'SHCSM12X1.75X25 GR 12.9', 'X', '73181500', 23.95, 600.00, 100.00, 8.740, 63.50, 15.21, 28.74, 9.00, 0.79, 9.00, 0.79, 18.00, 1.57, 0.00, -1000.00, -8740.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2333, '316124028-0500', 'SHCSM12X1.75X28 GR 12.9', 'X', '73181500', 23.95, 400.00, 100.00, 8.740, 63.50, 15.21, 28.74, 9.00, 0.79, 9.00, 0.79, 18.00, 1.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2334, '316124030-0500', 'SHCSM12X1.75X30 GR 12.9', 'X', '73181500', 23.95, 400.00, 100.00, 8.740, 63.50, 15.21, 28.74, 9.00, 0.79, 9.00, 0.79, 18.00, 1.57, 0.00, -1000.00, -8740.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2335, '316124032-0500', 'SHCSM12X1.75X32 GR 12.9', 'X', '73181500', 23.40, 400.00, 100.00, 8.540, 63.50, 14.86, 28.08, 9.00, 0.77, 9.00, 0.77, 18.00, 1.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2336, '316124035-0500', 'SHCSM12X1.75X35 GR 12.9', 'X', '73181500', 24.55, 400.00, 100.00, 8.960, 63.50, 15.59, 29.46, 9.00, 0.81, 9.00, 0.81, 18.00, 1.61, 0.00, -1000.00, -8960.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2337, '316124040-0500', 'SHCSM12X1.75X40 GR 12.9', 'X', '73181500', 24.70, 400.00, 100.00, 9.020, 63.50, 15.68, 29.64, 9.00, 0.81, 9.00, 0.81, 18.00, 1.62, 0.00, -1000.00, -9020.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2338, '316124045-0500', 'SHCSM12X1.75X45 GR 12.9', 'X', '73181500', 25.10, 300.00, 50.00, 9.160, 63.50, 15.94, 30.12, 9.00, 0.82, 9.00, 0.82, 18.00, 1.65, 0.00, -1000.00, -9160.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(2339, '316124050-0500', 'SHCSM12X1.75X50 GR 12.9', 'X', '73181500', 25.70, 300.00, 50.00, 9.380, 63.50, 16.32, 30.84, 9.00, 0.84, 9.00, 0.84, 18.00, 1.69, 0.00, -1000.00, -9380.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2340, '316124055-0500', 'SHCSM12X1.75X55 GR 12.9', 'X', '73181500', 27.10, 300.00, 50.00, 9.890, 63.50, 17.21, 32.52, 9.00, 0.89, 9.00, 0.89, 18.00, 1.78, 0.00, -1000.00, -9890.00, 'PCS', 0.00, 1000.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2341, '316124060-0500', 'SHCSM12X1.75X60 GR 12.9', 'X', '73181500', 28.65, 300.00, 50.00, 10.460, 63.50, 18.19, 34.38, 9.00, 0.94, 9.00, 0.94, 18.00, 1.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2342, '316124065-0500', 'SHCSM12X1.75X65 GR 12.9', 'X', '73181500', 30.15, 200.00, 50.00, 11.000, 63.50, 19.15, 36.18, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2343, '316124070-0500', 'SHCSM12X1.75X70 GR 12.9', 'X', '73181500', 31.80, 200.00, 50.00, 11.610, 63.50, 20.19, 38.16, 9.00, 1.04, 9.00, 1.04, 18.00, 2.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2344, '316124075-0500', 'SHCSM12X1.75X75 GR 12.9', 'X', '73181500', 33.20, 200.00, 50.00, 12.120, 63.50, 21.08, 39.84, 9.00, 1.09, 9.00, 1.09, 18.00, 2.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2345, '316124080-0500', 'SHCSM12X1.75X80 GR 12.9', 'X', '73181500', 39.80, 200.00, 50.00, 14.530, 63.50, 25.27, 47.76, 9.00, 1.31, 9.00, 1.31, 18.00, 2.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2346, '316124090-0500', 'SHCSM12X1.75X90 GR 12.9', 'X', '73181500', 45.00, 200.00, 50.00, 16.430, 63.50, 28.58, 54.00, 9.00, 1.48, 9.00, 1.48, 18.00, 2.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2347, '316124100-0500', 'SHCSM12X1.75X100 GR 12.9', 'X', '73181500', 52.05, 200.00, 50.00, 19.000, 63.50, 33.05, 62.46, 9.00, 1.71, 9.00, 1.71, 18.00, 3.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2348, '316145020-0500', 'SHCSM14X2X20 GR 12.9', 'X', '73181500', 69.10, 400.00, 100.00, 25.220, 63.50, 43.88, 82.92, 9.00, 2.27, 9.00, 2.27, 18.00, 4.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2349, '316145025-0500', 'SHCSM14X2X25 GR 12.9', 'X', '73181500', 62.30, 400.00, 100.00, 22.740, 63.50, 39.56, 74.76, 9.00, 2.05, 9.00, 2.05, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2350, '316145030-0500', 'SHCSM14X2X30 GR 12.9', 'X', '73181500', 62.30, 400.00, 100.00, 22.740, 63.50, 39.56, 74.76, 9.00, 2.05, 9.00, 2.05, 18.00, 4.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2351, '316145035-0500', 'SHCSM14X2X35 GR 12.9', 'X', '73181500', 52.40, 300.00, 50.00, 19.130, 63.50, 33.27, 62.88, 9.00, 1.72, 9.00, 1.72, 18.00, 3.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2352, '316145040-0500', 'SHCSM14X2X40 GR 12.9', 'X', '73181500', 53.65, 300.00, 50.00, 19.580, 63.50, 34.07, 64.38, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2353, '316145045-0500', 'SHCSM14X2X45 GR 12.9', 'X', '73181500', 54.55, 200.00, 50.00, 19.910, 63.50, 34.64, 65.46, 9.00, 1.79, 9.00, 1.79, 18.00, 3.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2354, '316145050-0500', 'SHCSM14X2X50 GR 12.9', 'X', '73181500', 55.85, 200.00, 50.00, 20.390, 63.50, 35.46, 67.02, 9.00, 1.83, 9.00, 1.83, 18.00, 3.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2355, '316145055-0500', 'SHCSM14X2X55 GR 12.9', 'X', '73181500', 56.50, 200.00, 50.00, 20.620, 63.50, 35.88, 67.80, 9.00, 1.86, 9.00, 1.86, 18.00, 3.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2356, '316165016-0500', 'SHCSM16X2X16 GR 12.9', 'X', '73181500', 78.30, 300.00, 50.00, 28.580, 63.50, 49.72, 93.96, 9.00, 2.57, 9.00, 2.57, 18.00, 5.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2357, '316165020-0500', 'SHCSM16X2X20 GR 12.9', 'X', '73181500', 60.65, 300.00, 50.00, 22.140, 63.50, 38.51, 72.78, 9.00, 1.99, 9.00, 1.99, 18.00, 3.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2358, '316165025-0500', 'SHCSM16X2X25 GR 12.9', 'X', '73181500', 60.65, 300.00, 50.00, 22.140, 63.50, 38.51, 72.78, 9.00, 1.99, 9.00, 1.99, 18.00, 3.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2359, '316165030-0500', 'SHCSM16X2X30 GR 12.9', 'X', '73181500', 60.65, 200.00, 50.00, 22.140, 63.50, 38.51, 72.78, 9.00, 1.99, 9.00, 1.99, 18.00, 3.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2360, '316165035-0500', 'SHCSM16X2X35 GR 12.9', 'X', '73181500', 51.00, 200.00, 50.00, 18.620, 63.50, 32.39, 61.20, 9.00, 1.68, 9.00, 1.68, 18.00, 3.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2361, '316165040-0500', 'SHCSM16X2X40 GR 12.9', 'X', '73181500', 52.25, 200.00, 50.00, 19.070, 63.50, 33.18, 62.70, 9.00, 1.72, 9.00, 1.72, 18.00, 3.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2362, '316165045-0500', 'SHCSM16X2X45 GR 12.9', 'X', '73181500', 53.15, 200.00, 50.00, 19.400, 63.50, 33.75, 63.78, 9.00, 1.75, 9.00, 1.75, 18.00, 3.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2363, '316165050-0500', 'SHCSM16X2X50 GR 12.9', 'X', '73181500', 54.30, 200.00, 50.00, 19.820, 63.50, 34.48, 65.16, 9.00, 1.78, 9.00, 1.78, 18.00, 3.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2364, '316165055-0500', 'SHCSM16X2X55 GR 12.9', 'X', '73181500', 55.10, 200.00, 50.00, 20.110, 63.50, 34.99, 66.12, 9.00, 1.81, 9.00, 1.81, 18.00, 3.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2365, '316165060-0500', 'SHCSM16X2X60 GR 12.9', 'X', '73181500', 58.35, 120.00, 10.00, 21.300, 63.50, 37.05, 70.02, 9.00, 1.92, 9.00, 1.92, 18.00, 3.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2366, '316165065-0500', 'SHCSM16X2X65 GR 12.9', 'X', '73181500', 59.20, 120.00, 10.00, 21.610, 63.50, 37.59, 71.04, 9.00, 1.94, 9.00, 1.94, 18.00, 3.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2367, '316165070-0500', 'SHCSM16X2X70 GR 12.9', 'X', '73181500', 63.85, 120.00, 10.00, 23.310, 63.50, 40.54, 76.62, 9.00, 2.10, 9.00, 2.10, 18.00, 4.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2368, '316165075-0500', 'SHCSM16X2X75 GR 12.9', 'X', '73181500', 67.55, 120.00, 10.00, 24.660, 63.50, 42.89, 81.06, 9.00, 2.22, 9.00, 2.22, 18.00, 4.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2369, '316165080-0500', 'SHCSM16X2X80 GR 12.9', 'X', '73181500', 70.70, 120.00, 10.00, 25.810, 63.50, 44.89, 84.84, 9.00, 2.32, 9.00, 2.32, 18.00, 4.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2370, '316165085-0500', 'SHCSM16X2X85 GR 12.9', 'X', '73181500', 72.25, 80.00, 10.00, 26.370, 63.50, 45.88, 86.70, 9.00, 2.37, 9.00, 2.37, 18.00, 4.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2371, '316165090-0500', 'SHCSM16X2X90 GR 12.9', 'X', '73181500', 72.25, 80.00, 10.00, 26.370, 63.50, 45.88, 86.70, 9.00, 2.37, 9.00, 2.37, 18.00, 4.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2372, '316165100-0500', 'SHCSM16X2X100 GR 12.9', 'X', '73181500', 89.70, 80.00, 10.00, 32.740, 63.50, 56.96, 107.64, 9.00, 2.95, 9.00, 2.95, 18.00, 5.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2373, '316187030-0500', 'SHCSM18X2.5X30 GR 12.9', 'X', '73181500', 163.05, 200.00, 50.00, 59.510, 63.50, 103.54, 195.66, 9.00, 5.36, 9.00, 5.36, 18.00, 10.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2374, '316187035-0500', 'SHCSM18X2.5X35 GR 12.9', 'X', '73181500', 165.15, 200.00, 50.00, 60.280, 63.50, 104.87, 198.18, 9.00, 5.43, 9.00, 5.43, 18.00, 10.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2375, '316187040-0500', 'SHCSM18X2.5X40 GR 12.9', 'X', '73181500', 144.55, 120.00, 10.00, 52.760, 63.50, 91.79, 173.46, 9.00, 4.75, 9.00, 4.75, 18.00, 9.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2376, '316187045-0500', 'SHCSM18X2.5X45 GR 12.9', 'X', '73181500', 145.55, 120.00, 10.00, 53.130, 63.50, 92.42, 174.66, 9.00, 4.78, 9.00, 4.78, 18.00, 9.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2377, '316187050-0500', 'SHCSM18X2.5X50 GR 12.9', 'X', '73181500', 146.80, 120.00, 10.00, 53.580, 63.50, 93.22, 176.16, 9.00, 4.82, 9.00, 4.82, 18.00, 9.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2378, '316187055-0500', 'SHCSM18X2.5X55 GR 12.9', 'X', '73181500', 147.70, 120.00, 10.00, 53.910, 63.50, 93.79, 177.24, 9.00, 4.85, 9.00, 4.85, 18.00, 9.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2379, '316187060-0500', 'SHCSM18X2.5X60 GR 12.9', 'X', '73181500', 148.80, 120.00, 10.00, 54.310, 63.50, 94.49, 178.56, 9.00, 4.89, 9.00, 4.89, 18.00, 9.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2380, '316187065-0500', 'SHCSM18X2.5X65 GR 12.9', 'X', '73181500', 150.10, 40.00, 10.00, 54.790, 63.50, 95.31, 180.12, 9.00, 4.93, 9.00, 4.93, 18.00, 9.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2381, '316207025-0500', 'SHCSM20X2.5X25 GR 12.9', 'X', '73181500', 148.20, 20.00, 10.00, 54.090, 63.50, 94.11, 177.84, 9.00, 4.87, 9.00, 4.87, 18.00, 9.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2382, '316207030-0500', 'SHCSM20X2.5X30 GR 12.9', 'X', '73181500', 148.20, 120.00, 10.00, 54.090, 63.50, 94.11, 177.84, 9.00, 4.87, 9.00, 4.87, 18.00, 9.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2383, '316207035-0500', 'SHCSM20X2.5X35 GR 12.9', 'X', '73181500', 150.10, 120.00, 10.00, 54.790, 63.50, 95.31, 180.12, 9.00, 4.93, 9.00, 4.93, 18.00, 9.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2384, '316207040-0500', 'SHCSM20X2.5X40 GR 12.9', 'X', '73181500', 131.50, 120.00, 10.00, 48.000, 63.50, 83.50, 157.80, 9.00, 4.32, 9.00, 4.32, 18.00, 8.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2385, '316207045-0500', 'SHCSM20X2.5X45 GR 12.9', 'X', '73181500', 132.45, 120.00, 10.00, 48.340, 63.50, 84.11, 158.94, 9.00, 4.35, 9.00, 4.35, 18.00, 8.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2386, '316207050-0500', 'SHCSM20X2.5X50 GR 12.9', 'X', '73181500', 133.45, 120.00, 10.00, 48.710, 63.50, 84.74, 160.14, 9.00, 4.38, 9.00, 4.38, 18.00, 8.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2387, '316207055-0500', 'SHCSM20X2.5X55 GR 12.9', 'X', '73181500', 134.25, 40.00, 10.00, 49.000, 63.50, 85.25, 161.10, 9.00, 4.41, 9.00, 4.41, 18.00, 8.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2388, '316207060-0500', 'SHCSM20X2.5X60 GR 12.9', 'X', '73181500', 135.20, 40.00, 10.00, 49.350, 63.50, 85.85, 162.24, 9.00, 4.44, 9.00, 4.44, 18.00, 8.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2389, '316207065-0500', 'SHCSM20X2.5X65 GR 12.9', 'X', '73181500', 136.45, 40.00, 10.00, 49.800, 63.50, 86.65, 163.74, 9.00, 4.48, 9.00, 4.48, 18.00, 8.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2390, '316207070-0500', 'SHCSM20X2.5X70 GR 12.9', 'X', '73181500', 145.75, 40.00, 10.00, 53.200, 63.50, 92.55, 174.90, 9.00, 4.79, 9.00, 4.79, 18.00, 9.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2391, '316207075-0500', 'SHCSM20X2.5X75 GR 12.9', 'X', '73181500', 155.25, 40.00, 10.00, 56.670, 63.50, 98.58, 186.30, 9.00, 5.10, 9.00, 5.10, 18.00, 10.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2392, '316207080-0500', 'SHCSM20X2.5X80 GR 12.9', 'X', '73181500', 158.30, 60.00, 10.00, 57.780, 63.50, 100.52, 189.96, 9.00, 5.20, 9.00, 5.20, 18.00, 10.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2393, '316207090-0500', 'SHCSM20X2.5X90 GR 12.9', 'X', '73181500', 161.45, 60.00, 10.00, 58.930, 63.50, 102.52, 193.74, 9.00, 5.30, 9.00, 5.30, 18.00, 10.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2394, '316207100-0500', 'SHCSM20X2.5X100 GR 12.9', 'X', '73181500', 169.30, 60.00, 10.00, 61.790, 63.50, 107.51, 203.16, 9.00, 5.56, 9.00, 5.56, 18.00, 11.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2395, '316227050-0500', 'SHCSM22X2.5X50 GR 12.9', 'X', '73181500', 170.55, 40.00, 10.00, 62.250, 63.50, 108.30, 204.66, 9.00, 5.60, 9.00, 5.60, 18.00, 11.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2396, '316227055-0500', 'SHCSM22X2.5X55 GR 12.9', 'X', '73181500', 191.75, 40.00, 10.00, 69.990, 63.50, 121.76, 230.10, 9.00, 6.30, 9.00, 6.30, 18.00, 12.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2397, '316227060-0500', 'SHCSM22X2.5X60 GR 12.9', 'X', '73181500', 197.15, 40.00, 10.00, 71.960, 63.50, 125.19, 236.58, 9.00, 6.48, 9.00, 6.48, 18.00, 12.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2398, '316227065-0500', 'SHCSM22X2.5X65 GR 12.9', 'X', '73181500', 219.60, 40.00, 10.00, 80.150, 63.50, 139.45, 263.52, 9.00, 7.21, 9.00, 7.21, 18.00, 14.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2399, '316227070-0500', 'SHCSM22X2.5X70 GR 12.9', 'X', '73181500', 213.05, 60.00, 10.00, 77.760, 63.50, 135.29, 255.66, 9.00, 7.00, 9.00, 7.00, 18.00, 14.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2400, '316227075-0500', 'SHCSM22X2.5X75 GR 12.9', 'X', '73181500', 249.30, 60.00, 10.00, 90.990, 63.50, 158.31, 299.16, 9.00, 8.19, 9.00, 8.19, 18.00, 16.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2401, '316227080-0500', 'SHCSM22X2.5X80 GR 12.9', 'X', '73181500', 249.30, 60.00, 10.00, 90.990, 63.50, 158.31, 299.16, 9.00, 8.19, 9.00, 8.19, 18.00, 16.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2402, '316227090-0500', 'SHCSM22X2.5X90 GR 12.9', 'X', '73181500', 261.40, 40.00, 5.00, 95.410, 63.50, 165.99, 313.68, 9.00, 8.59, 9.00, 8.59, 18.00, 17.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2403, '316249040-0500', 'SHCSM24X3X40 GR 12.9', 'X', '73181500', 158.55, 40.00, 10.00, 57.870, 63.50, 100.68, 190.26, 9.00, 5.21, 9.00, 5.21, 18.00, 10.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2404, '316249045-0500', 'SHCSM24X3X45 GR 12.9', 'X', '73181500', 162.55, 60.00, 10.00, 59.330, 63.50, 103.22, 195.06, 9.00, 5.34, 9.00, 5.34, 18.00, 10.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2405, '316249050-0500', 'SHCSM24X3X50 GR 12.9', 'X', '73181500', 155.75, 60.00, 10.00, 56.850, 63.50, 98.90, 186.90, 9.00, 5.12, 9.00, 5.12, 18.00, 10.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2406, '316249055-0500', 'SHCSM24X3X55 GR 12.9', 'X', '73181500', 175.15, 60.00, 10.00, 63.930, 63.50, 111.22, 210.18, 9.00, 5.75, 9.00, 5.75, 18.00, 11.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2407, '316249060-0500', 'SHCSM24X3X60 GR 12.9', 'X', '73181500', 180.05, 60.00, 5.00, 65.720, 63.50, 114.33, 216.06, 9.00, 5.91, 9.00, 5.91, 18.00, 11.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2408, '316249065-0500', 'SHCSM24X3X65 GR 12.9', 'X', '73181500', 200.50, 60.00, 5.00, 73.180, 63.50, 127.32, 240.60, 9.00, 6.59, 9.00, 6.59, 18.00, 13.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2409, '316249070-0500', 'SHCSM24X3X70 GR 12.9', 'X', '73181500', 204.25, 20.00, 5.00, 74.550, 63.50, 129.70, 245.10, 9.00, 6.71, 9.00, 6.71, 18.00, 13.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2410, '316249075-0500', 'SHCSM24X3X75 GR 12.9', 'X', '73181500', 216.40, 20.00, 5.00, 78.990, 63.50, 137.41, 259.68, 9.00, 7.11, 9.00, 7.11, 18.00, 14.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2411, '316249080-0500', 'SHCSM24X3X80 GR 12.9', 'X', '73181500', 227.55, 20.00, 5.00, 83.060, 63.50, 144.49, 273.06, 9.00, 7.48, 9.00, 7.48, 18.00, 14.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2412, '316249085-0500', 'SHCSM24X3X85 GR 12.9', 'X', '73181500', 238.70, 20.00, 5.00, 87.130, 63.50, 151.57, 286.44, 9.00, 7.84, 9.00, 7.84, 18.00, 15.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2413, '316249090-0500', 'SHCSM24X3X90 GR 12.9', 'X', '73181500', 238.70, 20.00, 5.00, 87.130, 63.50, 151.57, 286.44, 9.00, 7.84, 9.00, 7.84, 18.00, 15.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2414, '316249100-0500', 'SHCSM24X3X100 GR 12.9', 'X', '73181500', 251.75, 20.00, 5.00, 91.890, 63.50, 159.86, 302.10, 9.00, 8.27, 9.00, 8.27, 18.00, 16.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2415, '316249110-0500', 'SHCSM24X3X110 GR 12.9', 'X', '73181500', 273.75, 30.00, 5.00, 99.920, 63.50, 173.83, 328.50, 9.00, 8.99, 9.00, 8.99, 18.00, 17.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2416, '316249120-0500', 'SHCSM24X3X120 GR 12.9', 'X', '73181500', 295.90, 30.00, 5.00, 108.000, 63.50, 187.90, 355.08, 9.00, 9.72, 9.00, 9.72, 18.00, 19.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2417, '316279070-0500', 'SHCSM27X3X70 GR 12.9', 'X', '73181500', 386.55, 15.00, 5.00, 141.090, 63.50, 245.46, 463.86, 9.00, 12.70, 9.00, 12.70, 18.00, 25.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2418, '316279075-0500', 'SHCSM27X3X75 GR 12.9', 'X', '73181500', 386.55, 15.00, 5.00, 141.090, 63.50, 245.46, 463.86, 9.00, 12.70, 9.00, 12.70, 18.00, 25.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2419, '316279080-0500', 'SHCSM27X3X80 GR 12.9', 'X', '73181500', 386.55, 15.00, 5.00, 141.090, 63.50, 245.46, 463.86, 9.00, 12.70, 9.00, 12.70, 18.00, 25.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2420, '316279090-0500', 'SHCSM27X3X90 GR 12.9', 'X', '73181500', 424.40, 15.00, 5.00, 154.910, 63.50, 269.49, 509.28, 9.00, 13.94, 9.00, 13.94, 18.00, 27.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2421, '316279100-0500', 'SHCSM27X3X100 GR 12.9', 'X', '73181500', 453.75, 15.00, 5.00, 165.620, 63.50, 288.13, 544.50, 9.00, 14.91, 9.00, 14.91, 18.00, 29.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2422, '316307045-0500', 'SHCSM30X3.5X45 GR 12.9', 'X', '73181500', 424.40, 15.00, 5.00, 154.910, 63.50, 269.49, 509.28, 9.00, 13.94, 9.00, 13.94, 18.00, 27.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2423, '316307050-0500', 'SHCSM30X3.5X50 GR 12.9', 'X', '73181500', 424.40, 15.00, 5.00, 154.910, 63.50, 269.49, 509.28, 9.00, 13.94, 9.00, 13.94, 18.00, 27.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2424, '316307055-0500', 'SHCSM30X3.5X55 GR 12.9', 'X', '73181500', 424.40, 15.00, 5.00, 154.910, 63.50, 269.49, 509.28, 9.00, 13.94, 9.00, 13.94, 18.00, 27.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2425, '316307060-0500', 'SHCSM30X3.5X60 GR 12.9', 'X', '73181500', 371.90, 15.00, 5.00, 135.740, 63.50, 236.16, 446.28, 9.00, 12.22, 9.00, 12.22, 18.00, 24.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2426, '316307065-0500', 'SHCSM30X3.5X65 GR 12.9', 'X', '73181500', 371.90, 15.00, 5.00, 135.740, 63.50, 236.16, 446.28, 9.00, 12.22, 9.00, 12.22, 18.00, 24.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2427, '316307070-0500', 'SHCSM30X3.5X70 GR 12.9', 'X', '73181500', 371.90, 15.00, 5.00, 135.740, 63.50, 236.16, 446.28, 9.00, 12.22, 9.00, 12.22, 18.00, 24.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2428, '316307075-0500', 'SHCSM30X3.5X75 GR 12.9', 'X', '73181500', 371.90, 15.00, 5.00, 135.740, 63.50, 236.16, 446.28, 9.00, 12.22, 9.00, 12.22, 18.00, 24.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2429, '316307080-0500', 'SHCSM30X3.5X80 GR 12.9', 'X', '73181500', 386.55, 20.00, 5.00, 141.090, 63.50, 245.46, 463.86, 9.00, 12.70, 9.00, 12.70, 18.00, 25.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2430, '316307090-0500', 'SHCSM30X3.5X90 GR 12.9', 'X', '73181500', 424.40, 20.00, 5.00, 154.910, 63.50, 269.49, 509.28, 9.00, 13.94, 9.00, 13.94, 18.00, 27.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2431, '316307100-0500', 'SHCSM30X3.5X100 GR 12.9', 'X', '73181500', 453.75, 20.00, 5.00, 165.620, 63.50, 288.13, 544.50, 9.00, 14.91, 9.00, 14.91, 18.00, 29.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2432, '316337075-0500', 'SHCSM33X3.5X75 GR 12.9', 'X', '73181500', 558.80, 8.00, 2.00, 203.960, 63.50, 354.84, 670.56, 9.00, 18.36, 9.00, 18.36, 18.00, 36.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2433, '316337080-0500', 'SHCSM33X3.5X80 GR 12.9', 'X', '73181500', 581.90, 8.00, 2.00, 212.390, 63.50, 369.51, 698.28, 9.00, 19.12, 9.00, 19.12, 18.00, 38.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2434, '316337090-0500', 'SHCSM33X3.5X90 GR 12.9', 'X', '73181500', 630.20, 8.00, 2.00, 230.020, 63.50, 400.18, 756.24, 9.00, 20.70, 9.00, 20.70, 18.00, 41.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2435, '316337100-0500', 'SHCSM33X3.5X100 GR 12.9', 'X', '73181500', 659.65, 20.00, 5.00, 240.770, 63.50, 418.88, 791.58, 9.00, 21.67, 9.00, 21.67, 18.00, 43.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2436, '316337150-0500', 'SHCSM33X3.5X150 GR 12.9', 'X', '73181500', 844.15, 20.00, 5.00, 308.110, 63.50, 536.04, 1012.98, 9.00, 27.73, 9.00, 27.73, 18.00, 55.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2437, '316369080-0500', 'SHCSM36X4X80 GR 12.9', 'X', '73181500', 695.35, 6.00, 2.00, 253.800, 63.50, 441.55, 834.42, 9.00, 22.84, 9.00, 22.84, 18.00, 45.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2438, '316369090-0500', 'SHCSM36X4X90 GR 12.9', 'X', '73181500', 758.30, 6.00, 2.00, 276.780, 63.50, 481.52, 909.96, 9.00, 24.91, 9.00, 24.91, 18.00, 49.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2439, '316369100-0500', 'SHCSM36X4X100 GR 12.9', 'X', '73181500', 779.35, 6.00, 2.00, 284.460, 63.50, 494.89, 935.22, 9.00, 25.60, 9.00, 25.60, 18.00, 51.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2440, '316369110-0500', 'SHCSM36X4X110 GR 12.9', 'X', '73181500', 823.45, 6.00, 2.00, 300.560, 63.50, 522.89, 988.14, 9.00, 27.05, 9.00, 27.05, 18.00, 54.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2441, '316369120-0500', 'SHCSM36X4X120 GR 12.9', 'X', '73181500', 857.10, 6.00, 2.00, 312.840, 63.50, 544.26, 1028.52, 9.00, 28.16, 9.00, 28.16, 18.00, 56.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2442, '326061006-0500', 'SHCS3/16BSWX3/8', 'X', '73181500', 6.75, 600.00, 200.00, 2.460, 63.50, 4.29, 8.10, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2443, '326061008-0500', 'SHCS3/16BSWX1/2', 'X', '73181500', 6.75, 600.00, 200.00, 2.460, 63.50, 4.29, 8.10, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2444, '326061010-0500', 'SHCS3/16BSWX5/8', 'X', '73181500', 6.30, 400.00, 200.00, 2.300, 63.50, 4.00, 7.56, 9.00, 0.21, 9.00, 0.21, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2445, '326061012-0500', 'SHCS3/16BSWX3/4.', 'X', '73181500', 6.75, 1600.00, 200.00, 2.460, 63.50, 4.29, 8.10, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2446, '326061014-0500', 'SHCS3/16BSWX7/8', 'X', '73181500', 7.25, 1600.00, 200.00, 2.650, 63.50, 4.60, 8.70, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2447, '326061100-0500', 'SHCS3/16BSWX1', 'X', '73181500', 7.50, 1600.00, 200.00, 2.740, 63.50, 4.76, 9.00, 9.00, 0.25, 9.00, 0.25, 18.00, 0.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2448, '326062006-0500', 'SHCS3/16BSFX3/8', 'X', '73181500', 8.25, 600.00, 200.00, 3.010, 63.50, 5.24, 9.90, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2449, '326062008-0500', 'SHCS3/8BSFX1/2.', 'X', '73181500', 8.25, 600.00, 200.00, 3.010, 63.50, 5.24, 9.90, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2450, '326062010-0500', 'SHCS3/16BSFX5/8', 'X', '73181500', 7.65, 1600.00, 200.00, 2.790, 63.50, 4.86, 9.18, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2451, '326062012-0500', 'SHCS3/16BSFX3/4', 'X', '73181500', 8.25, 2400.00, 200.00, 3.010, 63.50, 5.24, 9.90, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2452, '326062014-0500', 'SHCS3/16BSFX7/8', 'X', '73181500', 8.90, 1600.00, 200.00, 3.250, 63.50, 5.65, 10.68, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2453, '326062100-0500', 'SHCS3/16BSFX1', 'X', '73181500', 9.25, 1600.00, 200.00, 3.380, 63.50, 5.87, 11.10, 9.00, 0.30, 9.00, 0.30, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2454, '326081006-0500', 'SHCS1/4BSWX3/8', 'X', '73181500', 6.50, 600.00, 200.00, 2.370, 63.50, 4.13, 7.80, 9.00, 0.21, 9.00, 0.21, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2455, '326081008-0500', 'SHCS1/4BSWX1/2.', 'X', '73181500', 6.50, 400.00, 200.00, 2.370, 63.50, 4.13, 7.80, 9.00, 0.21, 9.00, 0.21, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2456, '326081010-0500', 'SHCS1/4BSWX5/8.', 'X', '73181500', 6.25, 400.00, 200.00, 2.280, 63.50, 3.97, 7.50, 9.00, 0.21, 9.00, 0.21, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2457, '326081012-0500', 'SHCS1/4BSWX3/4.', 'X', '73181500', 6.50, 400.00, 200.00, 2.370, 63.50, 4.13, 7.80, 9.00, 0.21, 9.00, 0.21, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2458, '326081014-0500', 'SHCS1/4BSWX7/8.', 'X', '73181500', 6.85, 2400.00, 200.00, 2.500, 63.50, 4.35, 8.22, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2459, '326081100-0500', 'SHCS1/4BSWX1.', 'X', '73181500', 7.30, 2400.00, 200.00, 2.660, 63.50, 4.64, 8.76, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2460, '326081104-0500', 'SHCS1/4BSWX1-1/4.', 'X', '73181500', 8.20, 2400.00, 200.00, 2.990, 63.50, 5.21, 9.84, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2461, '326081108-0500', 'SHCS1/4BSWX1-1/2.', 'X', '73181500', 9.10, 800.00, 200.00, 3.320, 63.50, 5.78, 10.92, 9.00, 0.30, 9.00, 0.30, 18.00, 0.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2462, '326081112-0500', 'SHCS1/4BSWX1-3/4.', 'X', '73181500', 11.20, 800.00, 200.00, 4.090, 63.50, 7.11, 13.44, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2463, '326082006-0500', 'SHCS1/4BSFX3/8.', 'X', '73181500', 8.00, 400.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2464, '326082008-0500', 'SHCS1/4BSFX1/2.', 'X', '73181500', 8.00, 400.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2465, '326082010-0500', 'SHCS1/4BSFX5/8.', 'X', '73181500', 7.65, 400.00, 200.00, 2.790, 63.50, 4.86, 9.18, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2466, '326082012-0500', 'SHCS1/4BSFX3/4.', 'X', '73181500', 8.00, 400.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2467, '326082014-0500', 'SHCS1/4BSFX7/8.', 'X', '73181500', 8.45, 400.00, 200.00, 3.080, 63.50, 5.37, 10.14, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2468, '326082100-0500', 'SHCS1/4BSFX1.', 'X', '73181500', 8.95, 2400.00, 200.00, 3.270, 63.50, 5.68, 10.74, 9.00, 0.29, 9.00, 0.29, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2469, '326082104-0500', 'SHCS1/4BSFX1-1/4.', 'X', '73181500', 10.05, 2400.00, 200.00, 3.670, 63.50, 6.38, 12.06, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2470, '326084006-0500', 'SHCS1/4UNCX3/8.', 'X', '73181500', 7.85, 400.00, 200.00, 2.870, 63.50, 4.98, 9.42, 9.00, 0.26, 9.00, 0.26, 18.00, 0.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2471, '326084008-0500', 'SHCS1/4UNCX1/2.', 'X', '73181500', 7.85, 400.00, 200.00, 2.870, 63.50, 4.98, 9.42, 9.00, 0.26, 9.00, 0.26, 18.00, 0.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2472, '326084010-0500', 'SHCS1/4UNCX5/8.', 'X', '73181500', 7.50, 400.00, 200.00, 2.740, 63.50, 4.76, 9.00, 9.00, 0.25, 9.00, 0.25, 18.00, 0.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2473, '326084012-0500', 'SHCS1/4UNCX3/4.', 'X', '73181500', 7.85, 400.00, 200.00, 2.870, 63.50, 4.98, 9.42, 9.00, 0.26, 9.00, 0.26, 18.00, 0.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2474, '326084014-0500', 'SHCS1/4UNCX7/8', 'X', '73181500', 8.35, 400.00, 200.00, 3.050, 63.50, 5.30, 10.02, 9.00, 0.27, 9.00, 0.27, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2475, '326084100-0500', 'SHCS1/4UNCX1.', 'X', '73181500', 8.70, 2400.00, 200.00, 3.180, 63.50, 5.52, 10.44, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2476, '326084104-0500', 'SHCS1/4UNCX1-1/4.', 'X', '73181500', 9.85, 2400.00, 200.00, 3.600, 63.50, 6.25, 11.82, 9.00, 0.32, 9.00, 0.32, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2477, '326085006-0500', 'SHCS1/4UNFX3/8', 'X', '73181500', 8.00, 400.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2478, '326085008-0500', 'SHCS1/4UNFX1/2.', 'X', '73181500', 8.00, 400.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2479, '326085010-0500', 'SHCS1/4UNFX5/8.', 'X', '73181500', 7.65, 400.00, 200.00, 2.790, 63.50, 4.86, 9.18, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2480, '326085012-0500', 'SHCS1/4UNFX3/4.', 'X', '73181500', 8.00, 400.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2481, '326085100-0500', 'SHCS1/4UNFX1.', 'X', '73181500', 8.95, 2400.00, 200.00, 3.270, 63.50, 5.68, 10.74, 9.00, 0.29, 9.00, 0.29, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2482, '326085104-0500', 'SHCS1/4UNFX1-1/4.', 'X', '73181500', 10.05, 2400.00, 200.00, 3.670, 63.50, 6.38, 12.06, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2483, '326101006-0500', 'SHCS5/16BSWX3/8', 'X', '73181500', 8.35, 1600.00, 200.00, 3.050, 63.50, 5.30, 10.02, 9.00, 0.27, 9.00, 0.27, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2484, '326101008-0500', 'SHCS5/16BSWX1/2.', 'X', '73181500', 8.25, 2400.00, 200.00, 3.010, 63.50, 5.24, 9.90, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2485, '326101010-0500', 'SHCS5/16BSWX5/8', 'X', '73181500', 7.30, 2400.00, 200.00, 2.660, 63.50, 4.64, 8.76, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2486, '326101012-0500', 'SHCS5/16BSWX3/4.', 'X', '73181500', 7.55, 2400.00, 200.00, 2.760, 63.50, 4.79, 9.06, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2487, '326101014-0500', 'SHCS5/16BSWX7/8.', 'X', '73181500', 7.90, 1600.00, 200.00, 2.880, 63.50, 5.02, 9.48, 9.00, 0.26, 9.00, 0.26, 18.00, 0.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2488, '326101100-0500', 'SHCS5/16BSWX1.', 'X', '73181500', 8.50, 800.00, 200.00, 3.100, 63.50, 5.40, 10.20, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2489, '326101104-0500', 'SHCS5/16BSWX1-1/4.', 'X', '73181500', 9.20, 800.00, 200.00, 3.360, 63.50, 5.84, 11.04, 9.00, 0.30, 9.00, 0.30, 18.00, 0.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2490, '326101108-0500', 'SHCS5/16BSWX1-1/2.', 'X', '73181500', 10.20, 800.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2491, '326102006-0500', 'SHCS5/16BSFX3/8.', 'X', '73181500', 10.25, 1600.00, 200.00, 3.740, 63.50, 6.51, 12.30, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2492, '326102008-0500', 'SHCS5/16BSFX1/2', 'X', '73181500', 10.20, 400.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2493, '326102010-0500', 'SHCS5/16BSFX5/8.', 'X', '73181500', 8.95, 1600.00, 200.00, 3.270, 63.50, 5.68, 10.74, 9.00, 0.29, 9.00, 0.29, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2494, '326102012-0500', 'SHCS5/16BSFX3/4.', 'X', '73181500', 9.30, 2400.00, 200.00, 3.390, 63.50, 5.91, 11.16, 9.00, 0.31, 9.00, 0.31, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2495, '326102014-0500', 'SHCS5/16BSFX7/8.', 'X', '73181500', 9.65, 1600.00, 200.00, 3.520, 63.50, 6.13, 11.58, 9.00, 0.32, 9.00, 0.32, 18.00, 0.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2496, '326102100-0500', 'SHCS5/16BSFX1.', 'X', '73181500', 10.40, 800.00, 200.00, 3.800, 63.50, 6.60, 12.48, 9.00, 0.34, 9.00, 0.34, 18.00, 0.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2497, '326102104-0500', 'SHCS5/16BSFX1-1/4.', 'X', '73181500', 11.30, 800.00, 200.00, 4.120, 63.50, 7.18, 13.56, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2498, '326102108-0500', 'SHCS5/16BSFX1-1/2.', 'X', '73181500', 12.55, 800.00, 200.00, 4.580, 63.50, 7.97, 15.06, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2499, '326104008-0500', 'SHCS5/16UNCX1/2.', 'X', '73181500', 10.00, 800.00, 200.00, 3.650, 63.50, 6.35, 12.00, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2500, '326104010-0500', 'SHCS5/16UNCX5/8.', 'X', '73181500', 8.70, 800.00, 200.00, 3.180, 63.50, 5.52, 10.44, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2501, '326104012-0500', 'SHCS5/16UNCX3/4.', 'X', '73181500', 9.10, 2400.00, 200.00, 3.320, 63.50, 5.78, 10.92, 9.00, 0.30, 9.00, 0.30, 18.00, 0.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2502, '326104014-0500', 'SHCS5/16UNCX7/8.', 'X', '73181500', 9.55, 800.00, 200.00, 3.490, 63.50, 6.06, 11.46, 9.00, 0.31, 9.00, 0.31, 18.00, 0.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2503, '326104100-0500', 'SHCS5/16UNCX1.', 'X', '73181500', 10.20, 1200.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2504, '326104104-0500', 'SHCS5/16UNCX1-1/4.', 'X', '73181500', 11.20, 400.00, 200.00, 4.090, 63.50, 7.11, 13.44, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2505, '326104108-0500', 'SHCS5/16UNCX1-1/2.', 'X', '73181500', 12.40, 800.00, 200.00, 4.530, 63.50, 7.87, 14.88, 9.00, 0.41, 9.00, 0.41, 18.00, 0.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2506, '326105008-0500', 'SHCS5/16UNFX1/2.', 'X', '73181500', 10.20, 800.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2507, '326105012-0500', 'SHCS5/16UNFX3/4.', 'X', '73181500', 9.30, 2400.00, 200.00, 3.390, 63.50, 5.91, 11.16, 9.00, 0.31, 9.00, 0.31, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2508, '326105014-0500', 'SHCS5/16UNFX7/8.', 'X', '73181500', 9.65, 800.00, 200.00, 3.520, 63.50, 6.13, 11.58, 9.00, 0.32, 9.00, 0.32, 18.00, 0.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2509, '326105100-0500', 'SHCS5/16UNFX1.', 'X', '73181500', 10.40, 800.00, 200.00, 3.800, 63.50, 6.60, 12.48, 9.00, 0.34, 9.00, 0.34, 18.00, 0.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2510, '326105104-0500', 'SHCS5/16UNFX1-1/4.', 'X', '73181500', 11.30, 800.00, 200.00, 4.120, 63.50, 7.18, 13.56, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2511, '326105108-0500', 'SHCS5/16UNFX1-1/2.', 'X', '73181500', 12.55, 800.00, 200.00, 4.580, 63.50, 7.97, 15.06, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2512, '326121008-0500', 'SHCS3/8BSWX1/2.', 'X', '73181500', 13.40, 600.00, 200.00, 4.890, 63.50, 8.51, 16.08, 9.00, 0.44, 9.00, 0.44, 18.00, 0.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2513, '326121010-0500', 'SHCS3/8BSWX5/8.', 'X', '73181500', 13.40, 1200.00, 200.00, 4.890, 63.50, 8.51, 16.08, 9.00, 0.44, 9.00, 0.44, 18.00, 0.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2514, '326121012-0500', 'SHCS3/8BSWX3/4.', 'X', '73181500', 10.85, 1200.00, 200.00, 3.960, 63.50, 6.89, 13.02, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2515, '326121014-0500', 'SHCS3/8BSWX7/8', 'X', '73181500', 12.10, 1200.00, 200.00, 4.420, 63.50, 7.68, 14.52, 9.00, 0.40, 9.00, 0.40, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2516, '326121100-0500', 'SHCS3/8BSWX1.', 'X', '73181500', 12.10, 800.00, 200.00, 4.420, 63.50, 7.68, 14.52, 9.00, 0.40, 9.00, 0.40, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2517, '326121104-0500', 'SHCS3/8BSWX1-1/4.', 'X', '73181500', 13.30, 800.00, 200.00, 4.850, 63.50, 8.45, 15.96, 9.00, 0.44, 9.00, 0.44, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2518, '326121106-0500', 'SHCS3/8BSWX1-3/8', 'X', '73181500', 14.75, 600.00, 100.00, 5.380, 63.50, 9.37, 17.70, 9.00, 0.48, 9.00, 0.48, 18.00, 0.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2519, '326121108-0500', 'SHCS3/8BSWX1-1/2.', 'X', '73181500', 14.75, 600.00, 100.00, 5.380, 63.50, 9.37, 17.70, 9.00, 0.48, 9.00, 0.48, 18.00, 0.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2520, '326121200-0500', 'SHCS3/8BSWX2', 'X', '73181500', 17.55, 400.00, 100.00, 6.410, 63.50, 11.14, 21.06, 9.00, 0.58, 9.00, 0.58, 18.00, 1.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2521, '326121208-0500', 'SHCS3/8BSWX2-1/2.', 'X', '73181500', 21.05, 400.00, 100.00, 7.680, 63.50, 13.37, 25.26, 9.00, 0.69, 9.00, 0.69, 18.00, 1.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2522, '326122008-0500', 'SHCS3/8BSFX1/2.', 'X', '73181500', 16.45, 1200.00, 200.00, 6.000, 63.50, 10.45, 19.74, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2523, '326122010-0500', 'SHCS3/8BSFX5/8', 'X', '73181500', 16.45, 1200.00, 200.00, 6.000, 63.50, 10.45, 19.74, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2524, '326122012-0500', 'SHCS3/8BSFX3/4.', 'X', '73181500', 13.35, 1200.00, 200.00, 4.870, 63.50, 8.48, 16.02, 9.00, 0.44, 9.00, 0.44, 18.00, 0.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2525, '326122014-0500', 'SHCS3/8BSFX7/8', 'X', '73181500', 14.95, 1200.00, 200.00, 5.460, 63.50, 9.49, 17.94, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2526, '326122100-0500', 'SHCS3/8BSFX1.', 'X', '73181500', 14.95, 800.00, 200.00, 5.460, 63.50, 9.49, 17.94, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2527, '326122104-0500', 'SHCS3/8BSFX1-1/4.', 'X', '73181500', 16.30, 800.00, 200.00, 5.950, 63.50, 10.35, 19.56, 9.00, 0.54, 9.00, 0.54, 18.00, 1.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2528, '326122108-0500', 'SHCS3/8BSFX1-1/2.', 'X', '73181500', 18.15, 600.00, 100.00, 6.620, 63.50, 11.53, 21.78, 9.00, 0.60, 9.00, 0.60, 18.00, 1.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2529, '326124012-0500', 'SHCS3/8UNCX3/4.', 'X', '73181500', 13.10, 800.00, 200.00, 4.780, 63.50, 8.32, 15.72, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2530, '326124014-0500', 'SHCS3/8UNCX7/8.', 'X', '73181500', 14.65, 1200.00, 200.00, 5.350, 63.50, 9.30, 17.58, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(2531, '326124100-0500', 'SHCS3/8UNCX1.', 'X', '73181500', 14.65, 800.00, 200.00, 5.350, 63.50, 9.30, 17.58, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2532, '326124104-0500', 'SHCS3/8UNCX1-1/4.', 'X', '73181500', 15.95, 800.00, 200.00, 5.820, 63.50, 10.13, 19.14, 9.00, 0.52, 9.00, 0.52, 18.00, 1.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2533, '326124108-0500', 'SHCS3/8UNCX1-1/2.', 'X', '73181500', 17.85, 600.00, 100.00, 6.520, 63.50, 11.33, 21.42, 9.00, 0.59, 9.00, 0.59, 18.00, 1.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2534, '326125010-0500', 'SHCS3/8UNFX5/8.', 'X', '73181500', 16.45, 800.00, 200.00, 6.000, 63.50, 10.45, 19.74, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2535, '326125012-0500', 'SHCS3/8UNFX3/4.', 'X', '73181500', 13.35, 1200.00, 200.00, 4.870, 63.50, 8.48, 16.02, 9.00, 0.44, 9.00, 0.44, 18.00, 0.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2536, '326125014-0500', 'SHCS3/8UNFX7/8.', 'X', '73181500', 14.95, 800.00, 200.00, 5.460, 63.50, 9.49, 17.94, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2537, '326125100-0500', 'SHCS3/8UNFX1.', 'X', '73181500', 14.95, 800.00, 200.00, 5.460, 63.50, 9.49, 17.94, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2538, '326125104-0500', 'SHCS3/8UNFX1-1/4.', 'X', '73181500', 16.30, 800.00, 200.00, 5.950, 63.50, 10.35, 19.56, 9.00, 0.54, 9.00, 0.54, 18.00, 1.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2539, '326125108-0500', 'SHCS3/8UNFX1-1/2.', 'X', '73181500', 18.15, 600.00, 100.00, 6.620, 63.50, 11.53, 21.78, 9.00, 0.60, 9.00, 0.60, 18.00, 1.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2540, '326141012-0500', 'SHCS7/16BSWX3/4.', 'X', '73181500', 32.45, 800.00, 200.00, 11.840, 63.50, 20.61, 38.94, 9.00, 1.07, 9.00, 1.07, 18.00, 2.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2541, '326141100-0500', 'SHCS7/16BSWX1.', 'X', '73181500', 28.35, 800.00, 200.00, 10.350, 63.50, 18.00, 34.02, 9.00, 0.93, 9.00, 0.93, 18.00, 1.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2542, '326141104-0500', 'SHCS7/16BSWX1-1/4.', 'X', '73181500', 28.35, 300.00, 100.00, 10.350, 63.50, 18.00, 34.02, 9.00, 0.93, 9.00, 0.93, 18.00, 1.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2543, '326141108-0500', 'SHCS7/16BSWX1-1/2.', 'X', '73181500', 28.85, 300.00, 100.00, 10.530, 63.50, 18.32, 34.62, 9.00, 0.95, 9.00, 0.95, 18.00, 1.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2544, '326141112-0500', 'SHCS7/16BSWX1-3/4', 'X', '73181500', 30.90, 200.00, 100.00, 11.280, 63.50, 19.62, 37.08, 9.00, 1.02, 9.00, 1.02, 18.00, 2.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2545, '326142100-0500', 'SHCS7/16BSFX1.', 'X', '73181500', 34.85, 600.00, 200.00, 12.720, 63.50, 22.13, 41.82, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2546, '326142104-0500', 'SHCS7/16BSFX1-1/4.', 'X', '73181500', 34.85, 300.00, 100.00, 12.720, 63.50, 22.13, 41.82, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2547, '326142108-0500', 'SHCS7/16BSFX1-1/2.', 'X', '73181500', 35.55, 300.00, 100.00, 12.980, 63.50, 22.57, 42.66, 9.00, 1.17, 9.00, 1.17, 18.00, 2.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2548, '326142112-0500', 'SHCS7/16BSFX1-3/4.', 'X', '73181500', 37.90, 300.00, 100.00, 13.830, 63.50, 24.07, 45.48, 9.00, 1.25, 9.00, 1.25, 18.00, 2.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2549, '326144012-0500', 'SHCS7/16UNCX3/4', 'X', '73181500', 39.20, 1200.00, 200.00, 14.310, 63.50, 24.89, 47.04, 9.00, 1.29, 9.00, 1.29, 18.00, 2.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2550, '326144100-0500', 'SHCS7/16UNCX1', 'X', '73181500', 34.20, 600.00, 200.00, 12.480, 63.50, 21.72, 41.04, 9.00, 1.12, 9.00, 1.12, 18.00, 2.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2551, '326144104-0500', 'SHCS7/16UNCX1-1/4.', 'X', '73181500', 34.20, 300.00, 100.00, 12.480, 63.50, 21.72, 41.04, 9.00, 1.12, 9.00, 1.12, 18.00, 2.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2552, '326144108-0500', 'SHCS7/16UNCX1-1/2.', 'X', '73181500', 34.90, 300.00, 100.00, 12.740, 63.50, 22.16, 41.88, 9.00, 1.15, 9.00, 1.15, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2553, '326144112-0500', 'SHCS7/16UNCX1-3/4.', 'X', '73181500', 37.25, 600.00, 100.00, 13.600, 63.50, 23.65, 44.70, 9.00, 1.22, 9.00, 1.22, 18.00, 2.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2554, '326145100-0500', 'SHCS7/16UNFX1.', 'X', '73181500', 34.85, 800.00, 200.00, 12.720, 63.50, 22.13, 41.82, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2555, '326145104-0500', 'SHCS7/16UNFX1-1/4.', 'X', '73181500', 34.85, 300.00, 100.00, 12.720, 63.50, 22.13, 41.82, 9.00, 1.14, 9.00, 1.14, 18.00, 2.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2556, '326145108-0500', 'SHCS7/16UNFX1-1/2.', 'X', '73181500', 35.55, 400.00, 100.00, 12.980, 63.50, 22.57, 42.66, 9.00, 1.17, 9.00, 1.17, 18.00, 2.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2557, '326161008-0500', 'SHCS1/2BSWX1/2', 'X', '73181500', 30.20, 600.00, 100.00, 11.020, 63.50, 19.18, 36.24, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2558, '326161012-0500', 'SHCS1/2BSWX3/4.', 'X', '73181500', 30.20, 600.00, 100.00, 11.020, 63.50, 19.18, 36.24, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2559, '326161014-0500', 'SHCS1/2BSWX7/8', 'X', '73181500', 30.20, 400.00, 100.00, 11.020, 63.50, 19.18, 36.24, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2560, '326161100-0500', 'SHCS1/2BSWX1.', 'X', '73181500', 26.30, 400.00, 100.00, 9.600, 63.50, 16.70, 31.56, 9.00, 0.86, 9.00, 0.86, 18.00, 1.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2561, '326161104-0500', 'SHCS1/2BSWX1-1/4.', 'X', '73181500', 26.30, 400.00, 100.00, 9.600, 63.50, 16.70, 31.56, 9.00, 0.86, 9.00, 0.86, 18.00, 1.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2562, '326161108-0500', 'SHCS1/2BSWX1-1/2.', 'X', '73181500', 26.90, 400.00, 100.00, 9.820, 63.50, 17.08, 32.28, 9.00, 0.88, 9.00, 0.88, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2563, '326161112-0500', 'SHCS1/2BSWX1-3/4.', 'X', '73181500', 28.60, 400.00, 100.00, 10.440, 63.50, 18.16, 34.32, 9.00, 0.94, 9.00, 0.94, 18.00, 1.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2564, '326161200-0500', 'SHCS1/2BSWX2.', 'X', '73181500', 28.60, 300.00, 50.00, 10.440, 63.50, 18.16, 34.32, 9.00, 0.94, 9.00, 0.94, 18.00, 1.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2565, '326161208-0500', 'SHCS1/2BSWX2-1/2', 'X', '73181500', 32.95, 200.00, 50.00, 12.030, 63.50, 20.92, 39.54, 9.00, 1.08, 9.00, 1.08, 18.00, 2.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2566, '326162012-0500', 'SHCS1/2BSFX3/4.', 'X', '73181500', 37.15, 600.00, 100.00, 13.560, 63.50, 23.59, 44.58, 9.00, 1.22, 9.00, 1.22, 18.00, 2.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2567, '326162014-0500', 'SHCS1/2BSFX7/8.', 'X', '73181500', 37.15, 600.00, 100.00, 13.560, 63.50, 23.59, 44.58, 9.00, 1.22, 9.00, 1.22, 18.00, 2.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2568, '326162100-0500', 'SHCS1/2BSFX1.', 'X', '73181500', 32.35, 400.00, 100.00, 11.810, 63.50, 20.54, 38.82, 9.00, 1.06, 9.00, 1.06, 18.00, 2.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2569, '326162104-0500', 'SHCS1/2BSFX1-1/4.', 'X', '73181500', 32.35, 400.00, 100.00, 11.810, 63.50, 20.54, 38.82, 9.00, 1.06, 9.00, 1.06, 18.00, 2.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2570, '326162108-0500', 'SHCS1/2BSFX1-1/2.', 'X', '73181500', 33.00, 400.00, 100.00, 12.050, 63.50, 20.96, 39.60, 9.00, 1.08, 9.00, 1.08, 18.00, 2.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2571, '326162112-0500', 'SHCS1/2BSFX1-3/4.', 'X', '73181500', 35.35, 300.00, 100.00, 12.900, 63.50, 22.45, 42.42, 9.00, 1.16, 9.00, 1.16, 18.00, 2.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2572, '326162200-0500', 'SHCS1/2BSFX2.', 'X', '73181500', 35.35, 300.00, 50.00, 12.900, 63.50, 22.45, 42.42, 9.00, 1.16, 9.00, 1.16, 18.00, 2.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2573, '326164012-0500', 'SHCS1/2UNCX3/4.', 'X', '73181500', 36.45, 600.00, 100.00, 13.300, 63.50, 23.15, 43.74, 9.00, 1.20, 9.00, 1.20, 18.00, 2.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2574, '326164014-0500', 'SHCS1/2UNCX7/8', 'X', '73181500', 36.45, 600.00, 100.00, 13.300, 63.50, 23.15, 43.74, 9.00, 1.20, 9.00, 1.20, 18.00, 2.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2575, '326164100-0500', 'SHCS1/2UNCX1.', 'X', '73181500', 31.75, 400.00, 100.00, 11.590, 63.50, 20.16, 38.10, 9.00, 1.04, 9.00, 1.04, 18.00, 2.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2576, '326164104-0500', 'SHCS1/2UNCX1-1/4.', 'X', '73181500', 31.75, 400.00, 100.00, 11.590, 63.50, 20.16, 38.10, 9.00, 1.04, 9.00, 1.04, 18.00, 2.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2577, '326164108-0500', 'SHCS1/2UNCX1-1/2.', 'X', '73181500', 32.40, 400.00, 100.00, 11.830, 63.50, 20.57, 38.88, 9.00, 1.06, 9.00, 1.06, 18.00, 2.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2578, '326164112-0500', 'SHCS1/2UNCX1-3/4.', 'X', '73181500', 34.60, 400.00, 100.00, 12.630, 63.50, 21.97, 41.52, 9.00, 1.14, 9.00, 1.14, 18.00, 2.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2579, '326164200-0500', 'SHCS1/2UNCX2.', 'X', '73181500', 34.60, 300.00, 50.00, 12.630, 63.50, 21.97, 41.52, 9.00, 1.14, 9.00, 1.14, 18.00, 2.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2580, '326165012-0500', 'SHCS1/2UNFX3/4.', 'X', '73181500', 37.15, 600.00, 100.00, 13.560, 63.50, 23.59, 44.58, 9.00, 1.22, 9.00, 1.22, 18.00, 2.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2581, '326165100-0500', 'SHCS1/2UNFX1.', 'X', '73181500', 32.35, 400.00, 100.00, 11.810, 63.50, 20.54, 38.82, 9.00, 1.06, 9.00, 1.06, 18.00, 2.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2582, '326165104-0500', 'SHCS1/2UNFX1-1/4.', 'X', '73181500', 32.35, 400.00, 100.00, 11.810, 63.50, 20.54, 38.82, 9.00, 1.06, 9.00, 1.06, 18.00, 2.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2583, '326165108-0500', 'SHCS1/2UNFX1-1/2.', 'X', '73181500', 33.00, 400.00, 100.00, 12.050, 63.50, 20.96, 39.60, 9.00, 1.08, 9.00, 1.08, 18.00, 2.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2584, '326165112-0500', 'SHCS1/2UNFX1-3/4.', 'X', '73181500', 35.35, 400.00, 100.00, 12.900, 63.50, 22.45, 42.42, 9.00, 1.16, 9.00, 1.16, 18.00, 2.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2585, '326165200-0500', 'SHCS1/2UNFX2.', 'X', '73181500', 35.35, 300.00, 50.00, 12.900, 63.50, 22.45, 42.42, 9.00, 1.16, 9.00, 1.16, 18.00, 2.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2586, '326201012-0500', 'SHCS5/8BSWX3/4.', 'X', '73181500', 72.90, 300.00, 50.00, 26.610, 63.50, 46.29, 87.48, 9.00, 2.39, 9.00, 2.39, 18.00, 4.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2587, '326201014-0500', 'SHCS5/8BSWX7/8', 'X', '73181500', 62.15, 300.00, 50.00, 22.680, 63.50, 39.47, 74.58, 9.00, 2.04, 9.00, 2.04, 18.00, 4.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2588, '326201100-0500', 'SHCS5/8BSWX1.', 'X', '73181500', 62.15, 300.00, 50.00, 22.680, 63.50, 39.47, 74.58, 9.00, 2.04, 9.00, 2.04, 18.00, 4.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2589, '326201104-0500', 'SHCS5/8BSWX1-1/4.', 'X', '73181500', 54.05, 200.00, 50.00, 19.730, 63.50, 34.32, 64.86, 9.00, 1.78, 9.00, 1.78, 18.00, 3.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2590, '326201108-0500', 'SHCS5/8BSWX1-1/2.', 'X', '73181500', 55.95, 200.00, 50.00, 20.420, 63.50, 35.53, 67.14, 9.00, 1.84, 9.00, 1.84, 18.00, 3.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2591, '326201112-0500', 'SHCS5/8BSWX1-3/4.', 'X', '73181500', 59.60, 200.00, 50.00, 21.750, 63.50, 37.85, 71.52, 9.00, 1.96, 9.00, 1.96, 18.00, 3.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2592, '326201200-0500', 'SHCS5/8BSWX2.', 'X', '73181500', 59.60, 200.00, 50.00, 21.750, 63.50, 37.85, 71.52, 9.00, 1.96, 9.00, 1.96, 18.00, 3.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2593, '326201204-0500', 'SHCS5/8BSWX2-1/4.', 'X', '73181500', 64.65, 80.00, 10.00, 23.600, 63.50, 41.05, 77.58, 9.00, 2.12, 9.00, 2.12, 18.00, 4.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2594, '326201208-0500', 'SHCS5/8BSWX2-1/2', 'X', '73181500', 64.65, 20.00, 10.00, 23.600, 63.50, 41.05, 77.58, 9.00, 2.12, 9.00, 2.12, 18.00, 4.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2595, '326201300-0500', 'SHCS5/8BSWX3', 'X', '73181500', 71.10, 80.00, 10.00, 25.950, 63.50, 45.15, 85.32, 9.00, 2.34, 9.00, 2.34, 18.00, 4.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2596, '326202100-0500', 'SHCS5/8BSFX1', 'X', '73181500', 76.55, 200.00, 50.00, 27.940, 63.50, 48.61, 91.86, 9.00, 2.51, 9.00, 2.51, 18.00, 5.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2597, '326202104-0500', 'SHCS5/8BSFX1-1/4.', 'X', '73181500', 66.50, 200.00, 50.00, 24.270, 63.50, 42.23, 79.80, 9.00, 2.18, 9.00, 2.18, 18.00, 4.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2598, '326202108-0500', 'SHCS5/8BSFX1-1/2.', 'X', '73181500', 68.85, 200.00, 50.00, 25.130, 63.50, 43.72, 82.62, 9.00, 2.26, 9.00, 2.26, 18.00, 4.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2599, '326202112-0500', 'SHCS5/8BSFX1-3/4.', 'X', '73181500', 73.25, 200.00, 50.00, 26.740, 63.50, 46.51, 87.90, 9.00, 2.41, 9.00, 2.41, 18.00, 4.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2600, '326202200-0500', 'SHCS5/8BSFX2.', 'X', '73181500', 73.25, 200.00, 50.00, 26.740, 63.50, 46.51, 87.90, 9.00, 2.41, 9.00, 2.41, 18.00, 4.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2601, '326204104-0500', 'SHCS5/8UNCX1-1/4.', 'X', '73181500', 65.25, 200.00, 50.00, 23.820, 63.50, 41.43, 78.30, 9.00, 2.14, 9.00, 2.14, 18.00, 4.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2602, '326204108-0500', 'SHCS5/8UNCX1-1/2.', 'X', '73181500', 67.55, 200.00, 50.00, 24.660, 63.50, 42.89, 81.06, 9.00, 2.22, 9.00, 2.22, 18.00, 4.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2603, '326204112-0500', 'SHCS5/8UNCX1-3/4.', 'X', '73181500', 71.90, 200.00, 50.00, 26.240, 63.50, 45.66, 86.28, 9.00, 2.36, 9.00, 2.36, 18.00, 4.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2604, '326204200-0500', 'SHCS5/8UNCX2.', 'X', '73181500', 71.90, 200.00, 50.00, 26.240, 63.50, 45.66, 86.28, 9.00, 2.36, 9.00, 2.36, 18.00, 4.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2605, '326204204-0500', 'SHCS5/8UNCX2-1/4.', 'X', '73181500', 78.05, 80.00, 10.00, 28.490, 63.50, 49.56, 93.66, 9.00, 2.56, 9.00, 2.56, 18.00, 5.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2606, '326205100-0500', 'SHCS5/8UNFX1.', 'X', '73181500', 76.55, 300.00, 50.00, 27.940, 63.50, 48.61, 91.86, 9.00, 2.51, 9.00, 2.51, 18.00, 5.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2607, '326205108-0500', 'SHCS5/8UNFX1-1/2.', 'X', '73181500', 68.85, 300.00, 50.00, 25.130, 63.50, 43.72, 82.62, 9.00, 2.26, 9.00, 2.26, 18.00, 4.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2608, '326205112-0500', 'SHCS5/8UNFX1-3/4.', 'X', '73181500', 73.25, 200.00, 50.00, 26.740, 63.50, 46.51, 87.90, 9.00, 2.41, 9.00, 2.41, 18.00, 4.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2609, '326205200-0500', 'SHCS5/8UNFX2.', 'X', '73181500', 73.25, 200.00, 50.00, 26.740, 63.50, 46.51, 87.90, 9.00, 2.41, 9.00, 2.41, 18.00, 4.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2610, '326241100-0500', 'SHCS3/4BSWX1', 'X', '73181500', 162.60, 200.00, 50.00, 59.350, 63.50, 103.25, 195.12, 9.00, 5.34, 9.00, 5.34, 18.00, 10.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2611, '326241104-0500', 'SHCS3/4BSWX1-1/4.', 'X', '73181500', 162.60, 80.00, 10.00, 59.350, 63.50, 103.25, 195.12, 9.00, 5.34, 9.00, 5.34, 18.00, 10.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2612, '326241108-0500', 'SHCS3/4BSWX1-1/2', 'X', '73181500', 143.25, 20.00, 10.00, 52.290, 63.50, 90.96, 171.90, 9.00, 4.71, 9.00, 4.71, 18.00, 9.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2613, '326241112-0500', 'SHCS3/4BSWX1-3/4', 'X', '73181500', 146.60, 60.00, 10.00, 53.510, 63.50, 93.09, 175.92, 9.00, 4.82, 9.00, 4.82, 18.00, 9.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2614, '326241200-0500', 'SHCS3/4BSWX2', 'X', '73181500', 146.60, 120.00, 10.00, 53.510, 63.50, 93.09, 175.92, 9.00, 4.82, 9.00, 4.82, 18.00, 9.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2615, '326241204-0500', 'SHCS3/4BSWX2-1/4', 'X', '73181500', 149.80, 120.00, 10.00, 54.680, 63.50, 95.12, 179.76, 9.00, 4.92, 9.00, 4.92, 18.00, 9.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2616, '326241208-0500', 'SHCS3/4BSWX2-1/2', 'X', '73181500', 149.80, 120.00, 10.00, 54.680, 63.50, 95.12, 179.76, 9.00, 4.92, 9.00, 4.92, 18.00, 9.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2617, '326241212-0500', 'SHCS3/4BSWX2-3/4', 'X', '73181500', 170.40, 80.00, 10.00, 62.200, 63.50, 108.20, 204.48, 9.00, 5.60, 9.00, 5.60, 18.00, 11.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2618, '326241300-0500', 'SHCS3/4BSWX3', 'X', '73181500', 170.40, 40.00, 10.00, 62.200, 63.50, 108.20, 204.48, 9.00, 5.60, 9.00, 5.60, 18.00, 11.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2619, '326242104-0500', 'SHCS3/4BSFX1-1/4', 'X', '73181500', 190.95, 80.00, 10.00, 69.700, 63.50, 121.25, 229.14, 9.00, 6.27, 9.00, 6.27, 18.00, 12.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2620, '326242108-0500', 'SHCS3/4BSFX1-1/2', 'X', '73181500', 168.20, 120.00, 10.00, 61.390, 63.50, 106.81, 201.84, 9.00, 5.53, 9.00, 5.53, 18.00, 11.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2621, '326242200-0500', 'SHCS3/4BSFX2', 'X', '73181500', 172.15, 120.00, 10.00, 62.830, 63.50, 109.32, 206.58, 9.00, 5.66, 9.00, 5.66, 18.00, 11.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2622, '326242204-0500', 'SHCS3/4BSFX2-1/4', 'X', '73181500', 175.90, 120.00, 10.00, 64.200, 63.50, 111.70, 211.08, 9.00, 5.78, 9.00, 5.78, 18.00, 11.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2623, '326242208-0500', 'SHCS3/4BSFX2-1/2', 'X', '73181500', 175.90, 120.00, 10.00, 64.200, 63.50, 111.70, 211.08, 9.00, 5.78, 9.00, 5.78, 18.00, 11.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2624, '326242212-0500', 'SHCS3/4BSFX2-3/4', 'X', '73181500', 200.10, 80.00, 10.00, 73.040, 63.50, 127.06, 240.12, 9.00, 6.57, 9.00, 6.57, 18.00, 13.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2625, '326244100-0500', 'SHCS3/4UNCX1', 'X', '73181500', 187.40, 200.00, 50.00, 68.400, 63.50, 119.00, 224.88, 9.00, 6.16, 9.00, 6.16, 18.00, 12.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2626, '326244104-0500', 'SHCS3/4UNCX1-1/4', 'X', '73181500', 187.40, 120.00, 10.00, 68.400, 63.50, 119.00, 224.88, 9.00, 6.16, 9.00, 6.16, 18.00, 12.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2627, '326244108-0500', 'SHCS3/4UNCX1-1/2', 'X', '73181500', 165.10, 120.00, 10.00, 60.260, 63.50, 104.84, 198.12, 9.00, 5.42, 9.00, 5.42, 18.00, 10.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2628, '326244112-0500', 'SHCS3/4UNCX1-3/4', 'X', '73181500', 169.00, 60.00, 10.00, 61.690, 63.50, 107.32, 202.80, 9.00, 5.55, 9.00, 5.55, 18.00, 11.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2629, '326244200-0500', 'SHCS3/4UNCX2', 'X', '73181500', 169.00, 60.00, 10.00, 61.690, 63.50, 107.32, 202.80, 9.00, 5.55, 9.00, 5.55, 18.00, 11.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2630, '326244204-0500', 'SHCS3/4UNCX2-1/4', 'X', '73181500', 172.65, 60.00, 10.00, 63.020, 63.50, 109.63, 207.18, 9.00, 5.67, 9.00, 5.67, 18.00, 11.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2631, '326244208-0500', 'SHCS3/4UNCX2-1/2', 'X', '73181500', 172.65, 120.00, 10.00, 63.020, 63.50, 109.63, 207.18, 9.00, 5.67, 9.00, 5.67, 18.00, 11.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2632, '326244212-0500', 'SHCS3/4UNCX2-3/4', 'X', '73181500', 196.30, 40.00, 10.00, 71.650, 63.50, 124.65, 235.56, 9.00, 6.45, 9.00, 6.45, 18.00, 12.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2633, '326245104-0500', 'SHCS3/4UNFX1-1/4', 'X', '73181500', 190.95, 80.00, 10.00, 69.700, 63.50, 121.25, 229.14, 9.00, 6.27, 9.00, 6.27, 18.00, 12.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2634, '326245108-0500', 'SHCS3/4UNFX1-1/2', 'X', '73181500', 168.20, 80.00, 10.00, 61.390, 63.50, 106.81, 201.84, 9.00, 5.53, 9.00, 5.53, 18.00, 11.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2635, '326245112-0500', 'SHCS3/4UNFX1-3/4', 'X', '73181500', 172.15, 40.00, 10.00, 62.830, 63.50, 109.32, 206.58, 9.00, 5.66, 9.00, 5.66, 18.00, 11.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2636, '326245200-0500', 'SHCS3/4UNFX2', 'X', '73181500', 172.15, 40.00, 10.00, 62.830, 63.50, 109.32, 206.58, 9.00, 5.66, 9.00, 5.66, 18.00, 11.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2637, '326245204-0500', 'SHCS3/4UNFX2-1/4', 'X', '73181500', 175.90, 40.00, 10.00, 64.200, 63.50, 111.70, 211.08, 9.00, 5.78, 9.00, 5.78, 18.00, 11.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2638, '326245208-0500', 'SHCS3/4UNFX2-1/2', 'X', '73181500', 175.90, 60.00, 10.00, 64.200, 63.50, 111.70, 211.08, 9.00, 5.78, 9.00, 5.78, 18.00, 11.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2639, '326281108-0500', 'SHCS7/8BSWX1-1/2', 'X', '73181500', 215.35, 120.00, 10.00, 78.600, 63.50, 136.75, 258.42, 9.00, 7.07, 9.00, 7.07, 18.00, 14.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2640, '326281112-0500', 'SHCS7/8BSWX1-3/4', 'X', '73181500', 223.50, 30.00, 10.00, 81.580, 63.50, 141.92, 268.20, 9.00, 7.34, 9.00, 7.34, 18.00, 14.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2641, '326281200-0500', 'SHCS7/8BSWX2', 'X', '73181500', 223.50, 120.00, 10.00, 81.580, 63.50, 141.92, 268.20, 9.00, 7.34, 9.00, 7.34, 18.00, 14.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2642, '326281204-0500', 'SHCS7/8BSWX2-1/4', 'X', '73181500', 241.00, 80.00, 10.00, 87.970, 63.50, 153.04, 289.20, 9.00, 7.92, 9.00, 7.92, 18.00, 15.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2643, '326281208-0500', 'SHCS7/8BSWX2-1/2', 'X', '73181500', 241.00, 80.00, 10.00, 87.970, 63.50, 153.04, 289.20, 9.00, 7.92, 9.00, 7.92, 18.00, 15.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2644, '326281212-0500', 'SHCS7/8BSWX2-3/4', 'X', '73181500', 271.40, 60.00, 10.00, 99.060, 63.50, 172.34, 325.68, 9.00, 8.92, 9.00, 8.92, 18.00, 17.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2645, '326281300-0500', 'SHCS7/8BSWX3', 'X', '73181500', 271.40, 80.00, 10.00, 99.060, 63.50, 172.34, 325.68, 9.00, 8.92, 9.00, 8.92, 18.00, 17.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2646, '326284200-0500', 'SHCS7/8UNCX2', 'X', '73181500', 257.55, 60.00, 10.00, 94.010, 63.50, 163.54, 309.06, 9.00, 8.46, 9.00, 8.46, 18.00, 16.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2647, '326284208-0500', 'SHCS7/8UNCX2-1/2', 'X', '73181500', 277.70, 60.00, 10.00, 101.360, 63.50, 176.34, 333.24, 9.00, 9.12, 9.00, 9.12, 18.00, 18.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2648, '326284300-0500', 'SHCS7/8UNCX3', 'X', '73181500', 312.70, 40.00, 10.00, 114.140, 63.50, 198.56, 375.24, 9.00, 10.27, 9.00, 10.27, 18.00, 20.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2649, '326321108-0500', 'SHCS1BSWX1-1/2', 'X', '73181500', 205.55, 40.00, 10.00, 75.030, 63.50, 130.52, 246.66, 9.00, 6.75, 9.00, 6.75, 18.00, 13.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2650, '326321112-0500', 'SHCS1BSWX1-3/4', 'X', '73181500', 213.30, 30.00, 10.00, 77.850, 63.50, 135.45, 255.96, 9.00, 7.01, 9.00, 7.01, 18.00, 14.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2651, '326321200-0500', 'SHCS1BSWX2', 'X', '73181500', 213.30, 40.00, 10.00, 77.850, 63.50, 135.45, 255.96, 9.00, 7.01, 9.00, 7.01, 18.00, 14.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2652, '326321204-0500', 'SHCS1BSWX2-1/4', 'X', '73181500', 230.15, 60.00, 5.00, 84.000, 63.50, 146.15, 276.18, 9.00, 7.56, 9.00, 7.56, 18.00, 15.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2653, '326321208-0500', 'SHCS1BSWX2-1/2', 'X', '73181500', 230.15, 60.00, 5.00, 84.000, 63.50, 146.15, 276.18, 9.00, 7.56, 9.00, 7.56, 18.00, 15.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2654, '326321212-0500', 'SHCS1BSWX2-3/4', 'X', '73181500', 259.05, 60.00, 5.00, 94.550, 63.50, 164.50, 310.86, 9.00, 8.51, 9.00, 8.51, 18.00, 17.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2655, '326321300-0500', 'SHCS1BSWX3', 'X', '73181500', 259.05, 20.00, 5.00, 94.550, 63.50, 164.50, 310.86, 9.00, 8.51, 9.00, 8.51, 18.00, 17.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2656, '326321308-0500', 'SHCS1BSWX3-1/2', 'X', '73181500', 285.75, 20.00, 5.00, 104.300, 63.50, 181.45, 342.90, 9.00, 9.39, 9.00, 9.39, 18.00, 18.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2657, '326322208-0500', 'SHCS1BSFX2-1/2', 'X', '73181500', 270.20, 10.00, 5.00, 98.620, 63.50, 171.58, 324.24, 9.00, 8.88, 9.00, 8.88, 18.00, 17.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2658, '326322300-0500', 'SHCS1BSFX3', 'X', '73181500', 304.15, 20.00, 5.00, 111.010, 63.50, 193.14, 364.98, 9.00, 9.99, 9.00, 9.99, 18.00, 19.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2659, '326324200-0500', 'SHCS1UNCX2', 'X', '73181500', 245.85, 60.00, 10.00, 89.740, 63.50, 156.11, 295.02, 9.00, 8.08, 9.00, 8.08, 18.00, 16.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2660, '326324208-0500', 'SHCS1UNCX2-1/2', 'X', '73181500', 265.20, 30.00, 5.00, 96.800, 63.50, 168.40, 318.24, 9.00, 8.71, 9.00, 8.71, 18.00, 17.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2661, '326324212-0500', 'SHCS1UNCX2-3/4', 'X', '73181500', 298.55, 30.00, 5.00, 108.970, 63.50, 189.58, 358.26, 9.00, 9.81, 9.00, 9.81, 18.00, 19.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2662, '326324300-0500', 'SHCS1UNCX3', 'X', '73181500', 298.55, 30.00, 5.00, 108.970, 63.50, 189.58, 358.26, 9.00, 9.81, 9.00, 9.81, 18.00, 19.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2663, '357031003-0500', 'SSSM3X0.5X3 45H', 'X', '73181500', 3.65, 1200.00, 400.00, 1.330, 63.50, 2.32, 4.38, 9.00, 0.12, 9.00, 0.12, 18.00, 0.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2664, '357031004-0500', 'SSSM3X0.5X4 45H', 'X', '73181500', 3.40, 1200.00, 400.00, 1.240, 63.50, 2.16, 4.08, 9.00, 0.11, 9.00, 0.11, 18.00, 0.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2665, '357031005-0500', 'SSSM3X0.5X5 45H', 'X', '73181500', 3.45, 1200.00, 400.00, 1.260, 63.50, 2.19, 4.14, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2666, '357031006-0500', 'SSSM3X0.5X6 45H', 'X', '73181500', 3.50, 1200.00, 400.00, 1.280, 63.50, 2.22, 4.20, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2667, '357031008-0500', 'SSSM3X0.5X8 45H', 'X', '73181500', 3.55, 1200.00, 400.00, 1.300, 63.50, 2.25, 4.26, 9.00, 0.12, 9.00, 0.12, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2668, '357031010-0500', 'SSSM3X0.5X10 45H', 'X', '73181500', 3.75, 1200.00, 400.00, 1.370, 63.50, 2.38, 4.50, 9.00, 0.12, 9.00, 0.12, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2669, '357031012-0500', 'SSSM3X0.5X12 45H', 'X', '73181500', 3.95, 1200.00, 400.00, 1.440, 63.50, 2.51, 4.74, 9.00, 0.13, 9.00, 0.13, 18.00, 0.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2670, '357031016-0500', 'SSSM3X0.5X16 45H', 'X', '73181500', 4.10, 1200.00, 400.00, 1.500, 63.50, 2.60, 4.92, 9.00, 0.13, 9.00, 0.13, 18.00, 0.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2671, '357041004-0500', 'SSSM4X0.7X4 45H', 'X', '73181500', 3.40, 1200.00, 400.00, 1.240, 63.50, 2.16, 4.08, 9.00, 0.11, 9.00, 0.11, 18.00, 0.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2672, '357041005-0500', 'SSSM4X0.7X5 45H', 'X', '73181500', 3.45, 1200.00, 400.00, 1.260, 63.50, 2.19, 4.14, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2673, '357041006-0500', 'SSSM4X0.7X6 45H', 'X', '73181500', 3.50, 1200.00, 400.00, 1.280, 63.50, 2.22, 4.20, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2674, '357041008-0500', 'SSSM4X0.7X8 45H', 'X', '73181500', 3.55, 1200.00, 400.00, 1.300, 63.50, 2.25, 4.26, 9.00, 0.12, 9.00, 0.12, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2675, '357041010-0500', 'SSSM4X0.7X10 45H', 'X', '73181500', 3.00, 1200.00, 400.00, 1.100, 63.50, 1.91, 3.60, 9.00, 0.10, 9.00, 0.10, 18.00, 0.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2676, '357041012-0500', 'SSSM4X0.7X12 45H', 'X', '73181500', 3.95, 1200.00, 400.00, 1.440, 63.50, 2.51, 4.74, 9.00, 0.13, 9.00, 0.13, 18.00, 0.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2677, '357041016-0500', 'SSSM4X0.7X16 45H', 'X', '73181500', 4.10, 1200.00, 400.00, 1.500, 63.50, 2.60, 4.92, 9.00, 0.13, 9.00, 0.13, 18.00, 0.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2678, '357051005-0500', 'SSSM5X0.8X5 45H', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2679, '357051006-0500', 'SSSM5X0.8X6 45H', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2680, '357051008-0500', 'SSSM5X0.8X8 45H', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2681, '357051010-0500', 'SSSM5X0.8X10 45H', 'X', '73181500', 2.65, 1200.00, 400.00, 0.970, 63.50, 1.68, 3.18, 9.00, 0.09, 9.00, 0.09, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2682, '357051012-0500', 'SSSM5X0.8X12 45H', 'X', '73181500', 2.75, 1200.00, 400.00, 1.000, 63.50, 1.75, 3.30, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2683, '357051016-0500', 'SSSM5X0.8X16 45H', 'X', '73181500', 2.80, 800.00, 400.00, 1.020, 63.50, 1.78, 3.36, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2684, '357061005-0500', 'SSSM6X1X5 45H', 'X', '73181500', 3.95, 800.00, 400.00, 1.440, 63.50, 2.51, 4.74, 9.00, 0.13, 9.00, 0.13, 18.00, 0.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2685, '357061006-0500', 'SSSM6X1X6 45H', 'X', '73181500', 2.40, 800.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2686, '357061008-0500', 'SSSM6X1X8 45H', 'X', '73181500', 2.65, 800.00, 400.00, 0.970, 63.50, 1.68, 3.18, 9.00, 0.09, 9.00, 0.09, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2687, '357061010-0500', 'SSSM6X1X10 45H', 'X', '73181500', 2.15, 800.00, 400.00, 0.780, 63.50, 1.37, 2.58, 9.00, 0.07, 9.00, 0.07, 18.00, 0.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2688, '357061012-0500', 'SSSM6X1X12 45H', 'X', '73181500', 2.80, 800.00, 400.00, 1.020, 63.50, 1.78, 3.36, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2689, '357061015-0500', 'SSSM6X1X15 45H', 'X', '73181500', 3.00, 400.00, 200.00, 1.100, 63.50, 1.91, 3.60, 9.00, 0.10, 9.00, 0.10, 18.00, 0.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2690, '357061016-0500', 'SSSM6X1X16 45H', 'X', '73181500', 3.00, 600.00, 200.00, 1.100, 63.50, 1.91, 3.60, 9.00, 0.10, 9.00, 0.10, 18.00, 0.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2691, '357061020-0500', 'SSSM6X1X20 45H', 'X', '73181500', 3.20, 600.00, 200.00, 1.170, 63.50, 2.03, 3.84, 9.00, 0.11, 9.00, 0.11, 18.00, 0.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2692, '357061025-0500', 'SSSM6X1X25 45H', 'X', '73181500', 3.85, 600.00, 200.00, 1.410, 63.50, 2.44, 4.62, 9.00, 0.13, 9.00, 0.13, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2693, '357061030-0500', 'SSSM6X1X30 45H', 'X', '73181500', 5.30, 400.00, 200.00, 1.930, 63.50, 3.37, 6.36, 9.00, 0.17, 9.00, 0.17, 18.00, 0.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2694, '357082006-0500', 'SSSM8X1.25X6 45H', 'X', '73181500', 2.65, 600.00, 200.00, 0.970, 63.50, 1.68, 3.18, 9.00, 0.09, 9.00, 0.09, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2695, '357082008-0500', 'SSSM8X1.25X8 45H', 'X', '73181500', 2.65, 600.00, 200.00, 0.970, 63.50, 1.68, 3.18, 9.00, 0.09, 9.00, 0.09, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2696, '357082010-0500', 'SSSM8X1.25X10 45H', 'X', '73181500', 2.70, 600.00, 200.00, 0.990, 63.50, 1.71, 3.24, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2697, '357082012-0500', 'SSSM8X1.25X12 45H', 'X', '73181500', 2.80, 600.00, 200.00, 1.020, 63.50, 1.78, 3.36, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2698, '357082016-0500', 'SSSM8X1.25X16 45H', 'X', '73181500', 3.15, 600.00, 200.00, 1.150, 63.50, 2.00, 3.78, 9.00, 0.10, 9.00, 0.10, 18.00, 0.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2699, '357082020-0500', 'SSSM8X1.25X20 45H', 'X', '73181500', 3.40, 400.00, 200.00, 1.240, 63.50, 2.16, 4.08, 9.00, 0.11, 9.00, 0.11, 18.00, 0.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2700, '357082025-0500', 'SSSM8X1.25X25 45H', 'X', '73181500', 3.85, 400.00, 200.00, 1.410, 63.50, 2.44, 4.62, 9.00, 0.13, 9.00, 0.13, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2701, '357082030-0500', 'SSSM8X1.25X30 45H', 'X', '73181500', 5.55, 2400.00, 200.00, 2.030, 63.50, 3.52, 6.66, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2702, '357082035-0500', 'SSSM8X1.25X35 45H', 'X', '73181500', 6.45, 600.00, 200.00, 2.350, 63.50, 4.10, 7.74, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2703, '357103008-0500', 'SSSM10X1.5X8 45H', 'X', '73181500', 3.00, 400.00, 200.00, 1.100, 63.50, 1.91, 3.60, 9.00, 0.10, 9.00, 0.10, 18.00, 0.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2704, '357103010-0500', 'SSSM10X1.5X10 45H', 'X', '73181500', 3.00, 400.00, 200.00, 1.100, 63.50, 1.91, 3.60, 9.00, 0.10, 9.00, 0.10, 18.00, 0.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2705, '357103012-0500', 'SSSM10X1.5X12 45H', 'X', '73181500', 3.40, 400.00, 200.00, 1.240, 63.50, 2.16, 4.08, 9.00, 0.11, 9.00, 0.11, 18.00, 0.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2706, '357103016-0500', 'SSSM10X1.5X16 45H', 'X', '73181500', 3.80, 400.00, 200.00, 1.390, 63.50, 2.41, 4.56, 9.00, 0.12, 9.00, 0.12, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2707, '357103019-0500', 'SSSM10X1.5X19 45H', 'X', '73181500', 4.10, 1200.00, 200.00, 1.500, 63.50, 2.60, 4.92, 9.00, 0.13, 9.00, 0.13, 18.00, 0.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2708, '357103020-0500', 'SSSM10X1.5X20 45H', 'X', '73181500', 4.10, 1200.00, 200.00, 1.500, 63.50, 2.60, 4.92, 9.00, 0.13, 9.00, 0.13, 18.00, 0.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2709, '357103025-0500', 'SSSM10X1.5X25 45H', 'X', '73181500', 4.90, 1200.00, 200.00, 1.790, 63.50, 3.11, 5.88, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2710, '357103030-0500', 'SSSM10X1.5X30 45H', 'X', '73181500', 7.10, 800.00, 200.00, 2.590, 63.50, 4.51, 8.52, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2711, '357103035-0500', 'SSSM10X1.5X35 45H', 'X', '73181500', 8.20, 600.00, 200.00, 2.990, 63.50, 5.21, 9.84, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2712, '357124010-0500', 'SSSM12X1.75X10 45H', 'X', '73181500', 8.10, 400.00, 200.00, 2.960, 63.50, 5.14, 9.72, 9.00, 0.27, 9.00, 0.27, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2713, '357124012-0500', 'SSSM12X1.75X12 45H', 'X', '73181500', 5.80, 400.00, 200.00, 2.120, 63.50, 3.68, 6.96, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2714, '357124016-0500', 'SSSM12X1.75X16 45H', 'X', '73181500', 6.30, 1200.00, 200.00, 2.300, 63.50, 4.00, 7.56, 9.00, 0.21, 9.00, 0.21, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2715, '357124020-0500', 'SSSM12X1.75X20 45H', 'X', '73181500', 6.65, 1200.00, 200.00, 2.430, 63.50, 4.22, 7.98, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2716, '357124025-0500', 'SSSM12X1.75X25 45H', 'X', '73181500', 7.55, 800.00, 200.00, 2.760, 63.50, 4.79, 9.06, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2717, '357124030-0500', 'SSSM12X1.75X30 45H', 'X', '73181500', 8.75, 600.00, 200.00, 3.190, 63.50, 5.56, 10.50, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2718, '357124035-0500', 'SSSM12X1.75X35 45H', 'X', '73181500', 10.00, 400.00, 200.00, 3.650, 63.50, 6.35, 12.00, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2719, '367061003-0500', 'SSS3/16BSWX3/16 KCP', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2720, '367061004-0500', 'SSS3/16BSWX1/4 KCP', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2721, '367061005-0500', 'SSS3/16BSWX5/16 KCP', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2722, '367061006-0500', 'SSS3/16BSWX3/8 KCP', 'X', '73181500', 2.65, 1200.00, 400.00, 0.970, 63.50, 1.68, 3.18, 9.00, 0.09, 9.00, 0.09, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2723, '367061008-0500', 'SSS3/16BSWX1/2 KCP', 'X', '73181500', 2.75, 1200.00, 400.00, 1.000, 63.50, 1.75, 3.30, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2724, '367061010-0500', 'SSS3/16BSWX5/8 KCP', 'X', '73181500', 2.80, 1200.00, 400.00, 1.020, 63.50, 1.78, 3.36, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(2725, '367062003-0500', 'SSS3/16BSFX3/16 KCP', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2726, '367062004-0500', 'SSS3/16BSFX1/4 KCP', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2727, '367081004-0500', 'SSS1/4BSWX1/4 KCP', 'X', '73181500', 2.40, 1200.00, 400.00, 0.880, 63.50, 1.52, 2.88, 9.00, 0.08, 9.00, 0.08, 18.00, 0.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2728, '367081005-0500', 'SSS1/4BSWX5/16 KCP', 'X', '73181500', 2.65, 1200.00, 400.00, 0.970, 63.50, 1.68, 3.18, 9.00, 0.09, 9.00, 0.09, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2729, '367081006-0500', 'SSS1/4BSWX3/8 KCP', 'X', '73181500', 2.70, 600.00, 200.00, 0.990, 63.50, 1.71, 3.24, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2730, '367081008-0500', 'SSS1/4BSWX1/2 KCP', 'X', '73181500', 2.80, 600.00, 200.00, 1.020, 63.50, 1.78, 3.36, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2731, '367081010-0500', 'SSS1/4BSWX5/8 KCP', 'X', '73181500', 3.00, 600.00, 200.00, 1.100, 63.50, 1.91, 3.60, 9.00, 0.10, 9.00, 0.10, 18.00, 0.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2732, '367081012-0500', 'SSS1/4BSWX3/4 KCP', 'X', '73181500', 3.20, 400.00, 200.00, 1.170, 63.50, 2.03, 3.84, 9.00, 0.11, 9.00, 0.11, 18.00, 0.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2733, '367081100-0500', 'SSS1/4BSWX1 KCP', 'X', '73181500', 3.85, 2400.00, 200.00, 1.410, 63.50, 2.44, 4.62, 9.00, 0.13, 9.00, 0.13, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2734, '367081104-0500', 'SSS1/4BSWX1-1/4 KCP', 'X', '73181500', 5.30, 2400.00, 200.00, 1.930, 63.50, 3.37, 6.36, 9.00, 0.17, 9.00, 0.17, 18.00, 0.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2735, '367082004-0500', 'SSS1/4BSFX1/4 KCP', 'X', '73181500', 2.55, 1200.00, 400.00, 0.930, 63.50, 1.62, 3.06, 9.00, 0.08, 9.00, 0.08, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2736, '367082006-0500', 'SSS1/4BSFX3/8 KCP', 'X', '73181500', 2.70, 600.00, 200.00, 0.990, 63.50, 1.71, 3.24, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2737, '367082008-0500', 'SSS1/4BSFX1/2 KCP', 'X', '73181500', 2.80, 600.00, 200.00, 1.020, 63.50, 1.78, 3.36, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2738, '367082010-0500', 'SSS1/4BSFX5/8 KCP', 'X', '73181500', 3.00, 600.00, 200.00, 1.100, 63.50, 1.91, 3.60, 9.00, 0.10, 9.00, 0.10, 18.00, 0.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2739, '367101005-0500', 'SSS5/16BSWX5/16 KCP', 'X', '73181500', 2.65, 600.00, 200.00, 0.970, 63.50, 1.68, 3.18, 9.00, 0.09, 9.00, 0.09, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2740, '367101006-0500', 'SSS5/16BSWX3/8 KCP', 'X', '73181500', 2.70, 600.00, 200.00, 0.990, 63.50, 1.71, 3.24, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2741, '367101008-0500', 'SSS5/16BSWX1/2 KCP', 'X', '73181500', 2.80, 400.00, 200.00, 1.020, 63.50, 1.78, 3.36, 9.00, 0.09, 9.00, 0.09, 18.00, 0.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2742, '367101010-0500', 'SSS5/16BSWX5/8 KCP', 'X', '73181500', 3.15, 400.00, 200.00, 1.150, 63.50, 2.00, 3.78, 9.00, 0.10, 9.00, 0.10, 18.00, 0.21, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2743, '367101012-0500', 'SSS5/16BSWX3/4 KCP', 'X', '73181500', 3.40, 400.00, 200.00, 1.240, 63.50, 2.16, 4.08, 9.00, 0.11, 9.00, 0.11, 18.00, 0.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2744, '367101100-0500', 'SSS5/16BSWX1 KCP', 'X', '73181500', 4.10, 400.00, 200.00, 1.500, 63.50, 2.60, 4.92, 9.00, 0.13, 9.00, 0.13, 18.00, 0.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2745, '367101104-0500', 'SSS5/16BSWX1-1/4 KCP', 'X', '73181500', 5.55, 1200.00, 200.00, 2.030, 63.50, 3.52, 6.66, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2746, '367104005-0500', 'SSS5/16UNCX5/16 KCP', 'X', '73181500', 2.65, 600.00, 200.00, 0.970, 63.50, 1.68, 3.18, 9.00, 0.09, 9.00, 0.09, 18.00, 0.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2747, '367121006-0500', 'SSS3/8BSWX3/8 KCP', 'X', '73181500', 3.00, 600.00, 200.00, 1.100, 63.50, 1.91, 3.60, 9.00, 0.10, 9.00, 0.10, 18.00, 0.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2748, '367121008-0500', 'SSS3/8BSWX1/2 KCP', 'X', '73181500', 3.40, 400.00, 200.00, 1.240, 63.50, 2.16, 4.08, 9.00, 0.11, 9.00, 0.11, 18.00, 0.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2749, '367121010-0500', 'SSS3/8BSWX5/8 KCP', 'X', '73181500', 3.80, 400.00, 200.00, 1.390, 63.50, 2.41, 4.56, 9.00, 0.12, 9.00, 0.12, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2750, '367121012-0500', 'SSS3/8BSWX3/4 KCP', 'X', '73181500', 4.10, 1200.00, 200.00, 1.500, 63.50, 2.60, 4.92, 9.00, 0.13, 9.00, 0.13, 18.00, 0.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2751, '367121100-0500', 'SSS3/8BSWX1 KCP', 'X', '73181500', 4.90, 800.00, 200.00, 1.790, 63.50, 3.11, 5.88, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2752, '367121104-0500', 'SSS3/8BSWX1-1/4 KCP', 'X', '73181500', 7.10, 800.00, 200.00, 2.590, 63.50, 4.51, 8.52, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2753, '367161008-0500', 'SSS1/2BSWX1/2 KCP', 'X', '73181500', 5.80, 400.00, 200.00, 2.120, 63.50, 3.68, 6.96, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2754, '367161010-0500', 'SSS1/2BSWX5/8 KCP', 'X', '73181500', 6.30, 800.00, 200.00, 2.300, 63.50, 4.00, 7.56, 9.00, 0.21, 9.00, 0.21, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2755, '367161012-0500', 'SSS1/2BSWX3/4 KCP', 'X', '73181500', 6.65, 800.00, 200.00, 2.430, 63.50, 4.22, 7.98, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2756, '367161100-0500', 'SSS1/2BSWX1 KCP', 'X', '73181500', 7.55, 600.00, 200.00, 2.760, 63.50, 4.79, 9.06, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2757, '367161104-0500', 'SSS1/2BSWX1-1/4 KCP', 'X', '73181500', 9.70, 600.00, 100.00, 3.540, 63.50, 6.16, 11.64, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2758, '367201104-0500', 'SSS5/8BSWX1-1/4 KCP', 'X', '73181500', 19.00, 200.00, 50.00, 6.940, 63.50, 12.07, 22.80, 9.00, 0.62, 9.00, 0.62, 18.00, 1.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2759, '3B6031006-0500', 'BHM3X0.5X6. GR 12.9', 'X', '73181500', 9.40, 600.00, 200.00, 3.430, 63.50, 5.97, 11.28, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2760, '3B6031008-0500', 'BHM3X0.5X8. GR 12.9', 'X', '73181500', 11.15, 600.00, 200.00, 4.070, 63.50, 7.08, 13.38, 9.00, 0.37, 9.00, 0.37, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2761, '3B6031010-0500', 'BHM3X0.5X10 GR 12.9', 'X', '73181500', 12.00, 600.00, 200.00, 4.380, 63.50, 7.62, 14.40, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2762, '3B6031012-0500', 'BHM3X0.5X12 GR 12.9', 'X', '73181500', 12.85, 600.00, 200.00, 4.690, 63.50, 8.16, 15.42, 9.00, 0.42, 9.00, 0.42, 18.00, 0.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2763, '3B6031016-0500', 'BHM3X0.5X16 GR 12.9', 'X', '73181500', 14.50, 600.00, 200.00, 5.290, 63.50, 9.21, 17.40, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2764, '3B6031020-0500', 'BHM3X0.5X20 GR 12.9', 'X', '73181500', 16.10, 600.00, 200.00, 5.880, 63.50, 10.22, 19.32, 9.00, 0.53, 9.00, 0.53, 18.00, 1.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2765, '3B6031025-0500', 'BHM3X0.5X25 GR 12.9', 'X', '73181500', 17.65, 600.00, 200.00, 6.440, 63.50, 11.21, 21.18, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2766, '3B6041006-0500', 'BHM4X0.7X6. GR 12.9', 'X', '73181500', 6.05, 600.00, 200.00, 2.210, 63.50, 3.84, 7.26, 9.00, 0.20, 9.00, 0.20, 18.00, 0.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2767, '3B6041008-0500', 'BHM4X0.7X8. GR 12.9', 'X', '73181500', 6.05, 600.00, 200.00, 2.210, 63.50, 3.84, 7.26, 9.00, 0.20, 9.00, 0.20, 18.00, 0.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2768, '3B6041010-0500', 'BHM4X0.7X10 GR 12.9', 'X', '73181500', 6.05, 600.00, 200.00, 2.210, 63.50, 3.84, 7.26, 9.00, 0.20, 9.00, 0.20, 18.00, 0.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2769, '3B6041012-0500', 'BHM4X0.7X12 GR 12.9', 'X', '73181500', 6.45, 600.00, 200.00, 2.350, 63.50, 4.10, 7.74, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2770, '3B6041016-0500', 'BHM4X0.7X16 GR 12.9', 'X', '73181500', 6.95, 600.00, 200.00, 2.540, 63.50, 4.41, 8.34, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2771, '3B6041020-0500', 'BHM4X0.7X20 GR 12.9', 'X', '73181500', 7.45, 600.00, 200.00, 2.720, 63.50, 4.73, 8.94, 9.00, 0.24, 9.00, 0.24, 18.00, 0.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2772, '3B6041025-0500', 'BHM4X0.7X25 GR 12.9', 'X', '73181500', 8.70, 600.00, 200.00, 3.180, 63.50, 5.52, 10.44, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2773, '3B6041030-0500', 'BHM4X0.7X30 GR 12.9', 'X', '73181500', 10.50, 1600.00, 200.00, 3.830, 63.50, 6.67, 12.60, 9.00, 0.34, 9.00, 0.34, 18.00, 0.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2774, '3B6051006-0500', 'BHM5X0.8X6 GR 12.9', 'X', '73181500', 9.40, 600.00, 200.00, 3.430, 63.50, 5.97, 11.28, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2775, '3B6051008-0500', 'BHM5X0.8X08 GR 12.9', 'X', '73181500', 8.95, 600.00, 200.00, 3.270, 63.50, 5.68, 10.74, 9.00, 0.29, 9.00, 0.29, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2776, '3B6051010-0500', 'BHM5X0.8X10 GR 12.9', 'X', '73181500', 6.20, 600.00, 200.00, 2.260, 63.50, 3.94, 7.44, 9.00, 0.20, 9.00, 0.20, 18.00, 0.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2777, '3B6051012-0500', 'BHM5X0.8X12 GR 12.9', 'X', '73181500', 6.45, 600.00, 200.00, 2.350, 63.50, 4.10, 7.74, 9.00, 0.21, 9.00, 0.21, 18.00, 0.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2778, '3B6051016-0500', 'BHM5X0.8X16 GR 12.9', 'X', '73181500', 6.95, 1600.00, 200.00, 2.540, 63.50, 4.41, 8.34, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2779, '3B6051020-0500', 'BHM5X0.8X20 GR 12.9', 'X', '73181500', 7.45, 1600.00, 200.00, 2.720, 63.50, 4.73, 8.94, 9.00, 0.24, 9.00, 0.24, 18.00, 0.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2780, '3B6051025-0500', 'BHM5X0.8X25 GR 12.9', 'X', '73181500', 8.70, 1600.00, 200.00, 3.180, 63.50, 5.52, 10.44, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2781, '3B6051030-0500', 'BHM5X0.8X30 GR 12.9', 'X', '73181500', 10.50, 2400.00, 200.00, 3.830, 63.50, 6.67, 12.60, 9.00, 0.34, 9.00, 0.34, 18.00, 0.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2782, '3B6051035-0500', 'BHM5X0.8X35 GR 12.9', 'X', '73181500', 12.00, 2400.00, 200.00, 4.380, 63.50, 7.62, 14.40, 9.00, 0.39, 9.00, 0.39, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2783, '3B6051040-0500', 'BHM5X0.8X40 GR 12.9', 'X', '73181500', 13.45, 2400.00, 200.00, 4.910, 63.50, 8.54, 16.14, 9.00, 0.44, 9.00, 0.44, 18.00, 0.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2784, '3B6061008-0500', 'BHM6X1X8 GR 12.9', 'X', '73181500', 10.10, 600.00, 200.00, 3.690, 63.50, 6.41, 12.12, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2785, '3B6061010-0500', 'BHM6X1X10 GR 12.9', 'X', '73181500', 6.90, 600.00, 200.00, 2.520, 63.50, 4.38, 8.28, 9.00, 0.23, 9.00, 0.23, 18.00, 0.45, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2786, '3B6061012-0500', 'BHM6X1X12 GR 12.9', 'X', '73181500', 5.55, 400.00, 200.00, 2.030, 63.50, 3.52, 6.66, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2787, '3B6061016-0500', 'BHM6X1X16 GR 12.9', 'X', '73181500', 7.45, 1600.00, 200.00, 2.720, 63.50, 4.73, 8.94, 9.00, 0.24, 9.00, 0.24, 18.00, 0.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2788, '3B6061018-0500', 'BHM6X1X18 GR 12.9', 'X', '73181500', 8.00, 1600.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2789, '3B6061020-0500', 'BHM6X1X20 GR 12.9', 'X', '73181500', 8.00, 1600.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2790, '3B6061025-0500', 'BHM6X1X25 GR 12.9', 'X', '73181500', 9.35, 2400.00, 200.00, 3.410, 63.50, 5.94, 11.22, 9.00, 0.31, 9.00, 0.31, 18.00, 0.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2791, '3B6061030-0500', 'BHM6X1X30 GR 12.9', 'X', '73181500', 10.75, 1200.00, 200.00, 3.920, 63.50, 6.83, 12.90, 9.00, 0.35, 9.00, 0.35, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2792, '3B6061035-0500', 'BHM6X1X35 GR 12.9', 'X', '73181500', 12.25, 800.00, 200.00, 4.470, 63.50, 7.78, 14.70, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2793, '3B6061040-0500', 'BHM6X1X40 GR 12.9', 'X', '73181500', 14.00, 800.00, 200.00, 5.110, 63.50, 8.89, 16.80, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2794, '3B6061045-0500', 'BHM6X1X45 GR 12.9', 'X', '73181500', 17.10, 800.00, 200.00, 6.240, 63.50, 10.86, 20.52, 9.00, 0.56, 9.00, 0.56, 18.00, 1.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2795, '3B6082010-0500', 'BHM8X1.25X10 GR 12.9', 'X', '73181500', 11.15, 2400.00, 200.00, 4.070, 63.50, 7.08, 13.38, 9.00, 0.37, 9.00, 0.37, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2796, '3B6082012-0500', 'BHM8X1.25X12 GR 12.9', 'X', '73181500', 8.95, 2400.00, 200.00, 3.270, 63.50, 5.68, 10.74, 9.00, 0.29, 9.00, 0.29, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2797, '3B6082016-0500', 'BHM8X1.25X16 GR 12.9', 'X', '73181500', 7.60, 2400.00, 200.00, 2.770, 63.50, 4.83, 9.12, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2798, '3B6082020-0500', 'BHM8X1.25X20 GR 12.9', 'X', '73181500', 9.60, 2400.00, 200.00, 3.500, 63.50, 6.10, 11.52, 9.00, 0.32, 9.00, 0.32, 18.00, 0.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2799, '3B6082025-0500', 'BHM8X1.25X25 GR 12.9', 'X', '73181500', 11.00, 800.00, 200.00, 4.020, 63.50, 6.99, 13.20, 9.00, 0.36, 9.00, 0.36, 18.00, 0.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2800, '3B6082030-0500', 'BHM8X1.25X30 GR 12.9', 'X', '73181500', 12.55, 800.00, 200.00, 4.580, 63.50, 7.97, 15.06, 9.00, 0.41, 9.00, 0.41, 18.00, 0.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2801, '3B6082035-0500', 'BHM8X1.25X35 GR 12.9', 'X', '73181500', 14.25, 600.00, 200.00, 5.200, 63.50, 9.05, 17.10, 9.00, 0.47, 9.00, 0.47, 18.00, 0.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2802, '3B6082040-0500', 'BHM8X1.25X40 GR 12.9', 'X', '73181500', 16.25, 600.00, 200.00, 5.930, 63.50, 10.32, 19.50, 9.00, 0.53, 9.00, 0.53, 18.00, 1.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2803, '3B6082045-0500', 'BHM8X1.25X45 GR 12.9', 'X', '73181500', 18.75, 800.00, 200.00, 6.840, 63.50, 11.91, 22.50, 9.00, 0.62, 9.00, 0.62, 18.00, 1.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2804, '3B6082050-0500', 'BHM8X1.25X50 GR 12.9', 'X', '73181500', 20.65, 800.00, 200.00, 7.540, 63.50, 13.11, 24.78, 9.00, 0.68, 9.00, 0.68, 18.00, 1.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2805, '3B6103016-0500', 'BHM10X1.5X16 GR 12.9', 'X', '73181500', 14.50, 800.00, 200.00, 5.290, 63.50, 9.21, 17.40, 9.00, 0.48, 9.00, 0.48, 18.00, 0.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2806, '3B6103020-0500', 'BHM10X1.5X20 GR 12.9', 'X', '73181500', 11.90, 1200.00, 200.00, 4.340, 63.50, 7.56, 14.28, 9.00, 0.39, 9.00, 0.39, 18.00, 0.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2807, '3B6103025-0500', 'BHM10X1.5X25 GR 12.9', 'X', '73181500', 13.75, 800.00, 100.00, 5.020, 63.50, 8.73, 16.50, 9.00, 0.45, 9.00, 0.45, 18.00, 0.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2808, '3B6103030-0500', 'BHM10X1.5X30 GR 12.9', 'X', '73181500', 15.75, 800.00, 100.00, 5.750, 63.50, 10.00, 18.90, 9.00, 0.52, 9.00, 0.52, 18.00, 1.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2809, '3B6103035-0500', 'BHM10X1.5X35 GR 12.9', 'X', '73181500', 18.05, 800.00, 100.00, 6.590, 63.50, 11.46, 21.66, 9.00, 0.59, 9.00, 0.59, 18.00, 1.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2810, '3B6103040-0500', 'BHM10X1.5X40 GR 12.9', 'X', '73181500', 20.70, 600.00, 100.00, 7.560, 63.50, 13.14, 24.84, 9.00, 0.68, 9.00, 0.68, 18.00, 1.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2811, '3B6103045-0500', 'BHM10X1.5X45 GR 12.9', 'X', '73181500', 24.05, 300.00, 100.00, 8.780, 63.50, 15.27, 28.86, 9.00, 0.79, 9.00, 0.79, 18.00, 1.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2812, '3B6103050-0500', 'BHM10X1.5X50 GR 12.9', 'X', '73181500', 26.60, 400.00, 100.00, 9.710, 63.50, 16.89, 31.92, 9.00, 0.87, 9.00, 0.87, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2813, '3C6031006-0500', 'CSKM3X0.5X6 GR 12.9', 'X', '73181500', 10.60, 600.00, 200.00, 3.870, 63.50, 6.73, 12.72, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2814, '3C6031008-0500', 'CSKM3X0.5X8 GR 12.9', 'X', '73181500', 10.60, 600.00, 200.00, 3.870, 63.50, 6.73, 12.72, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2815, '3C6031010-0500', 'CSKM3X0.5X10 GR 12.9', 'X', '73181500', 11.35, 600.00, 200.00, 4.140, 63.50, 7.21, 13.62, 9.00, 0.37, 9.00, 0.37, 18.00, 0.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2816, '3C6031012-0500', 'CSKM3X0.5X12 GR 12.9', 'X', '73181500', 12.20, 600.00, 200.00, 4.450, 63.50, 7.75, 14.64, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2817, '3C6031016-0500', 'CSKM3X0.5X16 GR 12.9', 'X', '73181500', 13.80, 600.00, 200.00, 5.040, 63.50, 8.76, 16.56, 9.00, 0.45, 9.00, 0.45, 18.00, 0.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2818, '3C6031020-0500', 'CSKM3X0.5X20 GR 12.9', 'X', '73181500', 15.45, 600.00, 200.00, 5.640, 63.50, 9.81, 18.54, 9.00, 0.51, 9.00, 0.51, 18.00, 1.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2819, '3C6031025-0500', 'CSKM3X0.5X25 GR 12.9', 'X', '73181500', 17.05, 600.00, 200.00, 6.220, 63.50, 10.83, 20.46, 9.00, 0.56, 9.00, 0.56, 18.00, 1.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2820, '3C6041008-0500', 'CSKM4X0.7X8 GR 12.9', 'X', '73181500', 5.80, 600.00, 200.00, 2.120, 63.50, 3.68, 6.96, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2821, '3C6041010-0500', 'CSKM4X0.7X10 GR 12.9', 'X', '73181500', 5.80, 600.00, 200.00, 2.120, 63.50, 3.68, 6.96, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2822, '3C6041012-0500', 'CSKM4X0.7X12 GR 12.9', 'X', '73181500', 4.90, 600.00, 200.00, 1.790, 63.50, 3.11, 5.88, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2823, '3C6041016-0500', 'CSKM4X0.7X16 GR 12.9', 'X', '73181500', 6.60, 600.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2824, '3C6041020-0500', 'CSKM4X0.7X20 GR 12.9', 'X', '73181500', 7.10, 600.00, 200.00, 2.590, 63.50, 4.51, 8.52, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2825, '3C6041025-0500', 'CSKM4X0.7X25 GR 12.9', 'X', '73181500', 8.30, 600.00, 200.00, 3.030, 63.50, 5.27, 9.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2826, '3C6041030-0500', 'CSKM4X0.7X30 GR 12.9', 'X', '73181500', 10.00, 600.00, 200.00, 3.650, 63.50, 6.35, 12.00, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2827, '3C6041035-0500', 'CSKM4X0.7X35 GR 12.9', 'X', '73181500', 20.65, 1600.00, 200.00, 7.540, 63.50, 13.11, 24.78, 9.00, 0.68, 9.00, 0.68, 18.00, 1.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2828, '3C6041040-0500', 'CSKM4X0.7X40 GR 12.9', 'X', '73181500', 22.15, 1600.00, 200.00, 8.080, 63.50, 14.07, 26.58, 9.00, 0.73, 9.00, 0.73, 18.00, 1.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2829, '3C6041045-0500', 'CSKM4X0.7X45 GR 12.9', 'X', '73181500', 25.05, 2400.00, 200.00, 9.140, 63.50, 15.91, 30.06, 9.00, 0.82, 9.00, 0.82, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2830, '3C6041050-0500', 'CSKM4X0.7X50 GR 12.9', 'X', '73181500', 29.45, 2400.00, 200.00, 10.750, 63.50, 18.70, 35.34, 9.00, 0.97, 9.00, 0.97, 18.00, 1.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2831, '3C6051008-0500', 'CSKM5X0.8X8 GR 12.9', 'X', '73181500', 8.50, 600.00, 200.00, 3.100, 63.50, 5.40, 10.20, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2832, '3C6051010-0500', 'CSKM5X0.8X10 GR 12.9', 'X', '73181500', 4.75, 600.00, 200.00, 1.730, 63.50, 3.02, 5.70, 9.00, 0.16, 9.00, 0.16, 18.00, 0.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2833, '3C6051012-0500', 'CSKM5X0.8X12 GR 12.9', 'X', '73181500', 4.90, 600.00, 200.00, 1.790, 63.50, 3.11, 5.88, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2834, '3C6051016-0500', 'CSKM5X0.8X16 GR 12.9', 'X', '73181500', 6.60, 1600.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2835, '3C6051018-0500', 'CSKM5X0.8X18 GR 12.9', 'X', '73181500', 7.10, 1600.00, 200.00, 2.590, 63.50, 4.51, 8.52, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2836, '3C6051020-0500', 'CSKM5X0.8X20 GR 12.9', 'X', '73181500', 7.10, 1600.00, 200.00, 2.590, 63.50, 4.51, 8.52, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2837, '3C6051025-0500', 'CSKM5X0.8X25 GR 12.9', 'X', '73181500', 8.30, 1600.00, 200.00, 3.030, 63.50, 5.27, 9.96, 9.00, 0.27, 9.00, 0.27, 18.00, 0.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2838, '3C6051030-0500', 'CSKM5X0.8X30 GR 12.9', 'X', '73181500', 10.00, 1600.00, 200.00, 3.650, 63.50, 6.35, 12.00, 9.00, 0.33, 9.00, 0.33, 18.00, 0.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2839, '3C6051035-0500', 'CSKM5X0.8X35 GR 12.9', 'X', '73181500', 13.30, 2400.00, 200.00, 4.850, 63.50, 8.45, 15.96, 9.00, 0.44, 9.00, 0.44, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2840, '3C6051040-0500', 'CSKM5X0.8X40 GR 12.9', 'X', '73181500', 20.65, 2400.00, 200.00, 7.540, 63.50, 13.11, 24.78, 9.00, 0.68, 9.00, 0.68, 18.00, 1.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2841, '3C6051045-0500', 'CSKM5X0.8X45 GR 12.9', 'X', '73181500', 23.55, 800.00, 200.00, 8.600, 63.50, 14.95, 28.26, 9.00, 0.77, 9.00, 0.77, 18.00, 1.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2842, '3C6051050-0500', 'CSKM5X0.8X50 GR 12.9', 'X', '73181500', 29.45, 800.00, 200.00, 10.750, 63.50, 18.70, 35.34, 9.00, 0.97, 9.00, 0.97, 18.00, 1.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2843, '3C6061008-0500', 'CSKM6X1X8 GR 12.9', 'X', '73181500', 10.15, 600.00, 200.00, 3.700, 63.50, 6.45, 12.18, 9.00, 0.33, 9.00, 0.33, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2844, '3C6061010-0500', 'CSKM6X1X10 GR 12.9', 'X', '73181500', 6.50, 600.00, 200.00, 2.370, 63.50, 4.13, 7.80, 9.00, 0.21, 9.00, 0.21, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2845, '3C6061012-0500', 'CSKM6X1X12 GR 12.9', 'X', '73181500', 5.25, 600.00, 200.00, 1.920, 63.50, 3.33, 6.30, 9.00, 0.17, 9.00, 0.17, 18.00, 0.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2846, '3C6061016-0500', 'CSKM6X1X16 GR 12.9', 'X', '73181500', 5.70, 1600.00, 200.00, 2.080, 63.50, 3.62, 6.84, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2847, '3C6061020-0500', 'CSKM6X1X20 GR 12.9', 'X', '73181500', 6.15, 1600.00, 200.00, 2.240, 63.50, 3.91, 7.38, 9.00, 0.20, 9.00, 0.20, 18.00, 0.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2848, '3C6061025-0500', 'CSKM6X1X25 GR 12.9', 'X', '73181500', 7.15, 2400.00, 200.00, 2.610, 63.50, 4.54, 8.58, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2849, '3C6061030-0500', 'CSKM6X1X30 GR 12.9', 'X', '73181500', 8.70, 2400.00, 200.00, 3.180, 63.50, 5.52, 10.44, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2850, '3C6061035-0500', 'CSKM6X1X35 GR 12.9', 'X', '73181500', 11.65, 2400.00, 200.00, 4.250, 63.50, 7.40, 13.98, 9.00, 0.38, 9.00, 0.38, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2851, '3C6061040-0500', 'CSKM6X1X40 GR 12.9', 'X', '73181500', 13.30, 800.00, 200.00, 4.850, 63.50, 8.45, 15.96, 9.00, 0.44, 9.00, 0.44, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2852, '3C6061045-0500', 'CSKM6X1X45 GR 12.9', 'X', '73181500', 23.55, 800.00, 200.00, 8.600, 63.50, 14.95, 28.26, 9.00, 0.77, 9.00, 0.77, 18.00, 1.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2853, '3C6061050-0500', 'CSKM6X1X50 GR 12.9', 'X', '73181500', 29.45, 800.00, 200.00, 10.750, 63.50, 18.70, 35.34, 9.00, 0.97, 9.00, 0.97, 18.00, 1.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2854, '3C6082012-0500', 'CSKM8X1.25X12 GR 12.9', 'X', '73181500', 8.50, 2400.00, 200.00, 3.100, 63.50, 5.40, 10.20, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2855, '3C6082014-0500', 'CSKM8X1.25X14 GR 12.9', 'X', '73181500', 8.50, 2400.00, 200.00, 3.100, 63.50, 5.40, 10.20, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2856, '3C6082016-0500', 'CSKM8X1.25X16 GR 12.9', 'X', '73181500', 8.50, 2400.00, 200.00, 3.100, 63.50, 5.40, 10.20, 9.00, 0.28, 9.00, 0.28, 18.00, 0.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2857, '3C6082020-0500', 'CSKM8X1.25X20 GR 12.9', 'X', '73181500', 9.05, 2400.00, 200.00, 3.300, 63.50, 5.75, 10.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2858, '3C6082025-0500', 'CSKM8X1.25X25 GR 12.9', 'X', '73181500', 10.45, 800.00, 200.00, 3.810, 63.50, 6.64, 12.54, 9.00, 0.34, 9.00, 0.34, 18.00, 0.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2859, '3C6082030-0500', 'CSKM8X1.25X30 GR 12.9', 'X', '73181500', 11.90, 800.00, 200.00, 4.340, 63.50, 7.56, 14.28, 9.00, 0.39, 9.00, 0.39, 18.00, 0.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2860, '3C6082035-0500', 'CSKM8X1.25X35 GR 12.9', 'X', '73181500', 13.55, 1200.00, 200.00, 4.950, 63.50, 8.60, 16.26, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2861, '3C6082040-0500', 'CSKM8X1.25X40 GR 12.9', 'X', '73181500', 15.45, 1200.00, 200.00, 5.640, 63.50, 9.81, 18.54, 9.00, 0.51, 9.00, 0.51, 18.00, 1.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2862, '3C6082045-0500', 'CSKM8X1.25X45 GR 12.9', 'X', '73181500', 17.30, 800.00, 200.00, 6.310, 63.50, 10.99, 20.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2863, '3C6082050-0500', 'CSKM8X1.25X50 GR 12.9', 'X', '73181500', 27.05, 800.00, 200.00, 9.870, 63.50, 17.18, 32.46, 9.00, 0.89, 9.00, 0.89, 18.00, 1.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2864, '3C6082055-0500', 'CSKM8X1.25X55 GR 12.9', 'X', '73181500', 32.35, 800.00, 200.00, 11.810, 63.50, 20.54, 38.82, 9.00, 1.06, 9.00, 1.06, 18.00, 2.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2865, '3C6082060-0500', 'CSKM8X1.25X60 GR 12.9', 'X', '73181500', 36.25, 800.00, 200.00, 13.230, 63.50, 23.02, 43.50, 9.00, 1.19, 9.00, 1.19, 18.00, 2.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2866, '3C6103016-0500', 'CSKM10X1.5X16 GR 12.9', 'X', '73181500', 13.75, 1600.00, 200.00, 5.020, 63.50, 8.73, 16.50, 9.00, 0.45, 9.00, 0.45, 18.00, 0.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2867, '3C6103020-0500', 'CSKM10X1.5X20 GR 12.9', 'X', '73181500', 11.30, 1200.00, 200.00, 4.120, 63.50, 7.18, 13.56, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2868, '3C6103025-0500', 'CSKM10X1.5X25 GR 12.9', 'X', '73181500', 13.05, 400.00, 100.00, 4.760, 63.50, 8.29, 15.66, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2869, '3C6103030-0500', 'CSKM10X1.5X30 GR 12.9', 'X', '73181500', 14.95, 800.00, 100.00, 5.460, 63.50, 9.49, 17.94, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2870, '3C6103035-0500', 'CSKM10X1.5X35 GR 12.9', 'X', '73181500', 17.15, 600.00, 100.00, 6.260, 63.50, 10.89, 20.58, 9.00, 0.56, 9.00, 0.56, 18.00, 1.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2871, '3C6103040-0500', 'CSKM10X1.5X40 GR 12.9', 'X', '73181500', 19.60, 600.00, 100.00, 7.150, 63.50, 12.45, 23.52, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2872, '3C6103045-0500', 'CSKM10X1.5X45 GR 12.9', 'X', '73181500', 22.15, 600.00, 100.00, 8.080, 63.50, 14.07, 26.58, 9.00, 0.73, 9.00, 0.73, 18.00, 1.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2873, '3C6103050-0500', 'CSKM10X1.5X50 GR 12.9', 'X', '73181500', 24.90, 400.00, 100.00, 9.090, 63.50, 15.81, 29.88, 9.00, 0.82, 9.00, 0.82, 18.00, 1.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2874, '3C6103055-0500', 'CSKM10X1.5X55 GR 12.9', 'X', '73181500', 28.20, 400.00, 100.00, 10.290, 63.50, 17.91, 33.84, 9.00, 0.93, 9.00, 0.93, 18.00, 1.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2875, '3C6103060-0500', 'CSKM10X1.5X60 GR 12.9', 'X', '73181500', 31.25, 400.00, 100.00, 11.410, 63.50, 19.84, 37.50, 9.00, 1.03, 9.00, 1.03, 18.00, 2.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2876, '3C6124025-0500', 'CSKM12X1.75X25 GR 12.9', 'X', '73181500', 23.85, 600.00, 100.00, 8.710, 63.50, 15.14, 28.62, 9.00, 0.78, 9.00, 0.78, 18.00, 1.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2877, '3C6124030-0500', 'CSKM12X1.75X30 GR 12.9', 'X', '73181500', 27.20, 600.00, 100.00, 9.930, 63.50, 17.27, 32.64, 9.00, 0.89, 9.00, 0.89, 18.00, 1.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2878, '3C6124035-0500', 'CSKM12X1.75X35 GR 12.9', 'X', '73181500', 30.60, 600.00, 100.00, 11.170, 63.50, 19.43, 36.72, 9.00, 1.01, 9.00, 1.01, 18.00, 2.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2879, '3C6124040-0500', 'CSKM12X1.75X40 GR 12.9', 'X', '73181500', 34.00, 400.00, 100.00, 12.410, 63.50, 21.59, 40.80, 9.00, 1.12, 9.00, 1.12, 18.00, 2.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2880, '3C6124045-0500', 'CSKM12X1.75X45 GR 12.9', 'X', '73181500', 37.40, 400.00, 100.00, 13.650, 63.50, 23.75, 44.88, 9.00, 1.23, 9.00, 1.23, 18.00, 2.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2881, '3C6124050-0500', 'CSKM12X1.75X50 GR 12.9', 'X', '73181500', 40.75, 400.00, 100.00, 14.870, 63.50, 25.88, 48.90, 9.00, 1.34, 9.00, 1.34, 18.00, 2.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2882, '3C6124055-0500', 'CSKM12X1.75X55 GR 12.9', 'X', '73181500', 44.20, 400.00, 100.00, 16.130, 63.50, 28.07, 53.04, 9.00, 1.45, 9.00, 1.45, 18.00, 2.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2883, '3C6124060-0500', 'CSKM12X1.75X60 GR 12.9', 'X', '73181500', 47.60, 200.00, 50.00, 17.370, 63.50, 30.23, 57.12, 9.00, 1.56, 9.00, 1.56, 18.00, 3.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2884, '3C6124065-0500', 'CSKM12X1.75X65 GR 12.9', 'X', '73181500', 53.65, 200.00, 50.00, 19.580, 63.50, 34.07, 64.38, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2885, '3C6124070-0500', 'CSKM12X1.75X70 GR 12.9', 'X', '73181500', 57.70, 200.00, 50.00, 21.060, 63.50, 36.64, 69.24, 9.00, 1.90, 9.00, 1.90, 18.00, 3.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2886, '3C6124075-0500', 'CSKM12X1.75X75 GR 12.9', 'X', '73181500', 62.10, 200.00, 50.00, 22.670, 63.50, 39.43, 74.52, 9.00, 2.04, 9.00, 2.04, 18.00, 4.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2887, '3C6124080-0500', 'CSKM12X1.75X80 GR 12.9', 'X', '73181500', 66.85, 200.00, 50.00, 24.400, 63.50, 42.45, 80.22, 9.00, 2.20, 9.00, 2.20, 18.00, 4.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2888, '3C6124085-0500', 'CSKM12X1.75X85 GR 12.9', 'X', '73181500', 71.85, 200.00, 50.00, 26.230, 63.50, 45.62, 86.22, 9.00, 2.36, 9.00, 2.36, 18.00, 4.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2889, '3C6124090-0500', 'CSKM12X1.75X90 GR 12.9', 'X', '73181500', 77.40, 200.00, 50.00, 28.250, 63.50, 49.15, 92.88, 9.00, 2.54, 9.00, 2.54, 18.00, 5.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2890, '3C6124100-0500', 'CSKM12X1.75X100 GR 12.9', 'X', '73181500', 89.60, 200.00, 50.00, 32.700, 63.50, 56.90, 107.52, 9.00, 2.94, 9.00, 2.94, 18.00, 5.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2891, '3C6165030-0500', 'CSKM16X2X30 GR 12.9', 'X', '73181500', 44.20, 300.00, 50.00, 16.130, 63.50, 28.07, 53.04, 9.00, 1.45, 9.00, 1.45, 18.00, 2.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2892, '3C6165035-0500', 'CSKM16X2X35 GR 12.9', 'X', '73181500', 47.60, 300.00, 50.00, 17.370, 63.50, 30.23, 57.12, 9.00, 1.56, 9.00, 1.56, 18.00, 3.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2893, '3C6165040-0500', 'CSKM16X2X40 GR 12.9', 'X', '73181500', 50.95, 200.00, 50.00, 18.600, 63.50, 32.35, 61.14, 9.00, 1.67, 9.00, 1.67, 18.00, 3.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2894, '3C6165045-0500', 'CSKM16X2X45 GR 12.9', 'X', '73181500', 54.40, 200.00, 50.00, 19.860, 63.50, 34.54, 65.28, 9.00, 1.79, 9.00, 1.79, 18.00, 3.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2895, '3C6165050-0500', 'CSKM16X2X50 GR 12.9', 'X', '73181500', 57.80, 200.00, 50.00, 21.100, 63.50, 36.70, 69.36, 9.00, 1.90, 9.00, 1.90, 18.00, 3.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2896, '3C6165055-0500', 'CSKM16X2X55 GR 12.9', 'X', '73181500', 61.10, 200.00, 50.00, 22.300, 63.50, 38.80, 73.32, 9.00, 2.01, 9.00, 2.01, 18.00, 4.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2897, '3C6165060-0500', 'CSKM16X2X60 GR 12.9', 'X', '73181500', 64.55, 200.00, 50.00, 23.560, 63.50, 40.99, 77.46, 9.00, 2.12, 9.00, 2.12, 18.00, 4.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2898, '3C6165065-0500', 'CSKM16X2X65 GR 12.9', 'X', '73181500', 71.05, 60.00, 10.00, 25.930, 63.50, 45.12, 85.26, 9.00, 2.33, 9.00, 2.33, 18.00, 4.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2899, '3C6165070-0500', 'CSKM16X2X70 GR 12.9', 'X', '73181500', 74.65, 120.00, 10.00, 27.250, 63.50, 47.40, 89.58, 9.00, 2.45, 9.00, 2.45, 18.00, 4.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2900, '3C6165075-0500', 'CSKM16X2X75 GR 12.9', 'X', '73181500', 78.35, 120.00, 10.00, 28.600, 63.50, 49.75, 94.02, 9.00, 2.57, 9.00, 2.57, 18.00, 5.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2901, '3C6165080-0500', 'CSKM16X2X80 GR 12.9', 'X', '73181500', 82.30, 120.00, 10.00, 30.040, 63.50, 52.26, 98.76, 9.00, 2.70, 9.00, 2.70, 18.00, 5.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2902, '3C6165085-0500', 'CSKM16X2X85 GR 12.9', 'X', '73181500', 93.30, 80.00, 10.00, 34.050, 63.50, 59.25, 111.96, 9.00, 3.06, 9.00, 3.06, 18.00, 6.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2903, '3C6165090-0500', 'CSKM16X2X90 GR 12.9', 'X', '73181500', 93.30, 80.00, 10.00, 34.050, 63.50, 59.25, 111.96, 9.00, 3.06, 9.00, 3.06, 18.00, 6.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2904, '3C6165095-0500', 'CSKM16X2X95 GR 12.9', 'X', '73181500', 112.80, 80.00, 10.00, 41.170, 63.50, 71.63, 135.36, 9.00, 3.71, 9.00, 3.71, 18.00, 7.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2905, '3C6165100-0500', 'CSKM16X2X100 GR 12.9', 'X', '73181500', 112.80, 80.00, 10.00, 41.170, 63.50, 71.63, 135.36, 9.00, 3.71, 9.00, 3.71, 18.00, 7.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2906, '3C6207040-0500', 'CSKM20X2.5X40 GR 12.9', 'X', '73181500', 50.10, 120.00, 10.00, 18.290, 63.50, 31.81, 60.12, 9.00, 1.65, 9.00, 1.65, 18.00, 3.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2907, '3C6207045-0500', 'CSKM20X2.5X45 GR 12.9', 'X', '73181500', 58.80, 60.00, 10.00, 21.460, 63.50, 37.34, 70.56, 9.00, 1.93, 9.00, 1.93, 18.00, 3.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2908, '3C6207050-0500', 'CSKM20X2.5X50 GR 12.9', 'X', '73181500', 58.80, 60.00, 10.00, 21.460, 63.50, 37.34, 70.56, 9.00, 1.93, 9.00, 1.93, 18.00, 3.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2909, '3C6207055-0500', 'CSKM20X2.5X55 GR 12.9', 'X', '73181500', 54.45, 40.00, 10.00, 19.870, 63.50, 34.58, 65.34, 9.00, 1.79, 9.00, 1.79, 18.00, 3.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2910, '3C6207060-0500', 'CSKM20X2.5X60 GR 12.9', 'X', '73181500', 67.50, 40.00, 10.00, 24.640, 63.50, 42.86, 81.00, 9.00, 2.22, 9.00, 2.22, 18.00, 4.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2911, '3C6207065-0500', 'CSKM20X2.5X65 GR 12.9', 'X', '73181500', 71.85, 40.00, 10.00, 26.230, 63.50, 45.62, 86.22, 9.00, 2.36, 9.00, 2.36, 18.00, 4.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2912, '3C6207070-0500', 'CSKM20X2.5X70 GR 12.9', 'X', '73181500', 76.15, 40.00, 10.00, 27.790, 63.50, 48.36, 91.38, 9.00, 2.50, 9.00, 2.50, 18.00, 5.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2913, '3C6207075-0500', 'CSKM20X2.5X75 GR 12.9', 'X', '73181500', 84.90, 40.00, 10.00, 30.990, 63.50, 53.91, 101.88, 9.00, 2.79, 9.00, 2.79, 18.00, 5.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2914, '3C6207080-0500', 'CSKM20X2.5X80 GR 12.9', 'X', '73181500', 84.90, 40.00, 10.00, 30.990, 63.50, 53.91, 101.88, 9.00, 2.79, 9.00, 2.79, 18.00, 5.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2915, '3C6207090-0500', 'CSKM20X2.5X90 GR 12.9', 'X', '73181500', 93.60, 60.00, 10.00, 34.160, 63.50, 59.44, 112.32, 9.00, 3.07, 9.00, 3.07, 18.00, 6.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2916, '3C6207100-0500', 'CSKM20X2.5X100 GR 12.9', 'X', '73181500', 97.95, 60.00, 10.00, 35.750, 63.50, 62.20, 117.54, 9.00, 3.22, 9.00, 3.22, 18.00, 6.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(2917, '3C6207110-0500', 'CSKM20X2.5X110 GR 12.9', 'X', '73181500', 117.30, 30.00, 10.00, 42.810, 63.50, 74.49, 140.76, 9.00, 3.85, 9.00, 3.85, 18.00, 7.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2918, '3C6207120-0500', 'CSKM20X2.5X120 GR 12.9', 'X', '73181500', 137.70, 40.00, 10.00, 50.260, 63.50, 87.44, 165.24, 9.00, 4.52, 9.00, 4.52, 18.00, 9.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2919, '3D0081006-0500', 'CSK1/4BSWX3/8', 'X', '73181500', 6.50, 400.00, 200.00, 2.370, 63.50, 4.13, 7.80, 9.00, 0.21, 9.00, 0.21, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2920, '3D0081008-0500', 'CSK1/4BSWX1/2', 'X', '73181500', 6.50, 600.00, 200.00, 2.370, 63.50, 4.13, 7.80, 9.00, 0.21, 9.00, 0.21, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2921, '3D0081010-0500', 'CSK1/4BSWX5/8', 'X', '73181500', 7.10, 400.00, 200.00, 2.590, 63.50, 4.51, 8.52, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2922, '3D0081012-0500', 'CSK1/4BSWX3/4', 'X', '73181500', 7.65, 400.00, 200.00, 2.790, 63.50, 4.86, 9.18, 9.00, 0.25, 9.00, 0.25, 18.00, 0.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2923, '3D0081014-0500', 'CSK1/4BSWX7/8', 'X', '73181500', 8.25, 400.00, 200.00, 3.010, 63.50, 5.24, 9.90, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2924, '3D0081100-0500', 'CSK1/4BSWX1', 'X', '73181500', 8.90, 2400.00, 200.00, 3.250, 63.50, 5.65, 10.68, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2925, '3D0081104-0500', 'CSK1/4BSWX1-1/4', 'X', '73181500', 10.20, 2400.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2926, '3D0081108-0500', 'CSK1/4BSWX1-1/2', 'X', '73181500', 9.15, 2400.00, 200.00, 3.340, 63.50, 5.81, 10.98, 9.00, 0.30, 9.00, 0.30, 18.00, 0.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2927, '3D0084008-0500', 'CSK1/4UNCX1/2', 'X', '73181500', 10.80, 400.00, 200.00, 3.940, 63.50, 6.86, 12.96, 9.00, 0.35, 9.00, 0.35, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2928, '3D0084012-0500', 'CSK1/4UNCX3/4', 'X', '73181500', 12.65, 400.00, 200.00, 4.620, 63.50, 8.03, 15.18, 9.00, 0.42, 9.00, 0.42, 18.00, 0.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2929, '3D0084100-0500', 'CSK1/4UNCX1', 'X', '73181500', 14.55, 400.00, 200.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2930, '3D0084104-0500', 'CSK1/4UNCX1-1/4', 'X', '73181500', 16.70, 2400.00, 200.00, 6.100, 63.50, 10.60, 20.04, 9.00, 0.55, 9.00, 0.55, 18.00, 1.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2931, '3D0085008-0500', 'CSK1/4UNFX1/2', 'X', '73181500', 11.00, 400.00, 200.00, 4.020, 63.50, 6.99, 13.20, 9.00, 0.36, 9.00, 0.36, 18.00, 0.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2932, '3D0085012-0500', 'CSK1/4UNFX3/4', 'X', '73181500', 12.95, 400.00, 200.00, 4.730, 63.50, 8.22, 15.54, 9.00, 0.43, 9.00, 0.43, 18.00, 0.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2933, '3D0085100-0500', 'CSK1/4UNFX1', 'X', '73181500', 14.85, 2400.00, 200.00, 5.420, 63.50, 9.43, 17.82, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2934, '3D0101008-0500', 'CSK5/16BSWX1/2', 'X', '73181500', 9.50, 400.00, 200.00, 3.470, 63.50, 6.03, 11.40, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2935, '3D0101010-0500', 'CSK5/16BSWX5/8', 'X', '73181500', 9.50, 2400.00, 200.00, 3.470, 63.50, 6.03, 11.40, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2936, '3D0101012-0500', 'CSK5/16BSWX3/4', 'X', '73181500', 9.05, 2400.00, 200.00, 3.300, 63.50, 5.75, 10.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2937, '3D0101014-0500', 'CSK5/16BSWX7/8', 'X', '73181500', 9.80, 800.00, 200.00, 3.580, 63.50, 6.22, 11.76, 9.00, 0.32, 9.00, 0.32, 18.00, 0.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2938, '3D0101100-0500', 'CSK5/16BSWX1', 'X', '73181500', 10.45, 800.00, 200.00, 3.810, 63.50, 6.64, 12.54, 9.00, 0.34, 9.00, 0.34, 18.00, 0.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2939, '3D0101104-0500', 'CSK5/16BSWX1-1/4', 'X', '73181500', 11.90, 800.00, 200.00, 4.340, 63.50, 7.56, 14.28, 9.00, 0.39, 9.00, 0.39, 18.00, 0.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2940, '3D0101108-0500', 'CSK5/16BSWX1-1/2', 'X', '73181500', 15.95, 800.00, 200.00, 5.820, 63.50, 10.13, 19.14, 9.00, 0.52, 9.00, 0.52, 18.00, 1.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2941, '3D0104008-0500', 'CSK5/16UNCX1/2', 'X', '73181500', 14.05, 800.00, 200.00, 5.130, 63.50, 8.92, 16.86, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2942, '3D0104012-0500', 'CSK5/16UNCX3/4', 'X', '73181500', 15.05, 800.00, 200.00, 5.490, 63.50, 9.56, 18.06, 9.00, 0.49, 9.00, 0.49, 18.00, 0.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2943, '3D0104100-0500', 'CSK5/16UNCX1', 'X', '73181500', 16.65, 800.00, 200.00, 6.080, 63.50, 10.57, 19.98, 9.00, 0.55, 9.00, 0.55, 18.00, 1.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2944, '3D0104104-0500', 'CSK5/16UNCX1-1/4', 'X', '73181500', 19.60, 800.00, 200.00, 7.150, 63.50, 12.45, 23.52, 9.00, 0.64, 9.00, 0.64, 18.00, 1.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2945, '3D0104108-0500', 'CSK5/16UNCX1-1/2', 'X', '73181500', 21.50, 800.00, 200.00, 7.850, 63.50, 13.65, 25.80, 9.00, 0.71, 9.00, 0.71, 18.00, 1.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2946, '3D0105012-0500', 'CSK5/16UNFX3/4', 'X', '73181500', 15.40, 800.00, 200.00, 5.620, 63.50, 9.78, 18.48, 9.00, 0.51, 9.00, 0.51, 18.00, 1.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2947, '3D0105100-0500', 'CSK5/16UNFX1', 'X', '73181500', 16.95, 1600.00, 200.00, 6.190, 63.50, 10.76, 20.34, 9.00, 0.56, 9.00, 0.56, 18.00, 1.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2948, '3D0105108-0500', 'CSK5/16UNFX1-1/2', 'X', '73181500', 23.70, 400.00, 200.00, 8.650, 63.50, 15.05, 28.44, 9.00, 0.78, 9.00, 0.78, 18.00, 1.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2949, '3D0121010-0500', 'CSK3/8BSWX5/8', 'X', '73181500', 14.70, 1200.00, 200.00, 5.370, 63.50, 9.33, 17.64, 9.00, 0.48, 9.00, 0.48, 18.00, 0.97, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2950, '3D0121012-0500', 'CSK3/8BSWX3/4', 'X', '73181500', 13.30, 1200.00, 200.00, 4.850, 63.50, 8.45, 15.96, 9.00, 0.44, 9.00, 0.44, 18.00, 0.87, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2951, '3D0121014-0500', 'CSK3/8BSWX7/8', 'X', '73181500', 14.30, 1200.00, 200.00, 5.220, 63.50, 9.08, 17.16, 9.00, 0.47, 9.00, 0.47, 18.00, 0.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2952, '3D0121100-0500', 'CSK3/8BSWX1', 'X', '73181500', 15.40, 1200.00, 200.00, 5.620, 63.50, 9.78, 18.48, 9.00, 0.51, 9.00, 0.51, 18.00, 1.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2953, '3D0121104-0500', 'CSK3/8BSWX1-1/4', 'X', '73181500', 17.65, 1200.00, 200.00, 6.440, 63.50, 11.21, 21.18, 9.00, 0.58, 9.00, 0.58, 18.00, 1.16, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2954, '3D0121108-0500', 'CSK3/8BSWX1-1/2', 'X', '73181500', 23.85, 800.00, 200.00, 8.710, 63.50, 15.14, 28.62, 9.00, 0.78, 9.00, 0.78, 18.00, 1.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2955, '3D0121112-0500', 'CSK3/8BSWX1-3/4', 'X', '73181500', 26.70, 1200.00, 200.00, 9.750, 63.50, 16.95, 32.04, 9.00, 0.88, 9.00, 0.88, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2956, '3D0121200-0500', 'CSK3/8BSWX2', 'X', '73181500', 26.70, 600.00, 100.00, 9.750, 63.50, 16.95, 32.04, 9.00, 0.88, 9.00, 0.88, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2957, '3D0124012-0500', 'CSK3/8UNCX3/4', 'X', '73181500', 20.05, 1200.00, 200.00, 7.320, 63.50, 12.73, 24.06, 9.00, 0.66, 9.00, 0.66, 18.00, 1.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2958, '3D0124100-0500', 'CSK3/8UNCX1', 'X', '73181500', 24.60, 800.00, 200.00, 8.980, 63.50, 15.62, 29.52, 9.00, 0.81, 9.00, 0.81, 18.00, 1.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2959, '3D0124104-0500', 'CSK3/8UNCX1-1/4', 'X', '73181500', 25.75, 800.00, 200.00, 9.400, 63.50, 16.35, 30.90, 9.00, 0.85, 9.00, 0.85, 18.00, 1.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2960, '3D0124108-0500', 'CSK3/8UNCX1-1/2', 'X', '73181500', 29.60, 1200.00, 200.00, 10.800, 63.50, 18.80, 35.52, 9.00, 0.97, 9.00, 0.97, 18.00, 1.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2961, '3D0124200-0500', 'CSK3/8UNCX2', 'X', '73181500', 36.05, 100.00, 100.00, 13.160, 63.50, 22.89, 43.26, 9.00, 1.18, 9.00, 1.18, 18.00, 2.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2962, '3D0125012-0500', 'CSK3/8UNFX3/4', 'X', '73181500', 20.50, 1200.00, 200.00, 7.480, 63.50, 13.02, 24.60, 9.00, 0.67, 9.00, 0.67, 18.00, 1.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2963, '3D0125100-0500', 'CSK3/8UNFX1', 'X', '73181500', 25.05, 1200.00, 200.00, 9.140, 63.50, 15.91, 30.06, 9.00, 0.82, 9.00, 0.82, 18.00, 1.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2964, '3D0125104-0500', 'CSK3/8UNFX1-1/4', 'X', '73181500', 26.25, 1200.00, 200.00, 9.580, 63.50, 16.67, 31.50, 9.00, 0.86, 9.00, 0.86, 18.00, 1.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2965, '3D0125108-0500', 'CSK3/8UNFX1-1/2', 'X', '73181500', 30.15, 1200.00, 200.00, 11.000, 63.50, 19.15, 36.18, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2966, '3D0125200-0500', 'CSK3/8UNFX2', 'X', '73181500', 36.05, 600.00, 100.00, 13.160, 63.50, 22.89, 43.26, 9.00, 1.18, 9.00, 1.18, 18.00, 2.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2967, '3D0161012-0500', 'CSK1/2BSWX3/4', 'X', '73181500', 29.35, 800.00, 200.00, 10.710, 63.50, 18.64, 35.22, 9.00, 0.96, 9.00, 0.96, 18.00, 1.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2968, '3D0161100-0500', 'CSK1/2BSWX1', 'X', '73181500', 36.70, 800.00, 200.00, 13.400, 63.50, 23.30, 44.04, 9.00, 1.21, 9.00, 1.21, 18.00, 2.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2969, '3D0161104-0500', 'CSK1/2BSWX1-1/4', 'X', '73181500', 40.75, 600.00, 100.00, 14.870, 63.50, 25.88, 48.90, 9.00, 1.34, 9.00, 1.34, 18.00, 2.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2970, '3D0161108-0500', 'CSK1/2BSWX1-1/2', 'X', '73181500', 45.60, 600.00, 100.00, 16.640, 63.50, 28.96, 54.72, 9.00, 1.50, 9.00, 1.50, 18.00, 3.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2971, '3D0161200-0500', 'CSK1/2BSWX2', 'X', '73181500', 51.15, 400.00, 100.00, 18.670, 63.50, 32.48, 61.38, 9.00, 1.68, 9.00, 1.68, 18.00, 3.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2972, '3D0161208-0500', 'CSK1/2BSWX2-1/2', 'X', '73181500', 57.25, 200.00, 50.00, 20.900, 63.50, 36.35, 68.70, 9.00, 1.88, 9.00, 1.88, 18.00, 3.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2973, '3D0164012-0500', 'CSK1/2UNCX3/4', 'X', '73181500', 35.90, 1200.00, 200.00, 13.100, 63.50, 22.80, 43.08, 9.00, 1.18, 9.00, 1.18, 18.00, 2.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2974, '3D0164100-0500', 'CSK1/2UNCX1', 'X', '73181500', 44.85, 800.00, 200.00, 16.370, 63.50, 28.48, 53.82, 9.00, 1.47, 9.00, 1.47, 18.00, 2.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2975, '3D0164104-0500', 'CSK1/2UNCX1-1/4', 'X', '73181500', 50.20, 400.00, 100.00, 18.320, 63.50, 31.88, 60.24, 9.00, 1.65, 9.00, 1.65, 18.00, 3.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2976, '3D0164108-0500', 'CSK1/2UNCX1-1/2', 'X', '73181500', 55.55, 400.00, 100.00, 20.280, 63.50, 35.27, 66.66, 9.00, 1.82, 9.00, 1.82, 18.00, 3.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2977, '3D0164200-0500', 'CSK1/2UNCX2', 'X', '73181500', 61.10, 600.00, 100.00, 22.300, 63.50, 38.80, 73.32, 9.00, 2.01, 9.00, 2.01, 18.00, 4.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2978, '3D0164208-0500', 'CSK1/2UNCX2-1/2', 'X', '73181500', 67.25, 40.00, 10.00, 24.550, 63.50, 42.70, 80.70, 9.00, 2.21, 9.00, 2.21, 18.00, 4.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2979, '3D0165012-0500', 'CSK1/2UNFX3/4', 'X', '73181500', 36.55, 1200.00, 200.00, 13.340, 63.50, 23.21, 43.86, 9.00, 1.20, 9.00, 1.20, 18.00, 2.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2980, '3D0165014-0500', 'CSK1/2UNFX7/8', 'X', '73181500', 42.05, 1200.00, 200.00, 15.350, 63.50, 26.70, 50.46, 9.00, 1.38, 9.00, 1.38, 18.00, 2.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2981, '3D0165100-0500', 'CSK1/2UNFX1', 'X', '73181500', 45.65, 800.00, 200.00, 16.660, 63.50, 28.99, 54.78, 9.00, 1.50, 9.00, 1.50, 18.00, 3.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2982, '3D0165104-0500', 'CSK1/2UNFX1-1/4', 'X', '73181500', 51.20, 400.00, 100.00, 18.690, 63.50, 32.51, 61.44, 9.00, 1.68, 9.00, 1.68, 18.00, 3.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2983, '3D0165108-0500', 'CSK1/2UNFX1-1/2', 'X', '73181500', 56.65, 400.00, 100.00, 20.680, 63.50, 35.97, 67.98, 9.00, 1.86, 9.00, 1.86, 18.00, 3.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2984, '3D0165208-0500', 'CSK1/2UNFX2-1/2', 'X', '73181500', 68.50, 40.00, 10.00, 25.000, 63.50, 43.50, 82.20, 9.00, 2.25, 9.00, 2.25, 18.00, 4.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2985, '3D0201200-0500', 'CSK5/8BSWX2', 'X', '73181500', 65.00, 80.00, 10.00, 23.730, 63.50, 41.28, 78.00, 9.00, 2.14, 9.00, 2.14, 18.00, 4.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2986, '3D0201204-0500', 'CSK5/8BSWX2-1/4', 'X', '73181500', 62.85, 60.00, 10.00, 22.940, 63.50, 39.91, 75.42, 9.00, 2.06, 9.00, 2.06, 18.00, 4.13, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2987, '3D0201208-0500', 'CSK5/8BSWX2-1/2', 'X', '73181500', 75.00, 20.00, 10.00, 27.380, 63.50, 47.63, 90.00, 9.00, 2.46, 9.00, 2.46, 18.00, 4.93, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2988, '3D0201212-0500', 'CSK5/8BSWX2-3/4', 'X', '73181500', 72.95, 40.00, 10.00, 26.630, 63.50, 46.32, 87.54, 9.00, 2.40, 9.00, 2.40, 18.00, 4.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2989, '3D0201300-0500', 'CSK5/8BSWX3', 'X', '73181500', 87.50, 80.00, 10.00, 31.940, 63.50, 55.56, 105.00, 9.00, 2.87, 9.00, 2.87, 18.00, 5.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2990, '3D0205200-0500', 'CSK5/8UNFX2', 'X', '73181500', 87.75, 160.00, 20.00, 32.030, 63.50, 55.72, 105.30, 9.00, 2.88, 9.00, 2.88, 18.00, 5.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 160.00, 160.00, 160.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2991, '3G7061006-0500', 'SSSM6X1X6 DOG POINT', 'X', '73181500', 3.50, 1600.00, 200.00, 1.280, 63.50, 2.22, 4.20, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2992, '3G7061010-0500', 'SSSM6X1X10 DOG POINT', 'X', '73181500', 3.85, 1600.00, 200.00, 1.410, 63.50, 2.44, 4.62, 9.00, 0.13, 9.00, 0.13, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2993, '3G7061016-0500', 'SSSM6X1X16 DOG POINT', 'X', '73181500', 4.30, 1600.00, 200.00, 1.570, 63.50, 2.73, 5.16, 9.00, 0.14, 9.00, 0.14, 18.00, 0.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2994, '3G7082016-0500', 'SSSM8X1.25X16 DOG POINT', 'X', '73181500', 4.45, 1600.00, 200.00, 1.620, 63.50, 2.83, 5.34, 9.00, 0.15, 9.00, 0.15, 18.00, 0.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2995, '3G7082025-0500', 'SSSM8X1.25X25 DOG POINT', 'X', '73181500', 5.55, 800.00, 200.00, 2.030, 63.50, 3.52, 6.66, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2996, '3G7103030-0500', 'SSSM10X1.5X30 DOG POINT', 'X', '73181500', 10.20, 1600.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2997, '3L2061012-0500', 'SHCLSM6X1X12 GR 8.8', 'X', '73181500', 6.95, 3200.00, 200.00, 2.540, 63.50, 4.41, 8.34, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2998, '3L2061014-0500', 'SHCLSM6X1X14 GR 8.8', 'X', '73181500', 6.60, 3200.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(2999, '3L2061016-0500', 'SHCLSM6X1X16 GR 8.8', 'X', '73181500', 6.60, 3200.00, 200.00, 2.410, 63.50, 4.19, 7.92, 9.00, 0.22, 9.00, 0.22, 18.00, 0.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3000, '3L2061025-0500', 'SHCLSM6X1X25 GR 8.8', 'X', '73181500', 7.70, 2400.00, 200.00, 2.810, 63.50, 4.89, 9.24, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3001, '3L2082014-0500', 'SHCLSM8X1.25X14 GR 8.8', 'X', '73181500', 7.70, 400.00, 200.00, 2.810, 63.50, 4.89, 9.24, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3002, '3L2082016-0500', 'SHCLSM8X1.25X16 GR 8.8', 'X', '73181500', 7.70, 1600.00, 200.00, 2.810, 63.50, 4.89, 9.24, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3003, '3L2082018-0500', 'SHCLSM8X1.25X18 GR 8.8', 'X', '73181500', 8.00, 1600.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3004, '3L2082020-0500', 'SHCLSM8X1.25X20 GR 8.8', 'X', '73181500', 8.00, 1600.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3005, '3L2082025-0500', 'SHCLSM8X1.25X25 GR 8.8', 'X', '73181500', 8.95, 1600.00, 200.00, 3.270, 63.50, 5.68, 10.74, 9.00, 0.29, 9.00, 0.29, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3006, '3L2082030-0500', 'SHCLSM8X1.25X30 GR 8.8', 'X', '73181500', 9.85, 1200.00, 200.00, 3.600, 63.50, 6.25, 11.82, 9.00, 0.32, 9.00, 0.32, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3007, '3L2103030-0500', 'SHCLSM10X1.5X30 GR 8.8', 'X', '73181500', 13.45, 1600.00, 200.00, 4.910, 63.50, 8.54, 16.14, 9.00, 0.44, 9.00, 0.44, 18.00, 0.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3008, '3L2124030-0500', 'SHCLSM12X1.75X30 GR 8.8', 'X', '73181500', 26.10, 300.00, 50.00, 9.530, 63.50, 16.57, 31.32, 9.00, 0.86, 9.00, 0.86, 18.00, 1.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3009, '3L2165030-0500', 'SHCLSM16X2X30 GR 8.8', 'X', '73181500', 52.25, 200.00, 50.00, 19.070, 63.50, 33.18, 62.70, 9.00, 1.72, 9.00, 1.72, 18.00, 3.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3010, '3L5061010-0500', 'SHCLSM6X1X10 GR 10.9', 'X', '73181500', 6.95, 3200.00, 200.00, 2.540, 63.50, 4.41, 8.34, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3011, '3L5061020-0500', 'SHCLSM6X1X20 GR 10.9', 'X', '73181500', 6.95, 3200.00, 200.00, 2.540, 63.50, 4.41, 8.34, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3012, '3L5061025-0500', 'SHCLSM6X1X25 GR 10.9', 'X', '73181500', 7.70, 2400.00, 200.00, 2.810, 63.50, 4.89, 9.24, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3013, '3L5082016-0500', 'SHCLSM8X1.25X16 GR 10.9', 'X', '73181500', 7.70, 800.00, 200.00, 2.810, 63.50, 4.89, 9.24, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3014, '3L5082020-0500', 'SHCLSM8X1.25X20 GR 10.9', 'X', '73181500', 8.00, 1600.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3015, '3L5082025-0500', 'SHCLSM8X1.25X25 GR 10.9', 'X', '73181500', 8.95, 800.00, 200.00, 3.270, 63.50, 5.68, 10.74, 9.00, 0.29, 9.00, 0.29, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3016, '3L5082030-0500', 'SHCLSM8X1.25X30 GR 10.9', 'X', '73181500', 9.85, 800.00, 200.00, 3.600, 63.50, 6.25, 11.82, 9.00, 0.32, 9.00, 0.32, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3017, '3L5082040-0500', 'SHCLSM8X1.25X40 GR 10.9', 'X', '73181500', 11.55, 800.00, 200.00, 4.220, 63.50, 7.33, 13.86, 9.00, 0.38, 9.00, 0.38, 18.00, 0.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3018, '3L5103016-0500', 'SHCLSM10X1.5X16 GR 10.9', 'X', '73181500', 12.20, 1600.00, 200.00, 4.450, 63.50, 7.75, 14.64, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3019, '3L5103020-0500', 'SHCLSM10X1.5X20 GR 10.9', 'X', '73181500', 11.15, 1200.00, 200.00, 4.070, 63.50, 7.08, 13.38, 9.00, 0.37, 9.00, 0.37, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3020, '3L5103025-0500', 'SHCLSM10X1.5X25 GR 10.9', 'X', '73181500', 12.25, 800.00, 200.00, 4.470, 63.50, 7.78, 14.70, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3021, '3L5103035-0500', 'SHCLSM10X1.5X35 GR 10.9', 'X', '73181500', 14.55, 600.00, 100.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3022, '3L5103040-0500', 'SHCLSM10X1.5X40 GR 10.9', 'X', '73181500', 15.50, 600.00, 100.00, 5.660, 63.50, 9.84, 18.60, 9.00, 0.51, 9.00, 0.51, 18.00, 1.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3023, '3L5124025-0500', 'SHCLSM12X1.75X25 GR 10.9', 'X', '73181500', 26.10, 600.00, 100.00, 9.530, 63.50, 16.57, 31.32, 9.00, 0.86, 9.00, 0.86, 18.00, 1.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3024, '3L5124030-0500', 'SHCLSM12X1.75X30 GR 10.9', 'X', '73181500', 26.10, 400.00, 100.00, 9.530, 63.50, 16.57, 31.32, 9.00, 0.86, 9.00, 0.86, 18.00, 1.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3025, '3L5165035-0500', 'SHCLSM16X2X35 GR 10.9', 'X', '73181500', 55.65, 200.00, 50.00, 20.310, 63.50, 35.34, 66.78, 9.00, 1.83, 9.00, 1.83, 18.00, 3.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3026, '3L6041020-0500', 'SHCLSM4X0.7X20 GR 12.9', 'X', '73181500', 8.10, 1600.00, 200.00, 2.960, 63.50, 5.14, 9.72, 9.00, 0.27, 9.00, 0.27, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3027, '3L6051010-0500', 'SHCLSM5X0.8X10 GR 12.9', 'X', '73181500', 7.15, 600.00, 200.00, 2.610, 63.50, 4.54, 8.58, 9.00, 0.23, 9.00, 0.23, 18.00, 0.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3028, '3L6051016-0500', 'SHCLSM5X0.8X16 GR 12.9', 'X', '73181500', 6.65, 1600.00, 200.00, 2.430, 63.50, 4.22, 7.98, 9.00, 0.22, 9.00, 0.22, 18.00, 0.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3029, '3L6061010-0500', 'SHCLSM6X1X10 GR 12.9', 'X', '73181500', 6.95, 3200.00, 200.00, 2.540, 63.50, 4.41, 8.34, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3030, '3L6082012-0500', 'SHCLSM8X1.25X12 GR 12.9', 'X', '73181500', 8.80, 2400.00, 200.00, 3.210, 63.50, 5.59, 10.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3031, '3L6082016-0500', 'SHCLSM8X1.25X16 GR 12.9', 'X', '73181500', 7.70, 1600.00, 200.00, 2.810, 63.50, 4.89, 9.24, 9.00, 0.25, 9.00, 0.25, 18.00, 0.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3032, '3L6082020-0500', 'SHCLSM8X1.25X20 GR 12.9', 'X', '73181500', 8.00, 1600.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3033, '3L6082025-0500', 'SHCLSM8X1.25X25 GR 12.9', 'X', '73181500', 8.95, 1600.00, 200.00, 3.270, 63.50, 5.68, 10.74, 9.00, 0.29, 9.00, 0.29, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3034, '3L6103020-0500', 'SHCLSM10X1.5X20 GR 12.9', 'X', '73181500', 11.15, 800.00, 200.00, 4.070, 63.50, 7.08, 13.38, 9.00, 0.37, 9.00, 0.37, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3035, '3L6124035-0500', 'SHCLSM12X1.75X35 GR 12.9', 'X', '73181500', 26.70, 400.00, 100.00, 9.750, 63.50, 16.95, 32.04, 9.00, 0.88, 9.00, 0.88, 18.00, 1.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3036, '3L6124040-0500', 'SHCLSM12X1.75X40 GR 12.9', 'X', '73181500', 26.90, 400.00, 100.00, 9.820, 63.50, 17.08, 32.28, 9.00, 0.88, 9.00, 0.88, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3037, '3L6165030-0500', 'SHCLSM16X2X30 GR 12.9', 'X', '73181500', 52.25, 200.00, 50.00, 19.070, 63.50, 33.18, 62.70, 9.00, 1.72, 9.00, 1.72, 18.00, 3.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3038, '3L6165035-0500', 'SHCLSM16X2X35 GR 12.9', 'X', '73181500', 55.65, 200.00, 50.00, 20.310, 63.50, 35.34, 66.78, 9.00, 1.83, 9.00, 1.83, 18.00, 3.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3039, '3N7041006-0500', 'SSSM4X0.7X6 CONE POINT', 'X', '73181500', 4.95, 1600.00, 200.00, 1.810, 63.50, 3.14, 5.94, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3040, '3N7041008-0500', 'SSSM4X0.7X8 CONE POINT', 'X', '73181500', 5.05, 400.00, 200.00, 1.840, 63.50, 3.21, 6.06, 9.00, 0.17, 9.00, 0.17, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3041, '3N7051006-0500', 'SSSM5X0.8X6 CONE POINT', 'X', '73181500', 3.45, 600.00, 200.00, 1.260, 63.50, 2.19, 4.14, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3042, '3N7051008-0500', 'SSSM5X0.8X8 CONE POINT', 'X', '73181500', 3.50, 600.00, 200.00, 1.280, 63.50, 2.22, 4.20, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3043, '3N7061006-0500', 'SSSM6X1X6 CONE POINT', 'X', '73181500', 3.50, 1600.00, 200.00, 1.280, 63.50, 2.22, 4.20, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3044, '3N7061008-0500', 'SSSM6X1X8 CONE POINT', 'X', '73181500', 3.75, 400.00, 200.00, 1.370, 63.50, 2.38, 4.50, 9.00, 0.12, 9.00, 0.12, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3045, '3N7061010-0500', 'SSSM6X1X10 CONE POINT', 'X', '73181500', 3.85, 3200.00, 200.00, 1.410, 63.50, 2.44, 4.62, 9.00, 0.13, 9.00, 0.13, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3046, '3N7061012-0500', 'SSSM6X1X12 CONE POINT', 'X', '73181500', 3.95, 1600.00, 200.00, 1.440, 63.50, 2.51, 4.74, 9.00, 0.13, 9.00, 0.13, 18.00, 0.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3047, '3N7061016-0500', 'SSSM6X1X16 CONE POINT', 'X', '73181500', 4.30, 600.00, 200.00, 1.570, 63.50, 2.73, 5.16, 9.00, 0.14, 9.00, 0.14, 18.00, 0.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3048, '3N7082010-0500', 'SSSM8X1.25X10 CONE POINT', 'X', '73181500', 3.85, 400.00, 200.00, 1.410, 63.50, 2.44, 4.62, 9.00, 0.13, 9.00, 0.13, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3049, '3N7082012-0500', 'SSSM8X1.25X12 CONE POINT', 'X', '73181500', 4.00, 400.00, 200.00, 1.460, 63.50, 2.54, 4.80, 9.00, 0.13, 9.00, 0.13, 18.00, 0.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3050, '3N7082016-0500', 'SSSM8X1.25X16 CONE POINT', 'X', '73181500', 4.45, 600.00, 200.00, 1.620, 63.50, 2.83, 5.34, 9.00, 0.15, 9.00, 0.15, 18.00, 0.29, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3051, '3N7103016-0500', 'SSSM10X1.5X16 CONE POINT', 'X', '73181500', 5.45, 3200.00, 200.00, 1.990, 63.50, 3.46, 6.54, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3052, '3N7103020-0500', 'SSSM10X1.5X20 CONE POINT', 'X', '73181500', 5.85, 2400.00, 200.00, 2.140, 63.50, 3.71, 7.02, 9.00, 0.19, 9.00, 0.19, 18.00, 0.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3053, '3P7051004-0500', 'SSSM5X0.8X4 CUP POINT', 'X', '73181500', 3.45, 600.00, 200.00, 1.260, 63.50, 2.19, 4.14, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3054, '3P7051005-0500', 'SSSM5X0.8X5 CUP POINT', 'X', '73181500', 3.45, 600.00, 200.00, 1.260, 63.50, 2.19, 4.14, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3055, '3P7061005-0500', 'SSSM6X1X5 CUP POINT', 'X', '73181500', 5.70, 800.00, 200.00, 2.080, 63.50, 3.62, 6.84, 9.00, 0.19, 9.00, 0.19, 18.00, 0.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3056, '3P7082008-0500', 'SSSM8X1.25X8 CUP POINT', 'X', '73181500', 3.75, 600.00, 200.00, 1.370, 63.50, 2.38, 4.50, 9.00, 0.12, 9.00, 0.12, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3057, '3P7103008-0500', 'SSSM10X1.5X8 CUP POINT', 'X', '73181500', 4.25, 400.00, 200.00, 1.550, 63.50, 2.70, 5.10, 9.00, 0.14, 9.00, 0.14, 18.00, 0.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3058, '3P7103010-0500', 'SSSM10X1.5X10 CUP POINT', 'X', '73181500', 4.25, 3200.00, 200.00, 1.550, 63.50, 2.70, 5.10, 9.00, 0.14, 9.00, 0.14, 18.00, 0.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3059, '3T7041006-0500', 'SSSM4X0.7X6 FLAT POINT', 'X', '73181500', 4.95, 1600.00, 200.00, 1.810, 63.50, 3.14, 5.94, 9.00, 0.16, 9.00, 0.16, 18.00, 0.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3060, '3T7041010-0500', 'SSSM4X0.7X10 FLAT POINT', 'X', '73181500', 5.35, 600.00, 200.00, 1.950, 63.50, 3.40, 6.42, 9.00, 0.18, 9.00, 0.18, 18.00, 0.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3061, '3T7051006-0500', 'SSSM5X0.8X6 FLAT POINT', 'X', '73181500', 3.45, 600.00, 200.00, 1.260, 63.50, 2.19, 4.14, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3062, '3T7051008-0500', 'SSSM5X0.8X8 FLAT POINT', 'X', '73181500', 3.50, 600.00, 200.00, 1.280, 63.50, 2.22, 4.20, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3063, '3T7061006-0500', 'SSSM6X1X6 FLAT POINT', 'X', '73181500', 3.50, 1600.00, 200.00, 1.280, 63.50, 2.22, 4.20, 9.00, 0.11, 9.00, 0.11, 18.00, 0.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3064, '3T7061008-0500', 'SSSM6X1X8 FLAT POINT', 'X', '73181500', 3.75, 400.00, 200.00, 1.370, 63.50, 2.38, 4.50, 9.00, 0.12, 9.00, 0.12, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3065, '3T7061010-0500', 'SSSM6X1X10 FLAT POINT', 'X', '73181500', 3.85, 600.00, 200.00, 1.410, 63.50, 2.44, 4.62, 9.00, 0.13, 9.00, 0.13, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3066, '3T7061012-0500', 'SSSM6X1X12 FLAT POINT', 'X', '73181500', 3.95, 1600.00, 200.00, 1.440, 63.50, 2.51, 4.74, 9.00, 0.13, 9.00, 0.13, 18.00, 0.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3067, '3T7082008-0500', 'SSSM8X1.25X8 FLAT POINT', 'X', '73181500', 3.75, 600.00, 200.00, 1.370, 63.50, 2.38, 4.50, 9.00, 0.12, 9.00, 0.12, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3068, '3T7082010-0500', 'SSSM8X1.25X10 FLAT POINT', 'X', '73181500', 3.85, 400.00, 200.00, 1.410, 63.50, 2.44, 4.62, 9.00, 0.13, 9.00, 0.13, 18.00, 0.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3069, '3T7082020-0500', 'SSSM8X1.25X20 FLAT POINT', 'X', '73181500', 4.85, 2400.00, 200.00, 1.770, 63.50, 3.08, 5.82, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3070, '3T7082025-0500', 'SSSM8X1.25X25 FLAT POINT', 'X', '73181500', 5.55, 400.00, 200.00, 2.030, 63.50, 3.52, 6.66, 9.00, 0.18, 9.00, 0.18, 18.00, 0.36, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3071, '3T7082030-0500', 'SSSM8X1.25X30 FLAT POINT', 'X', '73181500', 7.90, 800.00, 200.00, 2.880, 63.50, 5.02, 9.48, 9.00, 0.26, 9.00, 0.26, 18.00, 0.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3072, '3T7103010-0500', 'SSSM10X1.5X10 FLAT POINT', 'X', '73181500', 4.25, 3200.00, 200.00, 1.550, 63.50, 2.70, 5.10, 9.00, 0.14, 9.00, 0.14, 18.00, 0.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 3200.00, 3200.00, 3200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3073, '3T7103012-0500', 'SSSM10X1.5X12 FLAT POINT', 'X', '73181500', 4.80, 800.00, 200.00, 1.750, 63.50, 3.05, 5.76, 9.00, 0.16, 9.00, 0.16, 18.00, 0.32, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3074, '3T7103025-0500', 'SSSM10X1.5X25 FLAT POINT', 'X', '73181500', 7.05, 800.00, 200.00, 2.570, 63.50, 4.48, 8.46, 9.00, 0.23, 9.00, 0.23, 18.00, 0.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3075, '3T7103030-0500', 'SSSM10X1.5X30 FLAT POINT', 'X', '73181500', 10.20, 600.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3076, '3T7103035-0500', 'SSSM10X1.5X35 FLAT POINT', 'X', '73181500', 11.75, 300.00, 100.00, 4.290, 63.50, 7.46, 14.10, 9.00, 0.39, 9.00, 0.39, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3077, '3T7124025-0500', 'SSSM12X1.75X25 FLAT POINT', 'X', '73181500', 10.85, 800.00, 200.00, 3.960, 63.50, 6.89, 13.02, 9.00, 0.36, 9.00, 0.36, 18.00, 0.71, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3078, '416031025-0500', 'SHCBM3X0.5X25 GR 12.9', 'X', '73181500', 7.35, 2400.00, 200.00, 2.680, 63.50, 4.67, 8.82, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3079, '416031030-0500', 'SHCBM3X0.5X30 GR 12.9', 'X', '73181500', 8.65, 1600.00, 200.00, 3.160, 63.50, 5.49, 10.38, 9.00, 0.28, 9.00, 0.28, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3080, '416041030-0500', 'SHCBM4X0.7X30 GR 12.9', 'X', '73181500', 8.25, 1600.00, 200.00, 3.010, 63.50, 5.24, 9.90, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3081, '416041035-0500', 'SHCBM4X0.7X35 GR 12.9', 'X', '73181500', 9.05, 1600.00, 200.00, 3.300, 63.50, 5.75, 10.86, 9.00, 0.30, 9.00, 0.30, 18.00, 0.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3082, '416041040-0500', 'SHCBM4X0.7X40 GR 12.9', 'X', '73181500', 9.95, 1600.00, 200.00, 3.630, 63.50, 6.32, 11.94, 9.00, 0.33, 9.00, 0.33, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3083, '416041045-0500', 'SHCBM4X0.7X45 GR 12.9', 'X', '73181500', 11.35, 2400.00, 200.00, 4.140, 63.50, 7.21, 13.62, 9.00, 0.37, 9.00, 0.37, 18.00, 0.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3084, '416041050-0500', 'SHCBM4X0.7X50 GR 12.9', 'X', '73181500', 14.05, 2400.00, 200.00, 5.130, 63.50, 8.92, 16.86, 9.00, 0.46, 9.00, 0.46, 18.00, 0.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3085, '416041055-0500', 'SHCBM4X0.7X55 GR 12.9', 'X', '73181500', 22.45, 800.00, 200.00, 8.190, 63.50, 14.26, 26.94, 9.00, 0.74, 9.00, 0.74, 18.00, 1.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3086, '416051030-0500', 'SHCBM5X0.8X30 GR 12.9', 'X', '73181500', 7.30, 2400.00, 200.00, 2.660, 63.50, 4.64, 8.76, 9.00, 0.24, 9.00, 0.24, 18.00, 0.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3087, '416051035-0500', 'SHCBM5X0.8X35 GR 12.9', 'X', '73181500', 8.00, 2400.00, 200.00, 2.920, 63.50, 5.08, 9.60, 9.00, 0.26, 9.00, 0.26, 18.00, 0.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3088, '416051038-0500', 'SHCBM5X0.8X38 GR 12.9', 'X', '73181500', 8.70, 2400.00, 200.00, 3.180, 63.50, 5.52, 10.44, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3089, '416051040-0500', 'SHCBM5X0.8X40 GR 12.9', 'X', '73181500', 8.70, 2400.00, 200.00, 3.180, 63.50, 5.52, 10.44, 9.00, 0.29, 9.00, 0.29, 18.00, 0.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3090, '416051045-0500', 'SHCBM5X0.8X45 GR 12.9', 'X', '73181500', 9.45, 800.00, 200.00, 3.450, 63.50, 6.00, 11.34, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3091, '416051050-0500', 'SHCBM5X0.8X50 GR 12.9', 'X', '73181500', 10.20, 800.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3092, '416051055-0500', 'SHCBM5X0.8X55 GR 12.9', 'X', '73181500', 17.35, 800.00, 200.00, 6.330, 63.50, 11.02, 20.82, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3093, '416051060-0500', 'SHCBM5X0.8X60 GR 12.9', 'X', '73181500', 22.30, 1200.00, 200.00, 8.140, 63.50, 14.16, 26.76, 9.00, 0.73, 9.00, 0.73, 18.00, 1.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3094, '416051065-0500', 'SHCBM5X0.8X65 GR 12.9', 'X', '73181500', 44.30, 800.00, 200.00, 16.170, 63.50, 28.13, 53.16, 9.00, 1.46, 9.00, 1.46, 18.00, 2.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3095, '416051070-0500', 'SHCBM5X0.8X70 GR 12.9', 'X', '73181500', 53.05, 800.00, 200.00, 19.360, 63.50, 33.69, 63.66, 9.00, 1.74, 9.00, 1.74, 18.00, 3.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3096, '416061035-0500', 'SHCBM6X1X35 GR 12.9', 'X', '73181500', 8.15, 1600.00, 200.00, 2.970, 63.50, 5.18, 9.78, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3097, '416061040-0500', 'SHCBM6X1X40 GR 12.9', 'X', '73181500', 8.80, 1600.00, 200.00, 3.210, 63.50, 5.59, 10.56, 9.00, 0.29, 9.00, 0.29, 18.00, 0.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1600.00, 1600.00, 1600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3098, '416061045-0500', 'SHCBM6X1X45 GR 12.9', 'X', '73181500', 9.55, 800.00, 200.00, 3.490, 63.50, 6.06, 11.46, 9.00, 0.31, 9.00, 0.31, 18.00, 0.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3099, '416061050-0500', 'SHCBM6X1X50 GR 12.9', 'X', '73181500', 10.20, 1200.00, 200.00, 3.720, 63.50, 6.48, 12.24, 9.00, 0.34, 9.00, 0.34, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3100, '416061055-0500', 'SHCBM6X1X55 GR 12.9', 'X', '73181500', 11.05, 1200.00, 200.00, 4.030, 63.50, 7.02, 13.26, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3101, '416061060-0500', 'SHCBM6X1X60 GR 12.9', 'X', '73181500', 20.40, 1200.00, 200.00, 7.450, 63.50, 12.95, 24.48, 9.00, 0.67, 9.00, 0.67, 18.00, 1.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 1200.00, 1200.00, 1200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3102, '416061065-0500', 'SHCBM6X1X65 GR 12.9', 'X', '73181500', 21.15, 800.00, 200.00, 7.720, 63.50, 13.43, 25.38, 9.00, 0.69, 9.00, 0.69, 18.00, 1.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3103, '416061070-0500', 'SHCBM6X1X70 GR 12.9', 'X', '73181500', 21.95, 800.00, 200.00, 8.010, 63.50, 13.94, 26.34, 9.00, 0.72, 9.00, 0.72, 18.00, 1.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3104, '416061075-0500', 'SHCBM6X1X75 GR 12.9', 'X', '73181500', 24.50, 800.00, 200.00, 8.940, 63.50, 15.56, 29.40, 9.00, 0.80, 9.00, 0.80, 18.00, 1.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3105, '416061080-0500', 'SHCBM6X1X80 GR 12.9', 'X', '73181500', 22.40, 800.00, 200.00, 8.180, 63.50, 14.22, 26.88, 9.00, 0.74, 9.00, 0.74, 18.00, 1.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3106, '416061085-0500', 'SHCBM6X1X85 GR 12.9', 'X', '73181500', 28.30, 800.00, 200.00, 10.330, 63.50, 17.97, 33.96, 9.00, 0.93, 9.00, 0.93, 18.00, 1.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3107, '416061090-0500', 'SHCBM6X1X90 GR 12.9', 'X', '73181500', 28.30, 400.00, 100.00, 10.330, 63.50, 17.97, 33.96, 9.00, 0.93, 9.00, 0.93, 18.00, 1.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3108, '416061100-0500', 'SHCBM6X1X100 GR 12.9', 'X', '73181500', 31.95, 400.00, 100.00, 11.660, 63.50, 20.29, 38.34, 9.00, 1.05, 9.00, 1.05, 18.00, 2.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(3109, '416061110-0500', 'SHCBM6X1X110 GR 12.9', 'X', '73181500', 38.25, 600.00, 100.00, 13.960, 63.50, 24.29, 45.90, 9.00, 1.26, 9.00, 1.26, 18.00, 2.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3110, '416061115-0500', 'SHCBM6X1X115 GR 12.9', 'X', '73181500', 35.00, 600.00, 100.00, 12.780, 63.50, 22.23, 42.00, 9.00, 1.15, 9.00, 1.15, 18.00, 2.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3111, '416061120-0500', 'SHCBM6X1X120 GR 12.9', 'X', '73181500', 36.70, 200.00, 50.00, 13.400, 63.50, 23.30, 44.04, 9.00, 1.21, 9.00, 1.21, 18.00, 2.41, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3112, '416061125-0500', 'SHCBM6X1X125 GR 12.9', 'X', '73181500', 60.60, 200.00, 50.00, 22.120, 63.50, 38.48, 72.72, 9.00, 1.99, 9.00, 1.99, 18.00, 3.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3113, '416061130-0500', 'SHCBM6X1X130 GR 12.9', 'X', '73181500', 60.60, 200.00, 50.00, 22.120, 63.50, 38.48, 72.72, 9.00, 1.99, 9.00, 1.99, 18.00, 3.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3114, '416082040-0500', 'SHCBM8X1.25X40 GR 12.9', 'X', '73181500', 9.90, 800.00, 200.00, 3.610, 63.50, 6.29, 11.88, 9.00, 0.33, 9.00, 0.33, 18.00, 0.65, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3115, '416082045-0500', 'SHCBM8X1.25X45 GR 12.9', 'X', '73181500', 10.60, 800.00, 200.00, 3.870, 63.50, 6.73, 12.72, 9.00, 0.35, 9.00, 0.35, 18.00, 0.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3116, '416082050-0500', 'SHCBM8X1.25X50 GR 12.9', 'X', '73181500', 11.05, 800.00, 200.00, 4.030, 63.50, 7.02, 13.26, 9.00, 0.36, 9.00, 0.36, 18.00, 0.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3117, '416082055-0500', 'SHCBM8X1.25X55 GR 12.9', 'X', '73181500', 12.15, 800.00, 200.00, 4.430, 63.50, 7.72, 14.58, 9.00, 0.40, 9.00, 0.40, 18.00, 0.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3118, '416082060-0500', 'SHCBM8X1.25X60 GR 12.9', 'X', '73181500', 13.05, 600.00, 100.00, 4.760, 63.50, 8.29, 15.66, 9.00, 0.43, 9.00, 0.43, 18.00, 0.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3119, '416082065-0500', 'SHCBM8X1.25X65 GR 12.9', 'X', '73181500', 13.90, 400.00, 100.00, 5.070, 63.50, 8.83, 16.68, 9.00, 0.46, 9.00, 0.46, 18.00, 0.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3120, '416082070-0500', 'SHCBM8X1.25X70 GR 12.9', 'X', '73181500', 14.90, 400.00, 100.00, 5.440, 63.50, 9.46, 17.88, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3121, '416082075-0500', 'SHCBM8X1.25X75 GR 12.9', 'X', '73181500', 15.75, 400.00, 100.00, 5.750, 63.50, 10.00, 18.90, 9.00, 0.52, 9.00, 0.52, 18.00, 1.03, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3122, '416082080-0500', 'SHCBM8X1.25X80 GR 12.9', 'X', '73181500', 23.75, 400.00, 100.00, 8.670, 63.50, 15.08, 28.50, 9.00, 0.78, 9.00, 0.78, 18.00, 1.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3123, '416082085-0500', 'SHCBM8X1.25X85 GR 12.9', 'X', '73181500', 27.45, 400.00, 100.00, 10.020, 63.50, 17.43, 32.94, 9.00, 0.90, 9.00, 0.90, 18.00, 1.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3124, '416082090-0500', 'SHCBM8X1.25X90 GR 12.9', 'X', '73181500', 27.45, 400.00, 100.00, 10.020, 63.50, 17.43, 32.94, 9.00, 0.90, 9.00, 0.90, 18.00, 1.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3125, '416082095-0500', 'SHCBM8X1.25X95 GR 12.9', 'X', '73181500', 32.55, 400.00, 100.00, 11.880, 63.50, 20.67, 39.06, 9.00, 1.07, 9.00, 1.07, 18.00, 2.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3126, '416082100-0500', 'SHCBM8X1.25X100 GR 12.9', 'X', '73181500', 32.55, 400.00, 100.00, 11.880, 63.50, 20.67, 39.06, 9.00, 1.07, 9.00, 1.07, 18.00, 2.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3127, '416082110-0500', 'SHCBM8X1.25X110 GR 12.9', 'X', '73181500', 40.65, 300.00, 50.00, 14.840, 63.50, 25.81, 48.78, 9.00, 1.34, 9.00, 1.34, 18.00, 2.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3128, '416082120-0500', 'SHCBM8X1.25X120 GR 12.9', 'X', '73181500', 47.45, 300.00, 50.00, 17.320, 63.50, 30.13, 56.94, 9.00, 1.56, 9.00, 1.56, 18.00, 3.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3129, '416082125-0500', 'SHCBM8X1.25X125 GR 12.9', 'X', '73181500', 58.35, 300.00, 50.00, 21.300, 63.50, 37.05, 70.02, 9.00, 1.92, 9.00, 1.92, 18.00, 3.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3130, '416082130-0500', 'SHCBM8X1.25X130 GR 12.9', 'X', '73181500', 58.35, 300.00, 50.00, 21.300, 63.50, 37.05, 70.02, 9.00, 1.92, 9.00, 1.92, 18.00, 3.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3131, '416082140-0500', 'SHCBM8X1.25X140 GR 12.9', 'X', '73181500', 62.65, 300.00, 50.00, 22.870, 63.50, 39.78, 75.18, 9.00, 2.06, 9.00, 2.06, 18.00, 4.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3132, '416082150-0500', 'SHCBM8X1.25X150 GR 12.9', 'X', '73181500', 67.65, 300.00, 50.00, 24.690, 63.50, 42.96, 81.18, 9.00, 2.22, 9.00, 2.22, 18.00, 4.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3133, '416103045-0500', 'SHCBM10X1.5X45 GR 12.9', 'X', '73181500', 14.30, 600.00, 100.00, 5.220, 63.50, 9.08, 17.16, 9.00, 0.47, 9.00, 0.47, 18.00, 0.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3134, '416103050-0500', 'SHCBM10X1.5X50 GR 12.9', 'X', '73181500', 15.25, 400.00, 100.00, 5.570, 63.50, 9.68, 18.30, 9.00, 0.50, 9.00, 0.50, 18.00, 1.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3135, '416103055-0500', 'SHCBM10X1.5X55 GR 12.9', 'X', '73181500', 16.45, 400.00, 100.00, 6.000, 63.50, 10.45, 19.74, 9.00, 0.54, 9.00, 0.54, 18.00, 1.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3136, '416103060-0500', 'SHCBM10X1.5X60 GR 12.9', 'X', '73181500', 17.75, 400.00, 100.00, 6.480, 63.50, 11.27, 21.30, 9.00, 0.58, 9.00, 0.58, 18.00, 1.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3137, '416103065-0500', 'SHCBM10X1.5X65 GR 12.9', 'X', '73181500', 19.20, 400.00, 100.00, 7.010, 63.50, 12.19, 23.04, 9.00, 0.63, 9.00, 0.63, 18.00, 1.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3138, '416103070-0500', 'SHCBM10X1.5X70 GR 12.9', 'X', '73181500', 20.60, 400.00, 100.00, 7.520, 63.50, 13.08, 24.72, 9.00, 0.68, 9.00, 0.68, 18.00, 1.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3139, '416103075-0500', 'SHCBM10X1.5X75 GR 12.9', 'X', '73181500', 21.90, 400.00, 100.00, 7.990, 63.50, 13.91, 26.28, 9.00, 0.72, 9.00, 0.72, 18.00, 1.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3140, '416103080-0500', 'SHCBM10X1.5X80 GR 12.9', 'X', '73181500', 33.85, 200.00, 50.00, 12.360, 63.50, 21.49, 40.62, 9.00, 1.11, 9.00, 1.11, 18.00, 2.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3141, '416103085-0500', 'SHCBM10X1.5X85 GR 12.9', 'X', '73181500', 38.55, 200.00, 50.00, 14.070, 63.50, 24.48, 46.26, 9.00, 1.27, 9.00, 1.27, 18.00, 2.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3142, '416103090-0500', 'SHCBM10X1.5X90 GR 12.9', 'X', '73181500', 38.55, 200.00, 50.00, 14.070, 63.50, 24.48, 46.26, 9.00, 1.27, 9.00, 1.27, 18.00, 2.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3143, '416103095-0500', 'SHCBM10X1.5X95 GR 12.9', 'X', '73181500', 45.35, 200.00, 50.00, 16.550, 63.50, 28.80, 54.42, 9.00, 1.49, 9.00, 1.49, 18.00, 2.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3144, '416103100-0500', 'SHCBM10X1.5X100 GR 12.9', 'X', '73181500', 45.35, 200.00, 50.00, 16.550, 63.50, 28.80, 54.42, 9.00, 1.49, 9.00, 1.49, 18.00, 2.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3145, '416103110-0500', 'SHCBM10X1.5X110 GR 12.9', 'X', '73181500', 53.55, 200.00, 25.00, 19.550, 63.50, 34.00, 64.26, 9.00, 1.76, 9.00, 1.76, 18.00, 3.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3146, '416103120-0500', 'SHCBM10X1.5X120 GR 12.9', 'X', '73181500', 54.15, 200.00, 25.00, 19.760, 63.50, 34.39, 64.98, 9.00, 1.78, 9.00, 1.78, 18.00, 3.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3147, '416103125-0500', 'SHCBM10X1.5X125 GR 12.9', 'X', '73181500', 74.55, 150.00, 25.00, 27.210, 63.50, 47.34, 89.46, 9.00, 2.45, 9.00, 2.45, 18.00, 4.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3148, '416103130-0500', 'SHCBM10X1.5X130 GR 12.9', 'X', '73181500', 74.55, 150.00, 25.00, 27.210, 63.50, 47.34, 89.46, 9.00, 2.45, 9.00, 2.45, 18.00, 4.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3149, '416103140-0500', 'SHCBM10X1.5X140 GR 12.9', 'X', '73181500', 83.40, 150.00, 25.00, 30.440, 63.50, 52.96, 100.08, 9.00, 2.74, 9.00, 2.74, 18.00, 5.48, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3150, '416103150-0500', 'SHCBM10X1.5X150 GR 12.9', 'X', '73181500', 92.60, 150.00, 25.00, 33.800, 63.50, 58.80, 111.12, 9.00, 3.04, 9.00, 3.04, 18.00, 6.08, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3151, '416124050-0500', 'SHCBM12X1.75X50 GR 12.9', 'X', '73181500', 25.70, 300.00, 50.00, 9.380, 63.50, 16.32, 30.84, 9.00, 0.84, 9.00, 0.84, 18.00, 1.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3152, '416124055-0500', 'SHCBM12X1.75X55 GR 12.9', 'X', '73181500', 27.10, 300.00, 50.00, 9.890, 63.50, 17.21, 32.52, 9.00, 0.89, 9.00, 0.89, 18.00, 1.78, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3153, '416124060-0500', 'SHCBM12X1.75X60 GR 12.9', 'X', '73181500', 28.65, 300.00, 50.00, 10.460, 63.50, 18.19, 34.38, 9.00, 0.94, 9.00, 0.94, 18.00, 1.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3154, '416124065-0500', 'SHCBM12X1.75X65 GR 12.9', 'X', '73181500', 30.15, 200.00, 50.00, 11.000, 63.50, 19.15, 36.18, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3155, '416124070-0500', 'SHCBM12X1.75X70 GR 12.9', 'X', '73181500', 31.80, 200.00, 50.00, 11.610, 63.50, 20.19, 38.16, 9.00, 1.04, 9.00, 1.04, 18.00, 2.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3156, '416124075-0500', 'SHCBM12X1.75X75 GR 12.9', 'X', '73181500', 33.20, 200.00, 50.00, 12.120, 63.50, 21.08, 39.84, 9.00, 1.09, 9.00, 1.09, 18.00, 2.18, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3157, '416124080-0500', 'SHCBM12X1.75X80 GR 12.9', 'X', '73181500', 39.80, 200.00, 50.00, 14.530, 63.50, 25.27, 47.76, 9.00, 1.31, 9.00, 1.31, 18.00, 2.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3158, '416124085-0500', 'SHCBM12X1.75X85 GR 12.9', 'X', '73181500', 45.00, 200.00, 50.00, 16.430, 63.50, 28.58, 54.00, 9.00, 1.48, 9.00, 1.48, 18.00, 2.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3159, '416124090-0500', 'SHCBM12X1.75X90 GR 12.9', 'X', '73181500', 45.00, 200.00, 50.00, 16.430, 63.50, 28.58, 54.00, 9.00, 1.48, 9.00, 1.48, 18.00, 2.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3160, '416124095-0500', 'SHCBM12X1.75X95 GR 12.9', 'X', '73181500', 52.05, 200.00, 50.00, 19.000, 63.50, 33.05, 62.46, 9.00, 1.71, 9.00, 1.71, 18.00, 3.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3161, '416124100-0500', 'SHCBM12X1.75X100 GR 12.9', 'X', '73181500', 52.05, 200.00, 50.00, 19.000, 63.50, 33.05, 62.46, 9.00, 1.71, 9.00, 1.71, 18.00, 3.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3162, '416124105-0500', 'SHCBM12X1.75X105 GR 12.9', 'X', '73181500', 62.50, 200.00, 50.00, 22.810, 63.50, 39.69, 75.00, 9.00, 2.05, 9.00, 2.05, 18.00, 4.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3163, '416124110-0500', 'SHCBM12X1.75X110 GR 12.9', 'X', '73181500', 62.50, 150.00, 25.00, 22.810, 63.50, 39.69, 75.00, 9.00, 2.05, 9.00, 2.05, 18.00, 4.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3164, '416124115-0500', 'SHCBM12X1.75X115 GR 12.9', 'X', '73181500', 71.95, 150.00, 25.00, 26.260, 63.50, 45.69, 86.34, 9.00, 2.36, 9.00, 2.36, 18.00, 4.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3165, '416124120-0500', 'SHCBM12X1.75X120 GR 12.9', 'X', '73181500', 71.95, 150.00, 25.00, 26.260, 63.50, 45.69, 86.34, 9.00, 2.36, 9.00, 2.36, 18.00, 4.73, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3166, '416124125-0500', 'SHCBM12X1.75X125 GR 12.9', 'X', '73181500', 87.40, 150.00, 25.00, 31.900, 63.50, 55.50, 104.88, 9.00, 2.87, 9.00, 2.87, 18.00, 5.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3167, '416124130-0500', 'SHCBM12X1.75X130 GR 12.9', 'X', '73181500', 87.40, 150.00, 25.00, 31.900, 63.50, 55.50, 104.88, 9.00, 2.87, 9.00, 2.87, 18.00, 5.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3168, '416124140-0500', 'SHCBM12X1.75X140 GR 12.9', 'X', '73181500', 97.30, 150.00, 25.00, 35.510, 63.50, 61.79, 116.76, 9.00, 3.20, 9.00, 3.20, 18.00, 6.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3169, '416124150-0500', 'SHCBM12X1.75X150 GR 12.9', 'X', '73181500', 107.40, 150.00, 25.00, 39.200, 63.50, 68.20, 128.88, 9.00, 3.53, 9.00, 3.53, 18.00, 7.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3170, '416124160-0500', 'SHCBM12X1.75X160 GR 12.9', 'X', '73181500', 176.95, 100.00, 25.00, 64.590, 63.50, 112.36, 212.34, 9.00, 5.81, 9.00, 5.81, 18.00, 11.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3171, '416124165-0500', 'SHCBM12X1.75X165 GR 12.9', 'X', '73181500', 194.65, 100.00, 25.00, 71.050, 63.50, 123.60, 233.58, 9.00, 6.39, 9.00, 6.39, 18.00, 12.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3172, '416124170-0500', 'SHCBM12X1.75X170 GR 12.9', 'X', '73181500', 194.65, 100.00, 25.00, 71.050, 63.50, 123.60, 233.58, 9.00, 6.39, 9.00, 6.39, 18.00, 12.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3173, '416124180-0500', 'SHCBM12X1.75X180 GR 12.9', 'X', '73181500', 194.65, 100.00, 25.00, 71.050, 63.50, 123.60, 233.58, 9.00, 6.39, 9.00, 6.39, 18.00, 12.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3174, '416124180-4000', 'SHCBM12X1.75X180 GR 12.9', 'X', '73181500', 194.65, 100.00, 25.00, 71.050, 63.50, 123.60, 233.58, 9.00, 6.39, 9.00, 6.39, 18.00, 12.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3175, '416124190-0500', 'SHCBM12X1.75X190 GR 12.9', 'X', '73181500', 210.60, 100.00, 25.00, 76.870, 63.50, 133.73, 252.72, 9.00, 6.92, 9.00, 6.92, 18.00, 13.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3176, '416124200-0500', 'SHCBM12X1.75X200 GR 12.9', 'X', '73181500', 210.60, 100.00, 25.00, 76.870, 63.50, 133.73, 252.72, 9.00, 6.92, 9.00, 6.92, 18.00, 13.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 100.00, 100.00, 100.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3177, '416143070-0500', 'SHCBM14X1.5X70 GR 12.9', 'X', '73181500', 65.55, 200.00, 50.00, 23.930, 63.50, 41.62, 78.66, 9.00, 2.15, 9.00, 2.15, 18.00, 4.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3178, '416145060-0500', 'SHCBM14X2X60 GR 12.9', 'X', '73181500', 59.95, 200.00, 50.00, 21.880, 63.50, 38.07, 71.94, 9.00, 1.97, 9.00, 1.97, 18.00, 3.94, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3179, '416145065-0500', 'SHCBM14X2X65 GR 12.9', 'X', '73181500', 60.75, 200.00, 50.00, 22.170, 63.50, 38.58, 72.90, 9.00, 2.00, 9.00, 2.00, 18.00, 3.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3180, '416145070-0500', 'SHCBM14X2X70 GR 12.9', 'X', '73181500', 65.55, 200.00, 50.00, 23.930, 63.50, 41.62, 78.66, 9.00, 2.15, 9.00, 2.15, 18.00, 4.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3181, '416145075-0500', 'SHCBM14X2X75 GR 12.9', 'X', '73181500', 69.25, 200.00, 50.00, 25.280, 63.50, 43.97, 83.10, 9.00, 2.27, 9.00, 2.27, 18.00, 4.55, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3182, '416145080-0500', 'SHCBM14X2X80 GR 12.9', 'X', '73181500', 72.60, 80.00, 10.00, 26.500, 63.50, 46.10, 87.12, 9.00, 2.38, 9.00, 2.38, 18.00, 4.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3183, '416145085-0500', 'SHCBM14X2X85 GR 12.9', 'X', '73181500', 74.25, 20.00, 10.00, 27.100, 63.50, 47.15, 89.10, 9.00, 2.44, 9.00, 2.44, 18.00, 4.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3184, '416145090-0500', 'SHCBM14X2X90 GR 12.9', 'X', '73181500', 74.25, 80.00, 10.00, 27.100, 63.50, 47.15, 89.10, 9.00, 2.44, 9.00, 2.44, 18.00, 4.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3185, '416145095-0500', 'SHCBM14X2X95 GR 12.9', 'X', '73181500', 92.05, 80.00, 10.00, 33.600, 63.50, 58.45, 110.46, 9.00, 3.02, 9.00, 3.02, 18.00, 6.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3186, '416145100-0500', 'SHCBM14X2X100 GR 12.9', 'X', '73181500', 92.05, 80.00, 10.00, 33.600, 63.50, 58.45, 110.46, 9.00, 3.02, 9.00, 3.02, 18.00, 6.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3187, '416145110-0500', 'SHCBM14X2X110 GR 12.9', 'X', '73181500', 100.05, 80.00, 10.00, 36.520, 63.50, 63.53, 120.06, 9.00, 3.29, 9.00, 3.29, 18.00, 6.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3188, '416145120-0500', 'SHCBM14X2X120 GR 12.9', 'X', '73181500', 108.15, 80.00, 10.00, 39.470, 63.50, 68.68, 129.78, 9.00, 3.55, 9.00, 3.55, 18.00, 7.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3189, '416145130-0500', 'SHCBM14X2X130 GR 12.9', 'X', '73181500', 125.25, 60.00, 10.00, 45.720, 63.50, 79.53, 150.30, 9.00, 4.11, 9.00, 4.11, 18.00, 8.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3190, '416145140-0500', 'SHCBM14X2X140 GR 12.9', 'X', '73181500', 134.05, 60.00, 10.00, 48.930, 63.50, 85.12, 160.86, 9.00, 4.40, 9.00, 4.40, 18.00, 8.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3191, '416145150-0500', 'SHCBM14X2X150 GR 12.9', 'X', '73181500', 142.95, 60.00, 10.00, 52.180, 63.50, 90.77, 171.54, 9.00, 4.70, 9.00, 4.70, 18.00, 9.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3192, '416165060-0500', 'SHCBM16X2X60 GR 12.9', 'X', '73181500', 58.35, 120.00, 10.00, 21.300, 63.50, 37.05, 70.02, 9.00, 1.92, 9.00, 1.92, 18.00, 3.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3193, '416165065-0500', 'SHCBM16X2X65 GR 12.9', 'X', '73181500', 59.20, 120.00, 10.00, 21.610, 63.50, 37.59, 71.04, 9.00, 1.94, 9.00, 1.94, 18.00, 3.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3194, '416165070-0500', 'SHCBM16X2X70 GR 12.9', 'X', '73181500', 63.85, 120.00, 10.00, 23.310, 63.50, 40.54, 76.62, 9.00, 2.10, 9.00, 2.10, 18.00, 4.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3195, '416165075-0500', 'SHCBM16X2X75 GR 12.9', 'X', '73181500', 67.55, 120.00, 10.00, 24.660, 63.50, 42.89, 81.06, 9.00, 2.22, 9.00, 2.22, 18.00, 4.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3196, '416165080-0500', 'SHCBM16X2X80 GR 12.9', 'X', '73181500', 70.70, 120.00, 10.00, 25.810, 63.50, 44.89, 84.84, 9.00, 2.32, 9.00, 2.32, 18.00, 4.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 120.00, 120.00, 120.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3197, '416165085-0500', 'SHCBM16X2X85 GR 12.9', 'X', '73181500', 72.25, 80.00, 10.00, 26.370, 63.50, 45.88, 86.70, 9.00, 2.37, 9.00, 2.37, 18.00, 4.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3198, '416165090-0500', 'SHCBM16X2X90 GR 12.9', 'X', '73181500', 72.25, 80.00, 10.00, 26.370, 63.50, 45.88, 86.70, 9.00, 2.37, 9.00, 2.37, 18.00, 4.75, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3199, '416165095-0500', 'SHCBM16X2X95 GR 12.9', 'X', '73181500', 89.70, 80.00, 10.00, 32.740, 63.50, 56.96, 107.64, 9.00, 2.95, 9.00, 2.95, 18.00, 5.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 80.00, 80.00, 80.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3200, '416165100-0500', 'SHCBM16X2X100 GR 12.9', 'X', '73181500', 89.70, 40.00, 10.00, 32.740, 63.50, 56.96, 107.64, 9.00, 2.95, 9.00, 2.95, 18.00, 5.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3201, '416165110-0500', 'SHCBM16X2X110 GR 12.9', 'X', '73181500', 97.45, 60.00, 10.00, 35.570, 63.50, 61.88, 116.94, 9.00, 3.20, 9.00, 3.20, 18.00, 6.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3202, '416165115-0500', 'SHCBM16X2X115 GR 12.9', 'X', '73181500', 105.30, 60.00, 10.00, 38.430, 63.50, 66.87, 126.36, 9.00, 3.46, 9.00, 3.46, 18.00, 6.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3203, '416165120-0500', 'SHCBM16X2X120 GR 12.9', 'X', '73181500', 105.30, 60.00, 10.00, 38.430, 63.50, 66.87, 126.36, 9.00, 3.46, 9.00, 3.46, 18.00, 6.92, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3204, '416165125-0500', 'SHCBM16X2X125 GR 12.9', 'X', '73181500', 122.00, 60.00, 10.00, 44.530, 63.50, 77.47, 146.40, 9.00, 4.01, 9.00, 4.01, 18.00, 8.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3205, '416165130-0500', 'SHCBM16X2X130 GR 12.9', 'X', '73181500', 122.00, 60.00, 10.00, 44.530, 63.50, 77.47, 146.40, 9.00, 4.01, 9.00, 4.01, 18.00, 8.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3206, '416165140-0500', 'SHCBM16X2X140 GR 12.9', 'X', '73181500', 130.55, 60.00, 10.00, 47.650, 63.50, 82.90, 156.66, 9.00, 4.29, 9.00, 4.29, 18.00, 8.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3207, '416165150-0500', 'SHCBM16X2X150 GR 12.9', 'X', '73181500', 139.15, 60.00, 10.00, 50.790, 63.50, 88.36, 166.98, 9.00, 4.57, 9.00, 4.57, 18.00, 9.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3208, '416165160-0500', 'SHCBM16X2X160 GR 12.9', 'X', '73181500', 276.95, 60.00, 10.00, 101.090, 63.50, 175.86, 332.34, 9.00, 9.10, 9.00, 9.10, 18.00, 18.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 60.00, 60.00, 60.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3209, '416165170-0500', 'SHCBM16X2X170 GR 12.9', 'X', '73181500', 308.40, 40.00, 10.00, 112.570, 63.50, 195.83, 370.08, 9.00, 10.13, 9.00, 10.13, 18.00, 20.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3210, '416165180-0500', 'SHCBM16X2X180 GR 12.9', 'X', '73181500', 308.40, 40.00, 10.00, 112.570, 63.50, 195.83, 370.08, 9.00, 10.13, 9.00, 10.13, 18.00, 20.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3211, '416165190-0500', 'SHCBM16X2X190 GR 12.9', 'X', '73181500', 340.85, 40.00, 10.00, 124.410, 63.50, 216.44, 409.02, 9.00, 11.20, 9.00, 11.20, 18.00, 22.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3212, '416165200-0500', 'SHCBM16X2X200 GR 12.9', 'X', '73181500', 340.85, 40.00, 10.00, 124.410, 63.50, 216.44, 409.02, 9.00, 11.20, 9.00, 11.20, 18.00, 22.39, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3213, '416165210-0500', 'SHCBM16X2X210 GR 12.9', 'X', '73181500', 356.50, 40.00, 10.00, 130.120, 63.50, 226.38, 427.80, 9.00, 11.71, 9.00, 11.71, 18.00, 23.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3214, '416165220-0500', 'SHCBM16X2X220 GR 12.9', 'X', '73181500', 356.50, 40.00, 10.00, 130.120, 63.50, 226.38, 427.80, 9.00, 11.71, 9.00, 11.71, 18.00, 23.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3215, '416165230-0500', 'SHCBM16X2X230 GR 12.9', 'X', '73181500', 372.25, 40.00, 10.00, 135.870, 63.50, 236.38, 446.70, 9.00, 12.23, 9.00, 12.23, 18.00, 24.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3216, '416165240-0500', 'SHCBM16X2X240 GR 12.9', 'X', '73181500', 372.25, 40.00, 10.00, 135.870, 63.50, 236.38, 446.70, 9.00, 12.23, 9.00, 12.23, 18.00, 24.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3217, '416165250-0500', 'SHCBM16X2X250 GR 12.9', 'X', '73181500', 387.95, 10.00, 10.00, 141.600, 63.50, 246.35, 465.54, 9.00, 12.74, 9.00, 12.74, 18.00, 25.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3218, '416165260-0500', 'SHCBM16X2X260 GR 12.9', 'X', '73181500', 387.95, 10.00, 10.00, 141.600, 63.50, 246.35, 465.54, 9.00, 12.74, 9.00, 12.74, 18.00, 25.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3219, '416165280-0500', 'SHCBM16X2X280 GR 12.9', 'X', '73181500', 403.70, 10.00, 10.00, 147.350, 63.50, 256.35, 484.44, 9.00, 13.26, 9.00, 13.26, 18.00, 26.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3220, '416165300-0500', 'SHCBM16X2X300 GR 12.9', 'X', '73181500', 419.45, 10.00, 10.00, 153.100, 63.50, 266.35, 503.34, 9.00, 13.78, 9.00, 13.78, 18.00, 27.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3221, '416187070-0500', 'SHCBM18X2.5X70 GR 12.9', 'X', '73181500', 160.35, 40.00, 10.00, 58.530, 63.50, 101.82, 192.42, 9.00, 5.27, 9.00, 5.27, 18.00, 10.53, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3222, '416187075-0500', 'SHCBM18X2.5X75 GR 12.9', 'X', '73181500', 170.75, 40.00, 10.00, 62.320, 63.50, 108.43, 204.90, 9.00, 5.61, 9.00, 5.61, 18.00, 11.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3223, '416187080-0500', 'SHCBM18X2.5X80 GR 12.9', 'X', '73181500', 174.05, 40.00, 10.00, 63.530, 63.50, 110.52, 208.86, 9.00, 5.72, 9.00, 5.72, 18.00, 11.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3224, '416187085-0500', 'SHCBM18X2.5X85 GR 12.9', 'X', '73181500', 177.55, 40.00, 10.00, 64.810, 63.50, 112.74, 213.06, 9.00, 5.83, 9.00, 5.83, 18.00, 11.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3225, '416187090-0500', 'SHCBM18X2.5X90 GR 12.9', 'X', '73181500', 177.55, 40.00, 10.00, 64.810, 63.50, 112.74, 213.06, 9.00, 5.83, 9.00, 5.83, 18.00, 11.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3226, '416187100-0500', 'SHCBM18X2.5X100 GR 12.9', 'X', '73181500', 186.25, 40.00, 10.00, 67.980, 63.50, 118.27, 223.50, 9.00, 6.12, 9.00, 6.12, 18.00, 12.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3227, '416187110-0500', 'SHCBM18X2.5X110 GR 12.9', 'X', '73181500', 206.10, 30.00, 10.00, 75.230, 63.50, 130.87, 247.32, 9.00, 6.77, 9.00, 6.77, 18.00, 13.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3228, '416187120-0500', 'SHCBM18X2.5X120 GR 12.9', 'X', '73181500', 225.75, 30.00, 10.00, 82.400, 63.50, 143.35, 270.90, 9.00, 7.42, 9.00, 7.42, 18.00, 14.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3229, '416187130-0500', 'SHCBM18X2.5X130 GR 12.9', 'X', '73181500', 245.60, 30.00, 10.00, 89.640, 63.50, 155.96, 294.72, 9.00, 8.07, 9.00, 8.07, 18.00, 16.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3230, '416187140-0500', 'SHCBM18X2.5X140 GR 12.9', 'X', '73181500', 265.25, 30.00, 10.00, 96.820, 63.50, 168.43, 318.30, 9.00, 8.71, 9.00, 8.71, 18.00, 17.43, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3231, '416187150-0500', 'SHCBM18X2.5X150 GR 12.9', 'X', '73181500', 284.95, 30.00, 10.00, 104.010, 63.50, 180.94, 341.94, 9.00, 9.36, 9.00, 9.36, 18.00, 18.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3232, '416187160-0500', 'SHCBM18X2.5X160 GR 12.9', 'X', '73181500', 347.80, 30.00, 10.00, 126.950, 63.50, 220.85, 417.36, 9.00, 11.43, 9.00, 11.43, 18.00, 22.85, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3233, '416187180-0500', 'SHCBM18X2.5X180 GR 12.9', 'X', '73181500', 397.30, 40.00, 10.00, 145.010, 63.50, 252.29, 476.76, 9.00, 13.05, 9.00, 13.05, 18.00, 26.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3234, '416187200-0500', 'SHCBM18X2.5X200 GR 12.9', 'X', '73181500', 414.30, 40.00, 10.00, 151.220, 63.50, 263.08, 497.16, 9.00, 13.61, 9.00, 13.61, 18.00, 27.22, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3235, '416207070-0500', 'SHCBM20X2.5X70 GR 12.9', 'X', '73181500', 145.75, 40.00, 10.00, 53.200, 63.50, 92.55, 174.90, 9.00, 4.79, 9.00, 4.79, 18.00, 9.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3236, '416207075-0500', 'SHCBM20X2.5X75 GR 12.9', 'X', '73181500', 155.25, 40.00, 10.00, 56.670, 63.50, 98.58, 186.30, 9.00, 5.10, 9.00, 5.10, 18.00, 10.20, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 40.00, 40.00, 40.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3237, '416207080-0500', 'SHCBM20X2.5X80 GR 12.9', 'X', '73181500', 158.30, 30.00, 10.00, 57.780, 63.50, 100.52, 189.96, 9.00, 5.20, 9.00, 5.20, 18.00, 10.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3238, '416207085-0500', 'SHCBM20X2.5X85 GR 12.9', 'X', '73181500', 161.45, 30.00, 10.00, 58.930, 63.50, 102.52, 193.74, 9.00, 5.30, 9.00, 5.30, 18.00, 10.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3239, '416207090-0500', 'SHCBM20X2.5X90 GR 12.9', 'X', '73181500', 161.45, 30.00, 10.00, 58.930, 63.50, 102.52, 193.74, 9.00, 5.30, 9.00, 5.30, 18.00, 10.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3240, '416207095-0500', 'SHCBM20X2.5X95 GR 12.9', 'X', '73181500', 169.30, 30.00, 10.00, 61.790, 63.50, 107.51, 203.16, 9.00, 5.56, 9.00, 5.56, 18.00, 11.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3241, '416207100-0500', 'SHCBM20X2.5X100 GR 12.9', 'X', '73181500', 169.30, 30.00, 10.00, 61.790, 63.50, 107.51, 203.16, 9.00, 5.56, 9.00, 5.56, 18.00, 11.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3242, '416207110-0500', 'SHCBM20X2.5X110 GR 12.9', 'X', '73181500', 187.30, 30.00, 10.00, 68.360, 63.50, 118.94, 224.76, 9.00, 6.15, 9.00, 6.15, 18.00, 12.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3243, '416207120-0500', 'SHCBM20X2.5X120 GR 12.9', 'X', '73181500', 205.35, 30.00, 10.00, 74.950, 63.50, 130.40, 246.42, 9.00, 6.75, 9.00, 6.75, 18.00, 13.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3244, '416207125-0500', 'SHCBM20X2.5X125 GR 12.9', 'X', '73181500', 223.30, 30.00, 10.00, 81.500, 63.50, 141.80, 267.96, 9.00, 7.34, 9.00, 7.34, 18.00, 14.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3245, '416207130-0500', 'SHCBM20X2.5X130 GR 12.9', 'X', '73181500', 223.30, 30.00, 10.00, 81.500, 63.50, 141.80, 267.96, 9.00, 7.34, 9.00, 7.34, 18.00, 14.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3246, '416207135-0500', 'SHCBM20X2.5X135 GR 12.9', 'X', '73181500', 241.15, 30.00, 10.00, 88.020, 63.50, 153.13, 289.38, 9.00, 7.92, 9.00, 7.92, 18.00, 15.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3247, '416207140-0500', 'SHCBM20X2.5X140 GR 12.9', 'X', '73181500', 241.15, 15.00, 5.00, 88.020, 63.50, 153.13, 289.38, 9.00, 7.92, 9.00, 7.92, 18.00, 15.84, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3248, '416207150-0500', 'SHCBM20X2.5X150 GR 12.9', 'X', '73181500', 259.05, 15.00, 5.00, 94.550, 63.50, 164.50, 310.86, 9.00, 8.51, 9.00, 8.51, 18.00, 17.02, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3249, '416207160-0500', 'SHCBM20X2.5X160 GR 12.9', 'X', '73181500', 332.05, 15.00, 5.00, 121.200, 63.50, 210.85, 398.46, 9.00, 10.91, 9.00, 10.91, 18.00, 21.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3250, '416207170-0500', 'SHCBM20X2.5X170 GR 12.9', 'X', '73181500', 379.15, 20.00, 5.00, 138.390, 63.50, 240.76, 454.98, 9.00, 12.46, 9.00, 12.46, 18.00, 24.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3251, '416207175-0500', 'SHCBM20X2.5X175 GR 12.9', 'X', '73181500', 379.15, 20.00, 5.00, 138.390, 63.50, 240.76, 454.98, 9.00, 12.46, 9.00, 12.46, 18.00, 24.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3252, '416207180-0500', 'SHCBM20X2.5X180 GR 12.9', 'X', '73181500', 379.15, 20.00, 5.00, 138.390, 63.50, 240.76, 454.98, 9.00, 12.46, 9.00, 12.46, 18.00, 24.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3253, '416207190-0500', 'SHCBM20X2.5X190 GR 12.9', 'X', '73181500', 395.40, 20.00, 5.00, 144.320, 63.50, 251.08, 474.48, 9.00, 12.99, 9.00, 12.99, 18.00, 25.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3254, '416207200-0500', 'SHCBM20X2.5X200 GR 12.9', 'X', '73181500', 395.40, 20.00, 5.00, 144.320, 63.50, 251.08, 474.48, 9.00, 12.99, 9.00, 12.99, 18.00, 25.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3255, '416207210-0500', 'SHCBM20X2.5X210 GR 12.9', 'X', '73181500', 419.85, 20.00, 5.00, 153.250, 63.50, 266.60, 503.82, 9.00, 13.79, 9.00, 13.79, 18.00, 27.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3256, '416207220-0500', 'SHCBM20X2.5X220 GR 12.9', 'X', '73181500', 444.30, 20.00, 5.00, 162.170, 63.50, 282.13, 533.16, 9.00, 14.60, 9.00, 14.60, 18.00, 29.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3257, '416207230-0500', 'SHCBM20X2.5X230 GR 12.9', 'X', '73181500', 546.45, 10.00, 10.00, 199.450, 63.50, 347.00, 655.74, 9.00, 17.95, 9.00, 17.95, 18.00, 35.90, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3258, '416207240-0500', 'SHCBM20X2.5X240 GR 12.9', 'X', '73181500', 710.75, 20.00, 5.00, 259.420, 63.50, 451.33, 852.90, 9.00, 23.35, 9.00, 23.35, 18.00, 46.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3259, '416207250-0500', 'SHCBM20X2.5X250 GR 12.9', 'X', '73181500', 785.30, 20.00, 5.00, 286.630, 63.50, 498.67, 942.36, 9.00, 25.80, 9.00, 25.80, 18.00, 51.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3260, '416207260-0500', 'SHCBM20X2.5X260 GR 12.9', 'X', '73181500', 859.75, 5.00, 5.00, 313.810, 63.50, 545.94, 1031.70, 9.00, 28.24, 9.00, 28.24, 18.00, 56.49, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3261, '416207270-0500', 'SHCBM20X2.5X270 GR 12.9', 'X', '73181500', 894.45, 5.00, 5.00, 326.470, 63.50, 567.98, 1073.34, 9.00, 29.38, 9.00, 29.38, 18.00, 58.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3262, '416207280-0500', 'SHCBM20X2.5X280 GR 12.9', 'X', '73181500', 1018.45, 5.00, 5.00, 371.730, 63.50, 646.72, 1222.14, 9.00, 33.46, 9.00, 33.46, 18.00, 66.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3263, '416207290-0500', 'SHCBM20X2.5X290 GR 12.9', 'X', '73181500', 1004.65, 10.00, 5.00, 366.700, 63.50, 637.95, 1205.58, 9.00, 33.00, 9.00, 33.00, 18.00, 66.01, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3264, '416207300-0500', 'SHCBM20X2.5X300 GR 12.9', 'X', '73181500', 1091.25, 10.00, 10.00, 398.310, 63.50, 692.94, 1309.50, 9.00, 35.85, 9.00, 35.85, 18.00, 71.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3265, '416227070-0500', 'SHCBM22X2.5X70 GR 12.9', 'X', '73181500', 213.05, 30.00, 10.00, 77.760, 63.50, 135.29, 255.66, 9.00, 7.00, 9.00, 7.00, 18.00, 14.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3266, '416227080-0500', 'SHCBM22X2.5X80 GR 12.9', 'X', '73181500', 249.30, 30.00, 10.00, 90.990, 63.50, 158.31, 299.16, 9.00, 8.19, 9.00, 8.19, 18.00, 16.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 30.00, 30.00, 30.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3267, '416227090-0500', 'SHCBM22X2.5X90 GR 12.9', 'X', '73181500', 261.40, 20.00, 5.00, 95.410, 63.50, 165.99, 313.68, 9.00, 8.59, 9.00, 8.59, 18.00, 17.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3268, '416227100-0500', 'SHCBM22X2.5X100 GR 12.9', 'X', '73181500', 275.75, 20.00, 5.00, 100.650, 63.50, 175.10, 330.90, 9.00, 9.06, 9.00, 9.06, 18.00, 18.12, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3269, '416227110-0500', 'SHCBM22X2.5X110 GR 12.9', 'X', '73181500', 299.75, 15.00, 5.00, 109.410, 63.50, 190.34, 359.70, 9.00, 9.85, 9.00, 9.85, 18.00, 19.69, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3270, '416227120-0500', 'SHCBM22X2.5X120 GR 12.9', 'X', '73181500', 323.95, 15.00, 5.00, 118.240, 63.50, 205.71, 388.74, 9.00, 10.64, 9.00, 10.64, 18.00, 21.28, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3271, '416227125-0500', 'SHCBM22X2.5X125 GR 12.9', 'X', '73181500', 425.95, 15.00, 5.00, 155.470, 63.50, 270.48, 511.14, 9.00, 13.99, 9.00, 13.99, 18.00, 27.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3272, '416227130-0500', 'SHCBM22X2.5X130 GR 12.9', 'X', '73181500', 425.95, 15.00, 5.00, 155.470, 63.50, 270.48, 511.14, 9.00, 13.99, 9.00, 13.99, 18.00, 27.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3273, '416227140-0500', 'SHCBM22X2.5X140 GR 12.9', 'X', '73181500', 497.70, 15.00, 5.00, 181.660, 63.50, 316.04, 597.24, 9.00, 16.35, 9.00, 16.35, 18.00, 32.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3274, '416227150-0500', 'SHCBM22X2.5X150 GR 12.9', 'X', '73181500', 663.50, 15.00, 5.00, 242.180, 63.50, 421.32, 796.20, 9.00, 21.80, 9.00, 21.80, 18.00, 43.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3275, '416227160-0500', 'SHCBM22X2.5X160 GR 12.9', 'X', '73181500', 948.95, 20.00, 5.00, 346.370, 63.50, 602.58, 1138.74, 9.00, 31.17, 9.00, 31.17, 18.00, 62.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3276, '416227180-0500', 'SHCBM22X2.5X180 GR 12.9', 'X', '73181500', 1015.20, 15.00, 5.00, 370.550, 63.50, 644.65, 1218.24, 9.00, 33.35, 9.00, 33.35, 18.00, 66.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3277, '416249080-0500', 'SHCBM24X3X80 GR 12.9', 'X', '73181500', 227.55, 20.00, 5.00, 83.060, 63.50, 144.49, 273.06, 9.00, 7.48, 9.00, 7.48, 18.00, 14.95, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3278, '416249090-0500', 'SHCBM24X3X90 GR 12.9', 'X', '73181500', 238.70, 20.00, 5.00, 87.130, 63.50, 151.57, 286.44, 9.00, 7.84, 9.00, 7.84, 18.00, 15.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3279, '416249100-0500', 'SHCBM24X3X100 GR 12.9', 'X', '73181500', 251.75, 20.00, 5.00, 91.890, 63.50, 159.86, 302.10, 9.00, 8.27, 9.00, 8.27, 18.00, 16.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3280, '416249110-0500', 'SHCBM24X3X110 GR 12.9', 'X', '73181500', 273.75, 15.00, 5.00, 99.920, 63.50, 173.83, 328.50, 9.00, 8.99, 9.00, 8.99, 18.00, 17.99, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3281, '416249115-0500', 'SHCBM24X3X115 GR 12.9', 'X', '73181500', 295.90, 15.00, 5.00, 108.000, 63.50, 187.90, 355.08, 9.00, 9.72, 9.00, 9.72, 18.00, 19.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3282, '416249120-0500', 'SHCBM24X3X120 GR 12.9', 'X', '73181500', 295.90, 15.00, 5.00, 108.000, 63.50, 187.90, 355.08, 9.00, 9.72, 9.00, 9.72, 18.00, 19.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3283, '416249125-0500', 'SHCBM24X3X125 GR 12.9', 'X', '73181500', 318.00, 15.00, 5.00, 116.070, 63.50, 201.93, 381.60, 9.00, 10.45, 9.00, 10.45, 18.00, 20.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3284, '416249130-0500', 'SHCBM24X3X130 GR 12.9', 'X', '73181500', 318.00, 15.00, 5.00, 116.070, 63.50, 201.93, 381.60, 9.00, 10.45, 9.00, 10.45, 18.00, 20.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3285, '416249140-0500', 'SHCBM24X3X140 GR 12.9', 'X', '73181500', 340.00, 15.00, 5.00, 124.100, 63.50, 215.90, 408.00, 9.00, 11.17, 9.00, 11.17, 18.00, 22.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3286, '416249150-0500', 'SHCBM24X3X150 GR 12.9', 'X', '73181500', 362.20, 15.00, 5.00, 132.200, 63.50, 230.00, 434.64, 9.00, 11.90, 9.00, 11.90, 18.00, 23.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3287, '416249160-0500', 'SHCBM24X3X160 GR 12.9', 'X', '73181500', 588.00, 20.00, 5.00, 214.620, 63.50, 373.38, 705.60, 9.00, 19.32, 9.00, 19.32, 18.00, 38.63, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3288, '416249170-0500', 'SHCBM24X3X170 GR 12.9', 'X', '73181500', 629.10, 20.00, 5.00, 229.620, 63.50, 399.48, 754.92, 9.00, 20.67, 9.00, 20.67, 18.00, 41.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3289, '416249180-0500', 'SHCBM24X3X180 GR 12.9', 'X', '73181500', 629.10, 20.00, 5.00, 229.620, 63.50, 399.48, 754.92, 9.00, 20.67, 9.00, 20.67, 18.00, 41.33, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3290, '416249190-0500', 'SHCBM24X3X190 GR 12.9', 'X', '73181500', 673.45, 20.00, 5.00, 245.810, 63.50, 427.64, 808.14, 9.00, 22.12, 9.00, 22.12, 18.00, 44.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3291, '416249200-0500', 'SHCBM24X3X200 GR 12.9', 'X', '73181500', 673.45, 10.00, 5.00, 245.810, 63.50, 427.64, 808.14, 9.00, 22.12, 9.00, 22.12, 18.00, 44.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3292, '416249210-0500', 'SHCBM24X3X210 GR 12.9', 'X', '73181500', 663.95, 10.00, 5.00, 242.340, 63.50, 421.61, 796.74, 9.00, 21.81, 9.00, 21.81, 18.00, 43.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3293, '416249220-0500', 'SHCBM24X3X220 GR 12.9', 'X', '73181500', 720.70, 20.00, 5.00, 263.060, 63.50, 457.64, 864.84, 9.00, 23.67, 9.00, 23.67, 18.00, 47.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3294, '416249230-0500', 'SHCBM24X3X230 GR 12.9', 'X', '73181500', 713.65, 10.00, 5.00, 260.480, 63.50, 453.17, 856.38, 9.00, 23.44, 9.00, 23.44, 18.00, 46.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3295, '416249240-0500', 'SHCBM24X3X240 GR 12.9', 'X', '73181500', 777.90, 10.00, 5.00, 283.930, 63.50, 493.97, 933.48, 9.00, 25.55, 9.00, 25.55, 18.00, 51.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3296, '416249250-0500', 'SHCBM24X3X250 GR 12.9', 'X', '73181500', 756.70, 10.00, 5.00, 276.200, 63.50, 480.50, 908.04, 9.00, 24.86, 9.00, 24.86, 18.00, 49.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3297, '416249260-0500', 'SHCBM24X3X260 GR 12.9', 'X', '73181500', 671.45, 5.00, 5.00, 245.080, 63.50, 426.37, 805.74, 9.00, 22.06, 9.00, 22.06, 18.00, 44.11, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00');
INSERT INTO `item_mst` (`id`, `partno`, `description_one`, `description_two`, `hsn_code`, `list`, `moq`, `boxqty`, `cost`, `disc_per`, `disc_amt`, `mrp`, `sgst_per`, `sgst_amt`, `cgst_per`, `cgst_amt`, `igst_per`, `igst_amt`, `op_stk`, `stk_qty`, `stk_val`, `unit`, `ly_sales`, `cy_sales`, `pending`, `dispatch1`, `min_qty`, `max_qty`, `reord_qty`, `segment`, `remarks`, `rec_qty`, `bal_qty`) VALUES
(3298, '416249270-0500', 'SHCBM24X3X270 GR 12.9', 'X', '73181500', 829.50, 5.00, 5.00, 302.770, 63.50, 526.73, 995.40, 9.00, 27.25, 9.00, 27.25, 18.00, 54.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3299, '416249280-0500', 'SHCBM24X3X280 GR 12.9', 'X', '73181500', 853.10, 5.00, 5.00, 311.380, 63.50, 541.72, 1023.72, 9.00, 28.02, 9.00, 28.02, 18.00, 56.05, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3300, '416249290-0500', 'SHCBM24X3X290 GR 12.9', 'X', '73181500', 842.90, 5.00, 5.00, 307.660, 63.50, 535.24, 1011.48, 9.00, 27.69, 9.00, 27.69, 18.00, 55.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3301, '416249300-0500', 'SHCBM24X3X300 GR 12.9', 'X', '73181500', 917.00, 5.00, 5.00, 334.710, 63.50, 582.30, 1100.40, 9.00, 30.12, 9.00, 30.12, 18.00, 60.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3302, '416279100-0500', 'SHCBM27X3X100 GR 12.9', 'X', '73181500', 453.75, 15.00, 5.00, 165.620, 63.50, 288.13, 544.50, 9.00, 14.91, 9.00, 14.91, 18.00, 29.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3303, '416279110-0500', 'SHCBM27X3X110 GR 12.9', 'X', '73181500', 481.10, 15.00, 5.00, 175.600, 63.50, 305.50, 577.32, 9.00, 15.80, 9.00, 15.80, 18.00, 31.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 15.00, 15.00, 15.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3304, '416279120-0500', 'SHCBM27X3X120 GR 12.9', 'X', '73181500', 510.50, 20.00, 5.00, 186.330, 63.50, 324.17, 612.60, 9.00, 16.77, 9.00, 16.77, 18.00, 33.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3305, '416279130-0500', 'SHCBM27X3X130 GR 12.9', 'X', '73181500', 515.40, 10.00, 5.00, 188.120, 63.50, 327.28, 618.48, 9.00, 16.93, 9.00, 16.93, 18.00, 33.86, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3306, '416279140-0500', 'SHCBM27X3X140 GR 12.9', 'X', '73181500', 567.20, 20.00, 5.00, 207.030, 63.50, 360.17, 680.64, 9.00, 18.63, 9.00, 18.63, 18.00, 37.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3307, '416279150-0500', 'SHCBM27X3X150 GR 12.9', 'X', '73181500', 602.90, 10.00, 5.00, 220.060, 63.50, 382.84, 723.48, 9.00, 19.81, 9.00, 19.81, 18.00, 39.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3308, '416279160-0500', 'SHCBM27X3X160 GR 12.9', 'X', '73181500', 949.50, 10.00, 10.00, 346.570, 63.50, 602.93, 1139.40, 9.00, 31.19, 9.00, 31.19, 18.00, 62.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3309, '416279180-0500', 'SHCBM27X3X180 GR 12.9', 'X', '73181500', 1050.25, 10.00, 10.00, 383.340, 63.50, 666.91, 1260.30, 9.00, 34.50, 9.00, 34.50, 18.00, 69.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3310, '416279200-0500', 'SHCBM27X3X200 GR 12.9', 'X', '73181500', 1142.65, 5.00, 5.00, 417.070, 63.50, 725.58, 1371.18, 9.00, 37.54, 9.00, 37.54, 18.00, 75.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3311, '416279210-0500', 'SHCBM27X3X210 GR 12.9', 'X', '73181500', 1424.10, 5.00, 5.00, 519.800, 63.50, 904.30, 1708.92, 9.00, 46.78, 9.00, 46.78, 18.00, 93.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3312, '416279220-0500', 'SHCBM27X3X220 GR 12.9', 'X', '73181500', 1424.10, 5.00, 5.00, 519.800, 63.50, 904.30, 1708.92, 9.00, 46.78, 9.00, 46.78, 18.00, 93.56, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3313, '416279240-0500', 'SHCBM27X3X240 GR 12.9', 'X', '73181500', 1577.40, 2.00, 2.00, 575.750, 63.50, 1001.65, 1892.88, 9.00, 51.82, 9.00, 51.82, 18.00, 103.64, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3314, '416279260-0500', 'SHCBM27X3X260 GR 12.9', 'X', '73181500', 1718.20, 2.00, 2.00, 627.140, 63.50, 1091.06, 2061.84, 9.00, 56.44, 9.00, 56.44, 18.00, 112.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3315, '416279280-0500', 'SHCBM27X3X280 GR 12.9', 'X', '73181500', 1833.65, 2.00, 2.00, 669.280, 63.50, 1164.37, 2200.38, 9.00, 60.24, 9.00, 60.24, 18.00, 120.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3316, '416279300-0500', 'SHCBM27X3X300 GR 12.9', 'X', '73181500', 1949.10, 2.00, 2.00, 711.420, 63.50, 1237.68, 2338.92, 9.00, 64.03, 9.00, 64.03, 18.00, 128.06, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3317, '416307090-0500', 'SHCBM30X3.5X90 GR 12.9', 'X', '73181500', 424.40, 20.00, 5.00, 154.910, 63.50, 269.49, 509.28, 9.00, 13.94, 9.00, 13.94, 18.00, 27.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3318, '416307100-0500', 'SHCBM30X3.5X100 GR 12.9', 'X', '73181500', 453.75, 20.00, 5.00, 165.620, 63.50, 288.13, 544.50, 9.00, 14.91, 9.00, 14.91, 18.00, 29.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3319, '416307110-0500', 'SHCBM30X3.5X110 GR 12.9', 'X', '73181500', 481.10, 20.00, 5.00, 175.600, 63.50, 305.50, 577.32, 9.00, 15.80, 9.00, 15.80, 18.00, 31.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3320, '416307120-0500', 'SHCBM30X3.5X120 GR 12.9', 'X', '73181500', 510.50, 10.00, 5.00, 186.330, 63.50, 324.17, 612.60, 9.00, 16.77, 9.00, 16.77, 18.00, 33.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3321, '416307130-0500', 'SHCBM30X3.5X130 GR 12.9', 'X', '73181500', 546.20, 10.00, 5.00, 199.360, 63.50, 346.84, 655.44, 9.00, 17.94, 9.00, 17.94, 18.00, 35.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 10.00, 10.00, 10.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3322, '416307140-0500', 'SHCBM30X3.5X140 GR 12.9', 'X', '73181500', 567.20, 20.00, 5.00, 207.030, 63.50, 360.17, 680.64, 9.00, 18.63, 9.00, 18.63, 18.00, 37.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 20.00, 20.00, 20.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3323, '416307150-0500', 'SHCBM30X3.5X150 GR 12.9', 'X', '73181500', 602.90, 5.00, 5.00, 220.060, 63.50, 382.84, 723.48, 9.00, 19.81, 9.00, 19.81, 18.00, 39.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3324, '416307160-0500', 'SHCBM30X3.5X160 GR 12.9', 'X', '73181500', 949.50, 5.00, 5.00, 346.570, 63.50, 602.93, 1139.40, 9.00, 31.19, 9.00, 31.19, 18.00, 62.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3325, '416307170-0500', 'SHCBM30X3.5X170 GR 12.9', 'X', '73181500', 1050.25, 5.00, 5.00, 383.340, 63.50, 666.91, 1260.30, 9.00, 34.50, 9.00, 34.50, 18.00, 69.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3326, '416307180-0500', 'SHCBM30X3.5X180 GR 12.9', 'X', '73181500', 1050.25, 5.00, 5.00, 383.340, 63.50, 666.91, 1260.30, 9.00, 34.50, 9.00, 34.50, 18.00, 69.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3327, '416307190-0500', 'SHCBM30X3.5X190 GR 12.9', 'X', '73181500', 1142.65, 5.00, 5.00, 417.070, 63.50, 725.58, 1371.18, 9.00, 37.54, 9.00, 37.54, 18.00, 75.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3328, '416307200-0500', 'SHCBM30X3.5X200 GR 12.9', 'X', '73181500', 1142.65, 5.00, 5.00, 417.070, 63.50, 725.58, 1371.18, 9.00, 37.54, 9.00, 37.54, 18.00, 75.07, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3329, '416307210-0500', 'SHCBM30X3.5X210 GR 12.9', 'X', '73181500', 1417.80, 5.00, 5.00, 517.500, 63.50, 900.30, 1701.36, 9.00, 46.57, 9.00, 46.57, 18.00, 93.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3330, '416307220-0500', 'SHCBM30X3.5X220 GR 12.9', 'X', '73181500', 1417.80, 5.00, 5.00, 517.500, 63.50, 900.30, 1701.36, 9.00, 46.57, 9.00, 46.57, 18.00, 93.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3331, '416307230-0500', 'SHCBM30X3.5X230 GR 12.9', 'X', '73181500', 1524.95, 5.00, 5.00, 556.610, 63.50, 968.34, 1829.94, 9.00, 50.09, 9.00, 50.09, 18.00, 100.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3332, '416307240-0500', 'SHCBM30X3.5X240 GR 12.9', 'X', '73181500', 1524.95, 5.00, 5.00, 556.610, 63.50, 968.34, 1829.94, 9.00, 50.09, 9.00, 50.09, 18.00, 100.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3333, '416307250-0500', 'SHCBM30X3.5X250 GR 12.9', 'X', '73181500', 1632.05, 5.00, 5.00, 595.700, 63.50, 1036.35, 1958.46, 9.00, 53.61, 9.00, 53.61, 18.00, 107.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3334, '416307260-0500', 'SHCBM30X3.5X260 GR 12.9', 'X', '73181500', 1632.05, 5.00, 5.00, 595.700, 63.50, 1036.35, 1958.46, 9.00, 53.61, 9.00, 53.61, 18.00, 107.23, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3335, '416307280-0500', 'SHCBM30X3.5X280 GR 12.9', 'X', '73181500', 1739.15, 5.00, 5.00, 634.790, 63.50, 1104.36, 2086.98, 9.00, 57.13, 9.00, 57.13, 18.00, 114.26, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3336, '416307290-0500', 'SHCBM30X3.5X290 GR 12.9', 'X', '73181500', 1846.25, 5.00, 5.00, 673.880, 63.50, 1172.37, 2215.50, 9.00, 60.65, 9.00, 60.65, 18.00, 121.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3337, '416307300-0500', 'SHCBM30X3.5X300 GR 12.9', 'X', '73181500', 1846.25, 2.00, 2.00, 673.880, 63.50, 1172.37, 2215.50, 9.00, 60.65, 9.00, 60.65, 18.00, 121.30, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3338, '416337100-0500', 'SHCBM33X3.5X100 GR 12.9', 'X', '73181500', 659.65, 8.00, 2.00, 240.770, 63.50, 418.88, 791.58, 9.00, 21.67, 9.00, 21.67, 18.00, 43.34, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3339, '416337110-0500', 'SHCBM33X3.5X110 GR 12.9', 'X', '73181500', 695.35, 8.00, 2.00, 253.800, 63.50, 441.55, 834.42, 9.00, 22.84, 9.00, 22.84, 18.00, 45.68, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3340, '416337120-0500', 'SHCBM33X3.5X120 GR 12.9', 'X', '73181500', 758.30, 8.00, 2.00, 276.780, 63.50, 481.52, 909.96, 9.00, 24.91, 9.00, 24.91, 18.00, 49.82, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3341, '416337150-0500', 'SHCBM33X3.5X150 GR 12.9', 'X', '73181500', 844.15, 8.00, 2.00, 308.110, 63.50, 536.04, 1012.98, 9.00, 27.73, 9.00, 27.73, 18.00, 55.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3342, '416337160-0500', 'SHCBM33X3.5X160 GR 12.9', 'X', '73181500', 1178.35, 8.00, 2.00, 430.100, 63.50, 748.25, 1414.02, 9.00, 38.71, 9.00, 38.71, 18.00, 77.42, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 8.00, 8.00, 8.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3343, '416337180-0500', 'SHCBM33X3.5X180 GR 12.9', 'X', '73181500', 1304.40, 5.00, 5.00, 476.110, 63.50, 828.29, 1565.28, 9.00, 42.85, 9.00, 42.85, 18.00, 85.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3344, '416337200-0500', 'SHCBM33X3.5X200 GR 12.9', 'X', '73181500', 1417.80, 2.00, 2.00, 517.500, 63.50, 900.30, 1701.36, 9.00, 46.57, 9.00, 46.57, 18.00, 93.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3345, '416337220-0500', 'SHCBM33X3.5X220 GR 12.9', 'X', '73181500', 1758.05, 5.00, 5.00, 641.690, 63.50, 1116.36, 2109.66, 9.00, 57.75, 9.00, 57.75, 18.00, 115.50, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3346, '416337240-0500', 'SHCBM33X3.5X240 GR 12.9', 'X', '73181500', 1894.55, 2.00, 2.00, 691.510, 63.50, 1203.04, 2273.46, 9.00, 62.24, 9.00, 62.24, 18.00, 124.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3347, '416369110-0500', 'SHCBM36X4X110 GR 12.9', 'X', '73181500', 823.45, 6.00, 2.00, 300.560, 63.50, 522.89, 988.14, 9.00, 27.05, 9.00, 27.05, 18.00, 54.10, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3348, '416369120-0500', 'SHCBM36X4X120 GR 12.9', 'X', '73181500', 857.10, 6.00, 6.00, 312.840, 63.50, 544.26, 1028.52, 9.00, 28.16, 9.00, 28.16, 18.00, 56.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3349, '416369130-0500', 'SHCBM36X4X130 GR 12.9', 'X', '73181500', 886.40, 6.00, 2.00, 323.540, 63.50, 562.86, 1063.68, 9.00, 29.12, 9.00, 29.12, 18.00, 58.24, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3350, '416369140-0500', 'SHCBM36X4X140 GR 12.9', 'X', '73181500', 978.80, 6.00, 2.00, 357.260, 63.50, 621.54, 1174.56, 9.00, 32.15, 9.00, 32.15, 18.00, 64.31, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 6.00, 6.00, 6.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3351, '416369150-0500', 'SHCBM36X4X150 GR 12.9', 'X', '73181500', 1014.60, 5.00, 5.00, 370.330, 63.50, 644.27, 1217.52, 9.00, 33.33, 9.00, 33.33, 18.00, 66.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3352, '416369160-0500', 'SHCBM36X4X160 GR 12.9', 'X', '73181500', 1369.50, 5.00, 5.00, 499.870, 63.50, 869.63, 1643.40, 9.00, 44.99, 9.00, 44.99, 18.00, 89.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 5.00, 5.00, 5.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3353, '416369180-0500', 'SHCBM36X4X180 GR 12.9', 'X', '73181500', 1524.95, 2.00, 2.00, 556.610, 63.50, 968.34, 1829.94, 9.00, 50.09, 9.00, 50.09, 18.00, 100.19, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3354, '416369200-0500', 'SHCBM36X4X200 GR 12.9', 'X', '73181500', 1653.05, 2.00, 2.00, 603.360, 63.50, 1049.69, 1983.66, 9.00, 54.30, 9.00, 54.30, 18.00, 108.61, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3355, '416369220-0500', 'SHCBM36X4X220 GR 12.9', 'X', '73181500', 2043.70, 2.00, 2.00, 745.950, 63.50, 1297.75, 2452.44, 9.00, 67.14, 9.00, 67.14, 18.00, 134.27, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3356, '416369240-0500', 'SHCBM36X4X240 GR 12.9', 'X', '73181500', 2100.40, 2.00, 2.00, 766.650, 63.50, 1333.75, 2520.48, 9.00, 69.00, 9.00, 69.00, 18.00, 138.00, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3357, '416369250-0500', 'SHCBM36X4X250 GR 12.9', 'X', '73181500', 2249.55, 2.00, 2.00, 821.090, 63.50, 1428.46, 2699.46, 9.00, 73.90, 9.00, 73.90, 18.00, 147.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3358, '416369260-0500', 'SHCBM36X4X260 GR 12.9', 'X', '73181500', 2249.55, 2.00, 2.00, 821.090, 63.50, 1428.46, 2699.46, 9.00, 73.90, 9.00, 73.90, 18.00, 147.80, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3359, '416369280-0500', 'SHCBM36X4X280 GR 12.9', 'X', '73181500', 2398.60, 2.00, 2.00, 875.490, 63.50, 1523.11, 2878.32, 9.00, 78.79, 9.00, 78.79, 18.00, 157.59, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3360, '416369300-0500', 'SHCBM36X4X300 GR 12.9', 'X', '73181500', 2547.70, 2.00, 2.00, 929.910, 63.50, 1617.79, 3057.24, 9.00, 83.69, 9.00, 83.69, 18.00, 167.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2.00, 2.00, 2.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3361, '426061104-0500', 'SHCB3/16BSWX1-1/4', 'X', '73181500', 8.25, 2400.00, 200.00, 3.010, 63.50, 5.24, 9.90, 9.00, 0.27, 9.00, 0.27, 18.00, 0.54, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3362, '426061108-0500', 'SHCB3/16BSWX1-1/2', 'X', '73181500', 9.45, 2400.00, 200.00, 3.450, 63.50, 6.00, 11.34, 9.00, 0.31, 9.00, 0.31, 18.00, 0.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 2400.00, 2400.00, 2400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3363, '426061112-0500', 'SHCB3/16BSWX1-3/4', 'X', '73181500', 11.30, 600.00, 200.00, 4.120, 63.50, 7.18, 13.56, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3364, '426062104-0500', 'SHCB3/16BSFX1-1/4', 'X', '73181500', 10.15, 800.00, 200.00, 3.700, 63.50, 6.45, 12.18, 9.00, 0.33, 9.00, 0.33, 18.00, 0.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3365, '426062108-0500', 'SHCB3/16BSFX1-1/2', 'X', '73181500', 11.65, 800.00, 200.00, 4.250, 63.50, 7.40, 13.98, 9.00, 0.38, 9.00, 0.38, 18.00, 0.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3366, '426062112-0500', 'SHCB3/16BSFX1-3/4', 'X', '73181500', 13.90, 800.00, 200.00, 5.070, 63.50, 8.83, 16.68, 9.00, 0.46, 9.00, 0.46, 18.00, 0.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3367, '426081108-0500', 'SHCB1/4BSWX1-1/2', 'X', '73181500', 9.10, 800.00, 200.00, 3.320, 63.50, 5.78, 10.92, 9.00, 0.30, 9.00, 0.30, 18.00, 0.60, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3368, '426081112-0500', 'SHCB1/4BSWX1-3/4', 'X', '73181500', 11.20, 800.00, 200.00, 4.090, 63.50, 7.11, 13.44, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3369, '426081200-0500', 'SHCB1/4BSWX2', 'X', '73181500', 11.20, 600.00, 200.00, 4.090, 63.50, 7.11, 13.44, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3370, '426081204-0500', 'SHCB1/4BSWX2-1/4', 'X', '73181500', 22.40, 800.00, 200.00, 8.180, 63.50, 14.22, 26.88, 9.00, 0.74, 9.00, 0.74, 18.00, 1.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3371, '426081208-0500', 'SHCB1/4BSWX2-1/2', 'X', '73181500', 22.40, 400.00, 200.00, 8.180, 63.50, 14.22, 26.88, 9.00, 0.74, 9.00, 0.74, 18.00, 1.47, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3372, '426081212-0500', 'SHCB1/4BSWX2-3/4', 'X', '73181500', 24.10, 600.00, 200.00, 8.800, 63.50, 15.30, 28.92, 9.00, 0.79, 9.00, 0.79, 18.00, 1.58, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3373, '426081300-0500', 'SHCB1/4BSWX3', 'X', '73181500', 25.95, 800.00, 200.00, 9.470, 63.50, 16.48, 31.14, 9.00, 0.85, 9.00, 0.85, 18.00, 1.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3374, '426081304-0500', 'SHCB1/4BSWX3-1/4', 'X', '73181500', 31.05, 800.00, 200.00, 11.330, 63.50, 19.72, 37.26, 9.00, 1.02, 9.00, 1.02, 18.00, 2.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3375, '426081308-0500', 'SHCB1/4BSWX3-1/2', 'X', '73181500', 31.05, 800.00, 200.00, 11.330, 63.50, 19.72, 37.26, 9.00, 1.02, 9.00, 1.02, 18.00, 2.04, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3376, '426081400-0500', 'SHCB1/4BSWX4', 'X', '73181500', 34.20, 800.00, 200.00, 12.480, 63.50, 21.72, 41.04, 9.00, 1.12, 9.00, 1.12, 18.00, 2.25, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3377, '426082108-0500', 'SHCB1/4BSFX1-1/2', 'X', '73181500', 11.20, 800.00, 200.00, 4.090, 63.50, 7.11, 13.44, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3378, '426082112-0500', 'SHCB1/4BSFX1-3/4', 'X', '73181500', 13.85, 800.00, 200.00, 5.060, 63.50, 8.79, 16.62, 9.00, 0.45, 9.00, 0.45, 18.00, 0.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3379, '426082200-0500', 'SHCB1/4BSFX2', 'X', '73181500', 13.85, 600.00, 200.00, 5.060, 63.50, 8.79, 16.62, 9.00, 0.45, 9.00, 0.45, 18.00, 0.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3380, '426082204-0500', 'SHCB1/4BSFX2-1/4', 'X', '73181500', 27.50, 600.00, 200.00, 10.040, 63.50, 17.46, 33.00, 9.00, 0.90, 9.00, 0.90, 18.00, 1.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3381, '426082208-0500', 'SHCB1/4BSFX2-1/2', 'X', '73181500', 27.50, 600.00, 200.00, 10.040, 63.50, 17.46, 33.00, 9.00, 0.90, 9.00, 0.90, 18.00, 1.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3382, '426082300-0500', 'SHCB1/4BSFX3', 'X', '73181500', 31.85, 600.00, 200.00, 11.630, 63.50, 20.22, 38.22, 9.00, 1.05, 9.00, 1.05, 18.00, 2.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3383, '426082304-0500', 'SHCB1/4BSFX3-1/4', 'X', '73181500', 38.25, 600.00, 200.00, 13.960, 63.50, 24.29, 45.90, 9.00, 1.26, 9.00, 1.26, 18.00, 2.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3384, '426082308-0500', 'SHCB1/4BSFX3-1/2', 'X', '73181500', 38.25, 600.00, 200.00, 13.960, 63.50, 24.29, 45.90, 9.00, 1.26, 9.00, 1.26, 18.00, 2.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3385, '426082400-0500', 'SHCB1/4BSFX4', 'X', '73181500', 42.00, 600.00, 200.00, 15.330, 63.50, 26.67, 50.40, 9.00, 1.38, 9.00, 1.38, 18.00, 2.76, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3386, '426084108-0500', 'SHCB1/4UNCX1-1/2', 'X', '73181500', 11.00, 800.00, 200.00, 4.020, 63.50, 6.99, 13.20, 9.00, 0.36, 9.00, 0.36, 18.00, 0.72, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3387, '426084112-0500', 'SHCB1/4UNCX1-3/4', 'X', '73181500', 13.60, 800.00, 200.00, 4.960, 63.50, 8.64, 16.32, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3388, '426084200-0500', 'SHCB1/4UNCX2', 'X', '73181500', 13.60, 600.00, 200.00, 4.960, 63.50, 8.64, 16.32, 9.00, 0.45, 9.00, 0.45, 18.00, 0.89, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3389, '426084208-0500', 'SHCB1/4UNCX2-1/2', 'X', '73181500', 26.95, 600.00, 200.00, 9.840, 63.50, 17.11, 32.34, 9.00, 0.89, 9.00, 0.89, 18.00, 1.77, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3390, '426084308-0500', 'SHCB1/4UNCX3-1/2', 'X', '73181500', 37.50, 800.00, 200.00, 13.690, 63.50, 23.81, 45.00, 9.00, 1.23, 9.00, 1.23, 18.00, 2.46, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3391, '426084400-0500', 'SHCB1/4UNCX4', 'X', '73181500', 41.15, 600.00, 200.00, 15.020, 63.50, 26.13, 49.38, 9.00, 1.35, 9.00, 1.35, 18.00, 2.70, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3392, '426085108-0500', 'SHCB1/4UNFX1-1/2', 'X', '73181500', 11.20, 800.00, 200.00, 4.090, 63.50, 7.11, 13.44, 9.00, 0.37, 9.00, 0.37, 18.00, 0.74, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3393, '426085112-0500', 'SHCB1/4UNFX1-3/4', 'X', '73181500', 13.85, 600.00, 200.00, 5.060, 63.50, 8.79, 16.62, 9.00, 0.45, 9.00, 0.45, 18.00, 0.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3394, '426085200-0500', 'SHCB1/4UNFX2', 'X', '73181500', 13.85, 600.00, 200.00, 5.060, 63.50, 8.79, 16.62, 9.00, 0.45, 9.00, 0.45, 18.00, 0.91, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3395, '426085208-0500', 'SHCB1/4UNFX2-1/2', 'X', '73181500', 27.50, 600.00, 200.00, 10.040, 63.50, 17.46, 33.00, 9.00, 0.90, 9.00, 0.90, 18.00, 1.81, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3396, '426085300-0500', 'SHCB1/4UNFX3', 'X', '73181500', 31.85, 600.00, 200.00, 11.630, 63.50, 20.22, 38.22, 9.00, 1.05, 9.00, 1.05, 18.00, 2.09, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3397, '426085304-0500', 'SHCB1/4UNFX3-1/4', 'X', '73181500', 38.25, 600.00, 200.00, 13.960, 63.50, 24.29, 45.90, 9.00, 1.26, 9.00, 1.26, 18.00, 2.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3398, '426085308-0500', 'SHCB1/4UNFX3-1/2', 'X', '73181500', 38.25, 600.00, 200.00, 13.960, 63.50, 24.29, 45.90, 9.00, 1.26, 9.00, 1.26, 18.00, 2.51, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3399, '426101112-0500', 'SHCB5/16BSWX1-3/4', 'X', '73181500', 12.10, 400.00, 200.00, 4.420, 63.50, 7.68, 14.52, 9.00, 0.40, 9.00, 0.40, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3400, '426101200-0500', 'SHCB5/16BSWX2', 'X', '73181500', 12.10, 800.00, 200.00, 4.420, 63.50, 7.68, 14.52, 9.00, 0.40, 9.00, 0.40, 18.00, 0.79, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3401, '426101204-0500', 'SHCB5/16BSWX2-1/4', 'X', '73181500', 14.55, 800.00, 200.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3402, '426101208-0500', 'SHCB5/16BSWX2-1/2', 'X', '73181500', 14.55, 300.00, 100.00, 5.310, 63.50, 9.24, 17.46, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3403, '426101212-0500', 'SHCB5/16BSWX2-3/4', 'X', '73181500', 17.30, 400.00, 100.00, 6.310, 63.50, 10.99, 20.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3404, '426101300-0500', 'SHCB5/16BSWX3', 'X', '73181500', 17.30, 200.00, 100.00, 6.310, 63.50, 10.99, 20.76, 9.00, 0.57, 9.00, 0.57, 18.00, 1.14, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3405, '426101304-0500', 'SHCB5/16BSWX3-1/4', 'X', '73181500', 30.15, 300.00, 100.00, 11.000, 63.50, 19.15, 36.18, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3406, '426101308-0500', 'SHCB5/16BSWX3-1/2', 'X', '73181500', 30.15, 400.00, 100.00, 11.000, 63.50, 19.15, 36.18, 9.00, 0.99, 9.00, 0.99, 18.00, 1.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3407, '426101400-0500', 'SHCB5/16BSWX4', 'X', '73181500', 35.70, 400.00, 100.00, 13.030, 63.50, 22.67, 42.84, 9.00, 1.17, 9.00, 1.17, 18.00, 2.35, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3408, '426101408-0500', 'SHCB5/16BSWX4-1/2', 'X', '73181500', 55.85, 200.00, 50.00, 20.390, 63.50, 35.46, 67.02, 9.00, 1.83, 9.00, 1.83, 18.00, 3.67, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3409, '426101500-0500', 'SHCB5/16BSWX5', 'X', '73181500', 69.60, 200.00, 50.00, 25.400, 63.50, 44.20, 83.52, 9.00, 2.29, 9.00, 2.29, 18.00, 4.57, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3410, '426101508-0500', 'SHCB5/16BSWX5-1/2', 'X', '73181500', 86.10, 150.00, 50.00, 31.430, 63.50, 54.67, 103.32, 9.00, 2.83, 9.00, 2.83, 18.00, 5.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3411, '426101600-0500', 'SHCB5/16BSWX6', 'X', '73181500', 86.10, 200.00, 50.00, 31.430, 63.50, 54.67, 103.32, 9.00, 2.83, 9.00, 2.83, 18.00, 5.66, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 200.00, 200.00, 200.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3412, '426102200-0500', 'SHCB5/16BSFX2', 'X', '73181500', 14.95, 800.00, 200.00, 5.460, 63.50, 9.49, 17.94, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3413, '426102204-0500', 'SHCB5/16BSFX2-1/4', 'X', '73181500', 17.85, 800.00, 200.00, 6.520, 63.50, 11.33, 21.42, 9.00, 0.59, 9.00, 0.59, 18.00, 1.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3414, '426102208-0500', 'SHCB5/16BSFX2-1/2', 'X', '73181500', 17.85, 400.00, 100.00, 6.520, 63.50, 11.33, 21.42, 9.00, 0.59, 9.00, 0.59, 18.00, 1.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3415, '426102300-0500', 'SHCB5/16BSFX3', 'X', '73181500', 21.30, 400.00, 100.00, 7.770, 63.50, 13.53, 25.56, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3416, '426102308-0500', 'SHCB5/16BSFX3-1/2', 'X', '73181500', 37.10, 400.00, 100.00, 13.540, 63.50, 23.56, 44.52, 9.00, 1.22, 9.00, 1.22, 18.00, 2.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3417, '426102400-0500', 'SHCB5/16BSFX4', 'X', '73181500', 43.90, 400.00, 100.00, 16.020, 63.50, 27.88, 52.68, 9.00, 1.44, 9.00, 1.44, 18.00, 2.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3418, '426102408-0500', 'SHCB5/16BSFX4-1/2', 'X', '73181500', 68.75, 150.00, 50.00, 25.090, 63.50, 43.66, 82.50, 9.00, 2.26, 9.00, 2.26, 18.00, 4.52, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3419, '426102500-0500', 'SHCB5/16BSFX5', 'X', '73181500', 85.55, 150.00, 50.00, 31.230, 63.50, 54.32, 102.66, 9.00, 2.81, 9.00, 2.81, 18.00, 5.62, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 150.00, 150.00, 150.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3420, '426104112-0500', 'SHCB5/16UNCX1-3/4', 'X', '73181500', 14.65, 600.00, 200.00, 5.350, 63.50, 9.30, 17.58, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3421, '426104200-0500', 'SHCB5/16UNCX2', 'X', '73181500', 14.65, 800.00, 200.00, 5.350, 63.50, 9.30, 17.58, 9.00, 0.48, 9.00, 0.48, 18.00, 0.96, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 800.00, 800.00, 800.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3422, '426104204-0500', 'SHCB5/16UNCX2-1/4', 'X', '73181500', 17.55, 600.00, 200.00, 6.410, 63.50, 11.14, 21.06, 9.00, 0.58, 9.00, 0.58, 18.00, 1.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3423, '426104208-0500', 'SHCB5/16UNCX2-1/2', 'X', '73181500', 17.55, 300.00, 100.00, 6.410, 63.50, 11.14, 21.06, 9.00, 0.58, 9.00, 0.58, 18.00, 1.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3424, '426104212-0500', 'SHCB5/16UNCX2-3/4', 'X', '73181500', 20.85, 300.00, 100.00, 7.610, 63.50, 13.24, 25.02, 9.00, 0.68, 9.00, 0.68, 18.00, 1.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3425, '426104300-0500', 'SHCB5/16UNCX3', 'X', '73181500', 20.85, 300.00, 100.00, 7.610, 63.50, 13.24, 25.02, 9.00, 0.68, 9.00, 0.68, 18.00, 1.37, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3426, '426104400-0500', 'SHCB5/16UNCX4', 'X', '73181500', 43.15, 300.00, 100.00, 15.750, 63.50, 27.40, 51.78, 9.00, 1.42, 9.00, 1.42, 18.00, 2.83, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3427, '426105200-0500', 'SHCB5/16UNFX2', 'X', '73181500', 14.95, 600.00, 200.00, 5.460, 63.50, 9.49, 17.94, 9.00, 0.49, 9.00, 0.49, 18.00, 0.98, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3428, '426105204-0500', 'SHCB5/16UNFX2-1/4', 'X', '73181500', 17.85, 600.00, 200.00, 6.520, 63.50, 11.33, 21.42, 9.00, 0.59, 9.00, 0.59, 18.00, 1.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 600.00, 600.00, 600.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3429, '426105208-0500', 'SHCB5/16UNFX2-1/2', 'X', '73181500', 17.85, 300.00, 100.00, 6.520, 63.50, 11.33, 21.42, 9.00, 0.59, 9.00, 0.59, 18.00, 1.17, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3430, '426105300-0500', 'SHCB5/16UNFX3', 'X', '73181500', 21.30, 300.00, 100.00, 7.770, 63.50, 13.53, 25.56, 9.00, 0.70, 9.00, 0.70, 18.00, 1.40, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3431, '426105304-0500', 'SHCB5/16UNFX3-1/4', 'X', '73181500', 37.10, 300.00, 100.00, 13.540, 63.50, 23.56, 44.52, 9.00, 1.22, 9.00, 1.22, 18.00, 2.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3432, '426105308-0500', 'SHCB5/16UNFX3-1/2', 'X', '73181500', 37.10, 300.00, 100.00, 13.540, 63.50, 23.56, 44.52, 9.00, 1.22, 9.00, 1.22, 18.00, 2.44, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3433, '426105400-0500', 'SHCB5/16UNFX4', 'X', '73181500', 43.90, 400.00, 100.00, 16.020, 63.50, 27.88, 52.68, 9.00, 1.44, 9.00, 1.44, 18.00, 2.88, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3434, '426121112-0500', 'SHCB3/8BSWX1-3/4', 'X', '73181500', 17.55, 300.00, 100.00, 6.410, 63.50, 11.14, 21.06, 9.00, 0.58, 9.00, 0.58, 18.00, 1.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 300.00, 300.00, 300.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3435, '426121200-0500', 'SHCB3/8BSWX2', 'X', '73181500', 17.55, 400.00, 100.00, 6.410, 63.50, 11.14, 21.06, 9.00, 0.58, 9.00, 0.58, 18.00, 1.15, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3436, '426121204-0500', 'SHCB3/8BSWX2-1/4', 'X', '73181500', 21.05, 400.00, 100.00, 7.680, 63.50, 13.37, 25.26, 9.00, 0.69, 9.00, 0.69, 18.00, 1.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.00, 400.00, 'TVS-SOCKET', 'X', 0.00, '0.00'),
(3437, '426121208-0500', 'SHCB3/8BSWX2-1/2', 'X', '73181500', 21.05, 400.00, 100.00, 7.680, 63.50, 13.37, 25.26, 9.00, 0.69, 9.00, 0.69, 18.00, 1.38, 0.00, 0.00, 0.00, 'PCS', 0.00, 0.00, 0.00, 0.00, 400.00, 400.