<?php
/*call the FPDF library*/
require('pdf/fpdf.php');
require('../config/dbcon.php');
//$pdf = new FPDF('P','mm','A4');
$pdf = new FPDF('P','mm',array(360,255));
$pdf->SetAutoPageBreak(false, 0);
$pdf->AddPage();

$pdf->SetFont('helvetica','',10);
//HORIZONTAL LINE STARTS -------------------------------------------------------
$pdf -> Line(10, 10, 247, 10);   // 1ST HORIZONTAL LINE LEFT TO RIGHT
$pdf -> Line(10, 40, 247, 40);   // 2ND HORIZONTAL LINE LEFT TO RIGHT
$pdf -> Line(10, 46, 247, 46);   // 3RD HORIZONTAL LINE LEFT TO RIGHT
$pdf -> Line(10, 80, 247, 80);   // 4TH HORIZONTAL LINE LEFT TO RIGHT
$pdf -> Line(10, 270, 247, 270); // 5TH HORIZONTAL LINE LEFT TO RIGHT
$pdf -> Line(10, 277, 247, 277); // 6TH HORIZONTAL LINE LEFT TO RIGHT
$pdf -> Line(10, 350, 247, 350); // 7TH AND LAST HORIZONTAL LINE LEFT TO RIGHT
$pdf -> Line(134, 54, 247, 54); //AFTER INVOICE NUMBER
//HORIZONTAL LINE ENDS ---------------------------------------------------------

//VERTICAL LINE STARTS |||||||||||||||||||||||||||||||||||||||||||||||||||||||||
$pdf -> Line(10, 10, 10, 350);       // 1ST VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(19.98, 270, 19.98, 90); // 2ND VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(46, 270, 46, 90);       // 3RD VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(106, 270, 106, 90);     // 4TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(120, 270, 120, 90);     // 5TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(134, 270, 134, 80);     // 6TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(149, 270, 149, 90);     // 7TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(161, 270, 161, 90);     // 8TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(173, 270, 173, 90);     // 9TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(188, 270, 188, 90);     // 10TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(201, 270, 201, 90);     // 11TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(214, 270, 214, 90);     // 12TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(227, 270, 227, 90);     // 13TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(247, 10, 247, 350);     // 14TH VERTICAL LINE TOP TO BOTTOM
$pdf -> Line(134, 80, 134, 46);      // LEFT SIDE OF INVOICE NUMBER
//VERTICAL LINE ENDS |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

$pdf->SetFont('helvetica','B',10);
$pdf->Cell(0,6,'GST No: '.''."24ACZFS0363F1ZV",0,0,'L');
$pdf->Cell(-235 ,0,'',0,0);
$pdf->Cell(0,55,'PAN No. :'.'ACZFS0363F',0,0,'L');
$pdf->Cell(0,55,'CREDIT BILL',0,0,'R');
$pdf->Cell(-235 ,0,'',0,0);
$pdf->Cell(0,66,'Reverse Charge : No',0,0,'L');
$pdf->Cell(-227 ,0,'',0,0);
$pdf->Cell(0,66,'TAX INVOICE',0,0,'C');
$pdf->Cell(-50 ,0,'',0,0);
$pdf->Cell(52,66,'State Code :'.'24',0,0,'R');


//$pdf -> Line(10, 248, 247, 248);//LAST BOTTOM LINE (END OF PAGE)
//$pdf -> Line(10, 284, 247, 284);//LAST BOTTOM LINE (END OF PAGE)
//$pdf -> Line(10, 292, 247, 292);//LAST BOTTOM LINE (END OF PAGE)
//$pdf->Cell(-113 ,10,'',0,0);


$pdf->Cell(-15,6,'[   ]',0,0,'R');
$pdf->Cell(15,6,'Original ',0,0,'R');

$pdf->Cell(-15,15,'[   ]',0,0,'R');
$pdf->Cell(17,15,'Duplicate ',0,0,'R');

$pdf->Cell(-17,24,'[   ]',0,0,'R');
$pdf->Cell(17,24,'Triplicate ',0,0,'R');

$pdf->SetFont('helvetica','',24);
$mid_x = 127.5;
$company_name = "Swastik Sales Corporation";
$pdf->Text($mid_x - ($pdf->GetStringWidth($company_name) / 2), 17, $company_name);

$pdf->SetFont('helvetica','',10);
$address_one = "PLOT NO. 13-14, ROAD NO. 14, M.G ROAD, NEAR STATE BANK OF INDIA";
$pdf->Text($mid_x - ($pdf->GetStringWidth($address_one) / 2), 22, $address_one);

$address_two = "UDHNA UDHYOG NAGAR, SURAT-394210 GUJARAT";
$pdf->Text($mid_x - ($pdf->GetStringWidth($address_two) / 2), 27, $address_two);
$address_three = "P/M : 0261-2993634 9377811610 / 9825123634 Email : swastiksalescorp16@gmail.com";
$pdf->Text($mid_x - ($pdf->GetStringWidth($address_three) / 2), 32, $address_three);


$pdf->Cell(-239 ,20,'',0,0);
$pdf->SetFont('helvetica','B',11);
$pdf->Cell(100 ,80,'M/S '.'M/S AMIT TRADING COMPANY',0,0);
$pdf->SetFont('helvetica','',9);
$pdf->Cell(-100 ,20,'',0,0);

$pdf->Cell(25 ,88,'NO.10, PARSHVANATH ESTATE,',0,0);
$pdf->Cell(-25 ,20,'',0,0);
$pdf->Cell(25 ,96,'OPP. OM SHANTI & BRIGHT ENGLISH SCHOOL,',0,0);
$pdf->Cell(-25 ,20,'',0,0);
$pdf->Cell(25 ,104,'SURELIYA-REVABHAI ROAD, B/H CTM TEXTILE MILL,',0,0);
$pdf->Cell(-25 ,20,'',0,0);
$pdf->Cell(25 ,112,'AHMEDABAD 380021 GUJARAT',0,0);
$pdf->Cell(-25 ,20,'',0,0);
$pdf->Cell(25 ,120,'9408870888',0,0);
$pdf->Cell(-25 ,20,'',0,0);
$pdf->SetFont('helvetica','B',10);
$pdf->Cell(25 ,135,'GST No. :'.'24AFGPS4210M1ZE'.'    PAN No : '.'AFGPS4210M'. '   State Code: '.'24',0,0);

$pdf->Cell(100 ,20,'',0,0);
$pdf->Cell(230 ,80,'Invoice No.',0,0);
$pdf->Cell(-210 ,20,'',0,0);
$pdf->Cell(120 ,80,' : '. 'INV-1001',0,0);
$pdf->Cell(-85 ,20,'',0,0);
$pdf->Cell(120 ,80,'Invoice Date',0,0);
$pdf->Cell(-96 ,20,'',0,0);
$pdf->Cell(120 ,80,' :   ' . '28-04-2022',0,0);

$pdf->SetFont('helvetica','',10);
$pdf->Cell(-199 ,20,'',0,0);
$pdf->Cell(230 ,95,'P O No.',0,0);
$pdf->Cell(-210 ,20,'',0,0);
$pdf->Cell(120 ,95,' : '. 'PO NO-1001',0,0);
$pdf->Cell(-85 ,20,'',0,0);
$pdf->Cell(120 ,95,'PO Date',0,0);
$pdf->Cell(-96 ,20,'',0,0);
$pdf->Cell(120 ,95,' :   ' . '28-04-2022',0,0);

$pdf->Cell(-199 ,20,'',0,0);
$pdf->Cell(230 ,106,'Challan No.',0,0);
$pdf->Cell(-210 ,20,'',0,0);
$pdf->Cell(120 ,106,' : '. 'CH-1001',0,0);
$pdf->Cell(-85 ,20,'',0,0);
$pdf->Cell(120 ,106,'Challan Date',0,0);
$pdf->Cell(-96 ,20,'',0,0);
$pdf->Cell(120 ,106,' :   ' . '28-04-2022',0,0);

$pdf->Cell(-199 ,20,'',0,0);
$pdf->Cell(230 ,117,'Due Days.',0,0);
$pdf->Cell(-210 ,20,'',0,0);
$pdf->Cell(120 ,117,' : '. '30',0,0);
$pdf->Cell(-85 ,20,'',0,0);
$pdf->Cell(120 ,117,'Due Date',0,0);
$pdf->Cell(-96 ,20,'',0,0);
$pdf->Cell(120 ,117,' :   ' . '28-05-2022',0,0);

$pdf->Cell(-199 ,20,'',0,0);
$pdf->Cell(230 ,128,'Transport',0,0);
$pdf->Cell(-210 ,20,'',0,0);
$pdf->Cell(120 ,128,' : '. 'POOJA TPT',0,0);
$pdf->Cell(-85 ,20,'',0,0);
$pdf->Cell(120 ,128,'Acc. Balance',0,0);
$pdf->Cell(-96 ,20,'',0,0);
$pdf->Cell(120 ,128,' :   ' . '123456.00',0,0);

$pdf->Cell(-324 ,20,'',0,0);
$pdf->Cell(25 ,148,'Remarks : '.'POOJA TRANSPORT',0,0);

$pdf->Cell(100 ,20,'',0,0);
$pdf->Cell(25 ,148,'LR NO.',0,0);
$pdf->Cell(-5 ,20,'',0,0);
$pdf->Cell(150 ,148,' : ' . '345001234567',0,0);

$pdf->Cell(-115 ,20,'',0,0);
$pdf->Cell(25 ,148,'Parcel/Cases',0,0);
$pdf->Cell(-1 ,20,'',0,0);
$pdf->Cell(120 ,148,' :   ' . '25 NOS',0,0);


/*
$pdf->Cell(71 ,10,'',0,0);
$pdf->Cell(59 ,10,'Invoice',0,0);
$pdf->Cell(59 ,10,'',0,1);

$pdf->SetFont('Arial','B',15);
$pdf->Cell(71 ,5,'WET',0,0);
$pdf->Cell(59 ,5,'',0,0);
$pdf->Cell(59 ,5,'Details',0,1);

$pdf->SetFont('Arial','',10);

$pdf->Cell(130 ,5,'Near DAV',0,0);
$pdf->Cell(25 ,5,'Customer ID:',0,0);
$pdf->Cell(34 ,5,'0012',0,1);

$pdf->Cell(130 ,5,'Delhi, 751001',0,0);
$pdf->Cell(25 ,5,'Invoice Date:',0,0);
$pdf->Cell(34 ,5,'12th Jan 2019',0,1);
 
$pdf->Cell(130 ,5,'',0,0);
$pdf->Cell(25 ,5,'Invoice No:',0,0);
$pdf->Cell(34 ,5,'ORD001',0,1);


$pdf->SetFont('Arial','B',15);
$pdf->Cell(130 ,5,'Bill To',0,0);
$pdf->Cell(59 ,5,'',0,0);
$pdf->SetFont('Arial','B',10);
$pdf->Cell(189 ,10,'',0,1);
*/


//$pdf->Cell(50 ,10,'',0,1);

$pdf->SetFont('Arial','B',10);
/*Heading Of the table*/
//$pdf->Cell(10 ,6,'Sl',1,0,'C');
//$pdf->Cell(100 ,6,'Description',1,0,'C');
//$pdf->Cell(23 ,6,'Qty',1,0,'C');
//$pdf->Cell(30 ,6,'Unit Price',1,0,'C');
//$pdf->Cell(20 ,6,'Sales Tax',1,0,'C');
//$pdf->Cell(25 ,6,'Total',1,1,'C');/*end of line*/
/*Heading Of the table end*/

$height = 150;
$pdf->Cell(0 ,77,'',0,1);
$pdf->SetFont('Arial','B',9);
$pdf->Cell(10 ,5,'Sl',1,0,'C');
$pdf->Cell(26 ,5,'Part Number',1,0,'L');
$pdf->Cell(60 ,5,'Description',1,0,'L');
$pdf->Cell(14 ,5,'HSN',1,0,'C');
$pdf->Cell(14 ,5,'Qty',1,0,'R');
$pdf->Cell(15 ,5,'Price',1,0,'R');
$pdf->Cell(12 ,5,'Disc%',1,0,'R');
$pdf->Cell(12 ,5,'Rate',1,0,'R');
$pdf->Cell(15 ,5,'Taxable',1,0,'C');
$pdf->Cell(13 ,5,'SGST%',1,0,'C');
$pdf->Cell(13 ,5,'CGST%',1,0,'C');
$pdf->Cell(13 ,5,'IGST%',1,0,'C');
$pdf->Cell(20 ,5,'Total',1,1,'R');/*end of line*/
/*Heading Of the table end*/

$query=mysqli_query($connect,"Select * from invprt_mst where inv_number = '".'B2B- 2  (22-23)'."'");
$num_rows = mysqli_num_rows($query);
$rcount = $num_rows; // number of rows in inv_mst

$i = 1;
//if($rcount <= 300){
$pdf->SetFont('Arial','',9);
$query=mysqli_query($connect,"Select * from invprt_mst where inv_number = '".'B2B- 2  (22-23)'."'");
	while($row=mysqli_fetch_array($query)){
		
		$rcount = $rcount + 1;
		$height = $height -5;
		$pdf->Cell(10 ,5,$i,0,0,'C');
		$i = $i + 1;
		$pdf->Cell(26 ,5,$row["partno"],0,0);
		$pdf->Cell(59 ,5,$row["description_one"],0,0);
		$pdf->SetFont('Arial','',8);
		$pdf->Cell(16 ,5,$row["hsn_code"],0,0,'C');
		$pdf->SetFont('Arial','',9);
		$pdf->Cell(13 ,5,$row["qty"],0,0,'R');
		$pdf->Cell(15 ,5,number_format($row["list"],2, '.', ''),0,0,'R');
		$pdf->Cell(12 ,5,number_format($row["disc_per"],2, '.', ''),0,0,'R');
		$pdf->Cell(12 ,5,number_format($row["rate_one"],2, '.', ''),0,0,'R');
		$pdf->Cell(15 ,5,number_format($row["sales_val"],2, '.', ''),0,0,'R');
		$pdf->Cell(13 ,5,number_format($row["sgst_per"],2, '.', ''),0,0,'R');
		$pdf->Cell(13 ,5,number_format($row["cgst_per"],2, '.', ''),0,0,'R');
		$pdf->Cell(13 ,5,number_format($row["igst_per"],2, '.', ''),0,0,'R');
		$pdf->Cell(20 ,5,number_format($row["inv_val"],2, '.', ''),0,1,'R');
	}
	for ($i = 30; $i <= 31; $i++) {
		//$pdf->AddPage();
	}
//}



$pdf->Output();

?>