$(document).ready(function(){
	
	$(document).keydown(function(objEvent) {
		if (objEvent.keyCode == 9) {  //tab pressed
			objEvent.preventDefault(); // stops its action
		}
	})	
	load_data();
	function load_data(query)
	{
		$.ajax({
			url:"search",
			method:"post",
			data:{query:query},
			success:function(data)
			{
				$('#result').html(data);
				document.getElementById('customer_code').value = "";
				document.getElementById('customer_name').value = "";
				document.getElementById('cust_place').value = "";
				document.getElementById('segment').value = "";
				document.getElementById('disc_per').value = "";
				$('#search_text').focus();
			}
		});
	}	
	$('#search_text').keyup(function(){
		var search = $(this).val();
		if(search != '')
		{
			load_data(search);
		}
		else
		{
			load_data();			
		}
	});	
	$('#action').click(function() {
		var customer_code = $('#customer_code').val();
		var customer_name = $('#customer_name').val();
		var cust_place = $('#cust_place').val();
		var segment = $('#segment').val();
		var disc_per = $('#disc_per').val();		
		var id = $('#user_id').val();
		var action = $('#action').text();
		$actiontext = $('#action').text();
		if (customer_code != '' && customer_name != '' && cust_place != '' && segment != '' && disc_per != ''){
			$.ajax({
				url: "action",
				method: "POST",
				data: {
					customer_code: customer_code,
					customer_name: customer_name,
					cust_place: cust_place,
					segment: segment,
					disc_per: disc_per,					
					id: id,
					action: action
				},
				success: function(data) {
					$('.success').show(1000).html("Record Saved Successfully.").delay(1000).fadeOut(1000);
					load_data();
				}
			});
		} else {
			$('.success').show(1000).html("All Fields are Required").delay(1000).fadeOut(1000);
		}
	});

	$(document).on('click', '.update', function() {
		var id = $(this).attr("id");
		$.ajax({
			url: "fetch",
			method: "POST",
			data: {
				id: id
			},
			dataType: "json",
			success: function(data) {
				$('#action').text("Update");
				$('#user_id').val(id);
				$('#customer_code').val(data.customer_code);
				$('#customer_name').val(data.customer_name);					
				$('#cust_place').val(data.cust_place);
				$('#segment').val(data.segment);
				$('#disc_per').val(data.disc_per);
				$('#disc_per').focus();
			}
		})
	});		
	//To check the input is not empty and send the cursor to next input.
	$(document).ready(function() {
		$('input').on('keypress', function(e) {
			if (e.which == 13) {
				switch ($(this).attr('id')) {
					case 'disc_per':
					if (!document.getElementById("disc_per").value.length == 0) {
						$('#action').focus();
						e.preventDefault();
						break;
					}																																				
				}
			}
		});
	});
});

function myFunction() {
  var str = document.getElementById("search_text").innerHTML; 
  var res = str.replace("*", "%");
  document.getElementById("demo").innerHTML = res;
}
	function exportToExcel(tableID, filename = '') {
		var downloadurl;
		var dataFileType = 'application/vnd.ms-excel';
		var tableSelect = document.getElementById(tableID);
		var tableHTMLData = tableSelect.outerHTML.replace(/ /g, '%20');

		// Specify file name
		filename = filename ? filename + '.xls' : 'export_excel_data.xls';

		// Create download link element
		downloadurl = document.createElement("a");

		document.body.appendChild(downloadurl);

		if (navigator.msSaveOrOpenBlob) {
			var blob = new Blob(['\ufeff', tableHTMLData], {
				type: dataFileType
			});
			navigator.msSaveOrOpenBlob(blob, filename);
		} else {
			// Create a link to the file
			downloadurl.href = 'data:' + dataFileType + ', ' + tableHTMLData;

			// Setting the file name
			downloadurl.download = filename;

			//triggering the function
			downloadurl.click();
		}
	}