<?php
//SHOW A DATABASE ON A PDF FILE
//CREATED BY: Carlos Vasquez S.
//E-MAIL: cvasquez@cvs.cl
//CVS TECNOLOGIA E INNOVACION
//SANTIAGO, CHILE

require('pdf/fpdf.php');
//Connect to your database
require('../config/dbcon.php');
//Select the Products you want to show in your PDF file

$result=mysqli_query($connect,"select partno,description_one,list from item_mst order by partno");
//$result=mysqli_query($connect,"select partno,description_one,list from item_mst order by partno");
//$number_of_products = mysqli_numrows($result);

//Initialize the 3 columns and the total
$column_partno = "";
$column_description_one = "";
$column_list = "";
$total = 0;

//For each row, add the field to the corresponding column
while($row = mysqli_fetch_array($result))
{
	$partno = $row["partno"];
	$description_one = substr($row["description_one"],0,20);
	$real_list = $row["list"];
	$list_to_show = $row["list"];

	$column_partno = $column_partno.$partno."\n";
	$column_description_one = $column_description_one.$description_one."\n";
	$column_list = $column_list.$list_to_show."\n";

	//Sum all the lists (TOTAL)
	$total = $total+$real_list;
}
//mysqli_close();

//Convert the Total list to a number with (.) for thousands, and (,) for decimals.
$total = $total;

//Create a new PDF file
//$pdf=new FPDF();
$pdf = new FPDF('P','mm',array(360,250));
$pdf->AddPage();

//Fields description_one position
$Y_Fields_description_one_position = 0;
//Table position, under Fields description_one
$Y_Table_Position = 26;

//First create each Field description_one
//Gray color filling each Field description_one box
$pdf->SetFillColor(232,232,232);
//Bold Font for Field description_one
$pdf->SetFont('Arial','B',12);
$pdf->Cell(50 ,5,'partno',1,0,'C');
$pdf->Cell(120 ,5,'Description',1,0,'L');
$pdf->Cell(50 ,5,'List',1,0,'L');
$pdf->Ln();

//Now show the 3 columns
$pdf->SetFont('Arial','',12);
$pdf->SetY($Y_Table_Position);
$pdf->SetX(45);
$pdf->MultiCell(10,6,$column_partno,1);
$pdf->SetY($Y_Table_Position);
$pdf->SetX(65);
$pdf->MultiCell(100,6,$column_description_one,1);
$pdf->SetY($Y_Table_Position);
$pdf->SetX(135);
$pdf->MultiCell(30,6,$column_list,1,'R');
$pdf->SetX(135);
$pdf->MultiCell(30,6,'$ '.$total,1,'R');

//Create lines (boxes) for each ROW (Product)
//If you don't use the following partno, you don't create the lines separating each row
$i = 0;
$pdf->SetY($Y_Table_Position);
while ($i < 1000)
{
	$pdf->SetX(45);
	$pdf->MultiCell(120,6,'',1);
	$i = $i +1;
}

$pdf->Output();
?>
